/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.wado;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.AbstractExporter;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.keycloak.AccessTokenRequestor;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.dcm4chee.arc.storage.WriteContext;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WadoExporter
extends AbstractExporter {
    private static final Logger LOG = LoggerFactory.getLogger(WadoExporter.class);
    private static final int COPY_BUFFER_SIZE = 8192;
    private final QueryService queryService;
    private final StorageFactory storageFactory;
    private final AccessTokenRequestor accessTokenRequestor;
    private final Device device;
    private final IWebApplicationCache webApplicationCache;
    private final EnumMap<Entity, List<QueryRetrieveRequest>> queryRetrieveRequests = new EnumMap(Entity.class);
    private final boolean ignoreNotFound;
    private WebApplication queryRetrieveWebApp;

    public WadoExporter(ExporterDescriptor descriptor, QueryService queryService, StorageFactory storageFactory, Device device, AccessTokenRequestor accessTokenRequestor, IWebApplicationCache webApplicationCache) {
        super(descriptor);
        this.queryService = queryService;
        this.storageFactory = storageFactory;
        this.accessTokenRequestor = accessTokenRequestor;
        this.device = device;
        this.webApplicationCache = webApplicationCache;
        this.ignoreNotFound = Boolean.parseBoolean((String)descriptor.getProperties().get("IgnoreNotFound"));
        this.addQueryRetrieveRequest();
    }

    private String token() {
        if (this.queryRetrieveWebApp.getKeycloakClient() == null) {
            return null;
        }
        String token = null;
        try {
            token = this.accessTokenRequestor.getAccessToken2(this.queryRetrieveWebApp).getToken();
            LOG.debug("Access token retrieved for Web Application[name={}, {}] is {}", new Object[]{this.queryRetrieveWebApp.getApplicationName(), this.queryRetrieveWebApp.getKeycloakClient(), token});
        }
        catch (Exception e) {
            LOG.info("Failed to get access token for Web Application[name={}, KeycloakClientID={}] \n", new Object[]{this.queryRetrieveWebApp.getApplicationName(), this.queryRetrieveWebApp.getKeycloakClient(), e});
        }
        return token;
    }

    private void addQueryRetrieveRequest() {
        String uriSchemeSpecificPart = this.descriptor.getExportURI().getSchemeSpecificPart();
        String queryRetrieveService = null;
        try {
            this.queryRetrieveWebApp = this.webApplicationCache.findWebApplication(uriSchemeSpecificPart);
            if (this.descriptor.getProperties().containsKey("WadoService")) {
                if (!this.queryRetrieveWebApp.containsServiceClass(WebApplication.ServiceClass.WADO_URI) && !this.queryRetrieveWebApp.containsServiceClass(WebApplication.ServiceClass.WADO_RS)) {
                    LOG.info("{} web application does not contain any WADO service classes", (Object)this.queryRetrieveWebApp);
                    return;
                }
                queryRetrieveService = (String)this.descriptor.getProperties().get("WadoService");
            } else if (this.descriptor.getProperties().containsKey("QidoService")) {
                if (!this.queryRetrieveWebApp.containsServiceClass(WebApplication.ServiceClass.QIDO_RS)) {
                    LOG.info("{} web application does not contain any QIDO service classes", (Object)this.queryRetrieveWebApp);
                    return;
                }
                queryRetrieveService = (String)this.descriptor.getProperties().get("QidoService");
            }
            if (queryRetrieveService == null) {
                LOG.info("{} web application does not contain WADO / QIDO service to be invoked", (Object)this.queryRetrieveWebApp);
                return;
            }
            String targetURI = this.queryRetrieveWebApp.getServiceURL() + queryRetrieveService;
            MessageFormat format = new MessageFormat(targetURI.replace('[', '{').replace(']', '}'));
            Entity entity = Entity.values()[format.getFormats().length];
            List list = this.queryRetrieveRequests.computeIfAbsent(entity, k -> new ArrayList(2));
            list.add(new QueryRetrieveRequest(format, this.token(), this.device, this.descriptor, this.queryRetrieveWebApp));
        }
        catch (ConfigurationException e) {
            LOG.info("Failed to find Web Application for request invocation for {} : {}", (Object)uriSchemeSpecificPart, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outcome export(ExportContext exportContext) throws Exception {
        byte[] buffer = new byte[8192];
        int count = 0;
        int failed = 0;
        Throwable ex = null;
        HashMap<String, Storage> storageMap = new HashMap<String, Storage>();
        try {
            for (Map.Entry<Entity, List<QueryRetrieveRequest>> entry : this.queryRetrieveRequests.entrySet()) {
                for (Object[] params : entry.getKey().queryParams(exportContext, this.queryService)) {
                    for (QueryRetrieveRequest queryRetrieveRequest : entry.getValue()) {
                        try {
                            if (!this.invoke(queryRetrieveRequest, params, buffer, storageMap)) continue;
                            ++count;
                        }
                        catch (Exception e) {
                            ++failed;
                            ex = e;
                        }
                    }
                }
            }
        }
        finally {
            for (Storage storage : storageMap.values()) {
                SafeClose.close((Closeable)storage);
            }
        }
        String exporterID = exportContext.getExporter().getExporterDescriptor().getExporterID();
        if (failed == 0) {
            return new Outcome(Task.Status.COMPLETED, "Query retrieved " + count + " objects by Exporter " + exporterID);
        }
        if (count > 0) {
            return new Outcome(Task.Status.WARNING, "Query retrieved " + count + " objects by Exporter " + exporterID + ", failed: " + failed + " - " + ex.getMessage());
        }
        throw ex;
    }

    private boolean invoke(QueryRetrieveRequest queryRetrieveRequest, Object[] params, byte[] buffer, Map<String, Storage> storageMap) throws Exception {
        Invocation.Builder request = queryRetrieveRequest.openConnection(params, this.accessTokenRequestor);
        try (Response response = request.get();){
            Response.StatusType statusInfo = response.getStatusInfo();
            if (statusInfo.getFamily() != Response.Status.Family.SUCCESSFUL) {
                LOG.info("Invocation of request {} failed with status {} {}", new Object[]{queryRetrieveRequest.getTargetURL(), statusInfo.getStatusCode(), statusInfo.getReasonPhrase()});
                if (this.ignoreNotFound && (response.getStatus() == 404 || response.getStatus() == 410)) {
                    boolean bl = false;
                    return bl;
                }
                throw new IOException("HTTP " + statusInfo.getStatusCode() + " " + statusInfo.getReasonPhrase());
            }
            try (InputStream in = (InputStream)response.readEntity(InputStream.class);
                 OutputStream out = this.getOutputStream(queryRetrieveRequest.storageDescriptor, params, storageMap);){
                StreamUtils.copy((InputStream)in, (OutputStream)out, (byte[])buffer);
            }
        }
        return true;
    }

    private OutputStream getOutputStream(StorageDescriptor storageDescriptor, Object[] params, Map<String, Storage> storageMap) throws IOException {
        if (storageDescriptor == null) {
            return null;
        }
        Storage storage = storageMap.get(storageDescriptor.getStorageID());
        if (storage == null) {
            storage = this.storageFactory.getStorage(storageDescriptor);
            storageMap.put(storageDescriptor.getStorageID(), storage);
        }
        Attributes attrs = new Attributes(params.length);
        switch (params.length) {
            case 4: {
                attrs.setInt(528736, VR.IS, new int[]{(Integer)params[3]});
            }
            case 3: {
                attrs.setString(524312, VR.UI, (String)params[2]);
            }
            case 2: {
                attrs.setString(0x20000E, VR.UI, (String)params[1]);
            }
            case 1: {
                attrs.setString(0x20000D, VR.UI, (String)params[0]);
            }
        }
        WriteContext ctx = storage.createWriteContext(attrs);
        return storage.openOutputStream(ctx);
    }

    private static class QueryRetrieveRequest {
        final MessageFormat format;
        final EnumMap<HeaderField, String> headerFields;
        final StorageDescriptor storageDescriptor;
        final String token;
        final boolean tlsAllowAnyHostname;
        final boolean tlsDisableTrustManager;
        final ExporterDescriptor exporterDescriptor;
        final WebApplication queryRetrieveWebApp;
        final Device device;
        String targetURL;

        QueryRetrieveRequest(MessageFormat format, String token, Device device, ExporterDescriptor exporterDescriptor, WebApplication queryRetrieveWebApp) {
            this.format = format;
            this.exporterDescriptor = exporterDescriptor;
            this.queryRetrieveWebApp = queryRetrieveWebApp;
            this.device = device;
            this.storageDescriptor = this.toStorageDescriptor();
            this.headerFields = this.toHeaderFields();
            this.token = token;
            this.tlsAllowAnyHostname = this.setTLSFields("allow-any-hostname");
            this.tlsDisableTrustManager = this.setTLSFields("disable-trust-manager");
        }

        private boolean setTLSFields(String key) {
            return Boolean.parseBoolean(this.queryRetrieveWebApp.getProperty(key, null));
        }

        private StorageDescriptor toStorageDescriptor() {
            String storageID = this.exporterDescriptor.getProperty("StorageID", null);
            if (storageID == null) {
                return null;
            }
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
            StorageDescriptor storageDescriptor = arcDev.getStorageDescriptor(storageID);
            if (storageDescriptor == null) {
                LOG.warn("Exporter {} refers not configured StorageID={} - cannot store fetched objects", (Object)this.exporterDescriptor.getExporterID(), (Object)storageID);
            }
            return storageDescriptor;
        }

        private EnumMap<HeaderField, String> toHeaderFields() {
            EnumMap<HeaderField, String> headerFields = new EnumMap<HeaderField, String>(HeaderField.class);
            for (HeaderField headerField : HeaderField.values()) {
                String value = this.exporterDescriptor.getProperty(headerField.toString(), null);
                if (value == null) continue;
                headerFields.put(headerField, value);
            }
            return headerFields;
        }

        String getTargetURL() {
            return this.targetURL;
        }

        Invocation.Builder openConnection(Object[] params, AccessTokenRequestor accessTokenRequestor) throws Exception {
            this.targetURL = this.format.format(params);
            ResteasyClient client = accessTokenRequestor.resteasyClientBuilder(this.targetURL, this.tlsAllowAnyHostname, this.tlsDisableTrustManager).build();
            ResteasyWebTarget target = client.target(this.targetURL);
            Invocation.Builder request = target.request();
            this.headerFields.forEach((k, v) -> request.header(k.toString(), v));
            if (this.token != null) {
                request.header("Authorization", (Object)("Bearer " + this.token));
            }
            return request;
        }

        private static enum HeaderField {
            Accept,
            Accept_Encoding,
            Cache_Control;


            public String toString() {
                return this.name().replace('_', '-');
            }
        }
    }

    private static enum Entity {
        CONST{

            @Override
            List<Object[]> queryParams(ExportContext ctx, QueryService queryService) {
                return Collections.singletonList(new Object[0]);
            }
        }
        ,
        STUDY{

            @Override
            List<Object[]> queryParams(ExportContext ctx, QueryService queryService) {
                return Collections.singletonList(new Object[]{ctx.getStudyInstanceUID()});
            }
        }
        ,
        SERIES{

            @Override
            List<Object[]> queryParams(ExportContext ctx, QueryService queryService) {
                return ctx.getSeriesInstanceUID() == null ? queryService.getSeriesInstanceUIDs(ctx.getStudyInstanceUID()) : Collections.singletonList(new Object[]{ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID()});
            }
        }
        ,
        INSTANCE{

            @Override
            List<Object[]> queryParams(ExportContext ctx, QueryService queryService) {
                return ctx.getSeriesInstanceUID() == null ? queryService.getSOPInstanceUIDs(ctx.getStudyInstanceUID()) : (ctx.getSopInstanceUID() == null ? queryService.getSOPInstanceUIDs(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID()) : Collections.singletonList(new Object[]{ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), queryService.getNumberOfFrames(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID())}));
            }
        }
        ,
        FRAME{

            @Override
            List<Object[]> queryParams(ExportContext ctx, QueryService queryService) {
                List<Object[]> insts = INSTANCE.queryParams(ctx, queryService);
                ArrayList<Object[]> frames = new ArrayList<Object[]>(insts.size());
                for (Object[] inst : insts) {
                    Integer numFrames = (Integer)inst[3];
                    int n = numFrames != null ? numFrames : 1;
                    for (int i = 1; i <= n; ++i) {
                        Object[] frame = (Object[])inst.clone();
                        frame[3] = i;
                        frames.add(frame);
                    }
                }
                return frames;
            }
        };


        abstract List<Object[]> queryParams(ExportContext var1, QueryService var2);
    }
}

