/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.dicom;

import java.util.Map;
import java.util.Objects;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.AbstractExporter;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.retrieve.SeriesInfo;
import org.dcm4chee.arc.store.scu.CStoreSCU;

public class DicomExporter
extends AbstractExporter {
    private final RetrieveService retrieveService;
    private final CStoreSCU storeSCU;
    private final String destAET;
    private final Map<Long, RetrieveTask> retrieveTaskMap;

    protected DicomExporter(ExporterDescriptor descriptor, RetrieveService retrieveService, CStoreSCU storeSCU, Map<Long, RetrieveTask> retrieveTaskMap) {
        super(descriptor);
        this.retrieveService = retrieveService;
        this.storeSCU = storeSCU;
        this.destAET = descriptor.getExportURI().getSchemeSpecificPart();
        this.retrieveTaskMap = retrieveTaskMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outcome export(ExportContext exportContext) throws Exception {
        RetrieveContext retrieveContext = this.retrieveService.newRetrieveContextSTORE(exportContext.getAETitle(), exportContext.getStudyInstanceUID(), exportContext.getSeriesInstanceUID(), exportContext.getSopInstanceUID(), this.destAET);
        retrieveContext.setHttpServletRequestInfo(exportContext.getHttpServletRequestInfo());
        if (!this.retrieveService.calculateMatches(retrieveContext)) {
            return new Outcome(Task.Status.WARNING, DicomExporter.noMatches((ExportContext)exportContext));
        }
        if (!this.retrieveService.restrictRetrieveAccordingTransferCapabilities(retrieveContext)) {
            return new Outcome(retrieveContext.failed() > 0 ? Task.Status.WARNING : Task.Status.COMPLETED, DicomExporter.outcomeMessage((ExportContext)exportContext, (RetrieveContext)retrieveContext, (Object)this.destAET));
        }
        if (this.descriptor.isExportAsSourceAE()) {
            retrieveContext.getSeriesInfos().stream().map(SeriesInfo::getSendingAET).filter(Objects::nonNull).findFirst().ifPresent(arg_0 -> ((RetrieveContext)retrieveContext).setCallingAET(arg_0));
        }
        Long taskPk = exportContext.getTaskPK();
        RetrieveTask retrieveTask = this.storeSCU.newRetrieveTaskSTORE(retrieveContext);
        this.retrieveTaskMap.put(taskPk, retrieveTask);
        try {
            retrieveTask.run();
            Outcome outcome = new Outcome(retrieveContext.remaining() > 0 ? Task.Status.CANCELED : (retrieveContext.failed() > 0 ? (retrieveContext.missing() > 0 ? Task.Status.FAILED : Task.Status.WARNING) : Task.Status.COMPLETED), DicomExporter.outcomeMessage((ExportContext)exportContext, (RetrieveContext)retrieveContext, (Object)this.destAET));
            return outcome;
        }
        finally {
            this.retrieveTaskMap.remove(taskPk);
        }
    }
}

