/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.dcm2hl7;

import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.AbstractExporter;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.hl7.HL7Sender;
import org.dcm4chee.arc.hl7.HL7SenderUtils;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;

public class Dcm2Hl7Exporter
extends AbstractExporter {
    private final HL7Sender hl7Sender;
    private final Device device;
    private final RetrieveService retrieveService;
    private final IHL7ApplicationCache hl7AppCache;

    public Dcm2Hl7Exporter(ExporterDescriptor descriptor, HL7Sender hl7Sender, Device device, RetrieveService retrieveService, IHL7ApplicationCache hl7AppCache) {
        super(descriptor);
        this.hl7Sender = hl7Sender;
        this.device = device;
        this.retrieveService = retrieveService;
        this.hl7AppCache = hl7AppCache;
    }

    public Outcome export(ExportContext exportContext) throws Exception {
        HL7Application receiver;
        String[][] sendingAndReceiving = Dcm2Hl7Exporter.parseSendingAndReceivingApplicationAndFacility(this.descriptor.getExportURI().getSchemeSpecificPart());
        if (sendingAndReceiving == null) {
            return new Outcome(Task.Status.WARNING, "Export URI: " + this.descriptor.getExportURI() + " not in format: hl7:{Sending Application}/{Sending Facility}:{Receiving Application}/{Receiving Facility}");
        }
        String sendingAppFacility = sendingAndReceiving[0][0] + "|" + sendingAndReceiving[0][1];
        HL7Application sender = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(sendingAppFacility, true);
        if (sender == null) {
            return new Outcome(Task.Status.WARNING, "Sending HL7 Application not configured : " + sendingAppFacility);
        }
        String receivingAppFacility = sendingAndReceiving[1][0] + "|" + sendingAndReceiving[1][1];
        try {
            receiver = this.hl7AppCache.findHL7Application(receivingAppFacility);
        }
        catch (ConfigurationException e) {
            return new Outcome(Task.Status.WARNING, "Unknown Receiving HL7 Application : " + receivingAppFacility);
        }
        return this.scheduleMessage(exportContext, sender, receiver);
    }

    private static String[][] parseSendingAndReceivingApplicationAndFacility(String schemeSpecificPart) {
        String[][] result;
        String[] ss = StringUtils.split((String)schemeSpecificPart, (char)':');
        if (ss.length == 2 && (result = new String[][]{StringUtils.split((String)ss[0], (char)'/'), StringUtils.split((String)ss[1], (char)'/')})[0].length == 2 && result[1].length == 2) {
            return result;
        }
        return null;
    }

    private Outcome scheduleMessage(ExportContext exportContext, HL7Application sender, HL7Application receiver) throws Exception {
        String xslStylesheetURI = (String)this.descriptor.getProperties().get("XSLStylesheetURI");
        if (xslStylesheetURI == null) {
            return new Outcome(Task.Status.WARNING, "Missing XSL stylesheet to convert DICOM attributes to HL7 message");
        }
        String msgType = (String)this.descriptor.getProperties().get("MessageType");
        if (msgType == null) {
            return new Outcome(Task.Status.WARNING, "Missing HL7 message type");
        }
        RetrieveContext ctx = this.retrieveService.newRetrieveContext(exportContext.getAETitle(), exportContext.getStudyInstanceUID(), exportContext.getSeriesInstanceUID(), exportContext.getSopInstanceUID());
        ctx.setHttpServletRequestInfo(exportContext.getHttpServletRequestInfo());
        if (!this.retrieveService.calculateMatches(ctx)) {
            return new Outcome(Task.Status.WARNING, Dcm2Hl7Exporter.noMatches((ExportContext)exportContext));
        }
        ArchiveHL7Message hl7Msg = this.hl7Message(sender, receiver, ctx, msgType, xslStylesheetURI);
        HL7Message hl7MsgRsp = this.parseRsp(this.hl7Sender.sendMessage(sender, receiver, (UnparsedHL7Message)hl7Msg));
        return new Outcome(this.statusOf(hl7MsgRsp), hl7MsgRsp.toString());
    }

    private Task.Status statusOf(HL7Message hl7MsgRsp) {
        return hl7MsgRsp.getSegment("MSA").getField(1, "AA").equals("AA") ? Task.Status.COMPLETED : Task.Status.FAILED;
    }

    private HL7Message parseRsp(UnparsedHL7Message hl7MsgRsp) {
        HL7Segment msh = hl7MsgRsp.msh();
        String charset = msh.getField(17, "ASCII");
        return HL7Message.parse((byte[])hl7MsgRsp.unescapeXdddd(), (String)charset);
    }

    private ArchiveHL7Message hl7Message(HL7Application sender, HL7Application receiver, RetrieveContext ctx, String msgType, String uri) throws Exception {
        byte[] data = HL7SenderUtils.data((HL7Application)sender, (HL7Application)receiver, (Attributes)((InstanceLocations)ctx.getMatches().get(0)).getAttributes(), null, (String)msgType, (String)uri, null, null);
        ArchiveHL7Message hl7Msg = new ArchiveHL7Message(data);
        hl7Msg.setHttpServletRequestInfo(ctx.getHttpServletRequestInfo());
        return hl7Msg;
    }
}

