/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.curve2pr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.AbstractExporter;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;

public class Curve2PRExporter
extends AbstractExporter {
    private static final ElementDictionary dict = ElementDictionary.getStandardElementDictionary();
    private static final int[] TOP_LEFT = new int[]{1, 1};
    private static final int[] VOI_LUT_TAGS = new int[]{2625616, 2625617, 2625621, 2625622, 2633744};
    private static final int[] MOD_LUT_TAGS = new int[]{2625618, 2625619, 2625620, 2633728};
    private static final String GraphicLayer = "GraphicLayer";
    private static final String GraphicLayerOrder = "GraphicLayerOrder";
    private static final String GraphicLayerRecommendedDisplayGrayscaleValue = "GraphicLayerRecommendedDisplayGrayscaleValue";
    private static final String[] DEF_PROPS = new String[]{"GraphicLayer", "CURVEDATA", "GraphicLayerOrder", "1", "GraphicLayerRecommendedDisplayGrayscaleValue", "65535", "PR.Manufacturer", "", "PR.ContentCreatorName", "", "PR.SeriesDescription", "{0008103E}", "PR.SeriesNumber", "{00200011,offset,100}", "PR.ContentLabel", "CURVEDATA", "PR.ContentDescription", "Created from Curve Data in Image(s)"};
    private final RetrieveService retrieveService;
    private final StoreService storeService;
    private final int[] patStudyTags;
    private final Map<String, String> properties = new HashMap<String, String>();

    Curve2PRExporter(ExporterDescriptor descriptor, RetrieveService retrieveService, StoreService storeService) {
        super(descriptor);
        this.retrieveService = retrieveService;
        this.storeService = storeService;
        this.patStudyTags = this.patStudyTags(retrieveService.getArchiveDeviceExtension());
        for (int i = 1; i < DEF_PROPS.length; ++i) {
            this.properties.put(DEF_PROPS[i - 1], DEF_PROPS[i]);
            ++i;
        }
        descriptor.getProperties().forEach(this.properties::put);
    }

    private int[] patStudyTags(ArchiveDeviceExtension arcdev) {
        int[] patTags = arcdev.getAttributeFilter(Entity.Patient).getSelection(false);
        int[] studyTags = arcdev.getAttributeFilter(Entity.Study).getSelection(false);
        int[] dst = new int[patTags.length + studyTags.length - 1 + MOD_LUT_TAGS.length];
        System.arraycopy(patTags, 0, dst, 0, patTags.length);
        System.arraycopy(studyTags, 1, dst, patTags.length, studyTags.length - 1);
        System.arraycopy(MOD_LUT_TAGS, 0, dst, dst.length - MOD_LUT_TAGS.length, MOD_LUT_TAGS.length);
        Arrays.sort(dst);
        return dst;
    }

    public Outcome export(ExportContext ctx) throws Exception {
        ApplicationEntity ae;
        ArrayList<Attributes> results = new ArrayList<Attributes>();
        try (RetrieveContext retrieveContext = this.retrieveService.newRetrieveContext(ctx.getAETitle(), ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID());){
            ae = retrieveContext.getLocalApplicationEntity();
            retrieveContext.setHttpServletRequestInfo(ctx.getHttpServletRequestInfo());
            if (!this.retrieveService.calculateMatches(retrieveContext)) {
                Outcome outcome = new Outcome(Task.Status.WARNING, Curve2PRExporter.noMatches((ExportContext)ctx));
                return outcome;
            }
            for (InstanceLocations instanceLocations : retrieveContext.getMatches()) {
                if (!this.isImage(instanceLocations)) continue;
                this.curve2pr(retrieveContext, instanceLocations, results);
            }
        }
        if (results.isEmpty()) {
            return new Outcome(Task.Status.COMPLETED, Curve2PRExporter.noPresentationStateCreated(ctx));
        }
        int totInstanceRefs = 0;
        try (StoreSession session = this.storeService.newStoreSession(ctx.getHttpServletRequestInfo(), ae, ctx.getAETitle(), this.properties.get("SourceAET"));){
            for (Attributes pr : results) {
                int instanceRefs = this.countInstanceRefs(pr);
                totInstanceRefs += instanceRefs;
                Curve2PRExporter.trimSoftcopyVOILUT(pr, instanceRefs);
                Curve2PRExporter.trimDisplayAreaSelection(pr);
                StoreContext storeCtx = this.storeService.newStoreContext(session);
                storeCtx.setReceiveTransferSyntax("1.2.840.10008.1.2.1");
                this.storeService.store(storeCtx, pr);
            }
        }
        return new Outcome(Task.Status.COMPLETED, Curve2PRExporter.toMessage(ctx, results.size(), totInstanceRefs));
    }

    private int countInstanceRefs(Attributes pr) {
        return (int)pr.getSequence(528661).stream().mapToInt(x -> x.getSequence(528704).size()).count();
    }

    private boolean isImage(InstanceLocations inst) {
        Attributes attrs = inst.getAttributes();
        return attrs.getInt(2621456, -1) > 0 && attrs.getInt(2621457, -1) > 0;
    }

    private void curve2pr(RetrieveContext ctx, InstanceLocations inst, List<Attributes> results) throws Exception {
        byte[] curveData;
        Attributes metadata = Curve2PRExporter.loadWithoutPixelData(ctx, inst);
        float[] pixelSpacing = metadata.getFloats(2621488);
        Attributes graphicAnnotationItem = null;
        int offset = 0;
        while ((curveData = metadata.getBytes(0x50003000 | offset)) != null) {
            if (Curve2PRExporter.isConvertable(curveData, metadata, offset)) {
                if (graphicAnnotationItem == null) {
                    graphicAnnotationItem = this.graphicAnnotationItem(inst, results, metadata);
                }
                Curve2PRExporter.addPolyline(graphicAnnotationItem, VR.FL.toFloats((Object)curveData, false), pixelSpacing);
            }
            offset += 131072;
        }
    }

    private static Attributes loadWithoutPixelData(RetrieveContext ctx, InstanceLocations inst) throws Exception {
        try (DicomInputStream dis = ctx.getRetrieveService().openDicomInputStream(ctx, inst);){
            Attributes attrs = dis.readDatasetUntilPixelData();
            ctx.getRetrieveService().getAttributesCoercion(ctx, inst).coerce(attrs, null);
            Attributes attributes = attrs;
            return attributes;
        }
    }

    private static boolean isConvertable(byte[] curveData, Attributes metadata, int offset) {
        return curveData.length == 16 && metadata.getInt(0x50000005 | offset, -1) == 2 && metadata.getInt(0x50000010 | offset, -1) == 2 && "LINE".equals(metadata.getString(0x50000020 | offset)) && metadata.getInt(0x50000103 | offset, -1) == 2;
    }

    private Attributes graphicAnnotationItem(InstanceLocations inst, List<Attributes> results, Attributes metadata) {
        Attributes pr = this.createPR(inst, results, metadata);
        Curve2PRExporter.imageRef(Curve2PRExporter.seriesRef(pr, inst.getAttributes().getString(0x20000E)), inst);
        Attributes voiLUT = new Attributes(metadata, VOI_LUT_TAGS);
        if (!voiLUT.isEmpty()) {
            Curve2PRExporter.imageRef(Curve2PRExporter.softcopyVOILUTItem(pr, voiLUT), inst);
        }
        Attributes graphicAnnotationItem = new Attributes(4);
        pr.ensureSequence(0x700001, 10).add(graphicAnnotationItem);
        Curve2PRExporter.imageRef(graphicAnnotationItem, inst);
        graphicAnnotationItem.setString(0x700002, VR.CS, this.properties.get(GraphicLayer));
        Curve2PRExporter.imageRef(Curve2PRExporter.displayAreaSelectionItem(pr, metadata.getInt(2621456, 1), metadata.getInt(2621457, 1)), inst);
        return graphicAnnotationItem;
    }

    private Attributes createPR(InstanceLocations inst, List<Attributes> results, Attributes metadata) {
        Attributes modLUT = new Attributes(metadata, MOD_LUT_TAGS);
        for (Attributes pr : results) {
            if (!modLUT.equals((Object)new Attributes(pr, MOD_LUT_TAGS))) continue;
            return pr;
        }
        String instanceNumber = inst.getAttributes().getString(2097171, "1");
        String seriesInstanceUID = Curve2PRExporter.seriesInstanceUID(inst, results);
        String sopInstanceUID = Curve2PRExporter.sopInstanceUID(inst, seriesInstanceUID);
        Attributes pr = new Attributes();
        pr.setString(2097171, VR.IS, instanceNumber);
        pr.addSelected(metadata, this.patStudyTags);
        this.properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("PR")).forEach(entry -> Curve2PRExporter.setString(pr, entry, metadata));
        pr.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.11.1");
        pr.setString(524312, VR.UI, sopInstanceUID);
        pr.setString(524384, VR.CS, "PR");
        pr.setString(0x20000E, VR.UI, seriesInstanceUID);
        pr.setString(7340097, VR.CS, "N");
        pr.setInt(7340098, VR.US, new int[]{0});
        pr.newSequence(0x700060, 1).add(this.graphicLayerItem());
        Date now = new Date();
        pr.setDate(2251877123620883L, new Date[]{now});
        pr.setDate(31525755744682115L, new Date[]{now});
        results.add(pr);
        return pr;
    }

    private static void setString(Attributes pr, Map.Entry<String, String> entry, Attributes metadata) {
        int tag = TagUtils.forName((String)entry.getKey().substring(3));
        pr.setString(tag, dict.vrOf(tag), new AttributesFormat(entry.getValue()).format((Object)metadata));
    }

    private static String seriesInstanceUID(InstanceLocations inst, List<Attributes> results) {
        return !results.isEmpty() ? results.get(0).getString(0x20000E) : UIDUtils.createNameBasedUID((byte[])inst.getAttributes().getString(0x20000E).getBytes());
    }

    private static String sopInstanceUID(InstanceLocations inst, String seriesInstanceUID) {
        return UIDUtils.createNameBasedUID((byte[])(seriesInstanceUID + inst.getSopInstanceUID()).getBytes());
    }

    private Attributes graphicLayerItem() {
        Attributes item = new Attributes(3);
        item.setString(0x700002, VR.CS, this.properties.get(GraphicLayer));
        item.setString(7340130, VR.IS, this.properties.get(GraphicLayerOrder));
        item.setString(0x700066, VR.US, this.properties.get(GraphicLayerRecommendedDisplayGrayscaleValue));
        return item;
    }

    private static Attributes softcopyVOILUTItem(Attributes pr, Attributes voiLUT) {
        Sequence seq = pr.ensureSequence(2634000, 10);
        for (Attributes item : seq) {
            if (!voiLUT.equals((Object)new Attributes(item, VOI_LUT_TAGS))) continue;
            return item;
        }
        seq.add(voiLUT);
        return voiLUT;
    }

    private static Attributes displayAreaSelectionItem(Attributes pr, int ... bottomRight) {
        Sequence seq = pr.ensureSequence(7340122, 10);
        for (Attributes item : seq) {
            if (!Arrays.equals(bottomRight, item.getInts(7340115))) continue;
            return item;
        }
        Attributes item = new Attributes(4);
        seq.add(item);
        item.setInt(7340114, VR.SL, TOP_LEFT);
        item.setInt(7340115, VR.SL, bottomRight);
        item.setString(0x700100, VR.CS, "SCALE TO FIT");
        return item;
    }

    private static Attributes seriesRef(Attributes pr, String seriesIUID) {
        Sequence seq = pr.ensureSequence(528661, 10);
        for (Attributes item : seq) {
            if (!seriesIUID.equals(item.getString(0x20000E))) continue;
            return item;
        }
        Attributes item = new Attributes(2);
        seq.add(item);
        item.setString(0x20000E, VR.UI, seriesIUID);
        return item;
    }

    private static void imageRef(Attributes attrs, InstanceLocations inst) {
        attrs.ensureSequence(528704, 10).add(Curve2PRExporter.sopRef(inst));
    }

    private static Attributes sopRef(InstanceLocations inst) {
        Attributes sopRef = new Attributes(2);
        sopRef.setString(528720, VR.UI, inst.getSopClassUID());
        sopRef.setString(528725, VR.UI, inst.getSopInstanceUID());
        return sopRef;
    }

    private static void addPolyline(Attributes graphicAnnotationItem, float[] curveData, float[] pixelSpacing) {
        Curve2PRExporter.shiftCoordsOnePixel(curveData);
        if (pixelSpacing != null && pixelSpacing.length == 2) {
            graphicAnnotationItem.ensureSequence(0x700008, 10).add(Curve2PRExporter.createAnchorPoint(curveData, pixelSpacing));
        }
        graphicAnnotationItem.ensureSequence(0x700009, 10).add(Curve2PRExporter.createPolyline(curveData));
    }

    private static void shiftCoordsOnePixel(float[] curveData) {
        int i = 0;
        while (i < curveData.length) {
            int n = i++;
            curveData[n] = curveData[n] + 1.0f;
        }
    }

    private static Attributes createPolyline(float[] curveData) {
        Attributes polyline = new Attributes(6);
        polyline.setString(0x700005, VR.CS, "PIXEL");
        polyline.setInt(0x700020, VR.US, new int[]{2});
        polyline.setInt(7340065, VR.US, new int[]{2});
        polyline.setFloat(0x700022, VR.FL, curveData);
        polyline.setString(7340067, VR.CS, "POLYLINE");
        polyline.setString(7340068, VR.CS, "N");
        return polyline;
    }

    private static Attributes createAnchorPoint(float[] curveData, float[] pixelSpacing) {
        Attributes anchorPoint = new Attributes(4);
        anchorPoint.setString(0x700004, VR.CS, "PIXEL");
        anchorPoint.setString(0x700006, VR.ST, Curve2PRExporter.toText(curveData, pixelSpacing));
        anchorPoint.setFloat(7340052, VR.FL, Curve2PRExporter.toAnchorPoint(curveData));
        anchorPoint.setString(7340053, VR.CS, "N");
        return anchorPoint;
    }

    private static String toText(float[] curveData, float[] pixelSpacing) {
        float x = (curveData[0] - curveData[2]) * pixelSpacing[0];
        float y = (curveData[1] - curveData[3]) * pixelSpacing[1];
        return String.format("%.2f mm", Math.sqrt(x * x + y * y));
    }

    private static float[] toAnchorPoint(float[] curveData) {
        return new float[]{curveData[2], curveData[3] + Math.signum(curveData[3] - curveData[1]) * 10.0f};
    }

    private static void trimSoftcopyVOILUT(Attributes pr, int totRefs) {
        Sequence seq = pr.getSequence(2634000);
        if (seq == null || seq.size() != 1) {
            return;
        }
        Attributes item = (Attributes)seq.get(0);
        if (item.getSequence(528704).size() == totRefs) {
            item.remove(528704);
        }
    }

    private static void trimDisplayAreaSelection(Attributes pr) {
        Sequence displayAreaSelectionSeq = pr.getSequence(7340122);
        if (displayAreaSelectionSeq.size() == 1) {
            ((Attributes)displayAreaSelectionSeq.get(0)).remove(528704);
        }
    }

    private static String noPresentationStateCreated(ExportContext ctx) {
        return Curve2PRExporter.appendEntity((ExportContext)ctx, (StringBuilder)new StringBuilder("No Presentation State created for ")).toString();
    }

    private static String toMessage(ExportContext ctx, int numPRs, int numImages) {
        return Curve2PRExporter.appendEntity((ExportContext)ctx, (StringBuilder)new StringBuilder("Created ").append(numPRs).append(" Presentation State(s) applied to ").append(numImages).append(" Images of ")).toString();
    }
}

