/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Stream;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ValueSelector;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.BlobCorruptedException;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.PersonName;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.entity.SeriesQueryAttributes;
import org.dcm4chee.arc.entity.SeriesRequestAttributes;
import org.dcm4chee.arc.entity.Study;

@NamedQueries(value={@NamedQuery(name="Series.findBySeriesIUID", query="select se from Series se join se.study st where st.studyInstanceUID = ?1 and se.seriesInstanceUID = ?2 "), @NamedQuery(name="Series.attrsBySeriesIUID", query="select a.encodedAttributes from Series se join se.study st join se.attributesBlob a where st.studyInstanceUID = ?1 and se.seriesInstanceUID = ?2 "), @NamedQuery(name="Series.findSeriesOfStudyByStudyIUIDEager", query="select se from Series se join fetch se.study st join fetch se.attributesBlob join fetch st.attributesBlob where st.studyInstanceUID = ?1 "), @NamedQuery(name="Series.findBySeriesIUIDEager", query="select se from Series se join fetch se.study st join fetch st.patient p left join fetch p.patientName left join fetch st.referringPhysicianName left join fetch se.performingPhysicianName join fetch se.attributesBlob join fetch st.attributesBlob join fetch p.attributesBlob where st.studyInstanceUID = ?1 and se.seriesInstanceUID = ?2"), @NamedQuery(name="Series.seriesPKsOfStudyWithUnknownSize", query="select se.pk from Series se where se.study.pk = ?1 and se.size = -1"), @NamedQuery(name="Series.sizeOfStudy", query="select sum(se.size) from Series se where se.study.pk = ?1"), @NamedQuery(name="Series.SetSeriesSize", query="update Series se set se.size = ?2 where se.pk = ?1"), @NamedQuery(name="Series.SetCompleteness", query="update Series ser set ser.completeness = ?3 where ser.seriesInstanceUID = ?2 and ser.study in (select study from Study study where study.studyInstanceUID = ?1)"), @NamedQuery(name="Series.SetCompletenessOfStudy", query="update Series ser set ser.completeness = ?2 where ser.study in (select study from Study study where study.studyInstanceUID = ?1)"), @NamedQuery(name="Series.IncrementFailedRetrieves", query="update Series ser set ser.failedRetrieves = ser.failedRetrieves + 1, ser.completeness = ?3 where ser.seriesInstanceUID = ?2 and ser.study in (select study from Study study where study.studyInstanceUID = ?1)"), @NamedQuery(name="Series.updateStgVerFailures", query="update Series ser set ser.failuresOfLastStorageVerification = ?2, ser.size = ?3 where ser.pk =?1"), @NamedQuery(name="Series.updateCompressionFailures", query="update Series ser set ser.compressionFailures = ?2 where ser.pk = ?1"), @NamedQuery(name="Series.updateCompressionFailuresAndTSUID", query="update Series ser set ser.compressionFailures = ?2, ser.transferSyntaxUID = ?3 where ser.pk = ?1"), @NamedQuery(name="Series.updateCompressionCompleted", query="update Series ser set ser.compressionFailures = ?2, ser.transferSyntaxUID = ?3, ser.compressionTransferSyntaxUID = null, ser.compressionImageWriteParams = null where ser.pk = ?1"), @NamedQuery(name="Series.countSeriesOfStudy", query="select count(se) from Series se where se.study = ?1"), @NamedQuery(name="Series.GetExpiredSeries", query="select se from Series se where se.expirationDate <= ?1 and se.expirationState in ?2"), @NamedQuery(name="Series.ClaimExpiredSeries", query="update Series se set se.expirationState = ?3 where se.pk = ?1 and se.expirationState = ?2"), @NamedQuery(name="Series.ExpireSeries", query="update Series se set se.expirationState = ?2 , se.expirationDate = ?3 where se.study.pk = ?1"), @NamedQuery(name="Series.FindSeriesOfStudy", query="select se from Series se where se.study.studyInstanceUID = ?1"), @NamedQuery(name="Series.FindSeriesOfStudyByInstancePurgeState", query="select se from Series se join fetch se.metadata where se.study.studyInstanceUID = ?1 and se.instancePurgeState = ?2"), @NamedQuery(name="Series.FindBySeriesIUIDAndInstancePurgeState", query="select se from Series se join fetch se.metadata where se.study.studyInstanceUID = ?1 and se.seriesInstanceUID = ?2 and se.instancePurgeState = ?3"), @NamedQuery(name="Series.countSeriesOfStudyWithOtherRejectionState", query="select count(se) from Series se where se.study = ?1 and se.rejectionState <> ?2"), @NamedQuery(name="Series.seriesIUIDsOfStudy", query="select se.study.studyInstanceUID, se.seriesInstanceUID from Series se where se.study.studyInstanceUID = ?1"), @NamedQuery(name="Series.scheduledMetadataUpdate", query="select new org.dcm4chee.arc.entity.Series$MetadataUpdate(se.pk, se.metadataScheduledUpdateTime, se.metadataUpdateFailures, se.instancePurgeTime, se.instancePurgeState, metadata.storageID, metadata.storagePath) from Series se left join se.metadata metadata where se.metadataScheduledUpdateTime < current_timestamp"), @NamedQuery(name="Series.scheduledPurgeInstances", query="select new org.dcm4chee.arc.entity.Series$MetadataUpdate(se.pk, se.metadataScheduledUpdateTime, se.metadataUpdateFailures, se.instancePurgeTime, se.instancePurgeState, metadata.storageID, metadata.storagePath) from Series se join se.metadata metadata where se.instancePurgeTime < current_timestamp and se.metadataScheduledUpdateTime is null"), @NamedQuery(name="Series.scheduleMetadataUpdateForPatient", query="update Series se set se.metadataScheduledUpdateTime = current_timestamp where se.study in (select st from Study st where st.patient = ?1) and se.metadata is not null and se.metadataScheduledUpdateTime is null"), @NamedQuery(name="Series.scheduleMetadataUpdateForStudy", query="update Series se set se.metadataScheduledUpdateTime = current_timestamp where se.study = ?1 and se.metadata is not null and se.metadataScheduledUpdateTime is null"), @NamedQuery(name="Series.scheduleMetadataUpdateForSeries", query="update Series se set se.metadataScheduledUpdateTime = current_timestamp where se.pk = ?1 and se.metadata is not null and se.metadataScheduledUpdateTime is null"), @NamedQuery(name="Series.scheduleMetadataUpdateForSeriesUID", query="update Series se set se.metadataScheduledUpdateTime = current_timestamp where se.study in (select st from Study st where st.studyInstanceUID = ?1) and se.seriesInstanceUID = ?2 and se.metadata is not null and se.metadataScheduledUpdateTime is null"), @NamedQuery(name="Series.findDistinctModalities", query="select distinct se.modality from Series se"), @NamedQuery(name="Series.findDistinctInstitutions", query="select distinct se.institutionName from Series se"), @NamedQuery(name="Series.updateInstancePurgeState", query="update Series se set se.instancePurgeState = ?3 where se.pk = ?1 and se.instancePurgeState = ?2"), @NamedQuery(name="Series.findByStudyPkAndInstancePurgeState", query="select se from Series se join fetch se.metadata where se.study.pk=?1 and se.instancePurgeState=?2"), @NamedQuery(name="Series.scheduledStorageVerification", query="select new org.dcm4chee.arc.entity.Series$StorageVerification(se.pk, se.storageVerificationTime, se.seriesInstanceUID, se.study.studyInstanceUID) from Series se where se.storageVerificationTime < current_timestamp"), @NamedQuery(name="Series.scheduledCompression", query="select new org.dcm4chee.arc.entity.Series$Compression(se.study.pk, se.pk, se.compressionTime, se.instancePurgeState, se.compressionTransferSyntaxUID, se.compressionImageWriteParams, se.seriesInstanceUID, se.study.studyInstanceUID) from Series se where se.compressionTime < current_timestamp"), @NamedQuery(name="Series.setMetadataScheduledUpdateTime", query="update Series se set se.metadataUpdateFailures = se.metadataUpdateFailures + 1, se.metadataScheduledUpdateTime = ?2 where se.pk = ?1"), @NamedQuery(name="Series.setMetadata", query="update Series se set se.metadata = ?2, se.metadataUpdateFailures = 0, se.metadataScheduledUpdateTime = null where se.pk = ?1"), @NamedQuery(name="Series.claimStorageVerification", query="update Series se set se.storageVerificationTime = ?3 where se.pk = ?1 and se.storageVerificationTime = ?2"), @NamedQuery(name="Series.claimCompression", query="update Series se set se.compressionTime = null where se.pk = ?1 and se.compressionTime =?2"), @NamedQuery(name="Series.claimUpdateMetadata", query="update Series se set se.metadataScheduledUpdateTime = null where se.pk = ?1 and se.metadataScheduledUpdateTime = ?2"), @NamedQuery(name="Series.claimPurgeInstanceRecords", query="update Series se set se.instancePurgeTime = null where se.pk = ?1 and se.instancePurgeTime = ?2"), @NamedQuery(name="Series.findLastModifiedStudyLevel", query="SELECT p.updatedTime, st.modifiedTime, MAX(se.modifiedTime) from Series se JOIN se.study st JOIN st.patient p where st.studyInstanceUID = ?1 and se.instancePurgeState = ?2 GROUP BY p, st"), @NamedQuery(name="Series.findLastModifiedSeriesLevel", query="SELECT p.updatedTime, st.modifiedTime, se.modifiedTime from Series se JOIN se.study st JOIN st.patient p where st.studyInstanceUID = ?1 and se.seriesInstanceUID = ?2 and se.instancePurgeState = ?3")})
@Entity
@Table(name="series", uniqueConstraints={@UniqueConstraint(columnNames={"study_fk", "series_iuid"})}, indexes={@Index(columnList="series_iuid"), @Index(columnList="rejection_state"), @Index(columnList="series_no"), @Index(columnList="modality"), @Index(columnList="sop_cuid"), @Index(columnList="tsuid"), @Index(columnList="station_name"), @Index(columnList="pps_start_date"), @Index(columnList="pps_start_time"), @Index(columnList="body_part"), @Index(columnList="laterality"), @Index(columnList="series_desc"), @Index(columnList="institution"), @Index(columnList="department"), @Index(columnList="series_custom1"), @Index(columnList="series_custom2"), @Index(columnList="series_custom3"), @Index(columnList="sending_aet"), @Index(columnList="receiving_aet"), @Index(columnList="sending_pres_addr"), @Index(columnList="receiving_pres_addr"), @Index(columnList="sending_hl7_app"), @Index(columnList="sending_hl7_facility"), @Index(columnList="receiving_hl7_app"), @Index(columnList="receiving_hl7_facility"), @Index(columnList="expiration_state"), @Index(columnList="expiration_date"), @Index(columnList="failed_retrieves"), @Index(columnList="completeness"), @Index(columnList="metadata_update_time"), @Index(columnList="metadata_update_failures"), @Index(columnList="inst_purge_time"), @Index(columnList="inst_purge_state"), @Index(columnList="stgver_time"), @Index(columnList="stgver_failures"), @Index(columnList="compress_time"), @Index(columnList="compress_failures")})
public class Series {
    public static final String FIND_BY_SERIES_IUID = "Series.findBySeriesIUID";
    public static final String ATTRS_BY_SERIES_IUID = "Series.attrsBySeriesIUID";
    public static final String FIND_SERIES_OF_STUDY_BY_STUDY_IUID_EAGER = "Series.findSeriesOfStudyByStudyIUIDEager";
    public static final String FIND_BY_SERIES_IUID_EAGER = "Series.findBySeriesIUIDEager";
    public static final String COUNT_SERIES_OF_STUDY = "Series.countSeriesOfStudy";
    public static final String SERIES_PKS_OF_STUDY_WITH_UNKNOWN_SIZE = "Series.seriesPKsOfStudyWithUnknownSize";
    public static final String SIZE_OF_STUDY = "Series.sizeOfStudy";
    public static final String SET_SERIES_SIZE = "Series.SetSeriesSize";
    public static final String SET_COMPLETENESS = "Series.SetCompleteness";
    public static final String SET_COMPLETENESS_OF_STUDY = "Series.SetCompletenessOfStudy";
    public static final String INCREMENT_FAILED_RETRIEVES = "Series.IncrementFailedRetrieves";
    public static final String GET_EXPIRED_SERIES = "Series.GetExpiredSeries";
    public static final String CLAIM_EXPIRED_SERIES = "Series.ClaimExpiredSeries";
    public static final String EXPIRE_SERIES = "Series.ExpireSeries";
    public static final String FIND_SERIES_OF_STUDY = "Series.FindSeriesOfStudy";
    public static final String FIND_SERIES_OF_STUDY_BY_INSTANCE_PURGE_STATE = "Series.FindSeriesOfStudyByInstancePurgeState";
    public static final String FIND_BY_SERIES_IUID_AND_INSTANCE_PURGE_STATE = "Series.FindBySeriesIUIDAndInstancePurgeState";
    public static final String COUNT_SERIES_OF_STUDY_WITH_OTHER_REJECTION_STATE = "Series.countSeriesOfStudyWithOtherRejectionState";
    public static final String SERIES_IUIDS_OF_STUDY = "Series.seriesIUIDsOfStudy";
    public static final String SCHEDULED_METADATA_UPDATE = "Series.scheduledMetadataUpdate";
    public static final String SCHEDULED_PURGE_INSTANCES = "Series.scheduledPurgeInstances";
    public static final String SCHEDULE_METADATA_UPDATE_FOR_PATIENT = "Series.scheduleMetadataUpdateForPatient";
    public static final String SCHEDULE_METADATA_UPDATE_FOR_STUDY = "Series.scheduleMetadataUpdateForStudy";
    public static final String SCHEDULE_METADATA_UPDATE_FOR_SERIES = "Series.scheduleMetadataUpdateForSeries";
    public static final String SCHEDULE_METADATA_UPDATE_FOR_SERIES_UID = "Series.scheduleMetadataUpdateForSeriesUID";
    public static final String UPDATE_INSTANCE_PURGE_STATE = "Series.updateInstancePurgeState";
    public static final String FIND_DISTINCT_MODALITIES = "Series.findDistinctModalities";
    public static final String FIND_DISTINCT_INSTITUTIONS = "Series.findDistinctInstitutions";
    public static final String FIND_BY_STUDY_PK_AND_INSTANCE_PURGE_STATE = "Series.findByStudyPkAndInstancePurgeState";
    public static final String UPDATE_STGVER_FAILURES = "Series.updateStgVerFailures";
    public static final String SCHEDULED_STORAGE_VERIFICATION = "Series.scheduledStorageVerification";
    public static final String SCHEDULED_COMPRESSION = "Series.scheduledCompression";
    public static final String INCREMENT_METADATA_UPDATE_FAILURES = "Series.setMetadataScheduledUpdateTime";
    public static final String SET_METADATA = "Series.setMetadata";
    public static final String CLAIM_STORAGE_VERIFICATION = "Series.claimStorageVerification";
    public static final String CLAIM_COMPRESSION = "Series.claimCompression";
    public static final String CLAIM_UPDATE_METADATA = "Series.claimUpdateMetadata";
    public static final String CLAIM_PURGE_INSTANCE_RECORDS = "Series.claimPurgeInstanceRecords";
    public static final String UPDATE_COMPRESSION_FAILURES = "Series.updateCompressionFailures";
    public static final String UPDATE_COMPRESSION_FAILURES_AND_TSUID = "Series.updateCompressionFailuresAndTSUID";
    public static final String UPDATE_COMPRESSION_COMPLETED = "Series.updateCompressionCompleted";
    public static final String FIND_LAST_MODIFIED_STUDY_LEVEL = "Series.findLastModifiedStudyLevel";
    public static final String FIND_LAST_MODIFIED_SERIES_LEVEL = "Series.findLastModifiedSeriesLevel";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="modified_time")
    private Date modifiedTime;
    @Basic(optional=false)
    @Column(name="completeness")
    private Completeness completeness;
    @Basic(optional=false)
    @Column(name="failed_retrieves")
    private int failedRetrieves;
    @Basic(optional=false)
    @Column(name="series_iuid", updatable=false)
    private String seriesInstanceUID;
    @Column(name="series_no")
    private Integer seriesNumber;
    @Basic(optional=false)
    @Column(name="series_desc")
    private String seriesDescription;
    @Basic(optional=false)
    @Column(name="modality")
    private String modality;
    @Basic(optional=false)
    @Column(name="sop_cuid")
    private String sopClassUID;
    @Basic(optional=false)
    @Column(name="tsuid")
    private String transferSyntaxUID;
    @Basic(optional=false)
    @Column(name="department")
    private String institutionalDepartmentName;
    @Basic(optional=false)
    @Column(name="institution")
    private String institutionName;
    @Basic(optional=false)
    @Column(name="station_name")
    private String stationName;
    @Basic(optional=false)
    @Column(name="body_part")
    private String bodyPartExamined;
    @Basic(optional=false)
    @Column(name="laterality")
    private String laterality;
    @Basic(optional=false)
    @Column(name="pps_start_date")
    private String performedProcedureStepStartDate;
    @Basic(optional=false)
    @Column(name="pps_start_time")
    private String performedProcedureStepStartTime;
    @Basic(optional=false)
    @Column(name="pps_iuid")
    private String performedProcedureStepInstanceUID;
    @Basic(optional=false)
    @Column(name="pps_cuid")
    private String performedProcedureStepClassUID;
    @Basic(optional=false)
    @Column(name="series_custom1")
    private String seriesCustomAttribute1;
    @Basic(optional=false)
    @Column(name="series_custom2")
    private String seriesCustomAttribute2;
    @Basic(optional=false)
    @Column(name="series_custom3")
    private String seriesCustomAttribute3;
    @Column(name="sending_aet")
    private String sendingAET;
    @Column(name="receiving_aet")
    private String receivingAET;
    @Column(name="sending_pres_addr")
    private String sendingPresentationAddress;
    @Column(name="receiving_pres_addr")
    private String receivingPresentationAddress;
    @Column(name="sending_hl7_app")
    private String sendingHL7Application;
    @Column(name="sending_hl7_facility")
    private String sendingHL7Facility;
    @Column(name="receiving_hl7_app")
    private String receivingHL7Application;
    @Column(name="receiving_hl7_facility")
    private String receivingHL7Facility;
    @Column(name="ext_retrieve_aet")
    private String externalRetrieveAET;
    @Basic(optional=false)
    @Column(name="series_size")
    private long size = -1L;
    @Basic(optional=false)
    @Column(name="rejection_state")
    private RejectionState rejectionState;
    @Basic(optional=false)
    @Column(name="expiration_state")
    private ExpirationState expirationState;
    @Basic
    @Column(name="expiration_date")
    private String expirationDate;
    @Basic
    @Column(name="expiration_exporter_id")
    private String expirationExporterID;
    @Basic
    @Column(name="metadata_update_time")
    private Date metadataScheduledUpdateTime;
    @Basic(optional=false)
    @Column(name="metadata_update_failures")
    private int metadataUpdateFailures;
    @Basic
    @Column(name="inst_purge_time")
    private Date instancePurgeTime;
    @Basic(optional=false)
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="inst_purge_state")
    private InstancePurgeState instancePurgeState;
    @Basic
    @Column(name="stgver_time")
    private Date storageVerificationTime;
    @Basic(optional=false)
    @Column(name="stgver_failures")
    private int failuresOfLastStorageVerification;
    @Basic
    @Column(name="compress_time")
    private Date compressionTime;
    @Column(name="compress_tsuid")
    private String compressionTransferSyntaxUID;
    @Column(name="compress_params")
    private String compressionImageWriteParams;
    @Basic(optional=false)
    @Column(name="compress_failures")
    private int compressionFailures;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, optional=false)
    @JoinColumn(name="dicomattrs_fk")
    private AttributesBlob attributesBlob;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="perf_phys_name_fk")
    private PersonName performingPhysicianName;
    @ManyToOne
    @JoinColumn(name="inst_code_fk")
    private CodeEntity institutionCode;
    @ManyToOne
    @JoinColumn(name="dept_code_fk")
    private CodeEntity institutionalDepartmentTypeCode;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="series_fk")
    private Collection<SeriesRequestAttributes> requestAttributes;
    @OneToMany(mappedBy="series", cascade={CascadeType.ALL})
    private Collection<SeriesQueryAttributes> queryAttributes;
    @ManyToOne(optional=false)
    @JoinColumn(name="study_fk")
    private Study study;
    @OneToOne
    @JoinColumn(name="metadata_fk")
    private Metadata metadata;

    public String toString() {
        return "Series[pk=" + this.pk + ", uid=" + this.seriesInstanceUID + ", no=" + this.seriesNumber + ", mod=" + this.modality + "]";
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
        this.modifiedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public long getPk() {
        return this.pk;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public Integer getSeriesNumber() {
        return this.seriesNumber;
    }

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public String getModality() {
        return this.modality;
    }

    public String getSopClassUID() {
        return this.sopClassUID;
    }

    public void setSopClassUID(String sopClassUID) {
        this.sopClassUID = sopClassUID;
    }

    public String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    public void setTransferSyntaxUID(String transferSyntaxUID) {
        this.transferSyntaxUID = transferSyntaxUID;
    }

    public String getInstitutionalDepartmentName() {
        return this.institutionalDepartmentName;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getBodyPartExamined() {
        return this.bodyPartExamined;
    }

    public String getLaterality() {
        return this.laterality;
    }

    public PersonName getPerformingPhysicianName() {
        return this.performingPhysicianName;
    }

    public String getPerformedProcedureStepStartDate() {
        return this.performedProcedureStepStartDate;
    }

    public String getPerformedProcedureStepStartTime() {
        return this.performedProcedureStepStartTime;
    }

    public String getPerformedProcedureStepInstanceUID() {
        return this.performedProcedureStepInstanceUID;
    }

    public String getPerformedProcedureStepClassUID() {
        return this.performedProcedureStepClassUID;
    }

    public String getSeriesCustomAttribute1() {
        return this.seriesCustomAttribute1;
    }

    public String getSeriesCustomAttribute2() {
        return this.seriesCustomAttribute2;
    }

    public String getSeriesCustomAttribute3() {
        return this.seriesCustomAttribute3;
    }

    public String getSendingAET() {
        return this.sendingAET;
    }

    public void setSendingAET(String sendingAET) {
        this.sendingAET = sendingAET;
    }

    public String getReceivingAET() {
        return this.receivingAET;
    }

    public void setReceivingAET(String receivingAET) {
        this.receivingAET = receivingAET;
    }

    public String getSendingPresentationAddress() {
        return this.sendingPresentationAddress;
    }

    public void setSendingPresentationAddress(String sendingPresentationAddress) {
        this.sendingPresentationAddress = sendingPresentationAddress;
    }

    public String getReceivingPresentationAddress() {
        return this.receivingPresentationAddress;
    }

    public void setReceivingPresentationAddress(String receivingPresentationAddress) {
        this.receivingPresentationAddress = receivingPresentationAddress;
    }

    public String getSendingHL7Application() {
        return this.sendingHL7Application;
    }

    public void setSendingHL7Application(String sendingHL7Application) {
        this.sendingHL7Application = sendingHL7Application;
    }

    public String getSendingHL7Facility() {
        return this.sendingHL7Facility;
    }

    public void setSendingHL7Facility(String sendingHL7Facility) {
        this.sendingHL7Facility = sendingHL7Facility;
    }

    public String getReceivingHL7Application() {
        return this.receivingHL7Application;
    }

    public void setReceivingHL7Application(String receivingHL7Application) {
        this.receivingHL7Application = receivingHL7Application;
    }

    public String getReceivingHL7Facility() {
        return this.receivingHL7Facility;
    }

    public void setReceivingHL7Facility(String receivingHL7Facility) {
        this.receivingHL7Facility = receivingHL7Facility;
    }

    public String getExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public void setExternalRetrieveAET(String externalRetrieveAET) {
        this.externalRetrieveAET = externalRetrieveAET;
    }

    public void resetSize() {
        this.size = -1L;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public RejectionState getRejectionState() {
        return this.rejectionState;
    }

    public void setRejectionState(RejectionState rejectionState) {
        this.rejectionState = rejectionState;
    }

    public ExpirationState getExpirationState() {
        return this.expirationState;
    }

    public void setExpirationState(ExpirationState expirationState) {
        this.expirationState = expirationState;
    }

    public LocalDate getExpirationDate() {
        return this.expirationDate != null ? LocalDate.parse(this.expirationDate, DateTimeFormatter.BASIC_ISO_DATE) : null;
    }

    public void setExpirationDate(LocalDate expirationDate) {
        if (expirationDate != null) {
            try {
                this.expirationDate = DateTimeFormatter.BASIC_ISO_DATE.format(expirationDate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.expirationDate = null;
        }
    }

    public String getExpirationExporterID() {
        return this.expirationExporterID;
    }

    public void setExpirationExporterID(String expirationExporterID) {
        this.expirationExporterID = expirationExporterID;
    }

    public Date getMetadataScheduledUpdateTime() {
        return this.metadataScheduledUpdateTime;
    }

    public void setMetadataScheduledUpdateTime(Date metadataScheduledUpdateTime) {
        this.metadataScheduledUpdateTime = metadataScheduledUpdateTime;
    }

    public void scheduleMetadataUpdate(Duration delay) {
        if (delay != null && this.metadataScheduledUpdateTime == null) {
            this.metadataScheduledUpdateTime = new Date(System.currentTimeMillis() + delay.getSeconds() * 1000L);
        }
    }

    public int getMetadataUpdateFailures() {
        return this.metadataUpdateFailures;
    }

    public void setMetadataUpdateFailures(int metadataUpdateFailures) {
        this.metadataUpdateFailures = metadataUpdateFailures;
    }

    public Date getInstancePurgeTime() {
        return this.instancePurgeTime;
    }

    public void setInstancePurgeTime(Date instancePurgeTime) {
        this.instancePurgeTime = instancePurgeTime;
    }

    public void scheduleInstancePurge(Duration delay) {
        if (delay != null && this.instancePurgeTime == null) {
            this.instancePurgeTime = new Date(System.currentTimeMillis() + delay.getSeconds() * 1000L);
        }
    }

    public InstancePurgeState getInstancePurgeState() {
        return this.instancePurgeState;
    }

    public void setInstancePurgeState(InstancePurgeState instancePurgeState) {
        this.instancePurgeState = instancePurgeState;
    }

    public Date getStorageVerificationTime() {
        return this.storageVerificationTime;
    }

    public void setStorageVerificationTime(Date storageVerificationTime) {
        this.storageVerificationTime = storageVerificationTime;
    }

    public void scheduleStorageVerification(Period delay) {
        if (delay != null && this.storageVerificationTime == null) {
            this.storageVerificationTime = Date.from(Instant.now().plus(delay));
        }
    }

    public int getFailuresOfLastStorageVerification() {
        return this.failuresOfLastStorageVerification;
    }

    public void setFailuresOfLastStorageVerification(int failuresOfLastStorageVerification) {
        this.failuresOfLastStorageVerification = failuresOfLastStorageVerification;
    }

    public Date getCompressionTime() {
        return this.compressionTime;
    }

    public void setCompressionTime(Date compressionTime) {
        this.compressionTime = compressionTime;
    }

    public String getCompressionTransferSyntaxUID() {
        return this.compressionTransferSyntaxUID;
    }

    public void setCompressionTransferSyntaxUID(String compressionTransferSyntaxUID) {
        this.compressionTransferSyntaxUID = compressionTransferSyntaxUID;
    }

    public Property[] getCompressionImageWriteParams() {
        return Series.parseImageWriteParams(this.compressionImageWriteParams);
    }

    private static Property[] parseImageWriteParams(String params) {
        return params != null ? Property.valueOf((String[])StringUtils.split((String)params, (char)'\\')) : new Property[]{};
    }

    public void setCompressionImageWriteParams(Property[] imageWriteParams) {
        this.compressionImageWriteParams = imageWriteParams.length > 0 ? StringUtils.concat((String[])((String[])Stream.of(imageWriteParams).map(Property::toString).toArray(String[]::new)), (char)'\\') : null;
    }

    public int getCompressionFailures() {
        return this.compressionFailures;
    }

    public void setCompressionFailures(int compressionFailures) {
        this.compressionFailures = compressionFailures;
    }

    public Completeness getCompleteness() {
        return this.completeness;
    }

    public void setCompleteness(Completeness completeness) {
        this.completeness = completeness;
    }

    public CodeEntity getInstitutionCode() {
        return this.institutionCode;
    }

    public void setInstitutionCode(CodeEntity institutionCode) {
        this.institutionCode = institutionCode;
    }

    public CodeEntity getInstitutionalDepartmentTypeCode() {
        return this.institutionalDepartmentTypeCode;
    }

    public void setInstitutionalDepartmentTypeCode(CodeEntity institutionalDepartmentTypeCode) {
        this.institutionalDepartmentTypeCode = institutionalDepartmentTypeCode;
    }

    public Collection<SeriesRequestAttributes> getRequestAttributes() {
        if (this.requestAttributes == null) {
            this.requestAttributes = new ArrayList<SeriesRequestAttributes>();
        }
        return this.requestAttributes;
    }

    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Attributes getAttributes() throws BlobCorruptedException {
        return this.attributesBlob.getAttributes();
    }

    public void setAttributes(Attributes attrs, AttributeFilter filter, boolean withOriginalAttributesSequence, FuzzyStr fuzzyStr) {
        this.seriesInstanceUID = attrs.getString(0x20000E);
        this.seriesNumber = this.getInt(attrs, 0x200011);
        this.seriesDescription = attrs.getString(528446, "*");
        this.institutionName = attrs.getString(524416, "*");
        this.institutionalDepartmentName = attrs.getString(528448, "*");
        this.modality = attrs.getString(524384, "*").toUpperCase();
        this.stationName = attrs.getString(528400, "*");
        this.bodyPartExamined = attrs.getString(1572885, "*").toUpperCase();
        this.laterality = attrs.getString(0x200060, "*").toUpperCase();
        Attributes refPPS = attrs.getNestedDataset(528657);
        if (refPPS != null) {
            this.performedProcedureStepInstanceUID = refPPS.getString(528725, "*");
            this.performedProcedureStepClassUID = refPPS.getString(528720, "*");
        } else {
            this.performedProcedureStepInstanceUID = "*";
            this.performedProcedureStepClassUID = "*";
        }
        Date dt = attrs.getDate(18016889594708549L);
        if (dt != null) {
            this.performedProcedureStepStartDate = DateUtils.formatDA(null, (Date)dt);
            this.performedProcedureStepStartTime = attrs.containsValue(0x400244) ? DateUtils.formatTM(null, (Date)dt) : "*";
        } else {
            this.performedProcedureStepStartDate = "*";
            this.performedProcedureStepStartTime = "*";
        }
        this.performingPhysicianName = PersonName.valueOf(attrs.getString(528464), fuzzyStr, this.performingPhysicianName);
        this.seriesCustomAttribute1 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute1(), (String)"*");
        this.seriesCustomAttribute2 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute2(), (String)"*");
        this.seriesCustomAttribute3 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute3(), (String)"*");
        Attributes blobAttrs = new Attributes(attrs, filter.getSelection(withOriginalAttributesSequence));
        if (this.attributesBlob == null) {
            this.attributesBlob = new AttributesBlob(blobAttrs);
        } else {
            this.attributesBlob.setAttributes(blobAttrs);
        }
        this.modifiedTime = new Date();
    }

    private Integer getInt(Attributes attrs, int tag) {
        String val = attrs.getString(tag);
        if (val != null) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static class Compression {
        public final Long studyPk;
        public final Long seriesPk;
        public final Date compressionTime;
        public final InstancePurgeState instancePurgeState;
        public final String transferSyntaxUID;
        public final String imageWriteParams;
        public final String seriesInstanceUID;
        public final String studyInstanceUID;

        public Compression(Long studyPk, Long seriesPk, Date compressionTime, InstancePurgeState instancePurgeState, String transferSyntaxUID, String imageWriteParams, String seriesInstanceUID, String studyInstanceUID) {
            this.studyPk = studyPk;
            this.seriesPk = seriesPk;
            this.compressionTime = compressionTime;
            this.instancePurgeState = instancePurgeState;
            this.transferSyntaxUID = transferSyntaxUID;
            this.imageWriteParams = imageWriteParams;
            this.seriesInstanceUID = seriesInstanceUID;
            this.studyInstanceUID = studyInstanceUID;
        }

        public Property[] imageWriteParams() {
            return Series.parseImageWriteParams(this.imageWriteParams);
        }
    }

    public static class StorageVerification {
        public final Long seriesPk;
        public final Date storageVerificationTime;
        public final String seriesInstanceUID;
        public final String studyInstanceUID;

        public StorageVerification(Long seriesPk, Date storageVerificationTime, String seriesInstanceUID, String studyInstanceUID) {
            this.seriesPk = seriesPk;
            this.storageVerificationTime = storageVerificationTime;
            this.seriesInstanceUID = seriesInstanceUID;
            this.studyInstanceUID = studyInstanceUID;
        }

        public String toString() {
            return "StorageVerification[seriesPk=" + this.seriesPk + ", storageVerificationTime=" + this.storageVerificationTime + ", studyUID=" + this.studyInstanceUID + ", seriesUID=" + this.seriesInstanceUID + "]";
        }
    }

    public static class MetadataUpdate {
        public final Long seriesPk;
        public final Date scheduledUpdateTime;
        public final int updateFailures;
        public final Date instancePurgeTime;
        public final InstancePurgeState instancePurgeState;
        public final String storageID;
        public final String storagePath;

        public MetadataUpdate(Long seriesPk, Date scheduledUpdateTime, int updateFailures, Date instancePurgeTime, InstancePurgeState instancePurgeState, String storageID, String storagePath) {
            this.seriesPk = seriesPk;
            this.scheduledUpdateTime = scheduledUpdateTime;
            this.updateFailures = updateFailures;
            this.instancePurgeTime = instancePurgeTime;
            this.instancePurgeState = instancePurgeState;
            this.storageID = storageID;
            this.storagePath = storagePath;
        }

        public String toString() {
            return "MetadataUpdate[seriesPk=" + this.seriesPk + ", storageID=" + this.storageID + ", storagePath=" + this.storagePath + "]";
        }
    }

    public static enum InstancePurgeState {
        NO,
        PURGED,
        FAILED_TO_PURGE;

    }
}

