/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.dcm4chee.arc.entity.MPPS;

@NamedQueries(value={@NamedQuery(name="HL7PSUTask.findWithMppsByDeviceName", query="select o from HL7PSUTask o join fetch o.mpps mpps join fetch mpps.attributesBlob where o.mpps is not null and o.deviceName=?1 and o.pk>?2 order by o.pk"), @NamedQuery(name="HL7PSUTask.findScheduledByDeviceName", query="select o from HL7PSUTask o left join fetch o.mpps mpps left join fetch mpps.attributesBlob where o.deviceName=?1 and o.scheduledTime < current_timestamp order by o.scheduledTime"), @NamedQuery(name="HL7PSUTask.findByStudyIUID", query="select o from HL7PSUTask o where o.studyInstanceUID=?1")})
@Entity
@Table(name="hl7psu_task", uniqueConstraints={@UniqueConstraint(columnNames={"study_iuid", "pps_status"})}, indexes={@Index(columnList="device_name")})
public class HL7PSUTask {
    public static final String FIND_WITH_MPPS_BY_DEVICE_NAME = "HL7PSUTask.findWithMppsByDeviceName";
    public static final String FIND_SCHEDULED_BY_DEVICE_NAME = "HL7PSUTask.findScheduledByDeviceName";
    public static final String FIND_BY_STUDY_IUID = "HL7PSUTask.findByStudyIUID";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Column(name="device_name", updatable=false)
    private String deviceName;
    @Basic(optional=false)
    @Column(name="aet", updatable=false)
    private String aeTitle;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="scheduled_time")
    private Date scheduledTime;
    @Column(name="study_iuid", updatable=false)
    private String studyInstanceUID;
    @Column(name="series_iuid")
    private String seriesInstanceUID;
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="pps_status")
    private MPPS.Status pps_status;
    @OneToOne
    @JoinColumn(name="mpps_fk", updatable=false)
    private MPPS mpps;

    @PrePersist
    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public long getPk() {
        return this.pk;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(Date scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String studyInstanceUID) {
        this.studyInstanceUID = studyInstanceUID;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public void setSeriesInstanceUID(String seriesInstanceUID) {
        this.seriesInstanceUID = seriesInstanceUID;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public MPPS getMpps() {
        return this.mpps;
    }

    public void setMpps(MPPS mpps) {
        this.mpps = mpps;
        this.pps_status = mpps.getStatus();
    }

    public MPPS.Status getPPSStatus() {
        return this.pps_status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HL7PSUTask[pk=").append(this.pk).append(", deviceName=").append(this.deviceName);
        if (this.mpps == null) {
            sb.append(", studyInstanceUID=").append(this.studyInstanceUID);
            sb.append(", seriesInstanceUID=").append(this.seriesInstanceUID);
            sb.append(", accessionNumber=").append(this.accessionNumber);
        } else {
            sb.append(", mppsInstanceUID=").append(this.mpps.getSopInstanceUID());
            sb.append(", mppsStatus=").append((Object)this.mpps.getStatus());
        }
        if (this.scheduledTime != null) {
            sb.append(", scheduledTime=").append(this.scheduledTime);
        }
        sb.append(']');
        return sb.toString();
    }
}

