/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7ApplicationExtension;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.HL7ExportRule;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.HL7ForwardRule;
import org.dcm4chee.arc.conf.HL7ImportReportAdjustIUID;
import org.dcm4chee.arc.conf.HL7ImportReportMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7ImportReportMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7ORUAction;
import org.dcm4chee.arc.conf.HL7OrderMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderSPSStatus;
import org.dcm4chee.arc.conf.HL7OrderScheduledStation;
import org.dcm4chee.arc.conf.HL7PrefetchRule;
import org.dcm4chee.arc.conf.HL7ReferredMergedPatientPolicy;
import org.dcm4chee.arc.conf.HL7StudyRetentionPolicy;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.conf.ScheduledProtocolCodeInOrder;
import org.dcm4chee.arc.conf.ScheduledStationAETInOrder;
import org.dcm4chee.arc.conf.UPSOnHL7;

public class ArchiveHL7ApplicationExtension
extends HL7ApplicationExtension {
    private String aeTitle;
    private Boolean recordAttributeModification;
    private String patientUpdateTemplateURI;
    private String importReportTemplateURI;
    private String scheduleProcedureTemplateURI;
    private String hl7LogFilePattern;
    private String hl7ErrorLogFilePattern;
    private ScheduledProtocolCodeInOrder hl7ScheduledProtocolCodeInOrder;
    private ScheduledStationAETInOrder hl7ScheduledStationAETInOrder;
    private Boolean hl7UseNullValue;
    private HL7OrderMissingStudyIUIDPolicy hl7OrderMissingStudyIUIDPolicy;
    private HL7OrderMissingAdmissionIDPolicy hl7OrderMissingAdmissionIDPolicy;
    private HL7ImportReportMissingStudyIUIDPolicy hl7ImportReportMissingStudyIUIDPolicy;
    private HL7ImportReportMissingAdmissionIDPolicy hl7ImportReportMissingAdmissionIDPolicy;
    private String hl7ImportReportMissingStudyIUIDCFindSCP;
    private HL7ImportReportAdjustIUID hl7ImportReportAdjustIUID;
    private HL7ReferredMergedPatientPolicy hl7ReferredMergedPatientPolicy;
    private String hl7DicomCharacterSet;
    private Boolean hl7VeterinaryUsePatientName;
    private String hl7PatientArrivalMessageType;
    private HL7ORUAction[] hl7ORUAction = new HL7ORUAction[0];
    private String mwlWorklistLabel;
    private String mwlAccessionNumberGenerator;
    private String mwlRequestedProcedureIDGenerator;
    private String mwlScheduledProcedureStepIDGenerator;
    private Integer auditHL7MsgLimit;
    private final ArrayList<HL7ExportRule> hl7ExportRules = new ArrayList();
    private final ArrayList<HL7PrefetchRule> hl7PrefetchRules = new ArrayList();
    private final ArrayList<UPSOnHL7> upsOnHL7List = new ArrayList();
    private final ArrayList<HL7ForwardRule> hl7ForwardRules = new ArrayList();
    private final ArrayList<HL7OrderScheduledStation> hl7OrderScheduledStations = new ArrayList();
    private final ArrayList<HL7StudyRetentionPolicy> hl7StudyRetentionPolicies = new ArrayList();
    private final EnumMap<SPSStatus, HL7OrderSPSStatus> hl7OrderSPSStatuses = new EnumMap(SPSStatus.class);
    private final LinkedHashSet<String> hl7NoPatientCreateMessageTypes = new LinkedHashSet();
    private final Map<String, String> importReportTemplateParams = new HashMap<String, String>();

    public ArchiveDeviceExtension getArchiveDeviceExtension() {
        return (ArchiveDeviceExtension)this.hl7App.getDevice().getDeviceExtension(ArchiveDeviceExtension.class);
    }

    public ArchiveAEExtension getArchiveAEExtension() {
        return (ArchiveAEExtension)this.hl7App.getDevice().getApplicationEntity(this.aeTitle, true).getAEExtension(ArchiveAEExtension.class);
    }

    public void reconfigure(HL7ApplicationExtension src) {
        ArchiveHL7ApplicationExtension arcapp = (ArchiveHL7ApplicationExtension)src;
        this.aeTitle = arcapp.aeTitle;
        this.recordAttributeModification = arcapp.recordAttributeModification;
        this.patientUpdateTemplateURI = arcapp.patientUpdateTemplateURI;
        this.importReportTemplateURI = arcapp.importReportTemplateURI;
        this.scheduleProcedureTemplateURI = arcapp.scheduleProcedureTemplateURI;
        this.hl7LogFilePattern = arcapp.hl7LogFilePattern;
        this.hl7ErrorLogFilePattern = arcapp.hl7ErrorLogFilePattern;
        this.hl7ScheduledProtocolCodeInOrder = arcapp.hl7ScheduledProtocolCodeInOrder;
        this.hl7ScheduledStationAETInOrder = arcapp.hl7ScheduledStationAETInOrder;
        this.hl7UseNullValue = arcapp.hl7UseNullValue;
        this.hl7OrderMissingStudyIUIDPolicy = arcapp.hl7OrderMissingStudyIUIDPolicy;
        this.hl7OrderMissingAdmissionIDPolicy = arcapp.hl7OrderMissingAdmissionIDPolicy;
        this.hl7ImportReportMissingStudyIUIDPolicy = arcapp.hl7ImportReportMissingStudyIUIDPolicy;
        this.hl7ImportReportMissingAdmissionIDPolicy = arcapp.hl7ImportReportMissingAdmissionIDPolicy;
        this.hl7ImportReportAdjustIUID = arcapp.hl7ImportReportAdjustIUID;
        this.hl7ImportReportMissingStudyIUIDCFindSCP = arcapp.hl7ImportReportMissingStudyIUIDCFindSCP;
        this.hl7ReferredMergedPatientPolicy = arcapp.hl7ReferredMergedPatientPolicy;
        this.hl7DicomCharacterSet = arcapp.hl7DicomCharacterSet;
        this.hl7VeterinaryUsePatientName = arcapp.hl7VeterinaryUsePatientName;
        this.hl7PatientArrivalMessageType = arcapp.hl7PatientArrivalMessageType;
        this.hl7ORUAction = arcapp.hl7ORUAction;
        this.mwlWorklistLabel = arcapp.mwlWorklistLabel;
        this.mwlAccessionNumberGenerator = arcapp.mwlAccessionNumberGenerator;
        this.mwlRequestedProcedureIDGenerator = arcapp.mwlRequestedProcedureIDGenerator;
        this.mwlScheduledProcedureStepIDGenerator = arcapp.mwlScheduledProcedureStepIDGenerator;
        this.auditHL7MsgLimit = arcapp.auditHL7MsgLimit;
        this.hl7ExportRules.clear();
        this.hl7ExportRules.addAll(arcapp.hl7ExportRules);
        this.hl7PrefetchRules.clear();
        this.hl7PrefetchRules.addAll(arcapp.hl7PrefetchRules);
        this.upsOnHL7List.clear();
        this.upsOnHL7List.addAll(arcapp.upsOnHL7List);
        this.hl7ForwardRules.clear();
        this.hl7ForwardRules.addAll(arcapp.hl7ForwardRules);
        this.hl7OrderScheduledStations.clear();
        this.hl7OrderScheduledStations.addAll(arcapp.hl7OrderScheduledStations);
        this.hl7StudyRetentionPolicies.clear();
        this.hl7StudyRetentionPolicies.addAll(arcapp.hl7StudyRetentionPolicies);
        this.hl7OrderSPSStatuses.clear();
        this.hl7OrderSPSStatuses.putAll(arcapp.hl7OrderSPSStatuses);
        this.hl7NoPatientCreateMessageTypes.clear();
        this.hl7NoPatientCreateMessageTypes.addAll(arcapp.hl7NoPatientCreateMessageTypes);
        this.importReportTemplateParams.clear();
        this.importReportTemplateParams.putAll(arcapp.importReportTemplateParams);
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public Boolean getRecordAttributeModification() {
        return this.recordAttributeModification;
    }

    public void setRecordAttributeModification(Boolean recordAttributeModification) {
        this.recordAttributeModification = recordAttributeModification;
    }

    public boolean recordAttributeModification() {
        return this.recordAttributeModification != null ? this.recordAttributeModification.booleanValue() : this.getArchiveDeviceExtension().isRecordAttributeModification();
    }

    public String getPatientUpdateTemplateURI() {
        return this.patientUpdateTemplateURI;
    }

    public void setPatientUpdateTemplateURI(String patientUpdateTemplateURI) {
        this.patientUpdateTemplateURI = patientUpdateTemplateURI;
    }

    public String patientUpdateTemplateURI() {
        return this.patientUpdateTemplateURI != null ? this.patientUpdateTemplateURI : this.getArchiveDeviceExtension().getPatientUpdateTemplateURI();
    }

    public String getImportReportTemplateURI() {
        return this.importReportTemplateURI;
    }

    public void setImportReportTemplateURI(String importReportTemplateURI) {
        this.importReportTemplateURI = importReportTemplateURI;
    }

    public String importReportTemplateURI() {
        return this.importReportTemplateURI != null ? this.importReportTemplateURI : this.getArchiveDeviceExtension().getImportReportTemplateURI();
    }

    public String getScheduleProcedureTemplateURI() {
        return this.scheduleProcedureTemplateURI;
    }

    public void setScheduleProcedureTemplateURI(String scheduleProcedureTemplateURI) {
        this.scheduleProcedureTemplateURI = scheduleProcedureTemplateURI;
    }

    public String scheduleProcedureTemplateURI() {
        return this.scheduleProcedureTemplateURI != null ? this.scheduleProcedureTemplateURI : this.getArchiveDeviceExtension().getScheduleProcedureTemplateURI();
    }

    public String getHL7LogFilePattern() {
        return this.hl7LogFilePattern;
    }

    public void setHL7LogFilePattern(String hl7LogFilePattern) {
        this.hl7LogFilePattern = hl7LogFilePattern;
    }

    public String hl7LogFilePattern() {
        return this.hl7LogFilePattern != null ? this.hl7LogFilePattern : this.getArchiveDeviceExtension().getHL7LogFilePattern();
    }

    public String getHL7ErrorLogFilePattern() {
        return this.hl7ErrorLogFilePattern;
    }

    public void setHL7ErrorLogFilePattern(String hl7ErrorLogFilePattern) {
        this.hl7ErrorLogFilePattern = hl7ErrorLogFilePattern;
    }

    public String hl7ErrorLogFilePattern() {
        return this.hl7ErrorLogFilePattern != null ? this.hl7ErrorLogFilePattern : this.getArchiveDeviceExtension().getHL7ErrorLogFilePattern();
    }

    public String[] getHL7NoPatientCreateMessageTypes() {
        return this.hl7NoPatientCreateMessageTypes.toArray(new String[this.hl7NoPatientCreateMessageTypes.size()]);
    }

    public void setHL7NoPatientCreateMessageTypes(String ... messageTypes) {
        this.hl7NoPatientCreateMessageTypes.clear();
        for (String messageType : messageTypes) {
            this.hl7NoPatientCreateMessageTypes.add(messageType);
        }
    }

    public boolean isHL7NoPatientCreateMessageType(String messageType) {
        return this.hl7NoPatientCreateMessageTypes.isEmpty() ? this.getArchiveDeviceExtension().isHL7NoPatientCreateMessageType(messageType) : this.hl7NoPatientCreateMessageTypes.contains(messageType);
    }

    public Boolean getHL7UseNullValue() {
        return this.hl7UseNullValue;
    }

    public void setHL7UseNullValue(Boolean hl7UseNullValue) {
        this.hl7UseNullValue = hl7UseNullValue;
    }

    public boolean hl7UseNullValue() {
        return this.hl7UseNullValue != null ? this.hl7UseNullValue.booleanValue() : this.getArchiveDeviceExtension().isHL7UseNullValue();
    }

    public void removeHL7ExportRule(HL7ExportRule rule) {
        this.hl7ExportRules.remove(rule);
    }

    public void clearHL7ExportRules() {
        this.hl7ExportRules.clear();
    }

    public void addHL7ExportRule(HL7ExportRule rule) {
        this.hl7ExportRules.add(rule);
    }

    public Collection<HL7ExportRule> getHL7ExportRules() {
        return this.hl7ExportRules;
    }

    public Stream<HL7ExportRule> hl7ExportRules() {
        return Stream.concat(this.hl7ExportRules.stream(), this.getArchiveDeviceExtension().getHL7ExportRules().stream());
    }

    public boolean hasHL7ExportRules() {
        return !this.hl7ExportRules.isEmpty() || !this.getArchiveDeviceExtension().getHL7ExportRules().isEmpty();
    }

    public void removeHL7PrefetchRule(HL7PrefetchRule rule) {
        this.hl7PrefetchRules.remove(rule);
    }

    public void clearHL7PrefetchRules() {
        this.hl7PrefetchRules.clear();
    }

    public void addHL7PrefetchRule(HL7PrefetchRule rule) {
        this.hl7PrefetchRules.add(rule);
    }

    public Collection<HL7PrefetchRule> getHL7PrefetchRules() {
        return this.hl7PrefetchRules;
    }

    public Stream<HL7PrefetchRule> hl7PrefetchRules() {
        return Stream.concat(this.hl7PrefetchRules.stream(), this.getArchiveDeviceExtension().getHL7PrefetchRules().stream());
    }

    public boolean hasHL7PrefetchRules() {
        return !this.hl7PrefetchRules.isEmpty() || !this.getArchiveDeviceExtension().getHL7PrefetchRules().isEmpty();
    }

    public void removeUPSOnHL7(UPSOnHL7 rule) {
        this.upsOnHL7List.remove(rule);
    }

    public void clearUPSOnHL7List() {
        this.upsOnHL7List.clear();
    }

    public void addUPSOnHL7(UPSOnHL7 rule) {
        this.upsOnHL7List.add(rule);
    }

    public Collection<UPSOnHL7> listUPSOnHL7() {
        return this.upsOnHL7List;
    }

    public Stream<UPSOnHL7> upsOnHL7Stream() {
        return Stream.concat(this.upsOnHL7List.stream(), this.getArchiveDeviceExtension().listUPSOnHL7().stream());
    }

    public boolean hasUPSOnHL7() {
        return !this.upsOnHL7List.isEmpty() || !this.getArchiveDeviceExtension().listUPSOnHL7().isEmpty();
    }

    public void removeHL7ForwardRule(HL7ForwardRule rule) {
        this.hl7ForwardRules.remove(rule);
    }

    public void clearHL7ForwardRules() {
        this.hl7ForwardRules.clear();
    }

    public void addHL7ForwardRule(HL7ForwardRule rule) {
        this.hl7ForwardRules.add(rule);
    }

    public Collection<HL7ForwardRule> getHL7ForwardRules() {
        return this.hl7ForwardRules;
    }

    public Stream<HL7ForwardRule> hl7ForwardRules() {
        return Stream.concat(this.hl7ForwardRules.stream(), this.getArchiveDeviceExtension().getHL7ForwardRules().stream());
    }

    public boolean hasHL7ForwardRules() {
        return !this.hl7ForwardRules.isEmpty() || !this.getArchiveDeviceExtension().getHL7ForwardRules().isEmpty();
    }

    public void removeHL7OrderScheduledStation(HL7OrderScheduledStation rule) {
        this.hl7OrderScheduledStations.remove(rule);
    }

    public void clearHL7OrderScheduledStations() {
        this.hl7OrderScheduledStations.clear();
    }

    public void addHL7OrderScheduledStation(HL7OrderScheduledStation rule) {
        this.hl7OrderScheduledStations.add(rule);
    }

    public Collection<HL7OrderScheduledStation> getHL7OrderScheduledStations() {
        return this.hl7OrderScheduledStations;
    }

    public Collection<Device> hl7OrderScheduledStation(String hostName, HL7Fields hl7Fields) {
        ArrayList<Device> scheduledStations = new ArrayList<Device>();
        int priority = 0;
        for (Collection stations : new Collection[]{scheduledStations, this.getArchiveDeviceExtension().getHL7OrderScheduledStations()}) {
            for (HL7OrderScheduledStation station : stations) {
                if (!station.match(hostName, hl7Fields) || priority > station.getPriority()) continue;
                if (priority < station.getPriority()) {
                    priority = station.getPriority();
                    scheduledStations.clear();
                }
                scheduledStations.add(station.getDevice());
            }
        }
        return scheduledStations;
    }

    public void removeHL7StudyRetentionPolicy(HL7StudyRetentionPolicy policy) {
        this.hl7StudyRetentionPolicies.remove(policy);
    }

    public void clearHL7StudyRetentionPolicies() {
        this.hl7StudyRetentionPolicies.clear();
    }

    public void addHL7StudyRetentionPolicy(HL7StudyRetentionPolicy policy) {
        this.hl7StudyRetentionPolicies.add(policy);
    }

    public Collection<HL7StudyRetentionPolicy> getHL7StudyRetentionPolicies() {
        return this.hl7StudyRetentionPolicies;
    }

    public Stream<HL7StudyRetentionPolicy> hl7StudyRetentionPolicies() {
        return Stream.concat(this.hl7StudyRetentionPolicies.stream(), this.getArchiveDeviceExtension().getHL7StudyRetentionPolicies().stream());
    }

    public boolean hasHL7StudyRetentionPolicies() {
        return !this.hl7StudyRetentionPolicies.isEmpty() || !this.getArchiveDeviceExtension().getHL7StudyRetentionPolicies().isEmpty();
    }

    public void removeHL7OrderSPSStatus(HL7OrderSPSStatus rule) {
        this.hl7OrderSPSStatuses.remove((Object)rule.getSPSStatus());
    }

    public void clearHL7OrderSPSStatuses() {
        this.hl7OrderSPSStatuses.clear();
    }

    public void addHL7OrderSPSStatus(HL7OrderSPSStatus rule) {
        this.hl7OrderSPSStatuses.put(rule.getSPSStatus(), rule);
    }

    public Map<SPSStatus, HL7OrderSPSStatus> getHL7OrderSPSStatuses() {
        return this.hl7OrderSPSStatuses;
    }

    public Collection<HL7OrderSPSStatus> hl7OrderSPSStatuses() {
        return (this.hl7OrderSPSStatuses.isEmpty() ? this.getArchiveDeviceExtension().getHL7OrderSPSStatuses() : this.hl7OrderSPSStatuses).values();
    }

    public ScheduledProtocolCodeInOrder getHL7ScheduledProtocolCodeInOrder() {
        return this.hl7ScheduledProtocolCodeInOrder;
    }

    public void setHL7ScheduledProtocolCodeInOrder(ScheduledProtocolCodeInOrder hl7ScheduledProtocolCodeInOrder) {
        this.hl7ScheduledProtocolCodeInOrder = hl7ScheduledProtocolCodeInOrder;
    }

    public ScheduledProtocolCodeInOrder hl7ScheduledProtocolCodeInOrder() {
        return this.hl7ScheduledProtocolCodeInOrder != null ? this.hl7ScheduledProtocolCodeInOrder : this.getArchiveDeviceExtension().getHL7ScheduledProtocolCodeInOrder();
    }

    public ScheduledStationAETInOrder getHL7ScheduledStationAETInOrder() {
        return this.hl7ScheduledStationAETInOrder;
    }

    public void setHL7ScheduledStationAETInOrder(ScheduledStationAETInOrder hl7ScheduledStationAETInOrder) {
        this.hl7ScheduledStationAETInOrder = hl7ScheduledStationAETInOrder;
    }

    public ScheduledStationAETInOrder hl7ScheduledStationAETInOrder() {
        return this.hl7ScheduledStationAETInOrder != null ? this.hl7ScheduledStationAETInOrder : this.getArchiveDeviceExtension().getHL7ScheduledStationAETInOrder();
    }

    public Map<String, String> importReportTemplateParams() {
        return !this.importReportTemplateParams.isEmpty() ? this.importReportTemplateParams : this.getArchiveDeviceExtension().getImportReportTemplateParams();
    }

    public Map<String, String> getImportReportTemplateParams() {
        return this.importReportTemplateParams;
    }

    public void setImportReportTemplateParam(String name, String value) {
        this.importReportTemplateParams.put(name, value);
    }

    public void setImportReportTemplateParams(String[] ss) {
        this.importReportTemplateParams.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("XSLT parameter in incorrect format : " + s);
            }
            this.setImportReportTemplateParam(s.substring(0, index), s.substring(index + 1));
        }
    }

    public HL7OrderMissingStudyIUIDPolicy hl7OrderMissingStudyIUIDPolicy() {
        return this.hl7OrderMissingStudyIUIDPolicy != null ? this.hl7OrderMissingStudyIUIDPolicy : this.getArchiveDeviceExtension().getHl7OrderMissingStudyIUIDPolicy();
    }

    public HL7OrderMissingStudyIUIDPolicy getHL7OrderMissingStudyIUIDPolicy() {
        return this.hl7OrderMissingStudyIUIDPolicy;
    }

    public void setHL7OrderMissingStudyIUIDPolicy(HL7OrderMissingStudyIUIDPolicy hl7OrderMissingStudyIUIDPolicy) {
        this.hl7OrderMissingStudyIUIDPolicy = hl7OrderMissingStudyIUIDPolicy;
    }

    public HL7OrderMissingAdmissionIDPolicy hl7OrderMissingAdmissionIDPolicy() {
        return this.hl7OrderMissingAdmissionIDPolicy != null ? this.hl7OrderMissingAdmissionIDPolicy : this.getArchiveDeviceExtension().getHl7OrderMissingAdmissionIDPolicy();
    }

    public HL7OrderMissingAdmissionIDPolicy getHl7OrderMissingAdmissionIDPolicy() {
        return this.hl7OrderMissingAdmissionIDPolicy;
    }

    public void setHl7OrderMissingAdmissionIDPolicy(HL7OrderMissingAdmissionIDPolicy hl7OrderMissingAdmissionIDPolicy) {
        this.hl7OrderMissingAdmissionIDPolicy = hl7OrderMissingAdmissionIDPolicy;
    }

    public HL7ImportReportMissingStudyIUIDPolicy hl7ImportReportMissingStudyIUIDPolicy() {
        return this.hl7ImportReportMissingStudyIUIDPolicy != null ? this.hl7ImportReportMissingStudyIUIDPolicy : this.getArchiveDeviceExtension().getHl7ImportReportMissingStudyIUIDPolicy();
    }

    public HL7ImportReportMissingStudyIUIDPolicy getHl7ImportReportMissingStudyIUIDPolicy() {
        return this.hl7ImportReportMissingStudyIUIDPolicy;
    }

    public void setHl7ImportReportMissingStudyIUIDPolicy(HL7ImportReportMissingStudyIUIDPolicy hl7ImportReportMissingStudyIUIDPolicy) {
        this.hl7ImportReportMissingStudyIUIDPolicy = hl7ImportReportMissingStudyIUIDPolicy;
    }

    public HL7ImportReportMissingAdmissionIDPolicy hl7ImportReportMissingAdmissionIDPolicy() {
        return this.hl7ImportReportMissingAdmissionIDPolicy != null ? this.hl7ImportReportMissingAdmissionIDPolicy : this.getArchiveDeviceExtension().getHl7ImportReportMissingAdmissionIDPolicy();
    }

    public HL7ImportReportMissingAdmissionIDPolicy getHl7ImportReportMissingAdmissionIDPolicy() {
        return this.hl7ImportReportMissingAdmissionIDPolicy;
    }

    public void setHl7ImportReportMissingAdmissionIDPolicy(HL7ImportReportMissingAdmissionIDPolicy hl7ImportReportMissingAdmissionIDPolicy) {
        this.hl7ImportReportMissingAdmissionIDPolicy = hl7ImportReportMissingAdmissionIDPolicy;
    }

    public String hl7ImportReportMissingStudyIUIDCFindSCP() {
        return this.hl7ImportReportMissingStudyIUIDCFindSCP != null ? this.hl7ImportReportMissingStudyIUIDCFindSCP : this.getArchiveDeviceExtension().getHl7ImportReportMissingStudyIUIDCFindSCP();
    }

    public String getHl7ImportReportMissingStudyIUIDCFindSCP() {
        return this.hl7ImportReportMissingStudyIUIDCFindSCP;
    }

    public void setHl7ImportReportMissingStudyIUIDCFindSCP(String hl7ImportReportMissingStudyIUIDCFindSCP) {
        this.hl7ImportReportMissingStudyIUIDCFindSCP = hl7ImportReportMissingStudyIUIDCFindSCP;
    }

    public HL7ImportReportAdjustIUID hl7ImportReportAdjustIUID() {
        return this.hl7ImportReportAdjustIUID != null ? this.hl7ImportReportAdjustIUID : this.getArchiveDeviceExtension().getHl7ImportReportAdjustIUID();
    }

    public HL7ImportReportAdjustIUID getHl7ImportReportAdjustIUID() {
        return this.hl7ImportReportAdjustIUID;
    }

    public void setHl7ImportReportAdjustIUID(HL7ImportReportAdjustIUID hl7ImportReportAdjustIUID) {
        this.hl7ImportReportAdjustIUID = hl7ImportReportAdjustIUID;
    }

    public HL7ReferredMergedPatientPolicy hl7ReferredMergedPatientPolicy() {
        return this.hl7ReferredMergedPatientPolicy != null ? this.hl7ReferredMergedPatientPolicy : this.getArchiveDeviceExtension().getHl7ReferredMergedPatientPolicy();
    }

    public HL7ReferredMergedPatientPolicy getHl7ReferredMergedPatientPolicy() {
        return this.hl7ReferredMergedPatientPolicy;
    }

    public void setHl7ReferredMergedPatientPolicy(HL7ReferredMergedPatientPolicy hl7ReferredMergedPatientPolicy) {
        this.hl7ReferredMergedPatientPolicy = hl7ReferredMergedPatientPolicy;
    }

    public String hl7DicomCharacterSet() {
        return this.hl7DicomCharacterSet != null ? this.hl7DicomCharacterSet : this.getArchiveDeviceExtension().getHl7DicomCharacterSet();
    }

    public String getHl7DicomCharacterSet() {
        return this.hl7DicomCharacterSet;
    }

    public void setHl7DicomCharacterSet(String hl7DicomCharacterSet) {
        this.hl7DicomCharacterSet = hl7DicomCharacterSet;
    }

    public Boolean getHl7VeterinaryUsePatientName() {
        return this.hl7VeterinaryUsePatientName;
    }

    public void setHl7VeterinaryUsePatientName(Boolean hl7VeterinaryUsePatientName) {
        this.hl7VeterinaryUsePatientName = hl7VeterinaryUsePatientName;
    }

    public boolean hl7VeterinaryUsePatientName() {
        return this.hl7VeterinaryUsePatientName != null ? this.hl7VeterinaryUsePatientName.booleanValue() : this.getArchiveDeviceExtension().isHl7VeterinaryUsePatientName();
    }

    public String getHL7PatientArrivalMessageType() {
        return this.hl7PatientArrivalMessageType;
    }

    public void setHL7PatientArrivalMessageType(String hl7PatientArrivalMessageType) {
        this.hl7PatientArrivalMessageType = hl7PatientArrivalMessageType;
    }

    public String hl7PatientArrivalMessageType() {
        return this.hl7PatientArrivalMessageType != null ? this.hl7PatientArrivalMessageType : this.getArchiveDeviceExtension().getHL7PatientArrivalMessageType();
    }

    public HL7ORUAction[] getHl7ORUAction() {
        return this.hl7ORUAction;
    }

    public void setHl7ORUAction(HL7ORUAction[] hl7ORUAction) {
        this.hl7ORUAction = hl7ORUAction;
    }

    public HL7ORUAction[] hl7ORUAction() {
        return this.hl7ORUAction.length > 0 ? this.hl7ORUAction : this.getArchiveDeviceExtension().getHl7ORUAction();
    }

    public String getMWLWorklistLabel() {
        return this.mwlWorklistLabel;
    }

    public void setMWLWorklistLabel(String mwlWorklistLabel) {
        this.mwlWorklistLabel = mwlWorklistLabel;
    }

    public String getMWLAccessionNumberGenerator() {
        return this.mwlAccessionNumberGenerator;
    }

    public void setMWLAccessionNumberGenerator(String mwlAccessionNumberGenerator) {
        this.mwlAccessionNumberGenerator = mwlAccessionNumberGenerator;
    }

    public String mwlAccessionNumberGenerator() {
        return this.mwlAccessionNumberGenerator != null ? this.mwlAccessionNumberGenerator : this.getArchiveDeviceExtension().getMWLAccessionNumberGenerator();
    }

    public String getMWLRequestedProcedureIDGenerator() {
        return this.mwlRequestedProcedureIDGenerator;
    }

    public void setMWLRequestedProcedureIDGenerator(String mwlRequestedProcedureIDGenerator) {
        this.mwlRequestedProcedureIDGenerator = mwlRequestedProcedureIDGenerator;
    }

    public String mwlRequestedProcedureIDGenerator() {
        return this.mwlRequestedProcedureIDGenerator != null ? this.mwlRequestedProcedureIDGenerator : this.getArchiveDeviceExtension().getMWLRequestedProcedureIDGenerator();
    }

    public String getMWLScheduledProcedureStepIDGenerator() {
        return this.mwlScheduledProcedureStepIDGenerator;
    }

    public void setMWLScheduledProcedureStepIDGenerator(String mwlScheduledProcedureStepIDGenerator) {
        this.mwlScheduledProcedureStepIDGenerator = mwlScheduledProcedureStepIDGenerator;
    }

    public String mwlScheduledProcedureStepIDGenerator() {
        return this.mwlScheduledProcedureStepIDGenerator != null ? this.mwlScheduledProcedureStepIDGenerator : this.getArchiveDeviceExtension().getMWLScheduledProcedureStepIDGenerator();
    }

    public Integer getAuditHL7MsgLimit() {
        return this.auditHL7MsgLimit;
    }

    public void setAuditHL7MsgLimit(Integer auditHL7MsgLimit) {
        this.auditHL7MsgLimit = auditHL7MsgLimit;
    }

    public int auditHL7MsgLimit() {
        return this.auditHL7MsgLimit != null ? this.auditHL7MsgLimit.intValue() : this.getArchiveDeviceExtension().getAuditHL7MsgLimit();
    }
}

