/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonValue;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.BasicBulkDataDescriptor;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.AcceptConflictingPatientID;
import org.dcm4chee.arc.conf.AcceptMissingPatientID;
import org.dcm4chee.arc.conf.AllowDeletePatient;
import org.dcm4chee.arc.conf.AllowDeleteStudyPermanently;
import org.dcm4chee.arc.conf.AllowRejectionForDataRetentionPolicyExpired;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.ArchiveCompressionRule;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.AttributeSet;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.ExportPriorsRule;
import org.dcm4chee.arc.conf.ExportRule;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.HL7ExportRule;
import org.dcm4chee.arc.conf.HL7ForwardRule;
import org.dcm4chee.arc.conf.HL7ImportReportAdjustIUID;
import org.dcm4chee.arc.conf.HL7ImportReportMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7ImportReportMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7ORUAction;
import org.dcm4chee.arc.conf.HL7OrderMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderSPSStatus;
import org.dcm4chee.arc.conf.HL7OrderScheduledStation;
import org.dcm4chee.arc.conf.HL7PSUMWLMatchingKey;
import org.dcm4chee.arc.conf.HL7PSUMessageType;
import org.dcm4chee.arc.conf.HL7PrefetchRule;
import org.dcm4chee.arc.conf.HL7ReferredMergedPatientPolicy;
import org.dcm4chee.arc.conf.HL7StudyRetentionPolicy;
import org.dcm4chee.arc.conf.IDGenerator;
import org.dcm4chee.arc.conf.MPPSForwardRule;
import org.dcm4chee.arc.conf.MWLIdleTimeout;
import org.dcm4chee.arc.conf.MWLImport;
import org.dcm4chee.arc.conf.MetricsDescriptor;
import org.dcm4chee.arc.conf.MultipleStoreAssociations;
import org.dcm4chee.arc.conf.OverwritePolicy;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.dcm4chee.arc.conf.RSForwardRule;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.conf.ScheduledProtocolCodeInOrder;
import org.dcm4chee.arc.conf.ScheduledStationAETInOrder;
import org.dcm4chee.arc.conf.ShowPatientInfo;
import org.dcm4chee.arc.conf.SpanningCFindSCPPolicy;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.conf.StoreAccessControlIDRule;
import org.dcm4chee.arc.conf.StudyRetentionPolicy;
import org.dcm4chee.arc.conf.UPSOnHL7;
import org.dcm4chee.arc.conf.UPSOnStore;
import org.dcm4chee.arc.conf.UPSOnUPSCompleted;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.conf.UserIdentityNegotiation;

public class ArchiveDeviceExtension
extends DeviceExtension {
    public static final String AUDIT_UNKNOWN_STUDY_INSTANCE_UID = "1.2.40.0.13.1.15.110.3.165.1";
    public static final String AUDIT_UNKNOWN_PATIENT_ID = "<none>";
    public static final String JBOSS_SERVER_TEMP_DIR = "${jboss.server.temp.dir}";
    public static final String DEFAULT_WADO_ZIP_ENTRY_NAME_FORMAT = "DICOM/{0020000D,hash}/{0020000E,hash}/{00080018,hash}.dcm";
    public static final String WADO_THUMBNAIL_VIEWPORT = "64,64";
    public static final String MWL_ACCESSION_NUMBER_GENERATOR = "AccessionNumber";
    public static final String MWL_REQUESTED_PROCEDURE_ID_GENERATOR = "RequestedProcedureID";
    public static final String MWL_SCHEDULED_PROCEDURE_STEP_ID_GENERATOR = "ScheduledProcedureStepID";
    private volatile String defaultCharacterSet;
    private volatile String upsWorklistLabel;
    private volatile String[] upsEventSCUs = new String[0];
    private volatile int upsEventSCUKeepAlive;
    private volatile boolean upsUpdateWithoutTransactionUID;
    private volatile String fuzzyAlgorithmClass;
    private volatile String bulkDataDescriptorID;
    private volatile String[] seriesMetadataStorageIDs = new String[0];
    private volatile Duration seriesMetadataDelay;
    private volatile Duration seriesMetadataPollingInterval;
    private volatile int seriesMetadataFetchSize = 100;
    private volatile int seriesMetadataThreads = 1;
    private volatile int seriesMetadataMaxRetries = 0;
    private volatile Duration seriesMetadataRetryInterval;
    private volatile boolean purgeInstanceRecords;
    private volatile Duration purgeInstanceRecordsDelay;
    private volatile Duration purgeInstanceRecordsPollingInterval;
    private volatile int purgeInstanceRecordsFetchSize = 100;
    private volatile Duration deleteUPSPollingInterval;
    private volatile int deleteUPSFetchSize = 100;
    private volatile Duration deleteUPSCompletedDelay;
    private volatile Duration deleteUPSCanceledDelay;
    private volatile Duration upsProcessingPollingInterval;
    private volatile int upsProcessingFetchSize = 100;
    private volatile Duration taskPollingInterval;
    private volatile int taskFetchSize = 100;
    private volatile OverwritePolicy overwritePolicy = OverwritePolicy.NEVER;
    private volatile boolean recordAttributeModification = true;
    private volatile ShowPatientInfo showPatientInfoInSystemLog = ShowPatientInfo.PLAIN_TEXT;
    private volatile ShowPatientInfo showPatientInfoInAuditLog = ShowPatientInfo.PLAIN_TEXT;
    private volatile String bulkDataSpoolDirectory = "${jboss.server.temp.dir}";
    private volatile boolean validateCallingAEHostname = false;
    private volatile boolean sendPendingCGet = false;
    private volatile Duration sendPendingCMoveInterval;
    private volatile boolean personNameComponentOrderInsensitiveMatching = false;
    private volatile int queryFetchSize = 100;
    private volatile int queryMaxNumberOfResults = 0;
    private volatile int qidoMaxNumberOfResults = 0;
    private volatile boolean qidoETag = false;
    private volatile boolean filterByIssuerOfPatientID = false;
    private volatile boolean matchSOPClassOnInstanceLevel = false;
    private volatile boolean wadoMetadataWithoutPrivate = false;
    private volatile boolean wadoIgnorePresentationLUTShape = false;
    private volatile String wadoThumbnailViewPort = "64,64";
    private volatile String wadoZIPEntryNameFormat = "DICOM/{0020000D,hash}/{0020000E,hash}/{00080018,hash}.dcm";
    private volatile String wadoSR2HtmlTemplateURI;
    private volatile String wadoSR2TextTemplateURI;
    private volatile String wadoCDA2HtmlTemplateURI;
    private volatile String patientUpdateTemplateURI;
    private volatile String importReportTemplateURI;
    private volatile String scheduleProcedureTemplateURI;
    private volatile String unzipVendorDataToURI;
    private volatile String outgoingPatientUpdateTemplateURI;
    private volatile String[] mppsForwardDestinations = new String[0];
    private volatile String[] ianDestinations = new String[0];
    private volatile Duration ianDelay;
    private volatile Duration ianTimeout;
    private volatile boolean ianOnTimeout;
    private volatile Duration ianTaskPollingInterval;
    private volatile int ianTaskFetchSize = 100;
    private volatile String spanningCFindSCP;
    private volatile String[] spanningCFindSCPRetrieveAETitles = new String[0];
    private volatile SpanningCFindSCPPolicy spanningCFindSCPPolicy = SpanningCFindSCPPolicy.REPLACE;
    private volatile String fallbackCMoveSCP;
    private volatile String fallbackCMoveSCPDestination;
    private volatile String fallbackCMoveSCPCallingAET;
    private volatile String fallbackCMoveSCPLeadingCFindSCP;
    private volatile int fallbackCMoveSCPRetries;
    private volatile String fallbackWadoURIWebApplication;
    private volatile int fallbackWadoURIHttpStatusCode = 303;
    private volatile String externalRetrieveAEDestination;
    private volatile String xdsiImagingDocumentSourceAETitle;
    private volatile String alternativeCMoveSCP;
    private volatile boolean retrieveTaskWarningOnNoMatch;
    private volatile boolean retrieveTaskWarningOnWarnings;
    private volatile Duration deleteRejectedPollingInterval;
    private volatile int deleteRejectedFetchSize = 100;
    private volatile Duration purgeStoragePollingInterval;
    private volatile int purgeStorageFetchSize = 100;
    private volatile int deleteStudyBatchSize = 10;
    private volatile int deleteStudyChunkSize = 100;
    private volatile boolean deletePatientOnDeleteLastStudy = false;
    private volatile Duration failedToDeletePollingInterval;
    private volatile int failedToDeleteFetchSize = 100;
    private volatile Duration maxAccessTimeStaleness;
    private volatile Duration aeCacheStaleTimeout;
    private volatile Duration leadingCFindSCPQueryCacheStaleTimeout;
    private volatile int leadingCFindSCPQueryCacheSize = 10;
    private volatile String auditSpoolDirectory = "${jboss.server.temp.dir}";
    private volatile Duration auditPollingInterval;
    private volatile Duration auditAggregateDuration;
    private volatile String stowSpoolDirectory = "${jboss.server.temp.dir}";
    private volatile String wadoSpoolDirectory = "${jboss.server.temp.dir}";
    private volatile Duration purgeTaskPollingInterval;
    private volatile Duration purgeStgCmtPollingInterval;
    private volatile Duration purgeStgCmtCompletedDelay;
    private volatile Duration keyValueRetentionPollingInterval;
    private volatile int keyValueRetentionFetchSize = 100;
    private volatile Duration keyValueRetentionPeriod;
    private volatile Duration mwlPollingInterval;
    private volatile int mwlFetchSize = 100;
    private volatile Duration mwlImportInterval;
    private volatile String[] deleteMWLDelay = new String[0];
    private volatile SPSStatus[] hideSPSWithStatusFrom = new SPSStatus[0];
    private volatile SPSStatus[] hideSPSWithStatusFromMWLRS = new SPSStatus[0];
    private volatile HL7ORUAction[] hl7ORUAction = new HL7ORUAction[0];
    private volatile String mwlAccessionNumberGenerator = "AccessionNumber";
    private volatile String mwlRequestedProcedureIDGenerator = "RequestedProcedureID";
    private volatile String mwlScheduledProcedureStepIDGenerator = "ScheduledProcedureStepID";
    private volatile String hl7LogFilePattern;
    private volatile String hl7ErrorLogFilePattern;
    private volatile Duration rejectExpiredStudiesPollingInterval;
    private volatile ScheduleExpression[] rejectExpiredStudiesSchedules = new ScheduleExpression[0];
    private volatile int rejectExpiredStudiesFetchSize = 0;
    private volatile int rejectExpiredSeriesFetchSize = 0;
    private volatile String rejectExpiredStudiesAETitle;
    private volatile String fallbackCMoveSCPStudyOlderThan;
    private volatile String storePermissionServiceURL;
    private volatile String storePermissionServiceResponse;
    private volatile Pattern storePermissionServiceResponsePattern;
    private volatile Pattern storePermissionServiceExpirationDatePattern;
    private volatile Pattern storePermissionServiceErrorCommentPattern;
    private volatile Pattern storePermissionServiceErrorCodePattern;
    private volatile Duration storePermissionCacheStaleTimeout;
    private volatile int storePermissionCacheSize = 10;
    private volatile Duration mergeMWLCacheStaleTimeout;
    private volatile int mergeMWLCacheSize = 10;
    private volatile int storeUpdateDBMaxRetries = 3;
    private volatile int storeUpdateDBMaxRetryDelay = 1000;
    private volatile int storeUpdateDBMinRetryDelay = 500;
    private volatile AllowRejectionForDataRetentionPolicyExpired allowRejectionForDataRetentionPolicyExpired = AllowRejectionForDataRetentionPolicyExpired.EXPIRED_UNSET;
    private volatile AcceptMissingPatientID acceptMissingPatientID = AcceptMissingPatientID.CREATE;
    private volatile AllowDeletePatient allowDeletePatient = AllowDeletePatient.WITHOUT_STUDIES;
    private volatile AllowDeleteStudyPermanently allowDeleteStudyPermanently = AllowDeleteStudyPermanently.REJECTED;
    private volatile AcceptConflictingPatientID acceptConflictingPatientID = AcceptConflictingPatientID.MERGED;
    private volatile UserIdentityNegotiation userIdentityNegotiation = UserIdentityNegotiation.SUPPORTS;
    private volatile String userIdentityNegotiationRole;
    private volatile String userIdentityNegotiationKeycloakClientID;
    private volatile String[] retrieveAETitles = new String[0];
    private volatile String[] returnRetrieveAETitles = new String[0];
    private volatile String remapRetrieveURL;
    private volatile String remapRetrieveURLClientHost;
    private volatile String hl7PSUSendingApplication;
    private volatile String[] hl7PSUReceivingApplications = new String[0];
    private volatile Duration hl7PSUDelay;
    private volatile Duration hl7PSUTimeout;
    private volatile boolean hl7PSUOnTimeout;
    private volatile int hl7PSUTaskFetchSize = 100;
    private volatile Duration hl7PSUTaskPollingInterval;
    private volatile boolean hl7PSUMWL = false;
    private volatile HL7PSUMWLMatchingKey hl7PSUMWLMatchingKey = HL7PSUMWLMatchingKey.StudyInstanceUID;
    private volatile boolean hl7PSUForRequestedProcedure = false;
    private volatile boolean hl7PSUPIDPV1 = false;
    private volatile String hl7PSURequestedProcedureID;
    private volatile String hl7PSUAccessionNumber;
    private volatile String hl7PSUFillerOrderNumber;
    private volatile String hl7PSUPlacerOrderNumber;
    private volatile HL7PSUMessageType hl7PSUMessageType = HL7PSUMessageType.OMG_O19;
    private volatile Conditions hl7PSUConditions = new Conditions(new String[0]);
    private volatile String hl7PSUMppsTemplateURI;
    private volatile String hl7PSUStudyTemplateURI;
    private volatile String proxyUpstreamURL;
    private volatile String atna2JsonFhirTemplateURI;
    private volatile String atna2XmlFhirTemplateURI;
    private volatile Attributes.UpdatePolicy copyMoveUpdatePolicy = Attributes.UpdatePolicy.PRESERVE;
    private volatile Attributes.UpdatePolicy linkMWLEntryUpdatePolicy = Attributes.UpdatePolicy.PRESERVE;
    private volatile boolean hl7TrackChangedPatientID = true;
    private volatile boolean auditSoftwareConfigurationVerbose = false;
    private volatile boolean hl7UseNullValue = false;
    private volatile boolean hl7AppendHashOfStudyInstanceUIDToSeriesAndSOPInstanceUID;
    private volatile String[] hl7ADTReceivingApplication = new String[0];
    private volatile String hl7ADTSendingApplication;
    private volatile int queueTasksFetchSize = 100;
    private volatile int auditHL7MsgLimit = 1000;
    private volatile ScheduledProtocolCodeInOrder hl7ScheduledProtocolCodeInOrder = ScheduledProtocolCodeInOrder.OBR_4_4;
    private volatile ScheduledStationAETInOrder hl7ScheduledStationAETInOrder;
    private volatile String auditUnknownStudyInstanceUID = "1.2.40.0.13.1.15.110.3.165.1";
    private volatile String auditUnknownPatientID = "<none>";
    private volatile String rejectionNoteStorageAET;
    private volatile String uiConfigurationDeviceName;
    private volatile StorageVerificationPolicy storageVerificationPolicy = StorageVerificationPolicy.OBJECT_CHECKSUM;
    private volatile boolean storageVerificationUpdateLocationStatus;
    private volatile String[] storageVerificationStorageIDs = new String[0];
    private volatile String storageVerificationAETitle;
    private volatile String storageVerificationBatchID;
    private volatile Period storageVerificationInitialDelay;
    private volatile Period storageVerificationPeriod;
    private volatile int storageVerificationMaxScheduled;
    private volatile Duration storageVerificationPollingInterval;
    private volatile ScheduleExpression[] storageVerificationSchedules = new ScheduleExpression[0];
    private volatile int storageVerificationFetchSize = 100;
    private volatile boolean updateLocationStatusOnRetrieve;
    private volatile boolean storageVerificationOnRetrieve;
    private volatile String compressionAETitle;
    private volatile Duration compressionPollingInterval;
    private volatile int compressionFetchSize = 100;
    private volatile int compressionThreads = 1;
    private volatile ScheduleExpression[] compressionSchedules = new ScheduleExpression[0];
    private volatile Duration diffTaskProgressUpdateInterval;
    private volatile String patientVerificationPDQServiceID;
    private volatile Duration patientVerificationPollingInterval;
    private volatile int patientVerificationFetchSize = 100;
    private volatile Duration patientVerificationMaxStaleness;
    private volatile Period patientVerificationPeriod;
    private volatile Period patientVerificationPeriodOnNotFound;
    private volatile Duration patientVerificationRetryInterval;
    private volatile int patientVerificationMaxRetries;
    private volatile boolean patientVerificationAdjustIssuerOfPatientID;
    private volatile HL7OrderMissingStudyIUIDPolicy hl7OrderMissingStudyIUIDPolicy = HL7OrderMissingStudyIUIDPolicy.GENERATE;
    private volatile HL7OrderMissingAdmissionIDPolicy hl7OrderMissingAdmissionIDPolicy = HL7OrderMissingAdmissionIDPolicy.ACCEPT;
    private volatile HL7ImportReportMissingAdmissionIDPolicy hl7ImportReportMissingAdmissionIDPolicy = HL7ImportReportMissingAdmissionIDPolicy.ACCEPT;
    private volatile HL7ImportReportMissingStudyIUIDPolicy hl7ImportReportMissingStudyIUIDPolicy = HL7ImportReportMissingStudyIUIDPolicy.GENERATE;
    private volatile String hl7ImportReportMissingStudyIUIDCFindSCP;
    private volatile HL7ImportReportAdjustIUID hl7ImportReportAdjustIUID = HL7ImportReportAdjustIUID.NONE;
    private volatile HL7ReferredMergedPatientPolicy hl7ReferredMergedPatientPolicy = HL7ReferredMergedPatientPolicy.REJECT;
    private volatile String hl7DicomCharacterSet;
    private volatile boolean hl7VeterinaryUsePatientName;
    private volatile String hl7PatientArrivalMessageType;
    private volatile int csvUploadChunkSize = 100;
    private volatile boolean validateUID = true;
    private volatile boolean relationalQueryNegotiationLenient;
    private volatile boolean relationalRetrieveNegotiationLenient;
    private volatile int[] rejectConflictingPatientAttribute = new int[0];
    private volatile int schedulerMinStartDelay = 60;
    private volatile boolean stowRetiredTransferSyntax;
    private volatile boolean stowExcludeAPPMarkers;
    private volatile boolean restrictRetrieveSilently;
    private volatile boolean stowQuicktime2MP4;
    private volatile long stowMaxFragmentLength = 0x7FFFFFFEL;
    private volatile boolean identifyPatientByAllAttributes;
    private volatile String changeRequesterAET;
    private volatile MultipleStoreAssociations[] multipleStoreAssociations = new MultipleStoreAssociations[0];
    private volatile Duration studySizeDelay;
    private volatile Duration calculateStudySizePollingInterval;
    private volatile int calculateStudySizeFetchSize = 100;
    private volatile boolean calculateQueryAttributes;
    private volatile boolean storeImplementationVersionName = true;
    private volatile int supplementIssuerFetchSize = 100;
    private volatile int updateCharsetFetchSize = 100;
    private volatile Issuer auditAssigningAuthorityOfPatientID;
    private final EnumSet<VR> encodeAsJSONNumber = EnumSet.noneOf(VR.class);
    private final HashSet<String> wadoSupportedSRClasses = new HashSet();
    private final HashSet<String> wadoSupportedPRClasses = new HashSet();
    private final EnumMap<Entity, AttributeFilter> attributeFilters = new EnumMap(Entity.class);
    private final Map<AttributeSet.Type, Map<String, AttributeSet>> attributeSet = new EnumMap<AttributeSet.Type, Map<String, AttributeSet>>(AttributeSet.Type.class);
    private final Map<String, BasicBulkDataDescriptor> bulkDataDescriptorMap = new HashMap<String, BasicBulkDataDescriptor>();
    private final Map<String, IDGenerator> idGenerators = new HashMap<String, IDGenerator>();
    private final Map<String, QueryRetrieveView> queryRetrieveViewMap = new HashMap<String, QueryRetrieveView>();
    private final Map<String, StorageDescriptor> storageDescriptorMap = new HashMap<String, StorageDescriptor>();
    private final Map<String, QueueDescriptor> queueDescriptorMap = new HashMap<String, QueueDescriptor>();
    private final Map<String, MetricsDescriptor> metricsDescriptorMap = new HashMap<String, MetricsDescriptor>();
    private final Map<String, ExporterDescriptor> exporterDescriptorMap = new HashMap<String, ExporterDescriptor>();
    private final Map<String, PDQServiceDescriptor> pdqServiceDescriptorMap = new HashMap<String, PDQServiceDescriptor>();
    private final Map<String, RejectionNote> rejectionNoteMap = new HashMap<String, RejectionNote>();
    private final List<UPSOnStore> upsOnStoreList = new ArrayList<UPSOnStore>();
    private final List<UPSOnHL7> upsOnHL7List = new ArrayList<UPSOnHL7>();
    private final List<UPSOnUPSCompleted> upsOnUPSCompletedList = new ArrayList<UPSOnUPSCompleted>();
    private final List<UPSProcessingRule> upsProcessingRuleList = new ArrayList<UPSProcessingRule>();
    private final List<ExportRule> exportRules = new ArrayList<ExportRule>();
    private final List<ExportPriorsRule> exportPriorsRules = new ArrayList<ExportPriorsRule>();
    private final List<MPPSForwardRule> mppsForwardRule = new ArrayList<MPPSForwardRule>();
    private final List<HL7ExportRule> hl7ExportRules = new ArrayList<HL7ExportRule>();
    private final List<HL7PrefetchRule> hl7PrefetchRules = new ArrayList<HL7PrefetchRule>();
    private final List<RSForwardRule> rsForwardRules = new ArrayList<RSForwardRule>();
    private final List<HL7ForwardRule> hl7ForwardRules = new ArrayList<HL7ForwardRule>();
    private final List<HL7OrderScheduledStation> hl7OrderScheduledStations = new ArrayList<HL7OrderScheduledStation>();
    private final EnumMap<SPSStatus, HL7OrderSPSStatus> hl7OrderSPSStatuses = new EnumMap(SPSStatus.class);
    private final List<ArchiveCompressionRule> compressionRules = new ArrayList<ArchiveCompressionRule>();
    private final List<StudyRetentionPolicy> studyRetentionPolicies = new ArrayList<StudyRetentionPolicy>();
    private final List<HL7StudyRetentionPolicy> hl7StudyRetentionPolicies = new ArrayList<HL7StudyRetentionPolicy>();
    private final List<ArchiveAttributeCoercion> attributeCoercions = new ArrayList<ArchiveAttributeCoercion>();
    private final List<ArchiveAttributeCoercion2> attributeCoercions2 = new ArrayList<ArchiveAttributeCoercion2>();
    private final List<StoreAccessControlIDRule> storeAccessControlIDRules = new ArrayList<StoreAccessControlIDRule>();
    private final List<MWLIdleTimeout> mwlIdleTimeoutList = new ArrayList<MWLIdleTimeout>();
    private final List<MWLImport> mwlImportList = new ArrayList<MWLImport>();
    private final LinkedHashSet<String> hl7NoPatientCreateMessageTypes = new LinkedHashSet();
    private final Map<String, String> xRoadProperties = new HashMap<String, String>();
    private final Map<String, String> impaxReportProperties = new HashMap<String, String>();
    private final Map<String, String> importReportTemplateParams = new HashMap<String, String>();
    private final Map<String, String> hl7PSUTemplateParams = new HashMap<String, String>();
    private final Map<String, String> cStoreSCUOfCMoveSCP = new HashMap<String, String>();
    private final Map<String, String> dicomCharsetNameMappings = new HashMap<String, String>();
    private final Map<String, String> hl7CharsetNameMappings = new HashMap<String, String>();
    private final Map<String, Integer> upsEventWebSocketQueueSizes = new HashMap<String, Integer>();
    private transient FuzzyStr fuzzyStr;

    public String getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public void setDefaultCharacterSet(String defaultCharacterSet) {
        this.defaultCharacterSet = defaultCharacterSet;
    }

    public String getUPSWorklistLabel() {
        return this.upsWorklistLabel;
    }

    public void setUPSWorklistLabel(String upsWorklistLabel) {
        this.upsWorklistLabel = upsWorklistLabel;
    }

    public String[] getUPSEventSCUs() {
        return this.upsEventSCUs;
    }

    public void setUPSEventSCUs(String[] upsEventSCUs) {
        this.upsEventSCUs = upsEventSCUs;
    }

    public int getUPSEventSCUKeepAlive() {
        return this.upsEventSCUKeepAlive;
    }

    public void setUPSEventSCUKeepAlive(int upsEventSCUKeepAlive) {
        this.upsEventSCUKeepAlive = upsEventSCUKeepAlive;
    }

    public boolean isUPSUpdateWithoutTransactionUID() {
        return this.upsUpdateWithoutTransactionUID;
    }

    public void setUPSUpdateWithoutTransactionUID(boolean upsUpdateWithoutTransactionUID) {
        this.upsUpdateWithoutTransactionUID = upsUpdateWithoutTransactionUID;
    }

    public String getFuzzyAlgorithmClass() {
        return this.fuzzyAlgorithmClass;
    }

    public void setFuzzyAlgorithmClass(String fuzzyAlgorithmClass) {
        this.fuzzyStr = ArchiveDeviceExtension.fuzzyStr(fuzzyAlgorithmClass);
        this.fuzzyAlgorithmClass = fuzzyAlgorithmClass;
    }

    public FuzzyStr getFuzzyStr() {
        if (this.fuzzyStr == null) {
            if (this.fuzzyAlgorithmClass == null) {
                throw new IllegalStateException("No Fuzzy Algorithm Class configured");
            }
            this.fuzzyStr = ArchiveDeviceExtension.fuzzyStr(this.fuzzyAlgorithmClass);
        }
        return this.fuzzyStr;
    }

    private static FuzzyStr fuzzyStr(String s) {
        try {
            return (FuzzyStr)Class.forName(s).newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(s);
        }
    }

    public OverwritePolicy getOverwritePolicy() {
        return this.overwritePolicy;
    }

    public void setOverwritePolicy(OverwritePolicy overwritePolicy) {
        this.overwritePolicy = overwritePolicy;
    }

    public boolean isRecordAttributeModification() {
        return this.recordAttributeModification;
    }

    public void setRecordAttributeModification(boolean recordAttributeModification) {
        this.recordAttributeModification = recordAttributeModification;
    }

    public ShowPatientInfo getShowPatientInfoInSystemLog() {
        return this.showPatientInfoInSystemLog;
    }

    public ShowPatientInfo showPatientInfoInSystemLog() {
        return this.showPatientInfoInSystemLog != null ? this.showPatientInfoInSystemLog : ShowPatientInfo.PLAIN_TEXT;
    }

    public void setShowPatientInfoInSystemLog(ShowPatientInfo showPatientInfoInSystemLog) {
        this.showPatientInfoInSystemLog = showPatientInfoInSystemLog;
    }

    public ShowPatientInfo getShowPatientInfoInAuditLog() {
        return this.showPatientInfoInAuditLog;
    }

    public void setShowPatientInfoInAuditLog(ShowPatientInfo showPatientInfoInAuditLog) {
        this.showPatientInfoInAuditLog = showPatientInfoInAuditLog;
    }

    public ShowPatientInfo showPatientInfoInAuditLog() {
        return this.showPatientInfoInAuditLog != null ? this.showPatientInfoInAuditLog : ShowPatientInfo.PLAIN_TEXT;
    }

    public AcceptMissingPatientID getAcceptMissingPatientID() {
        return this.acceptMissingPatientID;
    }

    public void setAcceptMissingPatientID(AcceptMissingPatientID acceptMissingPatientID) {
        this.acceptMissingPatientID = acceptMissingPatientID;
    }

    public String getBulkDataSpoolDirectory() {
        return this.bulkDataSpoolDirectory;
    }

    public void setBulkDataSpoolDirectory(String bulkDataSpoolDirectory) {
        this.bulkDataSpoolDirectory = Objects.requireNonNull(bulkDataSpoolDirectory, "BulkDataSpoolDirectory");
    }

    public String getBulkDataDescriptorID() {
        return this.bulkDataDescriptorID;
    }

    public void setBulkDataDescriptorID(String bulkDataDescriptorID) {
        this.bulkDataDescriptorID = bulkDataDescriptorID;
    }

    public String[] getSeriesMetadataStorageIDs() {
        return this.seriesMetadataStorageIDs;
    }

    public void setSeriesMetadataStorageIDs(String ... seriesMetadataStorageIDs) {
        this.seriesMetadataStorageIDs = seriesMetadataStorageIDs;
        Arrays.sort(seriesMetadataStorageIDs);
    }

    public Duration getSeriesMetadataDelay() {
        return this.seriesMetadataDelay;
    }

    public void setSeriesMetadataDelay(Duration seriesMetadataDelay) {
        this.seriesMetadataDelay = seriesMetadataDelay;
    }

    public Duration getSeriesMetadataPollingInterval() {
        return this.seriesMetadataPollingInterval;
    }

    public void setSeriesMetadataPollingInterval(Duration seriesMetadataPollingInterval) {
        this.seriesMetadataPollingInterval = seriesMetadataPollingInterval;
    }

    public int getSeriesMetadataFetchSize() {
        return this.seriesMetadataFetchSize;
    }

    public void setSeriesMetadataFetchSize(int seriesMetadataFetchSize) {
        this.seriesMetadataFetchSize = this.greaterZero(seriesMetadataFetchSize, "seriesMetadataFetchSize");
    }

    public int getSeriesMetadataThreads() {
        return this.seriesMetadataThreads;
    }

    public void setSeriesMetadataThreads(int seriesMetadataThreads) {
        this.seriesMetadataThreads = seriesMetadataThreads;
    }

    public int getSeriesMetadataMaxRetries() {
        return this.seriesMetadataMaxRetries;
    }

    public void setSeriesMetadataMaxRetries(int seriesMetadataMaxRetries) {
        this.seriesMetadataMaxRetries = seriesMetadataMaxRetries;
    }

    public Duration getSeriesMetadataRetryInterval() {
        return this.seriesMetadataRetryInterval;
    }

    public void setSeriesMetadataRetryInterval(Duration seriesMetadataRetryInterval) {
        this.seriesMetadataRetryInterval = seriesMetadataRetryInterval;
    }

    public boolean isPurgeInstanceRecords() {
        return this.purgeInstanceRecords;
    }

    public void setPurgeInstanceRecords(boolean purgeInstanceRecords) {
        this.purgeInstanceRecords = purgeInstanceRecords;
    }

    public Duration getPurgeInstanceRecordsDelay() {
        return this.purgeInstanceRecordsDelay;
    }

    public void setPurgeInstanceRecordsDelay(Duration purgeInstanceRecordsDelay) {
        this.purgeInstanceRecordsDelay = purgeInstanceRecordsDelay;
    }

    public Duration getPurgeInstanceRecordsPollingInterval() {
        return this.purgeInstanceRecordsPollingInterval;
    }

    public void setPurgeInstanceRecordsPollingInterval(Duration purgeInstanceRecordsPollingInterval) {
        this.purgeInstanceRecordsPollingInterval = purgeInstanceRecordsPollingInterval;
    }

    public int getPurgeInstanceRecordsFetchSize() {
        return this.purgeInstanceRecordsFetchSize;
    }

    public void setPurgeInstanceRecordsFetchSize(int purgeInstanceRecordsFetchSize) {
        this.purgeInstanceRecordsFetchSize = this.greaterZero(purgeInstanceRecordsFetchSize, "purgeInstanceRecordsFetchSize");
    }

    public Duration getDeleteUPSPollingInterval() {
        return this.deleteUPSPollingInterval;
    }

    public void setDeleteUPSPollingInterval(Duration deleteUPSPollingInterval) {
        this.deleteUPSPollingInterval = deleteUPSPollingInterval;
    }

    public int getDeleteUPSFetchSize() {
        return this.deleteUPSFetchSize;
    }

    public void setDeleteUPSFetchSize(int deleteUPSFetchSize) {
        this.deleteUPSFetchSize = deleteUPSFetchSize;
    }

    public Duration getDeleteUPSCompletedDelay() {
        return this.deleteUPSCompletedDelay;
    }

    public void setDeleteUPSCompletedDelay(Duration deleteUPSCompletedDelay) {
        this.deleteUPSCompletedDelay = deleteUPSCompletedDelay;
    }

    public Duration getDeleteUPSCanceledDelay() {
        return this.deleteUPSCanceledDelay;
    }

    public void setDeleteUPSCanceledDelay(Duration deleteUPSCanceledDelay) {
        this.deleteUPSCanceledDelay = deleteUPSCanceledDelay;
    }

    public Duration getUPSProcessingPollingInterval() {
        return this.upsProcessingPollingInterval;
    }

    public void setUPSProcessingPollingInterval(Duration upsProcessingPollingInterval) {
        this.upsProcessingPollingInterval = upsProcessingPollingInterval;
    }

    public int getUPSProcessingFetchSize() {
        return this.upsProcessingFetchSize;
    }

    public void setUPSProcessingFetchSize(int upsProcessingFetchSize) {
        this.upsProcessingFetchSize = upsProcessingFetchSize;
    }

    public Duration getTaskPollingInterval() {
        return this.taskPollingInterval;
    }

    public void setTaskPollingInterval(Duration taskPollingInterval) {
        this.taskPollingInterval = taskPollingInterval;
    }

    public int getTaskFetchSize() {
        return this.taskFetchSize;
    }

    public void setTaskFetchSize(int taskFetchSize) {
        this.taskFetchSize = taskFetchSize;
    }

    public boolean isPersonNameComponentOrderInsensitiveMatching() {
        return this.personNameComponentOrderInsensitiveMatching;
    }

    public void setPersonNameComponentOrderInsensitiveMatching(boolean personNameComponentOrderInsensitiveMatching) {
        this.personNameComponentOrderInsensitiveMatching = personNameComponentOrderInsensitiveMatching;
    }

    public boolean isValidateCallingAEHostname() {
        return this.validateCallingAEHostname;
    }

    public void setValidateCallingAEHostname(boolean validateCallingAEHostname) {
        this.validateCallingAEHostname = validateCallingAEHostname;
    }

    public boolean isSendPendingCGet() {
        return this.sendPendingCGet;
    }

    public void setSendPendingCGet(boolean sendPendingCGet) {
        this.sendPendingCGet = sendPendingCGet;
    }

    public Duration getSendPendingCMoveInterval() {
        return this.sendPendingCMoveInterval;
    }

    public void setSendPendingCMoveInterval(Duration sendPendingCMoveInterval) {
        this.sendPendingCMoveInterval = sendPendingCMoveInterval;
    }

    public VR[] getEncodeAsJSONNumber() {
        return this.encodeAsJSONNumber.toArray(new VR[0]);
    }

    public void setEncodeAsJSONNumber(VR[] vrs) {
        Stream.of(vrs).forEach(ArchiveDeviceExtension::requireIS_DS_SV_UV);
        this.encodeAsJSONNumber.clear();
        this.encodeAsJSONNumber.addAll(Arrays.asList(vrs));
    }

    public JSONWriter encodeAsJSONNumber(JSONWriter writer) {
        return ArchiveDeviceExtension.encodeAsJSONNumber(writer, this.encodeAsJSONNumber);
    }

    static JSONWriter encodeAsJSONNumber(JSONWriter writer, EnumSet<VR> encodeAsJSONNumber) {
        encodeAsJSONNumber.forEach(vr -> writer.setJsonType(vr, JsonValue.ValueType.NUMBER));
        return writer;
    }

    static void requireIS_DS_SV_UV(VR vr) {
        if (vr != VR.DS && vr != VR.IS && vr != VR.SV && vr != VR.UV) {
            throw new IllegalArgumentException("vr:" + vr);
        }
    }

    public String[] getWadoSupportedSRClasses() {
        return this.wadoSupportedSRClasses.toArray(StringUtils.EMPTY_STRING);
    }

    public void setWadoSupportedSRClasses(String ... wadoSupportedSRClasses) {
        this.wadoSupportedSRClasses.clear();
        this.wadoSupportedSRClasses.addAll(Arrays.asList(wadoSupportedSRClasses));
    }

    public boolean isWadoSupportedSRClass(String cuid) {
        return this.wadoSupportedSRClasses.contains(cuid);
    }

    public String[] getWadoSupportedPRClasses() {
        return this.wadoSupportedPRClasses.toArray(StringUtils.EMPTY_STRING);
    }

    public void setWadoSupportedPRClasses(String ... wadoSupportedPRClasses) {
        this.wadoSupportedPRClasses.clear();
        this.wadoSupportedPRClasses.addAll(Arrays.asList(wadoSupportedPRClasses));
    }

    public boolean isWadoSupportedPRClass(String cuid) {
        return this.wadoSupportedPRClasses.contains(cuid);
    }

    public boolean isWadoMetadataWithoutPrivate() {
        return this.wadoMetadataWithoutPrivate;
    }

    public void setWadoMetadataWithoutPrivate(boolean wadoMetadataWithoutPrivate) {
        this.wadoMetadataWithoutPrivate = wadoMetadataWithoutPrivate;
    }

    public boolean isWadoIgnorePresentationLUTShape() {
        return this.wadoIgnorePresentationLUTShape;
    }

    public void setWadoIgnorePresentationLUTShape(boolean wadoIgnorePresentationLUTShape) {
        this.wadoIgnorePresentationLUTShape = wadoIgnorePresentationLUTShape;
    }

    public String getWadoThumbnailViewPort() {
        return this.wadoThumbnailViewPort;
    }

    public void setWadoThumbnailViewPort(String wadoThumbnailViewPort) {
        if (!Pattern.matches("[1-9]\\d{0,2},[1-9]\\d{0,2}", wadoThumbnailViewPort)) {
            throw new IllegalArgumentException(wadoThumbnailViewPort);
        }
        this.wadoThumbnailViewPort = wadoThumbnailViewPort;
    }

    public String getWadoZIPEntryNameFormat() {
        return this.wadoZIPEntryNameFormat;
    }

    public void setWadoZIPEntryNameFormat(String wadoZIPEntryNameFormat) {
        this.wadoZIPEntryNameFormat = wadoZIPEntryNameFormat;
    }

    public String getWadoSR2HtmlTemplateURI() {
        return this.wadoSR2HtmlTemplateURI;
    }

    public void setWadoSR2HtmlTemplateURI(String wadoSR2HtmlTemplateURI) {
        this.wadoSR2HtmlTemplateURI = wadoSR2HtmlTemplateURI;
    }

    public String getWadoSR2TextTemplateURI() {
        return this.wadoSR2TextTemplateURI;
    }

    public void setWadoSR2TextTemplateURI(String wadoSR2TextTemplateURI) {
        this.wadoSR2TextTemplateURI = wadoSR2TextTemplateURI;
    }

    public String getWadoCDA2HtmlTemplateURI() {
        return this.wadoCDA2HtmlTemplateURI;
    }

    public void setWadoCDA2HtmlTemplateURI(String wadoCDA2HtmlTemplateURI) {
        this.wadoCDA2HtmlTemplateURI = wadoCDA2HtmlTemplateURI;
    }

    public String getPatientUpdateTemplateURI() {
        return this.patientUpdateTemplateURI;
    }

    public void setPatientUpdateTemplateURI(String patientUpdateTemplateURI) {
        this.patientUpdateTemplateURI = patientUpdateTemplateURI;
    }

    public String getImportReportTemplateURI() {
        return this.importReportTemplateURI;
    }

    public void setImportReportTemplateURI(String importReportTemplateURI) {
        this.importReportTemplateURI = importReportTemplateURI;
    }

    public String getScheduleProcedureTemplateURI() {
        return this.scheduleProcedureTemplateURI;
    }

    public void setScheduleProcedureTemplateURI(String scheduleProcedureTemplateURI) {
        this.scheduleProcedureTemplateURI = scheduleProcedureTemplateURI;
    }

    public String getUnzipVendorDataToURI() {
        return this.unzipVendorDataToURI;
    }

    public void setUnzipVendorDataToURI(String unzipVendorDataToURI) {
        this.unzipVendorDataToURI = unzipVendorDataToURI;
    }

    public String getOutgoingPatientUpdateTemplateURI() {
        return this.outgoingPatientUpdateTemplateURI;
    }

    public void setOutgoingPatientUpdateTemplateURI(String outgoingPatientUpdateTemplateURI) {
        this.outgoingPatientUpdateTemplateURI = outgoingPatientUpdateTemplateURI;
    }

    public String[] getMppsForwardDestinations() {
        return this.mppsForwardDestinations;
    }

    public void setMppsForwardDestinations(String ... mppsForwardDestinations) {
        this.mppsForwardDestinations = mppsForwardDestinations;
    }

    public String[] getIanDestinations() {
        return this.ianDestinations;
    }

    public void setIanDestinations(String ... ianDestinations) {
        this.ianDestinations = ianDestinations;
    }

    public Duration getIanDelay() {
        return this.ianDelay;
    }

    public void setIanDelay(Duration ianDelay) {
        this.ianDelay = ianDelay;
    }

    public Duration getIanTimeout() {
        return this.ianTimeout;
    }

    public void setIanTimeout(Duration ianTimeout) {
        this.ianTimeout = ianTimeout;
    }

    public boolean isIanOnTimeout() {
        return this.ianOnTimeout;
    }

    public void setIanOnTimeout(boolean ianOnTimeout) {
        this.ianOnTimeout = ianOnTimeout;
    }

    public Duration getIanTaskPollingInterval() {
        return this.ianTaskPollingInterval;
    }

    public void setIanTaskPollingInterval(Duration ianTaskPollingInterval) {
        this.ianTaskPollingInterval = ianTaskPollingInterval;
    }

    public int getIanTaskFetchSize() {
        return this.ianTaskFetchSize;
    }

    public void setIanTaskFetchSize(int ianTaskFetchSize) {
        this.ianTaskFetchSize = this.greaterZero(ianTaskFetchSize, "ianTaskFetchSize");
    }

    public String getSpanningCFindSCP() {
        return this.spanningCFindSCP;
    }

    public void setSpanningCFindSCP(String spanningCFindSCP) {
        this.spanningCFindSCP = spanningCFindSCP;
    }

    public String[] getSpanningCFindSCPRetrieveAETitles() {
        return this.spanningCFindSCPRetrieveAETitles;
    }

    public void setSpanningCFindSCPRetrieveAETitles(String[] spanningCFindSCPRetrieveAETitles) {
        this.spanningCFindSCPRetrieveAETitles = spanningCFindSCPRetrieveAETitles;
    }

    public SpanningCFindSCPPolicy getSpanningCFindSCPPolicy() {
        return this.spanningCFindSCPPolicy;
    }

    public void setSpanningCFindSCPPolicy(SpanningCFindSCPPolicy spanningCFindSCPPolicy) {
        this.spanningCFindSCPPolicy = spanningCFindSCPPolicy;
    }

    public String getFallbackCMoveSCP() {
        return this.fallbackCMoveSCP;
    }

    public void setFallbackCMoveSCP(String fallbackCMoveSCP) {
        this.fallbackCMoveSCP = fallbackCMoveSCP;
    }

    public String getFallbackCMoveSCPDestination() {
        return this.fallbackCMoveSCPDestination;
    }

    public void setFallbackCMoveSCPDestination(String fallbackCMoveSCPDestination) {
        this.fallbackCMoveSCPDestination = fallbackCMoveSCPDestination;
    }

    public String getFallbackCMoveSCPCallingAET() {
        return this.fallbackCMoveSCPCallingAET;
    }

    public void setFallbackCMoveSCPCallingAET(String fallbackCMoveSCPCallingAET) {
        this.fallbackCMoveSCPCallingAET = fallbackCMoveSCPCallingAET;
    }

    public String getFallbackCMoveSCPLeadingCFindSCP() {
        return this.fallbackCMoveSCPLeadingCFindSCP;
    }

    public void setFallbackCMoveSCPLeadingCFindSCP(String fallbackCMoveSCPLeadingCFindSCP) {
        this.fallbackCMoveSCPLeadingCFindSCP = fallbackCMoveSCPLeadingCFindSCP;
    }

    public int getFallbackCMoveSCPRetries() {
        return this.fallbackCMoveSCPRetries;
    }

    public void setFallbackCMoveSCPRetries(int fallbackCMoveSCPRetries) {
        this.fallbackCMoveSCPRetries = fallbackCMoveSCPRetries;
    }

    public String getFallbackWadoURIWebApplication() {
        return this.fallbackWadoURIWebApplication;
    }

    public void setFallbackWadoURIWebApplication(String fallbackWadoURIWebApplication) {
        this.fallbackWadoURIWebApplication = fallbackWadoURIWebApplication;
    }

    public int getFallbackWadoURIHttpStatusCode() {
        return this.fallbackWadoURIHttpStatusCode;
    }

    public void setFallbackWadoURIHttpStatusCode(int fallbackWadoURIHttpStatusCode) {
        this.fallbackWadoURIHttpStatusCode = fallbackWadoURIHttpStatusCode;
    }

    public String getExternalRetrieveAEDestination() {
        return this.externalRetrieveAEDestination;
    }

    public void setExternalRetrieveAEDestination(String externalRetrieveAEDestination) {
        this.externalRetrieveAEDestination = externalRetrieveAEDestination;
    }

    public String getXDSiImagingDocumentSourceAETitle() {
        return this.xdsiImagingDocumentSourceAETitle;
    }

    public void setXDSiImagingDocumentSourceAETitle(String xdsiImagingDocumentSourceAETitle) {
        this.xdsiImagingDocumentSourceAETitle = xdsiImagingDocumentSourceAETitle;
    }

    public String getAlternativeCMoveSCP() {
        return this.alternativeCMoveSCP;
    }

    public void setAlternativeCMoveSCP(String alternativeCMoveSCP) {
        this.alternativeCMoveSCP = alternativeCMoveSCP;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = this.greaterOrEqualsZero(queryFetchSize, "queryFetchSize");
    }

    public int getQueryMaxNumberOfResults() {
        return this.queryMaxNumberOfResults;
    }

    public void setQueryMaxNumberOfResults(int queryMaxNumberOfResults) {
        this.queryMaxNumberOfResults = queryMaxNumberOfResults;
    }

    public int getQidoMaxNumberOfResults() {
        return this.qidoMaxNumberOfResults;
    }

    public void setQidoMaxNumberOfResults(int qidoMaxNumberOfResults) {
        this.qidoMaxNumberOfResults = qidoMaxNumberOfResults;
    }

    public boolean isQidoETag() {
        return this.qidoETag;
    }

    public void setQidoETag(boolean qidoETag) {
        this.qidoETag = qidoETag;
    }

    public boolean isFilterByIssuerOfPatientID() {
        return this.filterByIssuerOfPatientID;
    }

    public void setFilterByIssuerOfPatientID(boolean filterByIssuerOfPatientID) {
        this.filterByIssuerOfPatientID = filterByIssuerOfPatientID;
    }

    public boolean isMatchSOPClassOnInstanceLevel() {
        return this.matchSOPClassOnInstanceLevel;
    }

    public void setMatchSOPClassOnInstanceLevel(boolean matchSOPClassOnInstanceLevel) {
        this.matchSOPClassOnInstanceLevel = matchSOPClassOnInstanceLevel;
    }

    public Duration getDeleteRejectedPollingInterval() {
        return this.deleteRejectedPollingInterval;
    }

    public void setDeleteRejectedPollingInterval(Duration deleteRejectedPollingInterval) {
        this.deleteRejectedPollingInterval = deleteRejectedPollingInterval;
    }

    public int getDeleteRejectedFetchSize() {
        return this.deleteRejectedFetchSize;
    }

    public void setDeleteRejectedFetchSize(int deleteRejectedFetchSize) {
        this.deleteRejectedFetchSize = this.greaterZero(deleteRejectedFetchSize, "deleteRejectedFetchSize");
    }

    public Duration getPurgeStoragePollingInterval() {
        return this.purgeStoragePollingInterval;
    }

    public void setPurgeStoragePollingInterval(Duration purgeStoragePollingInterval) {
        this.purgeStoragePollingInterval = purgeStoragePollingInterval;
    }

    public int getPurgeStorageFetchSize() {
        return this.purgeStorageFetchSize;
    }

    public void setPurgeStorageFetchSize(int purgeStorageFetchSize) {
        this.purgeStorageFetchSize = this.greaterZero(purgeStorageFetchSize, "purgeStorageFetchSize");
    }

    public int getDeleteStudyBatchSize() {
        return this.deleteStudyBatchSize;
    }

    public void setDeleteStudyBatchSize(int deleteStudyBatchSize) {
        this.deleteStudyBatchSize = this.greaterZero(deleteStudyBatchSize, "deleteStudyBatchSize");
    }

    public int getDeleteStudyChunkSize() {
        return this.deleteStudyChunkSize;
    }

    public void setDeleteStudyChunkSize(int deleteStudyChunkSize) {
        this.deleteStudyChunkSize = this.greaterZero(deleteStudyChunkSize, "deleteStudyChunkSize");
    }

    public boolean isDeletePatientOnDeleteLastStudy() {
        return this.deletePatientOnDeleteLastStudy;
    }

    public void setDeletePatientOnDeleteLastStudy(boolean deletePatientOnDeleteLastStudy) {
        this.deletePatientOnDeleteLastStudy = deletePatientOnDeleteLastStudy;
    }

    public Duration getFailedToDeletePollingInterval() {
        return this.failedToDeletePollingInterval;
    }

    public void setFailedToDeletePollingInterval(Duration failedToDeletePollingInterval) {
        this.failedToDeletePollingInterval = failedToDeletePollingInterval;
    }

    public int getFailedToDeleteFetchSize() {
        return this.failedToDeleteFetchSize;
    }

    public void setFailedToDeleteFetchSize(int failedToDeleteFetchSize) {
        this.failedToDeleteFetchSize = failedToDeleteFetchSize;
    }

    public Duration getMaxAccessTimeStaleness() {
        return this.maxAccessTimeStaleness;
    }

    public void setMaxAccessTimeStaleness(Duration maxAccessTimeStaleness) {
        this.maxAccessTimeStaleness = maxAccessTimeStaleness;
    }

    public Duration getAECacheStaleTimeout() {
        return this.aeCacheStaleTimeout;
    }

    public void setAECacheStaleTimeout(Duration aeCacheStaleTimeout) {
        this.aeCacheStaleTimeout = aeCacheStaleTimeout;
    }

    public int getAECacheStaleTimeoutSeconds() {
        return ArchiveDeviceExtension.toSeconds(this.aeCacheStaleTimeout);
    }

    public Duration getLeadingCFindSCPQueryCacheStaleTimeout() {
        return this.leadingCFindSCPQueryCacheStaleTimeout;
    }

    public void setLeadingCFindSCPQueryCacheStaleTimeout(Duration leadingCFindSCPQueryCacheStaleTimeout) {
        this.leadingCFindSCPQueryCacheStaleTimeout = leadingCFindSCPQueryCacheStaleTimeout;
    }

    public int getLeadingCFindSCPQueryCacheStaleTimeoutSeconds() {
        return ArchiveDeviceExtension.toSeconds(this.leadingCFindSCPQueryCacheStaleTimeout);
    }

    private static int toSeconds(Duration timeout) {
        return timeout != null ? (int)timeout.getSeconds() : 0;
    }

    public int getLeadingCFindSCPQueryCacheSize() {
        return this.leadingCFindSCPQueryCacheSize;
    }

    public void setLeadingCFindSCPQueryCacheSize(int leadingCFindSCPQueryCacheSize) {
        this.leadingCFindSCPQueryCacheSize = this.greaterZero(leadingCFindSCPQueryCacheSize, "leadingCFindSCPQueryCacheSize");
    }

    public String getAuditSpoolDirectory() {
        return this.auditSpoolDirectory;
    }

    public void setAuditSpoolDirectory(String auditSpoolDirectory) {
        this.auditSpoolDirectory = Objects.requireNonNull(auditSpoolDirectory, "AuditSpoolDirectory");
    }

    public Duration getAuditPollingInterval() {
        return this.auditPollingInterval;
    }

    public void setAuditPollingInterval(Duration auditPollingInterval) {
        this.auditPollingInterval = auditPollingInterval;
    }

    public Duration getAuditAggregateDuration() {
        return this.auditAggregateDuration;
    }

    public void setAuditAggregateDuration(Duration auditAggregateDuration) {
        this.auditAggregateDuration = auditAggregateDuration;
    }

    public boolean isAuditAggregate() {
        return this.auditPollingInterval != null && this.auditAggregateDuration != null;
    }

    public String getStowSpoolDirectory() {
        return this.stowSpoolDirectory;
    }

    public void setStowSpoolDirectory(String stowSpoolDirectory) {
        this.stowSpoolDirectory = Objects.requireNonNull(stowSpoolDirectory, "StowSpoolDirectory");
    }

    public String getWadoSpoolDirectory() {
        return this.wadoSpoolDirectory;
    }

    public void setWadoSpoolDirectory(String wadoSpoolDirectory) {
        this.wadoSpoolDirectory = Objects.requireNonNull(wadoSpoolDirectory, "WadoSpoolDirectory");
    }

    public String getHL7LogFilePattern() {
        return this.hl7LogFilePattern;
    }

    public void setHL7LogFilePattern(String hl7LogFilePattern) {
        this.hl7LogFilePattern = hl7LogFilePattern;
    }

    public String getHL7ErrorLogFilePattern() {
        return this.hl7ErrorLogFilePattern;
    }

    public void setHL7ErrorLogFilePattern(String hl7ErrorLogFilePattern) {
        this.hl7ErrorLogFilePattern = hl7ErrorLogFilePattern;
    }

    public int getRejectExpiredStudiesFetchSize() {
        return this.rejectExpiredStudiesFetchSize;
    }

    public void setRejectExpiredStudiesFetchSize(int rejectExpiredStudiesFetchSize) {
        this.rejectExpiredStudiesFetchSize = this.greaterOrEqualsZero(rejectExpiredStudiesFetchSize, "rejectExpiredStudiesFetchSize");
    }

    public int getRejectExpiredSeriesFetchSize() {
        return this.rejectExpiredSeriesFetchSize;
    }

    public void setRejectExpiredSeriesFetchSize(int rejectExpiredSeriesFetchSize) {
        this.rejectExpiredSeriesFetchSize = this.greaterOrEqualsZero(rejectExpiredSeriesFetchSize, "rejectExpiredSeriesFetchSize");
    }

    public Duration getRejectExpiredStudiesPollingInterval() {
        return this.rejectExpiredStudiesPollingInterval;
    }

    public void setRejectExpiredStudiesPollingInterval(Duration rejectExpiredStudiesPollingInterval) {
        this.rejectExpiredStudiesPollingInterval = rejectExpiredStudiesPollingInterval;
    }

    public ScheduleExpression[] getRejectExpiredStudiesSchedules() {
        return this.rejectExpiredStudiesSchedules;
    }

    public void setRejectExpiredStudiesSchedules(ScheduleExpression[] rejectExpiredStudiesSchedules) {
        this.rejectExpiredStudiesSchedules = rejectExpiredStudiesSchedules;
    }

    public String getRejectExpiredStudiesAETitle() {
        return this.rejectExpiredStudiesAETitle;
    }

    public void setRejectExpiredStudiesAETitle(String rejectExpiredStudiesAETitle) {
        this.rejectExpiredStudiesAETitle = rejectExpiredStudiesAETitle;
    }

    public String getFallbackCMoveSCPStudyOlderThan() {
        return this.fallbackCMoveSCPStudyOlderThan;
    }

    public void setFallbackCMoveSCPStudyOlderThan(String fallbackCMoveSCPStudyOlderThan) {
        this.fallbackCMoveSCPStudyOlderThan = fallbackCMoveSCPStudyOlderThan;
    }

    public Duration getPurgeTaskPollingInterval() {
        return this.purgeTaskPollingInterval;
    }

    public void setPurgeTaskPollingInterval(Duration purgeTaskPollingInterval) {
        this.purgeTaskPollingInterval = purgeTaskPollingInterval;
    }

    public Duration getPurgeStgCmtPollingInterval() {
        return this.purgeStgCmtPollingInterval;
    }

    public void setPurgeStgCmtPollingInterval(Duration purgeStgCmtPollingInterval) {
        this.purgeStgCmtPollingInterval = purgeStgCmtPollingInterval;
    }

    public Duration getPurgeStgCmtCompletedDelay() {
        return this.purgeStgCmtCompletedDelay;
    }

    public void setPurgeStgCmtCompletedDelay(Duration purgeStgCmtCompletedDelay) {
        this.purgeStgCmtCompletedDelay = purgeStgCmtCompletedDelay;
    }

    public Duration getKeyValueRetentionPollingInterval() {
        return this.keyValueRetentionPollingInterval;
    }

    public void setKeyValueRetentionPollingInterval(Duration keyValueRetentionPollingInterval) {
        this.keyValueRetentionPollingInterval = keyValueRetentionPollingInterval;
    }

    public int getKeyValueRetentionFetchSize() {
        return this.keyValueRetentionFetchSize;
    }

    public void setKeyValueRetentionFetchSize(int keyValueRetentionFetchSize) {
        this.keyValueRetentionFetchSize = keyValueRetentionFetchSize;
    }

    public Duration getKeyValueRetentionPeriod() {
        return this.keyValueRetentionPeriod;
    }

    public void setKeyValueRetentionPeriod(Duration keyValueRetentionPeriod) {
        this.keyValueRetentionPeriod = keyValueRetentionPeriod;
    }

    public SPSStatus[] getHideSPSWithStatusFrom() {
        return this.hideSPSWithStatusFrom;
    }

    public void setHideSPSWithStatusFrom(SPSStatus[] hideSPSWithStatusFrom) {
        this.hideSPSWithStatusFrom = hideSPSWithStatusFrom;
    }

    public SPSStatus[] getHideSPSWithStatusFromMWLRS() {
        return this.hideSPSWithStatusFromMWLRS;
    }

    public void setHideSPSWithStatusFromMWLRS(SPSStatus[] hideSPSWithStatusFromMWLRS) {
        this.hideSPSWithStatusFromMWLRS = hideSPSWithStatusFromMWLRS;
    }

    public HL7ORUAction[] getHl7ORUAction() {
        return this.hl7ORUAction;
    }

    public void setHl7ORUAction(HL7ORUAction[] hl7ORUAction) {
        this.hl7ORUAction = hl7ORUAction;
    }

    public String getMWLAccessionNumberGenerator() {
        return this.mwlAccessionNumberGenerator;
    }

    public void setMWLAccessionNumberGenerator(String mwlAccessionNumberGenerator) {
        this.mwlAccessionNumberGenerator = mwlAccessionNumberGenerator;
    }

    public String getMWLRequestedProcedureIDGenerator() {
        return this.mwlRequestedProcedureIDGenerator;
    }

    public void setMWLRequestedProcedureIDGenerator(String mwlRequestedProcedureIDGenerator) {
        this.mwlRequestedProcedureIDGenerator = mwlRequestedProcedureIDGenerator;
    }

    public String getMWLScheduledProcedureStepIDGenerator() {
        return this.mwlScheduledProcedureStepIDGenerator;
    }

    public void setMWLScheduledProcedureStepIDGenerator(String mwlScheduledProcedureStepIDGenerator) {
        this.mwlScheduledProcedureStepIDGenerator = mwlScheduledProcedureStepIDGenerator;
    }

    public String getStorePermissionServiceURL() {
        return this.storePermissionServiceURL;
    }

    public void setStorePermissionServiceURL(String storePermissionServiceURL) {
        this.storePermissionServiceURL = storePermissionServiceURL;
    }

    public String getStorePermissionServiceResponse() {
        return this.storePermissionServiceResponse;
    }

    public void setStorePermissionServiceResponse(String storePermissionServiceResponse) {
        this.storePermissionServiceResponse = storePermissionServiceResponse;
    }

    public Pattern getStorePermissionServiceResponsePattern() {
        return this.storePermissionServiceResponsePattern;
    }

    public void setStorePermissionServiceResponsePattern(Pattern storePermissionServiceResponsePattern) {
        this.storePermissionServiceResponsePattern = storePermissionServiceResponsePattern;
    }

    public Pattern getStorePermissionServiceExpirationDatePattern() {
        return this.storePermissionServiceExpirationDatePattern;
    }

    public void setStorePermissionServiceExpirationDatePattern(Pattern storePermissionServiceExpirationDatePattern) {
        this.storePermissionServiceExpirationDatePattern = storePermissionServiceExpirationDatePattern;
    }

    public Pattern getStorePermissionServiceErrorCommentPattern() {
        return this.storePermissionServiceErrorCommentPattern;
    }

    public void setStorePermissionServiceErrorCommentPattern(Pattern storePermissionServiceErrorCommentPattern) {
        this.storePermissionServiceErrorCommentPattern = storePermissionServiceErrorCommentPattern;
    }

    public Pattern getStorePermissionServiceErrorCodePattern() {
        return this.storePermissionServiceErrorCodePattern;
    }

    public void setStorePermissionServiceErrorCodePattern(Pattern storePermissionServiceErrorCodePattern) {
        this.storePermissionServiceErrorCodePattern = storePermissionServiceErrorCodePattern;
    }

    public Duration getStorePermissionCacheStaleTimeout() {
        return this.storePermissionCacheStaleTimeout;
    }

    public void setStorePermissionCacheStaleTimeout(Duration storePermissionCacheStaleTimeout) {
        this.storePermissionCacheStaleTimeout = storePermissionCacheStaleTimeout;
    }

    public int getStorePermissionCacheStaleTimeoutSeconds() {
        return ArchiveDeviceExtension.toSeconds(this.storePermissionCacheStaleTimeout);
    }

    public int getStorePermissionCacheSize() {
        return this.storePermissionCacheSize;
    }

    public void setStorePermissionCacheSize(int storePermissionCacheSize) {
        this.storePermissionCacheSize = this.greaterZero(storePermissionCacheSize, "storePermissionCacheSize");
    }

    public Duration getMergeMWLCacheStaleTimeout() {
        return this.mergeMWLCacheStaleTimeout;
    }

    public void setMergeMWLCacheStaleTimeout(Duration mergeMWLCacheStaleTimeout) {
        this.mergeMWLCacheStaleTimeout = mergeMWLCacheStaleTimeout;
    }

    public int getMergeMWLCacheStaleTimeoutSeconds() {
        return ArchiveDeviceExtension.toSeconds(this.mergeMWLCacheStaleTimeout);
    }

    public int getMergeMWLCacheSize() {
        return this.mergeMWLCacheSize;
    }

    public void setMergeMWLCacheSize(int mergeMWLCacheSize) {
        this.mergeMWLCacheSize = this.greaterZero(mergeMWLCacheSize, "mergeMWLCacheSize");
    }

    public int getStoreUpdateDBMaxRetries() {
        return this.storeUpdateDBMaxRetries;
    }

    public void setStoreUpdateDBMaxRetries(int storeUpdateDBMaxRetries) {
        this.storeUpdateDBMaxRetries = storeUpdateDBMaxRetries;
    }

    public int getStoreUpdateDBMaxRetryDelay() {
        return this.storeUpdateDBMaxRetryDelay;
    }

    public void setStoreUpdateDBMaxRetryDelay(int storeUpdateDBMaxRetryDelay) {
        this.storeUpdateDBMaxRetryDelay = storeUpdateDBMaxRetryDelay;
    }

    public int getStoreUpdateDBMinRetryDelay() {
        return this.storeUpdateDBMinRetryDelay;
    }

    public void setStoreUpdateDBMinRetryDelay(int storeUpdateDBMinRetryDelay) {
        this.storeUpdateDBMinRetryDelay = storeUpdateDBMinRetryDelay;
    }

    public int storeUpdateDBRetryDelay() {
        return this.storeUpdateDBMinRetryDelay + ThreadLocalRandom.current().nextInt(Math.max(1, this.storeUpdateDBMaxRetryDelay - this.storeUpdateDBMinRetryDelay));
    }

    public AllowRejectionForDataRetentionPolicyExpired getAllowRejectionForDataRetentionPolicyExpired() {
        return this.allowRejectionForDataRetentionPolicyExpired;
    }

    public void setAllowRejectionForDataRetentionPolicyExpired(AllowRejectionForDataRetentionPolicyExpired allowRejectionForDataRetentionPolicyExpired) {
        this.allowRejectionForDataRetentionPolicyExpired = allowRejectionForDataRetentionPolicyExpired;
    }

    public String getRemapRetrieveURL() {
        return this.remapRetrieveURLClientHost != null ? "[" + this.remapRetrieveURLClientHost + "]" + this.remapRetrieveURL : this.remapRetrieveURL;
    }

    public void setRemapRetrieveURL(String remapRetrieveURL) {
        if (remapRetrieveURL == null || remapRetrieveURL.charAt(0) != '[') {
            this.remapRetrieveURL = remapRetrieveURL;
            this.remapRetrieveURLClientHost = null;
        } else {
            String[] ss = StringUtils.split((String)remapRetrieveURL.substring(1), (char)']');
            if (ss.length != 2) {
                throw new IllegalArgumentException(remapRetrieveURL);
            }
            this.remapRetrieveURL = ss[1];
            this.remapRetrieveURLClientHost = ss[0];
        }
    }

    public StringBuffer remapRetrieveURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        if (this.remap(request)) {
            sb.setLength(0);
            sb.append(this.remapRetrieveURL).append(request.getRequestURI());
        }
        return sb;
    }

    private boolean remap(HttpServletRequest request) {
        return this.remapRetrieveURL != null && (this.remapRetrieveURLClientHost == null || this.remapRetrieveURLClientHost.equals(StringUtils.isIPAddr((String)this.remapRetrieveURLClientHost) ? request.getRemoteAddr() : request.getRemoteHost()));
    }

    public String getHL7PSUSendingApplication() {
        return this.hl7PSUSendingApplication;
    }

    public void setHL7PSUSendingApplication(String hl7PSUSendingApplication) {
        this.hl7PSUSendingApplication = hl7PSUSendingApplication;
    }

    public Duration getHL7PSUTaskPollingInterval() {
        return this.hl7PSUTaskPollingInterval;
    }

    public void setHL7PSUTaskPollingInterval(Duration hl7PSUTaskPollingInterval) {
        this.hl7PSUTaskPollingInterval = hl7PSUTaskPollingInterval;
    }

    public String[] getHL7PSUReceivingApplications() {
        return this.hl7PSUReceivingApplications;
    }

    public void setHL7PSUReceivingApplications(String[] hl7PSUReceivingApplications) {
        this.hl7PSUReceivingApplications = hl7PSUReceivingApplications;
    }

    public Duration getHL7PSUDelay() {
        return this.hl7PSUDelay;
    }

    public void setHL7PSUDelay(Duration hl7PSUDelay) {
        this.hl7PSUDelay = hl7PSUDelay;
    }

    public Duration getHL7PSUTimeout() {
        return this.hl7PSUTimeout;
    }

    public void setHL7PSUTimeout(Duration hl7PSUTimeout) {
        this.hl7PSUTimeout = hl7PSUTimeout;
    }

    public boolean isHL7PSUOnTimeout() {
        return this.hl7PSUOnTimeout;
    }

    public void setHL7PSUOnTimeout(boolean hl7PSUOnTimeout) {
        this.hl7PSUOnTimeout = hl7PSUOnTimeout;
    }

    public int getHL7PSUTaskFetchSize() {
        return this.hl7PSUTaskFetchSize;
    }

    public void setHL7PSUTaskFetchSize(int hl7PSUTaskFetchSize) {
        this.hl7PSUTaskFetchSize = hl7PSUTaskFetchSize;
    }

    public boolean isHL7PSUMWL() {
        return this.hl7PSUMWL;
    }

    public void setHL7PSUMWL(boolean hl7PSUMWL) {
        this.hl7PSUMWL = hl7PSUMWL;
    }

    public HL7PSUMWLMatchingKey getHL7PSUMWLMatchingKey() {
        return this.hl7PSUMWLMatchingKey;
    }

    public void setHL7PSUMWLMatchingKey(HL7PSUMWLMatchingKey hl7PSUMWLMatchingKey) {
        this.hl7PSUMWLMatchingKey = hl7PSUMWLMatchingKey;
    }

    public boolean isHl7PSUForRequestedProcedure() {
        return this.hl7PSUForRequestedProcedure;
    }

    public void setHl7PSUForRequestedProcedure(boolean hl7PSUForRequestedProcedure) {
        this.hl7PSUForRequestedProcedure = hl7PSUForRequestedProcedure;
    }

    public boolean isHl7PSUPIDPV1() {
        return this.hl7PSUPIDPV1;
    }

    public void setHl7PSUPIDPV1(boolean hl7PSUPIDPV1) {
        this.hl7PSUPIDPV1 = hl7PSUPIDPV1;
    }

    public String getHl7PSURequestedProcedureID() {
        return this.hl7PSURequestedProcedureID;
    }

    public void setHl7PSURequestedProcedureID(String hl7PSURequestedProcedureID) {
        this.hl7PSURequestedProcedureID = hl7PSURequestedProcedureID;
    }

    public String getHl7PSUAccessionNumber() {
        return this.hl7PSUAccessionNumber;
    }

    public void setHl7PSUAccessionNumber(String hl7PSUAccessionNumber) {
        this.hl7PSUAccessionNumber = hl7PSUAccessionNumber;
    }

    public String getHl7PSUFillerOrderNumber() {
        return this.hl7PSUFillerOrderNumber;
    }

    public void setHl7PSUFillerOrderNumber(String hl7PSUFillerOrderNumber) {
        this.hl7PSUFillerOrderNumber = hl7PSUFillerOrderNumber;
    }

    public String getHl7PSUPlacerOrderNumber() {
        return this.hl7PSUPlacerOrderNumber;
    }

    public void setHl7PSUPlacerOrderNumber(String hl7PSUPlacerOrderNumber) {
        this.hl7PSUPlacerOrderNumber = hl7PSUPlacerOrderNumber;
    }

    public HL7PSUMessageType getHl7PSUMessageType() {
        return this.hl7PSUMessageType;
    }

    public void setHl7PSUMessageType(HL7PSUMessageType hl7PSUMessageType) {
        this.hl7PSUMessageType = hl7PSUMessageType;
    }

    public Conditions getHl7PSUConditions() {
        return this.hl7PSUConditions;
    }

    public void setHl7PSUConditions(Conditions hl7PSUConditions) {
        this.hl7PSUConditions = hl7PSUConditions;
    }

    public String getHl7PSUMppsTemplateURI() {
        return this.hl7PSUMppsTemplateURI;
    }

    public void setHl7PSUMppsTemplateURI(String hl7PSUMppsTemplateURI) {
        this.hl7PSUMppsTemplateURI = hl7PSUMppsTemplateURI;
    }

    public String getHl7PSUStudyTemplateURI() {
        return this.hl7PSUStudyTemplateURI;
    }

    public void setHl7PSUStudyTemplateURI(String hl7PSUStudyTemplateURI) {
        this.hl7PSUStudyTemplateURI = hl7PSUStudyTemplateURI;
    }

    public String[] getHL7NoPatientCreateMessageTypes() {
        return this.hl7NoPatientCreateMessageTypes.toArray(new String[this.hl7NoPatientCreateMessageTypes.size()]);
    }

    public void setHL7NoPatientCreateMessageTypes(String ... messageTypes) {
        this.hl7NoPatientCreateMessageTypes.clear();
        for (String messageType : messageTypes) {
            this.hl7NoPatientCreateMessageTypes.add(messageType);
        }
    }

    public boolean isHL7NoPatientCreateMessageType(String messageType) {
        return this.hl7NoPatientCreateMessageTypes.contains(messageType);
    }

    public Map<String, String> getXRoadProperties() {
        return this.xRoadProperties;
    }

    public void setXRoadProperty(String name, String value) {
        this.xRoadProperties.put(name, value);
    }

    public void setXRoadProperties(String[] ss) {
        this.xRoadProperties.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Property in incorrect format : " + s);
            }
            this.setXRoadProperty(s.substring(0, index), s.substring(index + 1));
        }
    }

    public boolean hasXRoadProperties() {
        return this.xRoadProperties.containsKey("endpoint");
    }

    public Map<String, String> getImpaxReportProperties() {
        return this.impaxReportProperties;
    }

    public void setImpaxReportProperty(String name, String value) {
        this.impaxReportProperties.put(name, value);
    }

    public void setImpaxReportProperties(String[] ss) {
        this.impaxReportProperties.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Property in incorrect format : " + s);
            }
            this.setImpaxReportProperty(s.substring(0, index), s.substring(index + 1));
        }
    }

    public boolean hasImpaxReportProperties() {
        return this.impaxReportProperties.containsKey("endpoint");
    }

    public AttributeFilter getAttributeFilter(Entity entity) {
        AttributeFilter filter = this.attributeFilters.get((Object)entity);
        if (filter == null) {
            throw new IllegalArgumentException("No Attribute Filter for " + entity + " configured");
        }
        return filter;
    }

    public void setAttributeFilter(Entity entity, AttributeFilter filter) {
        this.attributeFilters.put(entity, filter);
    }

    public Map<Entity, AttributeFilter> getAttributeFilters() {
        return this.attributeFilters;
    }

    public int[] returnKeysForLeadingCFindSCP(String aet) {
        Map<String, AttributeSet> map = this.getAttributeSet(AttributeSet.Type.LEADING_CFIND_SCP);
        AttributeSet attributeSet = map.get(aet);
        if (attributeSet == null) {
            attributeSet = map.get("*");
        }
        return attributeSet != null ? attributeSet.getSelection() : this.catAttributeFilters(Entity.Patient, Entity.Study);
    }

    private int[] catAttributeFilters(Entity ... entities) {
        int[] tags = ByteUtils.EMPTY_INTS;
        for (Entity entity : entities) {
            int[] src = this.getAttributeFilter(entity).getSelection();
            int[] dest = Arrays.copyOf(tags, tags.length + src.length);
            System.arraycopy(src, 0, dest, tags.length, src.length);
            tags = dest;
        }
        return tags;
    }

    public void addAttributeSet(AttributeSet tags) {
        Map<String, AttributeSet> map = this.attributeSet.get((Object)tags.getType());
        if (map == null) {
            map = new LinkedHashMap<String, AttributeSet>();
            this.attributeSet.put(tags.getType(), map);
        }
        map.put(tags.getID(), tags);
    }

    public void removeAttributeSet(AttributeSet tags) {
        Map<String, AttributeSet> map = this.attributeSet.get((Object)tags.getType());
        if (map != null) {
            map.remove(tags.getID());
        }
    }

    public Map<AttributeSet.Type, Map<String, AttributeSet>> getAttributeSet() {
        return this.attributeSet;
    }

    public Map<String, AttributeSet> getAttributeSet(AttributeSet.Type type) {
        return (Map)StringUtils.maskNull(this.attributeSet.get((Object)type), Collections.emptyMap());
    }

    public BulkDataDescriptor getBulkDataDescriptor(String bulkDataDescriptorID) {
        if (bulkDataDescriptorID == null) {
            return BulkDataDescriptor.DEFAULT;
        }
        BasicBulkDataDescriptor descriptor = this.bulkDataDescriptorMap.get(bulkDataDescriptorID);
        if (descriptor == null) {
            throw new IllegalArgumentException("No Bulk Data Descriptor with ID " + bulkDataDescriptorID + " configured");
        }
        return descriptor;
    }

    public BulkDataDescriptor getBulkDataDescriptor() {
        return this.getBulkDataDescriptor(this.bulkDataDescriptorID);
    }

    public void addBulkDataDescriptor(BasicBulkDataDescriptor descriptor) {
        this.bulkDataDescriptorMap.put(descriptor.getBulkDataDescriptorID(), descriptor);
    }

    public BasicBulkDataDescriptor removeBulkDataDescriptor(String bulkDataDescriptorID) {
        return this.bulkDataDescriptorMap.remove(bulkDataDescriptorID);
    }

    public void clearBulkDataDescriptors() {
        this.bulkDataDescriptorMap.clear();
    }

    public Map<String, BasicBulkDataDescriptor> getBulkDataDescriptors() {
        return this.bulkDataDescriptorMap;
    }

    public IDGenerator getIDGenerator(String name) {
        IDGenerator generator = this.idGenerators.get(name);
        if (generator == null) {
            throw new IllegalArgumentException("No ID Generator for " + name + " configured");
        }
        return generator;
    }

    public void addIDGenerator(IDGenerator generator) {
        this.idGenerators.put(generator.getName(), generator);
    }

    public void removeIDGenerator(IDGenerator generator) {
        this.idGenerators.remove(generator.getName());
    }

    public Map<String, IDGenerator> getIDGenerators() {
        return this.idGenerators;
    }

    public QueryRetrieveView getQueryRetrieveView(String viewID) {
        return this.queryRetrieveViewMap.get(viewID);
    }

    public QueryRetrieveView getQueryRetrieveViewNotNull(String viewID) {
        QueryRetrieveView view = this.getQueryRetrieveView(viewID);
        if (view == null) {
            throw new IllegalArgumentException("No Query Retrieve View configured with ID:" + viewID);
        }
        return view;
    }

    public QueryRetrieveView removeQueryRetrieveView(String viewID) {
        return this.queryRetrieveViewMap.remove(viewID);
    }

    public void addQueryRetrieveView(QueryRetrieveView view) {
        this.queryRetrieveViewMap.put(view.getViewID(), view);
    }

    public Collection<QueryRetrieveView> getQueryRetrieveViews() {
        return this.queryRetrieveViewMap.values();
    }

    public Collection<String> getQueryRetrieveViewIDs() {
        return this.queryRetrieveViewMap.keySet();
    }

    public StorageDescriptor getStorageDescriptor(String storageID) {
        return this.storageDescriptorMap.get(storageID);
    }

    public StorageDescriptor getStorageDescriptorNotNull(String storageID) {
        StorageDescriptor descriptor = this.getStorageDescriptor(storageID);
        if (descriptor == null) {
            throw new IllegalArgumentException("No Storage configured with ID:" + storageID);
        }
        return descriptor;
    }

    public StorageDescriptor removeStorageDescriptor(String storageID) {
        return this.storageDescriptorMap.remove(storageID);
    }

    public void addStorageDescriptor(StorageDescriptor descriptor) {
        this.storageDescriptorMap.put(descriptor.getStorageID(), descriptor);
    }

    public Collection<StorageDescriptor> getStorageDescriptors() {
        return this.storageDescriptorMap.values();
    }

    public List<StorageDescriptor> getFreeStorageDescriptors(String[] storageIDs) {
        return this.getStorageDescriptors(storageIDs, false);
    }

    public List<StorageDescriptor> getFullStorageDescriptors(String[] storageIDs) {
        return this.getStorageDescriptors(storageIDs, true);
    }

    private List<StorageDescriptor> getStorageDescriptors(String[] storageIDs, boolean storageThresholdExceeded) {
        ArrayList<StorageDescriptor> list = new ArrayList<StorageDescriptor>(storageIDs.length);
        for (String storageID : storageIDs) {
            StorageDescriptor descriptor = this.storageDescriptorMap.get(storageID);
            if (descriptor == null) {
                throw new IllegalArgumentException("No Storage configured with ID:" + storageID);
            }
            if (descriptor.isStorageThresholdExceeded() != storageThresholdExceeded) continue;
            list.add(descriptor);
        }
        return list;
    }

    public Stream<StorageDescriptor> getStorageDescriptorsOfCluster(String clusterID) {
        return this.storageDescriptorMap.values().stream().filter(desc -> clusterID.equals(desc.getStorageClusterID()));
    }

    public List<String> getOtherStorageIDsOfStorageCluster(StorageDescriptor desc) {
        return desc.getStorageClusterID() != null ? this.getStorageDescriptorsOfCluster(desc.getStorageClusterID()).map(StorageDescriptor::getStorageID).filter(storageID -> !storageID.equals(desc.getStorageID())).collect(Collectors.toList()) : Collections.emptyList();
    }

    public List<String> getStudyStorageIDs(String storageID, Boolean storageClustered, Boolean storageExported) {
        StorageDescriptor desc = this.getStorageDescriptor(storageID);
        return desc != null ? desc.getStudyStorageIDs(this.getOtherStorageIDsOfStorageCluster(desc), this.getExportedFromStorageIDs(storageID), storageClustered, storageExported) : Collections.emptyList();
    }

    private List<String> getExportedFromStorageIDs(String exportStorageID) {
        return this.storageDescriptorMap.values().stream().filter(desc -> Arrays.asList(desc.getExportStorageID()).contains(exportStorageID)).map(StorageDescriptor::getStorageID).collect(Collectors.toList());
    }

    public QueueDescriptor getQueueDescriptor(String queueName) {
        return this.queueDescriptorMap.get(queueName);
    }

    public QueueDescriptor getQueueDescriptorNotNull(String queueName) {
        QueueDescriptor descriptor = this.getQueueDescriptor(queueName);
        if (descriptor == null) {
            throw new IllegalArgumentException("No Queue configured with name:" + queueName);
        }
        return descriptor;
    }

    public QueueDescriptor removeQueueDescriptor(String queueName) {
        return this.queueDescriptorMap.remove(queueName);
    }

    public void addQueueDescriptor(QueueDescriptor descriptor) {
        this.queueDescriptorMap.put(descriptor.getQueueName(), descriptor);
    }

    public Collection<QueueDescriptor> getQueueDescriptors() {
        return this.queueDescriptorMap.values();
    }

    public MetricsDescriptor getMetricsDescriptor(String metricsName) {
        return this.metricsDescriptorMap.get(metricsName);
    }

    public boolean hasMetricsDescriptor(String metricsName) {
        return this.metricsDescriptorMap.containsKey(metricsName);
    }

    public MetricsDescriptor removeMetricsDescriptor(String metricsName) {
        return this.metricsDescriptorMap.remove(metricsName);
    }

    public void addMetricsDescriptor(MetricsDescriptor descriptor) {
        this.metricsDescriptorMap.put(descriptor.getMetricsName(), descriptor);
    }

    public Collection<MetricsDescriptor> getMetricsDescriptors() {
        return this.metricsDescriptorMap.values();
    }

    public ExporterDescriptor getExporterDescriptor(String exporterID) {
        return this.exporterDescriptorMap.get(exporterID);
    }

    public ExporterDescriptor getExporterDescriptorNotNull(String exporterID) {
        ExporterDescriptor descriptor = this.getExporterDescriptor(exporterID);
        if (descriptor == null) {
            throw new IllegalArgumentException("No Exporter configured with ID:" + exporterID);
        }
        return descriptor;
    }

    public ExporterDescriptor removeExporterDescriptor(String exporterID) {
        return this.exporterDescriptorMap.remove(exporterID);
    }

    public void addExporterDescriptor(ExporterDescriptor destination) {
        this.exporterDescriptorMap.put(destination.getExporterID(), destination);
    }

    public PDQServiceDescriptor getPDQServiceDescriptor(String pdqServiceID) {
        return this.pdqServiceDescriptorMap.get(pdqServiceID);
    }

    public PDQServiceDescriptor getPDQServiceDescriptorNotNull(String pdqServiceID) {
        PDQServiceDescriptor descriptor = this.getPDQServiceDescriptor(pdqServiceID);
        if (descriptor == null) {
            throw new IllegalArgumentException("No PDQService configured with ID:" + pdqServiceID);
        }
        return descriptor;
    }

    public PDQServiceDescriptor removePDQServiceDescriptor(String pDQServiceID) {
        return this.pdqServiceDescriptorMap.remove(pDQServiceID);
    }

    public void addPDQServiceDescriptor(PDQServiceDescriptor destination) {
        this.pdqServiceDescriptorMap.put(destination.getPDQServiceID(), destination);
    }

    public Collection<PDQServiceDescriptor> getPDQServiceDescriptors() {
        return this.pdqServiceDescriptorMap.values();
    }

    private int greaterZero(int i, String prompt) {
        if (i <= 0) {
            throw new IllegalArgumentException(prompt + ": " + i);
        }
        return i;
    }

    private int greaterOrEqualsZero(int i, String prompt) {
        if (i < 0) {
            throw new IllegalArgumentException(prompt + ": " + i);
        }
        return i;
    }

    public Collection<ExporterDescriptor> getExporterDescriptors() {
        return this.exporterDescriptorMap.values();
    }

    public void removeUPSOnStore(UPSOnStore rule) {
        this.upsOnStoreList.remove(rule);
    }

    public void clearUPSOnStore() {
        this.upsOnStoreList.clear();
    }

    public void addUPSOnStore(UPSOnStore upsOnStore) {
        this.upsOnStoreList.add(upsOnStore);
    }

    public Collection<UPSOnStore> listUPSOnStore() {
        return this.upsOnStoreList;
    }

    public void removeUPSOnUPSCompleted(UPSOnUPSCompleted rule) {
        this.upsOnUPSCompletedList.remove(rule);
    }

    public void clearUPSOnUPSCompleted() {
        this.upsOnUPSCompletedList.clear();
    }

    public void addUPSOnUPSCompleted(UPSOnUPSCompleted upsOnUPSCompleted) {
        this.upsOnUPSCompletedList.add(upsOnUPSCompleted);
    }

    public Collection<UPSOnUPSCompleted> listUPSOnUPSCompleted() {
        return this.upsOnUPSCompletedList;
    }

    public void removeUPSOnHL7(UPSOnHL7 rule) {
        this.upsOnHL7List.remove(rule);
    }

    public void clearUPSOnHL7() {
        this.upsOnHL7List.clear();
    }

    public void addUPSOnHL7(UPSOnHL7 upsOnHL7) {
        this.upsOnHL7List.add(upsOnHL7);
    }

    public Collection<UPSOnHL7> listUPSOnHL7() {
        return this.upsOnHL7List;
    }

    public void removeUPSProcessingRule(UPSProcessingRule rule) {
        this.upsProcessingRuleList.remove(rule);
    }

    public void clearUPSProcessingRules() {
        this.upsProcessingRuleList.clear();
    }

    public void addUPSProcessingRule(UPSProcessingRule rule) {
        this.upsProcessingRuleList.add(rule);
    }

    public Collection<UPSProcessingRule> listUPSProcessingRules() {
        return this.upsProcessingRuleList;
    }

    public void removeExportRule(ExportRule rule) {
        this.exportRules.remove(rule);
    }

    public void clearExportRules() {
        this.exportRules.clear();
    }

    public void addExportRule(ExportRule rule) {
        this.exportRules.add(rule);
    }

    public Collection<ExportRule> getExportRules() {
        return this.exportRules;
    }

    public void removeExportPriorsRule(ExportPriorsRule rule) {
        this.exportPriorsRules.remove(rule);
    }

    public void clearExportPriorsRules() {
        this.exportPriorsRules.clear();
    }

    public void addExportPriorsRule(ExportPriorsRule rule) {
        this.exportPriorsRules.add(rule);
    }

    public Collection<ExportPriorsRule> getExportPriorsRules() {
        return this.exportPriorsRules;
    }

    public void removeMPPSForwardRule(MPPSForwardRule rule) {
        this.mppsForwardRule.remove(rule);
    }

    public void clearMPPSForwardRules() {
        this.mppsForwardRule.clear();
    }

    public void addMPPSForwardRule(MPPSForwardRule rule) {
        this.mppsForwardRule.add(rule);
    }

    public Collection<MPPSForwardRule> getMPPSForwardRules() {
        return this.mppsForwardRule;
    }

    public void removeHL7ExportRule(HL7ExportRule rule) {
        this.hl7ExportRules.remove(rule);
    }

    public void clearHL7ExportRules() {
        this.hl7ExportRules.clear();
    }

    public void addHL7ExportRule(HL7ExportRule rule) {
        this.hl7ExportRules.add(rule);
    }

    public Collection<HL7ExportRule> getHL7ExportRules() {
        return this.hl7ExportRules;
    }

    public void removeHL7PrefetchRule(HL7PrefetchRule rule) {
        this.hl7PrefetchRules.remove(rule);
    }

    public void clearHL7PrefetchRules() {
        this.hl7PrefetchRules.clear();
    }

    public void addHL7PrefetchRule(HL7PrefetchRule rule) {
        this.hl7PrefetchRules.add(rule);
    }

    public Collection<HL7PrefetchRule> getHL7PrefetchRules() {
        return this.hl7PrefetchRules;
    }

    public void removeRSForwardRule(RSForwardRule rule) {
        this.rsForwardRules.remove(rule);
    }

    public void clearRSForwardRules() {
        this.rsForwardRules.clear();
    }

    public void addRSForwardRule(RSForwardRule rule) {
        this.rsForwardRules.add(rule);
    }

    public Collection<RSForwardRule> getRSForwardRules() {
        return this.rsForwardRules;
    }

    public void removeHL7ForwardRule(HL7ForwardRule rule) {
        this.hl7ForwardRules.remove(rule);
    }

    public void clearHL7ForwardRules() {
        this.hl7ForwardRules.clear();
    }

    public void addHL7ForwardRule(HL7ForwardRule rule) {
        this.hl7ForwardRules.add(rule);
    }

    public Collection<HL7ForwardRule> getHL7ForwardRules() {
        return this.hl7ForwardRules;
    }

    public void removeHL7OrderScheduledStation(HL7OrderScheduledStation scheduledStation) {
        this.hl7OrderScheduledStations.remove(scheduledStation);
    }

    public void clearHL7OrderScheduledStations() {
        this.hl7OrderScheduledStations.clear();
    }

    public void addHL7OrderScheduledStation(HL7OrderScheduledStation scheduledStation) {
        this.hl7OrderScheduledStations.add(scheduledStation);
    }

    public Collection<HL7OrderScheduledStation> getHL7OrderScheduledStations() {
        return this.hl7OrderScheduledStations;
    }

    public void removeHL7OrderSPSStatus(HL7OrderSPSStatus rule) {
        this.hl7OrderSPSStatuses.remove((Object)rule.getSPSStatus());
    }

    public void clearHL7OrderSPSStatuses() {
        this.hl7OrderSPSStatuses.clear();
    }

    public void addHL7OrderSPSStatus(HL7OrderSPSStatus rule) {
        this.hl7OrderSPSStatuses.put(rule.getSPSStatus(), rule);
    }

    public Map<SPSStatus, HL7OrderSPSStatus> getHL7OrderSPSStatuses() {
        return this.hl7OrderSPSStatuses;
    }

    public void removeCompressionRule(ArchiveCompressionRule rule) {
        this.compressionRules.remove(rule);
    }

    public void clearCompressionRules() {
        this.compressionRules.clear();
    }

    public void addCompressionRule(ArchiveCompressionRule rule) {
        this.compressionRules.add(rule);
    }

    public Collection<ArchiveCompressionRule> getCompressionRules() {
        return this.compressionRules;
    }

    public void removeStudyRetentionPolicy(StudyRetentionPolicy policy) {
        this.studyRetentionPolicies.remove(policy);
    }

    public void clearStudyRetentionPolicies() {
        this.studyRetentionPolicies.clear();
    }

    public void addStudyRetentionPolicy(StudyRetentionPolicy policy) {
        this.studyRetentionPolicies.add(policy);
    }

    public Collection<StudyRetentionPolicy> getStudyRetentionPolicies() {
        return this.studyRetentionPolicies;
    }

    public void removeHL7StudyRetentionPolicy(HL7StudyRetentionPolicy policy) {
        this.hl7StudyRetentionPolicies.remove(policy);
    }

    public void clearHL7StudyRetentionPolicies() {
        this.hl7StudyRetentionPolicies.clear();
    }

    public void addHL7StudyRetentionPolicy(HL7StudyRetentionPolicy policy) {
        this.hl7StudyRetentionPolicies.add(policy);
    }

    public Collection<HL7StudyRetentionPolicy> getHL7StudyRetentionPolicies() {
        return this.hl7StudyRetentionPolicies;
    }

    public void removeAttributeCoercion(ArchiveAttributeCoercion coercion) {
        this.attributeCoercions.remove(coercion);
    }

    public void clearAttributeCoercions() {
        this.attributeCoercions.clear();
    }

    public void addAttributeCoercion(ArchiveAttributeCoercion coercion) {
        this.attributeCoercions.add(coercion);
    }

    public Collection<ArchiveAttributeCoercion> getAttributeCoercions() {
        return this.attributeCoercions;
    }

    public void removeAttributeCoercion2(ArchiveAttributeCoercion2 coercion) {
        this.attributeCoercions2.remove(coercion);
    }

    public void clearAttributeCoercions2() {
        this.attributeCoercions2.clear();
    }

    public void addAttributeCoercion2(ArchiveAttributeCoercion2 coercion) {
        this.attributeCoercions2.add(coercion);
    }

    public Collection<ArchiveAttributeCoercion2> getAttributeCoercions2() {
        return this.attributeCoercions2;
    }

    public void removeStoreAccessControlIDRule(StoreAccessControlIDRule storeAccessControlIDRule) {
        this.storeAccessControlIDRules.remove(storeAccessControlIDRule);
    }

    public void clearStoreAccessControlIDRules() {
        this.storeAccessControlIDRules.clear();
    }

    public void addStoreAccessControlIDRule(StoreAccessControlIDRule storeAccessControlIDRule) {
        this.storeAccessControlIDRules.add(storeAccessControlIDRule);
    }

    public List<StoreAccessControlIDRule> getStoreAccessControlIDRules() {
        return this.storeAccessControlIDRules;
    }

    public void removeMWLIdleTimeout(MWLIdleTimeout mwlIdleTimeout) {
        this.mwlIdleTimeoutList.remove(mwlIdleTimeout);
    }

    public void clearMWLIdleTimeouts() {
        this.mwlIdleTimeoutList.clear();
    }

    public void addMWLIdleTimeout(MWLIdleTimeout mwlIdleTimeout) {
        this.mwlIdleTimeoutList.add(mwlIdleTimeout);
    }

    public List<MWLIdleTimeout> getMWLIdleTimeouts() {
        return this.mwlIdleTimeoutList;
    }

    public void removeMWLImport(MWLImport mWLImport) {
        this.mwlImportList.remove(mWLImport);
    }

    public void clearMWLImports() {
        this.mwlImportList.clear();
    }

    public void addMWLImport(MWLImport mWLImport) {
        this.mwlImportList.add(mWLImport);
    }

    public List<MWLImport> getMWLImports() {
        return this.mwlImportList;
    }

    public RejectionNote getRejectionNote(String rjNoteID) {
        return this.rejectionNoteMap.get(rjNoteID);
    }

    public RejectionNote getRejectionNote(Code code) {
        if (code != null) {
            for (RejectionNote rjNote : this.rejectionNoteMap.values()) {
                if (!rjNote.getRejectionNoteCode().equalsIgnoreMeaning(code)) continue;
                return rjNote;
            }
        }
        return null;
    }

    public RejectionNote getRejectionNote(RejectionNote.Type rejectionNoteType) {
        for (RejectionNote rejectionNote : this.rejectionNoteMap.values()) {
            if (rejectionNote.getRejectionNoteType() != rejectionNoteType) continue;
            return rejectionNote;
        }
        return null;
    }

    public RejectionNote removeRejectionNote(String rjNoteID) {
        return this.rejectionNoteMap.remove(rjNoteID);
    }

    public void addRejectionNote(RejectionNote rjNote) {
        this.rejectionNoteMap.put(rjNote.getRejectionNoteLabel(), rjNote);
    }

    public Collection<RejectionNote> getRejectionNotes() {
        return this.rejectionNoteMap.values();
    }

    public AllowDeleteStudyPermanently getAllowDeleteStudyPermanently() {
        return this.allowDeleteStudyPermanently;
    }

    public void setAllowDeleteStudyPermanently(AllowDeleteStudyPermanently allowDeleteStudyPermanently) {
        this.allowDeleteStudyPermanently = allowDeleteStudyPermanently;
    }

    public AllowDeletePatient getAllowDeletePatient() {
        return this.allowDeletePatient;
    }

    public void setAllowDeletePatient(AllowDeletePatient allowDeletePatient) {
        this.allowDeletePatient = allowDeletePatient;
    }

    public AcceptConflictingPatientID getAcceptConflictingPatientID() {
        return this.acceptConflictingPatientID;
    }

    public void setAcceptConflictingPatientID(AcceptConflictingPatientID acceptConflictingPatientID) {
        this.acceptConflictingPatientID = acceptConflictingPatientID;
    }

    public UserIdentityNegotiation getUserIdentityNegotiation() {
        return this.userIdentityNegotiation;
    }

    public void setUserIdentityNegotiation(UserIdentityNegotiation userIdentityNegotiation) {
        this.userIdentityNegotiation = userIdentityNegotiation;
    }

    public String getUserIdentityNegotiationRole() {
        return this.userIdentityNegotiationRole;
    }

    public void setUserIdentityNegotiationRole(String userIdentityNegotiationRole) {
        this.userIdentityNegotiationRole = userIdentityNegotiationRole;
    }

    public String getUserIdentityNegotiationKeycloakClientID() {
        return this.userIdentityNegotiationKeycloakClientID;
    }

    public void setUserIdentityNegotiationKeycloakClientID(String userIdentityNegotiationKeycloakClientID) {
        this.userIdentityNegotiationKeycloakClientID = userIdentityNegotiationKeycloakClientID;
    }

    public String[] getRetrieveAETitles() {
        return this.retrieveAETitles;
    }

    public void setRetrieveAETitles(String ... retrieveAETitles) {
        this.retrieveAETitles = retrieveAETitles;
    }

    public String[] getReturnRetrieveAETitles() {
        return this.returnRetrieveAETitles;
    }

    public void setReturnRetrieveAETitles(String ... returnRetrieveAETitles) {
        this.returnRetrieveAETitles = returnRetrieveAETitles;
    }

    public String getProxyUpstreamURL() {
        return this.proxyUpstreamURL;
    }

    public void setProxyUpstreamURL(String proxyUpstreamURL) {
        this.proxyUpstreamURL = proxyUpstreamURL;
    }

    public String getAudit2JsonFhirTemplateURI() {
        return this.atna2JsonFhirTemplateURI;
    }

    public void setAudit2JsonFhirTemplateURI(String atna2JsonFhirTemplateURI) {
        this.atna2JsonFhirTemplateURI = atna2JsonFhirTemplateURI;
    }

    public String getAudit2XmlFhirTemplateURI() {
        return this.atna2XmlFhirTemplateURI;
    }

    public void setAudit2XmlFhirTemplateURI(String atna2XmlFhirTemplateURI) {
        this.atna2XmlFhirTemplateURI = atna2XmlFhirTemplateURI;
    }

    public Attributes.UpdatePolicy getCopyMoveUpdatePolicy() {
        return this.copyMoveUpdatePolicy;
    }

    public void setCopyMoveUpdatePolicy(Attributes.UpdatePolicy copyMoveUpdatePolicy) {
        this.copyMoveUpdatePolicy = copyMoveUpdatePolicy;
    }

    public Attributes.UpdatePolicy getLinkMWLEntryUpdatePolicy() {
        return this.linkMWLEntryUpdatePolicy;
    }

    public void setLinkMWLEntryUpdatePolicy(Attributes.UpdatePolicy linkMWLEntryUpdatePolicy) {
        this.linkMWLEntryUpdatePolicy = linkMWLEntryUpdatePolicy;
    }

    public boolean isHL7TrackChangedPatientID() {
        return this.hl7TrackChangedPatientID;
    }

    public void setHL7TrackChangedPatientID(boolean hl7TrackChangedPatientID) {
        this.hl7TrackChangedPatientID = hl7TrackChangedPatientID;
    }

    public boolean isAuditSoftwareConfigurationVerbose() {
        return this.auditSoftwareConfigurationVerbose;
    }

    public void setAuditSoftwareConfigurationVerbose(boolean auditSoftwareConfigurationVerbose) {
        this.auditSoftwareConfigurationVerbose = auditSoftwareConfigurationVerbose;
    }

    public String[] getHL7ADTReceivingApplication() {
        return this.hl7ADTReceivingApplication;
    }

    public void setHL7ADTReceivingApplication(String[] hl7ADTReceivingApplication) {
        this.hl7ADTReceivingApplication = hl7ADTReceivingApplication;
    }

    public String getHL7ADTSendingApplication() {
        return this.hl7ADTSendingApplication;
    }

    public void setHL7ADTSendingApplication(String hl7ADTSendingApplication) {
        this.hl7ADTSendingApplication = hl7ADTSendingApplication;
    }

    public ScheduledProtocolCodeInOrder getHL7ScheduledProtocolCodeInOrder() {
        return this.hl7ScheduledProtocolCodeInOrder;
    }

    public void setHL7ScheduledProtocolCodeInOrder(ScheduledProtocolCodeInOrder hl7ScheduledProtocolCodeInOrder) {
        this.hl7ScheduledProtocolCodeInOrder = hl7ScheduledProtocolCodeInOrder;
    }

    public ScheduledStationAETInOrder getHL7ScheduledStationAETInOrder() {
        return this.hl7ScheduledStationAETInOrder;
    }

    public void setHL7ScheduledStationAETInOrder(ScheduledStationAETInOrder hl7ScheduledStationAETInOrder) {
        this.hl7ScheduledStationAETInOrder = hl7ScheduledStationAETInOrder;
    }

    public String getAuditUnknownStudyInstanceUID() {
        return this.auditUnknownStudyInstanceUID;
    }

    public void setAuditUnknownStudyInstanceUID(String auditUnknownStudyInstanceUID) {
        this.auditUnknownStudyInstanceUID = auditUnknownStudyInstanceUID;
    }

    public String auditUnknownStudyInstanceUID() {
        return (String)StringUtils.maskNull((Object)this.auditUnknownStudyInstanceUID, (Object)AUDIT_UNKNOWN_STUDY_INSTANCE_UID);
    }

    public String getAuditUnknownPatientID() {
        return this.auditUnknownPatientID;
    }

    public void setAuditUnknownPatientID(String auditUnknownPatientID) {
        this.auditUnknownPatientID = auditUnknownPatientID;
    }

    public String auditUnknownPatientID() {
        return (String)StringUtils.maskNull((Object)this.auditUnknownPatientID, (Object)AUDIT_UNKNOWN_PATIENT_ID);
    }

    public boolean isHL7UseNullValue() {
        return this.hl7UseNullValue;
    }

    public void setHL7UseNullValue(boolean hl7UseNullValue) {
        this.hl7UseNullValue = hl7UseNullValue;
    }

    public int getQueueTasksFetchSize() {
        return this.queueTasksFetchSize;
    }

    public void setQueueTasksFetchSize(int queueTasksFetchSize) {
        this.queueTasksFetchSize = queueTasksFetchSize;
    }

    public int getAuditHL7MsgLimit() {
        return this.auditHL7MsgLimit;
    }

    public void setAuditHL7MsgLimit(int auditHL7MsgLimit) {
        this.auditHL7MsgLimit = auditHL7MsgLimit;
    }

    public String getRejectionNoteStorageAET() {
        return this.rejectionNoteStorageAET;
    }

    public void setRejectionNoteStorageAET(String rejectionNoteStorageAET) {
        this.rejectionNoteStorageAET = rejectionNoteStorageAET;
    }

    public String getUiConfigurationDeviceName() {
        return this.uiConfigurationDeviceName;
    }

    public void setUiConfigurationDeviceName(String uiConfigurationDeviceName) {
        this.uiConfigurationDeviceName = uiConfigurationDeviceName;
    }

    public StorageVerificationPolicy getStorageVerificationPolicy() {
        return this.storageVerificationPolicy;
    }

    public void setStorageVerificationPolicy(StorageVerificationPolicy storageVerificationPolicy) {
        this.storageVerificationPolicy = storageVerificationPolicy;
    }

    public boolean isStorageVerificationUpdateLocationStatus() {
        return this.storageVerificationUpdateLocationStatus;
    }

    public void setStorageVerificationUpdateLocationStatus(boolean storageVerificationUpdateLocationStatus) {
        this.storageVerificationUpdateLocationStatus = storageVerificationUpdateLocationStatus;
    }

    public String[] getStorageVerificationStorageIDs() {
        return this.storageVerificationStorageIDs;
    }

    public void setStorageVerificationStorageIDs(String ... storageVerificationStorageIDs) {
        this.storageVerificationStorageIDs = storageVerificationStorageIDs;
    }

    public String getStorageVerificationAETitle() {
        return this.storageVerificationAETitle;
    }

    public void setStorageVerificationAETitle(String storageVerificationAETitle) {
        this.storageVerificationAETitle = storageVerificationAETitle;
    }

    public String getStorageVerificationBatchID() {
        return this.storageVerificationBatchID;
    }

    public void setStorageVerificationBatchID(String storageVerificationBatchID) {
        this.storageVerificationBatchID = storageVerificationBatchID;
    }

    public Period getStorageVerificationInitialDelay() {
        return this.storageVerificationInitialDelay;
    }

    public void setStorageVerificationInitialDelay(Period storageVerificationInitialDelay) {
        this.storageVerificationInitialDelay = storageVerificationInitialDelay;
    }

    public Period getStorageVerificationPeriod() {
        return this.storageVerificationPeriod;
    }

    public void setStorageVerificationPeriod(Period storageVerificationPeriod) {
        this.storageVerificationPeriod = storageVerificationPeriod;
    }

    public ScheduleExpression[] getStorageVerificationSchedules() {
        return this.storageVerificationSchedules;
    }

    public void setStorageVerificationSchedules(ScheduleExpression[] storageVerificationSchedules) {
        this.storageVerificationSchedules = storageVerificationSchedules;
    }

    public int getStorageVerificationMaxScheduled() {
        return this.storageVerificationMaxScheduled;
    }

    public void setStorageVerificationMaxScheduled(int storageVerificationMaxScheduled) {
        this.storageVerificationMaxScheduled = storageVerificationMaxScheduled;
    }

    public Duration getStorageVerificationPollingInterval() {
        return this.storageVerificationPollingInterval;
    }

    public void setStorageVerificationPollingInterval(Duration storageVerificationPollingInterval) {
        this.storageVerificationPollingInterval = storageVerificationPollingInterval;
    }

    public int getStorageVerificationFetchSize() {
        return this.storageVerificationFetchSize;
    }

    public void setStorageVerificationFetchSize(int storageVerificationFetchSize) {
        this.storageVerificationFetchSize = storageVerificationFetchSize;
    }

    public boolean isUpdateLocationStatusOnRetrieve() {
        return this.updateLocationStatusOnRetrieve;
    }

    public void setUpdateLocationStatusOnRetrieve(boolean updateLocationStatusOnRetrieve) {
        this.updateLocationStatusOnRetrieve = updateLocationStatusOnRetrieve;
    }

    public boolean isStorageVerificationOnRetrieve() {
        return this.storageVerificationOnRetrieve;
    }

    public void setStorageVerificationOnRetrieve(boolean storageVerificationOnRetrieve) {
        this.storageVerificationOnRetrieve = storageVerificationOnRetrieve;
    }

    public String getCompressionAETitle() {
        return this.compressionAETitle;
    }

    public void setCompressionAETitle(String compressionAETitle) {
        this.compressionAETitle = compressionAETitle;
    }

    public Duration getCompressionPollingInterval() {
        return this.compressionPollingInterval;
    }

    public void setCompressionPollingInterval(Duration compressionPollingInterval) {
        this.compressionPollingInterval = compressionPollingInterval;
    }

    public int getCompressionFetchSize() {
        return this.compressionFetchSize;
    }

    public void setCompressionFetchSize(int compressionFetchSize) {
        this.compressionFetchSize = this.greaterZero(compressionFetchSize, "CompressionFetchSize");
    }

    public int getCompressionThreads() {
        return this.compressionThreads;
    }

    public void setCompressionThreads(int compressionThreads) {
        this.compressionThreads = this.greaterZero(compressionThreads, "CompressionThreads");
    }

    public ScheduleExpression[] getCompressionSchedules() {
        return this.compressionSchedules;
    }

    public void setCompressionSchedules(ScheduleExpression[] compressionSchedules) {
        this.compressionSchedules = compressionSchedules;
    }

    public Duration getDiffTaskProgressUpdateInterval() {
        return this.diffTaskProgressUpdateInterval;
    }

    public void setDiffTaskProgressUpdateInterval(Duration diffTaskProgressUpdateInterval) {
        this.diffTaskProgressUpdateInterval = diffTaskProgressUpdateInterval;
    }

    public void setPatientVerificationPDQServiceID(String patientVerificationPDQServiceID) {
        this.patientVerificationPDQServiceID = patientVerificationPDQServiceID;
    }

    public Duration getPatientVerificationPollingInterval() {
        return this.patientVerificationPollingInterval;
    }

    public void setPatientVerificationPollingInterval(Duration patientVerificationPollingInterval) {
        this.patientVerificationPollingInterval = patientVerificationPollingInterval;
    }

    public int getPatientVerificationFetchSize() {
        return this.patientVerificationFetchSize;
    }

    public void setPatientVerificationFetchSize(int patientVerificationFetchSize) {
        this.patientVerificationFetchSize = patientVerificationFetchSize;
    }

    public String getPatientVerificationPDQServiceID() {
        return this.patientVerificationPDQServiceID;
    }

    public Period getPatientVerificationPeriod() {
        return this.patientVerificationPeriod;
    }

    public void setPatientVerificationPeriod(Period patientVerificationPeriod) {
        this.patientVerificationPeriod = patientVerificationPeriod;
    }

    public Period getPatientVerificationPeriodOnNotFound() {
        return this.patientVerificationPeriodOnNotFound;
    }

    public void setPatientVerificationPeriodOnNotFound(Period patientVerificationPeriodOnNotFound) {
        this.patientVerificationPeriodOnNotFound = patientVerificationPeriodOnNotFound;
    }

    public Duration getPatientVerificationRetryInterval() {
        return this.patientVerificationRetryInterval;
    }

    public void setPatientVerificationRetryInterval(Duration patientVerificationRetryInterval) {
        this.patientVerificationRetryInterval = patientVerificationRetryInterval;
    }

    public int getPatientVerificationMaxRetries() {
        return this.patientVerificationMaxRetries;
    }

    public void setPatientVerificationMaxRetries(int patientVerificationMaxRetries) {
        this.patientVerificationMaxRetries = patientVerificationMaxRetries;
    }

    public boolean isPatientVerificationAdjustIssuerOfPatientID() {
        return this.patientVerificationAdjustIssuerOfPatientID;
    }

    public void setPatientVerificationAdjustIssuerOfPatientID(boolean patientVerificationAdjustIssuerOfPatientID) {
        this.patientVerificationAdjustIssuerOfPatientID = patientVerificationAdjustIssuerOfPatientID;
    }

    public Duration getPatientVerificationMaxStaleness() {
        return this.patientVerificationMaxStaleness;
    }

    public void setPatientVerificationMaxStaleness(Duration patientVerificationMaxStaleness) {
        this.patientVerificationMaxStaleness = patientVerificationMaxStaleness;
    }

    public MultipleStoreAssociations[] getMultipleStoreAssociations() {
        return this.multipleStoreAssociations;
    }

    public void setMultipleStoreAssociations(String[] ss) {
        this.multipleStoreAssociations = MultipleStoreAssociations.of(ss);
    }

    public Map<String, String> getImportReportTemplateParams() {
        return this.importReportTemplateParams;
    }

    public void setImportReportTemplateParam(String name, String value) {
        this.importReportTemplateParams.put(name, value);
    }

    public void setImportReportTemplateParams(String[] ss) {
        this.importReportTemplateParams.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("XSLT parameter in incorrect format : " + s);
            }
            this.setImportReportTemplateParam(s.substring(0, index), s.substring(index + 1));
        }
    }

    public Map<String, String> getHL7PSUTemplateParams() {
        return this.hl7PSUTemplateParams;
    }

    public void setHL7PSUTemplateParam(String name, String value) {
        this.hl7PSUTemplateParams.put(name, value);
    }

    public void setHL7PSUTemplateParams(String[] ss) {
        this.hl7PSUTemplateParams.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("XSLT parameter in incorrect format : " + s);
            }
            this.setHL7PSUTemplateParam(s.substring(0, index), s.substring(index + 1));
        }
    }

    public Map<String, String> getCStoreSCUOfCMoveSCPs() {
        return this.cStoreSCUOfCMoveSCP;
    }

    public void setCStoreSCUOfCMoveSCP(String storeSCU, String moveSCP) {
        this.cStoreSCUOfCMoveSCP.put(storeSCU, moveSCP);
    }

    public void setCStoreSCUOfCMoveSCPs(String[] ss) {
        this.cStoreSCUOfCMoveSCP.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("CStoreSCUofCMoveSCP in incorrect format : " + s);
            }
            this.setCStoreSCUOfCMoveSCP(s.substring(0, index), s.substring(index + 1));
        }
    }

    public Map<String, String> getDicomCharsetNameMappings() {
        return this.dicomCharsetNameMappings;
    }

    public void setDicomCharsetNameMappings(String code, String charsetName) {
        this.dicomCharsetNameMappings.put(SpecificCharacterSet.checkSpecificCharacterSet((String)code), SpecificCharacterSet.checkCharsetName((String)charsetName));
    }

    public void setDicomCharsetNameMappings(String[] ss) {
        HashMap<String, String> prev = new HashMap<String, String>(this.dicomCharsetNameMappings);
        this.dicomCharsetNameMappings.clear();
        try {
            for (String s : ss) {
                int index = s.indexOf(61);
                if (index < 0) {
                    throw new IllegalArgumentException("DicomCharsetNameMapping in incorrect format : " + s);
                }
                this.setDicomCharsetNameMappings(s.substring(0, index), s.substring(index + 1));
            }
        }
        catch (IllegalArgumentException e) {
            this.dicomCharsetNameMappings.clear();
            this.dicomCharsetNameMappings.putAll(prev);
            throw e;
        }
    }

    public Map<String, String> getHL7CharsetNameMappings() {
        return this.hl7CharsetNameMappings;
    }

    public void setHL7CharsetNameMappings(String code, String charsetName) {
        this.hl7CharsetNameMappings.put(code, SpecificCharacterSet.checkCharsetName((String)charsetName));
    }

    public void setHL7CharsetNameMappings(String[] ss) {
        HashMap<String, String> prev = new HashMap<String, String>(this.hl7CharsetNameMappings);
        this.hl7CharsetNameMappings.clear();
        try {
            for (String s : ss) {
                int index = s.indexOf(61);
                if (index < 0) {
                    throw new IllegalArgumentException("HL7CharsetNameMapping in incorrect format : " + s);
                }
                this.setHL7CharsetNameMappings(s.substring(0, index), s.substring(index + 1));
            }
        }
        catch (IllegalArgumentException e) {
            this.hl7CharsetNameMappings.clear();
            this.hl7CharsetNameMappings.putAll(prev);
            throw e;
        }
    }

    public Map<String, Integer> getUPSEventWebSocketQueueSizes() {
        return this.upsEventWebSocketQueueSizes;
    }

    public void setUPSEventWebSocketQueueSize(String subscriberAET, int size) {
        if (size > 0) {
            this.upsEventWebSocketQueueSizes.put(subscriberAET, size);
        } else {
            this.upsEventWebSocketQueueSizes.remove(subscriberAET);
        }
    }

    public int getUPSEventWebSocketQueueSize(String subscriberAET) {
        return this.upsEventWebSocketQueueSizes.getOrDefault(subscriberAET, 0);
    }

    public void setUPSEventWebSocketQueueSizes(String[] ss) {
        HashMap<String, Integer> prev = new HashMap<String, Integer>(this.upsEventWebSocketQueueSizes);
        this.upsEventWebSocketQueueSizes.clear();
        try {
            for (String s : ss) {
                int index = s.indexOf(61);
                try {
                    this.setUPSEventWebSocketQueueSize(s.substring(0, index), Integer.valueOf(s.substring(index + 1)));
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    throw new IllegalArgumentException("UPSEventWebSocketQueueSize in incorrect format: " + s);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.upsEventWebSocketQueueSizes.clear();
            this.upsEventWebSocketQueueSizes.putAll(prev);
            throw e;
        }
    }

    public HL7OrderMissingStudyIUIDPolicy getHl7OrderMissingStudyIUIDPolicy() {
        return this.hl7OrderMissingStudyIUIDPolicy;
    }

    public void setHl7OrderMissingStudyIUIDPolicy(HL7OrderMissingStudyIUIDPolicy hl7OrderMissingStudyIUIDPolicy) {
        this.hl7OrderMissingStudyIUIDPolicy = hl7OrderMissingStudyIUIDPolicy;
    }

    public HL7OrderMissingAdmissionIDPolicy getHl7OrderMissingAdmissionIDPolicy() {
        return this.hl7OrderMissingAdmissionIDPolicy;
    }

    public void setHl7OrderMissingAdmissionIDPolicy(HL7OrderMissingAdmissionIDPolicy hl7OrderMissingAdmissionIDPolicy) {
        this.hl7OrderMissingAdmissionIDPolicy = hl7OrderMissingAdmissionIDPolicy;
    }

    public HL7ImportReportMissingStudyIUIDPolicy getHl7ImportReportMissingStudyIUIDPolicy() {
        return this.hl7ImportReportMissingStudyIUIDPolicy;
    }

    public void setHl7ImportReportMissingStudyIUIDPolicy(HL7ImportReportMissingStudyIUIDPolicy hl7ImportReportMissingStudyIUIDPolicy) {
        this.hl7ImportReportMissingStudyIUIDPolicy = hl7ImportReportMissingStudyIUIDPolicy;
    }

    public HL7ImportReportMissingAdmissionIDPolicy getHl7ImportReportMissingAdmissionIDPolicy() {
        return this.hl7ImportReportMissingAdmissionIDPolicy;
    }

    public void setHl7ImportReportMissingAdmissionIDPolicy(HL7ImportReportMissingAdmissionIDPolicy hl7ImportReportMissingAdmissionIDPolicy) {
        this.hl7ImportReportMissingAdmissionIDPolicy = hl7ImportReportMissingAdmissionIDPolicy;
    }

    public String getHl7ImportReportMissingStudyIUIDCFindSCP() {
        return this.hl7ImportReportMissingStudyIUIDCFindSCP;
    }

    public void setHl7ImportReportMissingStudyIUIDCFindSCP(String hl7ImportReportMissingStudyIUIDCFindSCP) {
        this.hl7ImportReportMissingStudyIUIDCFindSCP = hl7ImportReportMissingStudyIUIDCFindSCP;
    }

    public HL7ImportReportAdjustIUID getHl7ImportReportAdjustIUID() {
        return this.hl7ImportReportAdjustIUID;
    }

    public void setHl7ImportReportAdjustIUID(HL7ImportReportAdjustIUID hl7ImportReportAdjustIUID) {
        this.hl7ImportReportAdjustIUID = hl7ImportReportAdjustIUID;
    }

    public HL7ReferredMergedPatientPolicy getHl7ReferredMergedPatientPolicy() {
        return this.hl7ReferredMergedPatientPolicy;
    }

    public void setHl7ReferredMergedPatientPolicy(HL7ReferredMergedPatientPolicy hl7ReferredMergedPatientPolicy) {
        this.hl7ReferredMergedPatientPolicy = hl7ReferredMergedPatientPolicy;
    }

    public String getHl7DicomCharacterSet() {
        return this.hl7DicomCharacterSet;
    }

    public void setHl7DicomCharacterSet(String hl7DicomCharacterSet) {
        this.hl7DicomCharacterSet = hl7DicomCharacterSet;
    }

    public boolean isHl7VeterinaryUsePatientName() {
        return this.hl7VeterinaryUsePatientName;
    }

    public void setHl7VeterinaryUsePatientName(boolean hl7VeterinaryUsePatientName) {
        this.hl7VeterinaryUsePatientName = hl7VeterinaryUsePatientName;
    }

    public String getHL7PatientArrivalMessageType() {
        return this.hl7PatientArrivalMessageType;
    }

    public void setHL7PatientArrivalMessageType(String hl7PatientArrivalMessageType) {
        this.hl7PatientArrivalMessageType = hl7PatientArrivalMessageType;
    }

    public int getCSVUploadChunkSize() {
        return this.csvUploadChunkSize;
    }

    public void setCSVUploadChunkSize(int csvUploadChunkSize) {
        this.csvUploadChunkSize = csvUploadChunkSize;
    }

    public boolean isValidateUID() {
        return this.validateUID;
    }

    public void setValidateUID(boolean validateUID) {
        this.validateUID = validateUID;
    }

    public boolean isRelationalQueryNegotiationLenient() {
        return this.relationalQueryNegotiationLenient;
    }

    public void setRelationalQueryNegotiationLenient(boolean relationalQueryNegotiationLenient) {
        this.relationalQueryNegotiationLenient = relationalQueryNegotiationLenient;
    }

    public boolean isRelationalRetrieveNegotiationLenient() {
        return this.relationalRetrieveNegotiationLenient;
    }

    public void setRelationalRetrieveNegotiationLenient(boolean relationalRetrieveNegotiationLenient) {
        this.relationalRetrieveNegotiationLenient = relationalRetrieveNegotiationLenient;
    }

    public int[] getRejectConflictingPatientAttribute() {
        return this.rejectConflictingPatientAttribute;
    }

    public void setRejectConflictingPatientAttribute(int[] rejectConflictingPatientAttribute) {
        this.rejectConflictingPatientAttribute = rejectConflictingPatientAttribute;
        Arrays.sort(rejectConflictingPatientAttribute);
    }

    public int getSchedulerMinStartDelay() {
        return this.schedulerMinStartDelay;
    }

    public void setSchedulerMinStartDelay(int schedulerMinStartDelay) {
        this.schedulerMinStartDelay = schedulerMinStartDelay;
    }

    public boolean isStowRetiredTransferSyntax() {
        return this.stowRetiredTransferSyntax;
    }

    public void setStowRetiredTransferSyntax(boolean stowRetiredTransferSyntax) {
        this.stowRetiredTransferSyntax = stowRetiredTransferSyntax;
    }

    public boolean isStowExcludeAPPMarkers() {
        return this.stowExcludeAPPMarkers;
    }

    public void setStowExcludeAPPMarkers(boolean stowExcludeAPPMarkers) {
        this.stowExcludeAPPMarkers = stowExcludeAPPMarkers;
    }

    public boolean isRestrictRetrieveSilently() {
        return this.restrictRetrieveSilently;
    }

    public void setRestrictRetrieveSilently(boolean restrictRetrieveSilently) {
        this.restrictRetrieveSilently = restrictRetrieveSilently;
    }

    public boolean isRetrieveTaskWarningOnNoMatch() {
        return this.retrieveTaskWarningOnNoMatch;
    }

    public void setRetrieveTaskWarningOnNoMatch(boolean retrieveTaskWarningOnNoMatch) {
        this.retrieveTaskWarningOnNoMatch = retrieveTaskWarningOnNoMatch;
    }

    public boolean isRetrieveTaskWarningOnWarnings() {
        return this.retrieveTaskWarningOnWarnings;
    }

    public void setRetrieveTaskWarningOnWarnings(boolean retrieveTaskWarningOnWarnings) {
        this.retrieveTaskWarningOnWarnings = retrieveTaskWarningOnWarnings;
    }

    public boolean isStowQuicktime2MP4() {
        return this.stowQuicktime2MP4;
    }

    public void setStowQuicktime2MP4(boolean stowQuicktime2MP4) {
        this.stowQuicktime2MP4 = stowQuicktime2MP4;
    }

    public long getStowMaxFragmentLength() {
        return this.stowMaxFragmentLength;
    }

    public void setStowMaxFragmentLength(long stowMaxFragmentLength) {
        ArchiveDeviceExtension.checkStowMaxFragmentLength(stowMaxFragmentLength);
        this.stowMaxFragmentLength = stowMaxFragmentLength;
    }

    static void checkStowMaxFragmentLength(long stowMaxFragmentLength) {
        if (stowMaxFragmentLength < 1024L || stowMaxFragmentLength > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("stowMaxFragmentLength not in range 1024..4294967294");
        }
    }

    public boolean isIdentifyPatientByAllAttributes() {
        return this.identifyPatientByAllAttributes;
    }

    public void setIdentifyPatientByAllAttributes(boolean identifyPatientByAllAttributes) {
        this.identifyPatientByAllAttributes = identifyPatientByAllAttributes;
    }

    public Duration getMWLPollingInterval() {
        return this.mwlPollingInterval;
    }

    public void setMWLPollingInterval(Duration mwlPollingInterval) {
        this.mwlPollingInterval = mwlPollingInterval;
    }

    public int getMWLFetchSize() {
        return this.mwlFetchSize;
    }

    public void setMWLFetchSize(int mwlFetchSize) {
        this.mwlFetchSize = mwlFetchSize;
    }

    public Duration getMWLImportInterval() {
        return this.mwlImportInterval;
    }

    public void setMWLImportInterval(Duration mwlImportInterval) {
        this.mwlImportInterval = mwlImportInterval;
    }

    public String[] getDeleteMWLDelay() {
        return this.deleteMWLDelay;
    }

    public void setDeleteMWLDelay(String[] deleteMWLDelay) {
        this.deleteMWLDelay = deleteMWLDelay;
    }

    public Duration getStudySizeDelay() {
        return this.studySizeDelay;
    }

    public void setStudySizeDelay(Duration studySizeDelay) {
        this.studySizeDelay = studySizeDelay;
    }

    public Duration getCalculateStudySizePollingInterval() {
        return this.calculateStudySizePollingInterval;
    }

    public void setCalculateStudySizePollingInterval(Duration calculateStudySizePollingInterval) {
        this.calculateStudySizePollingInterval = calculateStudySizePollingInterval;
    }

    public int getCalculateStudySizeFetchSize() {
        return this.calculateStudySizeFetchSize;
    }

    public void setCalculateStudySizeFetchSize(int calculateStudySizeFetchSize) {
        this.calculateStudySizeFetchSize = calculateStudySizeFetchSize;
    }

    public boolean isCalculateQueryAttributes() {
        return this.calculateQueryAttributes;
    }

    public void setCalculateQueryAttributes(boolean calculateQueryAttributes) {
        this.calculateQueryAttributes = calculateQueryAttributes;
    }

    public boolean isStoreImplementationVersionName() {
        return this.storeImplementationVersionName;
    }

    public void setStoreImplementationVersionName(boolean storeImplementationVersionName) {
        this.storeImplementationVersionName = storeImplementationVersionName;
    }

    public int getSupplementIssuerFetchSize() {
        return this.supplementIssuerFetchSize;
    }

    public void setSupplementIssuerFetchSize(int supplementIssuerFetchSize) {
        this.supplementIssuerFetchSize = supplementIssuerFetchSize;
    }

    public int getUpdateCharsetFetchSize() {
        return this.updateCharsetFetchSize;
    }

    public void setUpdateCharsetFetchSize(int updateCharsetFetchSize) {
        this.updateCharsetFetchSize = updateCharsetFetchSize;
    }

    public Issuer getAuditAssigningAuthorityOfPatientID() {
        return this.auditAssigningAuthorityOfPatientID;
    }

    public void setAuditAssigningAuthorityOfPatientID(Issuer auditAssigningAuthorityOfPatientID) {
        this.auditAssigningAuthorityOfPatientID = auditAssigningAuthorityOfPatientID;
    }

    public String getChangeRequesterAET() {
        return this.changeRequesterAET;
    }

    public void setChangeRequesterAET(String changeRequesterAET) {
        this.changeRequesterAET = changeRequesterAET;
    }

    public void reconfigure(DeviceExtension from) {
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)from;
        this.defaultCharacterSet = arcdev.defaultCharacterSet;
        this.upsWorklistLabel = arcdev.upsWorklistLabel;
        this.upsEventSCUs = arcdev.upsEventSCUs;
        this.upsEventSCUKeepAlive = arcdev.upsEventSCUKeepAlive;
        this.upsUpdateWithoutTransactionUID = arcdev.upsUpdateWithoutTransactionUID;
        this.fuzzyAlgorithmClass = arcdev.fuzzyAlgorithmClass;
        this.fuzzyStr = arcdev.fuzzyStr;
        this.bulkDataDescriptorID = arcdev.bulkDataDescriptorID;
        this.seriesMetadataStorageIDs = arcdev.seriesMetadataStorageIDs;
        this.seriesMetadataDelay = arcdev.seriesMetadataDelay;
        this.seriesMetadataPollingInterval = arcdev.seriesMetadataPollingInterval;
        this.seriesMetadataFetchSize = arcdev.seriesMetadataFetchSize;
        this.seriesMetadataThreads = arcdev.seriesMetadataThreads;
        this.seriesMetadataRetryInterval = arcdev.seriesMetadataRetryInterval;
        this.purgeInstanceRecords = arcdev.purgeInstanceRecords;
        this.purgeInstanceRecordsDelay = arcdev.purgeInstanceRecordsDelay;
        this.purgeInstanceRecordsPollingInterval = arcdev.purgeInstanceRecordsPollingInterval;
        this.purgeInstanceRecordsFetchSize = arcdev.purgeInstanceRecordsFetchSize;
        this.deleteUPSPollingInterval = arcdev.deleteUPSPollingInterval;
        this.deleteUPSFetchSize = arcdev.deleteUPSFetchSize;
        this.deleteUPSCompletedDelay = arcdev.deleteUPSCompletedDelay;
        this.deleteUPSCanceledDelay = arcdev.deleteUPSCanceledDelay;
        this.upsProcessingPollingInterval = arcdev.upsProcessingPollingInterval;
        this.upsProcessingFetchSize = arcdev.upsProcessingFetchSize;
        this.taskPollingInterval = arcdev.taskPollingInterval;
        this.taskFetchSize = arcdev.taskFetchSize;
        this.overwritePolicy = arcdev.overwritePolicy;
        this.recordAttributeModification = arcdev.recordAttributeModification;
        this.showPatientInfoInSystemLog = arcdev.showPatientInfoInSystemLog;
        this.showPatientInfoInAuditLog = arcdev.showPatientInfoInAuditLog;
        this.bulkDataSpoolDirectory = arcdev.bulkDataSpoolDirectory;
        this.personNameComponentOrderInsensitiveMatching = arcdev.personNameComponentOrderInsensitiveMatching;
        this.validateCallingAEHostname = arcdev.validateCallingAEHostname;
        this.sendPendingCGet = arcdev.sendPendingCGet;
        this.sendPendingCMoveInterval = arcdev.sendPendingCMoveInterval;
        this.encodeAsJSONNumber.clear();
        this.encodeAsJSONNumber.addAll(arcdev.encodeAsJSONNumber);
        this.wadoSupportedSRClasses.clear();
        this.wadoSupportedSRClasses.addAll(arcdev.wadoSupportedSRClasses);
        this.wadoSupportedPRClasses.clear();
        this.wadoSupportedPRClasses.addAll(arcdev.wadoSupportedPRClasses);
        this.wadoIgnorePresentationLUTShape = arcdev.wadoIgnorePresentationLUTShape;
        this.wadoThumbnailViewPort = arcdev.wadoThumbnailViewPort;
        this.wadoZIPEntryNameFormat = arcdev.wadoZIPEntryNameFormat;
        this.wadoSR2HtmlTemplateURI = arcdev.wadoSR2HtmlTemplateURI;
        this.wadoSR2TextTemplateURI = arcdev.wadoSR2TextTemplateURI;
        this.wadoCDA2HtmlTemplateURI = arcdev.wadoCDA2HtmlTemplateURI;
        this.patientUpdateTemplateURI = arcdev.patientUpdateTemplateURI;
        this.importReportTemplateURI = arcdev.importReportTemplateURI;
        this.scheduleProcedureTemplateURI = arcdev.scheduleProcedureTemplateURI;
        this.outgoingPatientUpdateTemplateURI = arcdev.outgoingPatientUpdateTemplateURI;
        this.queryFetchSize = arcdev.queryFetchSize;
        this.queryMaxNumberOfResults = arcdev.queryMaxNumberOfResults;
        this.qidoMaxNumberOfResults = arcdev.qidoMaxNumberOfResults;
        this.qidoETag = arcdev.qidoETag;
        this.filterByIssuerOfPatientID = arcdev.filterByIssuerOfPatientID;
        this.matchSOPClassOnInstanceLevel = arcdev.matchSOPClassOnInstanceLevel;
        this.queryRetrieveViewMap.clear();
        this.queryRetrieveViewMap.putAll(arcdev.queryRetrieveViewMap);
        this.mppsForwardDestinations = arcdev.mppsForwardDestinations;
        this.ianDestinations = arcdev.ianDestinations;
        this.ianDelay = arcdev.ianDelay;
        this.ianTimeout = arcdev.ianTimeout;
        this.ianOnTimeout = arcdev.ianOnTimeout;
        this.ianTaskPollingInterval = arcdev.ianTaskPollingInterval;
        this.ianTaskFetchSize = arcdev.ianTaskFetchSize;
        this.spanningCFindSCP = arcdev.spanningCFindSCP;
        this.spanningCFindSCPRetrieveAETitles = arcdev.spanningCFindSCPRetrieveAETitles;
        this.spanningCFindSCPPolicy = arcdev.spanningCFindSCPPolicy;
        this.fallbackCMoveSCP = arcdev.fallbackCMoveSCP;
        this.fallbackCMoveSCPDestination = arcdev.fallbackCMoveSCPDestination;
        this.fallbackCMoveSCPCallingAET = arcdev.fallbackCMoveSCPCallingAET;
        this.fallbackCMoveSCPLeadingCFindSCP = arcdev.fallbackCMoveSCPLeadingCFindSCP;
        this.fallbackCMoveSCPRetries = arcdev.fallbackCMoveSCPRetries;
        this.fallbackWadoURIWebApplication = arcdev.fallbackWadoURIWebApplication;
        this.fallbackWadoURIHttpStatusCode = arcdev.fallbackWadoURIHttpStatusCode;
        this.externalRetrieveAEDestination = arcdev.externalRetrieveAEDestination;
        this.xdsiImagingDocumentSourceAETitle = arcdev.xdsiImagingDocumentSourceAETitle;
        this.alternativeCMoveSCP = arcdev.alternativeCMoveSCP;
        this.retrieveTaskWarningOnNoMatch = arcdev.retrieveTaskWarningOnNoMatch;
        this.retrieveTaskWarningOnWarnings = arcdev.retrieveTaskWarningOnWarnings;
        this.deleteRejectedPollingInterval = arcdev.deleteRejectedPollingInterval;
        this.deleteRejectedFetchSize = arcdev.deleteRejectedFetchSize;
        this.purgeStoragePollingInterval = arcdev.purgeStoragePollingInterval;
        this.purgeStorageFetchSize = arcdev.purgeStorageFetchSize;
        this.deleteStudyBatchSize = arcdev.deleteStudyBatchSize;
        this.deleteStudyChunkSize = arcdev.deleteStudyChunkSize;
        this.deletePatientOnDeleteLastStudy = arcdev.deletePatientOnDeleteLastStudy;
        this.failedToDeletePollingInterval = arcdev.failedToDeletePollingInterval;
        this.failedToDeleteFetchSize = arcdev.failedToDeleteFetchSize;
        this.maxAccessTimeStaleness = arcdev.maxAccessTimeStaleness;
        this.aeCacheStaleTimeout = arcdev.aeCacheStaleTimeout;
        this.leadingCFindSCPQueryCacheStaleTimeout = arcdev.leadingCFindSCPQueryCacheStaleTimeout;
        this.leadingCFindSCPQueryCacheSize = arcdev.leadingCFindSCPQueryCacheSize;
        this.auditSpoolDirectory = arcdev.auditSpoolDirectory;
        this.auditPollingInterval = arcdev.auditPollingInterval;
        this.auditAggregateDuration = arcdev.auditAggregateDuration;
        this.stowSpoolDirectory = arcdev.stowSpoolDirectory;
        this.wadoSpoolDirectory = arcdev.wadoSpoolDirectory;
        this.hl7LogFilePattern = arcdev.hl7LogFilePattern;
        this.hl7ErrorLogFilePattern = arcdev.hl7ErrorLogFilePattern;
        this.purgeTaskPollingInterval = arcdev.purgeTaskPollingInterval;
        this.purgeStgCmtPollingInterval = arcdev.purgeStgCmtPollingInterval;
        this.purgeStgCmtCompletedDelay = arcdev.purgeStgCmtCompletedDelay;
        this.keyValueRetentionPollingInterval = arcdev.keyValueRetentionPollingInterval;
        this.keyValueRetentionFetchSize = arcdev.keyValueRetentionFetchSize;
        this.keyValueRetentionPeriod = arcdev.keyValueRetentionPeriod;
        this.hideSPSWithStatusFrom = arcdev.hideSPSWithStatusFrom;
        this.hideSPSWithStatusFromMWLRS = arcdev.hideSPSWithStatusFromMWLRS;
        this.hl7ORUAction = arcdev.hl7ORUAction;
        this.mwlAccessionNumberGenerator = arcdev.mwlAccessionNumberGenerator;
        this.mwlRequestedProcedureIDGenerator = arcdev.mwlRequestedProcedureIDGenerator;
        this.mwlScheduledProcedureStepIDGenerator = arcdev.mwlScheduledProcedureStepIDGenerator;
        this.rejectExpiredStudiesPollingInterval = arcdev.rejectExpiredStudiesPollingInterval;
        this.rejectExpiredStudiesSchedules = arcdev.rejectExpiredStudiesSchedules;
        this.rejectExpiredStudiesFetchSize = arcdev.rejectExpiredStudiesFetchSize;
        this.rejectExpiredSeriesFetchSize = arcdev.rejectExpiredSeriesFetchSize;
        this.rejectExpiredStudiesAETitle = arcdev.rejectExpiredStudiesAETitle;
        this.fallbackCMoveSCPStudyOlderThan = arcdev.fallbackCMoveSCPStudyOlderThan;
        this.storePermissionServiceURL = arcdev.storePermissionServiceURL;
        this.storePermissionServiceResponse = arcdev.storePermissionServiceResponse;
        this.storePermissionServiceResponsePattern = arcdev.storePermissionServiceResponsePattern;
        this.storePermissionServiceExpirationDatePattern = arcdev.storePermissionServiceExpirationDatePattern;
        this.storePermissionServiceErrorCommentPattern = arcdev.storePermissionServiceErrorCommentPattern;
        this.storePermissionServiceErrorCodePattern = arcdev.storePermissionServiceErrorCodePattern;
        this.storePermissionCacheStaleTimeout = arcdev.storePermissionCacheStaleTimeout;
        this.storePermissionCacheSize = arcdev.storePermissionCacheSize;
        this.mergeMWLCacheStaleTimeout = arcdev.mergeMWLCacheStaleTimeout;
        this.mergeMWLCacheSize = arcdev.mergeMWLCacheSize;
        this.storeUpdateDBMaxRetries = arcdev.storeUpdateDBMaxRetries;
        this.storeUpdateDBMaxRetryDelay = arcdev.storeUpdateDBMaxRetryDelay;
        this.storeUpdateDBMinRetryDelay = arcdev.storeUpdateDBMinRetryDelay;
        this.allowRejectionForDataRetentionPolicyExpired = arcdev.allowRejectionForDataRetentionPolicyExpired;
        this.acceptMissingPatientID = arcdev.acceptMissingPatientID;
        this.allowDeleteStudyPermanently = arcdev.allowDeleteStudyPermanently;
        this.allowDeletePatient = arcdev.allowDeletePatient;
        this.retrieveAETitles = arcdev.retrieveAETitles;
        this.returnRetrieveAETitles = arcdev.returnRetrieveAETitles;
        this.remapRetrieveURL = arcdev.remapRetrieveURL;
        this.remapRetrieveURLClientHost = arcdev.remapRetrieveURLClientHost;
        this.hl7PSUSendingApplication = arcdev.hl7PSUSendingApplication;
        this.hl7PSUReceivingApplications = arcdev.hl7PSUReceivingApplications;
        this.hl7PSUDelay = arcdev.hl7PSUDelay;
        this.hl7PSUTimeout = arcdev.hl7PSUTimeout;
        this.hl7PSUOnTimeout = arcdev.hl7PSUOnTimeout;
        this.hl7PSUTaskPollingInterval = arcdev.hl7PSUTaskPollingInterval;
        this.hl7PSUTaskFetchSize = arcdev.hl7PSUTaskFetchSize;
        this.hl7PSUMWL = arcdev.hl7PSUMWL;
        this.hl7PSUMWLMatchingKey = arcdev.hl7PSUMWLMatchingKey;
        this.hl7PSUForRequestedProcedure = arcdev.hl7PSUForRequestedProcedure;
        this.hl7PSUPIDPV1 = arcdev.hl7PSUPIDPV1;
        this.hl7PSURequestedProcedureID = arcdev.hl7PSURequestedProcedureID;
        this.hl7PSUAccessionNumber = arcdev.hl7PSUAccessionNumber;
        this.hl7PSUFillerOrderNumber = arcdev.hl7PSUFillerOrderNumber;
        this.hl7PSUPlacerOrderNumber = arcdev.hl7PSUPlacerOrderNumber;
        this.hl7PSUMessageType = arcdev.hl7PSUMessageType;
        this.hl7PSUConditions = arcdev.hl7PSUConditions;
        this.hl7PSUMppsTemplateURI = arcdev.hl7PSUMppsTemplateURI;
        this.hl7PSUStudyTemplateURI = arcdev.hl7PSUStudyTemplateURI;
        this.acceptConflictingPatientID = arcdev.acceptConflictingPatientID;
        this.userIdentityNegotiation = arcdev.userIdentityNegotiation;
        this.userIdentityNegotiationRole = arcdev.userIdentityNegotiationRole;
        this.userIdentityNegotiationKeycloakClientID = arcdev.userIdentityNegotiationKeycloakClientID;
        this.proxyUpstreamURL = arcdev.proxyUpstreamURL;
        this.atna2JsonFhirTemplateURI = arcdev.atna2JsonFhirTemplateURI;
        this.atna2XmlFhirTemplateURI = arcdev.atna2XmlFhirTemplateURI;
        this.copyMoveUpdatePolicy = arcdev.copyMoveUpdatePolicy;
        this.linkMWLEntryUpdatePolicy = arcdev.linkMWLEntryUpdatePolicy;
        this.hl7TrackChangedPatientID = arcdev.hl7TrackChangedPatientID;
        this.hl7ADTReceivingApplication = arcdev.hl7ADTReceivingApplication;
        this.hl7ADTSendingApplication = arcdev.hl7ADTSendingApplication;
        this.hl7ScheduledProtocolCodeInOrder = arcdev.hl7ScheduledProtocolCodeInOrder;
        this.hl7ScheduledStationAETInOrder = arcdev.hl7ScheduledStationAETInOrder;
        this.auditUnknownStudyInstanceUID = arcdev.auditUnknownStudyInstanceUID;
        this.auditUnknownPatientID = arcdev.auditUnknownPatientID;
        this.auditSoftwareConfigurationVerbose = arcdev.auditSoftwareConfigurationVerbose;
        this.hl7UseNullValue = arcdev.hl7UseNullValue;
        this.queueTasksFetchSize = arcdev.queueTasksFetchSize;
        this.auditHL7MsgLimit = arcdev.auditHL7MsgLimit;
        this.rejectionNoteStorageAET = arcdev.rejectionNoteStorageAET;
        this.uiConfigurationDeviceName = arcdev.uiConfigurationDeviceName;
        this.storageVerificationPolicy = arcdev.storageVerificationPolicy;
        this.storageVerificationUpdateLocationStatus = arcdev.storageVerificationUpdateLocationStatus;
        this.storageVerificationStorageIDs = arcdev.storageVerificationStorageIDs;
        this.storageVerificationAETitle = arcdev.storageVerificationAETitle;
        this.storageVerificationBatchID = arcdev.storageVerificationBatchID;
        this.storageVerificationInitialDelay = arcdev.storageVerificationInitialDelay;
        this.storageVerificationPeriod = arcdev.storageVerificationPeriod;
        this.storageVerificationSchedules = arcdev.storageVerificationSchedules;
        this.storageVerificationMaxScheduled = arcdev.storageVerificationMaxScheduled;
        this.storageVerificationPollingInterval = arcdev.storageVerificationPollingInterval;
        this.storageVerificationFetchSize = arcdev.storageVerificationFetchSize;
        this.updateLocationStatusOnRetrieve = arcdev.updateLocationStatusOnRetrieve;
        this.storageVerificationOnRetrieve = arcdev.storageVerificationOnRetrieve;
        this.compressionAETitle = arcdev.compressionAETitle;
        this.compressionPollingInterval = arcdev.compressionPollingInterval;
        this.compressionFetchSize = arcdev.compressionFetchSize;
        this.compressionSchedules = arcdev.compressionSchedules;
        this.compressionThreads = arcdev.compressionThreads;
        this.diffTaskProgressUpdateInterval = arcdev.diffTaskProgressUpdateInterval;
        this.patientVerificationPDQServiceID = arcdev.patientVerificationPDQServiceID;
        this.patientVerificationPollingInterval = arcdev.patientVerificationPollingInterval;
        this.patientVerificationFetchSize = arcdev.patientVerificationFetchSize;
        this.patientVerificationMaxStaleness = arcdev.patientVerificationMaxStaleness;
        this.patientVerificationPeriod = arcdev.patientVerificationPeriod;
        this.patientVerificationRetryInterval = arcdev.patientVerificationRetryInterval;
        this.patientVerificationPeriodOnNotFound = arcdev.patientVerificationPeriodOnNotFound;
        this.patientVerificationMaxRetries = arcdev.patientVerificationMaxRetries;
        this.patientVerificationAdjustIssuerOfPatientID = arcdev.patientVerificationAdjustIssuerOfPatientID;
        this.csvUploadChunkSize = arcdev.csvUploadChunkSize;
        this.validateUID = arcdev.validateUID;
        this.hl7OrderMissingStudyIUIDPolicy = arcdev.hl7OrderMissingStudyIUIDPolicy;
        this.hl7OrderMissingAdmissionIDPolicy = arcdev.hl7OrderMissingAdmissionIDPolicy;
        this.hl7ImportReportMissingStudyIUIDPolicy = arcdev.hl7ImportReportMissingStudyIUIDPolicy;
        this.hl7ImportReportMissingAdmissionIDPolicy = arcdev.hl7ImportReportMissingAdmissionIDPolicy;
        this.hl7ImportReportMissingStudyIUIDCFindSCP = arcdev.hl7ImportReportMissingStudyIUIDCFindSCP;
        this.hl7ImportReportAdjustIUID = arcdev.hl7ImportReportAdjustIUID;
        this.hl7ReferredMergedPatientPolicy = arcdev.hl7ReferredMergedPatientPolicy;
        this.hl7DicomCharacterSet = arcdev.hl7DicomCharacterSet;
        this.hl7VeterinaryUsePatientName = arcdev.hl7VeterinaryUsePatientName;
        this.hl7PatientArrivalMessageType = arcdev.hl7PatientArrivalMessageType;
        this.relationalQueryNegotiationLenient = arcdev.relationalQueryNegotiationLenient;
        this.relationalRetrieveNegotiationLenient = arcdev.relationalRetrieveNegotiationLenient;
        this.rejectConflictingPatientAttribute = arcdev.rejectConflictingPatientAttribute;
        this.schedulerMinStartDelay = arcdev.schedulerMinStartDelay;
        this.stowRetiredTransferSyntax = arcdev.stowRetiredTransferSyntax;
        this.stowExcludeAPPMarkers = arcdev.stowExcludeAPPMarkers;
        this.restrictRetrieveSilently = arcdev.restrictRetrieveSilently;
        this.stowQuicktime2MP4 = arcdev.stowQuicktime2MP4;
        this.stowMaxFragmentLength = arcdev.stowMaxFragmentLength;
        this.identifyPatientByAllAttributes = arcdev.identifyPatientByAllAttributes;
        this.multipleStoreAssociations = arcdev.multipleStoreAssociations;
        this.mwlPollingInterval = arcdev.mwlPollingInterval;
        this.mwlFetchSize = arcdev.mwlFetchSize;
        this.mwlImportInterval = arcdev.mwlImportInterval;
        this.deleteMWLDelay = arcdev.deleteMWLDelay;
        this.studySizeDelay = arcdev.studySizeDelay;
        this.calculateStudySizePollingInterval = arcdev.calculateStudySizePollingInterval;
        this.calculateStudySizeFetchSize = arcdev.calculateStudySizeFetchSize;
        this.calculateQueryAttributes = arcdev.calculateQueryAttributes;
        this.storeImplementationVersionName = arcdev.storeImplementationVersionName;
        this.supplementIssuerFetchSize = arcdev.supplementIssuerFetchSize;
        this.updateCharsetFetchSize = arcdev.updateCharsetFetchSize;
        this.auditAssigningAuthorityOfPatientID = arcdev.auditAssigningAuthorityOfPatientID;
        this.changeRequesterAET = arcdev.changeRequesterAET;
        this.attributeFilters.clear();
        this.attributeFilters.putAll(arcdev.attributeFilters);
        this.attributeSet.clear();
        this.attributeSet.putAll(arcdev.attributeSet);
        this.bulkDataDescriptorMap.clear();
        this.bulkDataDescriptorMap.putAll(arcdev.bulkDataDescriptorMap);
        this.idGenerators.clear();
        this.idGenerators.putAll(arcdev.idGenerators);
        this.storageDescriptorMap.clear();
        this.storageDescriptorMap.putAll(arcdev.storageDescriptorMap);
        this.queueDescriptorMap.clear();
        this.queueDescriptorMap.putAll(arcdev.queueDescriptorMap);
        this.metricsDescriptorMap.clear();
        this.metricsDescriptorMap.putAll(arcdev.metricsDescriptorMap);
        this.pdqServiceDescriptorMap.clear();
        this.pdqServiceDescriptorMap.putAll(arcdev.pdqServiceDescriptorMap);
        this.exporterDescriptorMap.clear();
        this.exporterDescriptorMap.putAll(arcdev.exporterDescriptorMap);
        this.upsOnStoreList.clear();
        this.upsOnStoreList.addAll(arcdev.upsOnStoreList);
        this.upsOnUPSCompletedList.clear();
        this.upsOnUPSCompletedList.addAll(arcdev.upsOnUPSCompletedList);
        this.upsOnHL7List.clear();
        this.upsOnHL7List.addAll(arcdev.upsOnHL7List);
        this.upsProcessingRuleList.clear();
        this.upsProcessingRuleList.addAll(arcdev.upsProcessingRuleList);
        this.exportRules.clear();
        this.exportRules.addAll(arcdev.exportRules);
        this.exportPriorsRules.clear();
        this.exportPriorsRules.addAll(arcdev.exportPriorsRules);
        this.mppsForwardRule.clear();
        this.mppsForwardRule.addAll(arcdev.mppsForwardRule);
        this.hl7ExportRules.clear();
        this.hl7ExportRules.addAll(arcdev.hl7ExportRules);
        this.hl7PrefetchRules.clear();
        this.hl7PrefetchRules.addAll(arcdev.hl7PrefetchRules);
        this.rsForwardRules.clear();
        this.rsForwardRules.addAll(arcdev.rsForwardRules);
        this.hl7ForwardRules.clear();
        this.hl7ForwardRules.addAll(arcdev.hl7ForwardRules);
        this.hl7OrderScheduledStations.clear();
        this.hl7OrderScheduledStations.addAll(arcdev.hl7OrderScheduledStations);
        this.hl7OrderSPSStatuses.clear();
        this.hl7OrderSPSStatuses.putAll(arcdev.hl7OrderSPSStatuses);
        this.hl7NoPatientCreateMessageTypes.clear();
        this.hl7NoPatientCreateMessageTypes.addAll(arcdev.hl7NoPatientCreateMessageTypes);
        this.compressionRules.clear();
        this.compressionRules.addAll(arcdev.compressionRules);
        this.studyRetentionPolicies.clear();
        this.studyRetentionPolicies.addAll(arcdev.studyRetentionPolicies);
        this.hl7StudyRetentionPolicies.clear();
        this.hl7StudyRetentionPolicies.addAll(arcdev.hl7StudyRetentionPolicies);
        this.attributeCoercions.clear();
        this.attributeCoercions.addAll(arcdev.attributeCoercions);
        this.attributeCoercions2.clear();
        this.attributeCoercions2.addAll(arcdev.attributeCoercions2);
        this.storeAccessControlIDRules.clear();
        this.storeAccessControlIDRules.addAll(arcdev.storeAccessControlIDRules);
        this.mwlIdleTimeoutList.clear();
        this.mwlIdleTimeoutList.addAll(arcdev.mwlIdleTimeoutList);
        this.mwlImportList.clear();
        this.mwlImportList.addAll(arcdev.mwlImportList);
        this.rejectionNoteMap.clear();
        this.rejectionNoteMap.putAll(arcdev.rejectionNoteMap);
        this.xRoadProperties.clear();
        this.xRoadProperties.putAll(arcdev.xRoadProperties);
        this.impaxReportProperties.clear();
        this.impaxReportProperties.putAll(arcdev.impaxReportProperties);
        this.importReportTemplateParams.clear();
        this.importReportTemplateParams.putAll(arcdev.importReportTemplateParams);
        this.hl7PSUTemplateParams.clear();
        this.hl7PSUTemplateParams.putAll(arcdev.hl7PSUTemplateParams);
        this.cStoreSCUOfCMoveSCP.clear();
        this.cStoreSCUOfCMoveSCP.putAll(arcdev.cStoreSCUOfCMoveSCP);
        this.dicomCharsetNameMappings.clear();
        this.dicomCharsetNameMappings.putAll(arcdev.dicomCharsetNameMappings);
        this.hl7CharsetNameMappings.clear();
        this.hl7CharsetNameMappings.putAll(arcdev.hl7CharsetNameMappings);
        this.upsEventWebSocketQueueSizes.clear();
        this.upsEventWebSocketQueueSizes.putAll(arcdev.upsEventWebSocketQueueSizes);
    }
}

