/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.coerce.impl;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.TransferCapability;
import org.dcm4chee.arc.Cache;
import org.dcm4chee.arc.LeadingCFindSCPQueryCache;
import org.dcm4chee.arc.coerce.CoercionProcessor;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="leading-arc")
public class LeadingArchiveCoercionProcessor
implements CoercionProcessor {
    static final Logger LOG = LoggerFactory.getLogger(LeadingArchiveCoercionProcessor.class);
    @Inject
    private Device device;
    @Inject
    private LeadingCFindSCPQueryCache queryCache;
    @Inject
    private CFindSCU cfindSCU;

    public boolean coerce(ArchiveAttributeCoercion2 coercion, String sopClassUID, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs, Attributes modified) throws Exception {
        if (sopClassUID.equals("1.2.840.10008.5.1.4.1.2.1.1") || sopClassUID.equals("1.2.840.10008.5.1.4.31")) {
            LOG.info("Leading C-FIND coercion not intended for Patient / MWL queries.");
            return false;
        }
        String studyIUID = attrs.getString(0x20000D);
        String findSCP = coercion.getSchemeSpecificPart();
        Attributes newAttrs = this.queryStudy(coercion.getRole() == TransferCapability.Role.SCU ? receivingAET : sendingAET, findSCP, studyIUID);
        if (newAttrs == null) {
            return false;
        }
        if (attrs.update(coercion.getAttributeUpdatePolicy(), newAttrs, modified)) {
            LOG.info("Coerce Attributes from matching Study at {} by coercion {}", (Object)findSCP, (Object)coercion);
        }
        return true;
    }

    private Attributes queryStudy(String localAET, String leadingCFindSCP, String studyIUID) throws Exception {
        LeadingCFindSCPQueryCache.Key key = new LeadingCFindSCPQueryCache.Key(leadingCFindSCP, studyIUID);
        Cache.Entry entry = this.queryCache.getEntry((Object)key);
        if (entry != null) {
            return (Attributes)entry.value();
        }
        Attributes newAttrs = null;
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        List matches = this.cfindSCU.findStudy(this.device.getApplicationEntity(localAET, true), leadingCFindSCP, 0, studyIUID, arcdev.returnKeysForLeadingCFindSCP(leadingCFindSCP));
        if (!matches.isEmpty()) {
            newAttrs = (Attributes)matches.get(0);
        }
        this.queryCache.put((Object)key, (Object)newAttrs);
        return newAttrs;
    }
}

