/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpoolFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(SpoolFileReader.class);
    private String mainInfo;
    private List<String> instanceLines = new ArrayList<String>();
    private byte[] data = ByteUtils.EMPTY_BYTES;
    private byte[] ack = ByteUtils.EMPTY_BYTES;

    SpoolFileReader(Path p) {
        try (BufferedReader reader = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
            String line;
            this.mainInfo = reader.readLine();
            while ((line = reader.readLine()) != null) {
                this.instanceLines.add(line);
            }
        }
        catch (Exception e) {
            LOG.info("Failed to read audit spool file", (Throwable)e);
        }
    }

    SpoolFileReader(File file) {
        byte[] MSH = new byte[]{77, 83, 72};
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int readMain;
            ByteArrayOutputStream mainInfo = new ByteArrayOutputStream();
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            int skipChar = 0;
            while ((readMain = in.read()) != -1) {
                if (readMain == 10) {
                    ++skipChar;
                    break;
                }
                mainInfo.write(readMain);
            }
            this.mainInfo = new String(mainInfo.toByteArray());
            int readData = in.read();
            if (readData != -1) {
                data.write(readData);
                ++skipChar;
            }
            if (skipChar == 2) {
                int read;
                ByteArrayOutputStream ack = new ByteArrayOutputStream();
                int bufLength = (int)file.length() - skipChar - this.mainInfo.length();
                byte[] buf = new byte[bufLength];
                int mshStart = SpoolFileReader.indexOf(MSH, 0, buf, read = in.read(buf));
                if (mshStart > 0) {
                    data.write(buf, 0, mshStart);
                    this.data = data.toByteArray();
                    int ackLength = buf.length - this.data.length;
                    ack.write(buf, mshStart, ackLength);
                } else {
                    data.write(buf);
                    this.data = data.toByteArray();
                }
                this.ack = ack.toByteArray();
                ack.close();
            }
            mainInfo.close();
            data.close();
        }
        catch (Exception e) {
            LOG.info("Failed to read audit spool file", (Throwable)e);
        }
    }

    String getMainInfo() {
        return this.mainInfo;
    }

    List<String> getInstanceLines() {
        return this.instanceLines;
    }

    byte[] getData() {
        return this.data;
    }

    byte[] getAck() {
        return this.ack;
    }

    private static int indexOf(byte[] b1, int fromIndex, byte[] b2, int length) {
        int max = length - b1.length;
        for (int i = fromIndex; i < max; ++i) {
            if (!SpoolFileReader.startsWith(b1, i, b2)) continue;
            return i;
        }
        return -1;
    }

    private static boolean startsWith(byte[] b1, int fromIndex, byte[] b2) {
        int remaining = b1.length;
        int i1 = 0;
        int i2 = fromIndex;
        while (--remaining >= 0) {
            if (b2[i2++] == b1[i1++]) continue;
            return false;
        }
        return true;
    }
}

