/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.audit.AuditLoggerDeviceExtension;
import org.dcm4chee.arc.AssociationEvent;
import org.dcm4chee.arc.ConnectionEvent;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.delete.StudyDeleteContext;
import org.dcm4chee.arc.event.ArchiveServiceEvent;
import org.dcm4chee.arc.event.BulkTaskEvent;
import org.dcm4chee.arc.event.RejectionNoteSent;
import org.dcm4chee.arc.event.SoftwareConfiguration;
import org.dcm4chee.arc.event.StudySizeEvent;
import org.dcm4chee.arc.event.TaskEvent;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveEnd;
import org.dcm4chee.arc.retrieve.RetrieveStart;
import org.dcm4chee.arc.retrieve.RetrieveWADO;
import org.dcm4chee.arc.stgcmt.StgCmtContext;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.study.StudyMgtContext;

@ApplicationScoped
public class AuditTriggerObserver {
    @Inject
    private AuditService auditService;
    @Inject
    private Device device;

    public void onArchiveServiceEvent(@Observes ArchiveServiceEvent event) {
        if (event.getType() == ArchiveServiceEvent.Type.RELOADED) {
            return;
        }
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolApplicationActivity(event);
        }
    }

    public void onStore(@Observes StoreContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolStoreEvent(ctx);
        }
    }

    public void onQuery(@Observes QueryContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolQuery(ctx);
        }
    }

    public void onRetrieveStart(@Observes @RetrieveStart RetrieveContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolRetrieve(AuditUtils.EventType.RTRV_BEGIN, ctx);
        }
    }

    public void onRetrieveEnd(@Observes @RetrieveEnd RetrieveContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolRetrieve(AuditUtils.EventType.RTRV___TRF, ctx);
        }
    }

    public void onRetrieveWADO(@Observes @RetrieveWADO RetrieveContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolRetrieveWADO(ctx);
        }
    }

    public void onStudyDeleted(@Observes StudyDeleteContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolStudyDeleted(ctx);
        }
    }

    public void onExport(@Observes ExportContext ctx) {
        if (ctx.getXDSiManifest() == null) {
            return;
        }
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolProvideAndRegister(ctx);
        }
    }

    public void onConnection(@Observes ConnectionEvent event) {
        if (this.deviceHasAuditLoggers()) {
            switch (event.getType()) {
                case ESTABLISHED: 
                case REJECTED_BLACKLISTED: 
                case ACCEPTED: {
                    break;
                }
                case FAILED: 
                case REJECTED: {
                    this.auditService.spoolConnectionFailure(event);
                }
            }
        }
    }

    public void onPatientUpdate(@Observes PatientMgtContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolPatientRecord(ctx);
        }
    }

    public void onProcedureUpdate(@Observes ProcedureContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolProcedureRecord(ctx);
        }
    }

    public void onStudyUpdate(@Observes StudyMgtContext ctx) {
        if (ctx.getEventActionCode().equals("C")) {
            return;
        }
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolStudyRecord(ctx);
        }
    }

    public void onStorageCommit(@Observes StgCmtContext stgCmtContext) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolStgCmt(stgCmtContext);
        }
    }

    public void onRejectionNoteSent(@Observes RejectionNoteSent rejectionNoteSent) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolExternalRejection(rejectionNoteSent);
        }
    }

    public void onExternalRetrieve(@Observes ExternalRetrieveContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolExternalRetrieve(ctx);
        }
    }

    public void onSoftwareConfiguration(@Observes SoftwareConfiguration softwareConfiguration) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolSoftwareConfiguration(softwareConfiguration);
        }
    }

    public void onQueueMessageEvent(@Observes TaskEvent queueMsgEvent) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolTaskEvent(queueMsgEvent);
        }
    }

    public void onBulkQueueMessageEvent(@Observes BulkTaskEvent bulkQueueMsgEvent) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolBulkQueueMessageEvent(bulkQueueMsgEvent);
        }
    }

    public void onHL7Message(@Observes HL7ConnectionEvent hl7ConnectionEvent) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolHL7Message(hl7ConnectionEvent);
        }
    }

    public void onAssociation(@Observes AssociationEvent associationEvent) {
        if (this.deviceHasAuditLoggers()) {
            switch (associationEvent.getType()) {
                case ACCEPTED: 
                case ESTABLISHED: {
                    break;
                }
                case FAILED: 
                case REJECTED: {
                    this.auditService.spoolAssociationFailure(associationEvent);
                }
            }
        }
    }

    public void onStudySizeEvent(@Observes StudySizeEvent event) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolStudySizeEvent(event);
        }
    }

    public void onPatientDemographicsQuery(@Observes PDQServiceContext ctx) {
        if (this.deviceHasAuditLoggers()) {
            this.auditService.spoolPDQ(ctx);
        }
    }

    private boolean deviceHasAuditLoggers() {
        AuditLoggerDeviceExtension ext = (AuditLoggerDeviceExtension)this.device.getDeviceExtension(AuditLoggerDeviceExtension.class);
        return ext != null && !ext.getAuditLoggers().isEmpty();
    }
}

