/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.image.BufferedImageUtils;
import org.dcm4che3.image.ICCProfile;
import org.dcm4che3.image.PaletteColorModel;
import org.dcm4che3.image.PixelAspectRatio;
import org.dcm4che3.imageio.plugins.dcm.DicomImageReadParam;
import org.dcm4che3.imageio.plugins.dcm.DicomMetaData;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderedImageOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(RenderedImageOutput.class);
    private static final float DEF_FRAME_TIME = 1000.0f;
    private static final byte[] LOOP_FOREVER = new byte[]{1, 0, 0};
    private final RetrieveContext ctx;
    private final InstanceLocations inst;
    private final ImageReader reader;
    private final DicomImageReadParam readParam;
    private final int rows;
    private final int columns;
    private final int imageIndex;
    private final ImageWriter writer;
    private final ImageWriteParam writeParam;
    private final ICCProfile.Option iccProfile;

    public RenderedImageOutput(RetrieveContext ctx, InstanceLocations inst, DicomImageReadParam readParam, int rows, int columns, MediaType mimeType, String imageQuality, ICCProfile.Option iccProfile, int frame) {
        this.ctx = ctx;
        this.inst = inst;
        this.reader = RenderedImageOutput.getDicomImageReader();
        this.readParam = readParam;
        this.rows = rows;
        this.columns = columns;
        this.imageIndex = frame - 1;
        this.writer = RenderedImageOutput.getImageWriter(mimeType);
        this.writeParam = this.writer.getDefaultWriteParam();
        if (imageQuality != null) {
            this.writeParam.setCompressionMode(2);
            this.writeParam.setCompressionQuality((float)Integer.parseInt(imageQuality) / 100.0f);
        }
        this.iccProfile = iccProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException, WebApplicationException {
        RetrieveService service = this.ctx.getRetrieveService();
        LOG.debug("Start writing rendered {}", (Object)this.inst);
        try (DicomInputStream dis = service.openDicomInputStream(this.ctx, this.inst);){
            this.reader.setInput(dis);
            MemoryCacheImageOutputStream imageOut = new MemoryCacheImageOutputStream(out);
            this.writer.setOutput(imageOut);
            BufferedImage bi = null;
            if (this.imageIndex < 0) {
                IIOMetadata metadata = null;
                int numImages = this.reader.getNumImages(false);
                this.writer.prepareWriteSequence(null);
                for (int i = 0; i < numImages; ++i) {
                    this.readParam.setDestination(bi);
                    bi = this.reader.read(i, (ImageReadParam)this.readParam);
                    BufferedImage bi2 = this.adjust(bi);
                    if (metadata == null) {
                        metadata = this.createAnimatedGIFMetadata(bi2, this.writeParam, this.frameTime());
                    }
                    this.writer.writeToSequence(new IIOImage(bi2, null, metadata), this.writeParam);
                    imageOut.flush();
                }
                this.writer.endWriteSequence();
            } else {
                bi = this.reader.read(this.imageIndex, (ImageReadParam)this.readParam);
                this.writer.write(null, new IIOImage(this.adjust(bi), null, null), this.writeParam);
            }
            imageOut.close();
            LOG.debug("Finished writing rendered {}", (Object)this.inst);
        }
        finally {
            this.writer.dispose();
            this.reader.dispose();
        }
    }

    private float frameTime() throws IOException {
        DicomMetaData metaData = (DicomMetaData)this.reader.getStreamMetadata();
        Attributes attrs = metaData.getAttributes();
        return attrs.getFloat(1577059, 1000.0f);
    }

    private IIOMetadata createAnimatedGIFMetadata(BufferedImage bi, ImageWriteParam param, float frameTime) throws IOException {
        ImageTypeSpecifier imageType = ImageTypeSpecifier.createFromRenderedImage(bi);
        IIOMetadata metadata = this.writer.getDefaultImageMetadata(imageType, param);
        String formatName = metadata.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(formatName);
        IIOMetadataNode graphicControlExt = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
        graphicControlExt.setAttribute("delayTime", Integer.toString(Math.round(this.frameTime() / 10.0f)));
        IIOMetadataNode appExts = new IIOMetadataNode("ApplicationExtensions");
        IIOMetadataNode appExt = new IIOMetadataNode("ApplicationExtension");
        appExt.setAttribute("applicationID", "NETSCAPE");
        appExt.setAttribute("authenticationCode", "2.0");
        appExt.setUserObject(LOOP_FOREVER);
        appExts.appendChild(appExt);
        root.appendChild(appExts);
        metadata.setFromTree(formatName, root);
        return metadata;
    }

    private BufferedImage adjust(BufferedImage bi) throws IOException {
        return this.iccProfile.adjust(RenderedImageOutput.rescale(bi, this.rows, this.columns, this.getPixelAspectRatio()));
    }

    static BufferedImage rescale(BufferedImage bi, int r, int c, float sy) throws IOException {
        if (r == 0 && c == 0 && sy == 1.0f) {
            return bi;
        }
        float sx = 1.0f;
        if (r != 0 || c != 0) {
            if (r != 0 && c != 0) {
                if ((float)(r * bi.getWidth()) > (float)(c * bi.getHeight()) * sy) {
                    r = 0;
                } else {
                    c = 0;
                }
            }
            sx = r != 0 ? (float)r / ((float)bi.getHeight() * sy) : (float)c / (float)bi.getWidth();
            sy *= sx;
        }
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(sx, sy), 1);
        return op.filter(RenderedImageOutput.makeScaleable(bi), null);
    }

    private static BufferedImage makeScaleable(BufferedImage bi) {
        ColorModel pcm = bi.getColorModel();
        if (pcm instanceof PaletteColorModel || pcm instanceof IndexColorModel) {
            return BufferedImageUtils.convertPalettetoRGB((BufferedImage)bi, null);
        }
        if (bi.getSampleModel() instanceof BandedSampleModel) {
            return BufferedImageUtils.convertToIntRGB((BufferedImage)bi);
        }
        return bi;
    }

    private float getPixelAspectRatio() throws IOException {
        Attributes prAttrs = this.readParam.getPresentationState();
        return prAttrs != null ? PixelAspectRatio.forPresentationState((Attributes)prAttrs) : PixelAspectRatio.forImage((Attributes)this.getAttributes());
    }

    private Attributes getAttributes() throws IOException {
        return ((DicomMetaData)this.reader.getStreamMetadata()).getAttributes();
    }

    private static ImageReader getDicomImageReader() {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("DICOM");
        if (!readers.hasNext()) {
            ImageIO.scanForPlugins();
            readers = ImageIO.getImageReadersByFormatName("DICOM");
            if (!readers.hasNext()) {
                throw new RuntimeException("DICOM Image Reader not registered");
            }
        }
        return readers.next();
    }

    static ImageWriter getImageWriter(MediaType mimeType) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mimeType.toString());
        if (!writers.hasNext()) {
            throw new RuntimeException("No Image Writer for MIME Type: " + mimeType);
        }
        ImageWriter writer = writers.next();
        while (writers.hasNext() && !writer.getClass().getName().startsWith("com.sun.imageio.plugins")) {
            writer = writers.next();
        }
        return writer;
    }
}

