/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.wado.DecompressSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressFramesOutput
extends DecompressSupport
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(DecompressFramesOutput.class);
    private final int[] frameList;
    private final Path[] spoolFiles;
    private final Path spoolDirectory;
    private int frame = 1;
    private int frameListIndex;

    public DecompressFramesOutput(RetrieveContext ctx, InstanceLocations inst, int[] frameList, Path spoolDirectory) {
        super(ctx, inst);
        this.frameList = frameList;
        this.spoolDirectory = spoolDirectory;
        this.spoolFiles = spoolDirectory != null ? new Path[this.frameList.length] : null;
    }

    public void write(OutputStream out) throws IOException {
        try {
            if (this.frameListIndex == 0) {
                this.initEncapsulatedPixelData();
            }
            if (this.encapsulatedPixelData == null) {
                Files.copy(this.spoolFiles[this.frameListIndex++], out);
                return;
            }
            int nextFrame = this.frameList[this.frameListIndex++];
            while (this.frame < nextFrame) {
                this.skipFrame();
                ++this.frame;
            }
            this.decompressFrame(this.frame);
            LOG.debug("Start writing decompressed frame of {}", (Object)this.inst);
            this.writeFrameTo(out);
            LOG.debug("Finished writing decompressed frame of {}", (Object)this.inst);
            ++this.frame;
            if (this.allFramesRead()) {
                this.close();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private void skipFrame() throws IOException {
        for (int i = this.frameListIndex; i < this.frameList.length; ++i) {
            if (this.frame != this.frameList[i]) continue;
            this.spoolFiles[i] = Files.createTempFile(this.spoolDirectory, null, null, new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(this.spoolFiles[i], new OpenOption[0]);){
                this.decompressFrame(this.frame);
                this.writeFrameTo(out);
            }
            return;
        }
        if (!this.encapsulatedPixelData.seekNextFrame()) {
            throw new IOException("Number of data fragments not sufficient for number of frames in requested object");
        }
    }

    private boolean allFramesRead() {
        for (int i = this.frameListIndex; i < this.frameList.length; ++i) {
            if (this.frame > this.frameList[i]) continue;
            return false;
        }
        return true;
    }
}

