/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.study.size;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.Tuple;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.entity.PatientID;
import org.dcm4chee.arc.event.StudySizeEvent;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.impl.QueryAttributesEJB;
import org.dcm4chee.arc.query.impl.QuerySizeEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class StudySizeScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(StudySizeScheduler.class);
    @Inject
    private QueryService queryService;
    @Inject
    private QuerySizeEJB querySizeEJB;
    @Inject
    private QueryAttributesEJB queryAttrsEJB;
    @Inject
    private Event<StudySizeEvent> studySizeEvent;

    protected StudySizeScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getCalculateStudySizePollingInterval();
    }

    protected void execute() {
        int studySizeFetchSize;
        List studies;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        int calculated = 0;
        do {
            studySizeFetchSize = arcDev.getCalculateStudySizeFetchSize();
            studies = this.queryService.unknownSizeStudies(this.updatedTime(arcDev.getStudySizeDelay()), studySizeFetchSize);
            for (Tuple studyTuple : studies) {
                Long studyPk = (Long)studyTuple.get(0, Long.class);
                try {
                    long studySize = this.querySizeEJB.claimAndCalculateStudySize(studyPk);
                    if (studySize <= 0L) continue;
                    if (arcDev.isCalculateQueryAttributes()) {
                        this.queryAttrsEJB.calculateStudyQueryAttributes(studyPk);
                    }
                    ++calculated;
                    this.studySizeEvent.fire((Object)new StudySizeEvent((String)studyTuple.get(1, String.class), ((PatientID)studyTuple.get(2, PatientID.class)).getIDWithIssuer()));
                }
                catch (Exception e) {
                    LOG.warn("Failed to update DB with calculated size or query attributes for Study[pk={}]:{}", new Object[]{studyPk, System.lineSeparator(), e});
                }
            }
        } while (studies.size() == studySizeFetchSize && this.getPollingInterval() != null);
        if (calculated > 0) {
            LOG.info("Calculated size of {} studies", (Object)calculated);
        }
    }

    private Date updatedTime(Duration delay) {
        Calendar now = Calendar.getInstance();
        return delay != null ? new Date(now.getTimeInMillis() - delay.getSeconds() * 1000L) : now.getTime();
    }
}

