/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.study.impl;

import java.net.InetAddress;
import java.net.Socket;
import java.time.LocalDate;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.study.StudyMgtContext;

public class StudyMgtContextImpl
implements StudyMgtContext {
    private final AttributeFilter studyAttributeFilter;
    private final AttributeFilter seriesAttributeFilter;
    private final FuzzyStr fuzzyStr;
    private HttpServletRequestInfo httpRequest;
    private ArchiveAEExtension arcAE;
    private Socket socket;
    private UnparsedHL7Message msg;
    private Study study;
    private Attributes attributes;
    private List<Attributes> requestAttrs;
    private Patient patient;
    private String studyInstanceUID;
    private String eventActionCode;
    private Exception exception;
    private LocalDate expirationDate;
    private String seriesInstanceUID;
    private String expirationExporterID;
    private boolean freezeExpirationDate;
    private boolean unfreezeExpirationDate;
    private String accessControlID;
    private String reasonForModification;
    private String sourceOfPreviousValues;

    StudyMgtContextImpl(Device device) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class);
        this.studyAttributeFilter = arcDev.getAttributeFilter(Entity.Study);
        this.seriesAttributeFilter = arcDev.getAttributeFilter(Entity.Series);
        this.fuzzyStr = arcDev.getFuzzyStr();
    }

    StudyMgtContextImpl withApplicationEntity(ApplicationEntity ae) {
        this.arcAE = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
        return this;
    }

    StudyMgtContextImpl withHttpRequest(HttpServletRequestInfo httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    StudyMgtContextImpl withSocket(Socket socket) {
        this.socket = socket;
        return this;
    }

    StudyMgtContextImpl withUnparsedHL7Message(UnparsedHL7Message msg) {
        this.msg = msg;
        return this;
    }

    @Override
    public AttributeFilter getStudyAttributeFilter() {
        return this.studyAttributeFilter;
    }

    @Override
    public FuzzyStr getFuzzyStr() {
        return this.fuzzyStr;
    }

    @Override
    public HttpServletRequestInfo getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public UnparsedHL7Message getUnparsedHL7Message() {
        return this.msg;
    }

    @Override
    public String getRemoteHostName() {
        return this.httpRequest != null ? this.httpRequest.requesterHost : (this.socket != null ? ReverseDNS.hostNameOf((InetAddress)this.socket.getInetAddress()) : null);
    }

    @Override
    public String getLocalHostName() {
        return this.httpRequest != null ? this.httpRequest.localHost : (this.socket != null ? ReverseDNS.hostNameOf((InetAddress)this.socket.getLocalAddress()) : null);
    }

    @Override
    public ApplicationEntity getApplicationEntity() {
        return this.arcAE.getApplicationEntity();
    }

    @Override
    public ArchiveAEExtension getArchiveAEExtension() {
        return this.arcAE;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        this.attributes = attrs;
        this.studyInstanceUID = attrs.getString(0x20000D);
        this.seriesInstanceUID = attrs.getString(0x20000E);
    }

    @Override
    public Patient getPatient() {
        return this.patient;
    }

    @Override
    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    @Override
    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    @Override
    public void setStudyInstanceUID(String studyUID) {
        this.studyInstanceUID = studyUID;
    }

    @Override
    public Study getStudy() {
        return this.study;
    }

    @Override
    public void setStudy(Study study) {
        this.study = study;
    }

    @Override
    public String getEventActionCode() {
        return this.eventActionCode;
    }

    @Override
    public void setEventActionCode(String eventActionCode) {
        this.eventActionCode = eventActionCode;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public void setExpirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Override
    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    @Override
    public void setSeriesInstanceUID(String seriesUID) {
        this.seriesInstanceUID = seriesUID;
    }

    @Override
    public String getExpirationExporterID() {
        return this.expirationExporterID;
    }

    @Override
    public void setExpirationExporterID(String expirationExporterID) {
        this.expirationExporterID = expirationExporterID;
    }

    @Override
    public boolean isFreezeExpirationDate() {
        return this.freezeExpirationDate;
    }

    @Override
    public void setFreezeExpirationDate(boolean freezeExpirationDate) {
        this.freezeExpirationDate = freezeExpirationDate;
    }

    @Override
    public boolean isUnfreezeExpirationDate() {
        return this.unfreezeExpirationDate;
    }

    @Override
    public void setUnfreezeExpirationDate(boolean unfreezeExpirationDate) {
        this.unfreezeExpirationDate = unfreezeExpirationDate;
    }

    @Override
    public String getAccessControlID() {
        return this.accessControlID;
    }

    @Override
    public void setAccessControlID(String accessControlID) {
        this.accessControlID = accessControlID;
    }

    @Override
    public AttributeFilter getSeriesAttributeFilter() {
        return this.seriesAttributeFilter;
    }

    @Override
    public List<Attributes> getRequestAttributes() {
        return this.requestAttrs;
    }

    @Override
    public void setRequestAttributes(List<Attributes> requestAttrs) {
        this.requestAttrs = requestAttrs;
    }

    @Override
    public String getReasonForModification() {
        return this.reasonForModification;
    }

    @Override
    public void setReasonForModification(String reasonForModification) {
        this.reasonForModification = reasonForModification;
    }

    @Override
    public String getSourceOfPreviousValues() {
        return this.sourceOfPreviousValues;
    }

    @Override
    public void setSourceOfPreviousValues(String sourceOfPreviousValues) {
        this.sourceOfPreviousValues = sourceOfPreviousValues;
    }
}

