/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.scu.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.imageio.codec.Transcoder;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.NoPresentationContextException;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.scu.impl.TranscoderDataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CStoreForwardTask
implements Runnable {
    static final Logger LOG = LoggerFactory.getLogger(CStoreForwardTask.class);
    private final RetrieveContext ctx;
    private final Association rqas;
    private final Association storeas;
    private final LinkedBlockingQueue<WrappedStoreContext> queue = new LinkedBlockingQueue();

    public CStoreForwardTask(RetrieveContext ctx, Association storeas) {
        this.ctx = ctx;
        this.rqas = ctx.getRequestAssociation();
        this.storeas = storeas;
    }

    public void onStore(StoreContext storeContext) {
        if (this.storeas != null) {
            this.queue.offer(new WrappedStoreContext(storeContext));
        } else if (storeContext != null) {
            this.ctx.addFailedSOPInstanceUID(storeContext.getSopInstanceUID());
            this.ctx.incrementFailed();
        }
    }

    @Override
    public void run() {
        try {
            StoreContext storeCtx;
            while ((storeCtx = this.queue.take().storeContext) != null) {
                this.store(storeCtx);
            }
            this.storeas.waitForOutstandingRSP();
        }
        catch (InterruptedException e) {
            LOG.warn("{}: failed to wait for outstanding RSP on association to {}", new Object[]{this.rqas, this.storeas.getRemoteAET(), e});
        }
        finally {
            this.releaseStoreAssociation();
            this.ctx.decrementPendingCStoreForward();
        }
    }

    private void releaseStoreAssociation() {
        try {
            this.storeas.release();
        }
        catch (IOException e) {
            LOG.warn("{}: failed to release association to {}", new Object[]{this.rqas, this.storeas.getRemoteAET(), e});
        }
    }

    private void store(StoreContext storeCtx) {
        InstanceLocations inst = this.createInstanceLocations(storeCtx);
        this.ctx.addCStoreForward(inst);
        String cuid = inst.getSopClassUID();
        String iuid = inst.getSopInstanceUID();
        Set tsuids = this.storeas.getTransferSyntaxesFor(cuid);
        try {
            if (tsuids.isEmpty()) {
                throw new NoPresentationContextException(cuid);
            }
            RetrieveService service = this.ctx.getRetrieveService();
            try (Transcoder transcoder = service.openTranscoder(this.ctx, inst, (Collection)tsuids, false);){
                AttributesCoercion coerce;
                String tsuid = transcoder.getDestinationTransferSyntax();
                List coercions = service.getArchiveAttributeCoercions(this.ctx, inst);
                if (coercions.isEmpty()) {
                    ArchiveAttributeCoercion rule = service.getArchiveAttributeCoercion(this.ctx, inst);
                    if (rule != null) {
                        transcoder.setNullifyPixelData(rule.isNullifyPixelData());
                    }
                    coerce = service.getAttributesCoercion(this.ctx, inst, rule);
                } else {
                    transcoder.setNullifyPixelData(ArchiveAttributeCoercion2.containsScheme((Collection)coercions, (String)"nullify-pixel-data"));
                    coerce = service.getAttributesCoercion(this.ctx, inst, coercions);
                }
                TranscoderDataWriter data = new TranscoderDataWriter(transcoder, coerce);
                CStoreRSPHandler rspHandler = new CStoreRSPHandler(inst);
                long startTime = System.nanoTime();
                this.storeas.cstore(cuid, iuid, this.ctx.getPriority(), this.ctx.getMoveOriginatorAETitle(), this.ctx.getMoveOriginatorMessageID(), (DataWriter)data, tsuid, (DimseRSPHandler)rspHandler);
                service.getMetricsService().acceptDataRate("send-to-" + this.storeas.getRemoteAET(), data.getCount(), startTime);
            }
        }
        catch (Exception e) {
            this.ctx.incrementFailed();
            this.ctx.addFailedMatch(inst);
            LOG.info("{}: failed to send {} to {}:", new Object[]{this.rqas, inst, this.ctx.getDestinationAETitle(), e});
        }
    }

    private InstanceLocations createInstanceLocations(StoreContext storeCtx) {
        Instance inst = storeCtx.getStoredInstance();
        Series series = inst.getSeries();
        Study study = series.getStudy();
        Patient patient = study.getPatient();
        Attributes instAttrs = inst.getAttributes();
        Attributes seriesAttrs = series.getAttributes();
        Attributes studyAttrs = study.getAttributes();
        Attributes patAttrs = patient.getAttributes();
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, studyAttrs, seriesAttrs, instAttrs});
        instAttrs.addAll(seriesAttrs, true);
        instAttrs.addAll(studyAttrs, true);
        instAttrs.addAll(patAttrs, true);
        RetrieveService service = this.ctx.getRetrieveService();
        InstanceLocations instanceLocations = service.newInstanceLocations(instAttrs);
        instanceLocations.getLocations().addAll(this.locations(storeCtx));
        return instanceLocations;
    }

    private Collection<Location> locations(StoreContext storeCtx) {
        List locations = storeCtx.getLocations();
        return locations.isEmpty() ? storeCtx.getStoredInstance().getLocations() : locations;
    }

    private final class CStoreRSPHandler
    extends DimseRSPHandler {
        private final InstanceLocations inst;

        public CStoreRSPHandler(InstanceLocations inst) {
            super(CStoreForwardTask.this.storeas.nextMessageID());
            this.inst = inst;
        }

        public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
            super.onDimseRSP(as, cmd, data);
            int storeStatus = cmd.getInt(2304, -1);
            if (storeStatus == 0) {
                CStoreForwardTask.this.ctx.incrementCompleted();
            } else if ((storeStatus & 0xB000) == 45056) {
                CStoreForwardTask.this.ctx.incrementWarning();
            } else {
                CStoreForwardTask.this.ctx.incrementFailed();
                CStoreForwardTask.this.ctx.addFailedMatch(this.inst);
            }
        }
    }

    private static class WrappedStoreContext {
        final StoreContext storeContext;

        private WrappedStoreContext(StoreContext storeContext) {
            this.storeContext = storeContext;
        }
    }
}

