/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.net.service.AbstractDicomService;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.StgCmtResult;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.DefaultExportContext;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.stgcmt.StgCmtManager;
import org.dcm4chee.arc.stgcmt.StgCmtSCP;
import org.dcm4chee.arc.stgcmt.StgCmtSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Typed(value={DicomService.class, StgCmtSCP.class, StgCmtSCU.class})
class StgCmtImpl
extends AbstractDicomService
implements StgCmtSCP,
StgCmtSCU {
    private static final Logger LOG = LoggerFactory.getLogger(StgCmtImpl.class);
    @Inject
    private TaskManager taskManager;
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private QueryService queryService;
    @Inject
    private StgCmtManager ejb;

    public StgCmtImpl() {
        super(new String[]{"1.2.840.10008.1.20.1"});
    }

    public void onDimseRQ(Association as, PresentationContext pc, Dimse dimse, Attributes rq, Attributes data) throws IOException {
        switch (dimse) {
            case N_ACTION_RQ: {
                this.onNActionRQ(as, pc, rq, data);
                return;
            }
            case N_EVENT_REPORT_RQ: {
                this.onNEventReportRQ(as, pc, rq, data);
                return;
            }
        }
        throw new DicomServiceException(529);
    }

    public void onExport(@Observes ExportContext ctx) {
        if (ctx.getException() != null) {
            return;
        }
        ExporterDescriptor descriptor = ctx.getExporter().getExporterDescriptor();
        String stgCmtSCPAETitle = descriptor.getStgCmtSCPAETitle();
        if (stgCmtSCPAETitle != null && ctx.getOutcome().getStatus() == Task.Status.COMPLETED) {
            this.scheduleStorageCommit(ctx, descriptor);
        }
    }

    @Override
    public void scheduleStorageCommit(ExportContext ctx, ExporterDescriptor descriptor) {
        String stgCmtSCPAETitle = descriptor.getStgCmtSCPAETitle();
        if (stgCmtSCPAETitle != null) {
            ApplicationEntity ae = this.device.getApplicationEntity(ctx.getAETitle(), true);
            Attributes actionInfo = this.createActionInfo(ctx, ae);
            this.scheduleNAction(ae.getCallingAETitle(stgCmtSCPAETitle), stgCmtSCPAETitle, actionInfo, ctx, descriptor.getExporterID(), new Date());
        }
    }

    @Override
    public void scheduleStorageCommit(String localAET, String remoteAET, Attributes match, String batchID, QueryRetrieveLevel2 qrLevel, Date scheduledTime) {
        ExportContext ctx = this.createExportContext(localAET, match, batchID, qrLevel);
        ApplicationEntity ae = this.device.getApplicationEntity(localAET, true);
        Attributes actionInfo = this.createActionInfo(ctx, ae);
        this.scheduleNAction(ae.getCallingAETitle(remoteAET), remoteAET, actionInfo, ctx, null, scheduledTime);
    }

    private ExportContext createExportContext(String localAET, Attributes match, String batchID, QueryRetrieveLevel2 qrLevel) {
        DefaultExportContext ctx = new DefaultExportContext(null);
        ctx.setStudyInstanceUID(match.getString(0x20000D));
        switch (qrLevel) {
            case IMAGE: {
                ctx.setSopInstanceUID(match.getString(524312));
            }
            case SERIES: {
                ctx.setSeriesInstanceUID(match.getString(0x20000E));
            }
        }
        ctx.setAETitle(localAET);
        ctx.setBatchID(batchID);
        return ctx;
    }

    private Attributes createActionInfo(ExportContext ctx, ApplicationEntity ae) {
        return this.queryService.createActionInfo(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), ae);
    }

    private void onNActionRQ(Association as, PresentationContext pc, Attributes rq, Attributes actionInfo) throws DicomServiceException {
        int actionTypeID = rq.getInt(4104, 0);
        if (actionTypeID != 1) {
            throw new DicomServiceException(291).setActionTypeID(actionTypeID);
        }
        this.validateActionInfo(actionInfo);
        String localAET = as.getLocalAET();
        String remoteAET = as.getRemoteAET();
        try {
            as.getApplicationEntity().findCompatibleConnection(this.aeCache.findApplicationEntity(remoteAET));
            this.scheduleNEventReport(localAET, remoteAET, actionInfo);
        }
        catch (ConfigurationNotFoundException e) {
            throw new DicomServiceException(272, "Unknown Calling AET: " + remoteAET);
        }
        catch (Exception e) {
            throw new DicomServiceException(272, e.getMessage());
        }
        try {
            as.writeDimseRSP(pc, Commands.mkNActionRSP((Attributes)rq, (int)0), null);
        }
        catch (Exception e) {
            LOG.warn("{} << N-ACTION-RSP failed: {}", (Object)as, (Object)e.getMessage());
        }
    }

    private void validateActionInfo(Attributes actionInfo) throws DicomServiceException {
        if (!actionInfo.containsValue(528789)) {
            throw new DicomServiceException(277, "Missing Transaction UID (0008,1195)", false);
        }
        Sequence refSopSeq = actionInfo.getSequence(528793);
        if (refSopSeq == null || refSopSeq.isEmpty()) {
            throw new DicomServiceException(277, "Missing Referenced SOP Sequence (0008,1199)", false);
        }
        if (!refSopSeq.stream().allMatch(refSop -> refSop.containsValue(528725))) {
            throw new DicomServiceException(277, "Missing Referenced SOP Instance UID (0008,1155) in item of Referenced SOP Sequence (0008,1199)", false);
        }
    }

    private void onNEventReportRQ(Association as, PresentationContext pc, Attributes rq, Attributes eventInfo) {
        this.ejb.addExternalRetrieveAETs(eventInfo, this.device);
        try {
            as.writeDimseRSP(pc, Commands.mkNEventReportRSP((Attributes)rq, (int)0), null);
        }
        catch (Exception e) {
            LOG.warn("{} << N-EVENT-REPORT-RSP failed: {}", (Object)as, (Object)e.getMessage());
        }
    }

    private void scheduleNAction(String localAET, String remoteAET, Attributes actionInfo, ExportContext ctx, String exporterID, Date scheduledTime) {
        Task task = new Task();
        task.setDeviceName(this.device.getDeviceName());
        task.setQueueName("StgCmtSCU");
        task.setType(Task.Type.STGCMT_SCU);
        task.setScheduledTime(scheduledTime);
        task.setLocalAET(localAET);
        task.setRemoteAET(remoteAET);
        task.setStudyInstanceUID(ctx.getStudyInstanceUID());
        task.setSeriesInstanceUID(ctx.getSeriesInstanceUID());
        task.setSOPInstanceUID(ctx.getSopInstanceUID());
        task.setExporterID(exporterID);
        task.setPayload((Serializable)actionInfo);
        task.setStatus(Task.Status.SCHEDULED);
        task.setBatchID(ctx.getBatchID());
        this.taskManager.scheduleTask(task);
    }

    private void scheduleNEventReport(String localAET, String remoteAET, Attributes eventInfo) {
        Task task = new Task();
        task.setDeviceName(this.device.getDeviceName());
        task.setQueueName("StgCmtSCP");
        task.setType(Task.Type.STGCMT_SCP);
        task.setScheduledTime(new Date());
        task.setLocalAET(localAET);
        task.setRemoteAET(remoteAET);
        task.setPayload((Serializable)eventInfo);
        task.setStatus(Task.Status.SCHEDULED);
        this.taskManager.scheduleTask(task);
    }

    @Override
    public Outcome sendNAction(String localAET, String remoteAET, String studyInstanceUID, String seriesInstanceUID, String sopInstanceUID, String exporterID, Long taskPK, String batchID, Attributes actionInfo) throws Exception {
        DimseRSP dimseRSP = this.sendNActionRQ(localAET, remoteAET, studyInstanceUID, seriesInstanceUID, sopInstanceUID, exporterID, taskPK, batchID, actionInfo);
        Attributes cmd = dimseRSP.getCommand();
        int status = cmd.getInt(2304, -1);
        if (status != 0) {
            return new Outcome(Task.Status.WARNING, "Request Storage Commitment from AE: " + remoteAET + " failed with status: " + TagUtils.shortToHexString((int)status) + "H, error comment: " + cmd.getString(2306));
        }
        return new Outcome(Task.Status.COMPLETED, "Request Storage Commitment from AE: " + remoteAET);
    }

    @Override
    public DimseRSP sendNActionRQ(String localAET, String remoteAET, String studyInstanceUID, String seriesInstanceUID, String sopInstanceUID, String exporterID, Long taskPK, String batchID, Attributes actionInfo) throws Exception {
        ApplicationEntity localAE = this.device.getApplicationEntity(localAET, true);
        ApplicationEntity remoteAE = this.aeCache.findApplicationEntity(remoteAET);
        AAssociateRQ aarq = this.mkAAssociateRQ(localAE, TransferCapability.Role.SCU);
        if (!localAE.isMasqueradeCallingAETitle(remoteAET)) {
            aarq.setCallingAET(localAET);
        }
        Association as = localAE.connect(remoteAE, aarq);
        try {
            StgCmtResult result = new StgCmtResult();
            result.setStgCmtRequest(actionInfo);
            result.setStudyInstanceUID(studyInstanceUID);
            result.setSeriesInstanceUID(seriesInstanceUID);
            result.setSopInstanceUID(sopInstanceUID);
            result.setExporterID(exporterID);
            result.setTaskPK(taskPK);
            result.setBatchID(batchID);
            result.setDeviceName(this.device.getDeviceName());
            this.ejb.persistStgCmtResult(result);
            DimseRSP dimseRSP = as.naction("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", 1, actionInfo, null);
            dimseRSP.next();
            if (dimseRSP.getCommand().getInt(2304, -1) != 0) {
                this.ejb.deleteStgCmt(actionInfo.getString(528789));
            }
            DimseRSP dimseRSP2 = dimseRSP;
            return dimseRSP2;
        }
        catch (Exception e) {
            this.ejb.deleteStgCmt(actionInfo.getString(528789));
            throw e;
        }
        finally {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association to {}", (Object)as, (Object)remoteAET);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome sendNEventReport(String localAET, ApplicationEntity remoteAE, Attributes eventInfo) throws Exception {
        ApplicationEntity localAE = this.device.getApplicationEntity(localAET, true);
        AAssociateRQ aarq = this.mkAAssociateRQ(localAE, TransferCapability.Role.SCP);
        aarq.setCallingAET(localAET);
        Association as = localAE.connect(remoteAE, aarq);
        try {
            int successful = this.sequenceSizeOf(eventInfo, 528793);
            int failed = this.sequenceSizeOf(eventInfo, 528792);
            DimseRSP neventReport = as.neventReport("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", failed > 0 ? 2 : 1, eventInfo, null);
            neventReport.next();
            Outcome outcome = new Outcome(failed > 0 ? Task.Status.WARNING : Task.Status.COMPLETED, "Return Storage Commitment Result[successful: " + successful + ", failed: " + failed + "] to AE: " + remoteAE.getAETitle());
            return outcome;
        }
        finally {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association to {}", (Object)as, (Object)remoteAE.getAETitle());
            }
        }
    }

    private int sequenceSizeOf(Attributes eventInfo, int seqTag) {
        Sequence seq = eventInfo.getSequence(seqTag);
        return seq != null ? seq.size() : 0;
    }

    private AAssociateRQ mkAAssociateRQ(ApplicationEntity localAE, TransferCapability.Role role) {
        AAssociateRQ aarq = new AAssociateRQ();
        TransferCapability tc = localAE.getTransferCapabilityFor("1.2.840.10008.1.20.1", role);
        aarq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.1.20.1", tc.getTransferSyntaxes()));
        if (role == TransferCapability.Role.SCP) {
            aarq.addRoleSelection(new RoleSelection("1.2.840.10008.1.20.1", false, true));
        }
        return aarq;
    }
}

