/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.RejectedInstance;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.StgCmtResult;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.entity.Task_;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.StgCmtResultQueryParam;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.dcm4chee.arc.stgcmt.StgVerBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class StgCmtEJB {
    private final Logger LOG = LoggerFactory.getLogger(StgCmtEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private Device device;

    public void addExternalRetrieveAETs(Attributes eventInfo, Device device) {
        String transactionUID = eventInfo.getString(528789);
        StgCmtResult result = this.getStgCmtResult(transactionUID);
        if (result == null) {
            return;
        }
        this.updateExternalRetrieveAETs(eventInfo, result.getStudyInstanceUID(), ((ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class)).getExporterDescriptor(result.getExporterID()));
        result.setStgCmtResult(eventInfo);
    }

    private StgCmtResult getStgCmtResult(String transactionUID) throws NoResultException {
        StgCmtResult result;
        try {
            result = (StgCmtResult)this.em.createNamedQuery("StgCmtResult.findByTransactionUID", StgCmtResult.class).setParameter(1, (Object)transactionUID).getSingleResult();
        }
        catch (NoResultException e) {
            this.LOG.warn("No Storage Commitment result found with transaction UID : " + transactionUID);
            return null;
        }
        return result;
    }

    private void updateExternalRetrieveAETs(Attributes eventInfo, String suid, ExporterDescriptor ed) {
        if (ed == null) {
            return;
        }
        String configRetrieveAET = ed.getRetrieveAETitles().length > 0 ? ed.getRetrieveAETitles()[0] : null;
        String defRetrieveAET = eventInfo.getString(524372, ed.getStgCmtSCPAETitle());
        Sequence sopSeq = eventInfo.getSequence(528793);
        List instances = this.em.createNamedQuery("Instance.findByStudyIUID", Instance.class).setParameter(1, (Object)suid).getResultList();
        HashSet<String> studyExternalAETs = new HashSet<String>(4);
        IdentityHashMap<Series, HashSet<String>> seriesExternalAETsMap = new IdentityHashMap<Series, HashSet<String>>();
        for (Instance instance : instances) {
            Attributes sopRef = this.sopRefOf(instance.getSopInstanceUID(), sopSeq);
            if (sopRef != null) {
                instance.setExternalRetrieveAET(configRetrieveAET != null ? configRetrieveAET : sopRef.getString(524372, defRetrieveAET));
            }
            if (this.isRejected(instance) || this.isRejectionNoteDataRetentionPolicyExpired(instance)) continue;
            String externalRetrieveAET = instance.getExternalRetrieveAET();
            Series series = instance.getSeries();
            HashSet<String> seriesExternalAETs = (HashSet<String>)seriesExternalAETsMap.get(series);
            if (seriesExternalAETs == null) {
                seriesExternalAETs = new HashSet<String>(4);
                seriesExternalAETsMap.put(series, seriesExternalAETs);
            }
            seriesExternalAETs.add(externalRetrieveAET);
            studyExternalAETs.add(externalRetrieveAET);
        }
        for (Map.Entry entry : seriesExternalAETsMap.entrySet()) {
            Set seriesExternalAETs = (Set)entry.getValue();
            if (seriesExternalAETs.size() != 1 || seriesExternalAETs.contains(null)) continue;
            ((Series)entry.getKey()).setExternalRetrieveAET((String)seriesExternalAETs.iterator().next());
        }
        if (studyExternalAETs.size() == 1 && !studyExternalAETs.contains(null)) {
            ((Instance)instances.get(0)).getSeries().getStudy().setExternalRetrieveAET((String)studyExternalAETs.iterator().next());
        }
    }

    private boolean isRejected(Instance inst) {
        try {
            this.em.createNamedQuery("RejectedInstance.findByUIDs", RejectedInstance.class).setParameter(1, (Object)inst.getSeries().getStudy().getStudyInstanceUID()).setParameter(2, (Object)inst.getSeries().getSeriesInstanceUID()).setParameter(3, (Object)inst.getSopInstanceUID()).getSingleResult();
            return true;
        }
        catch (NoResultException e) {
            return false;
        }
    }

    private boolean isRejectionNoteDataRetentionPolicyExpired(Instance inst) {
        if (!inst.getSopClassUID().equals("1.2.840.10008.5.1.4.1.1.88.59") || inst.getConceptNameCode() == null) {
            return false;
        }
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        RejectionNote rjnote = arcdev.getRejectionNote(inst.getConceptNameCode().getCode());
        return rjnote != null && rjnote.getRejectionNoteType() == RejectionNote.Type.DATA_RETENTION_POLICY_EXPIRED;
    }

    private Attributes sopRefOf(String iuid, Sequence seq) {
        for (Attributes item : seq) {
            if (!iuid.equals(item.getString(528725))) continue;
            return item;
        }
        return null;
    }

    public void persistStgCmtResult(StgCmtResult result) {
        this.em.persist((Object)result);
    }

    public List<StgCmtResult> listStgCmts(StgCmtResultQueryParam queryParam, int offset, int limit) {
        CriteriaQuery q;
        Root stgCmtResult;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        QueryBuilder queryBuilder = new QueryBuilder(cb);
        List predicates = queryBuilder.stgCmtResultPredicates(stgCmtResult = (q = cb.createQuery(StgCmtResult.class)).from(StgCmtResult.class), queryParam);
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        TypedQuery query = this.em.createQuery(q);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public boolean deleteStgCmt(String transactionUID) {
        try {
            StgCmtResult result = this.getStgCmtResult(transactionUID);
            if (result != null) {
                this.em.remove((Object)result);
                return true;
            }
        }
        catch (Exception e) {
            this.LOG.warn("Deletion of Storage Commitment Result threw exception : " + e);
        }
        return false;
    }

    public int deleteStgCmts(StgCmtResult.Status status, Date updatedBefore) {
        CriteriaDelete q;
        Root stgCmtResult;
        StgCmtResultQueryParam stgCmtResultQueryParam = new StgCmtResultQueryParam(status, updatedBefore, null, null, null, null);
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        QueryBuilder queryBuilder = new QueryBuilder(cb);
        List predicates = queryBuilder.stgCmtResultPredicates(stgCmtResult = (q = cb.createCriteriaDelete(StgCmtResult.class)).from(StgCmtResult.class), stgCmtResultQueryParam);
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return this.em.createQuery(q).executeUpdate();
    }

    public int updateStgVerTask(Task storageVerificationTask) {
        return this.em.createNamedQuery("Task.UpdateStgVerResultByPk").setParameter(1, (Object)storageVerificationTask.getPk()).setParameter(2, (Object)storageVerificationTask.getCompleted()).setParameter(3, (Object)storageVerificationTask.getFailed()).executeUpdate();
    }

    public int updateSeries(long seriesPk, int failures, long size) {
        return this.em.createNamedQuery("Series.updateStgVerFailures").setParameter(1, (Object)seriesPk).setParameter(2, (Object)failures).setParameter(3, (Object)size).executeUpdate();
    }

    public int updateStudySize(Long studyPk, long studySize) {
        return this.em.createNamedQuery("Study.setStudySize").setParameter(1, (Object)studyPk).setParameter(2, (Object)studySize).executeUpdate();
    }

    public List<StgVerBatch> listStgVerBatches(TaskQueryParam taskQueryParam, int offset, int limit) {
        ListStgVerBatches listStgVerBatches = new ListStgVerBatches(taskQueryParam);
        TypedQuery query = this.em.createQuery(listStgVerBatches.query);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultStream().map(listStgVerBatches::toStgVerBatch).collect(Collectors.toList());
    }

    public List<Series.StorageVerification> findSeriesForScheduledStorageVerifications(int fetchSize) {
        return this.em.createNamedQuery("Series.scheduledStorageVerification", Series.StorageVerification.class).setMaxResults(fetchSize).getResultList();
    }

    public int claimForStorageVerification(Long seriesPk, Date verificationTime, Date nextVerificationTime) {
        return this.em.createNamedQuery("Series.claimStorageVerification").setParameter(1, (Object)seriesPk).setParameter(2, verificationTime, TemporalType.TIMESTAMP).setParameter(3, nextVerificationTime, TemporalType.TIMESTAMP).executeUpdate();
    }

    public boolean scheduleStgVerTask(String localAET, QueryRetrieveLevel2 qrlevel, HttpServletRequestInfo httpServletRequestInfo, String studyInstanceUID, String seriesInstanceUID, String sopInstanceUID, String batchID, Date scheduledTime, StorageVerificationPolicy storageVerificationPolicy, Boolean updateLocationStatus, String ... storageIDs) {
        Task task = new Task();
        task.setDeviceName(this.device.getDeviceName());
        task.setQueueName("StgVerTasks");
        task.setType(Task.Type.STGVER);
        task.setScheduledTime(scheduledTime);
        if (httpServletRequestInfo != null) {
            task.setRequesterUserID(httpServletRequestInfo.requesterUserID);
            task.setRequesterHost(httpServletRequestInfo.requesterHost);
            task.setRequestURI(this.requestURL(httpServletRequestInfo));
        }
        task.setStatus(Task.Status.SCHEDULED);
        task.setBatchID(batchID);
        task.setLocalAET(localAET);
        task.setStorageVerificationPolicy(storageVerificationPolicy);
        task.setUpdateLocationStatus(updateLocationStatus);
        task.setStorageIDs(storageIDs);
        task.setStudyInstanceUID(studyInstanceUID);
        if (qrlevel != QueryRetrieveLevel2.STUDY) {
            task.setSeriesInstanceUID(seriesInstanceUID);
            if (qrlevel == QueryRetrieveLevel2.IMAGE) {
                task.setSOPInstanceUID(sopInstanceUID);
            }
        }
        if (this.isStorageVerificationTaskAlreadyScheduled(task)) {
            return false;
        }
        this.em.persist((Object)task);
        this.LOG.info("Create {}", (Object)task);
        return true;
    }

    private String requestURL(HttpServletRequestInfo httpServletRequestInfo) {
        String requestURI = httpServletRequestInfo.requestURI;
        String queryString = httpServletRequestInfo.queryString;
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public boolean scheduleStgVerTask(String localAET, String studyInstanceUID, String seriesInstanceUID, String batchID) {
        return this.scheduleStgVerTask(localAET, QueryRetrieveLevel2.SERIES, null, studyInstanceUID, seriesInstanceUID, null, batchID, new Date(), null, null, new String[0]);
    }

    private boolean isStorageVerificationTaskAlreadyScheduled(Task storageVerificationTask) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Long.class);
        Root stgVerTask = q.from(Task.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.equal((Expression)stgVerTask.get(Task_.type), (Object)Task.Type.STGVER));
        predicates.add(stgVerTask.get(Task_.status).in(new Object[]{Task.Status.SCHEDULED, Task.Status.IN_PROCESS}));
        predicates.add(cb.equal((Expression)stgVerTask.get(Task_.studyInstanceUID), (Object)storageVerificationTask.getStudyInstanceUID()));
        if (storageVerificationTask.getSeriesInstanceUID() == null) {
            predicates.add(stgVerTask.get(Task_.seriesInstanceUID).isNull());
        } else {
            predicates.add(cb.or((Expression)stgVerTask.get(Task_.seriesInstanceUID).isNull(), (Expression)cb.equal((Expression)stgVerTask.get(Task_.seriesInstanceUID), (Object)storageVerificationTask.getSeriesInstanceUID())));
            if (storageVerificationTask.getSOPInstanceUID() == null) {
                predicates.add(stgVerTask.get(Task_.sopInstanceUID).isNull());
            } else {
                predicates.add(cb.or((Expression)stgVerTask.get(Task_.sopInstanceUID).isNull(), (Expression)cb.equal((Expression)stgVerTask.get(Task_.sopInstanceUID), (Object)storageVerificationTask.getSOPInstanceUID())));
            }
        }
        if (storageVerificationTask.getStorageVerificationPolicy() != null) {
            predicates.add(cb.equal((Expression)stgVerTask.get(Task_.storageVerificationPolicy), (Object)storageVerificationTask.getStorageVerificationPolicy()));
        }
        if (storageVerificationTask.getStorageIDsAsString() != null) {
            predicates.add(cb.equal((Expression)stgVerTask.get(Task_.storageIDs), (Object)storageVerificationTask.getStorageIDsAsString()));
        }
        try (Stream resultStream = this.em.createQuery(q.where(predicates.toArray(new Predicate[0])).select((Selection)stgVerTask.get(Task_.pk))).getResultStream();){
            Optional prev = resultStream.findFirst();
            if (prev.isPresent()) {
                this.LOG.info("Previous {} found - suppress duplicate storage verification", prev.get());
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public long countScheduledTasksOnThisDevice(String queueName) {
        return (Long)this.em.createNamedQuery("Task.CountByDeviceAndQueueNameAndStatus", Long.class).setParameter(1, (Object)this.device.getDeviceName()).setParameter(2, (Object)queueName).setParameter(3, (Object)Task.Status.SCHEDULED).getSingleResult();
    }

    private class ListStgVerBatches {
        final CriteriaBuilder cb;
        final QueryBuilder queryBuilder;
        final CriteriaQuery<Tuple> query;
        final Root<Task> task;
        final Expression<Date> minProcessingStartTime;
        final Expression<Date> maxProcessingStartTime;
        final Expression<Date> minProcessingEndTime;
        final Expression<Date> maxProcessingEndTime;
        final Expression<Date> minScheduledTime;
        final Expression<Date> maxScheduledTime;
        final Expression<Date> minCreatedTime;
        final Expression<Date> maxCreatedTime;
        final Expression<Date> minUpdatedTime;
        final Expression<Date> maxUpdatedTime;
        final Path<String> batchIDPath;
        final Expression<Long> completed;
        final Expression<Long> failed;
        final Expression<Long> warning;
        final Expression<Long> canceled;
        final Expression<Long> scheduled;
        final Expression<Long> inprocess;
        final TaskQueryParam queryParam;

        ListStgVerBatches(TaskQueryParam queryParam) {
            this.cb = StgCmtEJB.this.em.getCriteriaBuilder();
            this.queryBuilder = new QueryBuilder(this.cb);
            this.query = this.cb.createTupleQuery();
            this.task = this.query.from(Task.class);
            this.minProcessingStartTime = this.cb.least((Expression)this.task.get(Task_.processingStartTime));
            this.maxProcessingStartTime = this.cb.greatest((Expression)this.task.get(Task_.processingStartTime));
            this.minProcessingEndTime = this.cb.least((Expression)this.task.get(Task_.processingEndTime));
            this.maxProcessingEndTime = this.cb.greatest((Expression)this.task.get(Task_.processingEndTime));
            this.minScheduledTime = this.cb.least((Expression)this.task.get(Task_.scheduledTime));
            this.maxScheduledTime = this.cb.greatest((Expression)this.task.get(Task_.scheduledTime));
            this.minCreatedTime = this.cb.least((Expression)this.task.get(Task_.createdTime));
            this.maxCreatedTime = this.cb.greatest((Expression)this.task.get(Task_.createdTime));
            this.minUpdatedTime = this.cb.least((Expression)this.task.get(Task_.updatedTime));
            this.maxUpdatedTime = this.cb.greatest((Expression)this.task.get(Task_.updatedTime));
            this.batchIDPath = this.task.get(Task_.batchID);
            this.queryParam = queryParam;
            this.completed = this.statusSubquery(Task.Status.COMPLETED).getSelection();
            this.failed = this.statusSubquery(Task.Status.FAILED).getSelection();
            this.warning = this.statusSubquery(Task.Status.WARNING).getSelection();
            this.canceled = this.statusSubquery(Task.Status.CANCELED).getSelection();
            this.scheduled = this.statusSubquery(Task.Status.SCHEDULED).getSelection();
            this.inprocess = this.statusSubquery(Task.Status.IN_PROCESS).getSelection();
            this.query.multiselect(new Selection[]{this.batchIDPath, this.minProcessingStartTime, this.maxProcessingStartTime, this.minProcessingEndTime, this.maxProcessingEndTime, this.minScheduledTime, this.maxScheduledTime, this.minCreatedTime, this.maxCreatedTime, this.minUpdatedTime, this.maxUpdatedTime, this.completed, this.failed, this.warning, this.canceled, this.scheduled, this.inprocess});
            this.query.groupBy(new Expression[]{this.task.get(Task_.batchID)});
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)this.task.get(Task_.type), (Object)queryParam.getType()));
            if (queryParam.getBatchID() != null) {
                predicates.add(this.cb.equal((Expression)this.task.get(Task_.batchID), (Object)queryParam.getBatchID()));
            } else {
                predicates.add(this.task.get(Task_.batchID).isNotNull());
            }
            if (queryParam.getStatus() != null) {
                predicates.add(this.cb.equal((Expression)this.task.get(Task_.status), (Object)queryParam.getStatus()));
            }
            this.queryBuilder.matchStgVerBatch(predicates, queryParam, this.task);
            if (!predicates.isEmpty()) {
                this.query.where(predicates.toArray(new Predicate[0]));
            }
            if (queryParam.getOrderBy() != null) {
                this.query.orderBy(new Order[]{this.queryBuilder.orderBatches(this.task, queryParam.getOrderBy())});
            }
        }

        private Subquery<Long> statusSubquery(Task.Status status) {
            CriteriaQuery query = this.cb.createQuery(Task.class);
            Subquery sq = query.subquery(Long.class);
            Root sqtask = sq.from(Task.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)sqtask.get(Task_.status), (Object)status));
            predicates.add(this.cb.equal((Expression)sqtask.get(Task_.batchID), (Expression)this.task.get(Task_.batchID)));
            this.queryBuilder.matchStgVerBatch(predicates, this.queryParam, (Path)sqtask);
            sq.where(predicates.toArray(new Predicate[0]));
            sq.select(this.cb.count((Expression)sqtask));
            return sq;
        }

        StgVerBatch toStgVerBatch(Tuple tuple) {
            String batchID = (String)tuple.get(this.batchIDPath);
            StgVerBatch stgVerBatch = new StgVerBatch(batchID);
            stgVerBatch.setProcessingStartTimeRange((Date)tuple.get(this.minProcessingStartTime), (Date)tuple.get(this.maxProcessingStartTime));
            stgVerBatch.setProcessingEndTimeRange((Date)tuple.get(this.minProcessingEndTime), (Date)tuple.get(this.maxProcessingEndTime));
            stgVerBatch.setScheduledTimeRange((Date)tuple.get(this.minScheduledTime), (Date)tuple.get(this.maxScheduledTime));
            stgVerBatch.setCreatedTimeRange((Date)tuple.get(this.minCreatedTime), (Date)tuple.get(this.maxCreatedTime));
            stgVerBatch.setUpdatedTimeRange((Date)tuple.get(this.minUpdatedTime), (Date)tuple.get(this.maxUpdatedTime));
            CriteriaQuery distinct = this.cb.createQuery(String.class).distinct(true);
            Root stgverTask = distinct.from(Task.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)stgverTask.get(Task_.batchID), (Object)batchID));
            this.queryBuilder.matchStgVerBatch(predicates, this.queryParam, (Path)stgverTask);
            distinct.where(predicates.toArray(new Predicate[0]));
            stgVerBatch.setDeviceNames(this.select((CriteriaQuery<String>)distinct, (Path<String>)stgverTask.get(Task_.deviceName)));
            stgVerBatch.setLocalAETs(this.select((CriteriaQuery<String>)distinct, (Path<String>)stgverTask.get(Task_.localAET)));
            stgVerBatch.setCompleted((Long)tuple.get(this.completed));
            stgVerBatch.setCanceled((Long)tuple.get(this.canceled));
            stgVerBatch.setWarning((Long)tuple.get(this.warning));
            stgVerBatch.setFailed((Long)tuple.get(this.failed));
            stgVerBatch.setScheduled((Long)tuple.get(this.scheduled));
            stgVerBatch.setInProcess((Long)tuple.get(this.inprocess));
            return stgVerBatch;
        }

        private List<String> select(CriteriaQuery<String> query, Path<String> path) {
            return StgCmtEJB.this.em.createQuery(query.select(path)).getResultList();
        }
    }
}

