/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.api.IDeviceCache;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.AssociationHandler;
import org.dcm4che3.net.AssociationMonitor;
import org.dcm4che3.net.ConnectionMonitor;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.hl7.HL7ConnectionMonitor;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.HL7MessageListener;
import org.dcm4che3.net.hl7.service.HL7Service;
import org.dcm4che3.net.hl7.service.HL7ServiceRegistry;
import org.dcm4che3.net.service.BasicCEchoSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceRegistry;
import org.dcm4chee.arc.ArchiveService;
import org.dcm4chee.arc.HL7ExportHistory;
import org.dcm4chee.arc.HL7PrefetchHistory;
import org.dcm4chee.arc.LeadingCFindSCPQueryCache;
import org.dcm4chee.arc.MergeMWLCache;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.StorePermissionCache;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ShowPatientInfo;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.event.ArchiveServiceEvent;
import org.dcm4chee.arc.event.SoftwareConfiguration;
import org.dcm4chee.arc.impl.ArchiveDeviceProducer;
import org.dcm4chee.arc.impl.AssociationEventSource;
import org.dcm4chee.arc.impl.ConnectionEventSource;
import org.dcm4chee.arc.impl.HL7ConnectionEventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class ArchiveServiceImpl
implements ArchiveService {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveServiceImpl.class);
    @Inject
    private ArchiveDeviceProducer deviceProducer;
    @Inject
    private Instance<DicomService> dicomServices;
    @Inject
    private Instance<HL7Service> hl7Services;
    @Inject
    private Instance<Scheduler> schedulers;
    @Inject
    private IDeviceCache deviceCache;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private IWebApplicationCache webAppCache;
    @Inject
    private IHL7ApplicationCache hl7AppCache;
    @Inject
    private HL7ExportHistory hl7ExportHistory;
    @Inject
    private HL7PrefetchHistory hl7PrefetchHistory;
    @Inject
    private LeadingCFindSCPQueryCache leadingCFindSCPQueryCache;
    @Inject
    private MergeMWLCache mergeMWLCache;
    @Inject
    private StorePermissionCache storePermissionCache;
    @Inject
    private Device device;
    @Resource
    private ManagedExecutorService executor;
    @Resource
    private ManagedScheduledExecutorService scheduledExecutor;
    @Inject
    private AssociationHandler associationHandler;
    @Inject
    private Event<ArchiveServiceEvent> archiveServiceEvent;
    @Inject
    private ConnectionEventSource connectionEventSource;
    @Inject
    private AssociationEventSource associationEventSource;
    @Inject
    private HL7ConnectionEventSource hl7ConnectionEventSource;
    @Inject
    private DicomConfiguration conf;
    @Inject
    private Event<SoftwareConfiguration> softwareConfigurationEvent;
    private volatile ArchiveService.Status status = ArchiveService.Status.STOPPED;
    private final DicomService echoscp = new BasicCEchoSCP();
    private final DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
    private final HL7ServiceRegistry hl7ServiceRegistry = new HL7ServiceRegistry();

    @PostConstruct
    public void init() {
        try {
            AttributesBlob.setBlobCorruptedHandler(ArchiveServiceImpl::BlobCorruptedHandler);
            this.device.setConnectionMonitor((ConnectionMonitor)this.connectionEventSource);
            this.device.setAssociationMonitor((AssociationMonitor)this.associationEventSource);
            this.device.setExecutor((Executor)this.executor);
            this.device.setScheduledExecutor((ScheduledExecutorService)this.scheduledExecutor);
            this.device.setAssociationHandler(this.associationHandler);
            this.serviceRegistry.addDicomService(this.echoscp);
            for (DicomService service : this.dicomServices) {
                this.serviceRegistry.addDicomService(service);
            }
            for (DicomService service : this.hl7Services) {
                this.hl7ServiceRegistry.addHL7Service((HL7Service)service);
            }
            this.device.setDimseRQHandler((DimseRQHandler)this.serviceRegistry);
            HL7DeviceExtension hl7Extension = (HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class);
            if (hl7Extension != null) {
                hl7Extension.setHL7MessageListener((HL7MessageListener)this.hl7ServiceRegistry);
                hl7Extension.setHL7ConnectionMonitor((HL7ConnectionMonitor)this.hl7ConnectionEventSource);
            }
            this.mergeSoftwareVersions();
            this.configure();
            this.start(null);
        }
        catch (RuntimeException re) {
            this.destroy();
            throw re;
        }
        catch (Exception e) {
            this.destroy();
            throw new RuntimeException(e);
        }
    }

    private static Attributes BlobCorruptedHandler(byte[] bytes, Attributes result, IOException e) {
        LOG.warn("Failed to decode Attributes BLOB:\n", (Throwable)e);
        Path dir = Paths.get(System.getProperty("jboss.server.log.dir"), new SimpleDateFormat("'corrupted-blobs'-YYYY-MM-dd").format(new Date()));
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = Files.createTempFile(dir, "blob-", ".bin", new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                out.write(bytes);
            }
            LOG.info("Store corrupted Attributes BLOB to {}", (Object)file);
        }
        catch (IOException e2) {
            LOG.warn("Failed to log corrupted Attributes BLOB\n", (Throwable)e2);
        }
        return result;
    }

    @PreDestroy
    public void destroy() {
        if (this.status != ArchiveService.Status.STOPPED) {
            this.stop(null);
        }
        this.serviceRegistry.removeDicomService(this.echoscp);
        for (DicomService service : this.dicomServices) {
            this.serviceRegistry.removeDicomService(service);
        }
        for (DicomService service : this.hl7Services) {
            this.hl7ServiceRegistry.removeHL7Service((HL7Service)service);
        }
    }

    @Override
    public void start(HttpServletRequest request) throws Exception {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.start();
        }
        this.device.bindConnections();
        this.status = ArchiveService.Status.STARTED;
        this.archiveServiceEvent.fire((Object)new ArchiveServiceEvent(ArchiveServiceEvent.Type.STARTED, request));
    }

    @Override
    public void stop(HttpServletRequest request) {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.stop();
        }
        this.device.unbindConnections();
        this.status = ArchiveService.Status.STOPPED;
        this.archiveServiceEvent.fire((Object)new ArchiveServiceEvent(ArchiveServiceEvent.Type.STOPPED, request));
    }

    @Override
    public ArchiveService.Status status(HttpServletRequest request) {
        return this.status;
    }

    @Override
    public void reload(HttpServletRequest request) throws Exception {
        this.deviceProducer.reloadConfiguration();
        for (Scheduler scheduler : this.schedulers) {
            scheduler.reload();
        }
        this.device.rebindConnections();
        this.deviceCache.clear();
        this.aeCache.clear();
        this.webAppCache.clear();
        this.hl7AppCache.clear();
        this.hl7ExportHistory.clear();
        this.hl7PrefetchHistory.clear();
        this.leadingCFindSCPQueryCache.clear();
        this.mergeMWLCache.clear();
        this.storePermissionCache.clear();
        this.configure();
        this.archiveServiceEvent.fire((Object)new ArchiveServiceEvent(ArchiveServiceEvent.Type.RELOADED, request));
    }

    private void configure() {
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        this.deviceCache.setStaleTimeout(arcdev.getAECacheStaleTimeoutSeconds());
        this.aeCache.setStaleTimeout(arcdev.getAECacheStaleTimeoutSeconds());
        this.webAppCache.setStaleTimeout(arcdev.getAECacheStaleTimeoutSeconds());
        this.hl7AppCache.setStaleTimeout(arcdev.getAECacheStaleTimeoutSeconds());
        this.leadingCFindSCPQueryCache.setStaleTimeout((long)arcdev.getLeadingCFindSCPQueryCacheStaleTimeoutSeconds() * 1000L);
        this.leadingCFindSCPQueryCache.setMaxSize(arcdev.getLeadingCFindSCPQueryCacheSize());
        this.mergeMWLCache.setStaleTimeout((long)arcdev.getMergeMWLCacheStaleTimeoutSeconds() * 1000L);
        this.mergeMWLCache.setMaxSize(arcdev.getMergeMWLCacheSize());
        this.storePermissionCache.setStaleTimeout((long)arcdev.getStorePermissionCacheStaleTimeoutSeconds() * 1000L);
        this.storePermissionCache.setMaxSize(arcdev.getStorePermissionCacheSize());
        Patient.setShowPatientInfo((ShowPatientInfo)arcdev.showPatientInfoInSystemLog());
    }

    private void mergeSoftwareVersions() {
        Properties gitProps = new Properties();
        InputStream in = ArchiveService.class.getResourceAsStream("git.properties");
        if (in == null) {
            LOG.warn("Missing git.properties");
            return;
        }
        try {
            gitProps.load(in);
        }
        catch (IOException e) {
            LOG.warn("Failed to read git.properties", (Throwable)e);
            return;
        }
        Object[] versions = new String[]{"master".equals(gitProps.getProperty("git.branch")) ? gitProps.getProperty("git.build.version") : gitProps.getProperty("git.build.version") + "-" + gitProps.getProperty("git.branch"), gitProps.getProperty("git.commit.id.abbrev"), gitProps.getProperty("git.commit.time")};
        if (!LdapUtils.equals((Object[])this.device.getSoftwareVersions(), (Object[])versions)) {
            try {
                LOG.info("Update Software Version in LDAP to: {}", (Object)Arrays.toString(versions));
                this.device.setSoftwareVersions((String[])versions);
                ConfigurationChanges diffs = this.conf.merge(this.device, EnumSet.of(DicomConfiguration.Option.PRESERVE_VENDOR_DATA, DicomConfiguration.Option.PRESERVE_CERTIFICATE, DicomConfiguration.Option.CONFIGURATION_CHANGES));
                this.softwareConfigurationEvent.fire((Object)new SoftwareConfiguration(null, this.device.getDeviceName(), diffs));
            }
            catch (ConfigurationException e) {
                LOG.warn("Failed to update Software Version in LDAP:\n", (Throwable)e);
            }
        }
    }
}

