/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc;

import java.net.Socket;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;

public class HL7ConnectionEvent {
    private final Type type;
    private final HL7Application hl7Application;
    private final Connection connection;
    private final Socket socket;
    private final UnparsedHL7Message hl7Message;
    private final UnparsedHL7Message hl7ResponseMessage;
    private final Exception exception;

    private HL7ConnectionEvent(Type type, Connection connection, HL7Application hl7Application, Socket socket, UnparsedHL7Message hl7Message, UnparsedHL7Message hl7ResponseMessage, Exception exception) {
        this.type = type;
        this.hl7Application = hl7Application;
        this.connection = connection;
        this.socket = socket;
        this.hl7Message = hl7Message;
        this.hl7ResponseMessage = hl7ResponseMessage;
        this.exception = exception;
    }

    public static HL7ConnectionEvent onMessageReceived(Connection conn, Socket s, UnparsedHL7Message msg) {
        return new HL7ConnectionEvent(Type.MESSAGE_RECEIVED, conn, null, s, msg, null, null);
    }

    public static HL7ConnectionEvent onMessageProcessed(Connection conn, Socket s, UnparsedHL7Message msg, UnparsedHL7Message rsp, HL7Exception ex) {
        return new HL7ConnectionEvent(Type.MESSAGE_PROCESSED, conn, null, s, msg, rsp, (Exception)ex);
    }

    public static HL7ConnectionEvent onMessageSent(HL7Application hl7App, Socket s, UnparsedHL7Message msg, Exception ex) {
        return new HL7ConnectionEvent(Type.MESSAGE_SENT, null, hl7App, s, msg, null, ex);
    }

    public static HL7ConnectionEvent onMessageResponse(HL7Application hl7App, Socket s, UnparsedHL7Message msg, UnparsedHL7Message rsp, Exception ex) {
        return new HL7ConnectionEvent(Type.MESSAGE_RESPONSE, null, hl7App, s, msg, rsp, ex);
    }

    public Type getType() {
        return this.type;
    }

    public HL7Application getHL7Application() {
        return this.hl7Application;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public UnparsedHL7Message getHL7Message() {
        return this.hl7Message;
    }

    public UnparsedHL7Message getHL7ResponseMessage() {
        return this.hl7ResponseMessage;
    }

    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        return "HL7ConnectionEvent{type=" + this.type + ", hl7Application=" + this.hl7Application + ", connection=" + this.connection + ", socket=" + this.socket + ", hl7Message=" + this.hl7Message + ", hl7ResponseMessage=" + this.hl7ResponseMessage + ", exception=" + this.exception + "}";
    }

    public static enum Type {
        MESSAGE_RECEIVED,
        MESSAGE_PROCESSED,
        MESSAGE_SENT,
        MESSAGE_RESPONSE;

    }
}

