/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Instance_;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Location_;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.Metadata_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesQueryAttributes;
import org.dcm4chee.arc.entity.SeriesQueryAttributes_;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.StudyQueryAttributes;
import org.dcm4chee.arc.entity.StudyQueryAttributes_;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.impl.PatientQuery;
import org.dcm4chee.arc.query.impl.QuerySizeEJB;
import org.dcm4chee.arc.query.impl.SeriesQuery;
import org.dcm4chee.arc.query.impl.StudyQuery;
import org.dcm4chee.arc.query.util.QueryBuilder;

@Stateless
public class QueryServiceEJB {
    @PersistenceContext(unitName="dcm4chee-arc")
    EntityManager em;
    @Inject
    private CodeCache codeCache;
    @Inject
    QuerySizeEJB querySizeEJB;
    @Inject
    QueryService queryService;

    public Attributes getSeriesAttributes(Long seriesPk, QueryContext context) {
        String sopClassesInStudy;
        String modalitiesInStudy;
        int numberOfStudyRelatedSeries;
        Integer numberOfStudyRelatedInstances;
        Integer numberOfSeriesRelatedInstances;
        Tuple result;
        QueryRetrieveView qrView = context.getQueryParam().getQueryRetrieveView();
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createTupleQuery();
        Root series = q.from(Series.class);
        Join study = series.join(Series_.study);
        Join patient = study.join(Study_.patient);
        Join metadata = series.join(Series_.metadata, JoinType.LEFT);
        String viewID = context.getQueryParam().getViewID();
        CollectionJoin studyQueryAttributesPath = QueryBuilder.joinStudyQueryAttributes((CriteriaBuilder)cb, (From)study, (String)viewID);
        CollectionJoin seriesQueryAttributesPath = QueryBuilder.joinSeriesQueryAttributes((CriteriaBuilder)cb, (From)series, (String)viewID);
        Path seriesAttrBlob = series.join(Series_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        Path studyAttrBlob = study.join(Study_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        Path patAttrBlob = patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        try {
            result = (Tuple)this.em.createQuery(q.multiselect(new Selection[]{study.get(Study_.pk), patient.get(Patient_.numberOfStudies), patient.get(Patient_.createdTime), patient.get(Patient_.updatedTime), patient.get(Patient_.verificationTime), patient.get(Patient_.verificationStatus), patient.get(Patient_.failedVerifications), study.get(Study_.createdTime), study.get(Study_.updatedTime), study.get(Study_.modifiedTime), study.get(Study_.accessTime), study.get(Study_.expirationState), study.get(Study_.expirationDate), study.get(Study_.expirationExporterID), study.get(Study_.rejectionState), study.get(Study_.completeness), study.get(Study_.failedRetrieves), study.get(Study_.accessControlID), study.get(Study_.storageIDs), study.get(Study_.size), series.get(Series_.createdTime), series.get(Series_.updatedTime), series.get(Series_.modifiedTime), series.get(Series_.expirationState), series.get(Series_.expirationDate), series.get(Series_.expirationExporterID), series.get(Series_.rejectionState), series.get(Series_.completeness), series.get(Series_.failedRetrieves), series.get(Series_.sendingAET), series.get(Series_.receivingAET), series.get(Series_.sendingPresentationAddress), series.get(Series_.receivingPresentationAddress), series.get(Series_.sendingHL7Application), series.get(Series_.sendingHL7Facility), series.get(Series_.receivingHL7Application), series.get(Series_.receivingHL7Facility), series.get(Series_.metadataScheduledUpdateTime), series.get(Series_.metadataUpdateFailures), series.get(Series_.instancePurgeTime), series.get(Series_.instancePurgeState), series.get(Series_.storageVerificationTime), series.get(Series_.failuresOfLastStorageVerification), series.get(Series_.compressionTime), series.get(Series_.compressionFailures), series.get(Series_.transferSyntaxUID), metadata.get(Metadata_.createdTime), metadata.get(Metadata_.storageID), metadata.get(Metadata_.storagePath), metadata.get(Metadata_.digest), metadata.get(Metadata_.size), metadata.get(Metadata_.status), seriesQueryAttributesPath.get(SeriesQueryAttributes_.numberOfInstances), studyQueryAttributesPath.get(StudyQueryAttributes_.numberOfInstances), studyQueryAttributesPath.get(StudyQueryAttributes_.numberOfSeries), studyQueryAttributesPath.get(StudyQueryAttributes_.modalitiesInStudy), studyQueryAttributesPath.get(StudyQueryAttributes_.sopClassesInStudy), seriesAttrBlob, studyAttrBlob, patAttrBlob}).where((Expression)cb.equal((Expression)series.get(Series_.pk), (Object)seriesPk))).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        Long studySize = (Long)result.get((TupleElement)study.get(Study_.size));
        if (studySize < 0L) {
            studySize = this.querySizeEJB.calculateStudySize((Long)result.get((TupleElement)study.get(Study_.pk)), "Study.setStudySize");
        }
        if ((numberOfSeriesRelatedInstances = (Integer)result.get((TupleElement)seriesQueryAttributesPath.get(SeriesQueryAttributes_.numberOfInstances))) == null) {
            SeriesQueryAttributes seriesQueryAttributes = this.queryService.calculateSeriesQueryAttributes(seriesPk, (Series.InstancePurgeState)result.get((TupleElement)series.get(Series_.instancePurgeState)), (String)result.get((TupleElement)metadata.get(Metadata_.storageID)), (String)result.get((TupleElement)metadata.get(Metadata_.storagePath)), qrView);
            numberOfSeriesRelatedInstances = seriesQueryAttributes.getNumberOfInstances();
        }
        if ((numberOfStudyRelatedInstances = (Integer)result.get((TupleElement)studyQueryAttributesPath.get(StudyQueryAttributes_.numberOfInstances))) == null) {
            StudyQueryAttributes studyQueryAttributes = this.queryService.calculateStudyQueryAttributes((Long)result.get((TupleElement)study.get(Study_.pk)), qrView);
            numberOfStudyRelatedInstances = studyQueryAttributes.getNumberOfInstances();
            numberOfStudyRelatedSeries = studyQueryAttributes.getNumberOfSeries();
            modalitiesInStudy = studyQueryAttributes.getModalitiesInStudy();
            sopClassesInStudy = studyQueryAttributes.getSOPClassesInStudy();
        } else {
            numberOfStudyRelatedSeries = (Integer)result.get((TupleElement)studyQueryAttributesPath.get(StudyQueryAttributes_.numberOfSeries));
            modalitiesInStudy = (String)result.get((TupleElement)studyQueryAttributesPath.get(StudyQueryAttributes_.modalitiesInStudy));
            sopClassesInStudy = (String)result.get((TupleElement)studyQueryAttributesPath.get(StudyQueryAttributes_.sopClassesInStudy));
        }
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])result.get((TupleElement)patAttrBlob)), null);
        Attributes studyAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])result.get((TupleElement)studyAttrBlob)), null);
        Attributes seriesAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])result.get((TupleElement)seriesAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, studyAttrs, seriesAttrs});
        Attributes attrs = new Attributes(patAttrs.size() + studyAttrs.size() + seriesAttrs.size() + 20);
        attrs.addAll(patAttrs);
        attrs.addAll(studyAttrs, true);
        attrs.addAll(seriesAttrs, true);
        PatientQuery.addPatientQRAttrs((Path<Patient>)patient, context, result, attrs);
        StudyQuery.addStudyQRAddrs((Path<Study>)study, context, result, studySize, numberOfStudyRelatedInstances, numberOfStudyRelatedSeries, modalitiesInStudy, sopClassesInStudy, attrs);
        SeriesQuery.addSeriesQRAttrs((Root<Series>)series, (Join<Series, Metadata>)metadata, context, result, numberOfSeriesRelatedInstances, attrs);
        return attrs;
    }

    public void addLocationAttributes(Attributes attrs, Long instancePk) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createTupleQuery();
        Root location = q.from(Location.class);
        TypedQuery query = this.em.createQuery(q.multiselect(new Selection[]{location.get(Location_.storageID), location.get(Location_.storagePath), location.get(Location_.transferSyntaxUID), location.get(Location_.digest), location.get(Location_.size), location.get(Location_.status), location.get(Location_.multiReference)}).where(new Predicate[]{cb.equal((Expression)location.get(Location_.instance).get(Instance_.pk), (Object)instancePk), cb.equal((Expression)location.get(Location_.objectType), (Object)Location.ObjectType.DICOM_FILE)}));
        try (Stream resultStream = query.getResultStream();){
            Iterator iterate = resultStream.iterator();
            Attributes item = null;
            while (iterate.hasNext()) {
                Tuple results = (Tuple)iterate.next();
                if (item == null) {
                    item = attrs;
                } else {
                    item = new Attributes(5);
                    attrs.ensureSequence("DCM4CHEE Archive 5", 0x77770055, 1).add(item);
                }
                item.setString("DCM4CHEE Archive 5", 0x77770050, VR.LO, (String)results.get((TupleElement)location.get(Location_.storageID)));
                item.setString("DCM4CHEE Archive 5", 2004287569, VR.LO, StringUtils.split((String)((String)results.get((TupleElement)location.get(Location_.storagePath))), (char)'/'));
                item.setString("DCM4CHEE Archive 5", 2004287570, VR.UI, (String)results.get((TupleElement)location.get(Location_.transferSyntaxUID)));
                item.setInt("DCM4CHEE Archive 5", 2004287571, VR.UL, new int[]{((Long)results.get((TupleElement)location.get(Location_.size))).intValue()});
                if (results.get((TupleElement)location.get(Location_.digest)) != null) {
                    item.setString("DCM4CHEE Archive 5", 2004287572, VR.LO, (String)results.get((TupleElement)location.get(Location_.digest)));
                }
                if (results.get((TupleElement)location.get(Location_.status)) != Location.Status.OK) {
                    item.setString("DCM4CHEE Archive 5", 2004287574, VR.CS, ((Location.Status)results.get((TupleElement)location.get(Location_.status))).name());
                }
                if (results.get((TupleElement)location.get(Location_.multiReference)) == null) continue;
                item.setInt("DCM4CHEE Archive 5", 0x77770057, VR.IS, new int[]{(Integer)results.get((TupleElement)location.get(Location_.multiReference))});
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Attributes queryStudyExportTaskInfo(String studyIUID, QueryRetrieveView qrView) {
        String modalitiesInStudy;
        Tuple result;
        String viewID = qrView.getViewID();
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createTupleQuery();
        Root study = q.from(Study.class);
        CollectionJoin studyQueryAttributesPath = QueryBuilder.joinStudyQueryAttributes((CriteriaBuilder)cb, (From)study, (String)viewID);
        try {
            result = (Tuple)this.em.createQuery(q.multiselect(new Selection[]{study.get(Study_.pk), studyQueryAttributesPath.get(StudyQueryAttributes_.numberOfInstances), studyQueryAttributesPath.get(StudyQueryAttributes_.modalitiesInStudy)}).where((Expression)cb.equal((Expression)study.get(Study_.studyInstanceUID), (Object)studyIUID))).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        Integer numberOfStudyRelatedInstances = (Integer)result.get((TupleElement)studyQueryAttributesPath.get(StudyQueryAttributes_.numberOfInstances));
        if (numberOfStudyRelatedInstances == null) {
            StudyQueryAttributes studyQueryAttributes = this.queryService.calculateStudyQueryAttributes((Long)result.get((TupleElement)study.get(Study_.pk)), qrView);
            numberOfStudyRelatedInstances = studyQueryAttributes.getNumberOfInstances();
            modalitiesInStudy = studyQueryAttributes.getModalitiesInStudy();
        } else {
            modalitiesInStudy = (String)result.get((TupleElement)studyQueryAttributesPath.get(StudyQueryAttributes_.modalitiesInStudy));
        }
        Attributes attrs = new Attributes(2);
        attrs.setInt(2101768, VR.IS, new int[]{numberOfStudyRelatedInstances});
        attrs.setString(524385, VR.CS, modalitiesInStudy);
        return attrs;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Attributes querySeriesExportTaskInfo(String studyIUID, String seriesIUID, QueryRetrieveView qrView) {
        Tuple result;
        String viewID = qrView.getViewID();
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createTupleQuery();
        Root series = q.from(Series.class);
        Join metadata = series.join(Series_.metadata, JoinType.LEFT);
        Join study = series.join(Series_.study);
        CollectionJoin seriesQueryAttributesPath = QueryBuilder.joinSeriesQueryAttributes((CriteriaBuilder)cb, (From)series, (String)viewID);
        try {
            result = (Tuple)this.em.createQuery(q.multiselect(new Selection[]{series.get(Series_.pk), series.get(Series_.modality), series.get(Series_.instancePurgeState), metadata.get(Metadata_.storageID), metadata.get(Metadata_.storagePath), seriesQueryAttributesPath.get(SeriesQueryAttributes_.numberOfInstances)}).where(new Predicate[]{cb.equal((Expression)study.get(Study_.studyInstanceUID), (Object)studyIUID), cb.equal((Expression)series.get(Series_.seriesInstanceUID), (Object)seriesIUID)})).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        Integer numberOfSeriesRelatedInstances = (Integer)result.get((TupleElement)seriesQueryAttributesPath.get(SeriesQueryAttributes_.numberOfInstances));
        if (numberOfSeriesRelatedInstances == null) {
            Long seriesPk = (Long)result.get((TupleElement)series.get(Series_.pk));
            SeriesQueryAttributes seriesQueryAttributes = this.queryService.calculateSeriesQueryAttributes(seriesPk, (Series.InstancePurgeState)result.get((TupleElement)series.get(Series_.instancePurgeState)), (String)result.get((TupleElement)metadata.get(Metadata_.storageID)), (String)result.get((TupleElement)metadata.get(Metadata_.storagePath)), qrView);
            numberOfSeriesRelatedInstances = seriesQueryAttributes.getNumberOfInstances();
        }
        Attributes attrs = new Attributes(2);
        attrs.setInt(2101768, VR.IS, new int[]{numberOfSeriesRelatedInstances});
        attrs.setString(524385, VR.CS, (String)result.get((TupleElement)series.get(Series_.modality)));
        return attrs;
    }

    public Attributes getStudyAttributesWithSOPInstanceRefs(SOPInstanceRefsType type, String studyIUID, String seriesIUID, String objectUID, QueryRetrieveView qrView, Collection<Attributes> seriesAttrs, String[] retrieveAETs, String retrieveLocationUID) {
        Attributes attrs = this.getStudyAttributes(studyIUID);
        if (attrs == null) {
            return null;
        }
        Attributes sopInstanceRefs = this.getSOPInstanceRefs(type, studyIUID, objectUID, qrView, seriesAttrs, retrieveAETs, retrieveLocationUID, null, seriesIUID);
        if (sopInstanceRefs != null) {
            attrs.newSequence(4236149, 1).add(sopInstanceRefs);
        }
        return attrs;
    }

    public Attributes getSOPInstanceRefs(SOPInstanceRefsType type, String studyIUID, String objectUID, QueryRetrieveView qrView, Collection<Attributes> seriesAttrs, String[] retrieveAETs, String retrieveLocationUID, Availability availability, String ... seriesUID) {
        Attributes refStudy = new Attributes(2);
        Sequence refSeriesSeq = refStudy.newSequence(528661, 10);
        refStudy.setString(0x20000D, VR.UI, studyIUID);
        return this.getSOPInstanceRefs(refStudy, type, studyIUID, objectUID, qrView, seriesAttrs, retrieveAETs, retrieveLocationUID, availability, seriesUID);
    }

    public Attributes getSOPInstanceRefs(Attributes refStudy, SOPInstanceRefsType type, String studyIUID, String objectUID, QueryRetrieveView qrView, Collection<Attributes> seriesAttrs, String[] retrieveAETs, String retrieveLocationUID, Availability availability, String ... seriesUID) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createTupleQuery();
        Root instance = q.from(Instance.class);
        Join series = instance.join(Instance_.series);
        Join study = series.join(Series_.study);
        Path cuidPath = instance.get(Instance_.sopClassUID);
        Path iuidPath = instance.get(Instance_.sopInstanceUID);
        List tuples = this.em.createQuery(this.restrict(new QueryBuilder(cb), (CriteriaQuery<Tuple>)q, (Join<Series, Study>)study, (Join<Instance, Series>)series, (Root<Instance>)instance, studyIUID, objectUID, qrView, seriesUID).multiselect(new Selection[]{study.get(Study_.pk), series.get(Series_.pk), series.get(Series_.seriesInstanceUID), iuidPath, cuidPath, instance.get(Instance_.retrieveAETs), instance.get(Instance_.availability)})).getResultList();
        Sequence refSeriesSeq = refStudy.getSequence(528661);
        if (tuples.isEmpty() && refSeriesSeq.isEmpty() && type != SOPInstanceRefsType.KOS_XDSI) {
            return null;
        }
        if (type == SOPInstanceRefsType.STGCMT) {
            return this.getStgCmtRqstAttr(refSeriesSeq, tuples, (Path<String>)cuidPath, (Path<String>)iuidPath);
        }
        refStudy.setString(0x20000D, VR.UI, studyIUID);
        HashMap<Long, Sequence> seriesMap = new HashMap<Long, Sequence>();
        for (Tuple tuple : tuples) {
            Long seriesPk = (Long)tuple.get((TupleElement)series.get(Series_.pk));
            Sequence refSOPSeq = (Sequence)seriesMap.get(seriesPk);
            if (refSOPSeq == null) {
                Attributes refSeries = new Attributes(4);
                if (type == SOPInstanceRefsType.KOS_XDSI) {
                    if (retrieveAETs != null) {
                        refSeries.setString(524372, VR.AE, retrieveAETs);
                    }
                    if (retrieveLocationUID != null) {
                        refSeries.setString(4251665, VR.UI, retrieveLocationUID);
                    }
                }
                refSOPSeq = refSeries.newSequence(528793, 10);
                refSeries.setString(0x20000E, VR.UI, (String)tuple.get((TupleElement)series.get(Series_.seriesInstanceUID)));
                seriesMap.put(seriesPk, refSOPSeq);
                refSeriesSeq.add(refSeries);
                if (seriesAttrs != null) {
                    seriesAttrs.add(this.getSeriesAttributes(seriesPk));
                }
            }
            Attributes refSOP = new Attributes(4);
            if (type == SOPInstanceRefsType.IAN || type == SOPInstanceRefsType.UPS) {
                refSOP.setString(524372, VR.AE, (String[])StringUtils.maskNull((Object)retrieveAETs, (Object)StringUtils.split((String)((String)tuple.get((TupleElement)instance.get(Instance_.retrieveAETs))), (char)'\\')));
                refSOP.setString(524374, VR.CS, ((Availability)StringUtils.maskNull((Object)availability, (Object)((Availability)tuple.get((TupleElement)instance.get(Instance_.availability))))).toString());
                if (retrieveLocationUID != null) {
                    refSOP.setString(4251665, VR.UI, retrieveLocationUID);
                }
            }
            QueryServiceEJB.setSOPRef(refSOP, tuple, (Path<String>)cuidPath, (Path<String>)iuidPath);
            refSOPSeq.add(refSOP);
        }
        if (type == SOPInstanceRefsType.IAN) {
            refStudy.setNull(528657, VR.SQ);
        }
        return refStudy;
    }

    private CriteriaQuery<Tuple> restrict(QueryBuilder builder, CriteriaQuery<Tuple> q, Join<Series, Study> study, Join<Instance, Series> series, Root<Instance> instance, String studyIUID, String objectUID, QueryRetrieveView qrView, String ... seriesUID) {
        return q.where(builder.sopInstanceRefs(q, study, series, instance, studyIUID, objectUID, qrView, this.codeCache.findOrCreateEntities(qrView.getShowInstancesRejectedByCodes()), this.codeCache.findOrCreateEntities(qrView.getHideRejectionNotesWithCodes()), seriesUID).toArray(new Predicate[0]));
    }

    private Attributes getStgCmtRqstAttr(Sequence refSeriesSeq, List<Tuple> tuples, Path<String> cuidPath, Path<String> iuidPath) {
        Attributes refStgcmt = new Attributes(2);
        refStgcmt.setString(528789, VR.UI, UIDUtils.createUID());
        Sequence refSOPSeq = refStgcmt.newSequence(528793, 10);
        Stream.concat(refSeriesSeq.stream().flatMap(refSeries -> refSeries.getSequence(528793).stream()).map(attrs -> QueryServiceEJB.setSOPRef(new Attributes(2), attrs.getString(528720), attrs.getString(528725))), tuples.stream().map(tuple -> QueryServiceEJB.setSOPRef(new Attributes(2), tuple, cuidPath, iuidPath))).forEach(arg_0 -> ((Sequence)refSOPSeq).add(arg_0));
        return refStgcmt;
    }

    private static Attributes setSOPRef(Attributes attrs, Tuple tuple, Path<String> cuidPath, Path<String> iuidPath) {
        return QueryServiceEJB.setSOPRef(attrs, (String)tuple.get(cuidPath), (String)tuple.get(iuidPath));
    }

    private static Attributes setSOPRef(Attributes attrs, String cuid, String iuid) {
        attrs.setString(528720, VR.UI, cuid);
        attrs.setString(528725, VR.UI, iuid);
        return attrs;
    }

    public Attributes getStudyAttributes(String studyInstanceUID) {
        Tuple result;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createTupleQuery();
        Root study = q.from(Study.class);
        Join patient = study.join(Study_.patient);
        Path studyAttrBlob = study.join(Study_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        Path patAttrBlob = patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        try {
            result = (Tuple)this.em.createQuery(q.multiselect(new Selection[]{studyAttrBlob, patAttrBlob}).where((Expression)cb.equal((Expression)study.get(Study_.studyInstanceUID), (Object)studyInstanceUID))).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])result.get((TupleElement)patAttrBlob)), null);
        Attributes studyAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])result.get((TupleElement)studyAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, studyAttrs});
        Attributes attrs = new Attributes(patAttrs.size() + studyAttrs.size());
        attrs.addAll(patAttrs);
        attrs.addAll(studyAttrs, true);
        return attrs;
    }

    private Attributes getSeriesAttributes(Long seriesPk) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(byte[].class);
        Root series = q.from(Series.class);
        Path seriesAttrBlob = series.join(Series_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        return AttributesBlob.decodeAttributes((byte[])((byte[])this.em.createQuery(q.select((Selection)seriesAttrBlob).where((Expression)cb.equal((Expression)series.get(Series_.pk), (Object)seriesPk))).getSingleResult()), null);
    }

    public List<Tuple> unknownSizeStudies(Date dt, int fetchSize) {
        return this.em.createNamedQuery("Study.findPkStudyUIDPIDByUpdateTimeAndUnknownSize", Tuple.class).setParameter(1, (Object)dt).setMaxResults(fetchSize).getResultList();
    }

    public static enum SOPInstanceRefsType {
        IAN,
        KOS_IOCM,
        KOS_XDSI,
        STGCMT,
        UPS;

    }
}

