/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.impl.AbstractQuery;

class PatientQuery
extends AbstractQuery {
    private Root<Patient> patient;
    private Path<byte[]> patientAttrBlob;
    private static Path<byte[]> dominantPatientAttrBlob;

    PatientQuery(QueryContext context, EntityManager em) {
        super(context, em);
    }

    @Override
    protected CriteriaQuery<Tuple> multiselect() {
        CriteriaQuery q = this.cb.createTupleQuery();
        this.patient = q.from(Patient.class);
        return this.order(this.restrict(q, this.patient)).multiselect(this.selections());
    }

    private <T> Selection<T>[] selections() {
        boolean merged = this.context.getQueryParam().isMerged();
        Selection[] selections = new Selection[merged ? 9 : 8];
        selections[0] = this.patient.get(Patient_.pk);
        selections[1] = this.patient.get(Patient_.numberOfStudies);
        selections[2] = this.patient.get(Patient_.createdTime);
        selections[3] = this.patient.get(Patient_.updatedTime);
        selections[4] = this.patient.get(Patient_.verificationTime);
        selections[5] = this.patient.get(Patient_.verificationStatus);
        selections[6] = this.patient.get(Patient_.failedVerifications);
        this.patientAttrBlob = this.patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selections[7] = this.patientAttrBlob;
        if (merged) {
            dominantPatientAttrBlob = this.patient.join(Patient_.mergedWith).join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
            selections[8] = dominantPatientAttrBlob;
        }
        return selections;
    }

    @Override
    protected CriteriaQuery<Long> count() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root patient = q.from(Patient.class);
        return this.restrict(q, (Root<Patient>)patient).select((Selection)this.cb.count((Expression)patient));
    }

    @Override
    protected Attributes toAttributes(Tuple results) {
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.patientAttrBlob)), null);
        PatientQuery.addPatientQRAttrs(this.patient, this.context, results, patAttrs);
        return patAttrs;
    }

    private CriteriaQuery<Tuple> order(CriteriaQuery<Tuple> q) {
        if (this.context.getOrderByTags() != null) {
            q.orderBy(this.builder.orderPatients(this.patient, this.context.getOrderByTags()));
        }
        return q;
    }

    private <T> CriteriaQuery<T> restrict(CriteriaQuery<T> q, Root<Patient> patient) {
        List predicates = this.builder.patientPredicates(q, patient, this.context.getPatientIDs(), this.context.getIssuerOfPatientID(), this.context.getQueryKeys(), this.context.getQueryParam());
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return q;
    }

    static void addPatientQRAttrs(Path<Patient> patient, QueryContext context, Tuple results, Attributes attrs) {
        int failures;
        Patient.VerificationStatus verificationStatus;
        attrs.setInt(0x201200, VR.IS, new int[]{(Integer)results.get((TupleElement)patient.get(Patient_.numberOfStudies))});
        if (!context.isReturnPrivate()) {
            return;
        }
        PatientQuery.setDTwTZ(attrs, 0x77770010, (Date)results.get((TupleElement)patient.get(Patient_.createdTime)));
        PatientQuery.setDTwTZ(attrs, 0x77770011, (Date)results.get((TupleElement)patient.get(Patient_.updatedTime)));
        Date verificationTime = (Date)results.get((TupleElement)patient.get(Patient_.verificationTime));
        if (verificationTime != null) {
            PatientQuery.setDTwTZ(attrs, 2004287506, verificationTime);
        }
        if ((verificationStatus = (Patient.VerificationStatus)results.get((TupleElement)patient.get(Patient_.verificationStatus))) != Patient.VerificationStatus.UNVERIFIED || verificationTime != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287507, VR.CS, verificationStatus.name());
        }
        if ((failures = ((Integer)results.get((TupleElement)patient.get(Patient_.failedVerifications))).intValue()) > 0) {
            attrs.setInt("DCM4CHEE Archive 5", 2004287508, VR.US, new int[]{failures});
        }
        if (context.getQueryParam().isMerged()) {
            attrs.newSequence("DCM4CHEE Archive 5", 2004287509, 1).add(AttributesBlob.decodeAttributes((byte[])((byte[])results.get(dominantPatientAttrBlob)), null));
        }
    }

    @Override
    public boolean isOptionalKeysNotSupported() {
        return false;
    }
}

