/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qmgt.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="queue/{queueName}")
public class QueueManagerRS {
    private static final Logger LOG = LoggerFactory.getLogger(QueueManagerRS.class);
    @Inject
    private TaskManager taskManager;
    @Inject
    private Device device;
    @Context
    private HttpServletRequest request;
    @PathParam(value="queueName")
    private String queueName;
    @QueryParam(value="taskID")
    private Long taskID;
    @QueryParam(value="dicomDeviceName")
    private String deviceName;
    @QueryParam(value="newDeviceName")
    private List<String> newDeviceName;
    @QueryParam(value="status")
    @Pattern(regexp="SCHEDULED|IN PROCESS|COMPLETED|WARNING|FAILED|CANCELED")
    private @Pattern(regexp="SCHEDULED|IN PROCESS|COMPLETED|WARNING|FAILED|CANCELED") String status;
    @QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;
    @QueryParam(value="createdTime")
    private String createdTime;
    @QueryParam(value="updatedTime")
    private String updatedTime;
    @QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="localAET")
    private String localAET;
    @QueryParam(value="remoteAET")
    private String remoteAET;
    @QueryParam(value="orderby")
    @DefaultValue(value="-updatedTime")
    @Pattern(regexp="(-?)createdTime|(-?)updatedTime|(-?)scheduledTime")
    private @Pattern(regexp="(-?)createdTime|(-?)updatedTime|(-?)scheduledTime") String orderby;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response search() {
        this.logRequest();
        try {
            return Response.ok((Object)this.taskManager.writeAsJSON(this.taskQueryParam(this.deviceName), this.parseInt(this.offset), this.parseInt(this.limit))).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/count")
    @Produces(value={"application/json"})
    public Response countTasks() {
        this.logRequest();
        return this.taskManager.countTasks(this.taskQueryParam(this.deviceName));
    }

    @POST
    @Path(value="{taskID}/cancel")
    public Response cancelTask(@PathParam(value="taskID") long taskID) {
        this.logRequest();
        return this.taskManager.cancelTask(this.taskQueryParam(taskID), this.request);
    }

    @POST
    @Path(value="/cancel")
    @Produces(value={"application/json"})
    public Response cancelTasks() {
        this.logRequest();
        return this.taskManager.cancelTasks(this.taskQueryParam(this.deviceName), this.request);
    }

    @POST
    @Path(value="{taskID}/reschedule")
    public Response rescheduleTask(@PathParam(value="taskID") long taskID) {
        this.logRequest();
        return this.taskManager.rescheduleTask(this.taskQueryParam(taskID), this.scheduledTime(), this.newDeviceName, this.request);
    }

    @POST
    @Path(value="/reschedule")
    @Produces(value={"application/json"})
    public Response rescheduleTasks() {
        this.logRequest();
        return this.taskManager.rescheduleTasks(this.taskQueryParam(this.deviceName), this.scheduledTime(), this.newDeviceName, this.request);
    }

    @DELETE
    @Path(value="{taskID}")
    public Response deleteTask(@PathParam(value="taskID") long taskID) {
        this.logRequest();
        return this.taskManager.deleteTask(this.taskQueryParam(taskID), this.request);
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteTasks() {
        this.logRequest();
        return this.taskManager.deleteTasks(this.taskQueryParam(this.deviceName), this.request);
    }

    private int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private Date scheduledTime() {
        return this.scheduledTime != null ? ParseDateTime.valueOf((String)this.scheduledTime) : null;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private TaskQueryParam taskQueryParam(String deviceName) {
        TaskQueryParam taskQueryParam = new TaskQueryParam();
        taskQueryParam.setTaskPK(this.taskID);
        taskQueryParam.setQueueNames(Collections.singletonList(this.queueName));
        taskQueryParam.setDeviceName(deviceName);
        taskQueryParam.setStatus(this.status);
        taskQueryParam.setBatchID(this.batchID);
        taskQueryParam.setLocalAET(this.localAET);
        taskQueryParam.setRemoteAET(this.remoteAET);
        taskQueryParam.setCreatedTime(this.createdTime);
        taskQueryParam.setUpdatedTime(this.updatedTime);
        taskQueryParam.setOrderBy(this.orderby);
        return taskQueryParam;
    }

    private TaskQueryParam taskQueryParam(Long taskID) {
        TaskQueryParam taskQueryParam = new TaskQueryParam();
        taskQueryParam.setTaskPK(taskID);
        taskQueryParam.setQueueNames(Collections.singletonList(this.queueName));
        return taskQueryParam;
    }
}

