/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qmgt.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="queue")
@RequestScoped
public class QueryQueues {
    private static final Logger LOG = LoggerFactory.getLogger(QueryQueues.class);
    @Inject
    private Device device;
    @Context
    private HttpServletRequest request;
    @QueryParam(value="includeExporters")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String includeExporters;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public StreamingOutput query() {
        this.logRequest();
        try {
            return out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                this.writeQueues(gen);
                gen.writeEnd();
                gen.flush();
            };
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void writeQueuesWithExporters(JsonGenerator gen) {
        this.associatedQueuesExporters().forEach((queueName, queueDescExporterIDs) -> {
            JsonWriter writer = new JsonWriter(gen);
            gen.writeStartObject();
            writer.writeNotNullOrDef("name", queueName, null);
            writer.writeNotNullOrDef("description", (Object)queueDescExporterIDs.getQueue().getDescription(), null);
            writer.writeNotEmpty("exporterIDs", (Object[])queueDescExporterIDs.getExporterIDs().toArray(new String[0]), (Object[])new String[0]);
            gen.writeEnd();
        });
    }

    private void writeQueues(JsonGenerator gen) {
        if (Boolean.parseBoolean(this.includeExporters)) {
            this.writeQueuesWithExporters(gen);
            return;
        }
        for (QueueDescriptor queueDesc : this.sortedQueueDescriptors()) {
            JsonWriter writer = new JsonWriter(gen);
            gen.writeStartObject();
            writer.writeNotNullOrDef("name", (Object)queueDesc.getQueueName(), null);
            writer.writeNotNullOrDef("description", (Object)queueDesc.getDescription(), null);
            gen.writeEnd();
        }
    }

    private QueueDescriptor[] sortedQueueDescriptors() {
        return (QueueDescriptor[])((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueueDescriptors().stream().sorted(Comparator.comparing(QueueDescriptor::getQueueName)).toArray(QueueDescriptor[]::new);
    }

    private Map<String, QueueDescExporterIDs> associatedQueuesExporters() {
        Map queueNameExporterIDs = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getExporterDescriptors().stream().collect(Collectors.groupingBy(ExporterDescriptor::getQueueName, Collectors.mapping(ExporterDescriptor::getExporterID, Collectors.toList())));
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueueDescriptors().stream().filter(qd -> queueNameExporterIDs.containsKey(qd.getQueueName())).collect(Collectors.toMap(QueueDescriptor::getQueueName, qd -> new QueueDescExporterIDs((QueueDescriptor)qd, (List)queueNameExporterIDs.get(qd.getQueueName())), (v1, v2) -> v1, TreeMap::new));
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static class QueueDescExporterIDs {
        private QueueDescriptor queue;
        private List<String> exporterIDs;

        public QueueDescExporterIDs(QueueDescriptor queue, List<String> exporterIDs) {
            this.queue = queue;
            this.exporterIDs = exporterIDs;
        }

        public QueueDescriptor getQueue() {
            return this.queue;
        }

        public List<String> getExporterIDs() {
            return this.exporterIDs;
        }
    }
}

