/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qido;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeSet;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.QIDO;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.rs.util.MediaTypeUtils;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=QidoRS.class)
public class QidoRS {
    private static final Logger LOG = LoggerFactory.getLogger(QidoRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private QueryService service;
    @Inject
    private RetrieveService retrieveService;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request req;
    @Context
    private HttpHeaders headers;
    @Inject
    private Device device;
    @PathParam(value="AETitle")
    private String aet;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @javax.ws.rs.QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @javax.ws.rs.QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;
    @javax.ws.rs.QueryParam(value="onlyWithStudies")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String onlyWithStudies;
    @javax.ws.rs.QueryParam(value="incomplete")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String incomplete;
    @javax.ws.rs.QueryParam(value="retrievefailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String retrievefailed;
    @javax.ws.rs.QueryParam(value="storageVerificationFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageVerificationFailed;
    @javax.ws.rs.QueryParam(value="metadataUpdateFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String metadataUpdateFailed;
    @javax.ws.rs.QueryParam(value="compressionfailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String compressionfailed;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET")
    private String externalRetrieveAET;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET!")
    private String externalRetrieveAETNot;
    @javax.ws.rs.QueryParam(value="patientVerificationStatus")
    @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED")
    private @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED") String patientVerificationStatus;
    @javax.ws.rs.QueryParam(value="merged")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String merged;
    @javax.ws.rs.QueryParam(value="accept")
    private List<String> accept;
    @javax.ws.rs.QueryParam(value="includedefaults")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String includedefaults;
    @javax.ws.rs.QueryParam(value="ExpirationDate")
    private String expirationDate;
    @javax.ws.rs.QueryParam(value="storageID")
    private String storageID;
    @javax.ws.rs.QueryParam(value="storageClustered")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageClustered;
    @javax.ws.rs.QueryParam(value="storageExported")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageExported;
    @javax.ws.rs.QueryParam(value="allOfModalitiesInStudy")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String allOfModalitiesInStudy;
    @javax.ws.rs.QueryParam(value="StudySizeInKB")
    @Pattern(regexp="\\d{1,9}(-\\d{0,9})?|-\\d{1,9}")
    private @Pattern(regexp="\\d{1,9}(-\\d{0,9})?|-\\d{1,9}") String studySizeInKB;
    @javax.ws.rs.QueryParam(value="ExpirationState")
    @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT")
    private @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT") String expirationState;
    @javax.ws.rs.QueryParam(value="template")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String template;
    @javax.ws.rs.QueryParam(value="requested")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String requested;
    @javax.ws.rs.QueryParam(value="allmodified")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String allmodifiedAsString;
    private boolean allmodified;
    private char csvDelimiter = (char)44;
    private QueryAttributes queryAttrs;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        this.queryAttrs = new QueryAttributes(this.uriInfo, this.attributeSetMap());
        this.allmodified = Boolean.parseBoolean(this.allmodifiedAsString);
    }

    @GET
    @NoCache
    @Path(value="/patients")
    public Response searchForPatients() {
        return this.search("SearchForPatients", Model.PATIENT, null, null, QIDO.PATIENT, false, WebApplication.ServiceClass.QIDO_RS);
    }

    @GET
    @NoCache
    @Path(value="/studies")
    public Response searchForStudies() {
        return this.search("SearchForStudies", Model.STUDY, null, null, QIDO.STUDY, false, WebApplication.ServiceClass.QIDO_RS);
    }

    @GET
    @NoCache
    @Path(value="/series")
    public Response searchForSeries() {
        return this.search("SearchForSeries", Model.SERIES, null, null, QIDO.STUDY_SERIES, false, WebApplication.ServiceClass.QIDO_RS);
    }

    @GET
    @Path(value="/studies/{StudyInstanceUID}/series")
    public Response searchForSeriesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        return this.search("SearchForStudySeries", Model.SERIES, studyInstanceUID, null, QIDO.SERIES, true, WebApplication.ServiceClass.QIDO_RS);
    }

    @GET
    @NoCache
    @Path(value="/instances")
    public Response searchForInstances() {
        return this.search("SearchForInstances", Model.INSTANCE, null, null, QIDO.STUDY_SERIES_INSTANCE, false, WebApplication.ServiceClass.QIDO_RS);
    }

    @GET
    @Path(value="/studies/{StudyInstanceUID}/instances")
    public Response searchForInstancesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        return this.search("SearchForStudyInstances", Model.INSTANCE, studyInstanceUID, null, QIDO.SERIES_INSTANCE, true, WebApplication.ServiceClass.QIDO_RS);
    }

    @GET
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances")
    public Response searchForInstancesOfSeries(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID) {
        return this.search("SearchForStudySeriesInstances", Model.INSTANCE, studyInstanceUID, seriesInstanceUID, QIDO.INSTANCE, true, WebApplication.ServiceClass.QIDO_RS);
    }

    @GET
    @NoCache
    @Path(value="/mwlitems")
    public Response searchForSPS() {
        return this.search("SearchForSPS", Model.MWL, null, null, QIDO.MWL, false, WebApplication.ServiceClass.MWL_RS);
    }

    @GET
    @NoCache
    @Path(value="/mpps")
    public Response searchForMPPS() {
        return this.search("SearchForMPPS", Model.MPPS, null, null, QIDO.MPPS, false, WebApplication.ServiceClass.MPPS_RS);
    }

    @GET
    @NoCache
    @Path(value="/workitems")
    public Response searchForUPS() {
        return this.search("SearchForUPS", Model.UPS, null, null, QIDO.UPS, false, WebApplication.ServiceClass.UPS_RS);
    }

    @GET
    @NoCache
    @Path(value="/patients/count")
    @Produces(value={"application/json"})
    public Response countPatients() {
        return this.count("CountPatients", Model.PATIENT, null, null, WebApplication.ServiceClass.QIDO_COUNT);
    }

    @GET
    @NoCache
    @Path(value="/studies/count")
    @Produces(value={"application/json"})
    public Response countStudies() {
        return this.count("CountStudies", Model.STUDY, null, null, WebApplication.ServiceClass.QIDO_COUNT);
    }

    @GET
    @NoCache
    @Path(value="/series/count")
    @Produces(value={"application/json"})
    public Response countSeries() {
        return this.count("CountSeries", Model.SERIES, null, null, WebApplication.ServiceClass.QIDO_COUNT);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/series/count")
    @Produces(value={"application/json"})
    public Response countSeriesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        return this.count("CountStudySeries", Model.SERIES, studyInstanceUID, null, WebApplication.ServiceClass.QIDO_COUNT);
    }

    @GET
    @NoCache
    @Path(value="/instances/count")
    @Produces(value={"application/json"})
    public Response countInstances() {
        return this.count("CountInstances", Model.INSTANCE, null, null, WebApplication.ServiceClass.QIDO_COUNT);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/instances/count")
    @Produces(value={"application/json"})
    public Response countInstancesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        return this.count("CountStudyInstances", Model.INSTANCE, studyInstanceUID, null, WebApplication.ServiceClass.QIDO_COUNT);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/count")
    @Produces(value={"application/json"})
    public Response countInstancesOfSeries(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID) {
        return this.count("CountStudySeriesInstances", Model.INSTANCE, studyInstanceUID, seriesInstanceUID, WebApplication.ServiceClass.QIDO_COUNT);
    }

    @GET
    @NoCache
    @Path(value="/mwlitems/count")
    @Produces(value={"application/json"})
    public Response countSPS() {
        return this.count("CountSPS", Model.MWL, null, null, WebApplication.ServiceClass.MWL_RS);
    }

    @GET
    @NoCache
    @Path(value="/mpps/count")
    @Produces(value={"application/json"})
    public Response countMPPS() {
        return this.count("CountMPPS", Model.MPPS, null, null, WebApplication.ServiceClass.MPPS_RS);
    }

    @GET
    @NoCache
    @Path(value="/workitems/count")
    @Produces(value={"application/json"})
    public Response countUPS() {
        return this.count("CountUPS", Model.UPS, null, null, WebApplication.ServiceClass.UPS_RS);
    }

    @GET
    @NoCache
    @Path(value="/studies/size")
    @Produces(value={"application/json"})
    public Response sizeOfStudies() {
        Response response;
        block19: {
            ArchiveAEExtension arcAE = this.getArchiveAE();
            if (arcAE == null) {
                return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
            }
            this.validateAcceptedUserRoles(arcAE);
            ApplicationEntity ae = arcAE.getApplicationEntity();
            if (this.aet.equals(ae.getAETitle())) {
                this.validateWebAppServiceClass(WebApplication.ServiceClass.DCM4CHEE_ARC_AET);
            }
            QueryContext ctx = this.newQueryContext("SizeOfStudies", this.queryAttrs, null, null, Model.STUDY, ae);
            if (ctx.getQueryParam().noMatches()) {
                return Response.ok((Object)"{\"size\":0}").build();
            }
            ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            Query query = this.service.createStudyQuery(ctx);
            try {
                try (Stream studyPkStream = query.withUnknownSize(arcdev.getQueryFetchSize());){
                    Iterator studyPks = studyPkStream.iterator();
                    while (studyPks.hasNext()) {
                        ctx.getQueryService().calculateStudySize((Long)studyPks.next());
                    }
                }
                response = Response.ok((Object)("{\"size\":" + query.fetchSize() + "}")).build();
                if (query == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (query != null) {
                        try {
                            query.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            query.close();
        }
        return response;
    }

    private Response count(String method, Model model, String studyInstanceUID, String seriesInstanceUID, WebApplication.ServiceClass serviceClass) {
        Response response;
        block11: {
            ArchiveAEExtension arcAE = this.getArchiveAE();
            if (arcAE == null) {
                return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
            }
            this.validateAcceptedUserRoles(arcAE);
            ApplicationEntity ae = arcAE.getApplicationEntity();
            if (this.aet.equals(ae.getAETitle())) {
                this.validateWebAppServiceClass(serviceClass);
            }
            QueryContext ctx = this.newQueryContext(method, this.queryAttrs, studyInstanceUID, seriesInstanceUID, model, ae);
            if (ctx.getQueryParam().noMatches()) {
                return Response.ok((Object)"{\"count\":0}").build();
            }
            Query query = model.createQuery(this.service, ctx);
            try {
                response = Response.ok((Object)("{\"count\":" + query.fetchCount() + "}")).build();
                if (query == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (query != null) {
                        try {
                            query.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            query.close();
        }
        return response;
    }

    private Map<String, AttributeSet> attributeSetMap() {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getAttributeSet(AttributeSet.Type.QIDO_RS);
    }

    private Response.ResponseBuilder evaluatePreConditions(Date lastModified) {
        return this.req.evaluatePreconditions(new Date(lastModified.getTime() / 1000L * 1000L), new EntityTag(String.valueOf(lastModified.hashCode())));
    }

    private boolean ignorePatientUpdates(Attributes returnKeys) {
        int[] patientTags;
        for (int tag : patientTags = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getAttributeFilter(Entity.Patient).getSelection()) {
            if (tag == 524293 || !returnKeys.contains(tag)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response search(String method, Model model, String studyInstanceUID, String seriesInstanceUID, QIDO qido, boolean etag, WebApplication.ServiceClass serviceClass) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass(serviceClass);
        }
        Output output = this.selectMediaType();
        try {
            QueryContext ctx = this.newQueryContext(method, this.queryAttrs, studyInstanceUID, seriesInstanceUID, model, ae);
            ctx.setReturnKeys(this.queryAttrs.isIncludeAll() ? null : this.queryAttrs.getReturnKeys(this.includeDefaults() ? qido.includetags : qido.uids));
            Date lastModified = null;
            if (etag && arcAE.qidoETag()) {
                LOG.debug("Query Last Modified date of {}", (Object)model);
                lastModified = this.service.getLastModified(!this.queryAttrs.isIncludeAll() && this.ignorePatientUpdates(ctx.getReturnKeys()), studyInstanceUID, seriesInstanceUID);
                if (lastModified == null) {
                    LOG.info("Last Modified date for Study[uid={}] Series[uid={}] is unavailable.", (Object)studyInstanceUID, (Object)seriesInstanceUID);
                    return Response.noContent().build();
                }
                LOG.debug("Last Modified date: {}", (Object)lastModified);
                if (this.request.getHeader("If-Modified-Since") != null || this.request.getHeader("If-Unmodified-Since") != null || this.request.getHeader("If-Match") != null || this.request.getHeader("If-None-Match") != null) {
                    Response.ResponseBuilder respBuilder = this.evaluatePreConditions(lastModified);
                    if (respBuilder != null) {
                        Response response = respBuilder.build();
                        LOG.debug("Preconditions are met - return status {}", (Object)response.getStatus());
                        return response;
                    }
                    LOG.debug("Preconditions are not met - build response");
                }
            }
            ctx.setReturnPrivate(this.queryAttrs.isIncludePrivate());
            if (ctx.getQueryParam().noMatches()) {
                return Response.ok((Object)output.entity(this, method, null, model, null, ctx)).type(output.type()).build();
            }
            try (Query query = model.createQuery(this.service, ctx);){
                int maxResults = arcAE.qidoMaxNumberOfResults();
                int offsetInt = QidoRS.parseInt(this.offset);
                int limitInt = QidoRS.parseInt(this.limit);
                int remaining = 0;
                if (!(maxResults <= 0 || limitInt != 0 && limitInt <= maxResults || ctx.isConsiderPurgedInstances())) {
                    LOG.debug("Query for number of matching {}s", (Object)model);
                    long matches = query.fetchCount();
                    LOG.debug("Number of matching {}s: {}", (Object)model, (Object)matches);
                    int numResults = (int)(matches - (long)offsetInt);
                    if (numResults <= 0) {
                        LOG.debug("Offset {} >= {} - return 204 No Content", (Object)offsetInt, (Object)matches);
                        Response response = Response.noContent().build();
                        return response;
                    }
                    remaining = numResults - maxResults;
                }
                int fetchSize = arcAE.getArchiveDeviceExtension().getQueryFetchSize();
                LOG.debug("Query for matching {}s", (Object)model);
                query.executeQuery(fetchSize, offsetInt, remaining > 0 ? maxResults : limitInt);
                if (!query.hasMoreMatches()) {
                    LOG.debug("No matching {}s found - return 204 No Content", (Object)model);
                    Response response = Response.noContent().build();
                    return response;
                }
                Response.ResponseBuilder builder = Response.ok();
                if (remaining > 0) {
                    builder.header("Warning", (Object)this.warning(remaining));
                }
                if (lastModified != null) {
                    builder.lastModified(lastModified);
                    builder.tag(String.valueOf(lastModified.hashCode()));
                } else {
                    builder.header("Cache-Control", (Object)"no-cache");
                }
                Response response = builder.entity(output.entity(this, method, query, model, model.getAttributesCoercion(this.service, ctx), ctx)).type(output.type()).build();
                LOG.debug("Writing response {}, {}", (Object)response.getStatus(), (Object)response.getHeaders());
                Response response2 = response;
                return response2;
            }
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean includeDefaults() {
        return !"false".equals(this.includedefaults);
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass(WebApplication.ServiceClass serviceClass) {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(serviceClass)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with " + serviceClass.name() + "service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private Output selectMediaType() {
        List acceptableMediaTypes = MediaTypeUtils.acceptableMediaTypesOf((HttpHeaders)this.headers, this.accept);
        if (acceptableMediaTypes.stream().anyMatch(((Predicate<MediaType>)arg_0 -> ((MediaType)MediaTypes.APPLICATION_DICOM_JSON_TYPE).isCompatible(arg_0)).or(arg_0 -> ((MediaType)MediaType.APPLICATION_JSON_TYPE).isCompatible(arg_0)))) {
            return Output.JSON;
        }
        if (acceptableMediaTypes.stream().map(MediaTypes::getMultiPartRelatedType).anyMatch(arg_0 -> ((MediaType)MediaTypes.APPLICATION_DICOM_XML_TYPE).isCompatible(arg_0))) {
            return Output.DICOM_XML;
        }
        Optional<MediaType> csvMediaType = acceptableMediaTypes.stream().filter(arg_0 -> ((MediaType)MediaTypes.TEXT_CSV_UTF8_TYPE).isCompatible(arg_0)).findFirst();
        if (csvMediaType.isPresent()) {
            if ("semicolon".equals(csvMediaType.get().getParameters().get("delimiter"))) {
                this.csvDelimiter = (char)59;
            }
            return Output.CSV;
        }
        throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
    }

    private String warning(int remaining) {
        return "299 " + this.request.getServerName() + ":" + this.request.getServerPort() + " \"There are " + remaining + " additional results that can be requested\"";
    }

    private QueryContext newQueryContext(String method, QueryAttributes queryAttrs, String studyInstanceUID, String seriesInstanceUID, Model model, ApplicationEntity ae) throws Exception {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCalledAET(this.aet);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setAllOfModalitiesInStudy(Boolean.parseBoolean(this.allOfModalitiesInStudy));
        queryParam.setOnlyWithStudies(Boolean.parseBoolean(this.onlyWithStudies));
        queryParam.setIncomplete(Boolean.parseBoolean(this.incomplete));
        queryParam.setRetrieveFailed(Boolean.parseBoolean(this.retrievefailed));
        queryParam.setStorageVerificationFailed(Boolean.parseBoolean(this.storageVerificationFailed));
        queryParam.setMetadataUpdateFailed(Boolean.parseBoolean(this.metadataUpdateFailed));
        queryParam.setCompressionFailed(Boolean.parseBoolean(this.compressionfailed));
        queryParam.setTemplate(Boolean.parseBoolean(this.template));
        queryParam.setMerged(Boolean.parseBoolean(this.merged));
        queryParam.setExternalRetrieveAET(this.externalRetrieveAET);
        queryParam.setExternalRetrieveAETNot(this.externalRetrieveAETNot);
        queryParam.setExpirationDate(this.expirationDate);
        queryParam.setStudySizeRange(this.studySizeInKB);
        queryParam.setRequested(this.requested);
        if (this.storageID != null) {
            queryParam.setStudyStorageIDs(((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getStudyStorageIDs(this.storageID, QidoRS.parseBoolean(this.storageClustered), QidoRS.parseBoolean(this.storageExported)));
        }
        if (this.patientVerificationStatus != null) {
            queryParam.setPatientVerificationStatus(Patient.VerificationStatus.valueOf((String)this.patientVerificationStatus));
        }
        if (this.expirationState != null) {
            queryParam.setExpirationState(new ExpirationState[]{ExpirationState.valueOf((String)this.expirationState)});
        }
        QueryContext ctx = this.service.newQueryContextQIDO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), method, this.aet, ae, queryParam);
        ctx.setQueryRetrieveLevel(model.getQueryRetrieveLevel());
        ctx.setSOPClassUID(model.getSOPClassUID());
        Attributes keys = queryAttrs.getQueryKeys();
        ctx.setQueryKeys(keys);
        this.service.coerceAttributes(ctx);
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        if (studyInstanceUID != null) {
            keys.setString(0x20000D, VR.UI, studyInstanceUID);
        }
        if (seriesInstanceUID != null) {
            keys.setString(0x20000E, VR.UI, seriesInstanceUID);
        }
        ctx.setOrderByTags((List)queryAttrs.getOrderByTags());
        return ctx;
    }

    private static Boolean parseBoolean(String s) {
        return s != null ? Boolean.valueOf(s) : null;
    }

    private static int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private boolean acceptStudyMatch(Attributes match) {
        return this.queryAttrs.getModified().isEmpty() || this.isModified(match, this.readObject(match.getString(0x20000D), null, null));
    }

    private boolean acceptSeriesMatch(Attributes match) {
        return this.queryAttrs.getModified().isEmpty() || this.isModified(match, this.readObject(match.getString(0x20000D), match.getString(0x20000E), null));
    }

    private boolean acceptInstanceMatch(Attributes match) {
        return this.queryAttrs.getModified().isEmpty() || this.isModified(match, this.readObject(match.getString(0x20000D), match.getString(0x20000E), match.getString(524312)));
    }

    private Attributes readObject(String studyUID, String seriesUID, String objectUID) {
        Attributes attributes;
        block9: {
            RetrieveContext ctx = this.retrieveService.newRetrieveContextWADO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.aet, studyUID, seriesUID, objectUID);
            this.retrieveService.calculateMatches(ctx);
            DicomInputStream din = this.retrieveService.openDicomInputStream(ctx, (InstanceLocations)ctx.getMatches().get(0));
            try {
                attributes = din.readDatasetUntilPixelData();
                if (din == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (din != null) {
                        try {
                            din.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            din.close();
        }
        return attributes;
    }

    private boolean isModified(Attributes match, Attributes attrs) {
        return this.allmodified ? this.isAllModified(match, attrs) : this.isAnyModified(match, attrs);
    }

    private boolean isAllModified(Attributes match, Attributes attrs) {
        for (int[] tagPath : this.queryAttrs.getModified()) {
            if (!Objects.equals(QidoRS.getString(match, tagPath), QidoRS.getString(attrs, tagPath))) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyModified(Attributes match, Attributes attrs) {
        for (int[] tagPath : this.queryAttrs.getModified()) {
            if (Objects.equals(QidoRS.getString(match, tagPath), QidoRS.getString(attrs, tagPath))) continue;
            return true;
        }
        return false;
    }

    private static String getString(Attributes item, int[] tagPath) {
        int last = tagPath.length - 1;
        for (int i = 0; i < last; ++i) {
            if ((item = item.getNestedDataset(tagPath[i])) != null) continue;
            return null;
        }
        return item.getString(tagPath[last]);
    }

    private Object writeXML(String method, Query query, Model model, AttributesCoercion coercion) throws Exception {
        MultipartRelatedOutput output = new MultipartRelatedOutput();
        int count = 0;
        while (query != null && query.hasMoreMatches()) {
            Attributes tmp = query.nextMatch();
            if (tmp == null) continue;
            if (!model.acceptMatch.test(this, tmp)) {
                query.incrementLimit();
                continue;
            }
            Attributes match = this.adjust(tmp, model, query, coercion);
            LOG.debug("{}: Match #{}:\n{}", new Object[]{method, ++count, match});
            output.addPart(out -> {
                try {
                    SAXTransformer.getSAXWriter((Result)new StreamResult(out)).write(match);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }, MediaTypes.APPLICATION_DICOM_XML_TYPE);
        }
        LOG.info("{}: {} Matches", (Object)method, (Object)count);
        return output;
    }

    private Object writeJSON(String method, Query query, Model model, AttributesCoercion coercion) throws Exception {
        List<Attributes> matches = this.matches(method, query, model, coercion);
        return out -> {
            LOG.debug("Enter StreamingOutput.write");
            ArchiveAEExtension arcAE = this.getArchiveAE();
            if (arcAE != null) {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                JSONWriter writer = arcAE.encodeAsJSONNumber(new JSONWriter(gen));
                gen.writeStartArray();
                for (Attributes match : matches) {
                    writer.write(match);
                }
                gen.writeEnd();
                gen.flush();
            }
            LOG.debug("Leave StreamingOutput.write");
        };
    }

    private Object writeCSV(String method, Query query, Model model, AttributesCoercion coercion, QueryContext ctx) throws Exception {
        List<Attributes> matches = this.matches(method, query, model, coercion);
        return out -> {
            int[] tags;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            if (matches.size() > 0 && (tags = this.tagsFrom(model, (Attributes)matches.get(0), ctx)).length != 0) {
                CSVPrinter printer = new CSVPrinter((Appendable)writer, CSVFormat.RFC4180.builder().setHeader(this.csvHeader((Attributes)matches.get(0), tags)).setDelimiter(this.csvDelimiter).setQuoteMode(QuoteMode.ALL).build());
                matches.forEach(match -> this.printRecord(printer, (Attributes)match, tags));
            }
            ((Writer)writer).flush();
        };
    }

    private List<Attributes> matches(String method, Query query, Model model, AttributesCoercion coercion) throws Exception {
        if (query == null) {
            return Collections.emptyList();
        }
        ArrayList<Attributes> matches = new ArrayList<Attributes>();
        int count = 0;
        while (query.hasMoreMatches()) {
            Attributes tmp = query.nextMatch();
            if (tmp == null) continue;
            if (!model.acceptMatch.test(this, tmp)) {
                query.incrementLimit();
                continue;
            }
            Attributes match = this.adjust(tmp, model, query, coercion);
            LOG.debug("{}: Match #{}:\n{}", new Object[]{method, ++count, match});
            matches.add(match);
        }
        LOG.info("{}: {} Matches", (Object)method, (Object)count);
        return matches;
    }

    private int[] tagsFrom(Model model, Attributes match, QueryContext ctx) {
        Attributes returnKeys = ctx.getReturnKeys();
        return returnKeys == null ? this.allFieldsOf(model, match) : this.nonSeqTagsFrom(returnKeys);
    }

    private int[] allFieldsOf(Model model, Attributes match) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        int[] tags = arcDev.getAttributeFilter(Entity.Patient).getSelection();
        switch (model) {
            case STUDY: {
                return this.allNonSeqTags(match, tags, arcDev.getAttributeFilter(Entity.Study).getSelection(), {524385, 0x201200, 2101766, 2101768});
            }
            case SERIES: {
                return this.allNonSeqTags(match, tags, arcDev.getAttributeFilter(Entity.Study).getSelection(), arcDev.getAttributeFilter(Entity.Series).getSelection(), {0x201200, 2101766, 2101768, 2101769, 536578});
            }
            case INSTANCE: {
                return this.allNonSeqTags(match, tags, arcDev.getAttributeFilter(Entity.Study).getSelection(), arcDev.getAttributeFilter(Entity.Series).getSelection(), arcDev.getAttributeFilter(Entity.Instance).getSelection(), {0x201200, 2101766, 2101768, 2101769, 536578});
            }
            case MWL: {
                return this.allNonSeqTags(match, tags, arcDev.getAttributeFilter(Entity.MWL).getSelection());
            }
            case UPS: {
                return this.allNonSeqTags(match, tags, arcDev.getAttributeFilter(Entity.UPS).getSelection());
            }
        }
        return this.allNonSeqTags(match, tags, {0x201200});
    }

    private int[] allNonSeqTags(Attributes match, int[] ... tags) {
        HashSet<Integer> allNonSeqTags = new HashSet<Integer>();
        int[][] nArray = tags;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] entityTags;
            for (int tag : entityTags = nArray[i]) {
                if (ElementDictionary.vrOf((int)tag, (String)match.getPrivateCreator(tag)) == VR.SQ) continue;
                allNonSeqTags.add(tag);
            }
        }
        return allNonSeqTags.stream().mapToInt(Integer::intValue).toArray();
    }

    private int[] nonSeqTagsFrom(Attributes attrs) {
        HashSet tags = new HashSet();
        try {
            attrs.accept((attrs1, tag, vr, value) -> {
                if (ElementDictionary.vrOf((int)tag, (String)attrs.getPrivateCreator(tag)) != VR.SQ) {
                    tags.add(tag);
                }
                return true;
            }, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tags.stream().mapToInt(Integer::intValue).toArray();
    }

    private String[] csvHeader(Attributes match, int[] tags) {
        return (String[])Arrays.stream(tags).mapToObj(tag -> ElementDictionary.keywordOf((int)tag, (String)match.getPrivateCreator(tag))).toArray(String[]::new);
    }

    private void printRecord(CSVPrinter printer, Attributes match, int[] tags) {
        try {
            for (int tag : tags) {
                try {
                    if (tag == 524385) {
                        printer.print((Object)String.join((CharSequence)"\\", match.getStrings(tag)));
                        continue;
                    }
                    printer.print((Object)match.getString(tag));
                }
                catch (IOException e) {
                    LOG.debug("Error printing record for {}", (Object)tag);
                }
            }
            printer.println();
        }
        catch (IOException e) {
            LOG.debug("Error printing record for newline");
        }
    }

    private Attributes adjust(Attributes match, Model model, Query query, AttributesCoercion coercion) throws Exception {
        if (coercion != null) {
            coercion.coerce(match, null);
        }
        match = query.adjust(match);
        if (model != Model.PATIENT && model != Model.MWL) {
            model.addRetrieveURL(this, match);
            StringBuffer sb = model.retrieveURL(this, match);
            if (sb != null) {
                match.setString(528784, VR.UR, sb.toString());
            }
        }
        return match;
    }

    private Response errResponse(String errorMessage, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + errorMessage + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static enum Output {
        DICOM_XML{

            @Override
            Object entity(QidoRS service, String method, Query query, Model model, AttributesCoercion coercion, QueryContext ctx) throws Exception {
                return service.writeXML(method, query, model, coercion);
            }

            @Override
            MediaType type() {
                return MediaTypes.MULTIPART_RELATED_APPLICATION_DICOM_XML_TYPE;
            }
        }
        ,
        JSON{

            @Override
            Object entity(QidoRS service, String method, Query query, Model model, AttributesCoercion coercion, QueryContext ctx) throws Exception {
                return service.writeJSON(method, query, model, coercion);
            }

            @Override
            MediaType type() {
                return MediaTypes.APPLICATION_DICOM_JSON_TYPE;
            }
        }
        ,
        CSV{

            @Override
            Object entity(QidoRS service, String method, Query query, Model model, AttributesCoercion coercion, QueryContext ctx) throws Exception {
                return service.writeCSV(method, query, model, coercion, ctx);
            }

            @Override
            MediaType type() {
                return MediaTypes.TEXT_CSV_UTF8_TYPE;
            }
        };


        abstract Object entity(QidoRS var1, String var2, Query var3, Model var4, AttributesCoercion var5, QueryContext var6) throws Exception;

        abstract MediaType type();
    }

    private static enum Model {
        PATIENT(QueryRetrieveLevel2.PATIENT, "1.2.840.10008.5.1.4.1.2.1.1"){

            @Override
            public AttributesCoercion getAttributesCoercion(QueryService service, QueryContext ctx) {
                return null;
            }

            @Override
            public void addRetrieveURL(QidoRS qidoRS, Attributes match) {
            }
        }
        ,
        STUDY(QueryRetrieveLevel2.STUDY, "1.2.840.10008.5.1.4.1.2.2.1", (rec$, x$0) -> ((QidoRS)rec$).acceptStudyMatch((Attributes)x$0)){

            @Override
            public StringBuffer retrieveURL(QidoRS qidoRS, Attributes match) {
                return super.retrieveURL(qidoRS, match).append("/studies/").append(match.getString(0x20000D));
            }
        }
        ,
        SERIES(QueryRetrieveLevel2.SERIES, "1.2.840.10008.5.1.4.1.2.2.1", (rec$, x$0) -> ((QidoRS)rec$).acceptSeriesMatch((Attributes)x$0)){

            @Override
            StringBuffer retrieveURL(QidoRS qidoRS, Attributes match) {
                return STUDY.retrieveURL(qidoRS, match).append("/series/").append(match.getString(0x20000E));
            }
        }
        ,
        INSTANCE(QueryRetrieveLevel2.IMAGE, "1.2.840.10008.5.1.4.1.2.2.1", (rec$, x$0) -> ((QidoRS)rec$).acceptInstanceMatch((Attributes)x$0)){

            @Override
            StringBuffer retrieveURL(QidoRS qidoRS, Attributes match) {
                return SERIES.retrieveURL(qidoRS, match).append("/instances/").append(match.getString(524312));
            }
        }
        ,
        MWL(null, "1.2.840.10008.5.1.4.31"){

            @Override
            Query createQuery(QueryService service, QueryContext ctx) {
                return service.createMWLQuery(ctx);
            }

            @Override
            public AttributesCoercion getAttributesCoercion(QueryService service, QueryContext ctx) {
                return null;
            }

            @Override
            public void addRetrieveURL(QidoRS qidoRS, Attributes match) {
            }
        }
        ,
        MPPS(null, "1.2.840.10008.3.1.2.3.4"){

            @Override
            Query createQuery(QueryService service, QueryContext ctx) {
                return service.createMPPSQuery(ctx);
            }

            @Override
            public AttributesCoercion getAttributesCoercion(QueryService service, QueryContext ctx) {
                return null;
            }

            @Override
            public void addRetrieveURL(QidoRS qidoRS, Attributes match) {
            }
        }
        ,
        UPS(null, "1.2.840.10008.5.1.4.34.6.3"){

            @Override
            Query createQuery(QueryService service, QueryContext ctx) {
                return service.createUPSQuery(ctx);
            }

            @Override
            public AttributesCoercion getAttributesCoercion(QueryService service, QueryContext ctx) {
                return null;
            }

            @Override
            public void addRetrieveURL(QidoRS qidoRS, Attributes match) {
            }
        };

        final QueryRetrieveLevel2 qrLevel;
        final String sopClassUID;
        final BiPredicate<QidoRS, Attributes> acceptMatch;

        private Model(QueryRetrieveLevel2 qrLevel, String sopClassUID) {
            this(qrLevel, sopClassUID, (qidoRS, match) -> true);
        }

        private Model(QueryRetrieveLevel2 qrLevel, String sopClassUID, BiPredicate<QidoRS, Attributes> acceptMatch) {
            this.qrLevel = qrLevel;
            this.sopClassUID = sopClassUID;
            this.acceptMatch = acceptMatch;
        }

        QueryRetrieveLevel2 getQueryRetrieveLevel() {
            return this.qrLevel;
        }

        Query createQuery(QueryService service, QueryContext ctx) {
            return service.createQuery(ctx);
        }

        AttributesCoercion getAttributesCoercion(QueryService service, QueryContext ctx) {
            return service.getAttributesCoercion(ctx);
        }

        StringBuffer retrieveURL(QidoRS qidoRS, Attributes match) {
            StringBuffer sb = ((ArchiveDeviceExtension)qidoRS.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).remapRetrieveURL(qidoRS.request);
            sb.setLength(sb.lastIndexOf("/rs/") + 3);
            return sb;
        }

        void addRetrieveURL(QidoRS qidoRS, Attributes match) {
            match.setString(528784, VR.UR, this.retrieveURL(qidoRS, match).toString());
        }

        String getSOPClassUID() {
            return this.sopClassUID;
        }
    }
}

