/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq.db;

import java.util.List;
import javax.persistence.EntityManager;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.entity.PatientDemographics;
import org.dcm4chee.arc.pdq.AbstractPDQService;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.pdq.PDQServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTablePDQService
extends AbstractPDQService {
    private static final Logger LOG = LoggerFactory.getLogger(DBTablePDQService.class);
    private final EntityManager em;

    public DBTablePDQService(PDQServiceDescriptor descriptor, EntityManager em) {
        super(descriptor);
        this.em = em;
    }

    public Attributes query(PDQServiceContext ctx) throws PDQServiceException {
        this.requireQueryEntity(Entity.Patient);
        IDWithIssuer patientID = ctx.getPatientID();
        List patientDemographics = this.em.createNamedQuery("PatientDemographics.findByPatientID", PatientDemographics.class).setParameter(1, (Object)this.toString(patientID)).getResultList();
        switch (patientDemographics.size()) {
            case 0: {
                LOG.info("No Patient Demographics found for {}", (Object)patientID);
                return null;
            }
            case 1: {
                return this.demographics(patientID, (PatientDemographics)patientDemographics.get(0));
            }
        }
        throw new PDQServiceException("Patient ID '" + patientID + "' not unique at " + this.descriptor);
    }

    private String toString(IDWithIssuer patientID) {
        if (patientID.getIssuer() == null) {
            return patientID + "%";
        }
        return patientID.toString();
    }

    private Attributes demographics(IDWithIssuer patientID, PatientDemographics pd) {
        Attributes attrs = patientID.exportPatientIDWithIssuer(null);
        attrs.setString(0x100010, VR.PN, pd.getName());
        attrs.setString(0x100030, VR.DA, pd.getBirthDate());
        attrs.setString(0x100040, VR.CS, pd.getSex());
        return attrs;
    }
}

