/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.mpps.impl;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.NullifyAttributesCoercion;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.io.XSLTAttributesCoercion;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.coerce.CoercionFactory;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.mima.SupplementAssigningAuthorities;
import org.dcm4chee.arc.mpps.MPPSContext;
import org.dcm4chee.arc.mpps.MPPSService;
import org.dcm4chee.arc.mpps.impl.MPPSContextImpl;
import org.dcm4chee.arc.mpps.impl.MPPSServiceEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MPPSServiceImpl
implements MPPSService {
    static final Logger LOG = LoggerFactory.getLogger(MPPSServiceImpl.class);
    @Inject
    private MPPSServiceEJB ejb;
    @Inject
    private CoercionFactory coercionFactory;

    @Override
    public MPPSContext newMPPSContext(Association as) {
        return new MPPSContextImpl(as);
    }

    @Override
    public MPPS createMPPS(MPPSContext ctx) throws DicomServiceException {
        try {
            this.coerceAttributes(ctx, Dimse.N_CREATE_RQ);
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
        return this.ejb.createMPPS(ctx);
    }

    @Override
    public MPPS findMPPS(MPPSContext ctx) throws DicomServiceException {
        return this.ejb.findMPPS(ctx);
    }

    @Override
    public MPPS updateMPPS(MPPSContext ctx) throws DicomServiceException {
        try {
            this.coerceAttributes(ctx, Dimse.N_SET_RQ);
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
        return this.ejb.updateMPPS(ctx);
    }

    private void coerceAttributes(MPPSContext ctx, Dimse dimse) throws Exception {
        block8: {
            List coercions;
            block7: {
                ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
                coercions = arcAE.attributeCoercions2().filter(descriptor -> descriptor.match(TransferCapability.Role.SCU, dimse, "1.2.840.10008.3.1.2.3.3", ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), ctx.getAttributes())).collect(Collectors.toList());
                if (!coercions.isEmpty()) break block7;
                ArchiveAttributeCoercion rule = arcAE.findAttributeCoercion(dimse, TransferCapability.Role.SCU, "1.2.840.10008.3.1.2.3.3", ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), ctx.getAttributes());
                if (rule == null) break block8;
                this.coerceLegacy(ctx, rule);
                break block8;
            }
            block6: for (ArchiveAttributeCoercion2 coercion : coercions) {
                try {
                    if (!this.coercionFactory.getCoercionProcessor(coercion).coerce(coercion, "1.2.840.10008.3.1.2.3.3", ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), ctx.getAttributes(), null) || !coercion.isCoercionSufficient()) continue;
                }
                catch (Exception e) {
                    LOG.info("Failed to apply {}:\n", (Object)coercion, (Object)e);
                    switch (coercion.getCoercionOnFailure()) {
                        case RETHROW: {
                            throw e;
                        }
                        case CONTINUE: {
                            continue block6;
                        }
                    }
                }
                break;
            }
        }
    }

    private void coerceLegacy(MPPSContext ctx, ArchiveAttributeCoercion rule) throws Exception {
        AttributesCoercion coercion = null;
        coercion = this.coerceAttributesByXSL(ctx, rule, coercion);
        coercion = SupplementAssigningAuthorities.forMPPS((Device)rule.getSupplementFromDevice(), (AttributesCoercion)coercion);
        coercion = rule.mergeAttributes(coercion);
        coercion = NullifyAttributesCoercion.valueOf((int[])rule.getNullifyTags(), (AttributesCoercion)coercion);
        if (coercion != null) {
            coercion.coerce(ctx.getAttributes(), null);
        }
    }

    private AttributesCoercion coerceAttributesByXSL(MPPSContext ctx, ArchiveAttributeCoercion rule, AttributesCoercion next) {
        String xsltStylesheetURI = rule.getXSLTStylesheetURI();
        if (xsltStylesheetURI != null) {
            try {
                Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)xsltStylesheetURI));
                LOG.info("Coerce Attributes from rule: {}", (Object)rule);
                return new XSLTAttributesCoercion(tpls, null).includeKeyword(!rule.isNoKeywords()).setupTransformer(this.setupTransformer(ctx));
            }
            catch (TransformerConfigurationException e) {
                LOG.error("{}: Failed to compile XSL: {}", new Object[]{ctx, xsltStylesheetURI, e});
            }
        }
        return next;
    }

    private SAXTransformer.SetupTransformer setupTransformer(MPPSContext ctx) {
        return t -> {
            t.setParameter("LocalAET", ctx.getCalledAET());
            if (ctx.getCallingAET() != null) {
                t.setParameter("RemoteAET", ctx.getCallingAET());
            }
            t.setParameter("RemoteHost", ctx.getRemoteHostName());
        };
    }
}

