/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.mima;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupplementAssigningAuthorities
implements AttributesCoercion {
    static final Logger LOG = LoggerFactory.getLogger(SupplementAssigningAuthorities.class);
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private final Entity entity;
    private final Device device;
    private final AttributesCoercion next;

    private SupplementAssigningAuthorities(Entity entity, Device device, AttributesCoercion next) {
        this.entity = entity;
        this.device = device;
        this.next = next;
    }

    public static AttributesCoercion forInstance(Device device, AttributesCoercion next) {
        return device != null ? new SupplementAssigningAuthorities(Entity.Instance, device, next) : next;
    }

    public static AttributesCoercion forMPPS(Device device, AttributesCoercion next) {
        return device != null ? new SupplementAssigningAuthorities(Entity.MPPS, device, next) : next;
    }

    public static AttributesCoercion forMWL(Device device, AttributesCoercion next) {
        return device != null ? new SupplementAssigningAuthorities(Entity.MWL, device, next) : next;
    }

    public static AttributesCoercion forQuery(Device device, AttributesCoercion next) {
        return device != null ? new SupplementAssigningAuthorities(Entity.Query, device, next) : next;
    }

    public String remapUID(String uid) {
        return this.next != null ? this.next.remapUID(uid) : uid;
    }

    public void coerce(Attributes attrs, Attributes modified) throws Exception {
        LOG.info("Supplement entity {} by coercion {}", (Object)this.entity, (Object)this);
        this.entity.supplement(this, attrs);
        if (this.next != null) {
            this.next.coerce(attrs, modified);
        }
    }

    private void supplementInstance(Attributes attrs) {
        this.supplementValue(attrs, 524400, VR.LO, this.device.getManufacturer());
        this.supplementValue(attrs, 528528, VR.LO, this.device.getManufacturerModelName());
        this.supplementValue(attrs, 528400, VR.SH, this.device.getStationName());
        this.supplementValue(attrs, 0x181000, VR.LO, this.device.getDeviceSerialNumber());
        this.supplementValues(attrs, 1576992, VR.LO, this.device.getSoftwareVersions());
        this.supplementValue(attrs, 524416, VR.LO, this.device.getInstitutionNames());
        this.supplementCode(attrs, 524418, this.device.getInstitutionCodes());
        this.supplementValue(attrs, 528448, VR.LO, this.device.getInstitutionalDepartmentNames());
        this.supplementValue(attrs, 524417, VR.ST, this.device.getInstitutionAddresses());
        this.supplementIssuers(attrs);
        this.supplementRequestIssuers(attrs.getSequence(4194933));
        LOG.info("Supplement composite object from device: {}", (Object)this.device.getDeviceName());
    }

    private void supplementMPPS(Attributes attrs) {
        this.supplementIssuers(attrs);
        this.supplementRequestIssuers(attrs.getSequence(4194928));
        LOG.info("Supplement MPPS from device: {}", (Object)this.device.getDeviceName());
    }

    private void supplementMWL(Attributes attrs) {
        this.supplementIssuers(attrs);
        this.supplementRequestIssuers(attrs);
        LOG.info("Supplement MWL from device: {}", (Object)this.device.getDeviceName());
    }

    private void supplementQuery(Attributes attrs) {
        this.supplementIssuers(attrs);
        this.supplementRequestIssuers(attrs.getSequence(4194933));
        LOG.info("Supplement composite query from device: {}", (Object)this.device.getDeviceName());
    }

    private void supplementValue(Attributes attrs, int tag, VR vr, String ... values) {
        if (values.length == 0 || values[0] == null || attrs.containsValue(tag)) {
            return;
        }
        attrs.setString(tag, vr, values[0]);
        this.log(tag, vr, values[0]);
    }

    private void supplementValues(Attributes attrs, int tag, VR vr, String ... values) {
        if (values.length == 0 || attrs.containsValue(tag)) {
            return;
        }
        attrs.setString(tag, vr, values);
        this.log(tag, vr, values);
    }

    private void supplementCode(Attributes attrs, int seqTag, Code ... codes) {
        if (codes.length == 0 || codes[0] == null || attrs.containsValue(seqTag)) {
            return;
        }
        Attributes item = new Attributes(attrs.bigEndian(), 4);
        item.setString(524544, VR.SH, codes[0].getCodeValue());
        item.setString(524546, VR.SH, codes[0].getCodingSchemeDesignator());
        String version = codes[0].getCodingSchemeVersion();
        if (version != null) {
            item.setString(524547, VR.SH, version);
        }
        item.setString(524548, VR.LO, codes[0].getCodeMeaning());
        attrs.newSequence(seqTag, 1).add(item);
        this.log(seqTag, VR.SQ, item);
    }

    private void supplementIssuers(Attributes attrs) {
        this.supplementIssuerOfPatientID(attrs);
        this.supplementIssuer(attrs, 524368, 524369, this.device.getIssuerOfAccessionNumber());
        this.supplementIssuer(attrs, 3670032, 3670036, this.device.getIssuerOfAdmissionID());
        this.supplementIssuer(attrs, 3670112, 3670116, this.device.getIssuerOfServiceEpisodeID());
        this.supplementIssuer(attrs, 4195602, 4195603, this.device.getIssuerOfContainerIdentifier());
        this.supplementIssuer(attrs, 4195665, 4195682, this.device.getIssuerOfSpecimenIdentifier());
    }

    private void supplementIssuerOfPatientID(Attributes attrs) {
        String universalEntityID;
        if (this.supplementIssuerOfPID(attrs)) {
            return;
        }
        Issuer issuer = this.device.getIssuerOfPatientID();
        String localNamespaceEntityID = issuer.getLocalNamespaceEntityID();
        if (localNamespaceEntityID != null) {
            attrs.setString(0x100021, VR.LO, localNamespaceEntityID);
            this.log(0x100021, VR.LO, localNamespaceEntityID);
        }
        if ((universalEntityID = issuer.getUniversalEntityID()) != null) {
            Attributes item = new Attributes(attrs.bigEndian(), 2);
            item.setString(4194354, VR.UT, universalEntityID);
            item.setString(0x400033, VR.CS, issuer.getUniversalEntityIDType());
            attrs.newSequence(1048612, 1).add(item);
            this.log(1048612, VR.SQ, item);
        }
    }

    private boolean supplementIssuerOfPID(Attributes attrs) {
        Attributes issuerOfPIDQualifier = attrs.getNestedDataset(1048612);
        return !attrs.containsValue(0x100020) || this.device.getIssuerOfPatientID() == null || attrs.containsValue(0x100021) || issuerOfPIDQualifier != null && !issuerOfPIDQualifier.isEmpty();
    }

    private void supplementIssuer(Attributes attrs, int idTag, int seqTag, Issuer issuer) {
        String universalEntityID;
        if (issuer == null || !attrs.containsValue(idTag) || attrs.containsValue(seqTag)) {
            return;
        }
        Attributes item = new Attributes(attrs.bigEndian(), 3);
        String localNamespaceEntityID = issuer.getLocalNamespaceEntityID();
        if (localNamespaceEntityID != null) {
            item.setString(4194353, VR.UT, localNamespaceEntityID);
        }
        if ((universalEntityID = issuer.getUniversalEntityID()) != null) {
            item.setString(4194354, VR.UT, universalEntityID);
            item.setString(0x400033, VR.CS, issuer.getUniversalEntityIDType());
        }
        attrs.newSequence(seqTag, 1).add(item);
        this.log(seqTag, VR.SQ, item);
    }

    private void supplementRequestIssuers(Sequence rqSeq) {
        if (rqSeq != null) {
            for (Attributes rq : rqSeq) {
                this.supplementRequestIssuers(rq);
            }
        }
    }

    private void supplementRequestIssuers(Attributes rq) {
        this.supplementIssuer(rq, 524368, 524369, this.device.getIssuerOfAccessionNumber());
        this.supplementIssuer(rq, 4202518, 4194342, this.device.getOrderPlacerIdentifier());
        this.supplementIssuer(rq, 4202519, 4194343, this.device.getOrderFillerIdentifier());
    }

    private void log(int tag, VR vr, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Supplements {} {} [{}] {}", new Object[]{TagUtils.toString((int)tag), vr, value, DICT.keywordOf(tag)});
        }
    }

    private static enum Entity {
        Instance{

            @Override
            void supplement(SupplementAssigningAuthorities coercion, Attributes attrs) {
                coercion.supplementInstance(attrs);
            }
        }
        ,
        MPPS{

            @Override
            void supplement(SupplementAssigningAuthorities coercion, Attributes attrs) {
                coercion.supplementMPPS(attrs);
            }
        }
        ,
        MWL{

            @Override
            void supplement(SupplementAssigningAuthorities coercion, Attributes attrs) {
                coercion.supplementMWL(attrs);
            }
        }
        ,
        Query{

            @Override
            void supplement(SupplementAssigningAuthorities coercion, Attributes attrs) {
                coercion.supplementQuery(attrs);
            }
        };


        abstract void supplement(SupplementAssigningAuthorities var1, Attributes var2);
    }
}

