/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.metrics.impl;

import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.MetricsDescriptor;
import org.dcm4chee.arc.event.ArchiveServiceEvent;
import org.dcm4chee.arc.metrics.MetricsService;

@ApplicationScoped
public class MetricsServiceImpl
implements MetricsService {
    private static final int MILLIS_PER_MIN = 60000;
    private final Map<String, DataBins> map = new ConcurrentHashMap<String, DataBins>();
    @Inject
    private Device device;

    @Override
    public boolean exists(String name) {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).hasMetricsDescriptor(name);
    }

    @Override
    public void accept(String name, double value) {
        this.accept(name, () -> value);
    }

    @Override
    public void acceptNanoTime(String name, long startTime) {
        this.accept(name, () -> (double)(System.nanoTime() - startTime) / 1000000.0);
    }

    @Override
    public void acceptDataRate(String name, long bytes, long startTime) {
        this.accept(name, () -> (double)bytes * 1000.0 / (double)(System.nanoTime() - startTime));
    }

    @Override
    public void accept(String name, DoubleSupplier valueSupplier) {
        MetricsDescriptor descriptor = this.getMetricsDescriptor(name);
        if (descriptor == null) {
            return;
        }
        long time = MetricsServiceImpl.currentTimeMins();
        this.map.computeIfAbsent(name, x -> new DataBins(time, descriptor.getRetentionPeriod())).accept(time, valueSupplier.getAsDouble());
    }

    public void onReload(@Observes ArchiveServiceEvent event) {
        if (event.getType() != ArchiveServiceEvent.Type.RELOADED) {
            return;
        }
        this.map.entrySet().removeIf(entry -> {
            MetricsDescriptor metricsDescriptor = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getMetricsDescriptor((String)entry.getKey());
            return metricsDescriptor == null || metricsDescriptor.getRetentionPeriod() != ((DataBins)entry.getValue()).getRetentionPeriod();
        });
    }

    @Override
    public void forEach(String name, int limit, int binSize, Consumer<DoubleSummaryStatistics> consumer) {
        MetricsDescriptor descriptor = this.getMetricsDescriptor(name);
        if (descriptor == null) {
            return;
        }
        if (binSize <= 0) {
            throw new IllegalArgumentException("binSize not > 0: " + binSize);
        }
        int retentionPeriod = descriptor.getRetentionPeriod();
        if (binSize > retentionPeriod) {
            binSize = retentionPeriod;
        }
        int n = (retentionPeriod - 1) / binSize + 1;
        if (limit > 0 && n > limit) {
            n = limit;
        }
        DataBins dataBins = this.map.get(name);
        long time = MetricsServiceImpl.currentTimeMins();
        while (n-- > 0) {
            consumer.accept(dataBins != null ? dataBins.getBin(time, binSize) : null);
            time -= (long)binSize;
        }
    }

    private static long currentTimeMins() {
        return System.currentTimeMillis() / 60000L;
    }

    private MetricsDescriptor getMetricsDescriptor(String name) {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getMetricsDescriptor(name);
    }

    private static class DataBins {
        volatile long acceptTime;
        final DoubleSummaryStatistics[] statistics;

        DataBins(long time, int retentionPeriod) {
            this.acceptTime = time;
            this.statistics = new DoubleSummaryStatistics[retentionPeriod];
            this.statistics[(int)(time % (long)this.statistics.length)] = new DoubleSummaryStatistics();
        }

        int getRetentionPeriod() {
            return this.statistics.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void accept(long time, double value) {
            int i = (int)(time % (long)this.statistics.length);
            if (this.acceptTime < time) {
                DataBins dataBins = this;
                synchronized (dataBins) {
                    long diff = time - this.acceptTime;
                    if (diff > 0L) {
                        if (diff > 1L) {
                            if (diff >= (long)this.statistics.length) {
                                Arrays.fill(this.statistics, null);
                            } else {
                                int fromIndex = i + 1 - (int)diff;
                                if (fromIndex >= 0) {
                                    Arrays.fill(this.statistics, fromIndex, i, null);
                                } else {
                                    Arrays.fill(this.statistics, 0, i, null);
                                    Arrays.fill(this.statistics, fromIndex + this.statistics.length, this.statistics.length, null);
                                }
                            }
                        }
                        this.statistics[i] = new DoubleSummaryStatistics();
                        this.acceptTime = time;
                    }
                }
            }
            this.statistics[i].accept(value);
        }

        DoubleSummaryStatistics getBin(long time, int binSize) {
            long beforeAcceptTime = this.acceptTime - time;
            if (beforeAcceptTime < 0L) {
                if (beforeAcceptTime + (long)binSize <= 0L) {
                    return null;
                }
                time = this.acceptTime;
                binSize = (int)((long)binSize + beforeAcceptTime);
            } else if ((long)binSize > (long)this.statistics.length - beforeAcceptTime) {
                binSize = (int)((long)this.statistics.length - beforeAcceptTime);
            }
            DoubleSummaryStatistics bin = null;
            int i = this.statistics.length + (int)(time % (long)this.statistics.length);
            while (binSize-- > 0) {
                DoubleSummaryStatistics other = this.statistics[i % this.statistics.length];
                if (other != null) {
                    if (bin == null) {
                        bin = new DoubleSummaryStatistics();
                    }
                    bin.combine(other);
                }
                --i;
            }
            return bin;
        }
    }
}

