/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.keycloak;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.dcm4chee.arc.keycloak.KeycloakContext;

public class HttpServletRequestInfo {
    public final String requesterUserID;
    public final String requesterHost;
    public final int requesterPort;
    public final String requestURI;
    public final String queryString;
    public final String localHost;
    public MediaType contentType;

    private HttpServletRequestInfo(HttpServletRequest request) {
        this.requesterUserID = KeycloakContext.valueOf(request).getUserName();
        this.requesterHost = request.getRemoteHost();
        this.requesterPort = request.getRemotePort();
        this.requestURI = request.getRequestURL().toString();
        this.queryString = request.getQueryString();
        this.localHost = request.getServerName();
    }

    private HttpServletRequestInfo(String requesterUserID, String requesterHost, String requestURI, String queryStr) {
        this.requesterUserID = requesterUserID;
        this.requesterHost = requesterHost;
        this.requesterPort = 0;
        this.requestURI = requestURI;
        this.queryString = queryStr;
        this.localHost = HttpServletRequestInfo.hostOfURI(requestURI);
    }

    public static HttpServletRequestInfo valueOf(HttpServletRequest request) {
        return new HttpServletRequestInfo(request);
    }

    public static HttpServletRequestInfo valueOf(String requesterUserID, String requesterHost, String requestURI) {
        return requestURI == null ? null : new HttpServletRequestInfo(requesterUserID, requesterHost, requestURI, requestURI.contains("?") ? requestURI.substring(requestURI.indexOf("?") + 1) : null);
    }

    private static String hostOfURI(String requestURI) {
        try {
            char ch;
            int beginIndex = requestURI.indexOf(58) + 1;
            while (requestURI.charAt(++beginIndex) == '/') {
            }
            int endIndex = beginIndex;
            while ((ch = requestURI.charAt(endIndex)) != '/' && ch != ':') {
                ++endIndex;
            }
            return requestURI.substring(beginIndex, endIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public HttpServletRequestInfo setContentType(HttpHeaders headers) {
        this.contentType = headers.getMediaType();
        return this;
    }

    public String toString() {
        return "HttpServletRequestInfo[requesterUserID=" + this.requesterUserID + ", requesterHost=" + this.requesterHost + ", requesterPort=" + this.requesterPort + ", requesterURI=" + this.requestURI + ", queryString=" + this.queryString + ", localHost=" + this.localHost + "]";
    }
}

