/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7.impl;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HL7Logger {
    private static final Logger LOG = LoggerFactory.getLogger(HL7Logger.class);
    @Inject
    private Device device;

    public void onHL7Connection(@Observes HL7ConnectionEvent event) {
        UnparsedHL7Message msg = event.getHL7Message();
        switch (event.getType()) {
            case MESSAGE_RECEIVED: {
                this.log(msg, this.hl7LogFilePattern(msg));
                break;
            }
            case MESSAGE_PROCESSED: {
                if (event.getException() == null) break;
                this.log(msg, this.hl7ErrorLogFilePattern(msg));
            }
        }
    }

    private ArchiveDeviceExtension arcdev() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    private ArchiveHL7ApplicationExtension arcHL7App(UnparsedHL7Message msg) {
        HL7Application hl7App = ((HL7DeviceExtension)this.device.getDeviceExtensionNotNull(HL7DeviceExtension.class)).getHL7Application(msg.msh().getReceivingApplicationWithFacility(), true);
        return hl7App != null ? (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class) : null;
    }

    private String hl7LogFilePattern(UnparsedHL7Message msg) {
        ArchiveHL7ApplicationExtension arcHL7App = this.arcHL7App(msg);
        return arcHL7App != null ? arcHL7App.hl7LogFilePattern() : this.arcdev().getHL7LogFilePattern();
    }

    private String hl7ErrorLogFilePattern(UnparsedHL7Message msg) {
        ArchiveHL7ApplicationExtension arcHL7App = this.arcHL7App(msg);
        return arcHL7App != null ? arcHL7App.hl7ErrorLogFilePattern() : this.arcdev().getHL7ErrorLogFilePattern();
    }

    private void log(UnparsedHL7Message msg, String dirpath) {
        if (dirpath == null) {
            return;
        }
        String hl7LogFile = this.getPath(StringUtils.replaceSystemProperties((String)dirpath), msg.getSerialNo(), msg.msh());
        try {
            Files.createDirectories(Paths.get(hl7LogFile.substring(0, hl7LogFile.lastIndexOf("/")), new String[0]), new FileAttribute[0]);
            Files.write(Files.createFile(Paths.get(hl7LogFile, new String[0]), new FileAttribute[0]), msg.data(), new OpenOption[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to write log file : {}\n", (Object)hl7LogFile, (Object)e);
        }
    }

    private String getPath(String s, int serialNo, HL7Segment msh) {
        int i = s.indexOf("${");
        if (i == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int j = -1;
        do {
            sb.append(s.substring(j + 1, i));
            j = s.indexOf(125, i + 2);
            if (j == -1) {
                j = i - 1;
                break;
            }
            String s1 = s.substring(i + 2, j);
            String dateFormat = null;
            Date date = new Date();
            if (s1.substring(0, 4).equalsIgnoreCase("date")) {
                try {
                    date = new SimpleDateFormat("yyyyMMdd").parse(msh.getField(6, null).substring(0, 8));
                }
                catch (Exception e) {
                    LOG.warn("Failed to format date : ", (Throwable)e);
                }
                dateFormat = new SimpleDateFormat(s1.substring(s1.indexOf(",") + 1)).format(date);
            }
            String prop = s1.equalsIgnoreCase("SerialNo") ? String.valueOf(serialNo) : (s1.substring(0, 4).equalsIgnoreCase("MSH-") ? msh.getField(Integer.parseInt(s1.substring(4)) - 1, null) : (s1.substring(0, 4).equalsIgnoreCase("date") ? dateFormat : null));
            String s2 = s.substring(i, j + 1);
            String val = s.startsWith("env.", i + 2) ? System.getenv(s.substring(i + 6, j)) : prop;
            sb.append(val != null ? val : s2);
        } while ((i = s.indexOf("${", j + 1)) != -1);
        sb.append(s.substring(j + 1));
        return sb.toString();
    }
}

