/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7;

import java.net.Socket;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.hl7.ERRSegment;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.hl7.service.DefaultHL7Service;
import org.dcm4che3.net.hl7.service.HL7Service;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.HL7ImportReportMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7ORUAction;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.hl7.PatientUpdateService;
import org.dcm4chee.arc.hl7.SAXTransformer;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Typed(value={HL7Service.class})
class ImportReportService
extends DefaultHL7Service {
    private final Logger LOG = LoggerFactory.getLogger(ImportReportService.class);
    private static final String ACCESSION_NUMBER = "OBR^1^18^1^1";
    private static final String MIME_TYPE_ENCODING = "OBX^1^5^1^2";
    private static final String ENCAPSULATED_DOC_DATA = "OBX^1^5^1^5";
    private static final String STUDY_UID = "OBX^1^5^1^1";
    private static final String ADMISSION_ID = "PV1^1^19^1^1";
    @Inject
    private PatientService patientService;
    @Inject
    private StoreService storeService;
    @Inject
    private ProcedureService procedureService;
    @Inject
    private CFindSCU cfindscu;

    public ImportReportService() {
        super(new String[]{"ORU^R01"});
    }

    public UnparsedHL7Message onMessage(HL7Application hl7App, Connection conn, Socket s, UnparsedHL7Message msg) throws HL7Exception {
        ArchiveHL7Message archiveHL7Message = new ArchiveHL7Message(HL7Message.makeACK((HL7Segment)msg.msh(), (String)"AA", null).getBytes(null));
        if (PatientUpdateService.updatePatient(hl7App, s, msg, this.patientService, archiveHL7Message) != null) {
            try {
                this.importReport(hl7App, s, msg);
            }
            catch (HL7Exception e) {
                throw e;
            }
            catch (Exception e) {
                throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("206^Application record locked^HL70357").setUserMessage(e.getMessage()));
            }
        }
        return archiveHL7Message;
    }

    private void importReport(HL7Application hl7App, Socket s, UnparsedHL7Message msg) throws Exception {
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        HL7ORUAction[] hl7ORUActions = arcHL7App.hl7ORUAction();
        if (hl7ORUActions.length == 0) {
            this.LOG.info("No actions configured on receive of HL7 ORU message.");
            return;
        }
        String aet = arcHL7App.getAETitle();
        if (aet == null) {
            throw new ConfigurationException("No AE Title associated with HL7 Application: " + hl7App.getApplicationName());
        }
        ApplicationEntity ae = hl7App.getDevice().getApplicationEntity(aet, true);
        if (ae == null) {
            throw new ConfigurationException("No local AE with AE Title " + aet + " associated with HL7 Application: " + hl7App.getApplicationName());
        }
        Attributes attrs = SAXTransformer.transform(msg, arcHL7App, arcHL7App.importReportTemplateURI(), tr -> arcHL7App.importReportTemplateParams().forEach(tr::setParameter));
        if (!attrs.contains(524310) && !attrs.contains(4325394)) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(MIME_TYPE_ENCODING).setUserMessage("Invalid encoding of encapsulated document in components 2 and/or 3 and/or 4 of field 5"));
        }
        if (attrs.containsValue(4325394) && !this.isEncapsulatedDoc(attrs)) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(ENCAPSULATED_DOC_DATA).setUserMessage("Encapsulated document data missing"));
        }
        if (!attrs.containsValue(3670032)) {
            this.adjustAdmissionID(arcHL7App, attrs, msg);
        }
        if (!attrs.containsValue(0x20000D)) {
            String cFindSCP;
            String accNo = attrs.getString(524368);
            List suids = this.storeService.studyIUIDsByAccessionNo(accNo);
            if (suids.isEmpty() && (cFindSCP = arcHL7App.hl7ImportReportMissingStudyIUIDCFindSCP()) != null) {
                suids = this.cfindscu.findStudiesByAccessionNumber(ae, cFindSCP, 0, accNo, new int[]{0x20000D}).stream().map(match -> match.getString(0x20000D)).collect(Collectors.toList());
            }
            switch (suids.size()) {
                case 0: {
                    this.adjustStudyIUID(attrs, arcHL7App, msg.msh());
                    break;
                }
                case 1: {
                    attrs.setString(0x20000D, VR.UI, (String)suids.get(0));
                    break;
                }
                default: {
                    this.mstore(arcHL7App, s, ae, msg, attrs, suids);
                    return;
                }
            }
        }
        if (!attrs.containsValue(524312)) {
            attrs.setString(524312, VR.UI, UIDUtils.createUID());
        }
        if (!attrs.containsValue(0x20000E)) {
            attrs.setString(0x20000E, VR.UI, UIDUtils.createNameBasedUID((byte[])attrs.getBytes(524312)));
        }
        switch (arcHL7App.hl7ImportReportAdjustIUID()) {
            case APPEND_HASH_OF_STUDY_INSTANCE_UID: {
                ImportReportService.appendToSeriesAndSOPInstanceUID(attrs, "." + ((long)attrs.getString(0x20000D).hashCode() & 0xFFFFFFFFL));
            }
        }
        this.ensureStudyInstanceUIDInPredecessors(attrs);
        this.processHL7ORUAction(arcHL7App, s, ae, msg, attrs);
    }

    private static void appendToSeriesAndSOPInstanceUID(Attributes attrs, String suffix) {
        attrs.setString(524312, VR.UI, attrs.getString(524312) + suffix);
        attrs.setString(0x20000E, VR.UI, attrs.getString(0x20000E) + suffix);
        Sequence predecessors = attrs.getSequence(4236128);
        if (predecessors != null) {
            for (Attributes predecessor : predecessors) {
                for (Attributes refSeries : predecessor.getSequence(528661)) {
                    refSeries.setString(0x20000E, VR.UI, refSeries.getString(0x20000E) + suffix);
                    for (Attributes refSOP : refSeries.getSequence(528793)) {
                        refSOP.setString(528725, VR.UI, refSOP.getString(528725) + suffix);
                    }
                }
            }
        }
    }

    private void adjustAdmissionID(ArchiveHL7ApplicationExtension arcHL7App, Attributes attrs, UnparsedHL7Message msg) throws HL7Exception {
        HL7ImportReportMissingAdmissionIDPolicy hl7ImportReportMissingAdmissionIDPolicy = arcHL7App.hl7ImportReportMissingAdmissionIDPolicy();
        HL7Segment msh = msg.msh();
        switch (hl7ImportReportMissingAdmissionIDPolicy) {
            case REJECT: {
                throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(ADMISSION_ID).setUserMessage("Missing admission ID"));
            }
            case ACCESSION_AS_ADMISSION: {
                String accNo = attrs.getString(524368);
                if (accNo == null) {
                    throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(ACCESSION_NUMBER).setUserMessage("Failed to derive Admission ID from accession number"));
                }
                attrs.setString(3670032, VR.LO, accNo);
            }
        }
    }

    private boolean isEncapsulatedDoc(Attributes attrs) {
        if (attrs.getString(4325394).equals("text/xml")) {
            String cdaTxt = attrs.getString(4235616);
            if (cdaTxt == null) {
                return false;
            }
            attrs.setBytes(4325393, VR.OB, cdaTxt.getBytes());
            attrs.remove(4235616);
        }
        return attrs.containsValue(4325393);
    }

    private void adjustStudyIUID(Attributes attrs, ArchiveHL7ApplicationExtension arcHL7App, HL7Segment msh) throws HL7Exception {
        String accessionNum = attrs.getString(524368);
        String reqProcID = attrs.getNestedDataset(4236144).getString(0x401001);
        String studyIUID = null;
        if (reqProcID != null) {
            studyIUID = UIDUtils.createNameBasedUID((byte[])reqProcID.getBytes());
            this.LOG.info("Derived StudyInstanceUID from RequestedProcedureID[={}] : {} ", (Object)reqProcID, (Object)studyIUID);
        } else {
            switch (arcHL7App.hl7ImportReportMissingStudyIUIDPolicy()) {
                case REJECT: {
                    throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(STUDY_UID).setUserMessage("Missing Study Instance UID"));
                }
                case ACCESSION_BASED: {
                    if (accessionNum == null) {
                        throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(ACCESSION_NUMBER).setUserMessage("Missing accession number"));
                    }
                    studyIUID = UIDUtils.createNameBasedUID((byte[])accessionNum.getBytes());
                    this.LOG.info("Derived StudyInstanceUID from AccessionNumber[={}] : {}", (Object)accessionNum, (Object)studyIUID);
                    break;
                }
                case GENERATE: {
                    studyIUID = UIDUtils.createUID();
                }
            }
        }
        attrs.setString(0x20000D, VR.UI, studyIUID);
    }

    private void store(ArchiveHL7ApplicationExtension arcHL7App, Socket s, ApplicationEntity ae, UnparsedHL7Message msg, Attributes attrs) throws Exception {
        try (StoreSession session = this.storeService.newStoreSession(arcHL7App.getHL7Application(), s, msg, ae);){
            StoreContext ctx = this.storeService.newStoreContext(session);
            ctx.setReceiveTransferSyntax("1.2.840.10008.1.2.1");
            this.storeService.store(ctx, attrs);
        }
    }

    private void ensureStudyInstanceUIDInPredecessors(Attributes attrs) {
        Sequence predecessors = attrs.getSequence(4236128);
        if (predecessors == null) {
            return;
        }
        for (Attributes predecessor : predecessors) {
            if (predecessor.getString(0x20000D) != null) continue;
            predecessor.setString(0x20000D, VR.UI, attrs.getStrings(0x20000D));
        }
    }

    private void processHL7ORUAction(ArchiveHL7ApplicationExtension arcHL7App, Socket s, ApplicationEntity ae, UnparsedHL7Message msg, Attributes attrs) throws Exception {
        for (HL7ORUAction action : arcHL7App.hl7ORUAction()) {
            if (action == HL7ORUAction.IMPORT_REPORT) {
                this.store(arcHL7App, s, ae, msg, attrs);
                continue;
            }
            this.procedureService.updateMWLStatus(attrs.getString(0x20000D), SPSStatus.COMPLETED);
        }
    }

    private void mstore(ArchiveHL7ApplicationExtension arcHL7App, Socket s, ApplicationEntity ae, UnparsedHL7Message msg, Attributes attrs, List<String> suids) throws Exception {
        int n = suids.size();
        Sequence seq = attrs.newSequence(4236581, n);
        for (String suid : suids) {
            seq.add(this.refStudy(suid));
        }
        for (int i = 0; i < n; ++i) {
            Attributes refStudy = seq.remove(i);
            Attributes refSeries = refStudy.getNestedDataset(528661);
            Attributes refSOP = refSeries.getNestedDataset(528793);
            attrs.setString(0x20000D, VR.UI, refStudy.getString(0x20000D));
            attrs.setString(0x20000E, VR.UI, refSeries.getString(0x20000E));
            attrs.setString(524312, VR.UI, refSOP.getString(528725));
            this.ensureStudyInstanceUIDInPredecessors(attrs);
            this.processHL7ORUAction(arcHL7App, s, ae, msg, attrs);
            seq.add(i, refStudy);
        }
    }

    private Attributes refStudy(String studyUID) {
        Attributes refStudyAttrs = new Attributes(2);
        refStudyAttrs.setString(0x20000D, VR.UI, studyUID);
        refStudyAttrs.newSequence(528661, 2).add(this.refSeries());
        return refStudyAttrs;
    }

    private Attributes refSeries() {
        Attributes refSeriesAttrs = new Attributes(2);
        refSeriesAttrs.setString(0x20000E, VR.UI, UIDUtils.createUID());
        refSeriesAttrs.newSequence(528793, 1).add(this.refSOP());
        return refSeriesAttrs;
    }

    private Attributes refSOP() {
        Attributes attrs = new Attributes(2);
        attrs.setString(528725, VR.UI, UIDUtils.createUID());
        attrs.setString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.88.11");
        return attrs;
    }
}

