/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.xdsi;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.dcmr.AcquisitionModality;
import org.dcm4che3.dcmr.AnatomicRegion;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4che3.xdsi.AssociationBuilder;
import org.dcm4che3.xdsi.AssociationType1;
import org.dcm4che3.xdsi.ClassificationBuilder;
import org.dcm4che3.xdsi.ClassificationType;
import org.dcm4che3.xdsi.DocumentRepositoryPortType;
import org.dcm4che3.xdsi.DocumentRepositoryService;
import org.dcm4che3.xdsi.ExternalIdentifierBuilder;
import org.dcm4che3.xdsi.ExternalIdentifierType;
import org.dcm4che3.xdsi.ExtrinsicObjectType;
import org.dcm4che3.xdsi.ObjectFactory;
import org.dcm4che3.xdsi.ProvideAndRegisterDocumentSetRequestType;
import org.dcm4che3.xdsi.RegistryError;
import org.dcm4che3.xdsi.RegistryObjectListType;
import org.dcm4che3.xdsi.RegistryPackageType;
import org.dcm4che3.xdsi.RegistryResponseType;
import org.dcm4che3.xdsi.SlotBuilder;
import org.dcm4che3.xdsi.SlotType1;
import org.dcm4che3.xdsi.SubmitObjectsRequest;
import org.dcm4che3.xdsi.XDSUtils;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.export.xdsi.DicomDataHandler;
import org.dcm4chee.arc.exporter.AbstractExporter;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.query.QueryService;

public class XDSiExporter
extends AbstractExporter {
    private static final String SUBMISSION_SET_ID = "SubmissionSet01";
    private static final String DOCUMENT_ID = "Document01";
    private static final ObjectFactory rimFactory = new ObjectFactory();
    private static final String DEFAULT_SOURCE_ID = "1.3.6.1.4.1.21367.2011.2.1.331";
    private static final String DEFAULT_LANGUAGE_CODE = "en-us";
    private static final Code DEFAULT_CONTENT_TYPE = new Code("UNSPECIFIED-CONTENT-TYPE", "1.3.6.1.4.1.21367.2017.3", null, "Unspecified Clinical Activity");
    private static final Code DEFAULT_TYPE_CODE = new Code("18748-4", "2.16.840.1.113883.6.1", null, "Diagnostic imaging study");
    private static final Code DEFAULT_CLASS_CODE = new Code("IMAGES", "1.3.6.1.4.1.19376.1.2.6.1", null, "Images");
    private static final Code DEFAULT_CONFIDENTIALITY_CODE = new Code("N", "2.16.840.1.113883.5.25", null, "Normal");
    private static final Code DEFAULT_MANIFEST_TITLE = new Code("113030", "DCM", null, "Manifest");
    private static final Code DEFAULT_HEALTH_CARE_FACILITY_TYPE_CODE = new Code("22232009", "2.16.840.1.113883.6.96", null, "Hospital");
    private static final Code DEFAULT_PRACTICE_SETTING_CODE = new Code("Practice-A", "1.3.6.1.4.1.21367.2017.3", null, "Radiology");
    private static final Code MANIFEST_FORMAT_CODE = new Code("1.2.840.10008.5.1.4.1.1.88.59", "1.2.840.10008.2.6.1", null, "1.2.840.10008.5.1.4.1.1.88.59");
    private final DocumentRepositoryService service;
    private final QueryService queryService;
    private final Device device;
    private final String tlsProtocol;
    private final String[] cipherSuites;
    private final boolean disableCNCheck;
    private final boolean includeModalityCodes;
    private final boolean includeAnatomicRegionCodes;
    private final boolean useProcedureCodeAsTypeCode;
    private final String manifestLogDir;
    private final String sourceId;
    private final String assigningAuthorityOfPatientID;
    private final String assigningAuthorityOfAccessionNumber;
    private final Code manifestContentType;
    private final Code manifestTitle;
    private final int manifestSeriesNumber;
    private final int manifestInstanceNumber;
    private final Date now = new Date();
    private final String repositoryURL;
    private final String languageCode;
    private final Code classCode;
    private final Code confidentialityCode;
    private final Code healthCareFacilityTypeCode;
    private final Code practiceSettingCode;
    private final Code defTypeCode;
    private final List<String> sourcePatientInfo = new ArrayList<String>();
    private final Set<String> referenceIdList = new HashSet<String>();
    private final Map<Code.Key, Code> modalityCodes = new HashMap<Code.Key, Code>();
    private final Map<Code.Key, Code> anatomicRegionCodes = new HashMap<Code.Key, Code>();
    private String submissionSetUID;
    private Attributes manifest;
    private String documentUID;
    private String patientId;
    private String sourcePatientId;
    private Code typeCode;
    private int id;

    public XDSiExporter(ExporterDescriptor descriptor, DocumentRepositoryService service, QueryService queryService, Device device) {
        super(descriptor);
        this.service = service;
        this.queryService = queryService;
        this.device = device;
        this.repositoryURL = descriptor.getExportURI().getSchemeSpecificPart();
        this.disableCNCheck = Boolean.parseBoolean(descriptor.getProperty("TLS.disableCNCheck", null));
        this.tlsProtocol = descriptor.getProperty("TLS.protocol", null);
        this.cipherSuites = StringUtils.split((String)descriptor.getProperty("TLS.cipherSuites", null), (char)',');
        this.manifestTitle = this.getCodeProperty("Manifest.title", DEFAULT_MANIFEST_TITLE);
        this.manifestSeriesNumber = Integer.parseInt(descriptor.getProperty("Manifest.seriesNumber", "0"));
        this.manifestInstanceNumber = Integer.parseInt(descriptor.getProperty("Manifest.instanceNumber", "0"));
        this.manifestLogDir = descriptor.getProperty("Manifest.logDir", null);
        this.patientId = descriptor.getProperty("XDSSubmissionSet.patientId", null);
        this.assigningAuthorityOfPatientID = descriptor.getProperty("AssigningAuthority.patientId", null);
        this.assigningAuthorityOfAccessionNumber = descriptor.getProperty("AssigningAuthority.accessionNumber", null);
        this.sourceId = descriptor.getProperty("XDSSubmissionSet.sourceId", DEFAULT_SOURCE_ID);
        this.manifestContentType = this.getCodeProperty("XDSSubmissionSet.contentType", DEFAULT_CONTENT_TYPE);
        this.defTypeCode = this.getCodeProperty("DocumentEntry.typeCode", DEFAULT_TYPE_CODE);
        this.languageCode = descriptor.getProperty("DocumentEntry.languageCode", DEFAULT_LANGUAGE_CODE);
        this.classCode = this.getCodeProperty("DocumentEntry.classCode", DEFAULT_CLASS_CODE);
        this.confidentialityCode = this.getCodeProperty("DocumentEntry.confidentialityCode", DEFAULT_CONFIDENTIALITY_CODE);
        this.healthCareFacilityTypeCode = this.getCodeProperty("DocumentEntry.healthCareFacilityTypeCode", DEFAULT_HEALTH_CARE_FACILITY_TYPE_CODE);
        this.practiceSettingCode = this.getCodeProperty("DocumentEntry.practiceSettingCode", DEFAULT_PRACTICE_SETTING_CODE);
        this.includeModalityCodes = Boolean.parseBoolean(descriptor.getProperty("DocumentEntry.includeModalityCodes", null));
        this.includeAnatomicRegionCodes = Boolean.parseBoolean(descriptor.getProperty("DocumentEntry.includeAnatomicRegionCodes", null));
        this.useProcedureCodeAsTypeCode = Boolean.parseBoolean(descriptor.getProperty("DocumentEntry.useProcedureCodeAsTypeCode", null));
    }

    private Code getCodeProperty(String name, Code defValue) {
        String value = this.descriptor.getProperty(name, null);
        return value != null ? new Code(value) : defValue;
    }

    public Outcome export(ExportContext ctx) throws Exception {
        ApplicationEntity ae = this.device.getApplicationEntity(ctx.getAETitle(), true);
        ArrayList<Attributes> seriesAttrs = new ArrayList<Attributes>();
        this.manifest = this.queryService.createXDSiManifest(ae, ctx.getStudyInstanceUID(), this.descriptor.getRetrieveAETitles(), this.descriptor.getRetrieveLocationUID(), this.manifestTitle, this.manifestSeriesNumber, this.manifestInstanceNumber, seriesAttrs);
        this.documentUID = this.manifest.getString(524312);
        this.submissionSetUID = UIDUtils.createUID();
        this.sourcePatientId = this.adjustSourcePatientId();
        if (this.patientId == null) {
            this.patientId = this.sourcePatientId;
        }
        this.typeCode = this.typeCodeOf(this.manifest);
        this.initSourcePatientInfo();
        this.referenceIdList.add(this.manifest.getString(0x20000D) + "^^^^urn:ihe:iti:xds:2016:studyInstanceUID");
        this.addAccessionNumber(this.manifest);
        this.processSeriesAttrs(seriesAttrs);
        ctx.setXDSiManifest(this.manifest);
        ctx.setSubmissionSetUID(this.submissionSetUID);
        try {
            if (this.manifestLogDir != null) {
                File logDir = new File(this.manifestLogDir);
                logDir.mkdirs();
                try (DicomOutputStream out = new DicomOutputStream(new File(logDir, this.documentUID));){
                    out.writeDataset(this.manifest.createFileMetaInformation("1.2.840.10008.1.2.1"), this.manifest);
                }
            }
            RegistryResponseType rsp = this.port().documentRepositoryProvideAndRegisterDocumentSetB(this.createRequest());
            ctx.setXDSiRegistryResponse(rsp);
            switch (rsp.getStatus()) {
                case "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success": {
                    return new Outcome(Task.Status.COMPLETED, "Provide and Register Study[" + ctx.getStudyInstanceUID() + "] in SubmissionSet[" + this.submissionSetUID + "] @ " + this.repositoryURL + " successful");
                }
                case "urn:ihe:iti:2007:ResponseStatusType:PartialSuccess": {
                    return new Outcome(Task.Status.WARNING, "Provide and Register Study[" + ctx.getStudyInstanceUID() + "] in SubmissionSet[" + this.submissionSetUID + "] @ " + this.repositoryURL + " partial successful - " + this.getRegistryErrorMessage(rsp));
                }
            }
            throw new Exception("Provide and Register Study[" + ctx.getStudyInstanceUID() + "] @ " + this.repositoryURL + " failed - " + this.getRegistryErrorMessage(rsp));
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            throw e;
        }
    }

    private Code typeCodeOf(Attributes manifest) {
        Attributes codeItem;
        if (this.useProcedureCodeAsTypeCode && (codeItem = manifest.getNestedDataset(528434)) != null) {
            return new Code(codeItem);
        }
        return this.defTypeCode;
    }

    private void addAccessionNumber(Attributes attrs) {
        IDWithIssuer accno = IDWithIssuer.valueOf((Attributes)attrs, (int)524368, (int)524369);
        if (accno != null) {
            Issuer issuer = accno.getIssuer();
            String uid = issuer != null && "ISO".equals(issuer.getUniversalEntityIDType()) ? issuer.getUniversalEntityID() : this.assigningAuthorityOfAccessionNumber;
            this.referenceIdList.add(uid == null ? accno.getID() + "^^^^urn:ihe:iti:xds:2013:accession" : accno.getID() + "^^^&" + uid + "&ISO^urn:ihe:iti:xds:2013:accession");
        }
    }

    private void processSeriesAttrs(Collection<Attributes> seriesAttrs) {
        for (Attributes attrs : seriesAttrs) {
            Sequence reqAttrsSeq;
            Code modalityCode;
            if (this.includeModalityCodes && (modalityCode = AcquisitionModality.codeOf((String)attrs.getString(524384))) != null) {
                this.modalityCodes.put(modalityCode.key(), modalityCode);
            }
            if (this.includeAnatomicRegionCodes) {
                Code anatomicRegionCode;
                Attributes anatomicRegionCodeItem = attrs.getNestedDataset(533016);
                Code code = anatomicRegionCode = anatomicRegionCodeItem != null ? new Code(anatomicRegionCodeItem) : AnatomicRegion.codeOf((String)attrs.getString(1572885));
                if (anatomicRegionCode != null) {
                    this.anatomicRegionCodes.put(anatomicRegionCode.key(), anatomicRegionCode);
                }
            }
            if ((reqAttrsSeq = attrs.getSequence(4194933)) == null) continue;
            for (Attributes reqAttrs : reqAttrsSeq) {
                this.addAccessionNumber(reqAttrs);
            }
        }
    }

    private String getRegistryErrorMessage(RegistryResponseType rsp) {
        StringBuilder sb = null;
        for (RegistryError registryError : rsp.getRegistryErrorList().getRegistryError()) {
            if (sb == null) {
                sb = new StringBuilder(registryError.getCodeContext());
                continue;
            }
            sb.append(", ").append(registryError.getCodeContext());
        }
        return sb != null ? sb.toString() : "";
    }

    private String adjustSourcePatientId() {
        String iuid;
        IDWithIssuer pid = IDWithIssuer.pidOf((Attributes)this.manifest);
        Issuer issuer = pid.getIssuer();
        String string = iuid = issuer != null && "ISO".equals(issuer.getUniversalEntityIDType()) ? issuer.getUniversalEntityID() : this.assigningAuthorityOfPatientID;
        if (iuid != null) {
            pid.setIssuer(new Issuer(null, iuid, "ISO"));
            pid.exportPatientIDWithIssuer(this.manifest);
        }
        return pid.toString();
    }

    private DocumentRepositoryPortType port() throws Exception {
        DocumentRepositoryPortType port = this.service.getDocumentRepositoryPortSoap12(new WebServiceFeature[]{new AddressingFeature(true, true), new MTOMFeature()});
        XDSUtils.ensureMustUnderstandHandler((Object)port);
        XDSUtils.setEndpointAddress((Object)port, (String)this.repositoryURL);
        if (this.repositoryURL.startsWith("https")) {
            XDSUtils.setTlsClientParameters((Object)port, (TLSClientParameters)this.tlsClientParams());
        }
        return port;
    }

    private TLSClientParameters tlsClientParams() throws GeneralSecurityException, IOException {
        TLSClientParameters params = new TLSClientParameters();
        params.setKeyManagers(this.device.keyManagers());
        params.setTrustManagers(this.device.trustManagers());
        params.setSecureSocketProtocol(this.tlsProtocol);
        for (String cipherSuite : this.cipherSuites) {
            params.getCipherSuites().add(cipherSuite.trim());
        }
        params.setDisableCNCheck(this.disableCNCheck);
        return params;
    }

    private ProvideAndRegisterDocumentSetRequestType createRequest() {
        ProvideAndRegisterDocumentSetRequestType pnrReq = new ProvideAndRegisterDocumentSetRequestType();
        pnrReq.setSubmitObjectsRequest(this.createSubmitObjectsRequest());
        pnrReq.getDocument().add(this.createDocument());
        return pnrReq;
    }

    private SubmitObjectsRequest createSubmitObjectsRequest() {
        SubmitObjectsRequest sor = new SubmitObjectsRequest();
        sor.setRegistryObjectList(this.createRegistryObjectList());
        return sor;
    }

    private RegistryObjectListType createRegistryObjectList() {
        RegistryObjectListType registryObjectList = new RegistryObjectListType();
        List identifiable = registryObjectList.getIdentifiable();
        identifiable.add(rimFactory.createExtrinsicObject(this.createDocumentEntry()));
        identifiable.add(rimFactory.createRegistryPackage(this.createSubmissionSet()));
        identifiable.add(rimFactory.createClassification(this.createSubmissionSetClassification()));
        identifiable.add(rimFactory.createAssociation(this.createAssociation()));
        return registryObjectList;
    }

    private String nextId() {
        return "id_" + ++this.id;
    }

    private ExtrinsicObjectType createDocumentEntry() {
        ExtrinsicObjectType docEntry = new ExtrinsicObjectType();
        docEntry.setId(DOCUMENT_ID);
        docEntry.setObjectType("urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1");
        docEntry.setMimeType("application/dicom");
        this.createDocumentEntrySlots(docEntry.getSlot());
        this.createDocumentEntryClassifications(docEntry.getClassification());
        this.createDocumentEntryExternalIdentifiers(docEntry.getExternalIdentifier());
        return docEntry;
    }

    private void createDocumentEntrySlots(List<SlotType1> list) {
        list.add(new SlotBuilder("creationTime").valueDTM(this.now).build());
        list.add(new SlotBuilder("serviceStartTime").valueDTM(this.manifest.getDate(2251937253163056L, this.now)).build());
        list.add(new SlotBuilder("languageCode").valueList(this.languageCode).build());
        list.add(new SlotBuilder("sourcePatientId").valueList(this.sourcePatientId).build());
        list.add(new SlotBuilder("sourcePatientInfo").valueList(this.sourcePatientInfo).build());
        list.add(new SlotBuilder("urn:ihe:iti:xds:2013:referenceIdList").valueList(this.referenceIdList).build());
    }

    private void createDocumentEntryClassifications(List<ClassificationType> list) {
        list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a").classifiedObject(DOCUMENT_ID).code(this.classCode).build());
        list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f").classifiedObject(DOCUMENT_ID).code(this.confidentialityCode).build());
        list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d").classifiedObject(DOCUMENT_ID).code(MANIFEST_FORMAT_CODE).build());
        list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1").classifiedObject(DOCUMENT_ID).code(this.healthCareFacilityTypeCode).build());
        list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead").classifiedObject(DOCUMENT_ID).code(this.practiceSettingCode).build());
        list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983").classifiedObject(DOCUMENT_ID).code(this.typeCode).build());
        for (Code code : this.modalityCodes.values()) {
            list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4").classifiedObject(DOCUMENT_ID).code(code).build());
        }
        for (Code code : this.anatomicRegionCodes.values()) {
            list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4").classifiedObject(DOCUMENT_ID).code(code).build());
        }
    }

    private void createDocumentEntryExternalIdentifiers(List<ExternalIdentifierType> list) {
        list.add(new ExternalIdentifierBuilder(this.nextId()).identificationScheme("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab").registryObject(DOCUMENT_ID).name("XDSDocumentEntry.uniqueId").value(this.documentUID).build());
        list.add(new ExternalIdentifierBuilder(this.nextId()).identificationScheme("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427").registryObject(DOCUMENT_ID).name("XDSDocumentEntry.patientId").value(this.patientId).build());
    }

    private void initSourcePatientInfo() {
        this.sourcePatientInfo.add("PID-3|" + this.sourcePatientId);
        XDSiExporter.addIfNotNullTo("PID-5|", this.manifest.getString(0x100010), this.sourcePatientInfo);
        XDSiExporter.addIfNotNullTo("PID-7|", this.manifest.getString(0x100030), this.sourcePatientInfo);
        XDSiExporter.addIfNotNullTo("PID-8|", this.manifest.getString(0x100040), this.sourcePatientInfo);
    }

    private static void addIfNotNullTo(String prefix, String value, Collection<String> list) {
        if (value != null) {
            list.add(prefix + value);
        }
    }

    private RegistryPackageType createSubmissionSet() {
        RegistryPackageType submissionSet = new RegistryPackageType();
        submissionSet.setId(SUBMISSION_SET_ID);
        this.createSubmissionSetSlots(submissionSet.getSlot());
        this.createSubmissionSetClassifications(submissionSet.getClassification());
        this.createSubmissionSetExternalIdentifiers(submissionSet.getExternalIdentifier());
        return submissionSet;
    }

    private void createSubmissionSetSlots(List<SlotType1> list) {
        list.add(new SlotBuilder("submissionTime").valueDTM(this.now).build());
    }

    private void createSubmissionSetClassifications(List<ClassificationType> list) {
        list.add(new ClassificationBuilder(this.nextId()).classificationScheme("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500").classifiedObject(SUBMISSION_SET_ID).code(this.manifestContentType).build());
    }

    private void createSubmissionSetExternalIdentifiers(List<ExternalIdentifierType> list) {
        list.add(new ExternalIdentifierBuilder(this.nextId()).identificationScheme("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8").registryObject(SUBMISSION_SET_ID).name("XDSSubmissionSet.uniqueId").value(this.submissionSetUID).build());
        list.add(new ExternalIdentifierBuilder(this.nextId()).identificationScheme("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446").registryObject(SUBMISSION_SET_ID).name("XDSSubmissionSet.patientId").value(this.patientId).build());
        list.add(new ExternalIdentifierBuilder(this.nextId()).identificationScheme("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832").registryObject(SUBMISSION_SET_ID).name("XDSSubmissionSet.sourceId").value(this.sourceId).build());
    }

    private ClassificationType createSubmissionSetClassification() {
        return new ClassificationBuilder(this.nextId()).classificationNode("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd").classifiedObject(SUBMISSION_SET_ID).build();
    }

    private AssociationType1 createAssociation() {
        return new AssociationBuilder(this.nextId()).associationType("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember").sourceObject(SUBMISSION_SET_ID).targetObject(DOCUMENT_ID).submissionSetStatus("Original").build();
    }

    private ProvideAndRegisterDocumentSetRequestType.Document createDocument() {
        ProvideAndRegisterDocumentSetRequestType.Document doc = new ProvideAndRegisterDocumentSetRequestType.Document();
        doc.setId(DOCUMENT_ID);
        doc.setValue((DataHandler)new DicomDataHandler(this.manifest));
        return doc;
    }
}

