/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.stow;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.export.stow.StowExporter;
import org.dcm4chee.arc.exporter.Exporter;
import org.dcm4chee.arc.exporter.ExporterProvider;
import org.dcm4chee.arc.qmgt.TaskCanceled;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.stow.client.StowClient;
import org.dcm4chee.arc.stow.client.StowTask;

@ApplicationScoped
@Named(value="stow")
public class StowExporterProvider
implements ExporterProvider {
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private StowClient stowClient;
    private final Map<Long, StowTask> stowTaskMap = Collections.synchronizedMap(new HashMap());

    public Exporter getExporter(ExporterDescriptor descriptor) {
        return new StowExporter(descriptor, this.retrieveService, this.stowClient, this.stowTaskMap);
    }

    public void cancelStowTask(@Observes TaskCanceled event) {
        StowTask stowTask = this.stowTaskMap.get(event.task.getPk());
        if (stowTask != null) {
            stowTask.cancel();
        }
    }
}

