/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.stow;

import java.util.Map;
import org.dcm4che3.net.WebApplication;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.AbstractExporter;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.stow.client.StowClient;
import org.dcm4chee.arc.stow.client.StowTask;

public class StowExporter
extends AbstractExporter {
    private final RetrieveService retrieveService;
    private final StowClient stowClient;
    private final String destWebAppName;
    private final Map<Long, StowTask> stowTaskMap;

    public StowExporter(ExporterDescriptor descriptor, RetrieveService retrieveService, StowClient stowClient, Map<Long, StowTask> stowTaskMap) {
        super(descriptor);
        this.retrieveService = retrieveService;
        this.stowClient = stowClient;
        this.destWebAppName = descriptor.getExportURI().getSchemeSpecificPart();
        this.stowTaskMap = stowTaskMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outcome export(ExportContext exportContext) throws Exception {
        RetrieveContext retrieveContext = this.retrieveService.newRetrieveContextSTOW(exportContext.getAETitle(), exportContext.getStudyInstanceUID(), exportContext.getSeriesInstanceUID(), exportContext.getSopInstanceUID(), this.destWebAppName);
        retrieveContext.setHttpServletRequestInfo(exportContext.getHttpServletRequestInfo());
        if (!this.retrieveService.calculateMatches(retrieveContext)) {
            return new Outcome(Task.Status.WARNING, StowExporter.noMatches((ExportContext)exportContext));
        }
        if (!retrieveContext.getDestinationWebApp().containsServiceClass(WebApplication.ServiceClass.STOW_RS)) {
            return new Outcome(Task.Status.WARNING, "Destination webapp " + this.destWebAppName + " is not configured for STOW_RS web service");
        }
        Long taskPK = exportContext.getTaskPK();
        StowTask stowTask = this.stowClient.newStowTask(retrieveContext);
        this.stowTaskMap.put(taskPK, stowTask);
        try {
            stowTask.run();
            Outcome outcome = new Outcome(retrieveContext.remaining() > 0 ? Task.Status.CANCELED : (retrieveContext.failed() > 0 ? (retrieveContext.missing() > 0 ? Task.Status.FAILED : Task.Status.WARNING) : Task.Status.COMPLETED), StowExporter.outcomeMessage((ExportContext)exportContext, (RetrieveContext)retrieveContext, (Object)this.destWebAppName));
            return outcome;
        }
        finally {
            this.stowTaskMap.remove(taskPK);
        }
    }
}

