/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4chee.arc.entity.PersonName;

@Entity
@Table(name="ups_req", indexes={@Index(columnList="accession_no"), @Index(columnList="req_service"), @Index(columnList="req_proc_id"), @Index(columnList="study_iuid")})
public class UPSRequest {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="accno_entity_id")
    private String accessionNumberLocalNamespaceEntityID;
    @Column(name="accno_entity_uid")
    private String accessionNumberUniversalEntityID;
    @Column(name="accno_entity_uid_type")
    private String accessionNumberUniversalEntityIDType;
    @Basic(optional=false)
    @Column(name="study_iuid")
    private String studyInstanceUID;
    @Basic(optional=false)
    @Column(name="req_proc_id")
    private String requestedProcedureID;
    @Basic(optional=false)
    @Column(name="req_service")
    private String requestingService;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="req_phys_name_fk")
    private PersonName requestingPhysician;

    public UPSRequest() {
    }

    public UPSRequest(Attributes attrs, FuzzyStr fuzzyStr) {
        this.studyInstanceUID = attrs.getString(0x20000D, "*");
        this.accessionNumber = attrs.getString(524368, "*");
        Issuer issuer = Issuer.valueOf((Attributes)attrs.getNestedDataset(524369));
        if (issuer != null) {
            this.accessionNumberLocalNamespaceEntityID = issuer.getLocalNamespaceEntityID();
            this.accessionNumberUniversalEntityID = issuer.getUniversalEntityID();
            this.accessionNumberUniversalEntityIDType = issuer.getUniversalEntityIDType();
        } else {
            this.accessionNumberLocalNamespaceEntityID = null;
            this.accessionNumberUniversalEntityID = null;
            this.accessionNumberUniversalEntityIDType = null;
        }
        this.requestedProcedureID = attrs.getString(0x401001, "*");
        this.requestingService = attrs.getString(3280947, "*");
        this.requestingPhysician = PersonName.valueOf(attrs.getString(3280946), fuzzyStr, null);
    }

    public long getPk() {
        return this.pk;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public String getRequestingService() {
        return this.requestingService;
    }

    public PersonName getRequestingPhysician() {
        return this.requestingPhysician;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public String toString() {
        return "UPSRequest[pk=" + this.pk + ", suid=" + this.studyInstanceUID + ", accno=" + this.accessionNumber + ", rpid=" + this.requestedProcedureID + "]";
    }
}

