/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

@NamedQueries(value={@NamedQuery(name="StgCmtResult.findByTransactionUID", query="select result from StgCmtResult result where result.transactionUID = ?1")})
@Entity
@Table(name="stgcmt_result", uniqueConstraints={@UniqueConstraint(columnNames={"transaction_uid"})}, indexes={@Index(columnList="updated_time"), @Index(columnList="device_name"), @Index(columnList="exporter_id"), @Index(columnList="task_fk"), @Index(columnList="batch_id"), @Index(columnList="study_iuid"), @Index(columnList="stgcmt_status")})
public class StgCmtResult {
    public static final String FIND_BY_TRANSACTION_UID = "StgCmtResult.findByTransactionUID";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic(optional=false)
    @Column(name="transaction_uid", updatable=false)
    private String transactionUID;
    @Basic(optional=false)
    @Column(name="device_name", updatable=false)
    private String deviceName;
    @Basic
    @Column(name="exporter_id", updatable=false)
    private String exporterID;
    @Column(name="task_fk")
    private Long taskPK;
    @Column(name="batch_id", updatable=false)
    private String batchID;
    @Basic(optional=false)
    @Column(name="study_iuid", updatable=false)
    private String studyInstanceUID;
    @Basic
    @Column(name="series_iuid", updatable=false)
    private String seriesInstanceUID;
    @Basic
    @Column(name="sop_iuid", updatable=false)
    private String sopInstanceUID;
    @Column(name="num_instances", updatable=false)
    private int numberOfInstances;
    @Basic(optional=false)
    @Column(name="stgcmt_status")
    private Status status;
    @Column(name="num_failures")
    private int numberOfFailures;

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public long getPk() {
        return this.pk;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getExporterID() {
        return this.exporterID;
    }

    public void setExporterID(String exporterID) {
        this.exporterID = exporterID;
    }

    public Long getTaskPK() {
        return this.taskPK;
    }

    public void setTaskPK(Long taskPK) {
        this.taskPK = taskPK;
    }

    public String getBatchID() {
        return this.batchID;
    }

    public void setBatchID(String batchID) {
        this.batchID = batchID;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String studyInstanceUID) {
        this.studyInstanceUID = studyInstanceUID;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public void setSeriesInstanceUID(String seriesInstanceUID) {
        this.seriesInstanceUID = seriesInstanceUID;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public void setSopInstanceUID(String sopInstanceUID) {
        this.sopInstanceUID = sopInstanceUID;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getTransactionUID() {
        return this.transactionUID;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public void setStgCmtRequest(Attributes actionInfo) {
        this.transactionUID = actionInfo.getString(528789);
        this.numberOfInstances = actionInfo.getSequence(528793).size();
        this.status = Status.PENDING;
    }

    public void setStgCmtResult(Attributes eventInfo) {
        Sequence failedSeq = eventInfo.getSequence(528792);
        int n = this.numberOfFailures = failedSeq != null ? failedSeq.size() : 0;
        this.status = failedSeq == null ? Status.COMPLETED : (this.numberOfFailures < this.numberOfInstances ? Status.WARNING : Status.FAILED);
    }

    public static enum Status {
        PENDING,
        COMPLETED,
        WARNING,
        FAILED;

    }
}

