/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.ValueSelector;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.ShowPatientInfo;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.BlobCorruptedException;
import org.dcm4chee.arc.entity.PatientID;
import org.dcm4chee.arc.entity.PersonName;

@NamedQueries(value={@NamedQuery(name="Patient.findByPatientID", query="select p from Patient p join fetch p.patientID pid where pid.id = ?1 order by p.pk"), @NamedQuery(name="Patient.findByPatientIDEager", query="select p from Patient p join fetch p.patientID pid left join fetch p.patientName join fetch p.attributesBlob where pid.id = ?1 order by p.pk"), @NamedQuery(name="Patient.findByMergedWith", query="select p from Patient p where p.mergedWith = ?1"), @NamedQuery(name="Patient.CountByMergedWith", query="select count(p) from Patient p where p.mergedWith = ?1"), @NamedQuery(name="Patient.findByVerificationStatus", query="select new org.dcm4chee.arc.entity.Patient$IDWithPkAndVerificationStatus(p.patientID, p.pk, p.verificationStatus) from Patient p where p.verificationStatus = ?1 order by p.pk"), @NamedQuery(name="Patient.findByVerificationStatusAndTime", query="select new org.dcm4chee.arc.entity.Patient$IDWithPkAndVerificationStatus(p.patientID, p.pk, p.verificationStatus) from Patient p where p.verificationStatus = ?1 and p.verificationTime < ?2 order by p.verificationTime"), @NamedQuery(name="Patient.findByVerificationStatusAndTimeAndMaxRetries", query="select new org.dcm4chee.arc.entity.Patient$IDWithPkAndVerificationStatus(p.patientID, p.pk, p.verificationStatus) from Patient p where p.verificationStatus = ?1 and p.verificationTime < ?2 and p.failedVerifications <= ?3 order by p.verificationTime"), @NamedQuery(name="Patient.ClaimPatientVerification", query="update Patient p set p.verificationStatus = ?3 where p.pk = ?1 and p.verificationStatus = ?2")})
@Entity
@Table(name="patient", uniqueConstraints={@UniqueConstraint(columnNames={"patient_id_fk"})}, indexes={@Index(columnList="verification_status"), @Index(columnList="verification_time"), @Index(columnList="num_studies"), @Index(columnList="pat_birthdate"), @Index(columnList="pat_sex"), @Index(columnList="pat_custom1"), @Index(columnList="pat_custom2"), @Index(columnList="pat_custom3")})
public class Patient {
    public static final String FIND_BY_PATIENT_ID = "Patient.findByPatientID";
    public static final String FIND_BY_PATIENT_ID_EAGER = "Patient.findByPatientIDEager";
    public static final String FIND_BY_MERGED_WITH = "Patient.findByMergedWith";
    public static final String COUNT_BY_MERGED_WITH = "Patient.CountByMergedWith";
    public static final String FIND_BY_VERIFICATION_STATUS = "Patient.findByVerificationStatus";
    public static final String FIND_BY_VERIFICATION_STATUS_AND_TIME = "Patient.findByVerificationStatusAndTime";
    public static final String FIND_BY_VERIFICATION_STATUS_AND_TIME_AND_MAX_RETRIES = "Patient.findByVerificationStatusAndTimeAndMaxRetries";
    public static final String CLAIM_PATIENT_VERIFICATION = "Patient.ClaimPatientVerification";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_time")
    private Date updatedTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="verification_time")
    private Date verificationTime;
    @Basic(optional=false)
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="verification_status")
    private VerificationStatus verificationStatus = VerificationStatus.UNVERIFIED;
    @Basic(optional=false)
    @Column(name="failed_verifications")
    private int failedVerifications;
    @Basic(optional=false)
    @Column(name="pat_birthdate")
    private String patientBirthDate;
    @Basic(optional=false)
    @Column(name="pat_sex")
    private String patientSex;
    @Basic(optional=false)
    @Column(name="pat_custom1")
    private String patientCustomAttribute1;
    @Basic(optional=false)
    @Column(name="pat_custom2")
    private String patientCustomAttribute2;
    @Basic(optional=false)
    @Column(name="pat_custom3")
    private String patientCustomAttribute3;
    @Basic(optional=false)
    @Column(name="num_studies")
    private int numberOfStudies;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, optional=false)
    @JoinColumn(name="dicomattrs_fk")
    private AttributesBlob attributesBlob;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pat_name_fk")
    private PersonName patientName;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="resp_person_fk")
    private PersonName responsiblePerson;
    @ManyToOne
    @JoinColumn(name="merge_fk")
    private Patient mergedWith;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="patient_id_fk")
    private PatientID patientID;
    private static ShowPatientInfo showPatientInfo = ShowPatientInfo.PLAIN_TEXT;

    public static ShowPatientInfo getShowPatientInfo() {
        return showPatientInfo;
    }

    public static void setShowPatientInfo(ShowPatientInfo showPatientInfo) {
        Patient.showPatientInfo = showPatientInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Patient[pk=").append(this.pk);
        if (showPatientInfo == ShowPatientInfo.HASH_NAME_AND_ID && this.patientID != null) {
            sb.append(", id=#").append(this.patientID.toString().hashCode());
        } else {
            sb.append(", id=").append(this.patientID);
        }
        if (showPatientInfo != ShowPatientInfo.PLAIN_TEXT && this.patientName != null) {
            sb.append(", name=#").append(this.patientName.toString().hashCode());
        } else {
            sb.append(", name=").append(this.patientName);
        }
        sb.append(']');
        return sb.toString();
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public long getPk() {
        return this.pk;
    }

    public long getVersion() {
        return this.version;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public Date getVerificationTime() {
        return this.verificationTime;
    }

    public void setVerificationTime(Date verificationTime) {
        this.verificationTime = verificationTime;
    }

    public VerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(VerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public int getFailedVerifications() {
        return this.failedVerifications;
    }

    public void setFailedVerifications(int failedVerifications) {
        this.failedVerifications = failedVerifications;
    }

    public void resetFailedVerifications() {
        this.failedVerifications = 0;
    }

    public void incrementFailedVerifications() {
        ++this.failedVerifications;
    }

    public String getPatientBirthDate() {
        return this.patientBirthDate;
    }

    public String getPatientSex() {
        return this.patientSex;
    }

    public String getPatientCustomAttribute1() {
        return this.patientCustomAttribute1;
    }

    public String getPatientCustomAttribute2() {
        return this.patientCustomAttribute2;
    }

    public String getPatientCustomAttribute3() {
        return this.patientCustomAttribute3;
    }

    public int getNumberOfStudies() {
        return this.numberOfStudies;
    }

    public void setNumberOfStudies(int numberOfStudies) {
        this.numberOfStudies = numberOfStudies;
    }

    public void incrementNumberOfStudies() {
        ++this.numberOfStudies;
    }

    public void decrementNumberOfStudies() {
        this.numberOfStudies = Math.max(this.numberOfStudies - 1, 0);
    }

    public Patient getMergedWith() {
        return this.mergedWith;
    }

    public void setMergedWith(Patient mergedWith) {
        this.mergedWith = mergedWith;
    }

    public PersonName getPatientName() {
        return this.patientName;
    }

    public PatientID getPatientID() {
        return this.patientID;
    }

    public void setPatientID(PatientID patientID) {
        this.patientID = patientID;
    }

    public PersonName getResponsiblePerson() {
        return this.responsiblePerson;
    }

    public Attributes getAttributes() throws BlobCorruptedException {
        return this.attributesBlob.getAttributes();
    }

    public byte[] getEncodedAttributes() throws BlobCorruptedException {
        return this.attributesBlob.getEncodedAttributes();
    }

    public void setAttributes(Attributes attrs, AttributeFilter filter, boolean withOriginalAttributesSequence, FuzzyStr fuzzyStr) {
        this.patientName = PersonName.valueOf(attrs.getString(0x100010), fuzzyStr, this.patientName);
        this.patientBirthDate = attrs.getString(0x100030, "*");
        this.patientSex = attrs.getString(0x100040, "*").toUpperCase();
        this.patientCustomAttribute1 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute1(), (String)"*");
        this.patientCustomAttribute2 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute2(), (String)"*");
        this.patientCustomAttribute3 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute3(), (String)"*");
        Attributes blobAttrs = new Attributes(attrs, filter.getSelection(withOriginalAttributesSequence));
        if (this.attributesBlob == null) {
            this.attributesBlob = new AttributesBlob(blobAttrs);
        } else {
            this.attributesBlob.setAttributes(blobAttrs);
        }
        this.responsiblePerson = PersonName.valueOf(attrs.getString(1057431), fuzzyStr, this.responsiblePerson);
        this.updatedTime = new Date();
    }

    public static class IDWithPkAndVerificationStatus {
        public final IDWithIssuer idWithIssuer;
        public final Long pk;
        public final VerificationStatus verificationStatus;

        public IDWithPkAndVerificationStatus(PatientID patientID, Long pk, VerificationStatus verificationStatus) {
            this.idWithIssuer = patientID.getIDWithIssuer();
            this.pk = pk;
            this.verificationStatus = verificationStatus;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("Patient[pk=").append(this.pk);
            if (showPatientInfo != ShowPatientInfo.HASH_NAME_AND_ID) {
                sb.append(", id=").append(this.idWithIssuer);
            }
            sb.append(']');
            return sb.toString();
        }
    }

    public static enum VerificationStatus {
        UNVERIFIED,
        VERIFIED,
        NOT_FOUND,
        VERIFICATION_FAILED,
        IN_PROCESS;

    }
}

