/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.UIDMap;

@Entity
@Table(name="location", indexes={@Index(columnList="storage_id,status"), @Index(columnList="multi_ref")})
@NamedQueries(value={@NamedQuery(name="Location.FindByStorageIDAndStatus", query="select l from Location l where l.storageID=?1 and l.status=?2"), @NamedQuery(name="Location.FindByStudyPk", query="select l from Location l join fetch l.instance inst where inst.series.study.pk=?1"), @NamedQuery(name="Location.FindBySeriesPk", query="select l from Location l where l.instance.series.pk=?1"), @NamedQuery(name="Location.FindByStudyPkAndStorageIDs", query="select l from Location l join fetch l.instance inst where inst.series.study.pk=?1 and l.storageID in ?2"), @NamedQuery(name="Location.FindBySOPIUIDAndStorageID", query="select l from Location l where l.instance.sopInstanceUID=?1 and l.storageID=?2"), @NamedQuery(name="Location.InstancePksByStudyPkAndStorageIDs", query="select l.instance.pk from Location l where l.instance.series.study.pk=?1 and l.storageID in ?2"), @NamedQuery(name="Location.InstancePksByStudyPkAndStorageIDsAndStatus", query="select l.instance.pk from Location l where l.instance.series.study.pk=?1 and l.storageID in ?2 and l.status=?3"), @NamedQuery(name="Location.StorageIDsByStudyPkAndObjectType", query="select distinct l.storageID from Location l where l.instance.series.study.pk=?1 and l.objectType=?2"), @NamedQuery(name="Location.FindByRejectionCode", query="select l from Location l join fetch l.instance i join i.series ser join ser.study st where exists (select ri from RejectedInstance ri where ri.studyInstanceUID = st.studyInstanceUID and ri.seriesInstanceUID = ser.seriesInstanceUID and ri.sopInstanceUID = i.sopInstanceUID and ri.rejectionNoteCode = ?1)"), @NamedQuery(name="Location.FindByConceptNameCode", query="select l from Location l join fetch l.instance i where i.conceptNameCode=?1"), @NamedQuery(name="Location.FindByRejectionCodeBefore", query="select l from Location l join fetch l.instance i join i.series ser join ser.study st where exists (select ri from RejectedInstance ri where ri.studyInstanceUID = st.studyInstanceUID and ri.seriesInstanceUID = ser.seriesInstanceUID and ri.sopInstanceUID = i.sopInstanceUID and ri.rejectionNoteCode = ?1 and ri.createdTime < ?2)"), @NamedQuery(name="Location.FindByConceptNameCodeBefore", query="select l from Location l join fetch l.instance i where i.conceptNameCode=?1 and i.updatedTime<?2"), @NamedQuery(name="Location.CountByMultiRef", query="select count(l) from Location l where l.multiReference=?1"), @NamedQuery(name="Location.CountByUIDMap", query="select count(l) from Location l where l.uidMap=?1"), @NamedQuery(name="Location.SetDigest", query="update Location l set l.digest = ?2 where l.pk = ?1"), @NamedQuery(name="Location.SetStatus", query="update Location l set l.status = ?2 where l.pk = ?1"), @NamedQuery(name="Location.UpdateStatusFrom", query="update Location l set l.status = ?3 where l.pk = ?1 and l.status = ?2"), @NamedQuery(name="Location.DeleteByPk", query="delete from Location l where l.pk = ?1"), @NamedQuery(name="Location.Exists", query="select l.pk from Location l where l.pk = ?1")})
@NamedNativeQueries(value={@NamedNativeQuery(name="Location.SizeOfSeries", query="select sum(x.max_object_size) from (select max(object_size) max_object_size from location join instance on location.instance_fk = instance.pk where series_fk = ?1 and location.object_type = ?2 group by instance_fk) x")})
public class Location {
    public static final String FIND_BY_STORAGE_ID_AND_STATUS = "Location.FindByStorageIDAndStatus";
    public static final String FIND_BY_STUDY_PK = "Location.FindByStudyPk";
    public static final String FIND_BY_SERIES_PK = "Location.FindBySeriesPk";
    public static final String FIND_BY_STUDY_PK_AND_STORAGE_IDS = "Location.FindByStudyPkAndStorageIDs";
    public static final String FIND_BY_SOP_IUID_AND_STORAGE_ID = "Location.FindBySOPIUIDAndStorageID";
    public static final String INSTANCE_PKS_BY_STUDY_PK_AND_STORAGE_IDS = "Location.InstancePksByStudyPkAndStorageIDs";
    public static final String INSTANCE_PKS_BY_STUDY_PK_AND_STORAGE_IDS_AND_STATUS = "Location.InstancePksByStudyPkAndStorageIDsAndStatus";
    public static final String STORAGE_IDS_BY_STUDY_PK_AND_OBJECT_TYPE = "Location.StorageIDsByStudyPkAndObjectType";
    public static final String FIND_BY_REJECTION_CODE = "Location.FindByRejectionCode";
    public static final String FIND_BY_CONCEPT_NAME_CODE = "Location.FindByConceptNameCode";
    public static final String FIND_BY_REJECTION_CODE_BEFORE = "Location.FindByRejectionCodeBefore";
    public static final String FIND_BY_CONCEPT_NAME_CODE_BEFORE = "Location.FindByConceptNameCodeBefore";
    public static final String COUNT_BY_MULTI_REF = "Location.CountByMultiRef";
    public static final String COUNT_BY_UIDMAP = "Location.CountByUIDMap";
    public static final String SET_DIGEST = "Location.SetDigest";
    public static final String SET_STATUS = "Location.SetStatus";
    public static final String UPDATE_STATUS_FROM = "Location.UpdateStatusFrom";
    public static final String DELETE_BY_PK = "Location.DeleteByPk";
    public static final String SIZE_OF_SERIES = "Location.SizeOfSeries";
    public static final String EXISTS = "Location.Exists";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Column(name="storage_id", updatable=false)
    private String storageID;
    @Basic(optional=false)
    @Column(name="storage_path", updatable=false)
    private String storagePath;
    @Basic(optional=true)
    @Column(name="tsuid", updatable=false)
    private String transferSyntaxUID;
    @Basic(optional=false)
    @Column(name="object_size", updatable=false)
    private long size;
    @Basic(optional=true)
    @Column(name="digest", updatable=false)
    private String digest;
    @Basic(optional=false)
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status", updatable=true)
    private Status status;
    @Basic(optional=false)
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="object_type", updatable=false)
    private ObjectType objectType;
    @Column(name="multi_ref", updatable=true)
    private Integer multiReference;
    @Column(name="uidmap_fk", insertable=false, updatable=false)
    private Long uidMapFk;
    @ManyToOne
    @JoinColumn(name="uidmap_fk", updatable=false)
    private UIDMap uidMap;
    @ManyToOne
    @JoinColumn(name="instance_fk", updatable=true)
    private Instance instance;

    public static boolean isDicomFile(Location location) {
        return location.objectType == ObjectType.DICOM_FILE;
    }

    public Location() {
    }

    private Location(Builder builder) {
        this.pk = builder.pk;
        this.storageID = builder.storageID;
        this.storagePath = builder.storagePath;
        this.transferSyntaxUID = builder.transferSyntaxUID;
        this.size = builder.size;
        this.digest = builder.digest;
        this.status = builder.status;
        this.objectType = builder.objectType;
        this.multiReference = builder.multiReference;
        this.uidMap = builder.uidMap;
    }

    public Location(Location other) {
        this.createdTime = other.createdTime;
        this.storageID = other.storageID;
        this.storagePath = other.storagePath;
        this.transferSyntaxUID = other.transferSyntaxUID;
        this.size = other.size;
        this.digest = other.digest;
        this.status = other.status;
        this.objectType = other.objectType;
        this.multiReference = other.multiReference;
    }

    @PrePersist
    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public long getPk() {
        return this.pk;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    public long getSize() {
        return this.size;
    }

    public byte[] getDigest() {
        return this.digest != null ? TagUtils.fromHexString((String)this.digest) : null;
    }

    public String getDigestAsHexString() {
        return this.digest;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isStatusOK() {
        return this.status == Status.OK;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Integer getMultiReference() {
        return this.multiReference;
    }

    public void setMultiReference(Integer multiReference) {
        this.multiReference = multiReference;
    }

    public UIDMap getUidMap() {
        return this.uidMap;
    }

    public void setUidMap(UIDMap uidMap) {
        this.uidMap = uidMap;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public String toString() {
        return "Location[pk=" + this.pk + ", systemID=" + this.storageID + ", path=" + this.storagePath + ", tsuid=" + this.transferSyntaxUID + ", size=" + this.size + ", status=" + this.status + ", objectType=" + this.objectType + "]";
    }

    public static final class Builder {
        private long pk;
        private String storageID;
        private String storagePath;
        private String transferSyntaxUID;
        private long size;
        private String digest;
        private Status status = Status.OK;
        private ObjectType objectType = ObjectType.DICOM_FILE;
        public Integer multiReference;
        private UIDMap uidMap;

        public Builder pk(long pk) {
            this.pk = pk;
            return this;
        }

        public Builder storageID(String storageID) {
            this.storageID = storageID;
            return this;
        }

        public Builder storagePath(String storagePath) {
            this.storagePath = storagePath;
            return this;
        }

        public Builder transferSyntaxUID(String transferSyntaxUID) {
            this.transferSyntaxUID = transferSyntaxUID;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public Builder digest(byte[] digest) {
            return this.digest(digest != null ? TagUtils.toHexString((byte[])digest) : null);
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = status != null ? Status.valueOf(status) : Status.OK;
            return this;
        }

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder multiReference(Integer multiReference) {
            this.multiReference = multiReference;
            return this;
        }

        public Builder multiReference(String multiReference) {
            return this.multiReference(Builder.parseIntegerOrNull(multiReference));
        }

        private static Integer parseIntegerOrNull(String s) {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Builder uidMap(UIDMap uidMap) {
            this.uidMap = uidMap;
            return this;
        }

        public Location build() {
            return new Location(this);
        }
    }

    public static enum ObjectType {
        DICOM_FILE,
        METADATA;

    }

    public static enum Status {
        OK,
        TO_DELETE,
        FAILED_TO_DELETE,
        MISSING_OBJECT,
        FAILED_TO_FETCH_METADATA,
        FAILED_TO_FETCH_OBJECT,
        DIFFERING_OBJECT_SIZE,
        DIFFERING_OBJECT_CHECKSUM,
        DIFFERING_S3_MD5SUM,
        FAILED_TO_DELETE2,
        ORPHANED;

    }
}

