/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.dimse.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.event.RejectionNoteSent;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.store.scu.CStoreSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{storescp}")
public class RejectRS {
    private static final Logger LOG = LoggerFactory.getLogger(RejectRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private Event<RejectionNoteSent> rejectionNoteSentEvent;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="storescp")
    private String storescp;
    @QueryParam(value="priority")
    @Pattern(regexp="0|1|2")
    private @Pattern(regexp="0|1|2") String priority;
    @Inject
    private CFindSCU findSCU;
    @Inject
    private CStoreSCU storeSCU;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/studies/{StudyUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectStudy(@PathParam(value="StudyUID") String studyUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(studyUID, null, null, codeValue, designator);
    }

    @POST
    @Path(value="/studies/{StudyUID}/series/{SeriesUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectSeries(@PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(studyUID, seriesUID, null, codeValue, designator);
    }

    @POST
    @Path(value="/studies/{StudyUID}/series/{SeriesUID}/instances/{ObjectUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectInstance(@PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="ObjectUID") String objectUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(studyUID, seriesUID, objectUID, codeValue, designator);
    }

    @POST
    @Path(value="/query:{findscp}/studies/{StudyUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response queryRejectStudy(@PathParam(value="findscp") String findscp, @PathParam(value="StudyUID") String studyUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(studyUID, null, null, findscp, codeValue, designator);
    }

    @POST
    @Path(value="/query:{findscp}/studies/{StudyUID}/series/{SeriesUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response queryRejectSeries(@PathParam(value="findscp") String findscp, @PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(studyUID, seriesUID, null, findscp, codeValue, designator);
    }

    @POST
    @Path(value="/query:{findscp}/studies/{StudyUID}/series/{SeriesUID}/instances/{ObjectUID}/reject/{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response queryRejectInstance(@PathParam(value="findscp") String findscp, @PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="ObjectUID") String objectUID, @PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        return this.reject(studyUID, seriesUID, objectUID, findscp, codeValue, designator);
    }

    private int priority() {
        return RejectRS.parseInt(this.priority, 0);
    }

    private static int parseInt(String s, int defval) {
        return s != null ? Integer.parseInt(s) : defval;
    }

    private Response reject(String studyUID, String seriesUID, String objectUID, String codeValue, String designator) {
        return this.reject(studyUID, seriesUID, objectUID, this.storescp, codeValue, designator);
    }

    /*
     * Exception decompiling
     */
    private Response reject(String studyUID, String seriesUID, String objectUID, String findscp, String codeValue, String designator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response success(int status, String errorComment, List<Attributes> matches) {
        return Response.ok((Object)this.entity(status, errorComment, matches.size(), 0)).build();
    }

    private Response failed(int status, String errorComment, List<Attributes> matches) {
        String warning = this.warning(status);
        LOG.warn("Response status : Bad Gateway. Warning : {}", (Object)warning);
        return Response.status((Response.Status)Response.Status.BAD_GATEWAY).header("Warning", (Object)warning).entity((Object)this.entity(status, errorComment, 0, matches != null ? matches.size() : 0)).build();
    }

    private String warning(int status) {
        return TagUtils.shortToHexString((int)status) + (status == 272 ? ": Error: Processing Failure" : ((status & 0xA700) == 42752 ? ": Refused: Out of Resources" : ((status & 0xA900) == 43264 ? ": Error: Data Set does not match SOP Class" : ((status & 0xC000) == 49152 ? ": Cannot Understand" : ": Unexpected status code"))));
    }

    private StreamingOutput entity(int status, String error, int rejected, int failed) {
        return out -> {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            JsonWriter writer = new JsonWriter(gen);
            gen.writeStartObject();
            gen.write("status", TagUtils.shortToHexString((int)status));
            writer.writeNotNullOrDef("error", (Object)error, null);
            writer.writeNotDef("rejected", rejected, 0);
            writer.writeNotDef("failed", failed, 0);
            gen.writeEnd();
            gen.flush();
        };
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }
}

