/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.ldap;

import java.net.URI;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.ldap.LdapDicomConfiguration;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.ValueSelector;
import org.dcm4che3.deident.DeIdentifier;
import org.dcm4che3.net.AEExtension;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.AcceptConflictingPatientID;
import org.dcm4chee.arc.conf.AcceptMissingPatientID;
import org.dcm4chee.arc.conf.AllowDeletePatient;
import org.dcm4chee.arc.conf.AllowDeleteStudyPermanently;
import org.dcm4chee.arc.conf.AllowRejectionForDataRetentionPolicyExpired;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.ArchiveCompressionRule;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.AttributeSet;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.EntitySelector;
import org.dcm4chee.arc.conf.ExportPriorsRule;
import org.dcm4chee.arc.conf.ExportReoccurredInstances;
import org.dcm4chee.arc.conf.ExportRule;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.HL7Conditions;
import org.dcm4chee.arc.conf.HL7ExportRule;
import org.dcm4chee.arc.conf.HL7ForwardRule;
import org.dcm4chee.arc.conf.HL7ImportReportAdjustIUID;
import org.dcm4chee.arc.conf.HL7ImportReportMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7ImportReportMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7ORUAction;
import org.dcm4chee.arc.conf.HL7OrderMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderSPSStatus;
import org.dcm4chee.arc.conf.HL7OrderScheduledStation;
import org.dcm4chee.arc.conf.HL7PSUMWLMatchingKey;
import org.dcm4chee.arc.conf.HL7PSUMessageType;
import org.dcm4chee.arc.conf.HL7PrefetchRule;
import org.dcm4chee.arc.conf.HL7ReferredMergedPatientPolicy;
import org.dcm4chee.arc.conf.HL7StudyRetentionPolicy;
import org.dcm4chee.arc.conf.IDGenerator;
import org.dcm4chee.arc.conf.InputReadinessState;
import org.dcm4chee.arc.conf.MPPSForwardRule;
import org.dcm4chee.arc.conf.MWLIdleTimeout;
import org.dcm4chee.arc.conf.MWLImport;
import org.dcm4chee.arc.conf.MergeAttribute;
import org.dcm4chee.arc.conf.MergeMWLMatchingKey;
import org.dcm4chee.arc.conf.MetricsDescriptor;
import org.dcm4chee.arc.conf.MultipleStoreAssociations;
import org.dcm4chee.arc.conf.NullifyIssuer;
import org.dcm4chee.arc.conf.OverwritePolicy;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.dcm4chee.arc.conf.RSForwardRule;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.conf.RetentionPeriod;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.conf.ScheduledProtocolCodeInOrder;
import org.dcm4chee.arc.conf.ScheduledStationAETInOrder;
import org.dcm4chee.arc.conf.ShowPatientInfo;
import org.dcm4chee.arc.conf.SpanningCFindSCPPolicy;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StorageDuration;
import org.dcm4chee.arc.conf.StorageThreshold;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.conf.StoreAccessControlIDRule;
import org.dcm4chee.arc.conf.StudyRetentionPolicy;
import org.dcm4chee.arc.conf.UPSOnHL7;
import org.dcm4chee.arc.conf.UPSOnStore;
import org.dcm4chee.arc.conf.UPSOnUPSCompleted;
import org.dcm4chee.arc.conf.UPSPriority;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.conf.UseCallingAETitleAsCoercion;
import org.dcm4chee.arc.conf.UserIdentityNegotiation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LdapArchiveConfiguration
extends LdapDicomConfigurationExtension {
    private static final Logger LOG = LoggerFactory.getLogger(LdapArchiveConfiguration.class);

    protected void storeTo(ConfigurationChanges.ModifiedObject ldapObj, Device device, Attributes attrs) {
        ArchiveDeviceExtension ext = (ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (ext == null) {
            return;
        }
        attrs.get("objectclass").add("dcmArchiveDevice");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFuzzyAlgorithmClass", (Object)ext.getFuzzyAlgorithmClass(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmBulkDataDescriptorID", (Object)ext.getBulkDataDescriptorID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSeriesMetadataStorageID", (Object[])ext.getSeriesMetadataStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSeriesMetadataDelay", (Object)ext.getSeriesMetadataDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSeriesMetadataPollingInterval", (Object)ext.getSeriesMetadataPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSeriesMetadataFetchSize", (int)ext.getSeriesMetadataFetchSize(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSeriesMetadataThreads", (int)ext.getSeriesMetadataThreads(), (int)1);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSeriesMetadataMaxRetries", (int)ext.getSeriesMetadataMaxRetries(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSeriesMetadataRetryInterval", (Object)ext.getSeriesMetadataRetryInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeInstanceRecords", (boolean)ext.isPurgeInstanceRecords(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeInstanceRecordsDelay", (Object)ext.getPurgeInstanceRecordsDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeInstanceRecordsPollingInterval", (Object)ext.getPurgeInstanceRecordsPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeInstanceRecordsFetchSize", (int)ext.getPurgeInstanceRecordsFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteUPSPollingInterval", (Object)ext.getDeleteUPSPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteUPSFetchSize", (int)ext.getDeleteUPSFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteUPSCompletedDelay", (Object)ext.getDeleteUPSCompletedDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteUPSCanceledDelay", (Object)ext.getDeleteUPSCanceledDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmOverwritePolicy", (Object)ext.getOverwritePolicy(), (Object)OverwritePolicy.NEVER);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRecordAttributeModification", (boolean)ext.isRecordAttributeModification(), (boolean)true);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIdentifyPatientByAllAttributes", (boolean)ext.isIdentifyPatientByAllAttributes(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmBulkDataSpoolDirectory", (Object)ext.getBulkDataSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPersonNameComponentOrderInsensitiveMatching", (boolean)ext.isPersonNameComponentOrderInsensitiveMatching(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSendPendingCGet", (boolean)ext.isSendPendingCGet(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSendPendingCMoveInterval", (Object)ext.getSendPendingCMoveInterval(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSpanningCFindSCP", (Object)ext.getSpanningCFindSCP(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSpanningCFindSCPRetrieveAET", (Object[])ext.getSpanningCFindSCPRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSpanningCFindSCPPolicy", (Object)ext.getSpanningCFindSCPPolicy(), (Object)SpanningCFindSCPPolicy.REPLACE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCP", (Object)ext.getFallbackCMoveSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPDestination", (Object)ext.getFallbackCMoveSCPDestination(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPCallingAET", (Object)ext.getFallbackCMoveSCPCallingAET(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPLeadingCFindSCP", (Object)ext.getFallbackCMoveSCPLeadingCFindSCP(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPRetries", (int)ext.getFallbackCMoveSCPRetries(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAltCMoveSCP", (Object)ext.getAlternativeCMoveSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoZIPEntryNameFormat", (Object)ext.getWadoZIPEntryNameFormat(), (Object)"DICOM/{0020000D,hash}/{0020000E,hash}/{00080018,hash}.dcm");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoSR2HtmlTemplateURI", (Object)ext.getWadoSR2HtmlTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoSR2TextTemplateURI", (Object)ext.getWadoSR2TextTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoCDA2HtmlTemplateURI", (Object)ext.getWadoCDA2HtmlTemplateURI(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoSupportedSRClasses", (Object[])ext.getWadoSupportedSRClasses(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoSupportedPRClasses", (Object[])ext.getWadoSupportedPRClasses(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoSpoolDirectory", (Object)ext.getWadoSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoThumbnailViewport", (Object)ext.getWadoThumbnailViewPort(), (Object)"64,64");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackWadoURIWebAppName", (Object)ext.getFallbackWadoURIWebApplication(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackWadoURIHttpStatusCode", (int)ext.getFallbackWadoURIHttpStatusCode(), (int)303);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoIgnorePresentationLUTShape", (boolean)ext.isWadoIgnorePresentationLUTShape(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoMetadataExcludePrivate", (boolean)ext.isWadoMetadataWithoutPrivate(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PatientUpdateTemplateURI", (Object)ext.getPatientUpdateTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportTemplateURI", (Object)ext.getImportReportTemplateURI(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportTemplateParam", (Map)ext.getImportReportTemplateParams());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ScheduleProcedureTemplateURI", (Object)ext.getScheduleProcedureTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OutgoingPatientUpdateTemplateURI", (Object)ext.getOutgoingPatientUpdateTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7LogFilePattern", (Object)ext.getHL7LogFilePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ErrorLogFilePattern", (Object)ext.getHL7ErrorLogFilePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUnzipVendorDataToURI", (Object)ext.getUnzipVendorDataToURI(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQueryFetchSize", (int)ext.getQueryFetchSize(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQueryMaxNumberOfResults", (int)ext.getQueryMaxNumberOfResults(), (int)0);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQidoMaxNumberOfResults", (int)ext.getQidoMaxNumberOfResults(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQidoETag", (boolean)ext.isQidoETag(), (boolean)false);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFwdMppsDestination", (Object[])ext.getMppsForwardDestinations(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanDestination", (Object[])ext.getIanDestinations(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanDelay", (Object)ext.getIanDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanTimeout", (Object)ext.getIanTimeout(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanOnTimeout", (boolean)ext.isIanOnTimeout(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanTaskPollingInterval", (Object)ext.getIanTaskPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanTaskFetchSize", (int)ext.getIanTaskFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeStoragePollingInterval", (Object)ext.getPurgeStoragePollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeStorageFetchSize", (int)ext.getPurgeStorageFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFailedToDeletePollingInterval", (Object)ext.getFailedToDeletePollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFailedToDeleteFetchSize", (int)ext.getFailedToDeleteFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteRejectedPollingInterval", (Object)ext.getDeleteRejectedPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteRejectedFetchSize", (int)ext.getDeleteRejectedFetchSize(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteStudyBatchSize", (int)ext.getDeleteStudyBatchSize(), (int)10);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeletePatientOnDeleteLastStudy", (boolean)ext.isDeletePatientOnDeleteLastStudy(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxAccessTimeStaleness", (Object)ext.getMaxAccessTimeStaleness(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAECacheStaleTimeout", (Object)ext.getAECacheStaleTimeout(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmLeadingCFindSCPQueryCacheStaleTimeout", (Object)ext.getLeadingCFindSCPQueryCacheStaleTimeout(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmLeadingCFindSCPQueryCacheSize", (int)ext.getLeadingCFindSCPQueryCacheSize(), (int)10);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditSpoolDirectory", (Object)ext.getAuditSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditPollingInterval", (Object)ext.getAuditPollingInterval(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditAggregateDuration", (Object)ext.getAuditAggregateDuration(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowSpoolDirectory", (Object)ext.getStowSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeQueueMessagePollingInterval", (Object)ext.getPurgeTaskPollingInterval(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHideSPSWithStatusFromMWL", (Object[])ext.getHideSPSWithStatusFrom(), (Object[])new SPSStatus[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHideSPSWithStatusFromMWLRS", (Object[])ext.getHideSPSWithStatusFromMWLRS(), (Object[])new SPSStatus[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEncodeAsJSONNumber", (Object[])ext.getEncodeAsJSONNumber(), (Object[])new VR[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ORUAction", (Object[])ext.getHl7ORUAction(), (Object[])new HL7ORUAction[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLAccessionNumberGenerator", (Object)ext.getMWLAccessionNumberGenerator(), (Object)"AccessionNumber");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLRequestedProcedureIDGenerator", (Object)ext.getMWLRequestedProcedureIDGenerator(), (Object)"RequestedProcedureID");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLScheduledProcedureStepIDGenerator", (Object)ext.getMWLScheduledProcedureStepIDGenerator(), (Object)"ScheduledProcedureStepID");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectExpiredStudiesPollingInterval", (Object)ext.getRejectExpiredStudiesPollingInterval(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectExpiredStudiesSchedule", (Object[])ext.getRejectExpiredStudiesSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectExpiredStudiesFetchSize", (int)ext.getRejectExpiredStudiesFetchSize(), (int)0);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectExpiredSeriesFetchSize", (int)ext.getRejectExpiredSeriesFetchSize(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectExpiredStudiesAETitle", (Object)ext.getRejectExpiredStudiesAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPStudyOlderThan", (Object)ext.getFallbackCMoveSCPStudyOlderThan(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceURL", (Object)ext.getStorePermissionServiceURL(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceResponse", (Object)ext.getStorePermissionServiceResponse(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceResponsePattern", (Object)ext.getStorePermissionServiceResponsePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionCacheStaleTimeout", (Object)ext.getStorePermissionCacheStaleTimeout(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionCacheSize", (int)ext.getStorePermissionCacheSize(), (int)10);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeMWLCacheStaleTimeout", (Object)ext.getMergeMWLCacheStaleTimeout(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeMWLCacheSize", (int)ext.getMergeMWLCacheSize(), (int)10);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStoreUpdateDBMaxRetries", (int)ext.getStoreUpdateDBMaxRetries(), (int)3);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStoreUpdateDBMinRetryDelay", (int)ext.getStoreUpdateDBMinRetryDelay(), (int)500);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStoreUpdateDBMaxRetryDelay", (int)ext.getStoreUpdateDBMaxRetryDelay(), (int)1000);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAllowRejectionForDataRetentionPolicyExpired", (Object)ext.getAllowRejectionForDataRetentionPolicyExpired(), (Object)AllowRejectionForDataRetentionPolicyExpired.EXPIRED_UNSET);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptMissingPatientID", (Object)ext.getAcceptMissingPatientID(), (Object)AcceptMissingPatientID.CREATE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAllowDeleteStudyPermanently", (Object)ext.getAllowDeleteStudyPermanently(), (Object)AllowDeleteStudyPermanently.REJECTED);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAllowDeletePatient", (Object)ext.getAllowDeletePatient(), (Object)AllowDeletePatient.WITHOUT_STUDIES);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceExpirationDatePattern", (Object)ext.getStorePermissionServiceExpirationDatePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmShowPatientInfoInSystemLog", (Object)ext.getShowPatientInfoInSystemLog(), (Object)ShowPatientInfo.PLAIN_TEXT);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmShowPatientInfoInAuditLog", (Object)ext.getShowPatientInfoInAuditLog(), (Object)ShowPatientInfo.PLAIN_TEXT);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeStgCmtCompletedDelay", (Object)ext.getPurgeStgCmtCompletedDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeStgCmtPollingInterval", (Object)ext.getPurgeStgCmtPollingInterval(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDefaultCharacterSet", (Object)ext.getDefaultCharacterSet(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCharsetNameMapping", (Map)ext.getDicomCharsetNameMappings());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7CharsetNameMapping", (Map)ext.getHL7CharsetNameMappings());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSEventWebSocketQueueSize", (Map)ext.getUPSEventWebSocketQueueSizes());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSWorklistLabel", (Object)ext.getUPSWorklistLabel(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSEventSCU", (Object[])ext.getUPSEventSCUs(), (Object[])new String[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSEventSCUKeepAlive", (int)ext.getUPSEventSCUKeepAlive(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceErrorCommentPattern", (Object)ext.getStorePermissionServiceErrorCommentPattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceErrorCodePattern", (Object)ext.getStorePermissionServiceErrorCodePattern(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveAET", (Object[])ext.getRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmReturnRetrieveAET", (Object[])ext.getReturnRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMultipleStoreAssociations", (Object[])ext.getMultipleStoreAssociations(), (Object[])new MultipleStoreAssociations[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExternalRetrieveAEDestination", (Object)ext.getExternalRetrieveAEDestination(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmXDSiImagingDocumentSourceAETitle", (Object)ext.getXDSiImagingDocumentSourceAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRemapRetrieveURL", (Object)ext.getRemapRetrieveURL(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmValidateCallingAEHostname", (boolean)ext.isValidateCallingAEHostname(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUSendingApplication", (Object)ext.getHL7PSUSendingApplication(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUReceivingApplication", (Object[])ext.getHL7PSUReceivingApplications(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUDelay", (Object)ext.getHL7PSUDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUTimeout", (Object)ext.getHL7PSUTimeout(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUOnTimeout", (boolean)ext.isHL7PSUOnTimeout(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUTaskPollingInterval", (Object)ext.getHL7PSUTaskPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUTaskFetchSize", (int)ext.getHL7PSUTaskFetchSize(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUMWL", (boolean)ext.isHL7PSUMWL(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUMWLMatchingKey", (Object)ext.getHL7PSUMWLMatchingKey(), (Object)HL7PSUMWLMatchingKey.StudyInstanceUID);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUForRequestedProcedure", (boolean)ext.isHl7PSUForRequestedProcedure(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUPIDPV1", (boolean)ext.isHl7PSUPIDPV1(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSURequestedProcedureID", (Object)ext.getHl7PSURequestedProcedureID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUAccessionNumber", (Object)ext.getHl7PSUAccessionNumber(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUFillerOrderNumber", (Object)ext.getHl7PSUFillerOrderNumber(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUPlacerOrderNumber", (Object)ext.getHl7PSUPlacerOrderNumber(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUTemplateParam", (Map)ext.getHL7PSUTemplateParams());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUMessageType", (Object)ext.getHl7PSUMessageType(), (Object)HL7PSUMessageType.OMG_O19);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUCondition", (Map)ext.getHl7PSUConditions().getMap());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUMppsTemplateURI", (Object)ext.getHl7PSUMppsTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUStudyTemplateURI", (Object)ext.getHl7PSUStudyTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptConflictingPatientID", (Object)ext.getAcceptConflictingPatientID(), (Object)AcceptConflictingPatientID.MERGED);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProxyUpstreamURL", (Object)ext.getProxyUpstreamURL(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAudit2JsonFhirTemplateURI", (Object)ext.getAudit2JsonFhirTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAudit2XmlFhirTemplateURI", (Object)ext.getAudit2XmlFhirTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCopyMoveUpdatePolicy", (Object)ext.getCopyMoveUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmLinkMWLEntryUpdatePolicy", (Object)ext.getLinkMWLEntryUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationPolicy", (Object)ext.getStorageVerificationPolicy(), (Object)StorageVerificationPolicy.OBJECT_CHECKSUM);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationUpdateLocationStatus", (boolean)ext.isStorageVerificationUpdateLocationStatus(), (boolean)false);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationStorageID", (Object[])ext.getStorageVerificationStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationAETitle", (Object)ext.getStorageVerificationAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationBatchID", (Object)ext.getStorageVerificationBatchID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationInitialDelay", (Object)ext.getStorageVerificationInitialDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationPeriod", (Object)ext.getStorageVerificationPeriod(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationMaxScheduled", (int)ext.getStorageVerificationMaxScheduled(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationPollingInterval", (Object)ext.getStorageVerificationPollingInterval(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationSchedule", (Object[])ext.getStorageVerificationSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationFetchSize", (int)ext.getStorageVerificationFetchSize(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUpdateLocationStatusOnRetrieve", (boolean)ext.isUpdateLocationStatusOnRetrieve(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationOnRetrieve", (boolean)ext.isStorageVerificationOnRetrieve(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7TrackChangedPatientID", (boolean)ext.isHL7TrackChangedPatientID(), (boolean)true);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ADTSendingApplication", (Object)ext.getHL7ADTSendingApplication(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ADTReceivingApplication", (Object[])ext.getHL7ADTReceivingApplication(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ScheduledProtocolCodeInOrder", (Object)ext.getHL7ScheduledProtocolCodeInOrder(), (Object)ScheduledProtocolCodeInOrder.OBR_4_4);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ScheduledStationAETInOrder", (Object)ext.getHL7ScheduledStationAETInOrder(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7NoPatientCreateMessageType", (Object[])ext.getHL7NoPatientCreateMessageTypes(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditUnknownStudyInstanceUID", (Object)ext.getAuditUnknownStudyInstanceUID(), (Object)"1.2.40.0.13.1.15.110.3.165.1");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditUnknownPatientID", (Object)ext.getAuditUnknownPatientID(), (Object)"<none>");
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditSoftwareConfigurationVerbose", (boolean)ext.isAuditSoftwareConfigurationVerbose(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7UseNullValue", (boolean)ext.isHL7UseNullValue(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQueueTasksFetchSize", (int)ext.getQueueTasksFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectionNoteStorageAET", (Object)ext.getRejectionNoteStorageAET(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmXRoadProperty", (Map)ext.getXRoadProperties());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmImpaxReportProperty", (Map)ext.getImpaxReportProperties());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUIConfigurationDeviceName", (Object)ext.getUiConfigurationDeviceName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCompressionAETitle", (Object)ext.getCompressionAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCompressionPollingInterval", (Object)ext.getCompressionPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCompressionFetchSize", (int)ext.getCompressionFetchSize(), (int)100);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCompressionSchedule", (Object[])ext.getCompressionSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCompressionThreads", (int)ext.getCompressionThreads(), (int)1);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDiffTaskProgressUpdateInterval", (Object)ext.getDiffTaskProgressUpdateInterval(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationPDQServiceID", (Object)ext.getPatientVerificationPDQServiceID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationPollingInterval", (Object)ext.getPatientVerificationPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationFetchSize", (int)ext.getPatientVerificationFetchSize(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationAdjustIssuerOfPatientID", (boolean)ext.isPatientVerificationAdjustIssuerOfPatientID(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationPeriod", (Object)ext.getPatientVerificationPeriod(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationPeriodOnNotFound", (Object)ext.getPatientVerificationPeriodOnNotFound(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationRetryInterval", (Object)ext.getPatientVerificationRetryInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationMaxRetries", (int)ext.getPatientVerificationMaxRetries(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatientVerificationMaxStaleness", (Object)ext.getPatientVerificationMaxStaleness(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCSVUploadChunkSize", (int)ext.getCSVUploadChunkSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OrderMissingStudyIUIDPolicy", (Object)ext.getHl7OrderMissingStudyIUIDPolicy(), (Object)HL7OrderMissingStudyIUIDPolicy.GENERATE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OrderMissingAdmissionIDPolicy", (Object)ext.getHl7OrderMissingAdmissionIDPolicy(), (Object)HL7OrderMissingAdmissionIDPolicy.ACCEPT);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportMissingStudyIUIDPolicy", (Object)ext.getHl7ImportReportMissingStudyIUIDPolicy(), (Object)HL7ImportReportMissingStudyIUIDPolicy.GENERATE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportMissingAdmissionIDPolicy", (Object)ext.getHl7ImportReportMissingAdmissionIDPolicy(), (Object)HL7ImportReportMissingAdmissionIDPolicy.ACCEPT);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportMissingStudyIUIDCFindSCP", (Object)ext.getHl7ImportReportMissingStudyIUIDCFindSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ImportReportAdjustIUID", (Object)ext.getHl7ImportReportAdjustIUID(), (Object)HL7ImportReportAdjustIUID.NONE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7DicomCharacterSet", (Object)ext.getHl7DicomCharacterSet(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7VeterinaryUsePatientName", (boolean)ext.isHl7VeterinaryUsePatientName(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmValidateUID", (boolean)ext.isValidateUID(), (boolean)true);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRelationalQueryNegotiationLenient", (boolean)ext.isRelationalQueryNegotiationLenient(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRelationalRetrieveNegotiationLenient", (boolean)ext.isRelationalRetrieveNegotiationLenient(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedulerMinStartDelay", (int)ext.getSchedulerMinStartDelay(), (int)60);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowRetiredTransferSyntax", (boolean)ext.isStowRetiredTransferSyntax(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowExcludeAPPMarkers", (boolean)ext.isStowExcludeAPPMarkers(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRestrictRetrieveSilently", (boolean)ext.isRestrictRetrieveSilently(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowQuicktime2MP4", (boolean)ext.isStowQuicktime2MP4(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowMaxFragmentLength", (long)ext.getStowMaxFragmentLength(), (long)0x7FFFFFFEL);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLPollingInterval", (Object)ext.getMWLPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLFetchSize", (int)ext.getMWLFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLImportInterval", (Object)ext.getMWLImportInterval(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteMWLDelay", (Object[])ext.getDeleteMWLDelay(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSProcessingPollingInterval", (Object)ext.getUPSProcessingPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSProcessingFetchSize", (int)ext.getUPSProcessingFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmTaskPollingInterval", (Object)ext.getTaskPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmTaskFetchSize", (int)ext.getTaskFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ReferredMergedPatientPolicy", (Object)ext.getHl7ReferredMergedPatientPolicy(), (Object)HL7ReferredMergedPatientPolicy.REJECT);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveTaskWarningOnNoMatch", (boolean)ext.isRetrieveTaskWarningOnNoMatch(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveTaskWarningOnWarnings", (boolean)ext.isRetrieveTaskWarningOnWarnings(), (boolean)false);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCStoreSCUOfCMoveSCP", (Map)ext.getCStoreSCUOfCMoveSCPs());
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteStudyChunkSize", (int)ext.getDeleteStudyChunkSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PatientArrivalMessageType", (Object)ext.getHL7PatientArrivalMessageType(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUserIdentityNegotiation", (Object)ext.getUserIdentityNegotiation(), (Object)UserIdentityNegotiation.SUPPORTS);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUserIdentityNegotiationRole", (Object)ext.getUserIdentityNegotiationRole(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUserIdentityNegotiationKeycloakClientID", (Object)ext.getUserIdentityNegotiationKeycloakClientID(), null);
        LdapArchiveConfiguration.storeNotEmptyTags(ldapObj, attrs, "dcmRejectConflictingPatientAttribute", ext.getRejectConflictingPatientAttribute());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCalculateStudySizeDelay", (Object)ext.getStudySizeDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCalculateStudySizePollingInterval", (Object)ext.getCalculateStudySizePollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCalculateStudySizeFetchSize", (int)ext.getCalculateStudySizeFetchSize(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCalculateQueryAttributes", (boolean)ext.isCalculateQueryAttributes(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStoreImplementationVersionName", (boolean)ext.isStoreImplementationVersionName(), (boolean)true);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSupplementIssuerFetchSize", (int)ext.getSupplementIssuerFetchSize(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUpdateCharsetFetchSize", (int)ext.getUpdateCharsetFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditAssigningAuthorityOfPatientID", (Object)ext.getAuditAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmChangeRequesterAET", (Object)ext.getChangeRequesterAET(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFilterByIssuerOfPatientID", (boolean)ext.isFilterByIssuerOfPatientID(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditHL7MsgLimit", (int)ext.getAuditHL7MsgLimit(), (int)1000);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMatchSOPClassOnInstanceLevel", (boolean)ext.isMatchSOPClassOnInstanceLevel(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSUpdateWithoutTransactionUID", (boolean)ext.isUPSUpdateWithoutTransactionUID(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmKeyValueRetentionPollingInterval", (Object)ext.getKeyValueRetentionPollingInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmKeyValueRetentionFetchSize", (int)ext.getKeyValueRetentionFetchSize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmKeyValueRetentionPeriod", (Object)ext.getKeyValueRetentionPeriod(), null);
    }

    protected void loadFrom(Device device, Attributes attrs) throws NamingException {
        if (!LdapUtils.hasObjectClass((Attributes)attrs, (String)"dcmArchiveDevice")) {
            return;
        }
        ArchiveDeviceExtension ext = new ArchiveDeviceExtension();
        device.addDeviceExtension((DeviceExtension)ext);
        ext.setFuzzyAlgorithmClass(LdapUtils.stringValue((Attribute)attrs.get("dcmFuzzyAlgorithmClass"), null));
        ext.setBulkDataDescriptorID(LdapUtils.stringValue((Attribute)attrs.get("dcmBulkDataDescriptorID"), null));
        ext.setSeriesMetadataStorageIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmSeriesMetadataStorageID"), (String[])new String[0]));
        ext.setSeriesMetadataDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmSeriesMetadataDelay"), null));
        ext.setSeriesMetadataPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmSeriesMetadataPollingInterval"), null));
        ext.setSeriesMetadataFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmSeriesMetadataFetchSize"), (int)100));
        ext.setSeriesMetadataThreads(LdapUtils.intValue((Attribute)attrs.get("dcmSeriesMetadataThreads"), (int)1));
        ext.setSeriesMetadataMaxRetries(LdapUtils.intValue((Attribute)attrs.get("dcmSeriesMetadataMaxRetries"), (int)0));
        ext.setSeriesMetadataRetryInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmSeriesMetadataRetryInterval"), null));
        ext.setPurgeInstanceRecords(LdapUtils.booleanValue((Attribute)attrs.get("dcmPurgeInstanceRecords"), (boolean)false));
        ext.setPurgeInstanceRecordsDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeInstanceRecordsDelay"), null));
        ext.setPurgeInstanceRecordsPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeInstanceRecordsPollingInterval"), null));
        ext.setPurgeInstanceRecordsFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmPurgeInstanceRecordsFetchSize"), (int)100));
        ext.setDeleteUPSPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmDeleteUPSPollingInterval"), null));
        ext.setDeleteUPSFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmDeleteUPSFetchSize"), (int)100));
        ext.setDeleteUPSCompletedDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmDeleteUPSCompletedDelay"), null));
        ext.setDeleteUPSCanceledDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmDeleteUPSCanceledDelay"), null));
        ext.setOverwritePolicy((OverwritePolicy)LdapUtils.enumValue(OverwritePolicy.class, (Attribute)attrs.get("dcmOverwritePolicy"), (Enum)OverwritePolicy.NEVER));
        ext.setRecordAttributeModification(LdapUtils.booleanValue((Attribute)attrs.get("dcmRecordAttributeModification"), (boolean)true));
        ext.setIdentifyPatientByAllAttributes(LdapUtils.booleanValue((Attribute)attrs.get("dcmIdentifyPatientByAllAttributes"), (boolean)false));
        ext.setBulkDataSpoolDirectory(LdapUtils.stringValue((Attribute)attrs.get("dcmBulkDataSpoolDirectory"), (String)"${jboss.server.temp.dir}"));
        ext.setPersonNameComponentOrderInsensitiveMatching(LdapUtils.booleanValue((Attribute)attrs.get("dcmPersonNameComponentOrderInsensitiveMatching"), (boolean)false));
        ext.setSendPendingCGet(LdapUtils.booleanValue((Attribute)attrs.get("dcmSendPendingCGet"), (boolean)false));
        ext.setSendPendingCMoveInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmSendPendingCMoveInterval"), null));
        ext.setSpanningCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmSpanningCFindSCP"), null));
        ext.setSpanningCFindSCPRetrieveAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmSpanningCFindSCPRetrieveAET"), (String[])new String[0]));
        ext.setSpanningCFindSCPPolicy((SpanningCFindSCPPolicy)LdapUtils.enumValue(SpanningCFindSCPPolicy.class, (Attribute)attrs.get("dcmSpanningCFindSCPPolicy"), (Enum)SpanningCFindSCPPolicy.REPLACE));
        ext.setFallbackCMoveSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCP"), null));
        ext.setFallbackCMoveSCPDestination(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCPDestination"), null));
        ext.setFallbackCMoveSCPCallingAET(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCPCallingAET"), null));
        ext.setFallbackCMoveSCPRetries(LdapUtils.intValue((Attribute)attrs.get("dcmFallbackCMoveSCPRetries"), (int)0));
        ext.setFallbackCMoveSCPLeadingCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCPLeadingCFindSCP"), null));
        ext.setAlternativeCMoveSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmAltCMoveSCP"), null));
        ext.setWadoZIPEntryNameFormat(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoZIPEntryNameFormat"), (String)"DICOM/{0020000D,hash}/{0020000E,hash}/{00080018,hash}.dcm"));
        ext.setWadoSR2HtmlTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoSR2HtmlTemplateURI"), null));
        ext.setWadoSR2TextTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoSR2TextTemplateURI"), null));
        ext.setWadoCDA2HtmlTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoCDA2HtmlTemplateURI"), null));
        ext.setWadoSupportedSRClasses(LdapUtils.stringArray((Attribute)attrs.get("dcmWadoSupportedSRClasses"), (String[])new String[0]));
        ext.setWadoSupportedPRClasses(LdapUtils.stringArray((Attribute)attrs.get("dcmWadoSupportedPRClasses"), (String[])new String[0]));
        ext.setWadoSpoolDirectory(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoSpoolDirectory"), (String)"${jboss.server.temp.dir}"));
        ext.setWadoThumbnailViewPort(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoThumbnailViewport"), (String)"64,64"));
        ext.setFallbackWadoURIWebApplication(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackWadoURIWebAppName"), null));
        ext.setFallbackWadoURIHttpStatusCode(LdapUtils.intValue((Attribute)attrs.get("dcmFallbackWadoURIHttpStatusCode"), (int)303));
        ext.setWadoIgnorePresentationLUTShape(LdapUtils.booleanValue((Attribute)attrs.get("dcmWadoIgnorePresentationLUTShape"), (boolean)false));
        ext.setWadoMetadataWithoutPrivate(LdapUtils.booleanValue((Attribute)attrs.get("dcmWadoMetadataExcludePrivate"), (boolean)false));
        ext.setPatientUpdateTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7PatientUpdateTemplateURI"), null));
        ext.setImportReportTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7ImportReportTemplateURI"), null));
        ext.setImportReportTemplateParams(LdapUtils.stringArray((Attribute)attrs.get("hl7ImportReportTemplateParam"), (String[])new String[0]));
        ext.setScheduleProcedureTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7ScheduleProcedureTemplateURI"), null));
        ext.setOutgoingPatientUpdateTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7OutgoingPatientUpdateTemplateURI"), null));
        ext.setHL7LogFilePattern(LdapUtils.stringValue((Attribute)attrs.get("hl7LogFilePattern"), null));
        ext.setHL7ErrorLogFilePattern(LdapUtils.stringValue((Attribute)attrs.get("hl7ErrorLogFilePattern"), null));
        ext.setUnzipVendorDataToURI(LdapUtils.stringValue((Attribute)attrs.get("dcmUnzipVendorDataToURI"), null));
        ext.setQueryFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmQueryFetchSize"), (int)100));
        ext.setQueryMaxNumberOfResults(LdapUtils.intValue((Attribute)attrs.get("dcmQueryMaxNumberOfResults"), (int)0));
        ext.setQidoMaxNumberOfResults(LdapUtils.intValue((Attribute)attrs.get("dcmQidoMaxNumberOfResults"), (int)0));
        ext.setQidoETag(LdapUtils.booleanValue((Attribute)attrs.get("dcmQidoETag"), (boolean)false));
        ext.setMppsForwardDestinations(LdapUtils.stringArray((Attribute)attrs.get("dcmFwdMppsDestination"), (String[])new String[0]));
        ext.setIanDestinations(LdapUtils.stringArray((Attribute)attrs.get("dcmIanDestination"), (String[])new String[0]));
        ext.setIanDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmIanDelay"), null));
        ext.setIanTimeout(LdapArchiveConfiguration.toDuration(attrs.get("dcmIanTimeout"), null));
        ext.setIanOnTimeout(LdapUtils.booleanValue((Attribute)attrs.get("dcmIanOnTimeout"), (boolean)false));
        ext.setIanTaskPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmIanTaskPollingInterval"), null));
        ext.setIanTaskFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmIanTaskFetchSize"), (int)100));
        ext.setPurgeStoragePollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeStoragePollingInterval"), null));
        ext.setPurgeStorageFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmPurgeStorageFetchSize"), (int)100));
        ext.setFailedToDeletePollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmFailedToDeletePollingInterval"), null));
        ext.setFailedToDeleteFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmFailedToDeleteFetchSize"), (int)100));
        ext.setDeleteRejectedPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmDeleteRejectedPollingInterval"), null));
        ext.setDeleteRejectedFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmDeleteRejectedFetchSize"), (int)100));
        ext.setDeleteStudyBatchSize(LdapUtils.intValue((Attribute)attrs.get("dcmDeleteStudyBatchSize"), (int)10));
        ext.setDeletePatientOnDeleteLastStudy(LdapUtils.booleanValue((Attribute)attrs.get("dcmDeletePatientOnDeleteLastStudy"), (boolean)false));
        ext.setMaxAccessTimeStaleness(LdapArchiveConfiguration.toDuration(attrs.get("dcmMaxAccessTimeStaleness"), null));
        ext.setAECacheStaleTimeout(LdapArchiveConfiguration.toDuration(attrs.get("dcmAECacheStaleTimeout"), null));
        ext.setLeadingCFindSCPQueryCacheStaleTimeout(LdapArchiveConfiguration.toDuration(attrs.get("dcmLeadingCFindSCPQueryCacheStaleTimeout"), null));
        ext.setLeadingCFindSCPQueryCacheSize(LdapUtils.intValue((Attribute)attrs.get("dcmLeadingCFindSCPQueryCacheSize"), (int)10));
        ext.setAuditSpoolDirectory(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditSpoolDirectory"), (String)"${jboss.server.temp.dir}"));
        ext.setAuditPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmAuditPollingInterval"), null));
        ext.setAuditAggregateDuration(LdapArchiveConfiguration.toDuration(attrs.get("dcmAuditAggregateDuration"), null));
        ext.setStowSpoolDirectory(LdapUtils.stringValue((Attribute)attrs.get("dcmStowSpoolDirectory"), (String)"${jboss.server.temp.dir}"));
        ext.setPurgeTaskPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeQueueMessagePollingInterval"), null));
        ext.setHideSPSWithStatusFrom((SPSStatus[])LdapUtils.enumArray(SPSStatus.class, (Attribute)attrs.get("dcmHideSPSWithStatusFromMWL")));
        ext.setHideSPSWithStatusFromMWLRS((SPSStatus[])LdapUtils.enumArray(SPSStatus.class, (Attribute)attrs.get("dcmHideSPSWithStatusFromMWLRS")));
        ext.setEncodeAsJSONNumber((VR[])LdapUtils.enumArray(VR.class, (Attribute)attrs.get("dcmEncodeAsJSONNumber")));
        ext.setHl7ORUAction((HL7ORUAction[])LdapUtils.enumArray(HL7ORUAction.class, (Attribute)attrs.get("hl7ORUAction")));
        ext.setMWLAccessionNumberGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLAccessionNumberGenerator"), (String)"AccessionNumber"));
        ext.setMWLRequestedProcedureIDGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLRequestedProcedureIDGenerator"), (String)"RequestedProcedureID"));
        ext.setMWLScheduledProcedureStepIDGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLScheduledProcedureStepIDGenerator"), (String)"ScheduledProcedureStepID"));
        ext.setRejectExpiredStudiesPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmRejectExpiredStudiesPollingInterval"), null));
        ext.setRejectExpiredStudiesSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmRejectExpiredStudiesSchedule"), (String[])new String[0])));
        ext.setRejectExpiredStudiesFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmRejectExpiredStudiesFetchSize"), (int)0));
        ext.setRejectExpiredSeriesFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmRejectExpiredSeriesFetchSize"), (int)0));
        ext.setRejectExpiredStudiesAETitle(LdapUtils.stringValue((Attribute)attrs.get("dcmRejectExpiredStudiesAETitle"), null));
        ext.setFallbackCMoveSCPStudyOlderThan(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCPStudyOlderThan"), null));
        ext.setStorePermissionServiceURL(LdapUtils.stringValue((Attribute)attrs.get("dcmStorePermissionServiceURL"), null));
        ext.setStorePermissionServiceResponse(LdapUtils.stringValue((Attribute)attrs.get("dcmStorePermissionServiceResponse"), null));
        ext.setStorePermissionServiceResponsePattern(LdapArchiveConfiguration.toPattern(attrs.get("dcmStorePermissionServiceResponsePattern")));
        ext.setStorePermissionCacheStaleTimeout(LdapArchiveConfiguration.toDuration(attrs.get("dcmStorePermissionCacheStaleTimeout"), null));
        ext.setStorePermissionCacheSize(LdapUtils.intValue((Attribute)attrs.get("dcmStorePermissionCacheSize"), (int)10));
        ext.setMergeMWLCacheStaleTimeout(LdapArchiveConfiguration.toDuration(attrs.get("dcmMergeMWLCacheStaleTimeout"), null));
        ext.setMergeMWLCacheSize(LdapUtils.intValue((Attribute)attrs.get("dcmMergeMWLCacheSize"), (int)10));
        ext.setStoreUpdateDBMaxRetries(LdapUtils.intValue((Attribute)attrs.get("dcmStoreUpdateDBMaxRetries"), (int)3));
        ext.setStoreUpdateDBMinRetryDelay(LdapUtils.intValue((Attribute)attrs.get("dcmStoreUpdateDBMinRetryDelay"), (int)500));
        ext.setStoreUpdateDBMaxRetryDelay(LdapUtils.intValue((Attribute)attrs.get("dcmStoreUpdateDBMaxRetryDelay"), (int)1000));
        ext.setAllowRejectionForDataRetentionPolicyExpired((AllowRejectionForDataRetentionPolicyExpired)LdapUtils.enumValue(AllowRejectionForDataRetentionPolicyExpired.class, (Attribute)attrs.get("dcmAllowRejectionForDataRetentionPolicyExpired"), (Enum)AllowRejectionForDataRetentionPolicyExpired.EXPIRED_UNSET));
        ext.setAcceptMissingPatientID((AcceptMissingPatientID)LdapUtils.enumValue(AcceptMissingPatientID.class, (Attribute)attrs.get("dcmAcceptMissingPatientID"), (Enum)AcceptMissingPatientID.CREATE));
        ext.setAllowDeleteStudyPermanently((AllowDeleteStudyPermanently)LdapUtils.enumValue(AllowDeleteStudyPermanently.class, (Attribute)attrs.get("dcmAllowDeleteStudyPermanently"), (Enum)AllowDeleteStudyPermanently.REJECTED));
        ext.setAllowDeletePatient((AllowDeletePatient)LdapUtils.enumValue(AllowDeletePatient.class, (Attribute)attrs.get("dcmAllowDeletePatient"), (Enum)AllowDeletePatient.WITHOUT_STUDIES));
        ext.setStorePermissionServiceExpirationDatePattern(LdapArchiveConfiguration.toPattern(attrs.get("dcmStorePermissionServiceExpirationDatePattern")));
        ext.setShowPatientInfoInSystemLog((ShowPatientInfo)LdapUtils.enumValue(ShowPatientInfo.class, (Attribute)attrs.get("dcmShowPatientInfoInSystemLog"), (Enum)ShowPatientInfo.PLAIN_TEXT));
        ext.setShowPatientInfoInAuditLog((ShowPatientInfo)LdapUtils.enumValue(ShowPatientInfo.class, (Attribute)attrs.get("dcmShowPatientInfoInAuditLog"), (Enum)ShowPatientInfo.PLAIN_TEXT));
        ext.setPurgeStgCmtCompletedDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeStgCmtCompletedDelay"), null));
        ext.setPurgeStgCmtPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeStgCmtPollingInterval"), null));
        ext.setDefaultCharacterSet(LdapUtils.stringValue((Attribute)attrs.get("dcmDefaultCharacterSet"), null));
        ext.setDicomCharsetNameMappings(LdapUtils.stringArray((Attribute)attrs.get("dcmCharsetNameMapping"), (String[])new String[0]));
        ext.setHL7CharsetNameMappings(LdapUtils.stringArray((Attribute)attrs.get("hl7CharsetNameMapping"), (String[])new String[0]));
        ext.setUPSEventWebSocketQueueSizes(LdapUtils.stringArray((Attribute)attrs.get("dcmUPSEventWebSocketQueueSize"), (String[])new String[0]));
        ext.setUPSWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSWorklistLabel"), null));
        ext.setUPSEventSCUs(LdapUtils.stringArray((Attribute)attrs.get("dcmUPSEventSCU"), (String[])new String[0]));
        ext.setUPSEventSCUKeepAlive(LdapUtils.intValue((Attribute)attrs.get("dcmUPSEventSCUKeepAlive"), (int)0));
        ext.setStorePermissionServiceErrorCommentPattern(LdapArchiveConfiguration.toPattern(attrs.get("dcmStorePermissionServiceErrorCommentPattern")));
        ext.setStorePermissionServiceErrorCodePattern(LdapArchiveConfiguration.toPattern(attrs.get("dcmStorePermissionServiceErrorCodePattern")));
        ext.setRetrieveAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmRetrieveAET"), (String[])new String[0]));
        ext.setReturnRetrieveAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmReturnRetrieveAET"), (String[])new String[0]));
        ext.setMultipleStoreAssociations(LdapUtils.stringArray((Attribute)attrs.get("dcmMultipleStoreAssociations"), (String[])new String[0]));
        ext.setExternalRetrieveAEDestination(LdapUtils.stringValue((Attribute)attrs.get("dcmExternalRetrieveAEDestination"), null));
        ext.setXDSiImagingDocumentSourceAETitle(LdapUtils.stringValue((Attribute)attrs.get("dcmXDSiImagingDocumentSourceAETitle"), null));
        ext.setRemapRetrieveURL(LdapUtils.stringValue((Attribute)attrs.get("dcmRemapRetrieveURL"), null));
        ext.setValidateCallingAEHostname(LdapUtils.booleanValue((Attribute)attrs.get("dcmValidateCallingAEHostname"), (boolean)false));
        ext.setHL7PSUSendingApplication(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUSendingApplication"), null));
        ext.setHL7PSUReceivingApplications(LdapUtils.stringArray((Attribute)attrs.get("hl7PSUReceivingApplication"), (String[])new String[0]));
        ext.setHL7PSUDelay(LdapArchiveConfiguration.toDuration(attrs.get("hl7PSUDelay"), null));
        ext.setHL7PSUTimeout(LdapArchiveConfiguration.toDuration(attrs.get("hl7PSUTimeout"), null));
        ext.setHL7PSUOnTimeout(LdapUtils.booleanValue((Attribute)attrs.get("hl7PSUOnTimeout"), (boolean)false));
        ext.setHL7PSUTaskPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("hl7PSUTaskPollingInterval"), null));
        ext.setHL7PSUTaskFetchSize(LdapUtils.intValue((Attribute)attrs.get("hl7PSUTaskFetchSize"), (int)100));
        ext.setHL7PSUMWL(LdapUtils.booleanValue((Attribute)attrs.get("hl7PSUMWL"), (boolean)false));
        ext.setHL7PSUMWLMatchingKey((HL7PSUMWLMatchingKey)LdapUtils.enumValue(HL7PSUMWLMatchingKey.class, (Attribute)attrs.get("hl7PSUMWLMatchingKey"), (Enum)HL7PSUMWLMatchingKey.StudyInstanceUID));
        ext.setHl7PSUForRequestedProcedure(LdapUtils.booleanValue((Attribute)attrs.get("hl7PSUForRequestedProcedure"), (boolean)false));
        ext.setHl7PSUPIDPV1(LdapUtils.booleanValue((Attribute)attrs.get("hl7PSUPIDPV1"), (boolean)false));
        ext.setHl7PSURequestedProcedureID(LdapUtils.stringValue((Attribute)attrs.get("hl7PSURequestedProcedureID"), null));
        ext.setHl7PSUAccessionNumber(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUAccessionNumber"), null));
        ext.setHl7PSUFillerOrderNumber(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUFillerOrderNumber"), null));
        ext.setHl7PSUPlacerOrderNumber(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUPlacerOrderNumber"), null));
        ext.setHL7PSUTemplateParams(LdapUtils.stringArray((Attribute)attrs.get("hl7PSUTemplateParam"), (String[])new String[0]));
        ext.setHl7PSUMessageType((HL7PSUMessageType)LdapUtils.enumValue(HL7PSUMessageType.class, (Attribute)attrs.get("hl7PSUMessageType"), (Enum)HL7PSUMessageType.OMG_O19));
        ext.setHl7PSUConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("hl7PSUCondition"), (String[])new String[0])));
        ext.setHl7PSUMppsTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUMppsTemplateURI"), null));
        ext.setHl7PSUStudyTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUStudyTemplateURI"), null));
        ext.setAcceptConflictingPatientID((AcceptConflictingPatientID)LdapUtils.enumValue(AcceptConflictingPatientID.class, (Attribute)attrs.get("dcmAcceptConflictingPatientID"), (Enum)AcceptConflictingPatientID.MERGED));
        ext.setProxyUpstreamURL(LdapUtils.stringValue((Attribute)attrs.get("dcmProxyUpstreamURL"), null));
        ext.setAudit2JsonFhirTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmAudit2JsonFhirTemplateURI"), null));
        ext.setAudit2XmlFhirTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmAudit2XmlFhirTemplateURI"), null));
        ext.setCopyMoveUpdatePolicy((Attributes.UpdatePolicy)LdapUtils.enumValue(Attributes.UpdatePolicy.class, (Attribute)attrs.get("dcmCopyMoveUpdatePolicy"), (Enum)Attributes.UpdatePolicy.PRESERVE));
        ext.setLinkMWLEntryUpdatePolicy((Attributes.UpdatePolicy)LdapUtils.enumValue(Attributes.UpdatePolicy.class, (Attribute)attrs.get("dcmLinkMWLEntryUpdatePolicy"), (Enum)Attributes.UpdatePolicy.PRESERVE));
        ext.setStorageVerificationPolicy((StorageVerificationPolicy)LdapUtils.enumValue(StorageVerificationPolicy.class, (Attribute)attrs.get("dcmStorageVerificationPolicy"), (Enum)StorageVerificationPolicy.OBJECT_CHECKSUM));
        ext.setStorageVerificationUpdateLocationStatus(LdapUtils.booleanValue((Attribute)attrs.get("dcmStorageVerificationUpdateLocationStatus"), (boolean)false));
        ext.setStorageVerificationStorageIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmStorageVerificationStorageID"), (String[])new String[0]));
        ext.setStorageVerificationAETitle(LdapUtils.stringValue((Attribute)attrs.get("dcmStorageVerificationAETitle"), null));
        ext.setStorageVerificationBatchID(LdapUtils.stringValue((Attribute)attrs.get("dcmStorageVerificationBatchID"), null));
        ext.setStorageVerificationInitialDelay(LdapArchiveConfiguration.toPeriod(attrs.get("dcmStorageVerificationInitialDelay")));
        ext.setStorageVerificationPeriod(LdapArchiveConfiguration.toPeriod(attrs.get("dcmStorageVerificationPeriod")));
        ext.setStorageVerificationMaxScheduled(LdapUtils.intValue((Attribute)attrs.get("dcmStorageVerificationMaxScheduled"), (int)0));
        ext.setStorageVerificationPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmStorageVerificationPollingInterval"), null));
        ext.setStorageVerificationSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmStorageVerificationSchedule"), (String[])new String[0])));
        ext.setStorageVerificationFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmStorageVerificationFetchSize"), (int)100));
        ext.setUpdateLocationStatusOnRetrieve(LdapUtils.booleanValue((Attribute)attrs.get("dcmUpdateLocationStatusOnRetrieve"), (boolean)false));
        ext.setStorageVerificationOnRetrieve(LdapUtils.booleanValue((Attribute)attrs.get("dcmStorageVerificationOnRetrieve"), (boolean)false));
        ext.setHL7TrackChangedPatientID(LdapUtils.booleanValue((Attribute)attrs.get("hl7TrackChangedPatientID"), (boolean)true));
        ext.setHL7ADTReceivingApplication(LdapUtils.stringArray((Attribute)attrs.get("hl7ADTReceivingApplication"), (String[])new String[0]));
        ext.setHL7ADTSendingApplication(LdapUtils.stringValue((Attribute)attrs.get("hl7ADTSendingApplication"), null));
        ext.setHL7ScheduledProtocolCodeInOrder((ScheduledProtocolCodeInOrder)LdapUtils.enumValue(ScheduledProtocolCodeInOrder.class, (Attribute)attrs.get("hl7ScheduledProtocolCodeInOrder"), (Enum)ScheduledProtocolCodeInOrder.OBR_4_4));
        ext.setHL7ScheduledStationAETInOrder((ScheduledStationAETInOrder)LdapUtils.enumValue(ScheduledStationAETInOrder.class, (Attribute)attrs.get("hl7ScheduledStationAETInOrder"), null));
        ext.setHL7NoPatientCreateMessageTypes(LdapUtils.stringArray((Attribute)attrs.get("hl7NoPatientCreateMessageType"), (String[])new String[0]));
        ext.setAuditUnknownStudyInstanceUID(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditUnknownStudyInstanceUID"), (String)"1.2.40.0.13.1.15.110.3.165.1"));
        ext.setAuditUnknownPatientID(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditUnknownPatientID"), (String)"<none>"));
        ext.setAuditSoftwareConfigurationVerbose(LdapUtils.booleanValue((Attribute)attrs.get("dcmAuditSoftwareConfigurationVerbose"), (boolean)false));
        ext.setHL7UseNullValue(LdapUtils.booleanValue((Attribute)attrs.get("hl7UseNullValue"), (boolean)false));
        ext.setQueueTasksFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmQueueTasksFetchSize"), (int)100));
        ext.setRejectionNoteStorageAET(LdapUtils.stringValue((Attribute)attrs.get("dcmRejectionNoteStorageAET"), null));
        ext.setXRoadProperties(LdapUtils.stringArray((Attribute)attrs.get("dcmXRoadProperty"), (String[])new String[0]));
        ext.setImpaxReportProperties(LdapUtils.stringArray((Attribute)attrs.get("dcmImpaxReportProperty"), (String[])new String[0]));
        ext.setUiConfigurationDeviceName(LdapUtils.stringValue((Attribute)attrs.get("dcmUIConfigurationDeviceName"), null));
        ext.setCompressionAETitle(LdapUtils.stringValue((Attribute)attrs.get("dcmCompressionAETitle"), null));
        ext.setCompressionPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmCompressionPollingInterval"), null));
        ext.setCompressionFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmCompressionFetchSize"), (int)100));
        ext.setCompressionSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmCompressionSchedule"), (String[])new String[0])));
        ext.setCompressionThreads(LdapUtils.intValue((Attribute)attrs.get("dcmCompressionThreads"), (int)1));
        ext.setDiffTaskProgressUpdateInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmDiffTaskProgressUpdateInterval"), null));
        ext.setPatientVerificationPDQServiceID(LdapUtils.stringValue((Attribute)attrs.get("dcmPatientVerificationPDQServiceID"), null));
        ext.setPatientVerificationPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmPatientVerificationPollingInterval"), null));
        ext.setPatientVerificationFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmPatientVerificationFetchSize"), (int)100));
        ext.setPatientVerificationAdjustIssuerOfPatientID(LdapUtils.booleanValue((Attribute)attrs.get("dcmPatientVerificationAdjustIssuerOfPatientID"), (boolean)false));
        ext.setPatientVerificationPeriod(LdapArchiveConfiguration.toPeriod(attrs.get("dcmPatientVerificationPeriod")));
        ext.setPatientVerificationPeriodOnNotFound(LdapArchiveConfiguration.toPeriod(attrs.get("dcmPatientVerificationPeriodOnNotFound")));
        ext.setPatientVerificationRetryInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmPatientVerificationRetryInterval"), null));
        ext.setPatientVerificationMaxRetries(LdapUtils.intValue((Attribute)attrs.get("dcmPatientVerificationMaxRetries"), (int)0));
        ext.setPatientVerificationMaxStaleness(LdapArchiveConfiguration.toDuration(attrs.get("dcmPatientVerificationMaxStaleness"), null));
        ext.setCSVUploadChunkSize(LdapUtils.intValue((Attribute)attrs.get("dcmCSVUploadChunkSize"), (int)100));
        ext.setHl7OrderMissingStudyIUIDPolicy((HL7OrderMissingStudyIUIDPolicy)LdapUtils.enumValue(HL7OrderMissingStudyIUIDPolicy.class, (Attribute)attrs.get("hl7OrderMissingStudyIUIDPolicy"), (Enum)HL7OrderMissingStudyIUIDPolicy.GENERATE));
        ext.setHl7OrderMissingAdmissionIDPolicy((HL7OrderMissingAdmissionIDPolicy)LdapUtils.enumValue(HL7OrderMissingAdmissionIDPolicy.class, (Attribute)attrs.get("hl7OrderMissingAdmissionIDPolicy"), (Enum)HL7OrderMissingAdmissionIDPolicy.ACCEPT));
        ext.setHl7ImportReportMissingStudyIUIDPolicy((HL7ImportReportMissingStudyIUIDPolicy)LdapUtils.enumValue(HL7ImportReportMissingStudyIUIDPolicy.class, (Attribute)attrs.get("hl7ImportReportMissingStudyIUIDPolicy"), (Enum)HL7ImportReportMissingStudyIUIDPolicy.GENERATE));
        ext.setHl7ImportReportMissingAdmissionIDPolicy((HL7ImportReportMissingAdmissionIDPolicy)LdapUtils.enumValue(HL7ImportReportMissingAdmissionIDPolicy.class, (Attribute)attrs.get("hl7ImportReportMissingAdmissionIDPolicy"), (Enum)HL7ImportReportMissingAdmissionIDPolicy.ACCEPT));
        ext.setHl7ImportReportMissingStudyIUIDCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("hl7ImportReportMissingStudyIUIDCFindSCP"), null));
        ext.setHl7ImportReportAdjustIUID((HL7ImportReportAdjustIUID)LdapUtils.enumValue(HL7ImportReportAdjustIUID.class, (Attribute)attrs.get("hl7ImportReportAdjustIUID"), (Enum)HL7ImportReportAdjustIUID.NONE));
        ext.setHl7DicomCharacterSet(LdapUtils.stringValue((Attribute)attrs.get("hl7DicomCharacterSet"), null));
        ext.setHl7VeterinaryUsePatientName(LdapUtils.booleanValue((Attribute)attrs.get("hl7VeterinaryUsePatientName"), (boolean)false));
        ext.setValidateUID(LdapUtils.booleanValue((Attribute)attrs.get("dcmValidateUID"), (boolean)true));
        ext.setRelationalQueryNegotiationLenient(LdapUtils.booleanValue((Attribute)attrs.get("dcmRelationalQueryNegotiationLenient"), (boolean)false));
        ext.setRelationalRetrieveNegotiationLenient(LdapUtils.booleanValue((Attribute)attrs.get("dcmRelationalRetrieveNegotiationLenient"), (boolean)false));
        ext.setSchedulerMinStartDelay(LdapUtils.intValue((Attribute)attrs.get("dcmSchedulerMinStartDelay"), (int)60));
        ext.setRejectConflictingPatientAttribute(LdapArchiveConfiguration.tags(attrs.get("dcmRejectConflictingPatientAttribute")));
        ext.setStowRetiredTransferSyntax(LdapUtils.booleanValue((Attribute)attrs.get("dcmStowRetiredTransferSyntax"), (boolean)false));
        ext.setStowExcludeAPPMarkers(LdapUtils.booleanValue((Attribute)attrs.get("dcmStowExcludeAPPMarkers"), (boolean)false));
        ext.setRestrictRetrieveSilently(LdapUtils.booleanValue((Attribute)attrs.get("dcmRestrictRetrieveSilently"), (boolean)false));
        ext.setStowQuicktime2MP4(LdapUtils.booleanValue((Attribute)attrs.get("dcmStowQuicktime2MP4"), (boolean)false));
        ext.setStowMaxFragmentLength(LdapUtils.longValue((Attribute)attrs.get("dcmStowMaxFragmentLength"), (long)0x7FFFFFFEL));
        ext.setMWLPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmMWLPollingInterval"), null));
        ext.setMWLFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmMWLFetchSize"), (int)100));
        ext.setMWLImportInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmMWLImportInterval"), null));
        ext.setDeleteMWLDelay(LdapUtils.stringArray((Attribute)attrs.get("dcmDeleteMWLDelay"), (String[])new String[0]));
        ext.setUPSProcessingPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmUPSProcessingPollingInterval"), null));
        ext.setUPSProcessingFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmUPSProcessingFetchSize"), (int)100));
        ext.setTaskPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmTaskPollingInterval"), null));
        ext.setTaskFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmTaskFetchSize"), (int)100));
        ext.setHl7ReferredMergedPatientPolicy((HL7ReferredMergedPatientPolicy)LdapUtils.enumValue(HL7ReferredMergedPatientPolicy.class, (Attribute)attrs.get("hl7ReferredMergedPatientPolicy"), (Enum)HL7ReferredMergedPatientPolicy.REJECT));
        ext.setRetrieveTaskWarningOnNoMatch(LdapUtils.booleanValue((Attribute)attrs.get("dcmRetrieveTaskWarningOnNoMatch"), (boolean)false));
        ext.setRetrieveTaskWarningOnWarnings(LdapUtils.booleanValue((Attribute)attrs.get("dcmRetrieveTaskWarningOnWarnings"), (boolean)false));
        ext.setCStoreSCUOfCMoveSCPs(LdapUtils.stringArray((Attribute)attrs.get("dcmCStoreSCUOfCMoveSCP"), (String[])new String[0]));
        ext.setDeleteStudyChunkSize(LdapUtils.intValue((Attribute)attrs.get("dcmDeleteStudyChunkSize"), (int)100));
        ext.setHL7PatientArrivalMessageType(LdapUtils.stringValue((Attribute)attrs.get("hl7PatientArrivalMessageType"), null));
        ext.setUserIdentityNegotiation((UserIdentityNegotiation)LdapUtils.enumValue(UserIdentityNegotiation.class, (Attribute)attrs.get("dcmUserIdentityNegotiation"), (Enum)UserIdentityNegotiation.SUPPORTS));
        ext.setUserIdentityNegotiationRole(LdapUtils.stringValue((Attribute)attrs.get("dcmUserIdentityNegotiationRole"), null));
        ext.setUserIdentityNegotiationKeycloakClientID(LdapUtils.stringValue((Attribute)attrs.get("dcmUserIdentityNegotiationKeycloakClientID"), null));
        ext.setStudySizeDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmCalculateStudySizeDelay"), null));
        ext.setCalculateStudySizePollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmCalculateStudySizePollingInterval"), null));
        ext.setCalculateStudySizeFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmCalculateStudySizeFetchSize"), (int)100));
        ext.setCalculateQueryAttributes(LdapUtils.booleanValue((Attribute)attrs.get("dcmCalculateQueryAttributes"), (boolean)false));
        ext.setStoreImplementationVersionName(LdapUtils.booleanValue((Attribute)attrs.get("dcmStoreImplementationVersionName"), (boolean)true));
        ext.setSupplementIssuerFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmSupplementIssuerFetchSize"), (int)100));
        ext.setUpdateCharsetFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmUpdateCharsetFetchSize"), (int)100));
        ext.setAuditAssigningAuthorityOfPatientID(LdapArchiveConfiguration.toIssuer(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditAssigningAuthorityOfPatientID"), null)));
        ext.setChangeRequesterAET(LdapUtils.stringValue((Attribute)attrs.get("dcmChangeRequesterAET"), null));
        ext.setFilterByIssuerOfPatientID(LdapUtils.booleanValue((Attribute)attrs.get("dcmFilterByIssuerOfPatientID"), (boolean)false));
        ext.setAuditHL7MsgLimit(LdapUtils.intValue((Attribute)attrs.get("dcmAuditHL7MsgLimit"), (int)1000));
        ext.setMatchSOPClassOnInstanceLevel(LdapUtils.booleanValue((Attribute)attrs.get("dcmMatchSOPClassOnInstanceLevel"), (boolean)false));
        ext.setUPSUpdateWithoutTransactionUID(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSUpdateWithoutTransactionUID"), (boolean)false));
        ext.setKeyValueRetentionPollingInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmKeyValueRetentionPollingInterval"), null));
        ext.setKeyValueRetentionFetchSize(LdapUtils.intValue((Attribute)attrs.get("dcmKeyValueRetentionFetchSize"), (int)100));
        ext.setKeyValueRetentionPeriod(LdapArchiveConfiguration.toDuration(attrs.get("dcmKeyValueRetentionPeriod"), null));
    }

    protected void storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, Device prev, Device device, List<ModificationItem> mods) {
        boolean remove;
        ArchiveDeviceExtension aa = (ArchiveDeviceExtension)prev.getDeviceExtension(ArchiveDeviceExtension.class);
        ArchiveDeviceExtension bb = (ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (aa == null && bb == null) {
            return;
        }
        boolean bl = remove = bb == null;
        if (remove) {
            bb = new ArchiveDeviceExtension();
        } else if (aa == null) {
            aa = new ArchiveDeviceExtension();
            mods.add(new ModificationItem(1, LdapUtils.attr((String)"objectClass", (Object[])new String[]{"dcmArchiveDevice"})));
        }
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFuzzyAlgorithmClass", (Object)aa.getFuzzyAlgorithmClass(), (Object)bb.getFuzzyAlgorithmClass(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmBulkDataDescriptorID", (Object)aa.getBulkDataDescriptorID(), (Object)bb.getBulkDataDescriptorID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataStorageID", (Object[])aa.getSeriesMetadataStorageIDs(), (Object[])bb.getSeriesMetadataStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataDelay", (Object)aa.getSeriesMetadataDelay(), (Object)bb.getSeriesMetadataDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataPollingInterval", (Object)aa.getSeriesMetadataPollingInterval(), (Object)bb.getSeriesMetadataPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataFetchSize", (int)aa.getSeriesMetadataFetchSize(), (int)bb.getSeriesMetadataFetchSize(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataThreads", (int)aa.getSeriesMetadataThreads(), (int)bb.getSeriesMetadataThreads(), (int)1);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataMaxRetries", (int)aa.getSeriesMetadataMaxRetries(), (int)bb.getSeriesMetadataMaxRetries(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataRetryInterval", (Object)aa.getSeriesMetadataRetryInterval(), (Object)bb.getSeriesMetadataRetryInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeInstanceRecords", (boolean)aa.isPurgeInstanceRecords(), (boolean)bb.isPurgeInstanceRecords(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeInstanceRecordsDelay", (Object)aa.getPurgeInstanceRecordsDelay(), (Object)bb.getPurgeInstanceRecordsDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeInstanceRecordsPollingInterval", (Object)aa.getPurgeInstanceRecordsPollingInterval(), (Object)bb.getPurgeInstanceRecordsPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeInstanceRecordsFetchSize", (int)aa.getPurgeInstanceRecordsFetchSize(), (int)bb.getPurgeInstanceRecordsFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteUPSPollingInterval", (Object)aa.getDeleteUPSPollingInterval(), (Object)bb.getDeleteUPSPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteUPSFetchSize", (int)aa.getDeleteUPSFetchSize(), (int)bb.getDeleteUPSFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteUPSCompletedDelay", (Object)aa.getDeleteUPSCompletedDelay(), (Object)bb.getDeleteUPSCompletedDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteUPSCanceledDelay", (Object)aa.getDeleteUPSCanceledDelay(), (Object)bb.getDeleteUPSCanceledDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmOverwritePolicy", (Object)aa.getOverwritePolicy(), (Object)bb.getOverwritePolicy(), (Object)OverwritePolicy.NEVER);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRecordAttributeModification", (boolean)aa.isRecordAttributeModification(), (boolean)bb.isRecordAttributeModification(), (boolean)true);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIdentifyPatientByAllAttributes", (boolean)aa.isIdentifyPatientByAllAttributes(), (boolean)bb.isIdentifyPatientByAllAttributes(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmBulkDataSpoolDirectory", (Object)aa.getBulkDataSpoolDirectory(), (Object)bb.getBulkDataSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPersonNameComponentOrderInsensitiveMatching", (boolean)aa.isPersonNameComponentOrderInsensitiveMatching(), (boolean)bb.isPersonNameComponentOrderInsensitiveMatching(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSendPendingCGet", (boolean)aa.isSendPendingCGet(), (boolean)bb.isSendPendingCGet(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSendPendingCMoveInterval", (Object)aa.getSendPendingCMoveInterval(), (Object)bb.getSendPendingCMoveInterval(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSpanningCFindSCP", (Object)aa.getSpanningCFindSCP(), (Object)bb.getSpanningCFindSCP(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSpanningCFindSCPRetrieveAET", (Object[])aa.getSpanningCFindSCPRetrieveAETitles(), (Object[])bb.getSpanningCFindSCPRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSpanningCFindSCPPolicy", (Object)aa.getSpanningCFindSCPPolicy(), (Object)bb.getSpanningCFindSCPPolicy(), (Object)SpanningCFindSCPPolicy.REPLACE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCP", (Object)aa.getFallbackCMoveSCP(), (Object)bb.getFallbackCMoveSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPDestination", (Object)aa.getFallbackCMoveSCPDestination(), (Object)bb.getFallbackCMoveSCPDestination(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPCallingAET", (Object)aa.getFallbackCMoveSCPCallingAET(), (Object)bb.getFallbackCMoveSCPCallingAET(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPRetries", (int)aa.getFallbackCMoveSCPRetries(), (int)bb.getFallbackCMoveSCPRetries(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPLeadingCFindSCP", (Object)aa.getFallbackCMoveSCPLeadingCFindSCP(), (Object)bb.getFallbackCMoveSCPLeadingCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAltCMoveSCP", (Object)aa.getAlternativeCMoveSCP(), (Object)bb.getAlternativeCMoveSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoZIPEntryNameFormat", (Object)aa.getWadoZIPEntryNameFormat(), (Object)bb.getWadoZIPEntryNameFormat(), (Object)"DICOM/{0020000D,hash}/{0020000E,hash}/{00080018,hash}.dcm");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoSR2HtmlTemplateURI", (Object)aa.getWadoSR2HtmlTemplateURI(), (Object)bb.getWadoSR2HtmlTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoSR2TextTemplateURI", (Object)aa.getWadoSR2TextTemplateURI(), (Object)bb.getWadoSR2TextTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoCDA2HtmlTemplateURI", (Object)aa.getWadoCDA2HtmlTemplateURI(), (Object)bb.getWadoCDA2HtmlTemplateURI(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoSupportedSRClasses", (Object[])aa.getWadoSupportedSRClasses(), (Object[])bb.getWadoSupportedSRClasses(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoSupportedPRClasses", (Object[])aa.getWadoSupportedPRClasses(), (Object[])bb.getWadoSupportedPRClasses(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoSpoolDirectory", (Object)aa.getWadoSpoolDirectory(), (Object)bb.getWadoSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoThumbnailViewport", (Object)aa.getWadoThumbnailViewPort(), (Object)bb.getWadoThumbnailViewPort(), (Object)"64,64");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackWadoURIWebAppName", (Object)aa.getFallbackWadoURIWebApplication(), (Object)bb.getFallbackWadoURIWebApplication(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackWadoURIHttpStatusCode", (int)aa.getFallbackWadoURIHttpStatusCode(), (int)bb.getFallbackWadoURIHttpStatusCode(), (int)303);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoIgnorePresentationLUTShape", (boolean)aa.isWadoIgnorePresentationLUTShape(), (boolean)bb.isWadoIgnorePresentationLUTShape(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoMetadataExcludePrivate", (boolean)aa.isWadoMetadataWithoutPrivate(), (boolean)bb.isWadoMetadataWithoutPrivate(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportTemplateURI", (Object)aa.getImportReportTemplateURI(), (Object)bb.getImportReportTemplateURI(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportTemplateParam", (Map)aa.getImportReportTemplateParams(), (Map)bb.getImportReportTemplateParams());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PatientUpdateTemplateURI", (Object)aa.getPatientUpdateTemplateURI(), (Object)bb.getPatientUpdateTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ScheduleProcedureTemplateURI", (Object)aa.getScheduleProcedureTemplateURI(), (Object)bb.getScheduleProcedureTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OutgoingPatientUpdateTemplateURI", (Object)aa.getOutgoingPatientUpdateTemplateURI(), (Object)bb.getOutgoingPatientUpdateTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7LogFilePattern", (Object)aa.getHL7LogFilePattern(), (Object)bb.getHL7LogFilePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ErrorLogFilePattern", (Object)aa.getHL7ErrorLogFilePattern(), (Object)bb.getHL7ErrorLogFilePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUnzipVendorDataToURI", (Object)aa.getUnzipVendorDataToURI(), (Object)bb.getUnzipVendorDataToURI(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQueryFetchSize", (int)aa.getQueryFetchSize(), (int)bb.getQueryFetchSize(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQueryMaxNumberOfResults", (int)aa.getQueryMaxNumberOfResults(), (int)bb.getQueryMaxNumberOfResults(), (int)0);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQidoMaxNumberOfResults", (int)aa.getQidoMaxNumberOfResults(), (int)bb.getQidoMaxNumberOfResults(), (int)0);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQidoETag", (boolean)aa.isQidoETag(), (boolean)bb.isQidoETag(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFwdMppsDestination", (Object[])aa.getMppsForwardDestinations(), (Object[])bb.getMppsForwardDestinations(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanDestination", (Object[])aa.getIanDestinations(), (Object[])bb.getIanDestinations(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanDelay", (Object)aa.getIanDelay(), (Object)bb.getIanDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanTimeout", (Object)aa.getIanTimeout(), (Object)bb.getIanTimeout(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanOnTimeout", (boolean)aa.isIanOnTimeout(), (boolean)bb.isIanOnTimeout(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanTaskPollingInterval", (Object)aa.getIanTaskPollingInterval(), (Object)bb.getIanTaskPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanTaskFetchSize", (int)aa.getIanTaskFetchSize(), (int)bb.getIanTaskFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeStoragePollingInterval", (Object)aa.getPurgeStoragePollingInterval(), (Object)bb.getPurgeStoragePollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeStorageFetchSize", (int)aa.getPurgeStorageFetchSize(), (int)bb.getPurgeStorageFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFailedToDeletePollingInterval", (Object)aa.getFailedToDeletePollingInterval(), (Object)bb.getFailedToDeletePollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFailedToDeleteFetchSize", (int)aa.getFailedToDeleteFetchSize(), (int)bb.getFailedToDeleteFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteRejectedPollingInterval", (Object)aa.getDeleteRejectedPollingInterval(), (Object)bb.getDeleteRejectedPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteRejectedFetchSize", (int)aa.getDeleteRejectedFetchSize(), (int)bb.getDeleteRejectedFetchSize(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteStudyBatchSize", (int)aa.getDeleteStudyBatchSize(), (int)bb.getDeleteStudyBatchSize(), (int)10);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeletePatientOnDeleteLastStudy", (boolean)aa.isDeletePatientOnDeleteLastStudy(), (boolean)bb.isDeletePatientOnDeleteLastStudy(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMaxAccessTimeStaleness", (Object)aa.getMaxAccessTimeStaleness(), (Object)bb.getMaxAccessTimeStaleness(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAECacheStaleTimeout", (Object)aa.getAECacheStaleTimeout(), (Object)bb.getAECacheStaleTimeout(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmLeadingCFindSCPQueryCacheStaleTimeout", (Object)aa.getLeadingCFindSCPQueryCacheStaleTimeout(), (Object)bb.getLeadingCFindSCPQueryCacheStaleTimeout(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmLeadingCFindSCPQueryCacheSize", (int)aa.getLeadingCFindSCPQueryCacheSize(), (int)bb.getLeadingCFindSCPQueryCacheSize(), (int)10);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditSpoolDirectory", (Object)aa.getAuditSpoolDirectory(), (Object)bb.getAuditSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditPollingInterval", (Object)aa.getAuditPollingInterval(), (Object)bb.getAuditPollingInterval(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditAggregateDuration", (Object)aa.getAuditAggregateDuration(), (Object)bb.getAuditAggregateDuration(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowSpoolDirectory", (Object)aa.getStowSpoolDirectory(), (Object)bb.getStowSpoolDirectory(), (Object)"${jboss.server.temp.dir}");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeQueueMessagePollingInterval", (Object)aa.getPurgeTaskPollingInterval(), (Object)bb.getPurgeTaskPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHideSPSWithStatusFromMWL", (Object[])aa.getHideSPSWithStatusFrom(), (Object[])bb.getHideSPSWithStatusFrom(), (Object[])new SPSStatus[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHideSPSWithStatusFromMWLRS", (Object[])aa.getHideSPSWithStatusFromMWLRS(), (Object[])bb.getHideSPSWithStatusFromMWLRS(), (Object[])new SPSStatus[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEncodeAsJSONNumber", (Object[])aa.getEncodeAsJSONNumber(), (Object[])bb.getEncodeAsJSONNumber(), (Object[])new VR[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ORUAction", (Object[])aa.getHl7ORUAction(), (Object[])bb.getHl7ORUAction(), (Object[])new HL7ORUAction[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLAccessionNumberGenerator", (Object)aa.getMWLAccessionNumberGenerator(), (Object)bb.getMWLAccessionNumberGenerator(), (Object)"AccessionNumber");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLRequestedProcedureIDGenerator", (Object)aa.getMWLRequestedProcedureIDGenerator(), (Object)bb.getMWLRequestedProcedureIDGenerator(), (Object)"RequestedProcedureID");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLScheduledProcedureStepIDGenerator", (Object)aa.getMWLScheduledProcedureStepIDGenerator(), (Object)bb.getMWLScheduledProcedureStepIDGenerator(), (Object)"ScheduledProcedureStepID");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectExpiredStudiesPollingInterval", (Object)aa.getRejectExpiredStudiesPollingInterval(), (Object)bb.getRejectExpiredStudiesPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectExpiredStudiesSchedule", (Object[])aa.getRejectExpiredStudiesSchedules(), (Object[])bb.getRejectExpiredStudiesSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectExpiredStudiesFetchSize", (int)aa.getRejectExpiredStudiesFetchSize(), (int)bb.getRejectExpiredStudiesFetchSize(), (int)0);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectExpiredSeriesFetchSize", (int)aa.getRejectExpiredSeriesFetchSize(), (int)bb.getRejectExpiredSeriesFetchSize(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectExpiredStudiesAETitle", (Object)aa.getRejectExpiredStudiesAETitle(), (Object)bb.getRejectExpiredStudiesAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPStudyOlderThan", (Object)aa.getFallbackCMoveSCPStudyOlderThan(), (Object)bb.getFallbackCMoveSCPStudyOlderThan(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceURL", (Object)aa.getStorePermissionServiceURL(), (Object)bb.getStorePermissionServiceURL(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceResponse", (Object)aa.getStorePermissionServiceResponse(), (Object)bb.getStorePermissionServiceResponse(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceResponsePattern", (Object)aa.getStorePermissionServiceResponsePattern(), (Object)bb.getStorePermissionServiceResponsePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionCacheStaleTimeout", (Object)aa.getStorePermissionCacheStaleTimeout(), (Object)bb.getStorePermissionCacheStaleTimeout(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionCacheSize", (int)aa.getStorePermissionCacheSize(), (int)bb.getStorePermissionCacheSize(), (int)10);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeMWLCacheStaleTimeout", (Object)aa.getMergeMWLCacheStaleTimeout(), (Object)bb.getMergeMWLCacheStaleTimeout(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeMWLCacheSize", (int)aa.getMergeMWLCacheSize(), (int)bb.getMergeMWLCacheSize(), (int)10);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStoreUpdateDBMaxRetries", (int)aa.getStoreUpdateDBMaxRetries(), (int)bb.getStoreUpdateDBMaxRetries(), (int)3);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStoreUpdateDBMinRetryDelay", (int)aa.getStoreUpdateDBMinRetryDelay(), (int)bb.getStoreUpdateDBMinRetryDelay(), (int)500);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStoreUpdateDBMaxRetryDelay", (int)aa.getStoreUpdateDBMaxRetryDelay(), (int)bb.getStoreUpdateDBMaxRetryDelay(), (int)1000);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAllowRejectionForDataRetentionPolicyExpired", (Object)aa.getAllowRejectionForDataRetentionPolicyExpired(), (Object)bb.getAllowRejectionForDataRetentionPolicyExpired(), (Object)AllowRejectionForDataRetentionPolicyExpired.EXPIRED_UNSET);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptMissingPatientID", (Object)aa.getAcceptMissingPatientID(), (Object)bb.getAcceptMissingPatientID(), (Object)AcceptMissingPatientID.CREATE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAllowDeleteStudyPermanently", (Object)aa.getAllowDeleteStudyPermanently(), (Object)bb.getAllowDeleteStudyPermanently(), (Object)AllowDeleteStudyPermanently.REJECTED);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAllowDeletePatient", (Object)aa.getAllowDeletePatient(), (Object)bb.getAllowDeletePatient(), (Object)AllowDeletePatient.WITHOUT_STUDIES);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceExpirationDatePattern", (Object)aa.getStorePermissionServiceExpirationDatePattern(), (Object)bb.getStorePermissionServiceExpirationDatePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmShowPatientInfoInSystemLog", (Object)aa.getShowPatientInfoInSystemLog(), (Object)bb.getShowPatientInfoInSystemLog(), (Object)ShowPatientInfo.PLAIN_TEXT);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmShowPatientInfoInAuditLog", (Object)aa.getShowPatientInfoInAuditLog(), (Object)bb.getShowPatientInfoInAuditLog(), (Object)ShowPatientInfo.PLAIN_TEXT);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeStgCmtCompletedDelay", (Object)aa.getPurgeStgCmtCompletedDelay(), (Object)bb.getPurgeStgCmtCompletedDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeStgCmtPollingInterval", (Object)aa.getPurgeStgCmtPollingInterval(), (Object)bb.getPurgeStgCmtPollingInterval(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDefaultCharacterSet", (Object)aa.getDefaultCharacterSet(), (Object)bb.getDefaultCharacterSet(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCharsetNameMapping", (Map)aa.getDicomCharsetNameMappings(), (Map)bb.getDicomCharsetNameMappings());
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7CharsetNameMapping", (Map)aa.getHL7CharsetNameMappings(), (Map)bb.getHL7CharsetNameMappings());
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSEventWebSocketQueueSize", (Map)aa.getUPSEventWebSocketQueueSizes(), (Map)bb.getUPSEventWebSocketQueueSizes());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSWorklistLabel", (Object)aa.getUPSWorklistLabel(), (Object)bb.getUPSWorklistLabel(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSEventSCU", (Object[])aa.getUPSEventSCUs(), (Object[])bb.getUPSEventSCUs(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSEventSCUKeepAlive", (int)aa.getUPSEventSCUKeepAlive(), (int)bb.getUPSEventSCUKeepAlive(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceErrorCommentPattern", (Object)aa.getStorePermissionServiceErrorCommentPattern(), (Object)bb.getStorePermissionServiceErrorCommentPattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceErrorCodePattern", (Object)aa.getStorePermissionServiceErrorCodePattern(), (Object)bb.getStorePermissionServiceErrorCodePattern(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveAET", (Object[])aa.getRetrieveAETitles(), (Object[])bb.getRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmReturnRetrieveAET", (Object[])aa.getReturnRetrieveAETitles(), (Object[])bb.getReturnRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMultipleStoreAssociations", (Object[])aa.getMultipleStoreAssociations(), (Object[])bb.getMultipleStoreAssociations(), (Object[])new MultipleStoreAssociations[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExternalRetrieveAEDestination", (Object)aa.getExternalRetrieveAEDestination(), (Object)bb.getExternalRetrieveAEDestination(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmXDSiImagingDocumentSourceAETitle", (Object)aa.getXDSiImagingDocumentSourceAETitle(), (Object)bb.getXDSiImagingDocumentSourceAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRemapRetrieveURL", (Object)aa.getRemapRetrieveURL(), (Object)bb.getRemapRetrieveURL(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmValidateCallingAEHostname", (Object)aa.isValidateCallingAEHostname(), (Object)bb.isValidateCallingAEHostname(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUSendingApplication", (Object)aa.getHL7PSUSendingApplication(), (Object)bb.getHL7PSUSendingApplication(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUReceivingApplication", (Object[])aa.getHL7PSUReceivingApplications(), (Object[])bb.getHL7PSUReceivingApplications(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUDelay", (Object)aa.getHL7PSUDelay(), (Object)bb.getHL7PSUDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUTimeout", (Object)aa.getHL7PSUTimeout(), (Object)bb.getHL7PSUTimeout(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUOnTimeout", (boolean)aa.isHL7PSUOnTimeout(), (boolean)bb.isHL7PSUOnTimeout(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUTaskPollingInterval", (Object)aa.getHL7PSUTaskPollingInterval(), (Object)bb.getHL7PSUTaskPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUTaskFetchSize", (int)aa.getHL7PSUTaskFetchSize(), (int)bb.getHL7PSUTaskFetchSize(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUMWL", (boolean)aa.isHL7PSUMWL(), (boolean)bb.isHL7PSUMWL(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUMWLMatchingKey", (Object)aa.getHL7PSUMWLMatchingKey(), (Object)bb.getHL7PSUMWLMatchingKey(), (Object)HL7PSUMWLMatchingKey.StudyInstanceUID);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUForRequestedProcedure", (boolean)aa.isHl7PSUForRequestedProcedure(), (boolean)bb.isHl7PSUForRequestedProcedure(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUPIDPV1", (boolean)aa.isHl7PSUPIDPV1(), (boolean)bb.isHl7PSUPIDPV1(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSURequestedProcedureID", (Object)aa.getHl7PSURequestedProcedureID(), (Object)bb.getHl7PSURequestedProcedureID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUAccessionNumber", (Object)aa.getHl7PSUAccessionNumber(), (Object)bb.getHl7PSUAccessionNumber(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUFillerOrderNumber", (Object)aa.getHl7PSUFillerOrderNumber(), (Object)bb.getHl7PSUFillerOrderNumber(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUPlacerOrderNumber", (Object)aa.getHl7PSUPlacerOrderNumber(), (Object)bb.getHl7PSUPlacerOrderNumber(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUTemplateParam", (Map)aa.getHL7PSUTemplateParams(), (Map)bb.getHL7PSUTemplateParams());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUMessageType", (Object)aa.getHl7PSUMessageType(), (Object)bb.getHl7PSUMessageType(), (Object)HL7PSUMessageType.OMG_O19);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUCondition", (Map)aa.getHl7PSUConditions().getMap(), (Map)bb.getHl7PSUConditions().getMap());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUMppsTemplateURI", (Object)aa.getHl7PSUMppsTemplateURI(), (Object)bb.getHl7PSUMppsTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUStudyTemplateURI", (Object)aa.getHl7PSUStudyTemplateURI(), (Object)bb.getHl7PSUStudyTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptConflictingPatientID", (Object)aa.getAcceptConflictingPatientID(), (Object)bb.getAcceptConflictingPatientID(), (Object)AcceptConflictingPatientID.MERGED);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProxyUpstreamURL", (Object)aa.getProxyUpstreamURL(), (Object)bb.getProxyUpstreamURL(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAudit2JsonFhirTemplateURI", (Object)aa.getAudit2JsonFhirTemplateURI(), (Object)bb.getAudit2JsonFhirTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAudit2XmlFhirTemplateURI", (Object)aa.getAudit2XmlFhirTemplateURI(), (Object)bb.getAudit2XmlFhirTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCopyMoveUpdatePolicy", (Object)aa.getCopyMoveUpdatePolicy(), (Object)bb.getCopyMoveUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmLinkMWLEntryUpdatePolicy", (Object)aa.getLinkMWLEntryUpdatePolicy(), (Object)bb.getLinkMWLEntryUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationPolicy", (Object)aa.getStorageVerificationPolicy(), (Object)bb.getStorageVerificationPolicy(), (Object)StorageVerificationPolicy.OBJECT_CHECKSUM);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationUpdateLocationStatus", (Object)aa.isStorageVerificationUpdateLocationStatus(), (Object)bb.isStorageVerificationUpdateLocationStatus(), (Object)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationStorageID", (Object[])aa.getStorageVerificationStorageIDs(), (Object[])bb.getStorageVerificationStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationAETitle", (Object)aa.getStorageVerificationAETitle(), (Object)bb.getStorageVerificationAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationBatchID", (Object)aa.getStorageVerificationBatchID(), (Object)bb.getStorageVerificationBatchID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationInitialDelay", (Object)aa.getStorageVerificationInitialDelay(), (Object)bb.getStorageVerificationInitialDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationPeriod", (Object)aa.getStorageVerificationPeriod(), (Object)bb.getStorageVerificationPeriod(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationMaxScheduled", (int)aa.getStorageVerificationMaxScheduled(), (int)bb.getStorageVerificationMaxScheduled(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationPollingInterval", (Object)aa.getStorageVerificationPollingInterval(), (Object)bb.getStorageVerificationPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationSchedule", (Object[])aa.getStorageVerificationSchedules(), (Object[])bb.getStorageVerificationSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationFetchSize", (int)aa.getStorageVerificationFetchSize(), (int)bb.getStorageVerificationFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUpdateLocationStatusOnRetrieve", (Object)aa.isUpdateLocationStatusOnRetrieve(), (Object)bb.isUpdateLocationStatusOnRetrieve(), (Object)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationOnRetrieve", (Object)aa.isStorageVerificationOnRetrieve(), (Object)bb.isStorageVerificationOnRetrieve(), (Object)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7TrackChangedPatientID", (boolean)aa.isHL7TrackChangedPatientID(), (boolean)bb.isHL7TrackChangedPatientID(), (boolean)true);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ADTReceivingApplication", (Object[])aa.getHL7ADTReceivingApplication(), (Object[])bb.getHL7ADTReceivingApplication(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ADTSendingApplication", (Object)aa.getHL7ADTSendingApplication(), (Object)bb.getHL7ADTSendingApplication(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ScheduledProtocolCodeInOrder", (Object)aa.getHL7ScheduledProtocolCodeInOrder(), (Object)bb.getHL7ScheduledProtocolCodeInOrder(), (Object)ScheduledProtocolCodeInOrder.OBR_4_4);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ScheduledStationAETInOrder", (Object)aa.getHL7ScheduledStationAETInOrder(), (Object)bb.getHL7ScheduledStationAETInOrder(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7NoPatientCreateMessageType", (Object[])aa.getHL7NoPatientCreateMessageTypes(), (Object[])bb.getHL7NoPatientCreateMessageTypes(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditUnknownStudyInstanceUID", (Object)aa.getAuditUnknownStudyInstanceUID(), (Object)bb.getAuditUnknownStudyInstanceUID(), (Object)"1.2.40.0.13.1.15.110.3.165.1");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditUnknownPatientID", (Object)aa.getAuditUnknownPatientID(), (Object)bb.getAuditUnknownPatientID(), (Object)"<none>");
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditSoftwareConfigurationVerbose", (boolean)aa.isAuditSoftwareConfigurationVerbose(), (boolean)bb.isAuditSoftwareConfigurationVerbose(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7UseNullValue", (boolean)aa.isHL7UseNullValue(), (boolean)bb.isHL7UseNullValue(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQueueTasksFetchSize", (int)aa.getQueueTasksFetchSize(), (int)bb.getQueueTasksFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectionNoteStorageAET", (Object)aa.getRejectionNoteStorageAET(), (Object)bb.getRejectionNoteStorageAET(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmXRoadProperty", (Map)aa.getXRoadProperties(), (Map)bb.getXRoadProperties());
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmImpaxReportProperty", (Map)aa.getImpaxReportProperties(), (Map)bb.getImpaxReportProperties());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUIConfigurationDeviceName", (Object)aa.getUiConfigurationDeviceName(), (Object)bb.getUiConfigurationDeviceName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCompressionAETitle", (Object)aa.getCompressionAETitle(), (Object)bb.getCompressionAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCompressionPollingInterval", (Object)aa.getCompressionPollingInterval(), (Object)bb.getCompressionPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCompressionFetchSize", (int)aa.getCompressionFetchSize(), (int)bb.getCompressionFetchSize(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCompressionSchedule", (Object[])aa.getCompressionSchedules(), (Object[])bb.getCompressionSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCompressionThreads", (int)aa.getCompressionThreads(), (int)bb.getCompressionThreads(), (int)1);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDiffTaskProgressUpdateInterval", (Object)aa.getDiffTaskProgressUpdateInterval(), (Object)bb.getDiffTaskProgressUpdateInterval(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationPDQServiceID", (Object)aa.getPatientVerificationPDQServiceID(), (Object)bb.getPatientVerificationPDQServiceID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationPollingInterval", (Object)aa.getPatientVerificationPollingInterval(), (Object)bb.getPatientVerificationPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationFetchSize", (int)aa.getPatientVerificationFetchSize(), (int)bb.getPatientVerificationFetchSize(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationAdjustIssuerOfPatientID", (boolean)aa.isPatientVerificationAdjustIssuerOfPatientID(), (boolean)bb.isPatientVerificationAdjustIssuerOfPatientID(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationPeriod", (Object)aa.getPatientVerificationPeriod(), (Object)bb.getPatientVerificationPeriod(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationPeriodOnNotFound", (Object)aa.getPatientVerificationPeriodOnNotFound(), (Object)bb.getPatientVerificationPeriodOnNotFound(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationRetryInterval", (Object)aa.getPatientVerificationRetryInterval(), (Object)bb.getPatientVerificationRetryInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationMaxRetries", (int)aa.getPatientVerificationMaxRetries(), (int)bb.getPatientVerificationMaxRetries(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatientVerificationMaxStaleness", (Object)aa.getPatientVerificationMaxStaleness(), (Object)bb.getPatientVerificationMaxStaleness(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCSVUploadChunkSize", (int)aa.getCSVUploadChunkSize(), (int)bb.getCSVUploadChunkSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OrderMissingStudyIUIDPolicy", (Object)aa.getHl7OrderMissingStudyIUIDPolicy(), (Object)bb.getHl7OrderMissingStudyIUIDPolicy(), (Object)HL7OrderMissingStudyIUIDPolicy.GENERATE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OrderMissingAdmissionIDPolicy", (Object)aa.getHl7OrderMissingAdmissionIDPolicy(), (Object)bb.getHl7OrderMissingAdmissionIDPolicy(), (Object)HL7OrderMissingAdmissionIDPolicy.ACCEPT);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportMissingStudyIUIDPolicy", (Object)aa.getHl7ImportReportMissingStudyIUIDPolicy(), (Object)bb.getHl7ImportReportMissingStudyIUIDPolicy(), (Object)HL7ImportReportMissingStudyIUIDPolicy.GENERATE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportMissingStudyIUIDCFindSCP", (Object)aa.getHl7ImportReportMissingStudyIUIDCFindSCP(), (Object)bb.getHl7ImportReportMissingStudyIUIDCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ImportReportAdjustIUID", (Object)aa.getHl7ImportReportAdjustIUID(), (Object)bb.getHl7ImportReportAdjustIUID(), (Object)HL7ImportReportAdjustIUID.NONE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7DicomCharacterSet", (Object)aa.getHl7DicomCharacterSet(), (Object)bb.getHl7DicomCharacterSet(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7VeterinaryUsePatientName", (boolean)aa.isHl7VeterinaryUsePatientName(), (boolean)bb.isHl7VeterinaryUsePatientName(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmValidateUID", (boolean)aa.isValidateUID(), (boolean)bb.isValidateUID(), (boolean)true);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRelationalQueryNegotiationLenient", (boolean)aa.isRelationalQueryNegotiationLenient(), (boolean)bb.isRelationalQueryNegotiationLenient(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRelationalRetrieveNegotiationLenient", (boolean)aa.isRelationalRetrieveNegotiationLenient(), (boolean)bb.isRelationalRetrieveNegotiationLenient(), (boolean)false);
        this.storeDiffTags(mods, "dcmRejectConflictingPatientAttribute", aa.getRejectConflictingPatientAttribute(), bb.getRejectConflictingPatientAttribute());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedulerMinStartDelay", (int)aa.getSchedulerMinStartDelay(), (int)bb.getSchedulerMinStartDelay(), (int)60);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowRetiredTransferSyntax", (boolean)aa.isStowRetiredTransferSyntax(), (boolean)bb.isStowRetiredTransferSyntax(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowExcludeAPPMarkers", (boolean)aa.isStowExcludeAPPMarkers(), (boolean)bb.isStowExcludeAPPMarkers(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRestrictRetrieveSilently", (boolean)aa.isRestrictRetrieveSilently(), (boolean)bb.isRestrictRetrieveSilently(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowQuicktime2MP4", (boolean)aa.isStowQuicktime2MP4(), (boolean)bb.isStowQuicktime2MP4(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowMaxFragmentLength", (long)aa.getStowMaxFragmentLength(), (long)bb.getStowMaxFragmentLength(), (long)0x7FFFFFFEL);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLPollingInterval", (Object)aa.getMWLPollingInterval(), (Object)bb.getMWLPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLFetchSize", (int)aa.getMWLFetchSize(), (int)bb.getMWLFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLImportInterval", (Object)aa.getMWLImportInterval(), (Object)bb.getMWLImportInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteMWLDelay", (Object[])aa.getDeleteMWLDelay(), (Object[])bb.getDeleteMWLDelay(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSProcessingPollingInterval", (Object)aa.getUPSProcessingPollingInterval(), (Object)bb.getUPSProcessingPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSProcessingFetchSize", (int)aa.getUPSProcessingFetchSize(), (int)bb.getUPSProcessingFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmTaskPollingInterval", (Object)aa.getTaskPollingInterval(), (Object)bb.getTaskPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmTaskFetchSize", (int)aa.getTaskFetchSize(), (int)bb.getTaskFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7ReferredMergedPatientPolicy", (Object)aa.getHl7ReferredMergedPatientPolicy(), (Object)bb.getHl7ReferredMergedPatientPolicy(), (Object)HL7ReferredMergedPatientPolicy.REJECT);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveTaskWarningOnNoMatch", (boolean)aa.isRetrieveTaskWarningOnNoMatch(), (boolean)bb.isRetrieveTaskWarningOnNoMatch(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveTaskWarningOnWarnings", (boolean)aa.isRetrieveTaskWarningOnWarnings(), (boolean)bb.isRetrieveTaskWarningOnWarnings(), (boolean)false);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCStoreSCUOfCMoveSCP", (Map)aa.getCStoreSCUOfCMoveSCPs(), (Map)bb.getCStoreSCUOfCMoveSCPs());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteStudyChunkSize", (int)aa.getDeleteStudyChunkSize(), (int)bb.getDeleteStudyChunkSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PatientArrivalMessageType", (Object)aa.getHL7PatientArrivalMessageType(), (Object)bb.getHL7PatientArrivalMessageType(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUserIdentityNegotiation", (Object)aa.getUserIdentityNegotiation(), (Object)bb.getUserIdentityNegotiation(), (Object)UserIdentityNegotiation.SUPPORTS);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUserIdentityNegotiationRole", (Object)aa.getUserIdentityNegotiationRole(), (Object)bb.getUserIdentityNegotiationRole(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUserIdentityNegotiationKeycloakClientID", (Object)aa.getUserIdentityNegotiationKeycloakClientID(), (Object)bb.getUserIdentityNegotiationKeycloakClientID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCalculateStudySizeDelay", (Object)aa.getStudySizeDelay(), (Object)bb.getStudySizeDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCalculateStudySizePollingInterval", (Object)aa.getCalculateStudySizePollingInterval(), (Object)bb.getCalculateStudySizePollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCalculateStudySizeFetchSize", (int)aa.getCalculateStudySizeFetchSize(), (int)bb.getCalculateStudySizeFetchSize(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCalculateQueryAttributes", (boolean)aa.isCalculateQueryAttributes(), (boolean)bb.isCalculateQueryAttributes(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStoreImplementationVersionName", (boolean)aa.isStoreImplementationVersionName(), (boolean)bb.isStoreImplementationVersionName(), (boolean)true);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSupplementIssuerFetchSize", (int)aa.getSupplementIssuerFetchSize(), (int)bb.getSupplementIssuerFetchSize(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUpdateCharsetFetchSize", (int)aa.getUpdateCharsetFetchSize(), (int)bb.getUpdateCharsetFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditAssigningAuthorityOfPatientID", (Object)aa.getAuditAssigningAuthorityOfPatientID(), (Object)bb.getAuditAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmChangeRequesterAET", (Object)aa.getChangeRequesterAET(), (Object)bb.getChangeRequesterAET(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFilterByIssuerOfPatientID", (boolean)aa.isFilterByIssuerOfPatientID(), (boolean)bb.isFilterByIssuerOfPatientID(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditHL7MsgLimit", (int)aa.getAuditHL7MsgLimit(), (int)bb.getAuditHL7MsgLimit(), (int)1000);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMatchSOPClassOnInstanceLevel", (boolean)aa.isMatchSOPClassOnInstanceLevel(), (boolean)bb.isMatchSOPClassOnInstanceLevel(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSUpdateWithoutTransactionUID", (boolean)aa.isUPSUpdateWithoutTransactionUID(), (boolean)bb.isUPSUpdateWithoutTransactionUID(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmKeyValueRetentionPollingInterval", (Object)aa.getKeyValueRetentionPollingInterval(), (Object)bb.getKeyValueRetentionPollingInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmKeyValueRetentionFetchSize", (int)aa.getKeyValueRetentionFetchSize(), (int)bb.getKeyValueRetentionFetchSize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmKeyValueRetentionPeriod", (Object)aa.getKeyValueRetentionPeriod(), (Object)bb.getKeyValueRetentionPeriod(), null);
        if (remove) {
            mods.add(new ModificationItem(3, LdapUtils.attr((String)"objectClass", (Object[])new String[]{"dcmArchiveDevice"})));
        }
    }

    protected void storeChilds(ConfigurationChanges diffs, String deviceDN, Device device) throws NamingException {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (arcDev == null) {
            return;
        }
        this.storeAttributeFilter(diffs, deviceDN, arcDev);
        this.storeStorageDescriptors(diffs, deviceDN, arcDev);
        this.storeQueueDescriptors(diffs, deviceDN, arcDev);
        this.storePDQServiceDescriptors(diffs, deviceDN, arcDev);
        this.storeExporterDescriptors(diffs, deviceDN, arcDev);
        this.storeExportRules(diffs, arcDev.getExportRules(), deviceDN);
        this.storePrefetchRules(diffs, arcDev.getExportPriorsRules(), deviceDN);
        this.storeMPPSForwardRules(diffs, arcDev.getMPPSForwardRules(), deviceDN);
        LdapArchiveConfiguration.storeHL7ExportRules(diffs, arcDev.getHL7ExportRules(), deviceDN, this.config);
        LdapArchiveConfiguration.storeHL7PrefetchRules(diffs, arcDev.getHL7PrefetchRules(), deviceDN, this.config);
        this.storeCompressionRules(diffs, arcDev.getCompressionRules(), deviceDN);
        this.storeStoreAccessControlIDRules(diffs, arcDev.getStoreAccessControlIDRules(), deviceDN);
        this.storeAttributeCoercions(diffs, arcDev.getAttributeCoercions(), deviceDN);
        this.storeAttributeCoercions2(diffs, arcDev.getAttributeCoercions2(), deviceDN);
        this.storeQueryRetrieveViews(diffs, deviceDN, arcDev);
        this.storeRejectNotes(diffs, deviceDN, arcDev);
        this.storeStudyRetentionPolicies(diffs, arcDev.getStudyRetentionPolicies(), deviceDN);
        LdapArchiveConfiguration.storeHL7StudyRetentionPolicies(diffs, arcDev.getHL7StudyRetentionPolicies(), deviceDN, this.config);
        this.storeIDGenerators(diffs, deviceDN, arcDev);
        LdapArchiveConfiguration.storeHL7ForwardRules(diffs, arcDev.getHL7ForwardRules(), deviceDN, this.config);
        this.storeRSForwardRules(diffs, arcDev.getRSForwardRules(), deviceDN);
        this.storeAttributeSet(diffs, deviceDN, arcDev);
        LdapArchiveConfiguration.storeScheduledStations(diffs, arcDev.getHL7OrderScheduledStations(), deviceDN, this.config);
        LdapArchiveConfiguration.storeHL7OrderSPSStatus(diffs, arcDev.getHL7OrderSPSStatuses(), deviceDN, this.config);
        this.storeMetricsDescriptors(diffs, arcDev.getMetricsDescriptors(), deviceDN);
        this.storeUPSOnStoreList(diffs, arcDev.listUPSOnStore(), deviceDN);
        this.storeUPSProcessingRules(diffs, deviceDN, arcDev);
        LdapArchiveConfiguration.storeUPSOnHL7List(diffs, arcDev.listUPSOnHL7(), deviceDN, this.config);
        this.storeUPSOnUPSCompletedList(diffs, arcDev.listUPSOnUPSCompleted(), deviceDN);
        this.storeMWLIdleTimeouts(diffs, arcDev.getMWLIdleTimeouts(), deviceDN);
        this.storeMWLImports(diffs, arcDev.getMWLImports(), deviceDN);
        this.config.store(diffs, arcDev.getBulkDataDescriptors(), deviceDN);
    }

    protected void loadChilds(Device device, String deviceDN) throws NamingException {
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (arcdev == null) {
            return;
        }
        this.loadAttributeFilters(arcdev, deviceDN);
        this.loadStorageDescriptors(arcdev, deviceDN);
        this.loadQueueDescriptors(arcdev, deviceDN);
        this.loadPDQServiceDescriptors(arcdev, deviceDN);
        this.loadExporterDescriptors(arcdev, deviceDN);
        this.loadExportRules(arcdev.getExportRules(), deviceDN);
        this.loadPrefetchRules(arcdev.getExportPriorsRules(), deviceDN);
        this.loadMPPSForwardRules(arcdev.getMPPSForwardRules(), deviceDN);
        LdapArchiveConfiguration.loadHL7ExportRules(arcdev.getHL7ExportRules(), deviceDN, this.config);
        LdapArchiveConfiguration.loadHL7PrefetchRules(arcdev.getHL7PrefetchRules(), deviceDN, this.config);
        this.loadCompressionRules(arcdev.getCompressionRules(), deviceDN);
        this.loadStoreAccessControlIDRules(arcdev.getStoreAccessControlIDRules(), deviceDN);
        this.loadAttributeCoercions(arcdev.getAttributeCoercions(), deviceDN, device);
        this.loadAttributeCoercions2(arcdev.getAttributeCoercions2(), deviceDN, device);
        this.loadQueryRetrieveViews(arcdev, deviceDN);
        this.loadRejectNotes(arcdev, deviceDN);
        this.loadStudyRetentionPolicies(arcdev.getStudyRetentionPolicies(), deviceDN);
        LdapArchiveConfiguration.loadHL7StudyRetentionPolicies(arcdev.getHL7StudyRetentionPolicies(), deviceDN, this.config);
        this.loadIDGenerators(arcdev, deviceDN);
        LdapArchiveConfiguration.loadHL7ForwardRules(arcdev.getHL7ForwardRules(), deviceDN, this.config);
        this.loadRSForwardRules(arcdev.getRSForwardRules(), deviceDN);
        this.loadAttributeSet(arcdev, deviceDN);
        LdapArchiveConfiguration.loadScheduledStations(arcdev.getHL7OrderScheduledStations(), deviceDN, this.config, device);
        LdapArchiveConfiguration.loadHL7OrderSPSStatus(arcdev.getHL7OrderSPSStatuses(), deviceDN, this.config);
        this.loadMetricsDescriptors(arcdev, deviceDN);
        this.loadUPSOnStoreList(arcdev.listUPSOnStore(), deviceDN);
        this.loadUPSProcessingRules(arcdev, deviceDN);
        LdapArchiveConfiguration.loadUPSOnHL7List(arcdev.listUPSOnHL7(), deviceDN, this.config);
        this.loadUPSOnUPSCompletedList(arcdev.listUPSOnUPSCompleted(), deviceDN);
        this.loadMWLIdleTimeouts(arcdev.getMWLIdleTimeouts(), deviceDN);
        this.loadMWLImports(arcdev.getMWLImports(), deviceDN);
        this.config.load(arcdev.getBulkDataDescriptors(), deviceDN);
    }

    protected void mergeChilds(ConfigurationChanges diffs, Device prev, Device device, String deviceDN) throws NamingException {
        ArchiveDeviceExtension aa = (ArchiveDeviceExtension)prev.getDeviceExtension(ArchiveDeviceExtension.class);
        ArchiveDeviceExtension bb = (ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (aa == null && bb == null) {
            return;
        }
        if (aa == null) {
            aa = new ArchiveDeviceExtension();
        } else if (bb == null) {
            bb = new ArchiveDeviceExtension();
        }
        this.mergeAttributeFilters(diffs, aa, bb, deviceDN);
        this.mergeStorageDescriptors(diffs, aa, bb, deviceDN);
        this.mergeQueueDescriptors(diffs, aa, bb, deviceDN);
        this.mergePDQServiceDescriptors(diffs, aa, bb, deviceDN);
        this.mergeExportDescriptors(diffs, aa, bb, deviceDN);
        this.mergeExportRules(diffs, aa.getExportRules(), bb.getExportRules(), deviceDN);
        this.mergePrefetchRules(diffs, aa.getExportPriorsRules(), bb.getExportPriorsRules(), deviceDN);
        this.mergeMPPSForwardRules(diffs, aa.getMPPSForwardRules(), bb.getMPPSForwardRules(), deviceDN);
        LdapArchiveConfiguration.mergeHL7ExportRules(diffs, aa.getHL7ExportRules(), bb.getHL7ExportRules(), deviceDN, this.getDicomConfiguration());
        LdapArchiveConfiguration.mergeHL7PrefetchRules(diffs, aa.getHL7PrefetchRules(), bb.getHL7PrefetchRules(), deviceDN, this.getDicomConfiguration());
        this.mergeCompressionRules(diffs, aa.getCompressionRules(), bb.getCompressionRules(), deviceDN);
        this.mergeStoreAccessControlIDRules(diffs, aa.getStoreAccessControlIDRules(), bb.getStoreAccessControlIDRules(), deviceDN);
        this.mergeAttributeCoercions(diffs, aa.getAttributeCoercions(), bb.getAttributeCoercions(), deviceDN);
        this.mergeAttributeCoercions2(diffs, aa.getAttributeCoercions2(), bb.getAttributeCoercions2(), deviceDN);
        this.mergeQueryRetrieveViews(diffs, aa, bb, deviceDN);
        this.mergeRejectNotes(diffs, aa, bb, deviceDN);
        this.mergeStudyRetentionPolicies(diffs, aa.getStudyRetentionPolicies(), bb.getStudyRetentionPolicies(), deviceDN);
        LdapArchiveConfiguration.mergeHL7StudyRetentionPolicies(diffs, aa.getHL7StudyRetentionPolicies(), bb.getHL7StudyRetentionPolicies(), deviceDN, this.config);
        this.mergeIDGenerators(diffs, aa, bb, deviceDN);
        LdapArchiveConfiguration.mergeHL7ForwardRules(diffs, aa.getHL7ForwardRules(), bb.getHL7ForwardRules(), deviceDN, this.config);
        this.mergeRSForwardRules(diffs, aa.getRSForwardRules(), bb.getRSForwardRules(), deviceDN);
        this.mergeAttributeSet(diffs, aa, bb, deviceDN);
        LdapArchiveConfiguration.mergeScheduledStations(diffs, aa.getHL7OrderScheduledStations(), bb.getHL7OrderScheduledStations(), deviceDN, this.config);
        LdapArchiveConfiguration.mergeHL7OrderSPSStatus(diffs, aa.getHL7OrderSPSStatuses(), bb.getHL7OrderSPSStatuses(), deviceDN, this.config);
        this.mergeMetricsDescriptors(diffs, aa.getMetricsDescriptors(), bb.getMetricsDescriptors(), deviceDN);
        this.mergeUPSOnStoreList(diffs, aa.listUPSOnStore(), bb.listUPSOnStore(), deviceDN);
        LdapArchiveConfiguration.mergeUPSOnHL7List(diffs, aa.listUPSOnHL7(), bb.listUPSOnHL7(), deviceDN, this.config);
        this.mergeUPSProcessingRules(diffs, aa, bb, deviceDN);
        this.mergeUPSOnUPSCompletedList(diffs, aa.listUPSOnUPSCompleted(), bb.listUPSOnUPSCompleted(), deviceDN);
        this.mergeMWLIdleTimeouts(diffs, aa.getMWLIdleTimeouts(), bb.getMWLIdleTimeouts(), deviceDN);
        this.mergeMWLImports(diffs, aa.getMWLImports(), bb.getMWLImports(), deviceDN);
        this.config.merge(diffs, aa.getBulkDataDescriptors(), bb.getBulkDataDescriptors(), deviceDN);
    }

    protected void storeTo(ConfigurationChanges.ModifiedObject ldapObj, ApplicationEntity ae, Attributes attrs) {
        ArchiveAEExtension ext = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
        if (ext == null) {
            return;
        }
        attrs.get("objectclass").add("dcmArchiveNetworkAE");
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmObjectStorageID", (Object[])ext.getObjectStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmObjectStorageCount", (int)ext.getObjectStorageCount(), (int)1);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMetadataStorageID", (Object[])ext.getMetadataStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmBulkDataDescriptorID", (Object)ext.getBulkDataDescriptorID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSeriesMetadataDelay", (Object)ext.getSeriesMetadataDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeInstanceRecordsDelay", (Object)ext.getPurgeInstanceRecordsDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStoreAccessControlID", (Object)ext.getStoreAccessControlID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAccessControlID", (Object[])ext.getAccessControlIDs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmOverwritePolicy", (Object)ext.getOverwritePolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRecordAttributeModification", (Object)ext.getRecordAttributeModification(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmBulkDataSpoolDirectory", (Object)ext.getBulkDataSpoolDirectory(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQueryRetrieveViewID", (Object)ext.getQueryRetrieveViewID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPersonNameComponentOrderInsensitiveMatching", (Object)ext.getPersonNameComponentOrderInsensitiveMatching(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSendPendingCGet", (Object)ext.getSendPendingCGet(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSendPendingCMoveInterval", (Object)ext.getSendPendingCMoveInterval(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSpanningCFindSCP", (Object)ext.getSpanningCFindSCP(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSpanningCFindSCPRetrieveAET", (Object[])ext.getSpanningCFindSCPRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSpanningCFindSCPPolicy", (Object)ext.getSpanningCFindSCPPolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCP", (Object)ext.getFallbackCMoveSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPDestination", (Object)ext.getFallbackCMoveSCPDestination(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPCallingAET", (Object)ext.getFallbackCMoveSCPCallingAET(), null);
        LdapUtils.storeNotNull((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPRetries", (Integer)ext.getFallbackCMoveSCPRetries());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPLeadingCFindSCP", (Object)ext.getFallbackCMoveSCPLeadingCFindSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAltCMoveSCP", (Object)ext.getAlternativeCMoveSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoZIPEntryNameFormat", (Object)ext.getWadoZIPEntryNameFormat(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoSR2HtmlTemplateURI", (Object)ext.getWadoSR2HtmlTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoSR2TextTemplateURI", (Object)ext.getWadoSR2TextTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoCDA2HtmlTemplateURI", (Object)ext.getWadoCDA2HtmlTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoThumbnailViewport", (Object)ext.getWadoThumbnailViewPort(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackWadoURIWebAppName", (Object)ext.getFallbackWadoURIWebApplication(), null);
        LdapUtils.storeNotNull((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackWadoURIHttpStatusCode", (Integer)ext.getFallbackWadoURIHttpStatusCode());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoIgnorePresentationLUTShape", (Object)ext.getWadoIgnorePresentationLUTShape(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWadoMetadataExcludePrivate", (Object)ext.getWadoMetadataWithoutPrivate(), null);
        LdapUtils.storeNotNull((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQueryMaxNumberOfResults", (Integer)ext.getQueryMaxNumberOfResults());
        LdapUtils.storeNotNull((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQidoMaxNumberOfResults", (Integer)ext.getQidoMaxNumberOfResults());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQidoETag", (Object)ext.getQidoETag(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFwdMppsDestination", (Object[])ext.getMppsForwardDestinations(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanDestination", (Object[])ext.getIanDestinations(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanDelay", (Object)ext.getIanDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanTimeout", (Object)ext.getIanTimeout(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanOnTimeout", (Object)ext.getIanOnTimeout(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHideSPSWithStatusFromMWL", (Object[])ext.getHideSPSWithStatusFromMWL(), (Object[])new SPSStatus[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHideSPSWithStatusFromMWLRS", (Object[])ext.getHideSPSWithStatusFromMWLRS(), (Object[])new SPSStatus[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLAccessionNumberGenerator", (Object)ext.getMWLAccessionNumberGenerator(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLRequestedProcedureIDGenerator", (Object)ext.getMWLRequestedProcedureIDGenerator(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLScheduledProcedureStepIDGenerator", (Object)ext.getMWLScheduledProcedureStepIDGenerator(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEncodeAsJSONNumber", (Object[])ext.getEncodeAsJSONNumber(), (Object[])new VR[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFallbackCMoveSCPStudyOlderThan", (Object)ext.getFallbackCMoveSCPStudyOlderThan(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceURL", (Object)ext.getStorePermissionServiceURL(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceResponse", (Object)ext.getStorePermissionServiceResponse(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceResponsePattern", (Object)ext.getStorePermissionServiceResponsePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAllowRejectionForDataRetentionPolicyExpired", (Object)ext.getAllowRejectionForDataRetentionPolicyExpired(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptedUserRole", (Object[])ext.getAcceptedUserRoles(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptMissingPatientID", (Object)ext.getAcceptMissingPatientID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAllowDeleteStudyPermanently", (Object)ext.getAllowDeleteStudyPermanently(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAllowDeletePatient", (Object)ext.getAllowDeletePatient(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceExpirationDatePattern", (Object)ext.getStorePermissionServiceExpirationDatePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDefaultCharacterSet", (Object)ext.getDefaultCharacterSet(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLWorklistLabel", (Object)ext.getMWLWorklistLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSWorklistLabel", (Object)ext.getUPSWorklistLabel(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSEventSCU", (Object[])ext.getUPSEventSCUs(), (Object[])new String[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSEventSCUKeepAlive", (int)ext.getUPSEventSCUKeepAlive(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceErrorCommentPattern", (Object)ext.getStorePermissionServiceErrorCommentPattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorePermissionServiceErrorCodePattern", (Object)ext.getStorePermissionServiceErrorCodePattern(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveAET", (Object[])ext.getRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmReturnRetrieveAET", (Object[])ext.getReturnRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMultipleStoreAssociations", (Object[])ext.getMultipleStoreAssociations(), (Object[])new MultipleStoreAssociations[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExternalRetrieveAEDestination", (Object)ext.getExternalRetrieveAEDestination(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptedMoveDestination", (Object[])ext.getAcceptedMoveDestinations(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmValidateCallingAEHostname", (Object)ext.getValidateCallingAEHostname(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUSendingApplication", (Object)ext.getHL7PSUSendingApplication(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUReceivingApplication", (Object[])ext.getHL7PSUReceivingApplications(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUDelay", (Object)ext.getHL7PSUDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUTimeout", (Object)ext.getHL7PSUTimeout(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUOnTimeout", (Object)ext.getHL7PSUOnTimeout(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUMWL", (Object)ext.getHL7PSUMWL(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUMWLMatchingKey", (Object)ext.getHL7PSUMWLMatchingKey(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUForRequestedProcedure", (Object)ext.getHl7PSUForRequestedProcedure(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUPIDPV1", (Object)ext.getHl7PSUPIDPV1(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSURequestedProcedureID", (Object)ext.getHl7PSURequestedProcedureID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUAccessionNumber", (Object)ext.getHl7PSUAccessionNumber(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUFillerOrderNumber", (Object)ext.getHl7PSUFillerOrderNumber(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUPlacerOrderNumber", (Object)ext.getHl7PSUPlacerOrderNumber(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUTemplateParam", (Map)ext.getHL7PSUTemplateParams());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUMessageType", (Object)ext.getHl7PSUMessageType(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUCondition", (Map)ext.getHl7PSUConditions().getMap());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUMppsTemplateURI", (Object)ext.getHl7PSUMppsTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7PSUStudyTemplateURI", (Object)ext.getHl7PSUStudyTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptConflictingPatientID", (Object)ext.getAcceptConflictingPatientID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCopyMoveUpdatePolicy", (Object)ext.getCopyMoveUpdatePolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmLinkMWLEntryUpdatePolicy", (Object)ext.getLinkMWLEntryUpdatePolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationPolicy", (Object)ext.getStorageVerificationPolicy(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationUpdateLocationStatus", (Object)ext.getStorageVerificationUpdateLocationStatus(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationStorageID", (Object[])ext.getStorageVerificationStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationInitialDelay", (Object)ext.getStorageVerificationInitialDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUpdateLocationStatusOnRetrieve", (Object)ext.getUpdateLocationStatusOnRetrieve(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageVerificationOnRetrieve", (Object)ext.getStorageVerificationOnRetrieve(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRelationalQueryNegotiationLenient", (Object)ext.getRelationalQueryNegotiationLenient(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRelationalRetrieveNegotiationLenient", (Object)ext.getRelationalRetrieveNegotiationLenient(), null);
        LdapArchiveConfiguration.storeNotEmptyTags(ldapObj, attrs, "dcmRejectConflictingPatientAttribute", ext.getRejectConflictingPatientAttribute());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowRetiredTransferSyntax", (Object)ext.getStowRetiredTransferSyntax(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowExcludeAPPMarkers", (Object)ext.getStowExcludeAPPMarkers(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRestrictRetrieveSilently", (Object)ext.getRestrictRetrieveSilently(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowQuicktime2MP4", (Object)ext.getStowQuicktime2MP4(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStowMaxFragmentLength", (Object)ext.getStowMaxFragmentLength(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveTaskWarningOnNoMatch", (Object)ext.getRetrieveTaskWarningOnNoMatch(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveTaskWarningOnWarnings", (Object)ext.getRetrieveTaskWarningOnWarnings(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUserIdentityNegotiation", (Object)ext.getUserIdentityNegotiation(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUserIdentityNegotiationRole", (Object)ext.getUserIdentityNegotiationRole(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUserIdentityNegotiationKeycloakClientID", (Object)ext.getUserIdentityNegotiationKeycloakClientID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmChangeRequesterAET", (Object)ext.getChangeRequesterAET(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFilterByIssuerOfPatientID", (Object)ext.getFilterByIssuerOfPatientID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMatchSOPClassOnInstanceLevel", (Object)ext.getMatchSOPClassOnInstanceLevel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSUpdateWithoutTransactionUID", (Object)ext.getUPSUpdateWithoutTransactionUID(), null);
    }

    protected void loadFrom(ApplicationEntity ae, Attributes attrs) throws NamingException {
        if (!LdapUtils.hasObjectClass((Attributes)attrs, (String)"dcmArchiveNetworkAE")) {
            return;
        }
        ArchiveAEExtension ext = new ArchiveAEExtension();
        ae.addAEExtension((AEExtension)ext);
        ext.setObjectStorageIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmObjectStorageID"), (String[])new String[0]));
        ext.setObjectStorageCount(LdapUtils.intValue((Attribute)attrs.get("dcmObjectStorageCount"), (int)1));
        ext.setMetadataStorageIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmMetadataStorageID"), (String[])new String[0]));
        ext.setBulkDataDescriptorID(LdapUtils.stringValue((Attribute)attrs.get("dcmBulkDataDescriptorID"), null));
        ext.setSeriesMetadataDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmSeriesMetadataDelay"), null));
        ext.setPurgeInstanceRecordsDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeInstanceRecordsDelay"), null));
        ext.setStoreAccessControlID(LdapUtils.stringValue((Attribute)attrs.get("dcmStoreAccessControlID"), null));
        ext.setAccessControlIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmAccessControlID"), (String[])new String[0]));
        ext.setOverwritePolicy((OverwritePolicy)LdapUtils.enumValue(OverwritePolicy.class, (Attribute)attrs.get("dcmOverwritePolicy"), null));
        ext.setRecordAttributeModification(LdapUtils.booleanValue((Attribute)attrs.get("dcmRecordAttributeModification"), null));
        ext.setBulkDataSpoolDirectory(LdapUtils.stringValue((Attribute)attrs.get("dcmBulkDataSpoolDirectory"), null));
        ext.setQueryRetrieveViewID(LdapUtils.stringValue((Attribute)attrs.get("dcmQueryRetrieveViewID"), null));
        ext.setPersonNameComponentOrderInsensitiveMatching(LdapUtils.booleanValue((Attribute)attrs.get("dcmPersonNameComponentOrderInsensitiveMatching"), null));
        ext.setSendPendingCGet(LdapUtils.booleanValue((Attribute)attrs.get("dcmSendPendingCGet"), null));
        ext.setSendPendingCMoveInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmSendPendingCMoveInterval"), null));
        ext.setSpanningCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmSpanningCFindSCP"), null));
        ext.setSpanningCFindSCPRetrieveAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmSpanningCFindSCPRetrieveAET"), (String[])new String[0]));
        ext.setSpanningCFindSCPPolicy((SpanningCFindSCPPolicy)LdapUtils.enumValue(SpanningCFindSCPPolicy.class, (Attribute)attrs.get("dcmSpanningCFindSCPPolicy"), null));
        ext.setFallbackCMoveSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCP"), null));
        ext.setFallbackCMoveSCPDestination(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCPDestination"), null));
        ext.setFallbackCMoveSCPCallingAET(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCPCallingAET"), null));
        ext.setFallbackCMoveSCPRetries(LdapUtils.intValue((Attribute)attrs.get("dcmFallbackCMoveSCPRetries"), null));
        ext.setFallbackCMoveSCPLeadingCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCPLeadingCFindSCP"), null));
        ext.setAlternativeCMoveSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmAltCMoveSCP"), null));
        ext.setWadoZIPEntryNameFormat(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoZIPEntryNameFormat"), null));
        ext.setWadoSR2HtmlTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoSR2HtmlTemplateURI"), null));
        ext.setWadoSR2TextTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoSR2TextTemplateURI"), null));
        ext.setWadoCDA2HtmlTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoCDA2HtmlTemplateURI"), null));
        ext.setWadoThumbnailViewPort(LdapUtils.stringValue((Attribute)attrs.get("dcmWadoThumbnailViewport"), null));
        ext.setFallbackWadoURIWebApplication(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackWadoURIWebAppName"), null));
        ext.setFallbackWadoURIHttpStatusCode(LdapUtils.intValue((Attribute)attrs.get("dcmFallbackWadoURIHttpStatusCode"), null));
        ext.setWadoIgnorePresentationLUTShape(LdapUtils.booleanValue((Attribute)attrs.get("dcmWadoIgnorePresentationLUTShape"), null));
        ext.setWadoMetadataWithoutPrivate(LdapUtils.booleanValue((Attribute)attrs.get("dcmWadoMetadataExcludePrivate"), null));
        ext.setQueryMaxNumberOfResults(LdapUtils.intValue((Attribute)attrs.get("dcmQueryMaxNumberOfResults"), null));
        ext.setQidoMaxNumberOfResults(LdapUtils.intValue((Attribute)attrs.get("dcmQidoMaxNumberOfResults"), null));
        ext.setQidoETag(LdapUtils.booleanValue((Attribute)attrs.get("dcmQidoETag"), null));
        ext.setMppsForwardDestinations(LdapUtils.stringArray((Attribute)attrs.get("dcmFwdMppsDestination"), (String[])new String[0]));
        ext.setIanDestinations(LdapUtils.stringArray((Attribute)attrs.get("dcmIanDestination"), (String[])new String[0]));
        ext.setIanDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmIanDelay"), null));
        ext.setIanTimeout(LdapArchiveConfiguration.toDuration(attrs.get("dcmIanTimeout"), null));
        ext.setIanOnTimeout(LdapUtils.booleanValue((Attribute)attrs.get("dcmIanOnTimeout"), null));
        ext.setHideSPSWithStatusFromMWL((SPSStatus[])LdapUtils.enumArray(SPSStatus.class, (Attribute)attrs.get("dcmHideSPSWithStatusFromMWL")));
        ext.setHideSPSWithStatusFromMWLRS((SPSStatus[])LdapUtils.enumArray(SPSStatus.class, (Attribute)attrs.get("dcmHideSPSWithStatusFromMWLRS")));
        ext.setMWLAccessionNumberGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLAccessionNumberGenerator"), null));
        ext.setMWLRequestedProcedureIDGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLRequestedProcedureIDGenerator"), null));
        ext.setMWLScheduledProcedureStepIDGenerator(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLScheduledProcedureStepIDGenerator"), null));
        ext.setEncodeAsJSONNumber((VR[])LdapUtils.enumArray(VR.class, (Attribute)attrs.get("dcmEncodeAsJSONNumber")));
        ext.setFallbackCMoveSCPStudyOlderThan(LdapUtils.stringValue((Attribute)attrs.get("dcmFallbackCMoveSCPStudyOlderThan"), null));
        ext.setStorePermissionServiceURL(LdapUtils.stringValue((Attribute)attrs.get("dcmStorePermissionServiceURL"), null));
        ext.setStorePermissionServiceResponse(LdapUtils.stringValue((Attribute)attrs.get("dcmStorePermissionServiceResponse"), null));
        ext.setStorePermissionServiceResponsePattern(LdapArchiveConfiguration.toPattern(attrs.get("dcmStorePermissionServiceResponsePattern")));
        ext.setAllowRejectionForDataRetentionPolicyExpired((AllowRejectionForDataRetentionPolicyExpired)LdapUtils.enumValue(AllowRejectionForDataRetentionPolicyExpired.class, (Attribute)attrs.get("dcmAllowRejectionForDataRetentionPolicyExpired"), null));
        ext.setAcceptedUserRoles(LdapUtils.stringArray((Attribute)attrs.get("dcmAcceptedUserRole"), (String[])new String[0]));
        ext.setAcceptMissingPatientID((AcceptMissingPatientID)LdapUtils.enumValue(AcceptMissingPatientID.class, (Attribute)attrs.get("dcmAcceptMissingPatientID"), null));
        ext.setAllowDeleteStudyPermanently((AllowDeleteStudyPermanently)LdapUtils.enumValue(AllowDeleteStudyPermanently.class, (Attribute)attrs.get("dcmAllowDeleteStudyPermanently"), null));
        ext.setAllowDeletePatient((AllowDeletePatient)LdapUtils.enumValue(AllowDeletePatient.class, (Attribute)attrs.get("dcmAllowDeletePatient"), null));
        ext.setStorePermissionServiceExpirationDatePattern(LdapArchiveConfiguration.toPattern(attrs.get("dcmStorePermissionServiceExpirationDatePattern")));
        ext.setDefaultCharacterSet(LdapUtils.stringValue((Attribute)attrs.get("dcmDefaultCharacterSet"), null));
        ext.setMWLWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLWorklistLabel"), null));
        ext.setUPSWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSWorklistLabel"), null));
        ext.setUPSEventSCUs(LdapUtils.stringArray((Attribute)attrs.get("dcmUPSEventSCU"), (String[])new String[0]));
        ext.setUPSEventSCUKeepAlive(LdapUtils.intValue((Attribute)attrs.get("dcmUPSEventSCUKeepAlive"), (int)0));
        ext.setStorePermissionServiceErrorCommentPattern(LdapArchiveConfiguration.toPattern(attrs.get("dcmStorePermissionServiceErrorCommentPattern")));
        ext.setStorePermissionServiceErrorCodePattern(LdapArchiveConfiguration.toPattern(attrs.get("dcmStorePermissionServiceErrorCodePattern")));
        ext.setRetrieveAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmRetrieveAET"), (String[])new String[0]));
        ext.setReturnRetrieveAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmReturnRetrieveAET"), (String[])new String[0]));
        ext.setMultipleStoreAssociations(LdapUtils.stringArray((Attribute)attrs.get("dcmMultipleStoreAssociations"), (String[])new String[0]));
        ext.setExternalRetrieveAEDestination(LdapUtils.stringValue((Attribute)attrs.get("dcmExternalRetrieveAEDestination"), null));
        ext.setAcceptedMoveDestinations(LdapUtils.stringArray((Attribute)attrs.get("dcmAcceptedMoveDestination"), (String[])new String[0]));
        ext.setValidateCallingAEHostname(LdapUtils.booleanValue((Attribute)attrs.get("dcmValidateCallingAEHostname"), null));
        ext.setHL7PSUSendingApplication(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUSendingApplication"), null));
        ext.setHL7PSUReceivingApplications(LdapUtils.stringArray((Attribute)attrs.get("hl7PSUReceivingApplication"), (String[])new String[0]));
        ext.setHL7PSUDelay(LdapArchiveConfiguration.toDuration(attrs.get("hl7PSUDelay"), null));
        ext.setHL7PSUTimeout(LdapArchiveConfiguration.toDuration(attrs.get("hl7PSUTimeout"), null));
        ext.setHL7PSUOnTimeout(LdapUtils.booleanValue((Attribute)attrs.get("hl7PSUOnTimeout"), null));
        ext.setHL7PSUMWL(LdapUtils.booleanValue((Attribute)attrs.get("hl7PSUMWL"), null));
        ext.setHL7PSUMWLMatchingKey((HL7PSUMWLMatchingKey)LdapUtils.enumValue(HL7PSUMWLMatchingKey.class, (Attribute)attrs.get("hl7PSUMWLMatchingKey"), null));
        ext.setHl7PSUForRequestedProcedure(LdapUtils.booleanValue((Attribute)attrs.get("hl7PSUForRequestedProcedure"), null));
        ext.setHl7PSUPIDPV1(LdapUtils.booleanValue((Attribute)attrs.get("hl7PSUPIDPV1"), null));
        ext.setHl7PSURequestedProcedureID(LdapUtils.stringValue((Attribute)attrs.get("hl7PSURequestedProcedureID"), null));
        ext.setHl7PSUAccessionNumber(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUAccessionNumber"), null));
        ext.setHl7PSUFillerOrderNumber(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUFillerOrderNumber"), null));
        ext.setHl7PSUPlacerOrderNumber(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUPlacerOrderNumber"), null));
        ext.setHL7PSUTemplateParams(LdapUtils.stringArray((Attribute)attrs.get("hl7PSUTemplateParam"), (String[])new String[0]));
        ext.setHl7PSUMessageType((HL7PSUMessageType)LdapUtils.enumValue(HL7PSUMessageType.class, (Attribute)attrs.get("hl7PSUMessageType"), null));
        ext.setHl7PSUConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("hl7PSUCondition"), (String[])new String[0])));
        ext.setHl7PSUMppsTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUMppsTemplateURI"), null));
        ext.setHl7PSUStudyTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("hl7PSUStudyTemplateURI"), null));
        ext.setAcceptConflictingPatientID((AcceptConflictingPatientID)LdapUtils.enumValue(AcceptConflictingPatientID.class, (Attribute)attrs.get("dcmAcceptConflictingPatientID"), null));
        ext.setCopyMoveUpdatePolicy((Attributes.UpdatePolicy)LdapUtils.enumValue(Attributes.UpdatePolicy.class, (Attribute)attrs.get("dcmCopyMoveUpdatePolicy"), null));
        ext.setLinkMWLEntryUpdatePolicy((Attributes.UpdatePolicy)LdapUtils.enumValue(Attributes.UpdatePolicy.class, (Attribute)attrs.get("dcmLinkMWLEntryUpdatePolicy"), null));
        ext.setStorageVerificationPolicy((StorageVerificationPolicy)LdapUtils.enumValue(StorageVerificationPolicy.class, (Attribute)attrs.get("dcmStorageVerificationPolicy"), null));
        ext.setStorageVerificationUpdateLocationStatus(LdapUtils.booleanValue((Attribute)attrs.get("dcmStorageVerificationUpdateLocationStatus"), null));
        ext.setStorageVerificationStorageIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmStorageVerificationStorageID"), (String[])new String[0]));
        ext.setStorageVerificationInitialDelay(LdapArchiveConfiguration.toPeriod(attrs.get("dcmStorageVerificationInitialDelay")));
        ext.setUpdateLocationStatusOnRetrieve(LdapUtils.booleanValue((Attribute)attrs.get("dcmUpdateLocationStatusOnRetrieve"), null));
        ext.setStorageVerificationOnRetrieve(LdapUtils.booleanValue((Attribute)attrs.get("dcmStorageVerificationOnRetrieve"), null));
        ext.setRejectConflictingPatientAttribute(LdapArchiveConfiguration.tags(attrs.get("dcmRejectConflictingPatientAttribute")));
        ext.setRelationalQueryNegotiationLenient(LdapUtils.booleanValue((Attribute)attrs.get("dcmRelationalQueryNegotiationLenient"), null));
        ext.setRelationalRetrieveNegotiationLenient(LdapUtils.booleanValue((Attribute)attrs.get("dcmRelationalRetrieveNegotiationLenient"), null));
        ext.setStowRetiredTransferSyntax(LdapUtils.booleanValue((Attribute)attrs.get("dcmStowRetiredTransferSyntax"), null));
        ext.setStowExcludeAPPMarkers(LdapUtils.booleanValue((Attribute)attrs.get("dcmStowExcludeAPPMarkers"), null));
        ext.setRestrictRetrieveSilently(LdapUtils.booleanValue((Attribute)attrs.get("dcmRestrictRetrieveSilently"), null));
        ext.setStowQuicktime2MP4(LdapUtils.booleanValue((Attribute)attrs.get("dcmStowQuicktime2MP4"), null));
        ext.setStowMaxFragmentLength(LdapUtils.longValue((Attribute)attrs.get("dcmStowMaxFragmentLength"), null));
        ext.setRetrieveTaskWarningOnNoMatch(LdapUtils.booleanValue((Attribute)attrs.get("dcmRetrieveTaskWarningOnNoMatch"), null));
        ext.setRetrieveTaskWarningOnWarnings(LdapUtils.booleanValue((Attribute)attrs.get("dcmRetrieveTaskWarningOnWarnings"), null));
        ext.setUserIdentityNegotiation((UserIdentityNegotiation)LdapUtils.enumValue(UserIdentityNegotiation.class, (Attribute)attrs.get("dcmUserIdentityNegotiation"), null));
        ext.setUserIdentityNegotiationRole(LdapUtils.stringValue((Attribute)attrs.get("dcmUserIdentityNegotiationRole"), null));
        ext.setUserIdentityNegotiationKeycloakClientID(LdapUtils.stringValue((Attribute)attrs.get("dcmUserIdentityNegotiationKeycloakClientID"), null));
        ext.setChangeRequesterAET(LdapUtils.stringValue((Attribute)attrs.get("dcmChangeRequesterAET"), null));
        ext.setFilterByIssuerOfPatientID(LdapUtils.booleanValue((Attribute)attrs.get("dcmFilterByIssuerOfPatientID"), null));
        ext.setMatchSOPClassOnInstanceLevel(LdapUtils.booleanValue((Attribute)attrs.get("dcmMatchSOPClassOnInstanceLevel"), null));
        ext.setUPSUpdateWithoutTransactionUID(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSUpdateWithoutTransactionUID"), null));
    }

    protected void storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ApplicationEntity prev, ApplicationEntity ae, List<ModificationItem> mods) {
        boolean remove;
        ArchiveAEExtension aa = (ArchiveAEExtension)prev.getAEExtension(ArchiveAEExtension.class);
        ArchiveAEExtension bb = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
        if (aa == null && bb == null) {
            return;
        }
        boolean bl = remove = bb == null;
        if (remove) {
            bb = new ArchiveAEExtension();
        } else if (aa == null) {
            aa = new ArchiveAEExtension();
            mods.add(new ModificationItem(1, LdapUtils.attr((String)"objectClass", (Object[])new String[]{"dcmArchiveNetworkAE"})));
        }
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmObjectStorageID", (Object[])aa.getObjectStorageIDs(), (Object[])bb.getObjectStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmObjectStorageCount", (int)aa.getObjectStorageCount(), (int)bb.getObjectStorageCount(), (int)1);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMetadataStorageID", (Object[])aa.getMetadataStorageIDs(), (Object[])bb.getMetadataStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmBulkDataDescriptorID", (Object)aa.getBulkDataDescriptorID(), (Object)bb.getBulkDataDescriptorID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataDelay", (Object)aa.getSeriesMetadataDelay(), (Object)bb.getSeriesMetadataDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeInstanceRecordsDelay", (Object)aa.getPurgeInstanceRecordsDelay(), (Object)bb.getPurgeInstanceRecordsDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStoreAccessControlID", (Object)aa.getStoreAccessControlID(), (Object)bb.getStoreAccessControlID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAccessControlID", (Object[])aa.getAccessControlIDs(), (Object[])bb.getAccessControlIDs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmOverwritePolicy", (Object)aa.getOverwritePolicy(), (Object)bb.getOverwritePolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRecordAttributeModification", (Object)aa.getRecordAttributeModification(), (Object)bb.getRecordAttributeModification(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmBulkDataSpoolDirectory", (Object)aa.getBulkDataSpoolDirectory(), (Object)bb.getBulkDataSpoolDirectory(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQueryRetrieveViewID", (Object)aa.getQueryRetrieveViewID(), (Object)bb.getQueryRetrieveViewID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPersonNameComponentOrderInsensitiveMatching", (Object)aa.getPersonNameComponentOrderInsensitiveMatching(), (Object)bb.getPersonNameComponentOrderInsensitiveMatching(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSendPendingCGet", (Object)aa.getSendPendingCGet(), (Object)bb.getSendPendingCGet(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSendPendingCMoveInterval", (Object)aa.getSendPendingCMoveInterval(), (Object)bb.getSendPendingCMoveInterval(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSpanningCFindSCP", (Object)aa.getSpanningCFindSCP(), (Object)bb.getSpanningCFindSCP(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSpanningCFindSCPRetrieveAET", (Object[])aa.getSpanningCFindSCPRetrieveAETitles(), (Object[])bb.getSpanningCFindSCPRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSpanningCFindSCPPolicy", (Object)aa.getSpanningCFindSCPPolicy(), (Object)bb.getSpanningCFindSCPPolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCP", (Object)aa.getFallbackCMoveSCP(), (Object)bb.getFallbackCMoveSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPDestination", (Object)aa.getFallbackCMoveSCPDestination(), (Object)bb.getFallbackCMoveSCPDestination(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPCallingAET", (Object)aa.getFallbackCMoveSCPCallingAET(), (Object)bb.getFallbackCMoveSCPCallingAET(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPRetries", (Object)aa.getFallbackCMoveSCPRetries(), (Object)bb.getFallbackCMoveSCPRetries(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPLeadingCFindSCP", (Object)aa.getFallbackCMoveSCPLeadingCFindSCP(), (Object)bb.getFallbackCMoveSCPLeadingCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAltCMoveSCP", (Object)aa.getAlternativeCMoveSCP(), (Object)bb.getAlternativeCMoveSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoZIPEntryNameFormat", (Object)aa.getWadoZIPEntryNameFormat(), (Object)bb.getWadoZIPEntryNameFormat(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoSR2HtmlTemplateURI", (Object)aa.getWadoSR2HtmlTemplateURI(), (Object)bb.getWadoSR2HtmlTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoSR2TextTemplateURI", (Object)aa.getWadoSR2TextTemplateURI(), (Object)bb.getWadoSR2TextTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoCDA2HtmlTemplateURI", (Object)aa.getWadoCDA2HtmlTemplateURI(), (Object)bb.getWadoCDA2HtmlTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoThumbnailViewport", (Object)aa.getWadoThumbnailViewPort(), (Object)bb.getWadoThumbnailViewPort(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackWadoURIWebAppName", (Object)aa.getFallbackWadoURIWebApplication(), (Object)bb.getFallbackWadoURIWebApplication(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackWadoURIHttpStatusCode", (Object)aa.getFallbackWadoURIHttpStatusCode(), (Object)bb.getFallbackWadoURIHttpStatusCode(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoIgnorePresentationLUTShape", (Object)aa.getWadoIgnorePresentationLUTShape(), (Object)bb.getWadoIgnorePresentationLUTShape(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWadoMetadataExcludePrivate", (Object)aa.getWadoMetadataWithoutPrivate(), (Object)bb.getWadoMetadataWithoutPrivate(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQueryMaxNumberOfResults", (Object)aa.getQueryMaxNumberOfResults(), (Object)bb.getQueryMaxNumberOfResults(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQidoMaxNumberOfResults", (Object)aa.getQidoMaxNumberOfResults(), (Object)bb.getQidoMaxNumberOfResults(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQidoETag", (Object)aa.getQidoETag(), (Object)bb.getQidoETag(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFwdMppsDestination", (Object[])aa.getMppsForwardDestinations(), (Object[])bb.getMppsForwardDestinations(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanDestination", (Object[])aa.getIanDestinations(), (Object[])bb.getIanDestinations(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanDelay", (Object)aa.getIanDelay(), (Object)bb.getIanDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanTimeout", (Object)aa.getIanTimeout(), (Object)bb.getIanTimeout(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanOnTimeout", (Object)aa.getIanOnTimeout(), (Object)bb.getIanOnTimeout(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHideSPSWithStatusFromMWL", (Object[])aa.getHideSPSWithStatusFromMWL(), (Object[])bb.getHideSPSWithStatusFromMWL(), (Object[])new SPSStatus[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHideSPSWithStatusFromMWLRS", (Object[])aa.getHideSPSWithStatusFromMWLRS(), (Object[])bb.getHideSPSWithStatusFromMWLRS(), (Object[])new SPSStatus[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLAccessionNumberGenerator", (Object)aa.getMWLAccessionNumberGenerator(), (Object)bb.getMWLAccessionNumberGenerator(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLRequestedProcedureIDGenerator", (Object)aa.getMWLRequestedProcedureIDGenerator(), (Object)bb.getMWLRequestedProcedureIDGenerator(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLScheduledProcedureStepIDGenerator", (Object)aa.getMWLScheduledProcedureStepIDGenerator(), (Object)bb.getMWLScheduledProcedureStepIDGenerator(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEncodeAsJSONNumber", (Object[])aa.getEncodeAsJSONNumber(), (Object[])bb.getEncodeAsJSONNumber(), (Object[])new VR[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFallbackCMoveSCPStudyOlderThan", (Object)aa.getFallbackCMoveSCPStudyOlderThan(), (Object)bb.getFallbackCMoveSCPStudyOlderThan(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceURL", (Object)aa.getStorePermissionServiceURL(), (Object)bb.getStorePermissionServiceURL(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceResponse", (Object)aa.getStorePermissionServiceResponse(), (Object)bb.getStorePermissionServiceResponse(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceResponsePattern", (Object)aa.getStorePermissionServiceResponsePattern(), (Object)bb.getStorePermissionServiceResponsePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAllowRejectionForDataRetentionPolicyExpired", (Object)aa.getAllowRejectionForDataRetentionPolicyExpired(), (Object)bb.getAllowRejectionForDataRetentionPolicyExpired(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptedUserRole", (Object[])aa.getAcceptedUserRoles(), (Object[])bb.getAcceptedUserRoles(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptMissingPatientID", (Object)aa.getAcceptMissingPatientID(), (Object)bb.getAcceptMissingPatientID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAllowDeleteStudyPermanently", (Object)aa.getAllowDeleteStudyPermanently(), (Object)bb.getAllowDeleteStudyPermanently(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAllowDeletePatient", (Object)aa.getAllowDeletePatient(), (Object)bb.getAllowDeletePatient(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceExpirationDatePattern", (Object)aa.getStorePermissionServiceExpirationDatePattern(), (Object)bb.getStorePermissionServiceExpirationDatePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDefaultCharacterSet", (Object)aa.getDefaultCharacterSet(), (Object)bb.getDefaultCharacterSet(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLWorklistLabel", (Object)aa.getMWLWorklistLabel(), (Object)bb.getMWLWorklistLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSWorklistLabel", (Object)aa.getUPSWorklistLabel(), (Object)bb.getUPSWorklistLabel(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSEventSCU", (Object[])aa.getUPSEventSCUs(), (Object[])bb.getUPSEventSCUs(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSEventSCUKeepAlive", (int)aa.getUPSEventSCUKeepAlive(), (int)bb.getUPSEventSCUKeepAlive(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceErrorCommentPattern", (Object)aa.getStorePermissionServiceErrorCommentPattern(), (Object)bb.getStorePermissionServiceErrorCommentPattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorePermissionServiceErrorCodePattern", (Object)aa.getStorePermissionServiceErrorCodePattern(), (Object)bb.getStorePermissionServiceErrorCodePattern(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveAET", (Object[])aa.getRetrieveAETitles(), (Object[])bb.getRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmReturnRetrieveAET", (Object[])aa.getReturnRetrieveAETitles(), (Object[])bb.getReturnRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMultipleStoreAssociations", (Object[])aa.getMultipleStoreAssociations(), (Object[])bb.getMultipleStoreAssociations(), (Object[])new MultipleStoreAssociations[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExternalRetrieveAEDestination", (Object)aa.getExternalRetrieveAEDestination(), (Object)bb.getExternalRetrieveAEDestination(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptedMoveDestination", (Object[])aa.getAcceptedMoveDestinations(), (Object[])bb.getAcceptedMoveDestinations(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmValidateCallingAEHostname", (Object)aa.getValidateCallingAEHostname(), (Object)bb.getValidateCallingAEHostname(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUSendingApplication", (Object)aa.getHL7PSUSendingApplication(), (Object)bb.getHL7PSUSendingApplication(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUReceivingApplication", (Object[])aa.getHL7PSUReceivingApplications(), (Object[])bb.getHL7PSUReceivingApplications(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUDelay", (Object)aa.getHL7PSUDelay(), (Object)bb.getHL7PSUDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUTimeout", (Object)aa.getHL7PSUTimeout(), (Object)bb.getHL7PSUTimeout(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUOnTimeout", (Object)aa.getHL7PSUOnTimeout(), (Object)bb.getHL7PSUOnTimeout(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUMWL", (Object)aa.getHL7PSUMWL(), (Object)bb.getHL7PSUMWL(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUMWLMatchingKey", (Object)aa.getHL7PSUMWLMatchingKey(), (Object)bb.getHL7PSUMWLMatchingKey(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUForRequestedProcedure", (Object)aa.getHl7PSUForRequestedProcedure(), (Object)bb.getHl7PSUForRequestedProcedure(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUPIDPV1", (Object)aa.getHl7PSUPIDPV1(), (Object)bb.getHl7PSUPIDPV1(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSURequestedProcedureID", (Object)aa.getHl7PSURequestedProcedureID(), (Object)bb.getHl7PSURequestedProcedureID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUAccessionNumber", (Object)aa.getHl7PSUAccessionNumber(), (Object)bb.getHl7PSUAccessionNumber(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUFillerOrderNumber", (Object)aa.getHl7PSUFillerOrderNumber(), (Object)bb.getHl7PSUFillerOrderNumber(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUPlacerOrderNumber", (Object)aa.getHl7PSUPlacerOrderNumber(), (Object)bb.getHl7PSUPlacerOrderNumber(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUTemplateParam", (Map)aa.getHL7PSUTemplateParams(), (Map)bb.getHL7PSUTemplateParams());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUMessageType", (Object)aa.getHl7PSUMessageType(), (Object)bb.getHl7PSUMessageType(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUCondition", (Map)aa.getHl7PSUConditions().getMap(), (Map)bb.getHl7PSUConditions().getMap());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUMppsTemplateURI", (Object)aa.getHl7PSUMppsTemplateURI(), (Object)bb.getHl7PSUMppsTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7PSUStudyTemplateURI", (Object)aa.getHl7PSUStudyTemplateURI(), (Object)bb.getHl7PSUStudyTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptConflictingPatientID", (Object)aa.getAcceptConflictingPatientID(), (Object)bb.getAcceptConflictingPatientID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCopyMoveUpdatePolicy", (Object)aa.getCopyMoveUpdatePolicy(), (Object)bb.getCopyMoveUpdatePolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmLinkMWLEntryUpdatePolicy", (Object)aa.getLinkMWLEntryUpdatePolicy(), (Object)bb.getLinkMWLEntryUpdatePolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationPolicy", (Object)aa.getStorageVerificationPolicy(), (Object)bb.getStorageVerificationPolicy(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationUpdateLocationStatus", (Object)aa.getStorageVerificationUpdateLocationStatus(), (Object)bb.getStorageVerificationUpdateLocationStatus(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationStorageID", (Object[])aa.getStorageVerificationStorageIDs(), (Object[])bb.getStorageVerificationStorageIDs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationInitialDelay", (Object)aa.getStorageVerificationInitialDelay(), (Object)bb.getStorageVerificationInitialDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUpdateLocationStatusOnRetrieve", (Object)aa.getUpdateLocationStatusOnRetrieve(), (Object)bb.getUpdateLocationStatusOnRetrieve(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageVerificationOnRetrieve", (Object)aa.getStorageVerificationOnRetrieve(), (Object)bb.getStorageVerificationOnRetrieve(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRelationalQueryNegotiationLenient", (Object)aa.getRelationalQueryNegotiationLenient(), (Object)bb.getRelationalQueryNegotiationLenient(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRelationalRetrieveNegotiationLenient", (Object)aa.getRelationalRetrieveNegotiationLenient(), (Object)bb.getRelationalRetrieveNegotiationLenient(), null);
        this.storeDiffTags(mods, "dcmRejectConflictingPatientAttribute", aa.getRejectConflictingPatientAttribute(), bb.getRejectConflictingPatientAttribute());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowRetiredTransferSyntax", (Object)aa.getStowRetiredTransferSyntax(), (Object)bb.getStowRetiredTransferSyntax(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowExcludeAPPMarkers", (Object)aa.getStowExcludeAPPMarkers(), (Object)bb.getStowExcludeAPPMarkers(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRestrictRetrieveSilently", (Object)aa.getRestrictRetrieveSilently(), (Object)bb.getRestrictRetrieveSilently(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowQuicktime2MP4", (Object)aa.getStowQuicktime2MP4(), (Object)bb.getStowQuicktime2MP4(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStowMaxFragmentLength", (Object)aa.getStowMaxFragmentLength(), (Object)bb.getStowMaxFragmentLength(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveTaskWarningOnNoMatch", (Object)aa.getRetrieveTaskWarningOnNoMatch(), (Object)bb.getRetrieveTaskWarningOnNoMatch(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveTaskWarningOnWarnings", (Object)aa.getRetrieveTaskWarningOnWarnings(), (Object)bb.getRetrieveTaskWarningOnWarnings(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUserIdentityNegotiation", (Object)aa.getUserIdentityNegotiation(), (Object)bb.getUserIdentityNegotiation(), (Object)UserIdentityNegotiation.SUPPORTS);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUserIdentityNegotiationRole", (Object)aa.getUserIdentityNegotiationRole(), (Object)bb.getUserIdentityNegotiationRole(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUserIdentityNegotiationKeycloakClientID", (Object)aa.getUserIdentityNegotiationKeycloakClientID(), (Object)bb.getUserIdentityNegotiationKeycloakClientID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmChangeRequesterAET", (Object)aa.getChangeRequesterAET(), (Object)bb.getChangeRequesterAET(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFilterByIssuerOfPatientID", (Object)aa.getFilterByIssuerOfPatientID(), (Object)bb.getFilterByIssuerOfPatientID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMatchSOPClassOnInstanceLevel", (Object)aa.getMatchSOPClassOnInstanceLevel(), (Object)bb.getMatchSOPClassOnInstanceLevel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSUpdateWithoutTransactionUID", (Object)aa.getUPSUpdateWithoutTransactionUID(), (Object)bb.getUPSUpdateWithoutTransactionUID(), null);
        if (remove) {
            mods.add(new ModificationItem(3, LdapUtils.attr((String)"objectClass", (Object[])new String[]{"dcmArchiveNetworkAE"})));
        }
    }

    protected void storeChilds(ConfigurationChanges diffs, String aeDN, ApplicationEntity ae) throws NamingException {
        ArchiveAEExtension aeExt = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
        if (aeExt == null) {
            return;
        }
        this.storeExportRules(diffs, aeExt.getExportRules(), aeDN);
        this.storePrefetchRules(diffs, aeExt.getExportPriorsRules(), aeDN);
        this.storeMPPSForwardRules(diffs, aeExt.getMPPSForwardRules(), aeDN);
        this.storeCompressionRules(diffs, aeExt.getCompressionRules(), aeDN);
        this.storeStoreAccessControlIDRules(diffs, aeExt.getStoreAccessControlIDRules(), aeDN);
        this.storeAttributeCoercions(diffs, aeExt.getAttributeCoercions(), aeDN);
        this.storeAttributeCoercions2(diffs, aeExt.getAttributeCoercions2(), aeDN);
        this.storeStudyRetentionPolicies(diffs, aeExt.getStudyRetentionPolicies(), aeDN);
        this.storeRSForwardRules(diffs, aeExt.getRSForwardRules(), aeDN);
        this.storeUPSOnStoreList(diffs, aeExt.listUPSOnStore(), aeDN);
        this.storeUPSOnUPSCompletedList(diffs, aeExt.listUPSOnUPSCompleted(), aeDN);
    }

    protected void loadChilds(ApplicationEntity ae, String aeDN) throws NamingException {
        ArchiveAEExtension aeExt = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
        if (aeExt == null) {
            return;
        }
        this.loadExportRules(aeExt.getExportRules(), aeDN);
        this.loadPrefetchRules(aeExt.getExportPriorsRules(), aeDN);
        this.loadMPPSForwardRules(aeExt.getMPPSForwardRules(), aeDN);
        this.loadCompressionRules(aeExt.getCompressionRules(), aeDN);
        this.loadStoreAccessControlIDRules(aeExt.getStoreAccessControlIDRules(), aeDN);
        this.loadAttributeCoercions(aeExt.getAttributeCoercions(), aeDN, ae.getDevice());
        this.loadAttributeCoercions2(aeExt.getAttributeCoercions2(), aeDN, ae.getDevice());
        this.loadStudyRetentionPolicies(aeExt.getStudyRetentionPolicies(), aeDN);
        this.loadRSForwardRules(aeExt.getRSForwardRules(), aeDN);
        this.loadUPSOnStoreList(aeExt.listUPSOnStore(), aeDN);
        this.loadUPSOnUPSCompletedList(aeExt.listUPSOnUPSCompleted(), aeDN);
    }

    protected void mergeChilds(ConfigurationChanges diffs, ApplicationEntity prev, ApplicationEntity ae, String aeDN) throws NamingException {
        ArchiveAEExtension aa = (ArchiveAEExtension)prev.getAEExtension(ArchiveAEExtension.class);
        ArchiveAEExtension bb = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
        if (aa == null && bb == null) {
            return;
        }
        if (aa == null) {
            aa = new ArchiveAEExtension();
        } else if (bb == null) {
            bb = new ArchiveAEExtension();
        }
        this.mergeExportRules(diffs, aa.getExportRules(), bb.getExportRules(), aeDN);
        this.mergePrefetchRules(diffs, aa.getExportPriorsRules(), bb.getExportPriorsRules(), aeDN);
        this.mergeMPPSForwardRules(diffs, aa.getMPPSForwardRules(), bb.getMPPSForwardRules(), aeDN);
        this.mergeCompressionRules(diffs, aa.getCompressionRules(), bb.getCompressionRules(), aeDN);
        this.mergeStoreAccessControlIDRules(diffs, aa.getStoreAccessControlIDRules(), bb.getStoreAccessControlIDRules(), aeDN);
        this.mergeAttributeCoercions(diffs, aa.getAttributeCoercions(), bb.getAttributeCoercions(), aeDN);
        this.mergeAttributeCoercions2(diffs, aa.getAttributeCoercions2(), bb.getAttributeCoercions2(), aeDN);
        this.mergeStudyRetentionPolicies(diffs, aa.getStudyRetentionPolicies(), bb.getStudyRetentionPolicies(), aeDN);
        this.mergeRSForwardRules(diffs, aa.getRSForwardRules(), bb.getRSForwardRules(), aeDN);
        this.mergeUPSOnStoreList(diffs, aa.listUPSOnStore(), bb.listUPSOnStore(), aeDN);
        this.mergeUPSOnUPSCompletedList(diffs, aa.listUPSOnUPSCompleted(), bb.listUPSOnUPSCompleted(), aeDN);
    }

    private void storeAttributeFilter(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (Map.Entry entry : arcDev.getAttributeFilters().entrySet()) {
            String dn = LdapUtils.dnOf((String)"dcmEntity", (String)((Entity)entry.getKey()).name(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, LdapArchiveConfiguration.storeTo(ldapObj, (AttributeFilter)entry.getValue(), (Entity)entry.getKey(), new BasicAttributes(true)));
        }
    }

    private void storeAttributeSet(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (Map map : arcDev.getAttributeSet().values()) {
            for (AttributeSet attributeSet : map.values()) {
                String dn = LdapUtils.dnOf((String)"dcmAttributeSetType", (String)attributeSet.getType().name(), (String)"dcmAttributeSetID", (String)attributeSet.getID(), (String)deviceDN);
                ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo(ldapObj, attributeSet, new BasicAttributes(true)));
            }
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, AttributeSet attributeSet, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmAttributeSet");
        attrs.put("dcmAttributeSetType", attributeSet.getType().name());
        attrs.put("dcmAttributeSetID", attributeSet.getID());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAttributeSetTitle", (Object)attributeSet.getTitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)attributeSet.getDescription(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAttributeSetNumber", (int)attributeSet.getNumber(), (int)0);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)attributeSet.getProperties());
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomInstalled", (boolean)attributeSet.isInstalled(), (boolean)true);
        LdapArchiveConfiguration.storeNotEmptyTags(ldapObj, attrs, "dcmTag", attributeSet.getSelection());
        return attrs;
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, AttributeFilter filter, Entity entity, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmAttributeFilter");
        attrs.put("dcmEntity", entity.name());
        LdapArchiveConfiguration.storeNotEmptyTags(ldapObj, attrs, "dcmTag", filter.getSelection());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCustomAttribute1", (Object)filter.getCustomAttribute1(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCustomAttribute2", (Object)filter.getCustomAttribute2(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCustomAttribute3", (Object)filter.getCustomAttribute3(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAttributeUpdatePolicy", (Object)filter.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        return attrs;
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, HL7OrderSPSStatus hl7OrderSPSStatus, SPSStatus spsStatus, BasicAttributes attrs) {
        attrs.put("objectclass", "hl7OrderSPSStatus");
        attrs.put("dcmSPSStatus", spsStatus.name());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OrderControlStatus", (Object[])hl7OrderSPSStatus.getOrderControlStatusCodes(), (Object[])new String[0]);
        return attrs;
    }

    private static void storeNotEmptyTags(ConfigurationChanges.ModifiedObject ldapObj, Attributes attrs, String attrid, int[] vals) {
        if (vals != null && vals.length > 0) {
            attrs.put(LdapArchiveConfiguration.tagsAttr(attrid, vals));
            if (ldapObj != null) {
                ConfigurationChanges.ModifiedAttribute attribute = new ConfigurationChanges.ModifiedAttribute(attrid);
                for (int val : vals) {
                    attribute.addValue((Object)val);
                }
                ldapObj.add(attribute);
            }
        }
    }

    private static Attribute tagsAttr(String attrID, int[] tags) {
        BasicAttribute attr = new BasicAttribute(attrID);
        for (int tag : tags) {
            attr.add(TagUtils.toHexString((int)tag));
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributeFilters(ArchiveDeviceExtension device, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmAttributeFilter)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                AttributeFilter filter = new AttributeFilter(LdapArchiveConfiguration.tags(attrs.get("dcmTag")));
                filter.setCustomAttribute1(LdapArchiveConfiguration.valueSelector(attrs.get("dcmCustomAttribute1")));
                filter.setCustomAttribute2(LdapArchiveConfiguration.valueSelector(attrs.get("dcmCustomAttribute2")));
                filter.setCustomAttribute3(LdapArchiveConfiguration.valueSelector(attrs.get("dcmCustomAttribute3")));
                filter.setAttributeUpdatePolicy((Attributes.UpdatePolicy)LdapUtils.enumValue(Attributes.UpdatePolicy.class, (Attribute)attrs.get("dcmAttributeUpdatePolicy"), (Enum)Attributes.UpdatePolicy.PRESERVE));
                device.setAttributeFilter(Entity.valueOf((String)LdapUtils.stringValue((Attribute)attrs.get("dcmEntity"), null)), filter);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributeSet(ArchiveDeviceExtension device, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmAttributeSet)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                AttributeSet attributeSet = new AttributeSet();
                attributeSet.setType((AttributeSet.Type)LdapUtils.enumValue(AttributeSet.Type.class, (Attribute)attrs.get("dcmAttributeSetType"), null));
                attributeSet.setID(LdapUtils.stringValue((Attribute)attrs.get("dcmAttributeSetID"), null));
                attributeSet.setTitle(LdapUtils.stringValue((Attribute)attrs.get("dcmAttributeSetTitle"), null));
                attributeSet.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
                attributeSet.setNumber(LdapUtils.intValue((Attribute)attrs.get("dcmAttributeSetNumber"), (int)0));
                attributeSet.setProperties(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0]));
                attributeSet.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dicomInstalled"), (boolean)true));
                attributeSet.setSelection(LdapArchiveConfiguration.tags(attrs.get("dcmTag")));
                device.addAttributeSet(attributeSet);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadHL7OrderSPSStatus(Map<SPSStatus, HL7OrderSPSStatus> hl7OrderSPSStatusMap, String deviceDN, LdapDicomConfiguration config) throws NamingException {
        NamingEnumeration ne = config.search(deviceDN, "(objectclass=hl7OrderSPSStatus)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                HL7OrderSPSStatus hl7OrderSPSStatus = new HL7OrderSPSStatus();
                hl7OrderSPSStatus.setSPSStatus(SPSStatus.valueOf((String)LdapUtils.stringValue((Attribute)attrs.get("dcmSPSStatus"), null)));
                hl7OrderSPSStatus.setOrderControlStatusCodes(LdapUtils.stringArray((Attribute)attrs.get("hl7OrderControlStatus"), (String[])new String[0]));
                hl7OrderSPSStatusMap.put(hl7OrderSPSStatus.getSPSStatus(), hl7OrderSPSStatus);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private static ValueSelector valueSelector(Attribute attr) throws NamingException {
        return attr != null ? ValueSelector.valueOf((String)((String)attr.get())) : null;
    }

    private static int[] tags(Attribute attr) throws NamingException {
        if (attr == null) {
            return ByteUtils.EMPTY_INTS;
        }
        int[] is = new int[attr.size()];
        for (int i = 0; i < is.length; ++i) {
            is[i] = TagUtils.intFromHexString((String)((String)attr.get(i)));
        }
        return is;
    }

    private void mergeAttributeFilters(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        for (Entity entity : prev.getAttributeFilters().keySet()) {
            if (arcDev.getAttributeFilters().containsKey(entity)) continue;
            String dn = LdapUtils.dnOf((String)"dcmEntity", (String)entity.name(), (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (Map.Entry entry : arcDev.getAttributeFilters().entrySet()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            Entity entity = (Entity)entry.getKey();
            String dn = LdapUtils.dnOf((String)"dcmEntity", (String)entity.name(), (String)deviceDN);
            AttributeFilter prevFilter = (AttributeFilter)prev.getAttributeFilters().get(entity);
            if (prevFilter == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, LdapArchiveConfiguration.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), (AttributeFilter)entry.getValue(), entity, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevFilter, (AttributeFilter)entry.getValue(), new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeAttributeSet(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        for (Map.Entry prevEntry : prev.getAttributeSet().entrySet()) {
            AttributeSet.Type type = (AttributeSet.Type)prevEntry.getKey();
            Map map = arcDev.getAttributeSet(type);
            for (String name : ((Map)prevEntry.getValue()).keySet()) {
                if (map.containsKey(name)) continue;
                String dn = LdapUtils.dnOf((String)"dcmAttributeSetType", (String)type.name(), (String)"dcmAttributeSetID", (String)name, (String)deviceDN);
                this.config.destroySubcontext(dn);
                ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
            }
        }
        for (Map.Entry entry : arcDev.getAttributeSet().entrySet()) {
            Map prevMap = prev.getAttributeSet((AttributeSet.Type)entry.getKey());
            for (AttributeSet attributeSet : ((Map)entry.getValue()).values()) {
                ConfigurationChanges.ModifiedObject ldapObj;
                String dn = LdapUtils.dnOf((String)"dcmAttributeSetType", (String)attributeSet.getType().name(), (String)"dcmAttributeSetID", (String)attributeSet.getID(), (String)deviceDN);
                AttributeSet prevAttributeSet = (AttributeSet)prevMap.get(attributeSet.getID());
                if (prevAttributeSet == null) {
                    ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                    this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), attributeSet, new BasicAttributes(true)));
                    continue;
                }
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
                this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevAttributeSet, attributeSet, new ArrayList<ModificationItem>()));
                ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
            }
        }
    }

    static void mergeHL7OrderSPSStatus(ConfigurationChanges diffs, Map<SPSStatus, HL7OrderSPSStatus> prev, Map<SPSStatus, HL7OrderSPSStatus> hl7OrderSPSStatusMap, String deviceDN, LdapDicomConfiguration config) throws NamingException {
        for (SPSStatus sPSStatus : prev.keySet()) {
            if (hl7OrderSPSStatusMap.containsKey(sPSStatus)) continue;
            String dn = LdapUtils.dnOf((String)"dcmSPSStatus", (String)sPSStatus.toString(), (String)deviceDN);
            config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (Map.Entry entry : hl7OrderSPSStatusMap.entrySet()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            SPSStatus spsStatus = (SPSStatus)entry.getKey();
            String dn = LdapUtils.dnOf((String)"dcmSPSStatus", (String)spsStatus.toString(), (String)deviceDN);
            HL7OrderSPSStatus prevHL7OrderSPSStatus = prev.get(spsStatus);
            if (prevHL7OrderSPSStatus == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                config.createSubcontext(dn, LdapArchiveConfiguration.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), (HL7OrderSPSStatus)entry.getValue(), spsStatus, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            config.modifyAttributes(dn, LdapArchiveConfiguration.storeDiffs(ldapObj, prevHL7OrderSPSStatus, (HL7OrderSPSStatus)entry.getValue(), new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, AttributeFilter prev, AttributeFilter filter, List<ModificationItem> mods) {
        this.storeDiffTags(mods, "dcmTag", prev.getSelection(), filter.getSelection());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCustomAttribute1", (Object)prev.getCustomAttribute1(), (Object)filter.getCustomAttribute1(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCustomAttribute2", (Object)prev.getCustomAttribute2(), (Object)filter.getCustomAttribute2(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCustomAttribute3", (Object)prev.getCustomAttribute3(), (Object)filter.getCustomAttribute3(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAttributeUpdatePolicy", (Object)prev.getAttributeUpdatePolicy(), (Object)filter.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.PRESERVE);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, AttributeSet prev, AttributeSet attributeSet, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAttributeSetTitle", (Object)prev.getTitle(), (Object)attributeSet.getTitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)prev.getDescription(), (Object)attributeSet.getDescription(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAttributeSetNumber", (int)prev.getNumber(), (int)attributeSet.getNumber(), (int)0);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getProperties(), (Map)attributeSet.getProperties());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomInstalled", (boolean)prev.isInstalled(), (boolean)attributeSet.isInstalled(), (boolean)true);
        this.storeDiffTags(mods, "dcmTag", prev.getSelection(), attributeSet.getSelection());
        return mods;
    }

    private void storeDiffTags(List<ModificationItem> mods, String attrId, int[] prevs, int[] vals) {
        if (!Arrays.equals(prevs, vals)) {
            mods.add(vals == null || vals.length == 0 ? new ModificationItem(3, new BasicAttribute(attrId)) : new ModificationItem(2, LdapArchiveConfiguration.tagsAttr(attrId, vals)));
        }
    }

    private void storeStorageDescriptors(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (StorageDescriptor descriptor : arcDev.getStorageDescriptors()) {
            String dn = LdapUtils.dnOf((String)"dcmStorageID", (String)descriptor.getStorageID(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), descriptor, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, StorageDescriptor descriptor, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmStorage");
        attrs.put("dcmStorageID", descriptor.getStorageID());
        attrs.put("dcmURI", descriptor.getStorageURIStr());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDigestAlgorithm", (Object)descriptor.getDigestAlgorithm(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmInstanceAvailability", (Object)descriptor.getInstanceAvailability(), (Object)Availability.ONLINE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageDuration", (Object)descriptor.getStorageDuration(), (Object)StorageDuration.PERMANENT);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmReadOnly", (boolean)descriptor.isReadOnly(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmNoDeletionConstraint", (boolean)descriptor.isNoDeletionConstraint(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageThresholdExceedsPermanently", (boolean)descriptor.isStorageThresholdExceedsPermanently(), (boolean)true);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageThresholdExceeded", (Object)descriptor.getStorageThresholdExceeded(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleterThreads", (int)descriptor.getDeleterThreads(), (int)1);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageClusterID", (Object)descriptor.getStorageClusterID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStorageThreshold", (Object)descriptor.getStorageThreshold(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleterThreshold", (Object[])descriptor.getDeleterThresholdsAsStrings(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)descriptor.getProperties());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExternalRetrieveAET", (Object[])descriptor.getExternalRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExternalRetrieveInstanceAvailability", (Object)descriptor.getExternalRetrieveInstanceAvailability(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExportStorageID", (Object[])descriptor.getExportStorageID(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveCacheStorageID", (Object)descriptor.getRetrieveCacheStorageID(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveCacheMaxParallel", (int)descriptor.getRetrieveCacheMaxParallel(), (int)10);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteStudiesOlderThan", (Object[])descriptor.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.OlderThan), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteStudiesReceivedBefore", (Object[])descriptor.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.ReceivedBefore), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteStudiesNotUsedSince", (Object[])descriptor.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.NotUsedSince), (Object[])new String[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxRetries", (int)descriptor.getMaxRetries(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetryDelay", (Object)descriptor.getRetryDelay(), null);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStorageDescriptors(ArchiveDeviceExtension arcdev, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmStorage)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                StorageDescriptor desc = new StorageDescriptor(LdapUtils.stringValue((Attribute)attrs.get("dcmStorageID"), null));
                desc.setStorageURIStr(LdapUtils.stringValue((Attribute)attrs.get("dcmURI"), null));
                desc.setDigestAlgorithm(LdapUtils.stringValue((Attribute)attrs.get("dcmDigestAlgorithm"), null));
                desc.setInstanceAvailability((Availability)LdapUtils.enumValue(Availability.class, (Attribute)attrs.get("dcmInstanceAvailability"), (Enum)Availability.ONLINE));
                desc.setStorageDuration((StorageDuration)LdapUtils.enumValue(StorageDuration.class, (Attribute)attrs.get("dcmStorageDuration"), (Enum)StorageDuration.PERMANENT));
                desc.setReadOnly(LdapUtils.booleanValue((Attribute)attrs.get("dcmReadOnly"), (boolean)false));
                desc.setNoDeletionConstraint(LdapUtils.booleanValue((Attribute)attrs.get("dcmNoDeletionConstraint"), (boolean)false));
                desc.setStorageThresholdExceedsPermanently(LdapUtils.booleanValue((Attribute)attrs.get("dcmStorageThresholdExceedsPermanently"), (boolean)true));
                desc.setStorageThresholdExceeded(LdapUtils.dateTimeValue((Attribute)attrs.get("dcmStorageThresholdExceeded")));
                desc.setDeleterThreads(LdapUtils.intValue((Attribute)attrs.get("dcmDeleterThreads"), (int)1));
                desc.setStorageClusterID(LdapUtils.stringValue((Attribute)attrs.get("dcmStorageClusterID"), null));
                desc.setStorageThreshold(LdapArchiveConfiguration.toStorageThreshold(attrs.get("dcmStorageThreshold")));
                desc.setDeleterThresholdsFromStrings(LdapUtils.stringArray((Attribute)attrs.get("dcmDeleterThreshold"), (String[])new String[0]));
                desc.setProperties(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0]));
                desc.setExternalRetrieveAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmExternalRetrieveAET"), (String[])new String[0]));
                desc.setExternalRetrieveInstanceAvailability((Availability)LdapUtils.enumValue(Availability.class, (Attribute)attrs.get("dcmExternalRetrieveInstanceAvailability"), null));
                desc.setExportStorageID(LdapUtils.stringArray((Attribute)attrs.get("dcmExportStorageID"), (String[])new String[0]));
                desc.setRetrieveCacheStorageID(LdapUtils.stringValue((Attribute)attrs.get("dcmRetrieveCacheStorageID"), null));
                desc.setRetrieveCacheMaxParallel(LdapUtils.intValue((Attribute)attrs.get("dcmRetrieveCacheMaxParallel"), (int)10));
                desc.setRetentionPeriods(RetentionPeriod.DeleteStudies.OlderThan, LdapUtils.stringArray((Attribute)attrs.get("dcmDeleteStudiesOlderThan"), (String[])new String[0]));
                desc.setRetentionPeriods(RetentionPeriod.DeleteStudies.ReceivedBefore, LdapUtils.stringArray((Attribute)attrs.get("dcmDeleteStudiesReceivedBefore"), (String[])new String[0]));
                desc.setRetentionPeriods(RetentionPeriod.DeleteStudies.NotUsedSince, LdapUtils.stringArray((Attribute)attrs.get("dcmDeleteStudiesNotUsedSince"), (String[])new String[0]));
                desc.setMaxRetries(LdapUtils.intValue((Attribute)attrs.get("dcmMaxRetries"), (int)0));
                desc.setRetryDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmRetryDelay"), null));
                arcdev.addStorageDescriptor(desc);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private static StorageThreshold toStorageThreshold(Attribute attr) throws NamingException {
        return attr != null ? StorageThreshold.valueOf((String)((String)attr.get())) : null;
    }

    private void mergeStorageDescriptors(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        String dn;
        String storageID;
        for (StorageDescriptor descriptor : prev.getStorageDescriptors()) {
            storageID = descriptor.getStorageID();
            if (arcDev.getStorageDescriptor(storageID) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmStorageID", (String)storageID, (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (StorageDescriptor descriptor : arcDev.getStorageDescriptors()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            storageID = descriptor.getStorageID();
            dn = LdapUtils.dnOf((String)"dcmStorageID", (String)storageID, (String)deviceDN);
            StorageDescriptor prevDescriptor = prev.getStorageDescriptor(storageID);
            if (prevDescriptor == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), descriptor, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevDescriptor, descriptor, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, StorageDescriptor prev, StorageDescriptor desc, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getStorageURIStr(), (Object)desc.getStorageURIStr(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDigestAlgorithm", (Object)prev.getDigestAlgorithm(), (Object)desc.getDigestAlgorithm(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmInstanceAvailability", (Object)prev.getInstanceAvailability(), (Object)desc.getInstanceAvailability(), (Object)Availability.ONLINE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageDuration", (Object)prev.getStorageDuration(), (Object)desc.getStorageDuration(), (Object)StorageDuration.PERMANENT);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmReadOnly", (boolean)prev.isReadOnly(), (boolean)desc.isReadOnly(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmNoDeletionConstraint", (boolean)prev.isNoDeletionConstraint(), (boolean)desc.isNoDeletionConstraint(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageThresholdExceedsPermanently", (boolean)prev.isStorageThresholdExceedsPermanently(), (boolean)desc.isStorageThresholdExceedsPermanently(), (boolean)true);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageThresholdExceeded", (Object)prev.getStorageThresholdExceeded(), (Object)desc.getStorageThresholdExceeded(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleterThreads", (int)prev.getDeleterThreads(), (int)desc.getDeleterThreads(), (int)1);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageClusterID", (Object)prev.getStorageClusterID(), (Object)desc.getStorageClusterID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStorageThreshold", (Object)prev.getStorageThreshold(), (Object)desc.getStorageThreshold(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleterThreshold", (Object[])prev.getDeleterThresholdsAsStrings(), (Object[])desc.getDeleterThresholdsAsStrings(), (Object[])new String[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getProperties(), (Map)desc.getProperties());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExternalRetrieveAET", (Object[])prev.getExternalRetrieveAETitles(), (Object[])desc.getExternalRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExternalRetrieveInstanceAvailability", (Object)prev.getExternalRetrieveInstanceAvailability(), (Object)desc.getExternalRetrieveInstanceAvailability(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExportStorageID", (Object[])prev.getExportStorageID(), (Object[])desc.getExportStorageID(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveCacheStorageID", (Object)prev.getRetrieveCacheStorageID(), (Object)desc.getRetrieveCacheStorageID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveCacheMaxParallel", (int)prev.getRetrieveCacheMaxParallel(), (int)desc.getRetrieveCacheMaxParallel(), (int)10);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteStudiesOlderThan", (Object[])prev.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.OlderThan), (Object[])desc.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.OlderThan), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteStudiesReceivedBefore", (Object[])prev.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.ReceivedBefore), (Object[])desc.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.ReceivedBefore), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteStudiesNotUsedSince", (Object[])prev.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.NotUsedSince), (Object[])desc.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.NotUsedSince), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMaxRetries", (int)prev.getMaxRetries(), (int)desc.getMaxRetries(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetryDelay", (Object)prev.getRetryDelay(), (Object)desc.getRetryDelay(), null);
        return mods;
    }

    private void storeQueueDescriptors(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (QueueDescriptor descriptor : arcDev.getQueueDescriptors()) {
            String dn = LdapUtils.dnOf((String)"dcmQueueName", (String)descriptor.getQueueName(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, descriptor, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, QueueDescriptor descriptor, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmQueue");
        attrs.put("dcmQueueName", descriptor.getQueueName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)descriptor.getDescription(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxTasksParallel", (int)descriptor.getMaxTasksParallel(), (int)1);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxRetries", (int)descriptor.getMaxRetries(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetryDelay", (Object)descriptor.getRetryDelay(), (Object)QueueDescriptor.DEFAULT_RETRY_DELAY);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxRetryDelay", (Object)descriptor.getMaxRetryDelay(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetryDelayMultiplier", (int)descriptor.getRetryDelayMultiplier(), (int)100);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetryOnWarning", (boolean)descriptor.isRetryOnWarning(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeQueueMessageCompletedDelay", (Object)descriptor.getPurgeTaskCompletedDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeQueueMessageFailedDelay", (Object)descriptor.getPurgeTaskFailedDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeQueueMessageWarningDelay", (Object)descriptor.getPurgeTaskWarningDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPurgeQueueMessageCanceledDelay", (Object)descriptor.getPurgeTaskCanceledDelay(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])descriptor.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomInstalled", (boolean)descriptor.isInstalled(), (boolean)true);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQueueDescriptors(ArchiveDeviceExtension arcdev, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmQueue)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                QueueDescriptor desc = new QueueDescriptor(LdapUtils.stringValue((Attribute)attrs.get("dcmQueueName"), null));
                desc.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
                desc.setMaxTasksParallel(LdapUtils.intValue((Attribute)attrs.get("dcmMaxTasksParallel"), (int)1));
                desc.setMaxRetries(LdapUtils.intValue((Attribute)attrs.get("dcmMaxRetries"), (int)0));
                desc.setRetryDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmRetryDelay"), QueueDescriptor.DEFAULT_RETRY_DELAY));
                desc.setMaxRetryDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmMaxRetryDelay"), null));
                desc.setRetryDelayMultiplier(LdapUtils.intValue((Attribute)attrs.get("dcmRetryDelayMultiplier"), (int)100));
                desc.setRetryOnWarning(LdapUtils.booleanValue((Attribute)attrs.get("dcmRetryOnWarning"), (boolean)false));
                desc.setPurgeTaskCompletedDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeQueueMessageCompletedDelay"), null));
                desc.setPurgeTaskFailedDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeQueueMessageFailedDelay"), null));
                desc.setPurgeTaskWarningDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeQueueMessageWarningDelay"), null));
                desc.setPurgeTaskCanceledDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmPurgeQueueMessageCanceledDelay"), null));
                desc.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                desc.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dicomInstalled"), (boolean)true));
                arcdev.addQueueDescriptor(desc);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private void mergeQueueDescriptors(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        String dn;
        String queueName;
        for (QueueDescriptor descriptor : prev.getQueueDescriptors()) {
            queueName = descriptor.getQueueName();
            if (arcDev.getQueueDescriptor(queueName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmQueueName", (String)queueName, (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (QueueDescriptor descriptor : arcDev.getQueueDescriptors()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            queueName = descriptor.getQueueName();
            dn = LdapUtils.dnOf((String)"dcmQueueName", (String)queueName, (String)deviceDN);
            QueueDescriptor prevDescriptor = prev.getQueueDescriptor(queueName);
            if (prevDescriptor == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), descriptor, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevDescriptor, descriptor, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, QueueDescriptor prev, QueueDescriptor desc, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)prev.getDescription(), (Object)desc.getDescription(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMaxTasksParallel", (int)prev.getMaxTasksParallel(), (int)desc.getMaxTasksParallel(), (int)1);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMaxRetries", (int)prev.getMaxRetries(), (int)desc.getMaxRetries(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetryDelay", (Object)prev.getRetryDelay(), (Object)desc.getRetryDelay(), (Object)QueueDescriptor.DEFAULT_RETRY_DELAY);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMaxRetryDelay", (Object)prev.getMaxRetryDelay(), (Object)desc.getMaxRetryDelay(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetryDelayMultiplier", (int)prev.getRetryDelayMultiplier(), (int)desc.getRetryDelayMultiplier(), (int)100);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetryOnWarning", (boolean)prev.isRetryOnWarning(), (boolean)desc.isRetryOnWarning(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeQueueMessageCompletedDelay", (Object)prev.getPurgeTaskCompletedDelay(), (Object)desc.getPurgeTaskCompletedDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeQueueMessageFailedDelay", (Object)prev.getPurgeTaskFailedDelay(), (Object)desc.getPurgeTaskFailedDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeQueueMessageWarningDelay", (Object)prev.getPurgeTaskWarningDelay(), (Object)desc.getPurgeTaskWarningDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPurgeQueueMessageCanceledDelay", (Object)prev.getPurgeTaskCanceledDelay(), (Object)desc.getPurgeTaskCanceledDelay(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])desc.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomInstalled", (boolean)prev.isInstalled(), (boolean)desc.isInstalled(), (boolean)true);
        return mods;
    }

    private void storePDQServiceDescriptors(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (PDQServiceDescriptor descriptor : arcDev.getPDQServiceDescriptors()) {
            String dn = LdapUtils.dnOf((String)"dcmPDQServiceID", (String)descriptor.getPDQServiceID(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, descriptor, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, PDQServiceDescriptor desc, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmPDQService");
        attrs.put("dcmPDQServiceID", desc.getPDQServiceID());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURI", (Object)desc.getPDQServiceURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)desc.getDescription(), null);
        LdapArchiveConfiguration.storeNotEmptyTags(ldapObj, attrs, "dcmTag", desc.getSelection());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)desc.getProperties());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEntity", (Object)desc.getEntity(), (Object)Entity.Patient);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPDQServiceDescriptors(ArchiveDeviceExtension arcdev, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmPDQService)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                PDQServiceDescriptor desc = new PDQServiceDescriptor(LdapUtils.stringValue((Attribute)attrs.get("dcmPDQServiceID"), null));
                desc.setPDQServiceURI(LdapArchiveConfiguration.toURI(attrs.get("dcmURI")));
                desc.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
                desc.setSelection(LdapArchiveConfiguration.tags(attrs.get("dcmTag")));
                desc.setProperties(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0]));
                desc.setEntity((Entity)LdapUtils.enumValue(Entity.class, (Attribute)attrs.get("dcmEntity"), (Enum)Entity.Patient));
                arcdev.addPDQServiceDescriptor(desc);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private void mergePDQServiceDescriptors(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        String dn;
        String pdqServiceID;
        for (PDQServiceDescriptor descriptor : prev.getPDQServiceDescriptors()) {
            pdqServiceID = descriptor.getPDQServiceID();
            if (arcDev.getPDQServiceDescriptor(pdqServiceID) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmPDQServiceID", (String)pdqServiceID, (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (PDQServiceDescriptor descriptor : arcDev.getPDQServiceDescriptors()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            pdqServiceID = descriptor.getPDQServiceID();
            dn = LdapUtils.dnOf((String)"dcmPDQServiceID", (String)pdqServiceID, (String)deviceDN);
            PDQServiceDescriptor prevDescriptor = prev.getPDQServiceDescriptor(pdqServiceID);
            if (prevDescriptor == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), descriptor, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevDescriptor, descriptor, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, PDQServiceDescriptor prev, PDQServiceDescriptor desc, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getPDQServiceURI().toString(), (Object)desc.getPDQServiceURI().toString(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)prev.getDescription(), (Object)desc.getDescription(), null);
        this.storeDiffTags(mods, "dcmTag", prev.getSelection(), desc.getSelection());
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getProperties(), (Map)desc.getProperties());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEntity", (Object)prev.getEntity(), (Object)desc.getEntity(), (Object)Entity.Patient);
        return mods;
    }

    private void storeExporterDescriptors(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (ExporterDescriptor descriptor : arcDev.getExporterDescriptors()) {
            String dn = LdapUtils.dnOf((String)"dcmExporterID", (String)descriptor.getExporterID(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, descriptor, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, ExporterDescriptor descriptor, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmExporter");
        attrs.put("dcmExporterID", descriptor.getExporterID());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURI", (Object)descriptor.getExportURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)descriptor.getDescription(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQueueName", (Object)descriptor.getQueueName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomAETitle", (Object)descriptor.getAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStgCmtSCP", (Object)descriptor.getStgCmtSCPAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteStudyFromStorageID", (Object)descriptor.getDeleteStudyFromStorageID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIanDestination", (Object[])descriptor.getIanDestinations(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveAET", (Object[])descriptor.getRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveLocationUID", (Object)descriptor.getRetrieveLocationUID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmInstanceAvailability", (Object)descriptor.getInstanceAvailability(), (Object)Availability.ONLINE);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])descriptor.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)descriptor.getProperties());
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectForDataRetentionExpiry", (boolean)descriptor.isRejectForDataRetentionExpiry(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExportAsSourceAE", (boolean)descriptor.isExportAsSourceAE(), (boolean)false);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExporterDescriptors(ArchiveDeviceExtension arcdev, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmExporter)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                ExporterDescriptor desc = new ExporterDescriptor(LdapUtils.stringValue((Attribute)attrs.get("dcmExporterID"), null));
                desc.setExportURI(LdapArchiveConfiguration.toURI(attrs.get("dcmURI")));
                desc.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
                desc.setQueueName(LdapUtils.stringValue((Attribute)attrs.get("dcmQueueName"), null));
                desc.setAETitle(LdapUtils.stringValue((Attribute)attrs.get("dicomAETitle"), null));
                desc.setStgCmtSCPAETitle(LdapUtils.stringValue((Attribute)attrs.get("dcmStgCmtSCP"), null));
                desc.setDeleteStudyFromStorageID(LdapUtils.stringValue((Attribute)attrs.get("dcmDeleteStudyFromStorageID"), null));
                desc.setIanDestinations(LdapUtils.stringArray((Attribute)attrs.get("dcmIanDestination"), (String[])new String[0]));
                desc.setRetrieveAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmRetrieveAET"), (String[])new String[0]));
                desc.setRetrieveLocationUID(LdapUtils.stringValue((Attribute)attrs.get("dcmRetrieveLocationUID"), null));
                desc.setInstanceAvailability((Availability)LdapUtils.enumValue(Availability.class, (Attribute)attrs.get("dcmInstanceAvailability"), (Enum)Availability.ONLINE));
                desc.setRejectForDataRetentionExpiry(LdapUtils.booleanValue((Attribute)attrs.get("dcmRejectForDataRetentionExpiry"), (boolean)false));
                desc.setExportAsSourceAE(LdapUtils.booleanValue((Attribute)attrs.get("dcmExportAsSourceAE"), (boolean)false));
                desc.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                desc.setProperties(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0]));
                arcdev.addExporterDescriptor(desc);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private void mergeExportDescriptors(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        String dn;
        String exporterID;
        for (ExporterDescriptor descriptor : prev.getExporterDescriptors()) {
            exporterID = descriptor.getExporterID();
            if (arcDev.getExporterDescriptor(exporterID) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmExporterID", (String)exporterID, (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (ExporterDescriptor descriptor : arcDev.getExporterDescriptors()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            exporterID = descriptor.getExporterID();
            dn = LdapUtils.dnOf((String)"dcmExporterID", (String)exporterID, (String)deviceDN);
            ExporterDescriptor prevDescriptor = prev.getExporterDescriptor(exporterID);
            if (prevDescriptor == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), descriptor, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevDescriptor, descriptor, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ExporterDescriptor prev, ExporterDescriptor desc, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getExportURI().toString(), (Object)desc.getExportURI().toString(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)prev.getDescription(), (Object)desc.getDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQueueName", (Object)prev.getQueueName(), (Object)desc.getQueueName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomAETitle", (Object)prev.getAETitle(), (Object)desc.getAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStgCmtSCP", (Object)prev.getStgCmtSCPAETitle(), (Object)desc.getStgCmtSCPAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteStudyFromStorageID", (Object)prev.getDeleteStudyFromStorageID(), (Object)desc.getDeleteStudyFromStorageID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIanDestination", (Object[])prev.getIanDestinations(), (Object[])desc.getIanDestinations(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveAET", (Object[])prev.getRetrieveAETitles(), (Object[])desc.getRetrieveAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveLocationUID", (Object)prev.getRetrieveLocationUID(), (Object)desc.getRetrieveLocationUID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmInstanceAvailability", (Object)prev.getInstanceAvailability(), (Object)desc.getInstanceAvailability(), (Object)Availability.ONLINE);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])desc.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getProperties(), (Map)desc.getProperties());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectForDataRetentionExpiry", (boolean)prev.isRejectForDataRetentionExpiry(), (boolean)desc.isRejectForDataRetentionExpiry(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExportAsSourceAE", (boolean)prev.isExportAsSourceAE(), (boolean)desc.isExportAsSourceAE(), (boolean)false);
        return mods;
    }

    private void storeExportRules(ConfigurationChanges diffs, Collection<ExportRule> exportRules, String parentDN) throws NamingException {
        for (ExportRule rule : exportRules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    private void storeMPPSForwardRules(ConfigurationChanges diffs, Collection<MPPSForwardRule> mppsFwdRules, String parentDN) throws NamingException {
        for (MPPSForwardRule rule : mppsFwdRules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    private void storeMWLIdleTimeouts(ConfigurationChanges diffs, Collection<MWLIdleTimeout> mwlIdleTimeouts, String parentDN) throws NamingException {
        for (MWLIdleTimeout mwlIdleTimeout : mwlIdleTimeouts) {
            String dn = LdapUtils.dnOf((String)"cn", (String)mwlIdleTimeout.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, mwlIdleTimeout, new BasicAttributes(true)));
        }
    }

    private void storeMWLImports(ConfigurationChanges diffs, Collection<MWLImport> mwlImports, String parentDN) throws NamingException {
        for (MWLImport rule : mwlImports) {
            String dn = LdapUtils.dnOf((String)"dcmMWLImportID", (String)rule.getMWLImportID(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    private void storeUPSOnStoreList(ConfigurationChanges diffs, Collection<UPSOnStore> upsOnStoreList, String parentDN) throws NamingException {
        for (UPSOnStore upsOnStore : upsOnStoreList) {
            String dn = LdapUtils.dnOf((String)"dcmUPSOnStoreID", (String)upsOnStore.getUPSOnStoreID(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, upsOnStore, new BasicAttributes(true)));
        }
    }

    private void storeUPSOnUPSCompletedList(ConfigurationChanges diffs, Collection<UPSOnUPSCompleted> upsOnUPSCompletedList, String parentDN) throws NamingException {
        for (UPSOnUPSCompleted upsOnUPSCompleted : upsOnUPSCompletedList) {
            String dn = LdapUtils.dnOf((String)"dcmUPSOnUPSCompletedID", (String)upsOnUPSCompleted.getUPSonUPSCompletedID(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, upsOnUPSCompleted, new BasicAttributes(true)));
        }
    }

    private void storeUPSProcessingRules(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (UPSProcessingRule upsProcessingRule : arcDev.listUPSProcessingRules()) {
            String dn = LdapUtils.dnOf((String)"dcmUPSProcessingRuleID", (String)upsProcessingRule.getUPSProcessingRuleID(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, upsProcessingRule, new BasicAttributes(true)));
        }
    }

    static void storeUPSOnHL7List(ConfigurationChanges diffs, Collection<UPSOnHL7> upsOnHL7List, String parentDN, LdapDicomConfiguration config) throws NamingException {
        for (UPSOnHL7 upsOnHL7 : upsOnHL7List) {
            String dn = LdapUtils.dnOf((String)"hl7UPSOnHL7ID", (String)upsOnHL7.getUPSOnHL7ID(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            config.createSubcontext(dn, LdapArchiveConfiguration.storeTo(ldapObj, upsOnHL7, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, ExportRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmExportRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExporterID", (Object[])rule.getExporterIDs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEntity", (Object)rule.getEntity(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDeviceName", (Object)rule.getExporterDeviceName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDuration", (Object)rule.getExportDelay(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExportPreviousEntity", (boolean)rule.isExportPreviousEntity(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExportReoccurredInstances", (Object)rule.getExportReoccurredInstances(), (Object)ExportReoccurredInstances.REPLACE);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, MPPSForwardRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmMPPSForwardRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFwdMppsDestination", (Object[])rule.getDestinations(), (Object[])new String[0]);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, MWLIdleTimeout mwlIdleTimeout, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmMWLIdleTimeout");
        attrs.put("cn", mwlIdleTimeout.getCommonName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomAETitle", (Object)mwlIdleTimeout.getAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLStatusOnIdle", (Object)mwlIdleTimeout.getStatusOnIdle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDuration", (Object)mwlIdleTimeout.getIdleTimeout(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAETitle", (Object[])mwlIdleTimeout.getScheduledStationAETitles(), (Object[])new String[0]);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, MWLImport rule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmMWLImport");
        attrs.put("dcmMWLImportID", rule.getMWLImportID());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomAETitle", (Object)rule.getAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeMWLSCP", (Object)rule.getMWLSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLWorklistLabel", (Object)rule.getMWLWorklistLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDuration", (Object)rule.getPrefetchBefore(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLImportNotOlder", (Object)rule.getNotOlderThan(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLImportFilterBySCU", (boolean)rule.isFilterBySCU(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLImportDeleteNotFound", (boolean)rule.isDeleteNotFound(), (boolean)false);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIncludeField", (Object[])rule.getIncludeFields(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getFilter());
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UPSOnStore upsOnStore, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmUPSOnStore");
        attrs.put("dcmUPSOnStoreID", upsOnStore.getUPSOnStoreID());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSLabel", (Object)upsOnStore.getProcedureStepLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSPriority", (Object)upsOnStore.getUPSPriority(), (Object)UPSPriority.MEDIUM);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSInputReadinessState", (Object)upsOnStore.getInputReadinessState(), (Object)InputReadinessState.READY);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSStartDateTimeDelay", (Object)upsOnStore.getStartDateTimeDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSCompletionDateTimeDelay", (Object)upsOnStore.getCompletionDateTimeDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSWorklistLabel", (Object)upsOnStore.getWorklistLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSInstanceUIDBasedOnName", (Object)upsOnStore.getInstanceUIDBasedOnName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludeInputInformation", (Object)upsOnStore.getIncludeInputInformation(), (Object)UPSOnStore.IncludeInputInformation.APPEND);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludePatient", (boolean)upsOnStore.isIncludePatient(), (boolean)true);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludeStudyInstanceUID", (boolean)upsOnStore.isIncludeStudyInstanceUID(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludeReferencedRequest", (boolean)upsOnStore.isIncludeReferencedRequest(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDestinationAE", (Object)upsOnStore.getDestinationAE(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEntity", (Object)upsOnStore.getScopeOfAccumulation(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledWorkitemCode", (Object)upsOnStore.getScheduledWorkitemCode(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationNameCode", (Object[])upsOnStore.getScheduledStationNames(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationClassCode", (Object[])upsOnStore.getScheduledStationClasses(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationLocationCode", (Object[])upsOnStore.getScheduledStationLocations(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerCode", (Object[])upsOnStore.getScheduledHumanPerformers(), (Object[])new Code[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerName", (Object)upsOnStore.getScheduledHumanPerformerName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerOrganization", (Object)upsOnStore.getScheduledHumanPerformerOrganization(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAdmissionID", (Object)upsOnStore.getAdmissionID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomIssuerOfAdmissionID", (Object)upsOnStore.getIssuerOfAdmissionID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAccessionNumber", (Object)upsOnStore.getAccessionNumber(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomIssuerOfAccessionNumber", (Object)upsOnStore.getIssuerOfAccessionNumber(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequestedProcedureID", (Object)upsOnStore.getRequestedProcedureID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequestedProcedureDescription", (Object)upsOnStore.getRequestedProcedureDescription(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequestingPhysician", (Object)upsOnStore.getRequestingPhysician(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequestingService", (Object)upsOnStore.getRequestingService(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURI", (Object)upsOnStore.getXSLTStylesheetURI(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmNoKeywords", (boolean)upsOnStore.isNoKeywords(), (boolean)false);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)upsOnStore.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])upsOnStore.getSchedules(), (Object[])new ScheduleExpression[0]);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UPSOnUPSCompleted upsOnUPSCompleted, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmUPSOnUPSCompleted");
        attrs.put("dcmUPSOnUPSCompletedID", upsOnUPSCompleted.getUPSonUPSCompletedID());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)upsOnUPSCompleted.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequiresOtherUPSCompleted", (Object[])upsOnUPSCompleted.getRequiresOtherUPSCompleted(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSLabel", (Object)upsOnUPSCompleted.getProcedureStepLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSWorklistLabel", (Object)upsOnUPSCompleted.getWorklistLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSInstanceUIDBasedOnName", (Object)upsOnUPSCompleted.getInstanceUIDBasedOnName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludeInputInformation", (Object)upsOnUPSCompleted.getIncludeInputInformation(), (Object)UPSOnUPSCompleted.IncludeInputInformation.COPY_OUTPUT);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludePatient", (boolean)upsOnUPSCompleted.isIncludePatient(), (boolean)true);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSPriority", (Object)upsOnUPSCompleted.getUPSPriority(), (Object)UPSPriority.MEDIUM);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSInputReadinessState", (Object)upsOnUPSCompleted.getInputReadinessState(), (Object)InputReadinessState.READY);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSStartDateTimeDelay", (Object)upsOnUPSCompleted.getStartDateTimeDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSCompletionDateTimeDelay", (Object)upsOnUPSCompleted.getCompletionDateTimeDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDestinationAE", (Object)upsOnUPSCompleted.getDestinationAE(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEntity", (Object)upsOnUPSCompleted.getScopeOfAccumulation(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledWorkitemCode", (Object)upsOnUPSCompleted.getScheduledWorkitemCode(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationNameCode", (Object[])upsOnUPSCompleted.getScheduledStationNames(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationClassCode", (Object[])upsOnUPSCompleted.getScheduledStationClasses(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationLocationCode", (Object[])upsOnUPSCompleted.getScheduledStationLocations(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerCode", (Object[])upsOnUPSCompleted.getScheduledHumanPerformers(), (Object[])new Code[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerName", (Object)upsOnUPSCompleted.getScheduledHumanPerformerName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerOrganization", (Object)upsOnUPSCompleted.getScheduledHumanPerformerOrganization(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAdmissionID", (Object)upsOnUPSCompleted.getAdmissionID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomIssuerOfAdmissionID", (Object)upsOnUPSCompleted.getIssuerOfAdmissionID(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludeStudyInstanceUID", (boolean)upsOnUPSCompleted.isIncludeStudyInstanceUID(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludeReferencedRequest", (boolean)upsOnUPSCompleted.isIncludeReferencedRequest(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURI", (Object)upsOnUPSCompleted.getXSLTStylesheetURI(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmNoKeywords", (boolean)upsOnUPSCompleted.isNoKeywords(), (boolean)false);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UPSProcessingRule upsProcessingRule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmUPSProcessingRule");
        attrs.put("dcmUPSProcessingRuleID", upsProcessingRule.getUPSProcessingRuleID());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomAETitle", (Object)upsProcessingRule.getAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURI", (Object)upsProcessingRule.getUPSProcessorURI(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)upsProcessingRule.getProperties());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])upsProcessingRule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxThreads", (int)upsProcessingRule.getMaxThreads(), (int)1);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSInputReadinessState", (Object)upsProcessingRule.getInputReadinessState(), (Object)InputReadinessState.READY);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSPriority", (Object)upsProcessingRule.getUPSPriority(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSLabel", (Object)upsProcessingRule.getProcedureStepLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSWorklistLabel", (Object)upsProcessingRule.getWorklistLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledWorkitemCode", (Object)upsProcessingRule.getScheduledWorkitemCode(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationNameCode", (Object)upsProcessingRule.getScheduledStationName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationClassCode", (Object)upsProcessingRule.getScheduledStationClass(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationLocationCode", (Object)upsProcessingRule.getScheduledStationLocation(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSPerformedWorkitemCode", (Object)upsProcessingRule.getPerformedWorkitemCode(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSPerformedStationNameCode", (Object)upsProcessingRule.getPerformedStationNameCode(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRescheduleDiscontinuationReasonCode", (Object[])upsProcessingRule.getRescheduleDiscontinuationReasonCodes(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIgnoreDiscontinuationReasonCode", (Object[])upsProcessingRule.getIgnoreDiscontinuationReasonCodes(), (Object[])new Code[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxRetries", (int)upsProcessingRule.getMaxRetries(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetryDelay", (Object)upsProcessingRule.getRetryDelay(), (Object)UPSProcessingRule.DEFAULT_RETRY_DELAY);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxRetryDelay", (Object)upsProcessingRule.getMaxRetryDelay(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetryDelayMultiplier", (int)upsProcessingRule.getRetryDelayMultiplier(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSTemplateID", (Object)upsProcessingRule.getUpsTemplateID(), null);
        return attrs;
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, UPSOnHL7 upsOnHL7, BasicAttributes attrs) {
        attrs.put("objectclass", "hl7UPSOnHL7");
        attrs.put("hl7UPSOnHL7ID", upsOnHL7.getUPSOnHL7ID());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSLabel", (Object)upsOnHL7.getProcedureStepLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSPriority", (Object)upsOnHL7.getUPSPriority(), (Object)UPSPriority.MEDIUM);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSInputReadinessState", (Object)upsOnHL7.getInputReadinessState(), (Object)InputReadinessState.READY);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSStartDateTimeDelay", (Object)upsOnHL7.getStartDateTimeDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSCompletionDateTimeDelay", (Object)upsOnHL7.getCompletionDateTimeDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSWorklistLabel", (Object)upsOnHL7.getWorklistLabel(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSInstanceUIDBasedOnName", (Object)upsOnHL7.getInstanceUIDBasedOnName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDestinationAE", (Object)upsOnHL7.getDestinationAE(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledWorkitemCode", (Object)upsOnHL7.getScheduledWorkitemCode(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationNameCode", (Object[])upsOnHL7.getScheduledStationNames(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationClassCode", (Object[])upsOnHL7.getScheduledStationClasses(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledStationLocationCode", (Object[])upsOnHL7.getScheduledStationLocations(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerCode", (Object[])upsOnHL7.getScheduledHumanPerformers(), (Object[])new Code[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerName", (Object)upsOnHL7.getScheduledHumanPerformerName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSScheduledHumanPerformerOrganization", (Object)upsOnHL7.getScheduledHumanPerformerOrganization(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludeStudyInstanceUID", (boolean)upsOnHL7.isIncludeStudyInstanceUID(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUPSIncludeReferencedRequest", (boolean)upsOnHL7.isIncludeReferencedRequest(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStudyInstanceUID", (Object)upsOnHL7.getStudyInstanceUID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAdmissionID", (Object)upsOnHL7.getAdmissionID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomIssuerOfAdmissionID", (Object)upsOnHL7.getIssuerOfAdmissionID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAccessionNumber", (Object)upsOnHL7.getAccessionNumber(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomIssuerOfAccessionNumber", (Object)upsOnHL7.getIssuerOfAccessionNumber(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequestedProcedureID", (Object)upsOnHL7.getRequestedProcedureID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequestedProcedureDescription", (Object)upsOnHL7.getRequestedProcedureDescription(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequestingPhysician", (Object)upsOnHL7.getRequestingPhysician(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRequestingService", (Object)upsOnHL7.getRequestingService(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURI", (Object)upsOnHL7.getXSLTStylesheetURI(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)upsOnHL7.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])upsOnHL7.getSchedules(), (Object[])new ScheduleExpression[0]);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExportRules(Collection<ExportRule> exportRules, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmExportRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                ExportRule rule = new ExportRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                rule.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                rule.setExporterIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmExporterID"), (String[])new String[0]));
                rule.setEntity((Entity)LdapUtils.enumValue(Entity.class, (Attribute)attrs.get("dcmEntity"), null));
                rule.setExportDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmDuration"), null));
                rule.setExportPreviousEntity(LdapUtils.booleanValue((Attribute)attrs.get("dcmExportPreviousEntity"), (boolean)false));
                rule.setExportReoccurredInstances((ExportReoccurredInstances)LdapUtils.enumValue(ExportReoccurredInstances.class, (Attribute)attrs.get("dcmExportReoccurredInstances"), (Enum)ExportReoccurredInstances.REPLACE));
                rule.setExporterDeviceName(LdapUtils.stringValue((Attribute)attrs.get("dicomDeviceName"), null));
                exportRules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMPPSForwardRules(Collection<MPPSForwardRule> mppsFwdRules, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmMPPSForwardRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                MPPSForwardRule rule = new MPPSForwardRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                rule.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                rule.setDestinations(LdapUtils.stringArray((Attribute)attrs.get("dcmFwdMppsDestination"), (String[])new String[0]));
                mppsFwdRules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMWLIdleTimeouts(Collection<MWLIdleTimeout> mwlIdleTimeouts, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmMWLIdleTimeout)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                MWLIdleTimeout mwlIdleTimeout = new MWLIdleTimeout(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                mwlIdleTimeout.setAETitle(LdapUtils.stringValue((Attribute)attrs.get("dicomAETitle"), null));
                mwlIdleTimeout.setStatusOnIdle((SPSStatus)LdapUtils.enumValue(SPSStatus.class, (Attribute)attrs.get("dcmMWLStatusOnIdle"), null));
                mwlIdleTimeout.setIdleTimeout(LdapArchiveConfiguration.toDuration(attrs.get("dcmDuration"), null));
                mwlIdleTimeout.setScheduledStationAETitles(LdapUtils.stringArray((Attribute)attrs.get("dcmAETitle"), (String[])new String[0]));
                mwlIdleTimeouts.add(mwlIdleTimeout);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMWLImports(Collection<MWLImport> mwlImports, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmMWLImport)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                MWLImport rule = new MWLImport(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLImportID"), null));
                rule.setAETitle(LdapUtils.stringValue((Attribute)attrs.get("dicomAETitle"), null));
                rule.setMWLSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmMergeMWLSCP"), null));
                rule.setMWLWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmMWLWorklistLabel"), null));
                rule.setPrefetchBefore(LdapArchiveConfiguration.toDuration(attrs.get("dcmDuration"), null));
                rule.setNotOlderThan(LdapArchiveConfiguration.toDuration(attrs.get("dcmMWLImportNotOlder"), null));
                rule.setFilterBySCU(LdapUtils.booleanValue((Attribute)attrs.get("dcmMWLImportFilterBySCU"), (boolean)false));
                rule.setDeleteNotFound(LdapUtils.booleanValue((Attribute)attrs.get("dcmMWLImportDeleteNotFound"), (boolean)false));
                rule.setIncludeFields(LdapUtils.stringArray((Attribute)attrs.get("dcmIncludeField"), (String[])new String[0]));
                rule.setFilter(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0]));
                mwlImports.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUPSOnStoreList(Collection<UPSOnStore> upsOnStoreList, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmUPSOnStore)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UPSOnStore upsOnStore = new UPSOnStore(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSOnStoreID"), null));
                upsOnStore.setProcedureStepLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSLabel"), null));
                upsOnStore.setUPSPriority((UPSPriority)LdapUtils.enumValue(UPSPriority.class, (Attribute)attrs.get("dcmUPSPriority"), (Enum)UPSPriority.MEDIUM));
                upsOnStore.setInputReadinessState((InputReadinessState)LdapUtils.enumValue(InputReadinessState.class, (Attribute)attrs.get("dcmUPSInputReadinessState"), (Enum)InputReadinessState.READY));
                upsOnStore.setStartDateTimeDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmUPSStartDateTimeDelay"), null));
                upsOnStore.setCompletionDateTimeDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmUPSCompletionDateTimeDelay"), null));
                upsOnStore.setWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSWorklistLabel"), null));
                upsOnStore.setInstanceUIDBasedOnName(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSInstanceUIDBasedOnName"), null));
                upsOnStore.setIncludeInputInformation((UPSOnStore.IncludeInputInformation)LdapUtils.enumValue(UPSOnStore.IncludeInputInformation.class, (Attribute)attrs.get("dcmUPSIncludeInputInformation"), (Enum)UPSOnStore.IncludeInputInformation.APPEND));
                upsOnStore.setIncludePatient(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSIncludePatient"), (boolean)true));
                upsOnStore.setIncludeStudyInstanceUID(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSIncludeStudyInstanceUID"), (boolean)false));
                upsOnStore.setIncludeReferencedRequest(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSIncludeReferencedRequest"), (boolean)false));
                upsOnStore.setDestinationAE(LdapUtils.stringValue((Attribute)attrs.get("dcmDestinationAE"), null));
                upsOnStore.setScopeOfAccumulation((Entity)LdapUtils.enumValue(Entity.class, (Attribute)attrs.get("dcmEntity"), null));
                upsOnStore.setScheduledWorkitemCode(LdapUtils.codeValue((Attribute)attrs.get("dcmUPSScheduledWorkitemCode")));
                upsOnStore.setScheduledStationNames(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationNameCode")));
                upsOnStore.setScheduledStationClasses(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationClassCode")));
                upsOnStore.setScheduledStationLocations(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationLocationCode")));
                upsOnStore.setScheduledHumanPerformers(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledHumanPerformerCode")));
                upsOnStore.setScheduledHumanPerformerName(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSScheduledHumanPerformerName"), null));
                upsOnStore.setScheduledHumanPerformerOrganization(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSScheduledHumanPerformerOrganization"), null));
                upsOnStore.setAdmissionID(LdapUtils.stringValue((Attribute)attrs.get("dcmAdmissionID"), null));
                upsOnStore.setIssuerOfAdmissionID(LdapUtils.issuerValue((Attribute)attrs.get("dicomIssuerOfAdmissionID")));
                upsOnStore.setAccessionNumber(LdapUtils.stringValue((Attribute)attrs.get("dcmAccessionNumber"), null));
                upsOnStore.setIssuerOfAccessionNumber(LdapUtils.issuerValue((Attribute)attrs.get("dicomIssuerOfAccessionNumber")));
                upsOnStore.setRequestedProcedureID(LdapUtils.stringValue((Attribute)attrs.get("dcmRequestedProcedureID"), null));
                upsOnStore.setRequestedProcedureDescription(LdapUtils.stringValue((Attribute)attrs.get("dcmRequestedProcedureDescription"), null));
                upsOnStore.setRequestingPhysician(LdapUtils.stringValue((Attribute)attrs.get("dcmRequestingPhysician"), null));
                upsOnStore.setRequestingService(LdapUtils.stringValue((Attribute)attrs.get("dcmRequestingService"), null));
                upsOnStore.setXSLTStylesheetURI(LdapUtils.stringValue((Attribute)attrs.get("dcmURI"), null));
                upsOnStore.setNoKeywords(LdapUtils.booleanValue((Attribute)attrs.get("dcmNoKeywords"), (boolean)false));
                upsOnStore.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                upsOnStore.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                upsOnStoreList.add(upsOnStore);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUPSOnUPSCompletedList(Collection<UPSOnUPSCompleted> upsOnUPSCompletedList, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmUPSOnUPSCompleted)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UPSOnUPSCompleted upsOnUPSCompleted = new UPSOnUPSCompleted(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSOnUPSCompletedID"), null));
                upsOnUPSCompleted.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                upsOnUPSCompleted.setRequiresOtherUPSCompleted(LdapUtils.stringArray((Attribute)attrs.get("dcmRequiresOtherUPSCompleted"), (String[])new String[0]));
                upsOnUPSCompleted.setProcedureStepLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSLabel"), null));
                upsOnUPSCompleted.setUPSPriority((UPSPriority)LdapUtils.enumValue(UPSPriority.class, (Attribute)attrs.get("dcmUPSPriority"), (Enum)UPSPriority.MEDIUM));
                upsOnUPSCompleted.setInputReadinessState((InputReadinessState)LdapUtils.enumValue(InputReadinessState.class, (Attribute)attrs.get("dcmUPSInputReadinessState"), (Enum)InputReadinessState.READY));
                upsOnUPSCompleted.setStartDateTimeDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmUPSStartDateTimeDelay"), null));
                upsOnUPSCompleted.setCompletionDateTimeDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmUPSCompletionDateTimeDelay"), null));
                upsOnUPSCompleted.setWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSWorklistLabel"), null));
                upsOnUPSCompleted.setInstanceUIDBasedOnName(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSInstanceUIDBasedOnName"), null));
                upsOnUPSCompleted.setIncludeInputInformation((UPSOnUPSCompleted.IncludeInputInformation)LdapUtils.enumValue(UPSOnUPSCompleted.IncludeInputInformation.class, (Attribute)attrs.get("dcmUPSIncludeInputInformation"), (Enum)UPSOnUPSCompleted.IncludeInputInformation.COPY_OUTPUT));
                upsOnUPSCompleted.setIncludePatient(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSIncludePatient"), (boolean)true));
                upsOnUPSCompleted.setDestinationAE(LdapUtils.stringValue((Attribute)attrs.get("dcmDestinationAE"), null));
                upsOnUPSCompleted.setScopeOfAccumulation((Entity)LdapUtils.enumValue(Entity.class, (Attribute)attrs.get("dcmEntity"), null));
                upsOnUPSCompleted.setScheduledWorkitemCode(LdapUtils.codeValue((Attribute)attrs.get("dcmUPSScheduledWorkitemCode")));
                upsOnUPSCompleted.setScheduledStationNames(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationNameCode")));
                upsOnUPSCompleted.setScheduledStationClasses(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationClassCode")));
                upsOnUPSCompleted.setScheduledStationLocations(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationLocationCode")));
                upsOnUPSCompleted.setScheduledHumanPerformers(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledHumanPerformerCode")));
                upsOnUPSCompleted.setScheduledHumanPerformerName(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSScheduledHumanPerformerName"), null));
                upsOnUPSCompleted.setScheduledHumanPerformerOrganization(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSScheduledHumanPerformerOrganization"), null));
                upsOnUPSCompleted.setAdmissionID(LdapUtils.stringValue((Attribute)attrs.get("dcmAdmissionID"), null));
                upsOnUPSCompleted.setIssuerOfAdmissionID(LdapUtils.issuerValue((Attribute)attrs.get("dicomIssuerOfAdmissionID")));
                upsOnUPSCompleted.setIncludeStudyInstanceUID(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSIncludeStudyInstanceUID"), (boolean)false));
                upsOnUPSCompleted.setIncludeReferencedRequest(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSIncludeReferencedRequest"), (boolean)false));
                upsOnUPSCompleted.setXSLTStylesheetURI(LdapUtils.stringValue((Attribute)attrs.get("dcmURI"), null));
                upsOnUPSCompleted.setNoKeywords(LdapUtils.booleanValue((Attribute)attrs.get("dcmNoKeywords"), (boolean)false));
                upsOnUPSCompletedList.add(upsOnUPSCompleted);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUPSProcessingRules(ArchiveDeviceExtension arcDev, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmUPSProcessingRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UPSProcessingRule upsProcessingRule = new UPSProcessingRule(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSProcessingRuleID"), null));
                upsProcessingRule.setAETitle(LdapUtils.stringValue((Attribute)attrs.get("dicomAETitle"), null));
                upsProcessingRule.setUPSProcessorURI(URI.create(StringUtils.replaceSystemProperties((String)LdapUtils.stringValue((Attribute)attrs.get("dcmURI"), null))));
                upsProcessingRule.setProperties(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0]));
                upsProcessingRule.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                upsProcessingRule.setMaxThreads(LdapUtils.intValue((Attribute)attrs.get("dcmMaxThreads"), (int)1));
                upsProcessingRule.setInputReadinessState((InputReadinessState)LdapUtils.enumValue(InputReadinessState.class, (Attribute)attrs.get("dcmUPSInputReadinessState"), (Enum)InputReadinessState.READY));
                upsProcessingRule.setUPSPriority((UPSPriority)LdapUtils.enumValue(UPSPriority.class, (Attribute)attrs.get("dcmUPSPriority"), null));
                upsProcessingRule.setProcedureStepLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSLabel"), null));
                upsProcessingRule.setWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSWorklistLabel"), null));
                upsProcessingRule.setScheduledWorkitemCode(LdapUtils.codeValue((Attribute)attrs.get("dcmUPSScheduledWorkitemCode")));
                upsProcessingRule.setScheduledStationName(LdapUtils.codeValue((Attribute)attrs.get("dcmUPSScheduledStationNameCode")));
                upsProcessingRule.setScheduledStationClass(LdapUtils.codeValue((Attribute)attrs.get("dcmUPSScheduledStationClassCode")));
                upsProcessingRule.setScheduledStationLocation(LdapUtils.codeValue((Attribute)attrs.get("dcmUPSScheduledStationLocationCode")));
                upsProcessingRule.setPerformedWorkitemCode((Code)StringUtils.maskNull((Object)LdapUtils.codeValue((Attribute)attrs.get("dcmUPSPerformedWorkitemCode")), (Object)UPSProcessingRule.DEFAULT_PERFORMED_WORKITEM_CODE));
                upsProcessingRule.setPerformedStationNameCode((Code)StringUtils.maskNull((Object)LdapUtils.codeValue((Attribute)attrs.get("dcmUPSPerformedStationNameCode")), (Object)UPSProcessingRule.DEFAULT_PERFORMED_STATION_NAME_CODE));
                upsProcessingRule.setRescheduleDiscontinuationReasonCodes(LdapUtils.codeArray((Attribute)attrs.get("dcmRescheduleDiscontinuationReasonCode")));
                upsProcessingRule.setIgnoreDiscontinuationReasonCodes(LdapUtils.codeArray((Attribute)attrs.get("dcmIgnoreDiscontinuationReasonCode")));
                upsProcessingRule.setMaxRetries(LdapUtils.intValue((Attribute)attrs.get("dcmMaxRetries"), (int)0));
                upsProcessingRule.setRetryDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmRetryDelay"), UPSProcessingRule.DEFAULT_RETRY_DELAY));
                upsProcessingRule.setMaxRetryDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmMaxRetryDelay"), null));
                upsProcessingRule.setRetryDelayMultiplier(LdapUtils.intValue((Attribute)attrs.get("dcmRetryDelayMultiplier"), (int)100));
                upsProcessingRule.setUpsTemplateID(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSTemplateID"), null));
                arcDev.addUPSProcessingRule(upsProcessingRule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadUPSOnHL7List(Collection<UPSOnHL7> upsOnHL7List, String parentDN, LdapDicomConfiguration config) throws NamingException {
        NamingEnumeration ne = config.search(parentDN, "(objectclass=hl7UPSOnHL7)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                UPSOnHL7 upsOnHL7 = new UPSOnHL7(LdapUtils.stringValue((Attribute)attrs.get("hl7UPSOnHL7ID"), null));
                upsOnHL7.setProcedureStepLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSLabel"), null));
                upsOnHL7.setUPSPriority((UPSPriority)LdapUtils.enumValue(UPSPriority.class, (Attribute)attrs.get("dcmUPSPriority"), (Enum)UPSPriority.MEDIUM));
                upsOnHL7.setInputReadinessState((InputReadinessState)LdapUtils.enumValue(InputReadinessState.class, (Attribute)attrs.get("dcmUPSInputReadinessState"), (Enum)InputReadinessState.READY));
                upsOnHL7.setStartDateTimeDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmUPSStartDateTimeDelay"), null));
                upsOnHL7.setCompletionDateTimeDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmUPSCompletionDateTimeDelay"), null));
                upsOnHL7.setWorklistLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSWorklistLabel"), null));
                upsOnHL7.setInstanceUIDBasedOnName(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSInstanceUIDBasedOnName"), null));
                upsOnHL7.setScheduledStationNames(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationNameCode")));
                upsOnHL7.setDestinationAE(LdapUtils.stringValue((Attribute)attrs.get("dcmDestinationAE"), null));
                upsOnHL7.setScheduledWorkitemCode(LdapUtils.codeValue((Attribute)attrs.get("dcmUPSScheduledWorkitemCode")));
                upsOnHL7.setScheduledStationClasses(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationClassCode")));
                upsOnHL7.setScheduledStationLocations(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledStationLocationCode")));
                upsOnHL7.setScheduledHumanPerformers(LdapUtils.codeArray((Attribute)attrs.get("dcmUPSScheduledHumanPerformerCode")));
                upsOnHL7.setScheduledHumanPerformerName(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSScheduledHumanPerformerName"), null));
                upsOnHL7.setScheduledHumanPerformerOrganization(LdapUtils.stringValue((Attribute)attrs.get("dcmUPSScheduledHumanPerformerOrganization"), null));
                upsOnHL7.setIncludeStudyInstanceUID(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSIncludeStudyInstanceUID"), (boolean)false));
                upsOnHL7.setIncludeReferencedRequest(LdapUtils.booleanValue((Attribute)attrs.get("dcmUPSIncludeReferencedRequest"), (boolean)false));
                upsOnHL7.setStudyInstanceUID(LdapUtils.stringValue((Attribute)attrs.get("dcmStudyInstanceUID"), null));
                upsOnHL7.setAdmissionID(LdapUtils.stringValue((Attribute)attrs.get("dcmAdmissionID"), null));
                upsOnHL7.setIssuerOfAdmissionID(LdapUtils.issuerValue((Attribute)attrs.get("dicomIssuerOfAdmissionID")));
                upsOnHL7.setAccessionNumber(LdapUtils.stringValue((Attribute)attrs.get("dcmAccessionNumber"), null));
                upsOnHL7.setIssuerOfAccessionNumber(LdapUtils.issuerValue((Attribute)attrs.get("dicomIssuerOfAccessionNumber")));
                upsOnHL7.setRequestedProcedureID(LdapUtils.stringValue((Attribute)attrs.get("dcmRequestedProcedureID"), null));
                upsOnHL7.setRequestedProcedureDescription(LdapUtils.stringValue((Attribute)attrs.get("dcmRequestedProcedureDescription"), null));
                upsOnHL7.setRequestingPhysician(LdapUtils.stringValue((Attribute)attrs.get("dcmRequestingPhysician"), null));
                upsOnHL7.setRequestingService(LdapUtils.stringValue((Attribute)attrs.get("dcmRequestingService"), null));
                upsOnHL7.setXSLTStylesheetURI(LdapUtils.stringValue((Attribute)attrs.get("dcmURI"), null));
                upsOnHL7.setConditions(new HL7Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                upsOnHL7.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                upsOnHL7List.add(upsOnHL7);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private void storePrefetchRules(ConfigurationChanges diffs, Collection<ExportPriorsRule> exportPriorsRules, String parentDN) throws NamingException {
        for (ExportPriorsRule rule : exportPriorsRules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, ExportPriorsRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmExportPriorsRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExporterID", (Object[])rule.getExporterIDs(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEntitySelector", (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDuration", (Object)rule.getSuppressDuplicateExportInterval(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExportReoccurredInstances", (Object)rule.getExportReoccurredInstances(), (Object)ExportReoccurredInstances.REPLACE);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrefetchRules(Collection<ExportPriorsRule> exportPriorsRules, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmExportPriorsRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                ExportPriorsRule rule = new ExportPriorsRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                rule.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                rule.setExporterIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmExporterID"), (String[])new String[0]));
                rule.setEntitySelectors(EntitySelector.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmEntitySelector"), (String[])new String[0])));
                rule.setSuppressDuplicateExportInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmDuration"), null));
                rule.setExportReoccurredInstances((ExportReoccurredInstances)LdapUtils.enumValue(ExportReoccurredInstances.class, (Attribute)attrs.get("dcmExportReoccurredInstances"), (Enum)ExportReoccurredInstances.REPLACE));
                exportPriorsRules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    static void storeHL7ExportRules(ConfigurationChanges diffs, Collection<HL7ExportRule> prefetchRules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        for (HL7ExportRule rule : prefetchRules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            config.createSubcontext(dn, LdapArchiveConfiguration.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, HL7ExportRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "hl7ExportRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExporterID", (Object[])rule.getExporterIDs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmNullifyIssuerOfPatientID", (Object)rule.getIgnoreAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIssuerOfPatientID", (Object[])rule.getAssigningAuthorityOfPatientIDs(), (Object[])new Issuer[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPrefetchForIssuerOfPatientID", (Object)rule.getPrefetchForAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEntitySelector", (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDuration", (Object)rule.getSuppressDuplicateExportInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHistorySize", (int)rule.getSuppressDuplicateHistorySize(), (int)100);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadHL7ExportRules(Collection<HL7ExportRule> prefetchRules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        NamingEnumeration ne = config.search(parentDN, "(objectclass=hl7ExportRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                HL7ExportRule rule = new HL7ExportRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setConditions(new HL7Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                rule.setExporterIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmExporterID"), (String[])new String[0]));
                rule.setIgnoreAssigningAuthorityOfPatientID((NullifyIssuer)LdapUtils.enumValue(NullifyIssuer.class, (Attribute)attrs.get("dcmNullifyIssuerOfPatientID"), null));
                rule.setAssigningAuthorityOfPatientIDs(LdapArchiveConfiguration.toIssuers(LdapUtils.stringArray((Attribute)attrs.get("dcmIssuerOfPatientID"), (String[])new String[0])));
                rule.setPrefetchForAssigningAuthorityOfPatientID(LdapArchiveConfiguration.toIssuer(LdapUtils.stringValue((Attribute)attrs.get("dcmPrefetchForIssuerOfPatientID"), null)));
                rule.setEntitySelectors(EntitySelector.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmEntitySelector"), (String[])new String[0])));
                rule.setSuppressDuplicateExportInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmDuration"), null));
                rule.setSuppressDuplicateHistorySize(LdapUtils.intValue((Attribute)attrs.get("dcmHistorySize"), (int)100));
                prefetchRules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    static void storeHL7PrefetchRules(ConfigurationChanges diffs, Collection<HL7PrefetchRule> prefetchRules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        for (HL7PrefetchRule rule : prefetchRules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            config.createSubcontext(dn, LdapArchiveConfiguration.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, HL7PrefetchRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "hl7PrefetchRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmQueueName", (Object)rule.getQueueName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomAETitle", (Object)rule.getAETitle(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPrefetchCFindSCP", (Object)rule.getPrefetchCFindSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPrefetchCMoveSCP", (Object)rule.getPrefetchCMoveSCP(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPrefetchCStoreSCP", (Object[])rule.getPrefetchCStoreSCPs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDestinationCFindSCP", (Object)rule.getDestinationCFindSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDeviceName", (Object)rule.getPrefetchDeviceName(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSchedule", (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmNullifyIssuerOfPatientID", (Object)rule.getIgnoreAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIssuerOfPatientID", (Object[])rule.getAssigningAuthorityOfPatientIDs(), (Object[])new Issuer[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPrefetchForIssuerOfPatientID", (Object)rule.getPrefetchForAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmEntitySelector", (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDuration", (Object)rule.getSuppressDuplicateRetrieveInterval(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHistorySize", (int)rule.getSuppressDuplicateHistorySize(), (int)100);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPrefetchDateTimeField", (Object)rule.getPrefetchDateTimeField(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPrefetchInAdvance", (Object)rule.getPrefetchInAdvance(), null);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadHL7PrefetchRules(Collection<HL7PrefetchRule> prefetchRules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        NamingEnumeration ne = config.search(parentDN, "(objectclass=hl7PrefetchRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                HL7PrefetchRule rule = new HL7PrefetchRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setQueueName(LdapUtils.stringValue((Attribute)attrs.get("dcmQueueName"), null));
                rule.setAETitle(LdapUtils.stringValue((Attribute)attrs.get("dicomAETitle"), null));
                rule.setPrefetchCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmPrefetchCFindSCP"), null));
                rule.setPrefetchCMoveSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmPrefetchCMoveSCP"), null));
                rule.setPrefetchCStoreSCPs(LdapUtils.stringArray((Attribute)attrs.get("dcmPrefetchCStoreSCP"), (String[])new String[0]));
                rule.setDestinationCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmDestinationCFindSCP"), null));
                rule.setPrefetchDeviceName(LdapUtils.stringValue((Attribute)attrs.get("dicomDeviceName"), null));
                rule.setConditions(new HL7Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                rule.setSchedules(ScheduleExpression.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmSchedule"), (String[])new String[0])));
                rule.setIgnoreAssigningAuthorityOfPatientID((NullifyIssuer)LdapUtils.enumValue(NullifyIssuer.class, (Attribute)attrs.get("dcmNullifyIssuerOfPatientID"), null));
                rule.setAssigningAuthorityOfPatientIDs(LdapArchiveConfiguration.toIssuers(LdapUtils.stringArray((Attribute)attrs.get("dcmIssuerOfPatientID"), (String[])new String[0])));
                rule.setPrefetchForAssigningAuthorityOfPatientID(LdapArchiveConfiguration.toIssuer(LdapUtils.stringValue((Attribute)attrs.get("dcmPrefetchForIssuerOfPatientID"), null)));
                rule.setEntitySelectors(EntitySelector.valuesOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmEntitySelector"), (String[])new String[0])));
                rule.setSuppressDuplicateRetrieveInterval(LdapArchiveConfiguration.toDuration(attrs.get("dcmDuration"), null));
                rule.setSuppressDuplicateHistorySize(LdapUtils.intValue((Attribute)attrs.get("dcmHistorySize"), (int)100));
                rule.setPrefetchDateTimeField(LdapUtils.stringValue((Attribute)attrs.get("dcmPrefetchDateTimeField"), null));
                rule.setPrefetchInAdvance(LdapArchiveConfiguration.toDuration(attrs.get("dcmPrefetchInAdvance"), null));
                prefetchRules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private static URI toURI(Attribute attr) throws NamingException {
        return attr != null ? URI.create((String)attr.get()) : null;
    }

    private static Duration toDuration(Attribute attr, Duration defValue) throws NamingException {
        return attr != null ? Duration.valueOf((String)((String)attr.get())) : defValue;
    }

    private static Period toPeriod(Attribute attr) throws NamingException {
        return attr != null ? Period.parse((String)attr.get()) : null;
    }

    private static Pattern toPattern(Attribute attr) throws NamingException {
        return attr != null ? Pattern.compile((String)attr.get()) : null;
    }

    private void mergeExportRules(ConfigurationChanges diffs, Collection<ExportRule> prevRules, Collection<ExportRule> rules, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (ExportRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (this.findExportRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (ExportRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            ExportRule prevRule = this.findExportRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeMPPSForwardRules(ConfigurationChanges diffs, Collection<MPPSForwardRule> prevRules, Collection<MPPSForwardRule> rules, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (MPPSForwardRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (this.findMPPSForwardRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (MPPSForwardRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            MPPSForwardRule prevRule = this.findMPPSForwardRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeMWLIdleTimeouts(ConfigurationChanges diffs, Collection<MWLIdleTimeout> prevMWLIdleTimeouts, Collection<MWLIdleTimeout> mwlIdleTimeouts, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (MWLIdleTimeout prevMWLIdleTimeout : prevMWLIdleTimeouts) {
            cn = prevMWLIdleTimeout.getCommonName();
            if (this.findMWLIdleTimeoutByCN(mwlIdleTimeouts, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (MWLIdleTimeout mwlIdleTimeout : mwlIdleTimeouts) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = mwlIdleTimeout.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            MWLIdleTimeout prevMWLIdleTimeout = this.findMWLIdleTimeoutByCN(prevMWLIdleTimeouts, cn);
            if (prevMWLIdleTimeout == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), mwlIdleTimeout, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevMWLIdleTimeout, mwlIdleTimeout, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeMWLImports(ConfigurationChanges diffs, Collection<MWLImport> prevMWLImports, Collection<MWLImport> mwlImports, String parentDN) throws NamingException {
        String dn;
        String mwlImportID;
        for (MWLImport prevMWLImport : prevMWLImports) {
            mwlImportID = prevMWLImport.getMWLImportID();
            if (this.findMWLImportByID(mwlImports, mwlImportID) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmMWLImportID", (String)mwlImportID, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (MWLImport mwlImport : mwlImports) {
            ConfigurationChanges.ModifiedObject ldapObj;
            mwlImportID = mwlImport.getMWLImportID();
            dn = LdapUtils.dnOf((String)"dcmMWLImportID", (String)mwlImportID, (String)parentDN);
            MWLImport prevMWLImport = this.findMWLImportByID(prevMWLImports, mwlImportID);
            if (prevMWLImport == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), mwlImport, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevMWLImport, mwlImport, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeUPSOnStoreList(ConfigurationChanges diffs, Collection<UPSOnStore> prevUPSOnStoreList, Collection<UPSOnStore> upsOnStoreList, String parentDN) throws NamingException {
        String dn;
        String id;
        for (UPSOnStore prevUPSOnStore : prevUPSOnStoreList) {
            id = prevUPSOnStore.getUPSOnStoreID();
            if (this.findUPSOnStoreByID(upsOnStoreList, id) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmUPSOnStoreID", (String)id, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UPSOnStore rule : upsOnStoreList) {
            ConfigurationChanges.ModifiedObject ldapObj;
            id = rule.getUPSOnStoreID();
            dn = LdapUtils.dnOf((String)"dcmUPSOnStoreID", (String)id, (String)parentDN);
            UPSOnStore prevUPSOnStore = this.findUPSOnStoreByID(prevUPSOnStoreList, id);
            if (prevUPSOnStore == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUPSOnStore, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeUPSOnUPSCompletedList(ConfigurationChanges diffs, Collection<UPSOnUPSCompleted> prevUPSOnUPSCompletedList, Collection<UPSOnUPSCompleted> upsOnUPSCompletedList, String parentDN) throws NamingException {
        String dn;
        String id;
        for (UPSOnUPSCompleted prevUPSOnUPSCompleted : prevUPSOnUPSCompletedList) {
            id = prevUPSOnUPSCompleted.getUPSonUPSCompletedID();
            if (this.findUPSOnUPSCompletedByID(upsOnUPSCompletedList, id) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmUPSOnUPSCompletedID", (String)id, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UPSOnUPSCompleted rule : upsOnUPSCompletedList) {
            ConfigurationChanges.ModifiedObject ldapObj;
            id = rule.getUPSonUPSCompletedID();
            dn = LdapUtils.dnOf((String)"dcmUPSOnUPSCompletedID", (String)id, (String)parentDN);
            UPSOnUPSCompleted prevUPSOnUPSCompleted = this.findUPSOnUPSCompletedByID(prevUPSOnUPSCompletedList, id);
            if (prevUPSOnUPSCompleted == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUPSOnUPSCompleted, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeUPSProcessingRules(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        String dn;
        String id;
        for (UPSProcessingRule prevUPSProcessingRule : prev.listUPSProcessingRules()) {
            id = prevUPSProcessingRule.getUPSProcessingRuleID();
            if (this.findUPSProcessingRuleByID(arcDev.listUPSProcessingRules(), id) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmUPSProcessingRuleID", (String)id, (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UPSProcessingRule upsProcessingRule : arcDev.listUPSProcessingRules()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            id = upsProcessingRule.getUPSProcessingRuleID();
            dn = LdapUtils.dnOf((String)"dcmUPSProcessingRuleID", (String)id, (String)deviceDN);
            UPSProcessingRule prevUPSProcessingRule = this.findUPSProcessingRuleByID(prev.listUPSProcessingRules(), id);
            if (prevUPSProcessingRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), upsProcessingRule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevUPSProcessingRule, upsProcessingRule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    static void mergeUPSOnHL7List(ConfigurationChanges diffs, Collection<UPSOnHL7> prevUPSOnHL7List, Collection<UPSOnHL7> upsOnHL7List, String parentDN, LdapDicomConfiguration config) throws NamingException {
        String dn;
        String id;
        for (UPSOnHL7 prevUPSOnHL7 : prevUPSOnHL7List) {
            id = prevUPSOnHL7.getUPSOnHL7ID();
            if (LdapArchiveConfiguration.findUPSOnHL7ByID(upsOnHL7List, id) != null) continue;
            dn = LdapUtils.dnOf((String)"hl7UPSOnHL7ID", (String)id, (String)parentDN);
            config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (UPSOnHL7 rule : upsOnHL7List) {
            ConfigurationChanges.ModifiedObject ldapObj;
            id = rule.getUPSOnHL7ID();
            dn = LdapUtils.dnOf((String)"hl7UPSOnHL7ID", (String)id, (String)parentDN);
            UPSOnHL7 prevUPSOnHL7 = LdapArchiveConfiguration.findUPSOnHL7ByID(prevUPSOnHL7List, id);
            if (prevUPSOnHL7 == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                config.createSubcontext(dn, LdapArchiveConfiguration.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            config.modifyAttributes(dn, LdapArchiveConfiguration.storeDiffs(ldapObj, prevUPSOnHL7, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ExportRule prev, ExportRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)rule.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExporterID", (Object[])prev.getExporterIDs(), (Object[])rule.getExporterIDs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEntity", (Object)prev.getEntity(), (Object)rule.getEntity(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDuration", (Object)prev.getExportDelay(), (Object)rule.getExportDelay(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExportPreviousEntity", (boolean)prev.isExportPreviousEntity(), (boolean)rule.isExportPreviousEntity(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExportReoccurredInstances", (Object)prev.getExportReoccurredInstances(), (Object)rule.getExportReoccurredInstances(), (Object)ExportReoccurredInstances.REPLACE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDeviceName", (Object)prev.getExporterDeviceName(), (Object)rule.getExporterDeviceName(), null);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, MPPSForwardRule prev, MPPSForwardRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)rule.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFwdMppsDestination", (Object[])prev.getDestinations(), (Object[])rule.getDestinations(), (Object[])new String[0]);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, MWLIdleTimeout prev, MWLIdleTimeout mwlIdleTimeout, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomAETitle", (Object)prev.getAETitle(), (Object)mwlIdleTimeout.getAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLStatusOnIdle", (Object)prev.getStatusOnIdle(), (Object)mwlIdleTimeout.getStatusOnIdle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDuration", (Object)prev.getIdleTimeout(), (Object)mwlIdleTimeout.getIdleTimeout(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAETitle", (Object[])prev.getScheduledStationAETitles(), (Object[])mwlIdleTimeout.getScheduledStationAETitles(), (Object[])new String[0]);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, MWLImport prev, MWLImport mwlImport, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomAETitle", (Object)prev.getAETitle(), (Object)mwlImport.getAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeMWLSCP", (Object)prev.getMWLSCP(), (Object)mwlImport.getMWLSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLWorklistLabel", (Object)prev.getMWLWorklistLabel(), (Object)mwlImport.getMWLWorklistLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDuration", (Object)prev.getPrefetchBefore(), (Object)mwlImport.getPrefetchBefore(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLImportNotOlder", (Object)prev.getNotOlderThan(), (Object)mwlImport.getNotOlderThan(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLImportFilterBySCU", (boolean)prev.isFilterBySCU(), (boolean)mwlImport.isFilterBySCU(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLImportDeleteNotFound", (boolean)prev.isDeleteNotFound(), (boolean)mwlImport.isDeleteNotFound(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIncludeField", (Object[])prev.getIncludeFields(), (Object[])mwlImport.getIncludeFields(), (Object[])new String[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getFilter(), (Map)mwlImport.getFilter());
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UPSOnStore prev, UPSOnStore upsOnStore, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSLabel", (Object)prev.getProcedureStepLabel(), (Object)upsOnStore.getProcedureStepLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSPriority", (Object)prev.getUPSPriority(), (Object)upsOnStore.getUPSPriority(), (Object)UPSPriority.MEDIUM);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSInputReadinessState", (Object)prev.getInputReadinessState(), (Object)upsOnStore.getInputReadinessState(), (Object)InputReadinessState.READY);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSStartDateTimeDelay", (Object)prev.getStartDateTimeDelay(), (Object)upsOnStore.getStartDateTimeDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSCompletionDateTimeDelay", (Object)prev.getCompletionDateTimeDelay(), (Object)upsOnStore.getCompletionDateTimeDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSWorklistLabel", (Object)prev.getWorklistLabel(), (Object)upsOnStore.getWorklistLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSInstanceUIDBasedOnName", (Object)prev.getInstanceUIDBasedOnName(), (Object)upsOnStore.getInstanceUIDBasedOnName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludeInputInformation", (Object)prev.getIncludeInputInformation(), (Object)upsOnStore.getIncludeInputInformation(), (Object)UPSOnStore.IncludeInputInformation.APPEND);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludePatient", (boolean)prev.isIncludePatient(), (boolean)upsOnStore.isIncludePatient(), (boolean)true);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludeStudyInstanceUID", (boolean)prev.isIncludeStudyInstanceUID(), (boolean)upsOnStore.isIncludeStudyInstanceUID(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludeReferencedRequest", (boolean)prev.isIncludeReferencedRequest(), (boolean)upsOnStore.isIncludeReferencedRequest(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDestinationAE", (Object)prev.getDestinationAE(), (Object)upsOnStore.getDestinationAE(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEntity", (Object)prev.getScopeOfAccumulation(), (Object)upsOnStore.getScopeOfAccumulation(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledWorkitemCode", (Object)prev.getScheduledWorkitemCode(), (Object)upsOnStore.getScheduledWorkitemCode(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationNameCode", (Object[])prev.getScheduledStationNames(), (Object[])upsOnStore.getScheduledStationNames(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationClassCode", (Object[])prev.getScheduledStationClasses(), (Object[])upsOnStore.getScheduledStationClasses(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationLocationCode", (Object[])prev.getScheduledStationLocations(), (Object[])upsOnStore.getScheduledStationLocations(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerCode", (Object[])prev.getScheduledHumanPerformers(), (Object[])upsOnStore.getScheduledHumanPerformers(), (Object[])new Code[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerName", (Object)prev.getScheduledHumanPerformerName(), (Object)upsOnStore.getScheduledHumanPerformerName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerOrganization", (Object)prev.getScheduledHumanPerformerOrganization(), (Object)upsOnStore.getScheduledHumanPerformerOrganization(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAdmissionID", (Object)prev.getAdmissionID(), (Object)upsOnStore.getAdmissionID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomIssuerOfAdmissionID", (Object)prev.getIssuerOfAdmissionID(), (Object)upsOnStore.getIssuerOfAdmissionID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAccessionNumber", (Object)prev.getAccessionNumber(), (Object)upsOnStore.getAccessionNumber(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomIssuerOfAccessionNumber", (Object)prev.getIssuerOfAccessionNumber(), (Object)upsOnStore.getIssuerOfAccessionNumber(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequestedProcedureID", (Object)prev.getRequestedProcedureID(), (Object)upsOnStore.getRequestedProcedureID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequestedProcedureDescription", (Object)prev.getRequestedProcedureDescription(), (Object)upsOnStore.getRequestedProcedureDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequestingPhysician", (Object)prev.getRequestingPhysician(), (Object)upsOnStore.getRequestingPhysician(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequestingService", (Object)prev.getRequestingService(), (Object)upsOnStore.getRequestingService(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getXSLTStylesheetURI(), (Object)upsOnStore.getXSLTStylesheetURI(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmNoKeywords", (boolean)prev.isNoKeywords(), (boolean)upsOnStore.isNoKeywords(), (boolean)false);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)upsOnStore.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])upsOnStore.getSchedules(), (Object[])new ScheduleExpression[0]);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UPSOnUPSCompleted prev, UPSOnUPSCompleted upsOnUPSCompleted, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)upsOnUPSCompleted.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequiresOtherUPSCompleted", (Object[])prev.getRequiresOtherUPSCompleted(), (Object[])upsOnUPSCompleted.getRequiresOtherUPSCompleted(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSLabel", (Object)prev.getProcedureStepLabel(), (Object)upsOnUPSCompleted.getProcedureStepLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSWorklistLabel", (Object)prev.getWorklistLabel(), (Object)upsOnUPSCompleted.getWorklistLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSInstanceUIDBasedOnName", (Object)prev.getInstanceUIDBasedOnName(), (Object)upsOnUPSCompleted.getInstanceUIDBasedOnName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludeInputInformation", (Object)prev.getIncludeInputInformation(), (Object)upsOnUPSCompleted.getIncludeInputInformation(), (Object)UPSOnUPSCompleted.IncludeInputInformation.COPY_OUTPUT);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludePatient", (boolean)prev.isIncludePatient(), (boolean)upsOnUPSCompleted.isIncludePatient(), (boolean)true);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSPriority", (Object)prev.getUPSPriority(), (Object)upsOnUPSCompleted.getUPSPriority(), (Object)UPSPriority.MEDIUM);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSInputReadinessState", (Object)prev.getInputReadinessState(), (Object)upsOnUPSCompleted.getInputReadinessState(), (Object)InputReadinessState.READY);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSStartDateTimeDelay", (Object)prev.getStartDateTimeDelay(), (Object)upsOnUPSCompleted.getStartDateTimeDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSCompletionDateTimeDelay", (Object)prev.getCompletionDateTimeDelay(), (Object)upsOnUPSCompleted.getCompletionDateTimeDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDestinationAE", (Object)prev.getDestinationAE(), (Object)upsOnUPSCompleted.getDestinationAE(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEntity", (Object)prev.getScopeOfAccumulation(), (Object)upsOnUPSCompleted.getScopeOfAccumulation(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledWorkitemCode", (Object)prev.getScheduledWorkitemCode(), (Object)upsOnUPSCompleted.getScheduledWorkitemCode(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationNameCode", (Object[])prev.getScheduledStationNames(), (Object[])upsOnUPSCompleted.getScheduledStationNames(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationClassCode", (Object[])prev.getScheduledStationClasses(), (Object[])upsOnUPSCompleted.getScheduledStationClasses(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationLocationCode", (Object[])prev.getScheduledStationLocations(), (Object[])upsOnUPSCompleted.getScheduledStationLocations(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerCode", (Object[])prev.getScheduledHumanPerformers(), (Object[])upsOnUPSCompleted.getScheduledHumanPerformers(), (Object[])new Code[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerName", (Object)prev.getScheduledHumanPerformerName(), (Object)upsOnUPSCompleted.getScheduledHumanPerformerName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerOrganization", (Object)prev.getScheduledHumanPerformerOrganization(), (Object)upsOnUPSCompleted.getScheduledHumanPerformerOrganization(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAdmissionID", (Object)prev.getAdmissionID(), (Object)upsOnUPSCompleted.getAdmissionID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomIssuerOfAdmissionID", (Object)prev.getIssuerOfAdmissionID(), (Object)upsOnUPSCompleted.getIssuerOfAdmissionID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludeStudyInstanceUID", (boolean)prev.isIncludeStudyInstanceUID(), (boolean)upsOnUPSCompleted.isIncludeStudyInstanceUID(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludeReferencedRequest", (boolean)prev.isIncludeReferencedRequest(), (boolean)upsOnUPSCompleted.isIncludeReferencedRequest(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getXSLTStylesheetURI(), (Object)upsOnUPSCompleted.getXSLTStylesheetURI(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmNoKeywords", (boolean)prev.isNoKeywords(), (boolean)upsOnUPSCompleted.isNoKeywords(), (boolean)false);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UPSProcessingRule prev, UPSProcessingRule upsProcessingRule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomAETitle", (Object)prev.getAETitle(), (Object)upsProcessingRule.getAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getUPSProcessorURI(), (Object)upsProcessingRule.getUPSProcessorURI(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getProperties(), (Map)upsProcessingRule.getProperties());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])upsProcessingRule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSeriesMetadataThreads", (int)prev.getMaxThreads(), (int)upsProcessingRule.getMaxThreads(), (int)1);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSInputReadinessState", (Object)prev.getInputReadinessState(), (Object)upsProcessingRule.getInputReadinessState(), (Object)InputReadinessState.READY);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSPriority", (Object)prev.getUPSPriority(), (Object)upsProcessingRule.getUPSPriority(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSLabel", (Object)prev.getProcedureStepLabel(), (Object)upsProcessingRule.getProcedureStepLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSWorklistLabel", (Object)prev.getWorklistLabel(), (Object)upsProcessingRule.getWorklistLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledWorkitemCode", (Object)prev.getScheduledWorkitemCode(), (Object)upsProcessingRule.getScheduledWorkitemCode(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationNameCode", (Object)prev.getScheduledStationName(), (Object)upsProcessingRule.getScheduledStationName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationClassCode", (Object)prev.getScheduledStationClass(), (Object)upsProcessingRule.getScheduledStationClass(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationLocationCode", (Object)prev.getScheduledStationLocation(), (Object)upsProcessingRule.getScheduledStationLocation(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSPerformedWorkitemCode", (Object)prev.getPerformedWorkitemCode(), (Object)upsProcessingRule.getPerformedWorkitemCode(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSPerformedStationNameCode", (Object)prev.getPerformedStationNameCode(), (Object)upsProcessingRule.getPerformedStationNameCode(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRescheduleDiscontinuationReasonCode", (Object[])prev.getRescheduleDiscontinuationReasonCodes(), (Object[])upsProcessingRule.getRescheduleDiscontinuationReasonCodes(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIgnoreDiscontinuationReasonCode", (Object[])prev.getIgnoreDiscontinuationReasonCodes(), (Object[])upsProcessingRule.getIgnoreDiscontinuationReasonCodes(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMaxRetries", (int)prev.getMaxRetries(), (int)upsProcessingRule.getMaxRetries(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetryDelay", (Object)prev.getRetryDelay(), (Object)upsProcessingRule.getRetryDelay(), (Object)UPSProcessingRule.DEFAULT_RETRY_DELAY);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMaxRetryDelay", (Object)prev.getMaxRetryDelay(), (Object)upsProcessingRule.getMaxRetryDelay(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetryDelayMultiplier", (int)prev.getRetryDelayMultiplier(), (int)upsProcessingRule.getRetryDelayMultiplier(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSTemplateID", (Object)prev.getUpsTemplateID(), (Object)upsProcessingRule.getUpsTemplateID(), null);
        return mods;
    }

    private static List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, UPSOnHL7 prev, UPSOnHL7 upsOnHL7, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSLabel", (Object)prev.getProcedureStepLabel(), (Object)upsOnHL7.getProcedureStepLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSPriority", (Object)prev.getUPSPriority(), (Object)upsOnHL7.getUPSPriority(), (Object)UPSPriority.MEDIUM);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSInputReadinessState", (Object)prev.getInputReadinessState(), (Object)upsOnHL7.getInputReadinessState(), (Object)InputReadinessState.READY);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSStartDateTimeDelay", (Object)prev.getStartDateTimeDelay(), (Object)upsOnHL7.getStartDateTimeDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSCompletionDateTimeDelay", (Object)prev.getCompletionDateTimeDelay(), (Object)upsOnHL7.getCompletionDateTimeDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSWorklistLabel", (Object)prev.getWorklistLabel(), (Object)upsOnHL7.getWorklistLabel(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSInstanceUIDBasedOnName", (Object)prev.getInstanceUIDBasedOnName(), (Object)upsOnHL7.getInstanceUIDBasedOnName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDestinationAE", (Object)prev.getDestinationAE(), (Object)upsOnHL7.getDestinationAE(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledWorkitemCode", (Object)prev.getScheduledWorkitemCode(), (Object)upsOnHL7.getScheduledWorkitemCode(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationNameCode", (Object[])prev.getScheduledStationNames(), (Object[])upsOnHL7.getScheduledStationNames(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationClassCode", (Object[])prev.getScheduledStationClasses(), (Object[])upsOnHL7.getScheduledStationClasses(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledStationLocationCode", (Object[])prev.getScheduledStationLocations(), (Object[])upsOnHL7.getScheduledStationLocations(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerCode", (Object[])prev.getScheduledHumanPerformers(), (Object[])upsOnHL7.getScheduledHumanPerformers(), (Object[])new Code[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerName", (Object)prev.getScheduledHumanPerformerName(), (Object)upsOnHL7.getScheduledHumanPerformerName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSScheduledHumanPerformerOrganization", (Object)prev.getScheduledHumanPerformerOrganization(), (Object)upsOnHL7.getScheduledHumanPerformerOrganization(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludeStudyInstanceUID", (boolean)prev.isIncludeStudyInstanceUID(), (boolean)upsOnHL7.isIncludeStudyInstanceUID(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUPSIncludeReferencedRequest", (boolean)prev.isIncludeReferencedRequest(), (boolean)upsOnHL7.isIncludeReferencedRequest(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStudyInstanceUID", (Object)prev.getStudyInstanceUID(), (Object)upsOnHL7.getStudyInstanceUID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAdmissionID", (Object)prev.getAdmissionID(), (Object)upsOnHL7.getAdmissionID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomIssuerOfAdmissionID", (Object)prev.getIssuerOfAdmissionID(), (Object)upsOnHL7.getIssuerOfAdmissionID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAccessionNumber", (Object)prev.getAccessionNumber(), (Object)upsOnHL7.getAccessionNumber(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomIssuerOfAccessionNumber", (Object)prev.getIssuerOfAccessionNumber(), (Object)upsOnHL7.getIssuerOfAccessionNumber(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequestedProcedureID", (Object)prev.getRequestedProcedureID(), (Object)upsOnHL7.getRequestedProcedureID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequestedProcedureDescription", (Object)prev.getRequestedProcedureDescription(), (Object)upsOnHL7.getRequestedProcedureDescription(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequestingPhysician", (Object)prev.getRequestingPhysician(), (Object)upsOnHL7.getRequestingPhysician(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRequestingService", (Object)prev.getRequestingService(), (Object)upsOnHL7.getRequestingService(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getXSLTStylesheetURI(), (Object)upsOnHL7.getXSLTStylesheetURI(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)upsOnHL7.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])upsOnHL7.getSchedules(), (Object[])new ScheduleExpression[0]);
        return mods;
    }

    private ExportRule findExportRuleByCN(Collection<ExportRule> rules, String cn) {
        for (ExportRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    private MPPSForwardRule findMPPSForwardRuleByCN(Collection<MPPSForwardRule> rules, String cn) {
        for (MPPSForwardRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    private MWLIdleTimeout findMWLIdleTimeoutByCN(Collection<MWLIdleTimeout> mwlIdleTimeouts, String cn) {
        for (MWLIdleTimeout mwlIdleTimeout : mwlIdleTimeouts) {
            if (!mwlIdleTimeout.getCommonName().equals(cn)) continue;
            return mwlIdleTimeout;
        }
        return null;
    }

    private MWLImport findMWLImportByID(Collection<MWLImport> mwlImports, String mwlImportID) {
        for (MWLImport mwlImport : mwlImports) {
            if (!mwlImport.getMWLImportID().equals(mwlImportID)) continue;
            return mwlImport;
        }
        return null;
    }

    private UPSOnStore findUPSOnStoreByID(Collection<UPSOnStore> upsOnStoreList, String id) {
        for (UPSOnStore upsOnStore : upsOnStoreList) {
            if (!upsOnStore.getUPSOnStoreID().equals(id)) continue;
            return upsOnStore;
        }
        return null;
    }

    private UPSOnUPSCompleted findUPSOnUPSCompletedByID(Collection<UPSOnUPSCompleted> upsOnUPSCompletedList, String id) {
        for (UPSOnUPSCompleted upsOnUPSCompleted : upsOnUPSCompletedList) {
            if (!upsOnUPSCompleted.getUPSonUPSCompletedID().equals(id)) continue;
            return upsOnUPSCompleted;
        }
        return null;
    }

    private UPSProcessingRule findUPSProcessingRuleByID(Collection<UPSProcessingRule> upsProcessingRules, String id) {
        for (UPSProcessingRule upsProcessingRule : upsProcessingRules) {
            if (!upsProcessingRule.getUPSProcessingRuleID().equals(id)) continue;
            return upsProcessingRule;
        }
        return null;
    }

    private static UPSOnHL7 findUPSOnHL7ByID(Collection<UPSOnHL7> upsOnHL7List, String id) {
        for (UPSOnHL7 upsOnHL7 : upsOnHL7List) {
            if (!upsOnHL7.getUPSOnHL7ID().equals(id)) continue;
            return upsOnHL7;
        }
        return null;
    }

    private void mergePrefetchRules(ConfigurationChanges diffs, Collection<ExportPriorsRule> prevRules, Collection<ExportPriorsRule> rules, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (ExportPriorsRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (this.findPrefetchRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (ExportPriorsRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            ExportPriorsRule prevRule = this.findPrefetchRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ExportPriorsRule prev, ExportPriorsRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)rule.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExporterID", (Object[])prev.getExporterIDs(), (Object[])rule.getExporterIDs(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEntitySelector", (Object[])prev.getEntitySelectors(), (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDuration", (Object)prev.getSuppressDuplicateExportInterval(), (Object)rule.getSuppressDuplicateExportInterval(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExportReoccurredInstances", (Object)prev.getExportReoccurredInstances(), (Object)rule.getExportReoccurredInstances(), (Object)ExportReoccurredInstances.REPLACE);
        return mods;
    }

    private ExportPriorsRule findPrefetchRuleByCN(Collection<ExportPriorsRule> rules, String cn) {
        for (ExportPriorsRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    static void mergeHL7ExportRules(ConfigurationChanges diffs, Collection<HL7ExportRule> prevRules, Collection<HL7ExportRule> rules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        String dn;
        String cn;
        for (HL7ExportRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (LdapArchiveConfiguration.findHL7ExportRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (HL7ExportRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            HL7ExportRule prevRule = LdapArchiveConfiguration.findHL7ExportRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                config.createSubcontext(dn, LdapArchiveConfiguration.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            config.modifyAttributes(dn, LdapArchiveConfiguration.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private static List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, HL7ExportRule prev, HL7ExportRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)rule.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExporterID", (Object[])prev.getExporterIDs(), (Object[])rule.getExporterIDs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmNullifyIssuerOfPatientID", (Object)prev.getIgnoreAssigningAuthorityOfPatientID(), (Object)rule.getIgnoreAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIssuerOfPatientID", (Object[])prev.getAssigningAuthorityOfPatientIDs(), (Object[])rule.getAssigningAuthorityOfPatientIDs(), (Object[])new Issuer[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPrefetchForIssuerOfPatientID", (Object)prev.getPrefetchForAssigningAuthorityOfPatientID(), (Object)rule.getPrefetchForAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEntitySelector", (Object[])prev.getEntitySelectors(), (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDuration", (Object)prev.getSuppressDuplicateExportInterval(), (Object)rule.getSuppressDuplicateExportInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHistorySize", (int)prev.getSuppressDuplicateHistorySize(), (int)rule.getSuppressDuplicateHistorySize(), (int)100);
        return mods;
    }

    private static HL7ExportRule findHL7ExportRuleByCN(Collection<HL7ExportRule> rules, String cn) {
        for (HL7ExportRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    static void mergeHL7PrefetchRules(ConfigurationChanges diffs, Collection<HL7PrefetchRule> prevRules, Collection<HL7PrefetchRule> rules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        String dn;
        String cn;
        for (HL7PrefetchRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (LdapArchiveConfiguration.findHL7PrefetchRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (HL7PrefetchRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            HL7PrefetchRule prevRule = LdapArchiveConfiguration.findHL7PrefetchRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                config.createSubcontext(dn, LdapArchiveConfiguration.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            config.modifyAttributes(dn, LdapArchiveConfiguration.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private static List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, HL7PrefetchRule prev, HL7PrefetchRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmQueueName", (Object)prev.getQueueName(), (Object)rule.getQueueName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomAETitle", (Object)prev.getAETitle(), (Object)rule.getAETitle(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPrefetchCFindSCP", (Object)prev.getPrefetchCFindSCP(), (Object)rule.getPrefetchCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPrefetchCMoveSCP", (Object)prev.getPrefetchCMoveSCP(), (Object)rule.getPrefetchCMoveSCP(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPrefetchCStoreSCP", (Object[])prev.getPrefetchCStoreSCPs(), (Object[])rule.getPrefetchCStoreSCPs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDestinationCFindSCP", (Object)prev.getDestinationCFindSCP(), (Object)rule.getDestinationCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDeviceName", (Object)prev.getPrefetchDeviceName(), (Object)rule.getPrefetchDeviceName(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)rule.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSchedule", (Object[])prev.getSchedules(), (Object[])rule.getSchedules(), (Object[])new ScheduleExpression[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmNullifyIssuerOfPatientID", (Object)prev.getIgnoreAssigningAuthorityOfPatientID(), (Object)rule.getIgnoreAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIssuerOfPatientID", (Object[])prev.getAssigningAuthorityOfPatientIDs(), (Object[])rule.getAssigningAuthorityOfPatientIDs(), (Object[])new Issuer[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmEntitySelector", (Object[])prev.getEntitySelectors(), (Object[])rule.getEntitySelectors(), (Object[])new EntitySelector[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDuration", (Object)prev.getSuppressDuplicateRetrieveInterval(), (Object)rule.getSuppressDuplicateRetrieveInterval(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHistorySize", (int)prev.getSuppressDuplicateHistorySize(), (int)rule.getSuppressDuplicateHistorySize(), (int)100);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPrefetchForIssuerOfPatientID", (Object)prev.getPrefetchForAssigningAuthorityOfPatientID(), (Object)rule.getPrefetchForAssigningAuthorityOfPatientID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPrefetchDateTimeField", (Object)prev.getPrefetchDateTimeField(), (Object)rule.getPrefetchDateTimeField(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPrefetchInAdvance", (Object)prev.getPrefetchInAdvance(), (Object)rule.getPrefetchInAdvance(), null);
        return mods;
    }

    private static HL7PrefetchRule findHL7PrefetchRuleByCN(Collection<HL7PrefetchRule> rules, String cn) {
        for (HL7PrefetchRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    private void storeCompressionRules(ConfigurationChanges diffs, Collection<ArchiveCompressionRule> rules, String parentDN) throws NamingException {
        for (ArchiveCompressionRule rule : rules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    private void storeStudyRetentionPolicies(ConfigurationChanges diffs, Collection<StudyRetentionPolicy> policies, String parentDN) throws NamingException {
        for (StudyRetentionPolicy policy : policies) {
            String dn = LdapUtils.dnOf((String)"cn", (String)policy.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, policy, new BasicAttributes(true)));
        }
    }

    static void storeHL7StudyRetentionPolicies(ConfigurationChanges diffs, Collection<HL7StudyRetentionPolicy> policies, String parentDN, LdapDicomConfiguration config) throws NamingException {
        for (HL7StudyRetentionPolicy policy : policies) {
            String dn = LdapUtils.dnOf((String)"cn", (String)policy.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            config.createSubcontext(dn, LdapArchiveConfiguration.storeTo(ldapObj, policy, new BasicAttributes(true)));
        }
    }

    private void storeStoreAccessControlIDRules(ConfigurationChanges diffs, Collection<StoreAccessControlIDRule> rules, String parentDN) throws NamingException {
        for (StoreAccessControlIDRule rule : rules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    static void storeHL7ForwardRules(ConfigurationChanges diffs, Collection<HL7ForwardRule> rules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        for (HL7ForwardRule rule : rules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            config.createSubcontext(dn, LdapArchiveConfiguration.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    static void storeScheduledStations(ConfigurationChanges diffs, Collection<HL7OrderScheduledStation> stations, String parentDN, LdapDicomConfiguration config) throws NamingException {
        for (HL7OrderScheduledStation station : stations) {
            String dn = LdapUtils.dnOf((String)"cn", (String)station.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            config.createSubcontext(dn, LdapArchiveConfiguration.storeTo(ldapObj, station, new BasicAttributes(true), config));
        }
    }

    static void storeHL7OrderSPSStatus(ConfigurationChanges diffs, Map<SPSStatus, HL7OrderSPSStatus> hl7OrderSPSStatusMap, String parentDN, LdapDicomConfiguration config) throws NamingException {
        for (Map.Entry<SPSStatus, HL7OrderSPSStatus> entry : hl7OrderSPSStatusMap.entrySet()) {
            String dn = LdapUtils.dnOf((String)"dcmSPSStatus", (String)entry.getKey().toString(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            config.createSubcontext(dn, LdapArchiveConfiguration.storeTo(ldapObj, entry.getValue(), entry.getKey(), new BasicAttributes(true)));
        }
    }

    private void storeRSForwardRules(ConfigurationChanges diffs, Collection<RSForwardRule> rules, String parentDN) throws NamingException {
        for (RSForwardRule rule : rules) {
            String dn = LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, rule, new BasicAttributes(true)));
        }
    }

    private void storeMetricsDescriptors(ConfigurationChanges diffs, Collection<MetricsDescriptor> metricsDescriptors, String parentDN) throws NamingException {
        for (MetricsDescriptor metricsDescriptor : metricsDescriptors) {
            String dn = LdapUtils.dnOf((String)"dcmMetricsName", (String)metricsDescriptor.getMetricsName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, metricsDescriptor, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, ArchiveCompressionRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmArchiveCompressionRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getConditions().getMap());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCompressionDelay", (Object)rule.getDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomTransferSyntax", (Object)rule.getTransferSyntax(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmImageWriteParam", (Object[])rule.getImageWriteParams(), (Object[])new Property[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRulePriority", (int)rule.getPriority(), (int)0);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, StoreAccessControlIDRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmStoreAccessControlIDRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getConditions().getMap());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStoreAccessControlID", (Object)rule.getStoreAccessControlID(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRulePriority", (int)rule.getPriority(), (int)0);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, StudyRetentionPolicy policy, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmStudyRetentionPolicy");
        attrs.put("cn", policy.getCommonName());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)policy.getConditions().getMap());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetentionPeriod", (Object)policy.getRetentionPeriod(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRulePriority", (int)policy.getPriority(), (int)0);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExpireSeriesIndividually", (boolean)policy.isExpireSeriesIndividually(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStartRetentionPeriodOnStudyDate", (boolean)policy.isStartRetentionPeriodOnStudyDate(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExporterID", (Object)policy.getExporterID(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFreezeExpirationDate", (boolean)policy.isFreezeExpirationDate(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRevokeExpiration", (boolean)policy.isRevokeExpiration(), (boolean)false);
        return attrs;
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, HL7StudyRetentionPolicy policy, BasicAttributes attrs) {
        attrs.put("objectclass", "hl7StudyRetentionPolicy");
        attrs.put("cn", policy.getCommonName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomAETitle", (Object)policy.getAETitle(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)policy.getConditions().getMap());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetentionPeriod", (Object)policy.getMinRetentionPeriod(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMaxRetentionPeriod", (Object)policy.getMaxRetentionPeriod(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRulePriority", (int)policy.getPriority(), (int)0);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmStartRetentionPeriodOnStudyDate", (boolean)policy.isStartRetentionPeriodOnStudyDate(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmExporterID", (Object)policy.getExporterID(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmFreezeExpirationDate", (boolean)policy.isFreezeExpirationDate(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRevokeExpiration", (boolean)policy.isRevokeExpiration(), (boolean)false);
        return attrs;
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, HL7ForwardRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "hl7ForwardRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7FwdApplicationName", (Object[])rule.getDestinations(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)rule.getConditions().getMap());
        return attrs;
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, HL7OrderScheduledStation station, BasicAttributes attrs, LdapDicomConfiguration config) {
        attrs.put("objectclass", "hl7OrderScheduledStation");
        attrs.put("cn", station.getCommonName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OrderScheduledStationDeviceReference", (Object)LdapArchiveConfiguration.scheduledStationDeviceRef(station, config), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRulePriority", (int)station.getPriority(), (int)0);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)station.getConditions().getMap());
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, RSForwardRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmRSForwardRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmWebAppName", (Object)rule.getWebAppName(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRSOperation", (Object[])rule.getRSOperations(), (Object[])new RSOperation[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmTLSAllowAnyHostname", (boolean)rule.isTlsAllowAnyHostname(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmTLSDisableTrustManager", (boolean)rule.isTlsDisableTrustManager(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURIPattern", (Object)rule.getRequestURLPattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHostnamePattern", (Object)rule.getRemoteHostnamePattern(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIPAddressPattern", (Object)rule.getRemoteIPAddressPattern(), null);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, MetricsDescriptor metricsDescriptor, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmMetrics");
        attrs.put("dcmMetricsName", metricsDescriptor.getMetricsName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)metricsDescriptor.getDescription(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMetricsRetentionPeriod", (int)metricsDescriptor.getRetentionPeriod(), (int)60);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUnit", (Object)metricsDescriptor.getUnit(), null);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCompressionRules(Collection<ArchiveCompressionRule> rules, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmArchiveCompressionRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                ArchiveCompressionRule rule = new ArchiveCompressionRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                rule.setDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmCompressionDelay"), null));
                rule.setTransferSyntax(LdapUtils.stringValue((Attribute)attrs.get("dicomTransferSyntax"), null));
                rule.setImageWriteParams(Property.valueOf((String[])LdapUtils.stringArray((Attribute)attrs.get("dcmImageWriteParam"), (String[])new String[0])));
                rule.setPriority(LdapUtils.intValue((Attribute)attrs.get("dcmRulePriority"), (int)0));
                rules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStoreAccessControlIDRules(Collection<StoreAccessControlIDRule> rules, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmStoreAccessControlIDRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                StoreAccessControlIDRule rule = new StoreAccessControlIDRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                rule.setStoreAccessControlID(LdapUtils.stringValue((Attribute)attrs.get("dcmStoreAccessControlID"), null));
                rule.setPriority(LdapUtils.intValue((Attribute)attrs.get("dcmRulePriority"), (int)0));
                rules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStudyRetentionPolicies(Collection<StudyRetentionPolicy> policies, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmStudyRetentionPolicy)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                StudyRetentionPolicy policy = new StudyRetentionPolicy(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                policy.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                policy.setRetentionPeriod(LdapArchiveConfiguration.toPeriod(attrs.get("dcmRetentionPeriod")));
                policy.setPriority(LdapUtils.intValue((Attribute)attrs.get("dcmRulePriority"), (int)0));
                policy.setExpireSeriesIndividually(LdapUtils.booleanValue((Attribute)attrs.get("dcmExpireSeriesIndividually"), (boolean)false));
                policy.setStartRetentionPeriodOnStudyDate(LdapUtils.booleanValue((Attribute)attrs.get("dcmStartRetentionPeriodOnStudyDate"), (boolean)false));
                policy.setExporterID(LdapUtils.stringValue((Attribute)attrs.get("dcmExporterID"), null));
                policy.setFreezeExpirationDate(LdapUtils.booleanValue((Attribute)attrs.get("dcmFreezeExpirationDate"), (boolean)false));
                policy.setRevokeExpiration(LdapUtils.booleanValue((Attribute)attrs.get("dcmRevokeExpiration"), (boolean)false));
                policies.add(policy);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadHL7StudyRetentionPolicies(Collection<HL7StudyRetentionPolicy> policies, String parentDN, LdapDicomConfiguration config) throws NamingException {
        NamingEnumeration ne = config.search(parentDN, "(objectclass=hl7StudyRetentionPolicy)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                HL7StudyRetentionPolicy policy = new HL7StudyRetentionPolicy(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                policy.setAETitle(LdapUtils.stringValue((Attribute)attrs.get("dicomAETitle"), null));
                policy.setConditions(new HL7Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                policy.setMinRetentionPeriod(LdapArchiveConfiguration.toPeriod(attrs.get("dcmRetentionPeriod")));
                policy.setMaxRetentionPeriod(LdapArchiveConfiguration.toPeriod(attrs.get("dcmMaxRetentionPeriod")));
                policy.setPriority(LdapUtils.intValue((Attribute)attrs.get("dcmRulePriority"), (int)0));
                policy.setStartRetentionPeriodOnStudyDate(LdapUtils.booleanValue((Attribute)attrs.get("dcmStartRetentionPeriodOnStudyDate"), (boolean)false));
                policy.setExporterID(LdapUtils.stringValue((Attribute)attrs.get("dcmExporterID"), null));
                policy.setFreezeExpirationDate(LdapUtils.booleanValue((Attribute)attrs.get("dcmFreezeExpirationDate"), (boolean)false));
                policy.setRevokeExpiration(LdapUtils.booleanValue((Attribute)attrs.get("dcmRevokeExpiration"), (boolean)false));
                policies.add(policy);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadHL7ForwardRules(Collection<HL7ForwardRule> rules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        NamingEnumeration ne = config.search(parentDN, "(objectclass=hl7ForwardRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                HL7ForwardRule rule = new HL7ForwardRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setDestinations(LdapUtils.stringArray((Attribute)attrs.get("hl7FwdApplicationName"), (String[])new String[0]));
                rule.setConditions(new HL7Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                rules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadScheduledStations(Collection<HL7OrderScheduledStation> stations, String parentDN, LdapDicomConfiguration config, Device device) throws NamingException {
        NamingEnumeration ne = config.search(parentDN, "(objectclass=hl7OrderScheduledStation)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                HL7OrderScheduledStation station = new HL7OrderScheduledStation(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                String scheduledStationDeviceRef = LdapUtils.stringValue((Attribute)attrs.get("hl7OrderScheduledStationDeviceReference"), null);
                station.setDevice(parentDN.equals(scheduledStationDeviceRef) ? device : LdapArchiveConfiguration.loadScheduledStation(scheduledStationDeviceRef, config));
                station.setPriority(LdapUtils.intValue((Attribute)attrs.get("dcmRulePriority"), (int)0));
                station.setConditions(new HL7Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                stations.add(station);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private static Device loadScheduledStation(String scheduledStationDeviceRef, LdapDicomConfiguration config) {
        try {
            return config.loadDevice(scheduledStationDeviceRef);
        }
        catch (ConfigurationException e) {
            LOG.info("Failed to load Scheduled Station device " + scheduledStationDeviceRef + " referenced by HL7 Order Scheduled Station", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRSForwardRules(Collection<RSForwardRule> rules, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmRSForwardRule)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                RSForwardRule rule = new RSForwardRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                rule.setWebAppName(LdapUtils.stringValue((Attribute)attrs.get("dcmWebAppName"), null));
                rule.setRSOperations((RSOperation[])LdapUtils.enumArray(RSOperation.class, (Attribute)attrs.get("dcmRSOperation")));
                rule.setTlsAllowAnyHostname(LdapUtils.booleanValue((Attribute)attrs.get("dcmTLSAllowAnyHostname"), (boolean)false));
                rule.setTlsDisableTrustManager(LdapUtils.booleanValue((Attribute)attrs.get("dcmTLSDisableTrustManager"), (boolean)false));
                rule.setRequestURLPattern(LdapUtils.stringValue((Attribute)attrs.get("dcmURIPattern"), null));
                rule.setRemoteHostnamePattern(LdapUtils.stringValue((Attribute)attrs.get("dcmHostnamePattern"), null));
                rule.setRemoteIPAddressPattern(LdapUtils.stringValue((Attribute)attrs.get("dcmIPAddressPattern"), null));
                rules.add(rule);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetricsDescriptors(ArchiveDeviceExtension arcdev, String parentDN) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmMetrics)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                MetricsDescriptor metricsDescriptor = new MetricsDescriptor();
                metricsDescriptor.setMetricsName(LdapUtils.stringValue((Attribute)attrs.get("dcmMetricsName"), null));
                metricsDescriptor.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
                metricsDescriptor.setRetentionPeriod(LdapUtils.intValue((Attribute)attrs.get("dcmMetricsRetentionPeriod"), (int)60));
                metricsDescriptor.setUnit(LdapUtils.stringValue((Attribute)attrs.get("dcmUnit"), null));
                arcdev.addMetricsDescriptor(metricsDescriptor);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private void mergeCompressionRules(ConfigurationChanges diffs, Collection<ArchiveCompressionRule> prevRules, Collection<ArchiveCompressionRule> rules, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (ArchiveCompressionRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (this.findCompressionRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (ArchiveCompressionRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            ArchiveCompressionRule prevRule = this.findCompressionRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeStoreAccessControlIDRules(ConfigurationChanges diffs, Collection<StoreAccessControlIDRule> prevRules, Collection<StoreAccessControlIDRule> rules, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (StoreAccessControlIDRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (this.findStoreAccessControlIDRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (StoreAccessControlIDRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            StoreAccessControlIDRule prevRule = this.findStoreAccessControlIDRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeStudyRetentionPolicies(ConfigurationChanges diffs, Collection<StudyRetentionPolicy> prevPolicies, Collection<StudyRetentionPolicy> policies, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (StudyRetentionPolicy prevRule : prevPolicies) {
            cn = prevRule.getCommonName();
            if (this.findStudyRetentionPolicyByCN(policies, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (StudyRetentionPolicy policy : policies) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = policy.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            StudyRetentionPolicy prevPolicy = this.findStudyRetentionPolicyByCN(prevPolicies, cn);
            if (prevPolicy == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), policy, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevPolicy, policy, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    static void mergeHL7StudyRetentionPolicies(ConfigurationChanges diffs, Collection<HL7StudyRetentionPolicy> prevPolicies, Collection<HL7StudyRetentionPolicy> policies, String parentDN, LdapDicomConfiguration config) throws NamingException {
        String dn;
        String cn;
        for (HL7StudyRetentionPolicy prevRule : prevPolicies) {
            cn = prevRule.getCommonName();
            if (LdapArchiveConfiguration.findHL7StudyRetentionPolicyByCN(policies, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (HL7StudyRetentionPolicy policy : policies) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = policy.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            HL7StudyRetentionPolicy prevPolicy = LdapArchiveConfiguration.findHL7StudyRetentionPolicyByCN(prevPolicies, cn);
            if (prevPolicy == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                config.createSubcontext(dn, LdapArchiveConfiguration.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), policy, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            config.modifyAttributes(dn, LdapArchiveConfiguration.storeDiffs(ldapObj, prevPolicy, policy, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    static void mergeHL7ForwardRules(ConfigurationChanges diffs, Collection<HL7ForwardRule> prevRules, Collection<HL7ForwardRule> rules, String parentDN, LdapDicomConfiguration config) throws NamingException {
        String dn;
        String cn;
        for (HL7ForwardRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (LdapArchiveConfiguration.findHL7ForwardRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (HL7ForwardRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            HL7ForwardRule prevRule = LdapArchiveConfiguration.findHL7ForwardRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                config.createSubcontext(dn, LdapArchiveConfiguration.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            config.modifyAttributes(dn, LdapArchiveConfiguration.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    static void mergeScheduledStations(ConfigurationChanges diffs, Collection<HL7OrderScheduledStation> prevStations, Collection<HL7OrderScheduledStation> stations, String parentDN, LdapDicomConfiguration config) throws NamingException {
        String dn;
        String cn;
        for (HL7OrderScheduledStation prevRule : prevStations) {
            cn = prevRule.getCommonName();
            if (LdapArchiveConfiguration.findScheduledStationByCN(stations, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (HL7OrderScheduledStation station : stations) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = station.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            HL7OrderScheduledStation prevStation = LdapArchiveConfiguration.findScheduledStationByCN(prevStations, cn);
            if (prevStation == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                config.createSubcontext(dn, LdapArchiveConfiguration.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), station, new BasicAttributes(true), config));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            config.modifyAttributes(dn, LdapArchiveConfiguration.storeDiffs(ldapObj, prevStation, station, new ArrayList<ModificationItem>(), config));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeAttributeCoercions(ConfigurationChanges diffs, Collection<ArchiveAttributeCoercion> prevCoercions, Collection<ArchiveAttributeCoercion> coercions, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (ArchiveAttributeCoercion prev : prevCoercions) {
            cn = prev.getCommonName();
            if (this.findAttributeCoercionByCN(coercions, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (ArchiveAttributeCoercion coercion : coercions) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = coercion.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            ArchiveAttributeCoercion prev = this.findAttributeCoercionByCN(prevCoercions, cn);
            if (prev == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), coercion, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prev, coercion, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeAttributeCoercions2(ConfigurationChanges diffs, Collection<ArchiveAttributeCoercion2> prevCoercions, Collection<ArchiveAttributeCoercion2> coercions, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (ArchiveAttributeCoercion2 prev : prevCoercions) {
            cn = prev.getCommonName();
            if (this.findAttributeCoercion2ByCN(coercions, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (ArchiveAttributeCoercion2 coercion : coercions) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = coercion.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            ArchiveAttributeCoercion2 prev = this.findAttributeCoercion2ByCN(prevCoercions, cn);
            if (prev == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), coercion, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prev, coercion, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeRSForwardRules(ConfigurationChanges diffs, Collection<RSForwardRule> prevRules, Collection<RSForwardRule> rules, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (RSForwardRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (this.findRSForwardRuleByCN(rules, cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (RSForwardRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            RSForwardRule prevRule = this.findRSForwardRuleByCN(prevRules, cn);
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeMetricsDescriptors(ConfigurationChanges diffs, Collection<MetricsDescriptor> prevMetricsDescriptors, Collection<MetricsDescriptor> metricsDescriptors, String parentDN) throws NamingException {
        String dn;
        String metricsName;
        for (MetricsDescriptor prevMetricsDescriptor : prevMetricsDescriptors) {
            metricsName = prevMetricsDescriptor.getMetricsName();
            if (this.findMetricsDescriptorByName(prevMetricsDescriptors, metricsName) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmMetricsName", (String)metricsName, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (MetricsDescriptor metricsDescriptor : metricsDescriptors) {
            ConfigurationChanges.ModifiedObject ldapObj;
            metricsName = metricsDescriptor.getMetricsName();
            dn = LdapUtils.dnOf((String)"dcmMetricsName", (String)metricsName, (String)parentDN);
            MetricsDescriptor prevMetricsDescriptor = this.findMetricsDescriptorByName(prevMetricsDescriptors, metricsName);
            if (prevMetricsDescriptor == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), metricsDescriptor, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevMetricsDescriptor, metricsDescriptor, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ArchiveCompressionRule prev, ArchiveCompressionRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)rule.getConditions().getMap());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCompressionDelay", (Object)prev.getDelay(), (Object)rule.getDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomTransferSyntax", (Object)prev.getTransferSyntax(), (Object)rule.getTransferSyntax(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmImageWriteParam", (Object[])prev.getImageWriteParams(), (Object[])rule.getImageWriteParams(), (Object[])new Property[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRulePriority", (int)prev.getPriority(), (int)rule.getPriority(), (int)0);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, StoreAccessControlIDRule prev, StoreAccessControlIDRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)rule.getConditions().getMap());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStoreAccessControlID", (Object)prev.getStoreAccessControlID(), (Object)rule.getStoreAccessControlID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRulePriority", (int)prev.getPriority(), (int)rule.getPriority(), (int)0);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, StudyRetentionPolicy prev, StudyRetentionPolicy policy, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)policy.getConditions().getMap());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetentionPeriod", (Object)prev.getRetentionPeriod(), (Object)policy.getRetentionPeriod(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRulePriority", (int)prev.getPriority(), (int)policy.getPriority(), (int)0);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExpireSeriesIndividually", (boolean)prev.isExpireSeriesIndividually(), (boolean)policy.isExpireSeriesIndividually(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStartRetentionPeriodOnStudyDate", (boolean)prev.isStartRetentionPeriodOnStudyDate(), (boolean)policy.isStartRetentionPeriodOnStudyDate(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExporterID", (Object)prev.getExporterID(), (Object)policy.getExporterID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFreezeExpirationDate", (boolean)prev.isFreezeExpirationDate(), (boolean)policy.isFreezeExpirationDate(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRevokeExpiration", (boolean)prev.isRevokeExpiration(), (boolean)policy.isRevokeExpiration(), (boolean)false);
        return mods;
    }

    private static List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, HL7StudyRetentionPolicy prev, HL7StudyRetentionPolicy policy, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomAETitle", (Object)prev.getAETitle(), (Object)policy.getAETitle(), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)policy.getConditions().getMap());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetentionPeriod", (Object)prev.getMinRetentionPeriod(), (Object)policy.getMinRetentionPeriod(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMaxRetentionPeriod", (Object)prev.getMaxRetentionPeriod(), (Object)policy.getMaxRetentionPeriod(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRulePriority", (int)prev.getPriority(), (int)policy.getPriority(), (int)0);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmStartRetentionPeriodOnStudyDate", (boolean)prev.isStartRetentionPeriodOnStudyDate(), (boolean)policy.isStartRetentionPeriodOnStudyDate(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmExporterID", (Object)prev.getExporterID(), (Object)policy.getExporterID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmFreezeExpirationDate", (boolean)prev.isFreezeExpirationDate(), (boolean)policy.isFreezeExpirationDate(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRevokeExpiration", (boolean)prev.isRevokeExpiration(), (boolean)policy.isRevokeExpiration(), (boolean)false);
        return mods;
    }

    private static List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, HL7ForwardRule prev, HL7ForwardRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)rule.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7FwdApplicationName", (Object[])prev.getDestinations(), (Object[])rule.getDestinations(), (Object[])new String[0]);
        return mods;
    }

    private static List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, HL7OrderScheduledStation prev, HL7OrderScheduledStation station, ArrayList<ModificationItem> mods, LdapDicomConfiguration config) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OrderScheduledStationDeviceReference", (Object)LdapArchiveConfiguration.scheduledStationDeviceRef(prev, config), (Object)LdapArchiveConfiguration.scheduledStationDeviceRef(station, config), null);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)station.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRulePriority", (int)prev.getPriority(), (int)station.getPriority(), (int)0);
        return mods;
    }

    private static List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, HL7OrderSPSStatus prev, HL7OrderSPSStatus hl7OrderSPSStatus, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OrderControlStatus", (Object[])prev.getOrderControlStatusCodes(), (Object[])hl7OrderSPSStatus.getOrderControlStatusCodes(), (Object[])new String[0]);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, RSForwardRule prev, RSForwardRule rule, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmWebAppName", (Object)prev.getWebAppName(), (Object)rule.getWebAppName(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRSOperation", (Object[])prev.getRSOperations(), (Object[])rule.getRSOperations(), (Object[])new RSOperation[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURIPattern", (Object)prev.getRequestURLPattern(), (Object)rule.getRequestURLPattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHostnamePattern", (Object)prev.getRemoteHostnamePattern(), (Object)rule.getRemoteHostnamePattern(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIPAddressPattern", (Object)prev.getRemoteIPAddressPattern(), (Object)rule.getRemoteIPAddressPattern(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmTLSAllowAnyHostname", (boolean)prev.isTlsAllowAnyHostname(), (boolean)rule.isTlsAllowAnyHostname(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmTLSDisableTrustManager", (boolean)prev.isTlsDisableTrustManager(), (boolean)rule.isTlsDisableTrustManager(), (boolean)false);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, MetricsDescriptor prev, MetricsDescriptor metricsDescriptor, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)prev.getDescription(), (Object)metricsDescriptor.getDescription(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMetricsRetentionPeriod", (int)prev.getRetentionPeriod(), (int)metricsDescriptor.getRetentionPeriod(), (int)60);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUnit", (Object)prev.getUnit(), (Object)metricsDescriptor.getUnit(), null);
        return mods;
    }

    private ArchiveCompressionRule findCompressionRuleByCN(Collection<ArchiveCompressionRule> rules, String cn) {
        for (ArchiveCompressionRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    private StoreAccessControlIDRule findStoreAccessControlIDRuleByCN(Collection<StoreAccessControlIDRule> rules, String cn) {
        for (StoreAccessControlIDRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    private StudyRetentionPolicy findStudyRetentionPolicyByCN(Collection<StudyRetentionPolicy> policies, String cn) {
        for (StudyRetentionPolicy policy : policies) {
            if (!policy.getCommonName().equals(cn)) continue;
            return policy;
        }
        return null;
    }

    private static HL7StudyRetentionPolicy findHL7StudyRetentionPolicyByCN(Collection<HL7StudyRetentionPolicy> policies, String cn) {
        for (HL7StudyRetentionPolicy policy : policies) {
            if (!policy.getCommonName().equals(cn)) continue;
            return policy;
        }
        return null;
    }

    private static HL7ForwardRule findHL7ForwardRuleByCN(Collection<HL7ForwardRule> rules, String cn) {
        for (HL7ForwardRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    private static HL7OrderScheduledStation findScheduledStationByCN(Collection<HL7OrderScheduledStation> stations, String cn) {
        for (HL7OrderScheduledStation station : stations) {
            if (!station.getCommonName().equals(cn)) continue;
            return station;
        }
        return null;
    }

    private RSForwardRule findRSForwardRuleByCN(Collection<RSForwardRule> rules, String cn) {
        for (RSForwardRule rule : rules) {
            if (!rule.getCommonName().equals(cn)) continue;
            return rule;
        }
        return null;
    }

    private MetricsDescriptor findMetricsDescriptorByName(Collection<MetricsDescriptor> metricsDescriptors, String metricsName) {
        for (MetricsDescriptor metricsDescriptor : metricsDescriptors) {
            if (!metricsDescriptor.getMetricsName().equals(metricsName)) continue;
            return metricsDescriptor;
        }
        return null;
    }

    private void storeQueryRetrieveViews(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (QueryRetrieveView view : arcDev.getQueryRetrieveViews()) {
            String dn = LdapUtils.dnOf((String)"dcmQueryRetrieveViewID", (String)view.getViewID(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, view, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, QueryRetrieveView qrView, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmQueryRetrieveView");
        attrs.put("dcmQueryRetrieveViewID", qrView.getViewID());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmShowInstancesRejectedByCode", (Object[])qrView.getShowInstancesRejectedByCodes(), (Object[])new Code[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHideRejectionNoteWithCode", (Object[])qrView.getHideRejectionNotesWithCodes(), (Object[])new Code[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmHideNotRejectedInstances", (boolean)qrView.isHideNotRejectedInstances(), (boolean)false);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQueryRetrieveViews(ArchiveDeviceExtension arcdev, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmQueryRetrieveView)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                QueryRetrieveView view = new QueryRetrieveView();
                view.setViewID(LdapUtils.stringValue((Attribute)attrs.get("dcmQueryRetrieveViewID"), null));
                view.setShowInstancesRejectedByCodes(LdapUtils.codeArray((Attribute)attrs.get("dcmShowInstancesRejectedByCode")));
                view.setHideRejectionNotesWithCodes(LdapUtils.codeArray((Attribute)attrs.get("dcmHideRejectionNoteWithCode")));
                view.setHideNotRejectedInstances(LdapUtils.booleanValue((Attribute)attrs.get("dcmHideNotRejectedInstances"), (boolean)false));
                arcdev.addQueryRetrieveView(view);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private void mergeQueryRetrieveViews(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        String dn;
        String viewID;
        for (QueryRetrieveView entry : prev.getQueryRetrieveViews()) {
            viewID = entry.getViewID();
            if (arcDev.getQueryRetrieveView(viewID) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmQueryRetrieveViewID", (String)viewID, (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (QueryRetrieveView entryNew : arcDev.getQueryRetrieveViews()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            viewID = entryNew.getViewID();
            dn = LdapUtils.dnOf((String)"dcmQueryRetrieveViewID", (String)viewID, (String)deviceDN);
            QueryRetrieveView entryOld = prev.getQueryRetrieveView(viewID);
            if (entryOld == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), entryNew, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, entryOld, entryNew, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, QueryRetrieveView prev, QueryRetrieveView view, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmShowInstancesRejectedByCode", (Object[])prev.getShowInstancesRejectedByCodes(), (Object[])view.getShowInstancesRejectedByCodes(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHideRejectionNoteWithCode", (Object[])prev.getHideRejectionNotesWithCodes(), (Object[])view.getHideRejectionNotesWithCodes(), (Object[])new Code[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmHideNotRejectedInstances", (boolean)prev.isHideNotRejectedInstances(), (boolean)view.isHideNotRejectedInstances(), (boolean)false);
        return mods;
    }

    private void storeAttributeCoercions(ConfigurationChanges diffs, Collection<ArchiveAttributeCoercion> coercions, String parentDN) throws NamingException {
        for (ArchiveAttributeCoercion coercion : coercions) {
            String dn = LdapUtils.dnOf((String)"cn", (String)coercion.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, coercion, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, ArchiveAttributeCoercion coercion, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmArchiveAttributeCoercion");
        attrs.put("cn", coercion.getCommonName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDIMSE", (Object)coercion.getDIMSE(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomTransferRole", (Object)coercion.getRole(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSOPClass", (Object[])coercion.getSOPClasses(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)coercion.getConditions().getMap());
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeAttribute", (Object[])coercion.getMergeAttributes(), (Object[])new MergeAttribute[0]);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRetrieveAsReceived", (boolean)coercion.isRetrieveAsReceived(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURI", (Object)coercion.getXSLTStylesheetURI(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmNoKeywords", (boolean)coercion.isNoKeywords(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmTrimISO2022CharacterSet", (boolean)coercion.isTrimISO2022CharacterSet(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmUseCallingAETitleAs", (Object)coercion.getUseCallingAETitleAs(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmLeadingCFindSCP", (Object)coercion.getLeadingCFindSCP(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeMWLTemplateURI", (Object)coercion.getMergeMWLTemplateURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeMWLSCP", (Object)coercion.getMergeMWLSCP(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeLocalMWLWorklistLabel", (Object[])coercion.getMergeLocalMWLWorklistLabels(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeLocalMWLWithStatus", (Object[])coercion.getMergeLocalMWLWithStatus(), (Object[])new SPSStatus[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeMWLMatchingKey", (Object)coercion.getMergeMWLMatchingKey(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMWLImportFilterBySCU", (boolean)coercion.isFilterBySCU(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAttributeUpdatePolicy", (Object)coercion.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.MERGE);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRulePriority", (int)coercion.getPriority(), (int)0);
        LdapArchiveConfiguration.storeNotEmptyTags(ldapObj, attrs, "dcmNullifyTag", coercion.getNullifyTags());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSupplementFromDeviceReference", (Object)this.deviceNameOf(coercion.getSupplementFromDevice()), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmNullifyIssuerOfPatientID", (Object)coercion.getNullifyIssuerOfPatientID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIssuerOfPatientID", (Object[])coercion.getIssuerOfPatientIDs(), (Object[])new Issuer[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIssuerOfPatientIDFormat", (Object)coercion.getIssuerOfPatientIDFormat(), null);
        return attrs;
    }

    private void storeAttributeCoercions2(ConfigurationChanges diffs, Collection<ArchiveAttributeCoercion2> coercions, String parentDN) throws NamingException {
        for (ArchiveAttributeCoercion2 coercion : coercions) {
            String dn = LdapUtils.dnOf((String)"cn", (String)coercion.getCommonName(), (String)parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, coercion, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, ArchiveAttributeCoercion2 coercion, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmArchiveAttributeCoercion2");
        attrs.put("cn", coercion.getCommonName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)coercion.getDescription(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRulePriority", (int)coercion.getPriority(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDIMSE", (Object)coercion.getDIMSE(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomTransferRole", (Object)coercion.getRole(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSOPClass", (Object[])coercion.getSOPClasses(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmProperty", (Map)coercion.getConditions().getMap());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmURI", (Object)coercion.getURI(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAttributeUpdatePolicy", (Object)coercion.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.MERGE);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmSupplementFromDeviceReference", (Object)this.deviceNameOf(coercion.getOtherDevice()), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmMergeAttribute", (Object[])coercion.getMergeAttributes(), (Object[])new MergeAttribute[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCoercionParam", (Map)coercion.getCoercionParams());
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCoercionSufficient", (boolean)coercion.isCoercionSufficient(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmCoercionOnFailure", (Object)coercion.getCoercionOnFailure(), (Object)ArchiveAttributeCoercion2.OnFailure.RETHROW);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributeCoercions(Collection<ArchiveAttributeCoercion> coercions, String parentDN, Device device) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmArchiveAttributeCoercion)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                ArchiveAttributeCoercion coercion = new ArchiveAttributeCoercion(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                coercion.setDIMSE((Dimse)LdapUtils.enumValue(Dimse.class, (Attribute)attrs.get("dcmDIMSE"), null));
                coercion.setRole((TransferCapability.Role)LdapUtils.enumValue(TransferCapability.Role.class, (Attribute)attrs.get("dicomTransferRole"), null));
                coercion.setSOPClasses(LdapUtils.stringArray((Attribute)attrs.get("dcmSOPClass"), (String[])new String[0]));
                coercion.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                coercion.setMergeAttributes(LdapUtils.stringArray((Attribute)attrs.get("dcmMergeAttribute"), (String[])new String[0]));
                coercion.setRetrieveAsReceived(LdapUtils.booleanValue((Attribute)attrs.get("dcmRetrieveAsReceived"), (boolean)false));
                coercion.setDeIdentification((DeIdentifier.Option[])LdapUtils.enumArray(DeIdentifier.Option.class, (Attribute)attrs.get("dcmDeIdentification")));
                coercion.setXSLTStylesheetURI(LdapUtils.stringValue((Attribute)attrs.get("dcmURI"), null));
                coercion.setNoKeywords(LdapUtils.booleanValue((Attribute)attrs.get("dcmNoKeywords"), (boolean)false));
                coercion.setTrimISO2022CharacterSet(LdapUtils.booleanValue((Attribute)attrs.get("dcmTrimISO2022CharacterSet"), (boolean)false));
                coercion.setUseCallingAETitleAs((UseCallingAETitleAsCoercion.Type)LdapUtils.enumValue(UseCallingAETitleAsCoercion.Type.class, (Attribute)attrs.get("dcmUseCallingAETitleAs"), null));
                coercion.setLeadingCFindSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmLeadingCFindSCP"), null));
                coercion.setMergeMWLTemplateURI(LdapUtils.stringValue((Attribute)attrs.get("dcmMergeMWLTemplateURI"), null));
                coercion.setMergeMWLSCP(LdapUtils.stringValue((Attribute)attrs.get("dcmMergeMWLSCP"), null));
                coercion.setMergeLocalMWLWorklistLabels(LdapUtils.stringArray((Attribute)attrs.get("dcmMergeLocalMWLWorklistLabel"), (String[])new String[0]));
                coercion.setMergeLocalMWLWithStatus((SPSStatus[])LdapUtils.enumArray(SPSStatus.class, (Attribute)attrs.get("dcmMergeLocalMWLWithStatus")));
                coercion.setMergeMWLMatchingKey((MergeMWLMatchingKey)LdapUtils.enumValue(MergeMWLMatchingKey.class, (Attribute)attrs.get("dcmMergeMWLMatchingKey"), null));
                coercion.setFilterBySCU(LdapUtils.booleanValue((Attribute)attrs.get("dcmMWLImportFilterBySCU"), (boolean)false));
                coercion.setAttributeUpdatePolicy((Attributes.UpdatePolicy)LdapUtils.enumValue(Attributes.UpdatePolicy.class, (Attribute)attrs.get("dcmAttributeUpdatePolicy"), (Enum)Attributes.UpdatePolicy.MERGE));
                coercion.setPriority(LdapUtils.intValue((Attribute)attrs.get("dcmRulePriority"), (int)0));
                coercion.setNullifyTags(LdapArchiveConfiguration.tags(attrs.get("dcmNullifyTag")));
                String supplementDeviceDN = LdapUtils.stringValue((Attribute)attrs.get("dcmSupplementFromDeviceReference"), null);
                if (supplementDeviceDN != null) {
                    coercion.setSupplementFromDevice(parentDN.equals(supplementDeviceDN) ? device : this.loadDevice(supplementDeviceDN));
                }
                coercion.setNullifyIssuerOfPatientID((NullifyIssuer)LdapUtils.enumValue(NullifyIssuer.class, (Attribute)attrs.get("dcmNullifyIssuerOfPatientID"), null));
                coercion.setIssuerOfPatientIDs(LdapArchiveConfiguration.toIssuers(LdapUtils.stringArray((Attribute)attrs.get("dcmIssuerOfPatientID"), (String[])new String[0])));
                coercion.setIssuerOfPatientIDFormat(LdapUtils.stringValue((Attribute)attrs.get("dcmIssuerOfPatientIDFormat"), null));
                coercions.add(coercion);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributeCoercions2(Collection<ArchiveAttributeCoercion2> coercions, String parentDN, Device device) throws NamingException {
        NamingEnumeration ne = this.config.search(parentDN, "(objectclass=dcmArchiveAttributeCoercion2)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                ArchiveAttributeCoercion2 coercion = new ArchiveAttributeCoercion2(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
                coercion.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
                coercion.setPriority(LdapUtils.intValue((Attribute)attrs.get("dcmRulePriority"), (int)0));
                coercion.setDIMSE((Dimse)LdapUtils.enumValue(Dimse.class, (Attribute)attrs.get("dcmDIMSE"), null));
                coercion.setRole((TransferCapability.Role)LdapUtils.enumValue(TransferCapability.Role.class, (Attribute)attrs.get("dicomTransferRole"), null));
                coercion.setSOPClasses(LdapUtils.stringArray((Attribute)attrs.get("dcmSOPClass"), (String[])new String[0]));
                coercion.setConditions(new Conditions(LdapUtils.stringArray((Attribute)attrs.get("dcmProperty"), (String[])new String[0])));
                coercion.setURI(LdapUtils.stringValue((Attribute)attrs.get("dcmURI"), null));
                coercion.setAttributeUpdatePolicy((Attributes.UpdatePolicy)LdapUtils.enumValue(Attributes.UpdatePolicy.class, (Attribute)attrs.get("dcmAttributeUpdatePolicy"), (Enum)Attributes.UpdatePolicy.MERGE));
                String otherDevice = LdapUtils.stringValue((Attribute)attrs.get("dcmSupplementFromDeviceReference"), null);
                if (otherDevice != null) {
                    coercion.setOtherDevice(parentDN.equals(otherDevice) ? device : this.loadDevice(otherDevice));
                }
                coercion.setMergeAttributes(LdapUtils.stringArray((Attribute)attrs.get("dcmMergeAttribute"), (String[])new String[0]));
                coercion.setCoercionParams(LdapUtils.stringArray((Attribute)attrs.get("dcmCoercionParam"), (String[])new String[0]));
                coercion.setCoercionSufficient(LdapUtils.booleanValue((Attribute)attrs.get("dcmCoercionSufficient"), (boolean)false));
                coercion.setCoercionOnFailure((ArchiveAttributeCoercion2.OnFailure)LdapUtils.enumValue(ArchiveAttributeCoercion2.OnFailure.class, (Attribute)attrs.get("dcmCoercionOnFailure"), (Enum)ArchiveAttributeCoercion2.OnFailure.RETHROW));
                coercions.add(coercion);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private static Issuer[] toIssuers(String[] issuerOfPatientIds) {
        Issuer[] issuers = new Issuer[issuerOfPatientIds.length];
        for (int i = 0; i < issuerOfPatientIds.length; ++i) {
            issuers[i] = new Issuer(issuerOfPatientIds[i]);
        }
        return issuers;
    }

    private static Issuer toIssuer(String issuerOfPatientID) {
        return issuerOfPatientID != null ? new Issuer(issuerOfPatientID) : null;
    }

    private Device loadDevice(String deviceName) {
        try {
            return this.config.loadDevice(deviceName);
        }
        catch (ConfigurationException e) {
            LOG.info("Failed to load Device {} referenced by Attribute Coercion", (Object)deviceName, (Object)e);
            return null;
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ArchiveAttributeCoercion prev, ArchiveAttributeCoercion coercion, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDIMSE", (Object)prev.getDIMSE(), (Object)coercion.getDIMSE(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomTransferRole", (Object)prev.getRole(), (Object)coercion.getRole(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSOPClass", (Object[])prev.getSOPClasses(), (Object[])coercion.getSOPClasses(), (Object[])new String[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)coercion.getConditions().getMap());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeAttribute", (Object[])prev.getMergeAttributes(), (Object[])coercion.getMergeAttributes(), (Object[])new MergeAttribute[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRetrieveAsReceived", (boolean)prev.isRetrieveAsReceived(), (boolean)coercion.isRetrieveAsReceived(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeIdentification", (Object[])prev.getDeIdentification(), (Object[])coercion.getDeIdentification(), (Object[])new DeIdentifier.Option[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getXSLTStylesheetURI(), (Object)coercion.getXSLTStylesheetURI(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmNoKeywords", (boolean)prev.isNoKeywords(), (boolean)coercion.isNoKeywords(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmTrimISO2022CharacterSet", (boolean)prev.isTrimISO2022CharacterSet(), (boolean)coercion.isTrimISO2022CharacterSet(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmUseCallingAETitleAs", (Object)prev.getUseCallingAETitleAs(), (Object)coercion.getUseCallingAETitleAs(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmLeadingCFindSCP", (Object)prev.getLeadingCFindSCP(), (Object)coercion.getLeadingCFindSCP(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeMWLTemplateURI", (Object)prev.getMergeMWLTemplateURI(), (Object)coercion.getMergeMWLTemplateURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeMWLSCP", (Object)prev.getMergeMWLSCP(), (Object)coercion.getMergeMWLSCP(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeLocalMWLWorklistLabel", (Object[])prev.getMergeLocalMWLWorklistLabels(), (Object[])coercion.getMergeLocalMWLWorklistLabels(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeLocalMWLWithStatus", (Object[])prev.getMergeLocalMWLWithStatus(), (Object[])coercion.getMergeLocalMWLWithStatus(), (Object[])new SPSStatus[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeMWLMatchingKey", (Object)prev.getMergeMWLMatchingKey(), (Object)coercion.getMergeMWLMatchingKey(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMWLImportFilterBySCU", (boolean)prev.isFilterBySCU(), (boolean)coercion.isFilterBySCU(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAttributeUpdatePolicy", (Object)prev.getAttributeUpdatePolicy(), (Object)coercion.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.MERGE);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRulePriority", (int)prev.getPriority(), (int)coercion.getPriority(), (int)0);
        this.storeDiffTags(mods, "dcmNullifyTag", prev.getNullifyTags(), coercion.getNullifyTags());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSupplementFromDeviceReference", (Object)this.deviceNameOf(prev.getSupplementFromDevice()), (Object)this.deviceNameOf(coercion.getSupplementFromDevice()), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmNullifyIssuerOfPatientID", (Object)prev.getNullifyIssuerOfPatientID(), (Object)coercion.getNullifyIssuerOfPatientID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIssuerOfPatientID", (Object[])prev.getIssuerOfPatientIDs(), (Object[])coercion.getIssuerOfPatientIDs(), (Object[])new Issuer[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIssuerOfPatientIDFormat", (Object)prev.getIssuerOfPatientIDFormat(), (Object)coercion.getIssuerOfPatientIDFormat(), null);
        return mods;
    }

    private ArchiveAttributeCoercion findAttributeCoercionByCN(Collection<ArchiveAttributeCoercion> coercions, String cn) {
        for (ArchiveAttributeCoercion coercion : coercions) {
            if (!coercion.getCommonName().equals(cn)) continue;
            return coercion;
        }
        return null;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ArchiveAttributeCoercion2 prev, ArchiveAttributeCoercion2 coercion, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)prev.getDescription(), (Object)coercion.getDescription(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRulePriority", (int)prev.getPriority(), (int)coercion.getPriority(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDIMSE", (Object)prev.getDIMSE(), (Object)coercion.getDIMSE(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomTransferRole", (Object)prev.getRole(), (Object)coercion.getRole(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSOPClass", (Object[])prev.getSOPClasses(), (Object[])coercion.getSOPClasses(), (Object[])new String[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmProperty", (Map)prev.getConditions().getMap(), (Map)coercion.getConditions().getMap());
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmURI", (Object)prev.getURI(), (Object)coercion.getURI(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAttributeUpdatePolicy", (Object)prev.getAttributeUpdatePolicy(), (Object)coercion.getAttributeUpdatePolicy(), (Object)Attributes.UpdatePolicy.MERGE);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSupplementFromDeviceReference", (Object)this.deviceNameOf(prev.getOtherDevice()), (Object)this.deviceNameOf(coercion.getOtherDevice()), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmMergeAttribute", (Object[])prev.getMergeAttributes(), (Object[])coercion.getMergeAttributes(), (Object[])new MergeAttribute[0]);
        LdapUtils.storeDiffProperties((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCoercionParam", (Map)prev.getCoercionParams(), (Map)coercion.getCoercionParams());
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCoercionSufficient", (boolean)prev.isCoercionSufficient(), (boolean)coercion.isCoercionSufficient(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmCoercionOnFailure", (Object)prev.getCoercionOnFailure(), (Object)coercion.getCoercionOnFailure(), (Object)ArchiveAttributeCoercion2.OnFailure.RETHROW);
        return mods;
    }

    private ArchiveAttributeCoercion2 findAttributeCoercion2ByCN(Collection<ArchiveAttributeCoercion2> coercions, String cn) {
        for (ArchiveAttributeCoercion2 coercion : coercions) {
            if (!coercion.getCommonName().equals(cn)) continue;
            return coercion;
        }
        return null;
    }

    private void storeRejectNotes(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (RejectionNote rejectionNote : arcDev.getRejectionNotes()) {
            String dn = LdapUtils.dnOf((String)"dcmRejectionNoteLabel", (String)rejectionNote.getRejectionNoteLabel(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, rejectionNote, new BasicAttributes(true)));
        }
    }

    private void storeIDGenerators(ConfigurationChanges diffs, String deviceDN, ArchiveDeviceExtension arcDev) throws NamingException {
        for (IDGenerator generator : arcDev.getIDGenerators().values()) {
            String dn = LdapUtils.dnOf((String)"dcmIDGeneratorName", (String)generator.getName(), (String)deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj, generator, new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, RejectionNote rjNote, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmRejectionNote");
        attrs.put("dcmRejectionNoteLabel", rjNote.getRejectionNoteLabel());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectionNoteType", (Object)rjNote.getRejectionNoteType(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmRejectionNoteCode", (Object)rjNote.getRejectionNoteCode(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptPreviousRejectedInstance", (Object)rjNote.getAcceptPreviousRejectedInstance(), (Object)RejectionNote.AcceptPreviousRejectedInstance.REJECT);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmOverwritePreviousRejection", (Object[])rjNote.getOverwritePreviousRejection(), (Object[])new Code[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAcceptRejectionBeforeStorage", (Object)rjNote.getAcceptRejectionBeforeStorage(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteRejectedInstanceDelay", (Object)rjNote.getDeleteRejectedInstanceDelay(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmDeleteRejectionNoteDelay", (Object)rjNote.getDeleteRejectionNoteDelay(), null);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, IDGenerator generator, BasicAttributes attrs) {
        attrs.put("objectClass", "dcmIDGenerator");
        attrs.put("dcmIDGeneratorName", generator.getName());
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIDGeneratorFormat", (Object)generator.getFormat(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmIDGeneratorInitialValue", (int)generator.getInitialValue(), (int)1);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRejectNotes(ArchiveDeviceExtension arcdev, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmRejectionNote)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                RejectionNote rjNote = new RejectionNote();
                rjNote.setRejectionNoteLabel(LdapUtils.stringValue((Attribute)attrs.get("dcmRejectionNoteLabel"), null));
                rjNote.setRejectionNoteType((RejectionNote.Type)LdapUtils.enumValue(RejectionNote.Type.class, (Attribute)attrs.get("dcmRejectionNoteType"), null));
                rjNote.setRejectionNoteCode(LdapUtils.codeValue((Attribute)attrs.get("dcmRejectionNoteCode")));
                rjNote.setAcceptPreviousRejectedInstance((RejectionNote.AcceptPreviousRejectedInstance)LdapUtils.enumValue(RejectionNote.AcceptPreviousRejectedInstance.class, (Attribute)attrs.get("dcmAcceptPreviousRejectedInstance"), (Enum)RejectionNote.AcceptPreviousRejectedInstance.REJECT));
                rjNote.setOverwritePreviousRejection(LdapUtils.codeArray((Attribute)attrs.get("dcmOverwritePreviousRejection")));
                rjNote.setAcceptRejectionBeforeStorage(LdapArchiveConfiguration.toDuration(attrs.get("dcmAcceptRejectionBeforeStorage"), null));
                rjNote.setDeleteRejectedInstanceDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmDeleteRejectedInstanceDelay"), null));
                rjNote.setDeleteRejectionNoteDelay(LdapArchiveConfiguration.toDuration(attrs.get("dcmDeleteRejectionNoteDelay"), null));
                arcdev.addRejectionNote(rjNote);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIDGenerators(ArchiveDeviceExtension arcdev, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmIDGenerator)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                IDGenerator generator = new IDGenerator();
                generator.setName(LdapUtils.stringValue((Attribute)attrs.get("dcmIDGeneratorName"), null));
                generator.setFormat(LdapUtils.stringValue((Attribute)attrs.get("dcmIDGeneratorFormat"), null));
                generator.setInitialValue(LdapUtils.intValue((Attribute)attrs.get("dcmIDGeneratorInitialValue"), (int)1));
                arcdev.addIDGenerator(generator);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private void mergeRejectNotes(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        String dn;
        String rjNoteID;
        for (RejectionNote entry : prev.getRejectionNotes()) {
            rjNoteID = entry.getRejectionNoteLabel();
            if (arcDev.getRejectionNote(rjNoteID) != null) continue;
            dn = LdapUtils.dnOf((String)"dcmRejectionNoteLabel", (String)rjNoteID, (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (RejectionNote entryNew : arcDev.getRejectionNotes()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            rjNoteID = entryNew.getRejectionNoteLabel();
            dn = LdapUtils.dnOf((String)"dcmRejectionNoteLabel", (String)rjNoteID, (String)deviceDN);
            RejectionNote entryOld = prev.getRejectionNote(rjNoteID);
            if (entryOld == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), entryNew, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, entryOld, entryNew, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeIDGenerators(ConfigurationChanges diffs, ArchiveDeviceExtension prev, ArchiveDeviceExtension arcDev, String deviceDN) throws NamingException {
        for (String name : prev.getIDGenerators().keySet()) {
            if (arcDev.getIDGenerators().containsKey(name)) continue;
            String dn = LdapUtils.dnOf((String)"dcmIDGeneratorName", (String)name, (String)deviceDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (IDGenerator entryNew : arcDev.getIDGenerators().values()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            String name = entryNew.getName();
            String dn = LdapUtils.dnOf((String)"dcmIDGeneratorName", (String)name, (String)deviceDN);
            IDGenerator entryOld = (IDGenerator)prev.getIDGenerators().get(name);
            if (entryOld == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), entryNew, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, entryOld, entryNew, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, RejectionNote prev, RejectionNote rjNote, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectionNoteType", (Object)prev.getRejectionNoteType(), (Object)rjNote.getRejectionNoteType(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmRejectionNoteCode", (Object)prev.getRejectionNoteCode(), (Object)rjNote.getRejectionNoteCode(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptPreviousRejectedInstance", (Object)prev.getAcceptPreviousRejectedInstance(), (Object)rjNote.getAcceptPreviousRejectedInstance(), (Object)RejectionNote.AcceptPreviousRejectedInstance.REJECT);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmOverwritePreviousRejection", (Object[])prev.getOverwritePreviousRejection(), (Object[])rjNote.getOverwritePreviousRejection(), (Object[])new Code[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAcceptRejectionBeforeStorage", (Object)prev.getAcceptRejectionBeforeStorage(), (Object)rjNote.getAcceptRejectionBeforeStorage(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteRejectedInstanceDelay", (Object)prev.getDeleteRejectedInstanceDelay(), (Object)rjNote.getDeleteRejectedInstanceDelay(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmDeleteRejectionNoteDelay", (Object)prev.getDeleteRejectionNoteDelay(), (Object)rjNote.getDeleteRejectionNoteDelay(), null);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, IDGenerator prev, IDGenerator generator, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIDGeneratorFormat", (Object)prev.getFormat(), (Object)generator.getFormat(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIDGeneratorInitialValue", (int)prev.getInitialValue(), (int)generator.getInitialValue(), (int)1);
        return mods;
    }

    private String deviceNameOf(Device device) {
        return device != null ? this.config.deviceRef(device.getDeviceName()) : null;
    }

    private static String scheduledStationDeviceRef(HL7OrderScheduledStation scheduledStation, LdapDicomConfiguration config) {
        Device scheduledStationDevice = scheduledStation.getDevice();
        return scheduledStationDevice != null ? config.deviceRef(scheduledStationDevice.getDeviceName()) : null;
    }
}

