/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.json;

import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import org.dcm4che3.conf.json.JsonConfiguration;
import org.dcm4che3.conf.json.JsonConfigurationExtension;
import org.dcm4che3.conf.json.audit.JsonAuditLoggerConfiguration;
import org.dcm4che3.conf.json.audit.JsonAuditRecordRepositoryConfiguration;
import org.dcm4che3.conf.json.hl7.JsonHL7Configuration;
import org.dcm4che3.conf.json.hl7.JsonHL7ConfigurationExtension;
import org.dcm4che3.conf.json.imageio.JsonImageReaderConfiguration;
import org.dcm4che3.conf.json.imageio.JsonImageWriterConfiguration;
import org.dcm4chee.arc.conf.json.JsonArchiveConfiguration;
import org.dcm4chee.arc.conf.json.JsonArchiveHL7Configuration;
import org.dcm4chee.arc.conf.ui.json.JsonArchiveUIConfiguration;

@ApplicationScoped
public class JsonConfigurationProducer {
    @Produces
    @ApplicationScoped
    private static JsonAuditLoggerConfiguration jsonAuditLoggerConfiguration = new JsonAuditLoggerConfiguration();
    @Produces
    @ApplicationScoped
    private static JsonAuditRecordRepositoryConfiguration jsonAuditRecordRepositoryConfiguration = new JsonAuditRecordRepositoryConfiguration();
    @Produces
    @ApplicationScoped
    private static JsonImageReaderConfiguration jsonImageReaderConfiguration = new JsonImageReaderConfiguration();
    @Produces
    @ApplicationScoped
    private static JsonImageWriterConfiguration jsonImageWriterConfiguration = new JsonImageWriterConfiguration();

    @Produces
    @ApplicationScoped
    private static JsonHL7Configuration newJsonHL7Configuration() {
        JsonHL7Configuration hl7Config = new JsonHL7Configuration();
        hl7Config.addHL7ConfigurationExtension((JsonHL7ConfigurationExtension)new JsonArchiveHL7Configuration());
        return hl7Config;
    }

    public static JsonConfiguration newJsonConfiguration() {
        return JsonConfigurationProducer.newJsonConfiguration(Stream.of(new JsonConfigurationExtension[]{jsonAuditLoggerConfiguration, jsonAuditRecordRepositoryConfiguration, jsonImageReaderConfiguration, jsonImageWriterConfiguration, new JsonArchiveConfiguration(), new JsonArchiveUIConfiguration(), JsonConfigurationProducer.newJsonHL7Configuration()}));
    }

    private static JsonConfiguration newJsonConfiguration(Stream<JsonConfigurationExtension> stream) {
        JsonConfiguration config = new JsonConfiguration();
        stream.forEach(arg_0 -> ((JsonConfiguration)config).addJsonConfigurationExtension(arg_0));
        return config;
    }

    @Produces
    @ApplicationScoped
    public static JsonConfiguration newJsonConfiguration(Instance<JsonConfigurationExtension> configExts) {
        return JsonConfigurationProducer.newJsonConfiguration(configExts.stream());
    }
}

