/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.stream.Stream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;

public class MergeAttribute {
    private static final ElementDictionary dict = ElementDictionary.getStandardElementDictionary();
    final String value;
    final int[] tagPath;
    final int[] itemPath;
    final AttributesFormat format;

    public MergeAttribute(String value) {
        try {
            this.value = value;
            int index = value.indexOf(61);
            String[] names = StringUtils.split((String)value.substring(0, index), (char)'.');
            this.tagPath = new int[names.length];
            this.itemPath = new int[names.length];
            this.parseTagPath(names);
            int beginIndex = index + 1;
            this.format = beginIndex < value.length() ? new AttributesFormat(value.substring(beginIndex)) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(value);
        }
    }

    private void parseTagPath(String[] names) {
        for (int i = 0; i < this.tagPath.length; ++i) {
            String name = names[i];
            int last = name.length() - 1;
            if (name.charAt(last) == ']') {
                int endName = name.indexOf(91);
                this.itemPath[i] = Integer.parseInt(name.substring(endName + 1, last)) - 1;
                name = name.substring(0, endName);
            }
            this.tagPath[i] = TagUtils.forName((String)name);
            if (this.tagPath[i] != -1 && this.itemPath[i] >= 0) continue;
            throw new IllegalArgumentException("tagPath: " + names[i]);
        }
    }

    public String toString() {
        return this.value;
    }

    static MergeAttribute[] of(String ... ss) {
        return (MergeAttribute[])Stream.of(ss).map(MergeAttribute::new).toArray(MergeAttribute[]::new);
    }

    public void merge(Attributes attrs, Attributes modified) {
        int tag = this.tagPath[this.tagPath.length - 1];
        if (this.format != null) {
            Attributes item = this.ensureItem(attrs);
            String oldValue = item.getString(tag);
            String newValue = this.format.format((Object)attrs);
            if (newValue.equals(oldValue)) {
                return;
            }
            if (tag == 524293) {
                item.setSpecificCharacterSet(new String[]{newValue});
                return;
            }
            item.setString(tag, dict.vrOf(tag), newValue);
            if (modified != null && oldValue != null) {
                this.ensureItem(modified).setString(tag, dict.vrOf(tag), oldValue);
            }
        } else {
            Attributes item = this.getItem(attrs);
            if (item != null && item.containsValue(tag)) {
                if (modified != null) {
                    this.ensureItem(modified).addSelected(item, null, tag);
                }
                item.setNull(tag, dict.vrOf(tag));
            }
        }
    }

    private static Attributes ensureItem(Attributes attrs, int tag, int index) {
        Sequence sq = attrs.ensureSequence(tag, index + 1);
        while (sq.size() <= index) {
            sq.add(new Attributes());
        }
        return (Attributes)sq.get(index);
    }

    private Attributes ensureItem(Attributes attrs) {
        Attributes item = attrs;
        int last = this.tagPath.length - 1;
        for (int i = 0; i < last; ++i) {
            item = MergeAttribute.ensureItem(item, this.tagPath[i], this.itemPath[i]);
        }
        return item;
    }

    private Attributes getItem(Attributes attrs) {
        Attributes item = attrs;
        int last = this.tagPath.length - 1;
        for (int i = 0; i < last; ++i) {
            item = item.getNestedDataset(this.tagPath[i]);
        }
        return item;
    }
}

