/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.EntitySelector;
import org.dcm4chee.arc.conf.HL7Conditions;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.NullifyIssuer;
import org.dcm4chee.arc.conf.ScheduleExpression;

public class HL7PrefetchRule {
    public static final HL7PrefetchRule[] EMPTY = new HL7PrefetchRule[0];
    private String commonName;
    private String queueName;
    private String aeTitle;
    private String prefetchCFindSCP;
    private String prefetchCMoveSCP;
    private String[] prefetchCStoreSCPs = new String[0];
    private String destinationCFindSCP;
    private String prefetchDeviceName;
    private HL7Conditions conditions = new HL7Conditions(new String[0]);
    private Duration suppressDuplicateRetrieveInterval;
    private int suppressDuplicateHistorySize = 100;
    private String prefetchDateTimeField;
    private Duration prefetchInAdvance;
    private NullifyIssuer ignoreAssigningAuthorityOfPatientID;
    private Issuer[] assigningAuthorityOfPatientIDs = new Issuer[0];
    private Issuer prefetchForAssigningAuthorityOfPatientID;
    private EntitySelector[] entitySelectors = new EntitySelector[0];
    private ScheduleExpression[] schedules = new ScheduleExpression[0];

    public HL7PrefetchRule() {
    }

    public HL7PrefetchRule(String commonName) {
        this.setCommonName(commonName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public String getPrefetchCFindSCP() {
        return this.prefetchCFindSCP;
    }

    public void setPrefetchCFindSCP(String prefetchCFindSCP) {
        this.prefetchCFindSCP = prefetchCFindSCP;
    }

    public String getPrefetchCMoveSCP() {
        return this.prefetchCMoveSCP;
    }

    public void setPrefetchCMoveSCP(String prefetchCMoveSCP) {
        this.prefetchCMoveSCP = prefetchCMoveSCP;
    }

    public String[] getPrefetchCStoreSCPs() {
        return this.prefetchCStoreSCPs;
    }

    public void setPrefetchCStoreSCPs(String ... prefetchCStoreSCPs) {
        this.prefetchCStoreSCPs = prefetchCStoreSCPs;
    }

    public String getDestinationCFindSCP() {
        return this.destinationCFindSCP;
    }

    public void setDestinationCFindSCP(String destinationCFindSCP) {
        this.destinationCFindSCP = destinationCFindSCP;
    }

    public HL7Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(HL7Conditions conditions) {
        this.conditions = conditions;
    }

    public Duration getSuppressDuplicateRetrieveInterval() {
        return this.suppressDuplicateRetrieveInterval;
    }

    public void setSuppressDuplicateRetrieveInterval(Duration suppressDuplicateRetrieveInterval) {
        this.suppressDuplicateRetrieveInterval = suppressDuplicateRetrieveInterval;
    }

    public int getSuppressDuplicateHistorySize() {
        return this.suppressDuplicateHistorySize;
    }

    public void setSuppressDuplicateHistorySize(int suppressDuplicateHistorySize) {
        this.suppressDuplicateHistorySize = suppressDuplicateHistorySize;
    }

    public String getPrefetchDeviceName() {
        return this.prefetchDeviceName;
    }

    public void setPrefetchDeviceName(String prefetchDeviceName) {
        this.prefetchDeviceName = prefetchDeviceName;
    }

    public NullifyIssuer getIgnoreAssigningAuthorityOfPatientID() {
        return this.ignoreAssigningAuthorityOfPatientID;
    }

    public void setIgnoreAssigningAuthorityOfPatientID(NullifyIssuer ignoreAssigningAuthorityOfPatientID) {
        this.ignoreAssigningAuthorityOfPatientID = ignoreAssigningAuthorityOfPatientID;
    }

    public Issuer[] getAssigningAuthorityOfPatientIDs() {
        return this.assigningAuthorityOfPatientIDs;
    }

    public void setAssigningAuthorityOfPatientIDs(Issuer ... assigningAuthorityOfPatientIDs) {
        this.assigningAuthorityOfPatientIDs = assigningAuthorityOfPatientIDs;
    }

    public IDWithIssuer ignoreAssigningAuthorityOfPatientID(IDWithIssuer pid) {
        return this.ignoreAssigningAuthorityOfPatientID != null && this.ignoreAssigningAuthorityOfPatientID.test(pid.getIssuer(), this.assigningAuthorityOfPatientIDs) ? pid.withoutIssuer() : pid;
    }

    public Issuer getPrefetchForAssigningAuthorityOfPatientID() {
        return this.prefetchForAssigningAuthorityOfPatientID;
    }

    public void setPrefetchForAssigningAuthorityOfPatientID(Issuer prefetchForAssigningAuthorityOfPatientID) {
        this.prefetchForAssigningAuthorityOfPatientID = prefetchForAssigningAuthorityOfPatientID;
    }

    public EntitySelector[] getEntitySelectors() {
        return this.entitySelectors;
    }

    public void setEntitySelectors(EntitySelector[] entitySelectors) {
        this.entitySelectors = entitySelectors;
    }

    public ScheduleExpression[] getSchedules() {
        return this.schedules;
    }

    public void setSchedules(ScheduleExpression ... schedules) {
        this.schedules = schedules;
    }

    public String getPrefetchDateTimeField() {
        return this.prefetchDateTimeField;
    }

    public void setPrefetchDateTimeField(String prefetchDateTimeField) {
        this.prefetchDateTimeField = prefetchDateTimeField;
    }

    public Duration getPrefetchInAdvance() {
        return this.prefetchInAdvance;
    }

    public void setPrefetchInAdvance(Duration prefetchInAdvance) {
        this.prefetchInAdvance = prefetchInAdvance;
    }

    public boolean match(String hostName, HL7Fields hl7Fields) {
        return this.conditions.match(hostName, hl7Fields);
    }

    public String toString() {
        return "HL7PrefetchRule{cn=" + this.commonName + ", queueName=" + this.queueName + ", aeTitle=" + this.aeTitle + ", findSCP=" + this.prefetchCFindSCP + ", moveSCP=" + this.prefetchCMoveSCP + ", storeSCPs=" + Arrays.toString(this.prefetchCStoreSCPs) + ", destFindSCP=" + this.destinationCFindSCP + ", prefetchDeviceName=" + this.prefetchDeviceName + ", conditions=" + this.conditions + ", suppressDups=" + this.suppressDuplicateRetrieveInterval + ", ignoreAssigningAuthorityOfPatientID=" + this.ignoreAssigningAuthorityOfPatientID + ", issuerOfPatientIDs=" + Arrays.toString(this.assigningAuthorityOfPatientIDs) + ", prefetchForAssigningAuthorityOfPatientID=" + this.prefetchForAssigningAuthorityOfPatientID + ", entitySelectors=" + Arrays.toString(this.entitySelectors) + ", schedules=" + Arrays.toString(this.schedules) + ", prefetchDateTimeField=" + this.prefetchDateTimeField + ", prefetchInAdvance=" + this.prefetchInAdvance + "}";
    }
}

