/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.StringUtils;

public class HL7Fields {
    private final UnparsedHL7Message msg;
    private final String defCharset;
    private volatile HL7Message hl7Message;

    public HL7Fields(UnparsedHL7Message msg, String defCharset) {
        this.msg = msg;
        this.defCharset = defCharset;
    }

    public String get(String field, String defVal) {
        HL7Segment seg;
        if (field.length() < 5 || field.charAt(3) != '-') {
            throw new IllegalArgumentException(field);
        }
        String[] ss = StringUtils.split((String)field.substring(4), (char)'.');
        if (ss.length > 3) {
            throw new IllegalArgumentException(field);
        }
        int[] is = new int[ss.length];
        try {
            for (int i = 0; i < ss.length; ++i) {
                is[i] = Integer.parseInt(ss[i]) - 1;
                if (is[i] >= 0) continue;
                throw new IllegalArgumentException(field);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(field);
        }
        if (field.startsWith("MSH")) {
            seg = this.msg.msh();
        } else {
            is[0] = is[0] + 1;
            HL7Message hl7Message = this.hl7Message;
            if (hl7Message == null) {
                this.hl7Message = hl7Message = HL7Message.parse((byte[])this.msg.data(), (String)this.defCharset);
            }
            seg = hl7Message.getSegment(field.substring(0, 3));
        }
        if (seg == null) {
            return defVal;
        }
        String val = seg.getField(is[0], "");
        if (is.length > 1) {
            val = StringUtils.cut((String)val, (int)is[1], (char)seg.getComponentSeparator());
            if (is.length > 2) {
                val = StringUtils.cut((String)val, (int)is[2], (char)seg.getSubcomponentSeparator());
            }
        }
        return val.isEmpty() ? defVal : val;
    }
}

