/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.charset.StandardCharsets;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.ParticipantObjectDescriptionBuilder;
import org.dcm4che3.audit.ParticipantObjectDetail;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentificationBuilder;
import org.dcm4che3.audit.SOPClass;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.InstanceInfo;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.entity.Patient;

class ParticipantObjectID {
    ParticipantObjectID() {
    }

    static ParticipantObjectIdentification patientPOI(AuditInfo auditInfo, SpoolFileReader reader) {
        ParticipantObjectIdentificationBuilder patientPOIBuilder = ParticipantObjectID.patientPOIBuilder(auditInfo).detail(ParticipantObjectID.hl7ParticipantObjectDetail(reader).toArray(new ParticipantObjectDetail[0]));
        String patVerStatus = auditInfo.getField(32);
        if (patVerStatus != null && Patient.VerificationStatus.valueOf((String)patVerStatus) != Patient.VerificationStatus.UNVERIFIED) {
            patientPOIBuilder.lifeCycle("4");
        }
        return patientPOIBuilder.build();
    }

    static ParticipantObjectIdentification patientPOI(SpoolFileReader reader) {
        return ParticipantObjectID.patientPOIBuilder(new AuditInfo(reader.getInstanceLines().get(0))).build();
    }

    static ParticipantObjectIdentificationBuilder patientPOIBuilder(AuditInfo auditInfo) {
        return new ParticipantObjectIdentificationBuilder(auditInfo.getField(6), AuditMessages.ParticipantObjectIDTypeCode.PatientNumber, "1", "1").name(auditInfo.getField(7));
    }

    static List<ParticipantObjectDetail> hl7ParticipantObjectDetail(SpoolFileReader reader) {
        ArrayList<ParticipantObjectDetail> detail = new ArrayList<ParticipantObjectDetail>();
        ParticipantObjectID.hl7ParticipantObjectDetail(detail, reader.getData());
        ParticipantObjectID.hl7ParticipantObjectDetail(detail, reader.getAck());
        return detail;
    }

    private static void hl7ParticipantObjectDetail(List<ParticipantObjectDetail> detail, byte[] data) {
        if (data.length > 0) {
            HL7Segment msh = HL7Segment.parseMSH((byte[])data, (int)data.length, (ParsePosition)new ParsePosition(0));
            String messageType = msh.getMessageType();
            String messageControlID = msh.getMessageControlID();
            detail.add(ParticipantObjectID.hl7ParticipantObjectDetail("HL7v2 Message", data));
            if (messageType != null) {
                detail.add(ParticipantObjectID.hl7ParticipantObjectDetail("MSH-9", messageType.getBytes()));
            }
            if (messageControlID != null) {
                detail.add(ParticipantObjectID.hl7ParticipantObjectDetail("MSH-10", messageControlID.getBytes()));
            }
        }
    }

    private static ParticipantObjectDetail hl7ParticipantObjectDetail(String key, byte[] val) {
        ParticipantObjectDetail detail = new ParticipantObjectDetail();
        detail.setType(key);
        detail.setValue(val);
        return detail;
    }

    private static ParticipantObjectIdentificationBuilder submissionSetPOI(AuditInfo auditInfo) {
        return new ParticipantObjectIdentificationBuilder(auditInfo.getField(20), AuditMessages.ParticipantObjectIDTypeCode.IHE_XDS_METADATA, "2", "20");
    }

    static ParticipantObjectIdentification[] submissionSetParticipants(AuditInfo auditInfo) {
        ParticipantObjectIdentification[] submissionSetParticipants = new ParticipantObjectIdentification[]{ParticipantObjectID.submissionSetPOI(auditInfo).build(), ParticipantObjectID.patientPOIBuilder(auditInfo).build()};
        return submissionSetParticipants;
    }

    static ParticipantObjectIdentification[] studyPatParticipants(AuditInfo auditInfo, List<String> instanceInfoLines, AuditUtils.EventType eventType, AuditLogger auditLogger) {
        ParticipantObjectIdentification[] studyPatParticipants = new ParticipantObjectIdentification[2];
        ParticipantObjectIdentificationBuilder studyPOIBuilder = ParticipantObjectID.studyPOI(auditInfo.getField(4)).detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"StudyDate", (String)auditInfo.getField(9))}).desc(ParticipantObjectID.participantObjDesc(auditInfo, instanceInfoLines, auditInfo.getField(8) != null || auditLogger.isIncludeInstanceUID() != false).build());
        if (eventType.eventClass == AuditUtils.EventClass.STORE_WADOR && !eventType.eventActionCode.equals("R") || eventType.eventClass == AuditUtils.EventClass.IMPAX) {
            studyPOIBuilder.lifeCycle("1");
        }
        studyPatParticipants[0] = studyPOIBuilder.build();
        studyPatParticipants[1] = ParticipantObjectID.patientPOIBuilder(auditInfo).build();
        return studyPatParticipants;
    }

    static ParticipantObjectIdentification[] studyPatParticipants(AuditInfo auditInfo, InstanceInfo instanceInfo) {
        ParticipantObjectIdentification[] studyPatParticipants = new ParticipantObjectIdentification[]{ParticipantObjectID.studyPOI(auditInfo.getField(4)).detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"StudyDate", (String)auditInfo.getField(9))}).desc(ParticipantObjectID.participantObjDesc(instanceInfo, true).build()).lifeCycle("1").build(), ParticipantObjectID.patientPOIBuilder(auditInfo).build()};
        return studyPatParticipants;
    }

    static ParticipantObjectIdentification[] studyPatParticipants(AuditInfo auditInfo, SpoolFileReader reader, AuditLogger auditLogger) {
        InstanceInfo instanceInfo = new InstanceInfo();
        instanceInfo.addAcc(auditInfo);
        instanceInfo.addMpps(auditInfo);
        boolean hasPatient = auditInfo.getField(6) != null;
        ParticipantObjectIdentification[] studyPatParticipants = new ParticipantObjectIdentification[hasPatient ? 2 : 1];
        List<ParticipantObjectDetail> participantObjectDetails = ParticipantObjectID.hl7ParticipantObjectDetail(reader);
        participantObjectDetails.add(AuditMessages.createParticipantObjectDetail((String)"ExpirationDate", (String)auditInfo.getField(36)));
        participantObjectDetails.add(AuditMessages.createParticipantObjectDetail((String)"StudyDate", (String)auditInfo.getField(9)));
        studyPatParticipants[0] = ParticipantObjectID.studyPOI(auditInfo.getField(4)).desc(ParticipantObjectID.participantObjDesc(instanceInfo, auditLogger.isIncludeInstanceUID()).build()).detail(participantObjectDetails.toArray(new ParticipantObjectDetail[0])).build();
        if (hasPatient) {
            studyPatParticipants[1] = ParticipantObjectID.patientPOIBuilder(auditInfo).build();
        }
        return studyPatParticipants;
    }

    static ParticipantObjectIdentification[] studyPatParticipants(SpoolFileReader reader, AuditInfo auditInfo, AuditLogger auditLogger) {
        ParticipantObjectIdentification[] studyPatParticipants = new ParticipantObjectIdentification[2];
        String[] studyUIDs = StringUtils.split((String)auditInfo.getField(4), (char)';');
        studyPatParticipants[0] = ParticipantObjectID.studyPOI(studyUIDs[0]).desc(ParticipantObjectID.participantObjDesc(auditInfo, reader.getInstanceLines(), studyUIDs.length > 1 || auditInfo.getField(8) != null || auditLogger.isIncludeInstanceUID() != false).pocsStudyUIDs(studyUIDs).build()).lifeCycle("4").build();
        studyPatParticipants[1] = ParticipantObjectID.patientPOIBuilder(auditInfo).build();
        return studyPatParticipants;
    }

    static ParticipantObjectIdentificationBuilder studyPOI(String uid) {
        return new ParticipantObjectIdentificationBuilder(uid, AuditMessages.ParticipantObjectIDTypeCode.StudyInstanceUID, "2", "3");
    }

    static ParticipantObjectIdentification studyPOI(String studyUID, InstanceInfo instanceInfo, boolean showIUID) {
        return ParticipantObjectID.studyPOI(studyUID).desc(ParticipantObjectID.participantObjDesc(instanceInfo, showIUID).build()).detail((ParticipantObjectDetail[])instanceInfo.getStudyDate().stream().map(studyDate -> AuditMessages.createParticipantObjectDetail((String)"StudyDate", (String)studyDate)).toArray(ParticipantObjectDetail[]::new)).build();
    }

    private static ParticipantObjectDescriptionBuilder participantObjDesc(AuditInfo auditInfo, List<String> instanceInfoLines, boolean showIUID) {
        InstanceInfo instanceInfo = new InstanceInfo();
        instanceInfo.addAcc(auditInfo);
        instanceInfoLines.forEach(line -> {
            AuditInfo info = new AuditInfo((String)line);
            instanceInfo.addMpps(info);
            instanceInfo.addSOPInstance(info);
        });
        return ParticipantObjectID.participantObjDesc(instanceInfo, showIUID);
    }

    private static ParticipantObjectDescriptionBuilder participantObjDesc(InstanceInfo instanceInfo, boolean showIUID) {
        return new ParticipantObjectDescriptionBuilder().sopC((SOPClass[])instanceInfo.getSopClassMap().entrySet().stream().map(entry -> AuditMessages.createSOPClass((HashSet)(showIUID ? (HashSet)entry.getValue() : null), (String)((String)entry.getKey()), (Integer)((HashSet)entry.getValue()).size())).toArray(SOPClass[]::new)).acc(instanceInfo.getAcc()).mpps(instanceInfo.getMpps());
    }

    static ParticipantObjectIdentification qidoParticipant(AuditInfo auditInfo) {
        ParticipantObjectIdentificationBuilder qidoParticipant = new ParticipantObjectIdentificationBuilder(auditInfo.getField(10), AuditMessages.ParticipantObjectIDTypeCode.QIDO_QUERY, "2", "24").detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"QueryEncoding", (String)StandardCharsets.UTF_8.name())});
        if (auditInfo.getField(11) != null) {
            qidoParticipant.query(auditInfo.getField(11).getBytes());
        }
        return qidoParticipant.build();
    }

    static ParticipantObjectIdentification cFindParticipant(AuditInfo auditInfo, byte[] data) {
        return new ParticipantObjectIdentificationBuilder(auditInfo.getField(10), AuditMessages.ParticipantObjectIDTypeCode.SOPClassUID, "2", "3").query(data).detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"TransferSyntax", (String)"1.2.840.10008.1.2")}).build();
    }

    static ParticipantObjectIdentification taskParticipant(AuditInfo auditInfo) {
        if (auditInfo.getField(27) == null) {
            return ParticipantObjectID.tasksParticipant(auditInfo);
        }
        return new ParticipantObjectIdentificationBuilder(auditInfo.getField(28), AuditMessages.ParticipantObjectIDTypeCode.TASK, "2", null).detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"Task", (String)auditInfo.getField(27))}).build();
    }

    private static ParticipantObjectIdentification tasksParticipant(AuditInfo auditInfo) {
        return new ParticipantObjectIdentificationBuilder(auditInfo.getField(28), AuditMessages.ParticipantObjectIDTypeCode.TASKS, "2", null).detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"Filters", (String)auditInfo.getField(25)), AuditMessages.createParticipantObjectDetail((String)"QueueName", (String)auditInfo.getField(38)), AuditMessages.createParticipantObjectDetail((String)"Count", (String)auditInfo.getField(26)), AuditMessages.createParticipantObjectDetail((String)"Failed", (String)auditInfo.getField(35))}).build();
    }

    static ParticipantObjectIdentification softwareConfParticipant(SpoolFileReader reader, AuditInfo auditInfo) {
        return new ParticipantObjectIdentificationBuilder(auditInfo.getField(2), AuditMessages.ParticipantObjectIDTypeCode.DeviceName, "2", null).detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"Alert Description", !reader.getInstanceLines().isEmpty() ? String.join((CharSequence)"\n", reader.getInstanceLines()) : null)}).build();
    }
}

