/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.delete.StudyDeleteContext;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.event.RejectionNoteSent;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;

class DeletionAuditService {
    DeletionAuditService() {
    }

    static AuditInfoBuilder[] instancesDeletedAuditInfo(StoreContext ctx, ArchiveDeviceExtension arcDev) {
        StoreSession storeSession = ctx.getStoreSession();
        boolean isSchedulerDeletedExpiredStudies = storeSession.getAssociation() == null && storeSession.getHttpRequest() == null;
        ArrayList<AuditInfoBuilder> auditInfoBuilders = new ArrayList<AuditInfoBuilder>();
        auditInfoBuilders.add(isSchedulerDeletedExpiredStudies ? DeletionAuditService.schedulerRejectedAuditInfo(ctx, arcDev) : DeletionAuditService.userRejectedAuditInfo(ctx, arcDev));
        DeletionAuditService.buildRejectionSOPAuditInfo(auditInfoBuilders, ctx.getAttributes());
        return auditInfoBuilders.toArray(new AuditInfoBuilder[0]);
    }

    private static AuditInfoBuilder schedulerRejectedAuditInfo(StoreContext ctx, ArchiveDeviceExtension arcDev) {
        return new AuditInfoBuilder.Builder().callingUserID(arcDev.getDevice().getDeviceName()).studyUIDAccNumDate(ctx.getAttributes(), arcDev).pIDAndName(ctx.getAttributes(), arcDev).outcome(DeletionAuditService.outcome(ctx)).warning(DeletionAuditService.warning(ctx)).build();
    }

    private static AuditInfoBuilder userRejectedAuditInfo(StoreContext ctx, ArchiveDeviceExtension arcDev) {
        StoreSession storeSession = ctx.getStoreSession();
        HttpServletRequestInfo httpServletRequestInfo = storeSession.getHttpRequest();
        String callingAET = storeSession.getCallingAET();
        AuditInfoBuilder.Builder auditInfoBuilder = new AuditInfoBuilder.Builder().callingHost(storeSession.getRemoteHostName()).callingUserID(httpServletRequestInfo != null ? httpServletRequestInfo.requesterUserID : (callingAET != null ? callingAET : storeSession.getLocalApplicationEntity().getAETitle())).calledUserID(httpServletRequestInfo != null ? DeletionAuditService.requestURLWithQueryParams(httpServletRequestInfo) : storeSession.getCalledAET()).outcome(DeletionAuditService.outcome(ctx)).warning(DeletionAuditService.warning(ctx));
        if (ctx.getPreviousInstance() != null) {
            Study prevStudy = ctx.getPreviousInstance().getSeries().getStudy();
            return auditInfoBuilder.studyUIDAccNumDate(prevStudy.getAttributes(), arcDev).pIDAndName(prevStudy.getPatient().getAttributes(), arcDev).build();
        }
        return auditInfoBuilder.studyUIDAccNumDate(ctx.getAttributes(), arcDev).pIDAndName(ctx.getAttributes(), arcDev).build();
    }

    static AuditInfoBuilder[] externalRejectionAuditInfo(RejectionNoteSent rejectionNoteSent, ArchiveDeviceExtension arcDev) {
        Attributes attrs = rejectionNoteSent.getRejectionNote();
        ArrayList<AuditInfoBuilder> auditInfoBuilders = new ArrayList<AuditInfoBuilder>();
        auditInfoBuilders.add(DeletionAuditService.externalRejectionClientAuditInfo(rejectionNoteSent, arcDev));
        DeletionAuditService.buildRejectionSOPAuditInfo(auditInfoBuilders, attrs);
        return auditInfoBuilders.toArray(new AuditInfoBuilder[0]);
    }

    private static AuditInfoBuilder externalRejectionClientAuditInfo(RejectionNoteSent rejectionNoteSent, ArchiveDeviceExtension arcDev) {
        HttpServletRequest req = rejectionNoteSent.getRequest();
        Attributes attrs = rejectionNoteSent.getRejectionNote();
        Attributes codeItem = (Attributes)attrs.getSequence(4235331).get(0);
        return new AuditInfoBuilder.Builder().callingUserID(KeycloakContext.valueOf((HttpServletRequest)req).getUserName()).callingHost(req.getRemoteHost()).calledUserID(req.getRequestURI()).calledHost(!rejectionNoteSent.getRemoteAE().getConnections().isEmpty() ? rejectionNoteSent.getRemoteAE().getConnections().stream().map(Connection::getHostname).collect(Collectors.joining(";")) : null).outcome(rejectionNoteSent.failed() ? rejectionNoteSent.getErrorComment() : null).warning(codeItem.getString(524548)).studyUIDAccNumDate(attrs, arcDev).pIDAndName(attrs, arcDev).build();
    }

    private static void buildRejectionSOPAuditInfo(List<AuditInfoBuilder> auditInfoBuilders, Attributes attrs) {
        if (attrs.getSequence(4236149) == null) {
            auditInfoBuilders.add(new AuditInfoBuilder.Builder().sopCUID(attrs.getString(524310)).sopIUID(attrs.getString(524312)).build());
            return;
        }
        attrs.getSequence(4236149).forEach(studyRef -> studyRef.getSequence(528661).forEach(seriesRef -> seriesRef.getSequence(528793).forEach(sopRef -> auditInfoBuilders.add(new AuditInfoBuilder.Builder().sopCUID(sopRef.getString(528720)).sopIUID(sopRef.getString(528725)).build()))));
    }

    static AuditInfoBuilder[] studyDeletedAuditInfo(StudyDeleteContext ctx, ArchiveDeviceExtension arcDev) {
        HttpServletRequestInfo httpServletRequestInfo = ctx.getHttpServletRequestInfo();
        Study study = ctx.getStudy();
        AuditInfoBuilder.Builder infoBuilder = new AuditInfoBuilder.Builder().studyUIDAccNumDate(study.getAttributes(), arcDev).pIDAndName(study.getPatient().getAttributes(), arcDev).outcome(DeletionAuditService.outcome(ctx.getException()));
        AuditInfoBuilder[] auditInfoBuilders = new AuditInfoBuilder[ctx.getInstances().size() + 1];
        auditInfoBuilders[0] = httpServletRequestInfo != null ? DeletionAuditService.userTriggeredPermDeletionAuditInfo(infoBuilder, httpServletRequestInfo) : DeletionAuditService.schedulerTriggeredPermDeletionAuditInfo(infoBuilder, arcDev);
        DeletionAuditService.buildSOPInstanceAuditInfo(auditInfoBuilders, ctx.getInstances());
        return auditInfoBuilders;
    }

    private static void buildSOPInstanceAuditInfo(AuditInfoBuilder[] auditInfoBuilder, List<Instance> instances) {
        int i = 1;
        for (Instance instance : instances) {
            auditInfoBuilder[i] = new AuditInfoBuilder.Builder().sopCUID(instance.getSopClassUID()).sopIUID(instance.getSopInstanceUID()).build();
            ++i;
        }
    }

    private static AuditInfoBuilder userTriggeredPermDeletionAuditInfo(AuditInfoBuilder.Builder infoBuilder, HttpServletRequestInfo httpServletRequestInfo) {
        return infoBuilder.callingUserID(httpServletRequestInfo.requesterUserID).callingHost(httpServletRequestInfo.requesterHost).calledUserID(DeletionAuditService.requestURLWithQueryParams(httpServletRequestInfo)).build();
    }

    private static String requestURLWithQueryParams(HttpServletRequestInfo httpServletRequestInfo) {
        return httpServletRequestInfo.queryString == null ? httpServletRequestInfo.requestURI : httpServletRequestInfo.requestURI + "?" + httpServletRequestInfo.queryString;
    }

    private static AuditInfoBuilder schedulerTriggeredPermDeletionAuditInfo(AuditInfoBuilder.Builder infoBuilder, ArchiveDeviceExtension arcDev) {
        return infoBuilder.callingUserID(arcDev.getDevice().getDeviceName()).build();
    }

    private static String outcome(StoreContext ctx) {
        return ctx.getException() != null ? (ctx.getRejectionNote() != null ? ctx.getRejectionNote().getRejectionNoteCode().getCodeMeaning() + " - " + ctx.getException().getMessage() : ctx.getException().getMessage()) : null;
    }

    private static String warning(StoreContext ctx) {
        return ctx.getException() == null && ctx.getRejectionNote() != null ? ctx.getRejectionNote().getRejectionNoteCode().getCodeMeaning() : null;
    }

    private static String outcome(Exception e) {
        return e != null ? e.getMessage() : null;
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])DeletionAuditService.activeParticipants(auditLogger, eventType, auditInfo), (ParticipantObjectIdentification[])ParticipantObjectID.studyPatParticipants(auditInfo, reader.getInstanceLines(), eventType, auditLogger));
    }

    private static ActiveParticipant[] activeParticipants(AuditLogger auditLogger, AuditUtils.EventType eventType, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[2];
        String callingUserID = auditInfo.getField(1);
        if (eventType.eventClass == AuditUtils.EventClass.USER_DELETED) {
            String archiveUserID = auditInfo.getField(2);
            AuditMessages.UserIDTypeCode archiveUserIDTypeCode = DeletionAuditService.archiveUserIDTypeCode(archiveUserID);
            activeParticipants[0] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditService.remoteUserIDTypeCode(archiveUserIDTypeCode, callingUserID)).isRequester().build();
            activeParticipants[1] = new ActiveParticipantBuilder(archiveUserID, DeletionAuditService.getLocalHostName(auditLogger)).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).build();
        } else {
            activeParticipants[0] = new ActiveParticipantBuilder(callingUserID, DeletionAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).altUserID(AuditLogger.processID()).isRequester().build();
        }
        return activeParticipants;
    }

    private static AuditMessages.UserIDTypeCode archiveUserIDTypeCode(String userID) {
        return userID.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : AuditMessages.UserIDTypeCode.StationAETitle;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }
}

