/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeSet;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="attribute-set")
@RequestScoped
public class QueryAttributeSets {
    private static final Logger LOG = LoggerFactory.getLogger(QueryAttributeSets.class);
    @Inject
    private Device device;
    @Context
    private HttpServletRequest request;

    @GET
    @NoCache
    @Path(value="/{type}")
    @Produces(value={"application/json"})
    public Response listAttributeSets(@PathParam(value="type") String type) {
        this.logRequest();
        try {
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            AttributeSet.Type attrSetType = AttributeSet.Type.valueOf((String)type);
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                for (AttributeSet attrSet : this.sortedAttributeSets(arcDev.getAttributeSet(attrSetType))) {
                    JsonWriter writer = new JsonWriter(gen);
                    gen.writeStartObject();
                    writer.writeNotNullOrDef("type", (Object)attrSet.getType().name(), null);
                    writer.writeNotNullOrDef("id", (Object)attrSet.getID(), null);
                    writer.writeNotNullOrDef("description", (Object)attrSet.getDescription(), null);
                    writer.writeNotNullOrDef("title", (Object)attrSet.getTitle(), null);
                    attrSet.getProperties().forEach((key, value) -> writer.writeNotNullOrDef(key, value, null));
                    gen.writeEnd();
                }
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException e) {
            return this.errResponse("Attribute Set of type : " + type + " not found.", Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private AttributeSet[] sortedAttributeSets(Map<String, AttributeSet> attrSets) {
        return (AttributeSet[])attrSets.values().stream().filter(AttributeSet::isInstalled).sorted(Comparator.comparing(AttributeSet::getID)).toArray(AttributeSet[]::new);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

