/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCopyOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(StreamCopyOutput.class);
    private final InputStream in;
    private final int length;

    public StreamCopyOutput(InputStream in, int length) {
        this.in = in;
        this.length = length;
    }

    public void write(OutputStream out) throws IOException, WebApplicationException {
        try {
            LOG.debug("Start writing {} bytes", (Object)this.length);
            StreamUtils.copy((InputStream)this.in, (OutputStream)out, (int)(this.length - 1));
            this.skipPaddedByte(out);
            LOG.debug("Finished writing {} bytes", (Object)this.length);
        }
        finally {
            SafeClose.close((Closeable)this.in);
        }
    }

    private void skipPaddedByte(OutputStream out) throws IOException {
        int lastByte = this.in.read();
        if (lastByte != 0) {
            out.write(lastByte);
        }
    }
}

