/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.impl;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.dcmr.ProcedureDiscontinuationReasons;
import org.dcm4che3.dcmr.ScopeOfAccumulation;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.UPSOnStore;
import org.dcm4chee.arc.conf.UPSState;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.GlobalSubscription;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Subscription;
import org.dcm4chee.arc.entity.UPS;
import org.dcm4chee.arc.entity.UPSRequest;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSEvent;
import org.dcm4chee.arc.ups.UPSUtils;
import org.dcm4chee.arc.ups.impl.UPSContextImpl;
import org.dcm4chee.arc.ups.impl.UPSServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Stateless
public class UPSServiceEJB {
    private static final Logger LOG = LoggerFactory.getLogger(UPSServiceEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    EntityManager em;
    @Inject
    private PatientService patientService;
    @Inject
    private CodeCache codeCache;

    public UPS createUPS(UPSContext ctx) {
        ArchiveDeviceExtension arcDev = ctx.getArchiveDeviceExtension();
        Attributes attrs = ctx.getAttributes();
        UPS ups = new UPS();
        ups.setUpsInstanceUID(ctx.getUPSInstanceUID());
        ups.setPatient(this.findOrCreatePatient(ctx));
        ups.setScheduledWorkitemCode(this.findOrCreateCode(attrs, 4210712));
        this.setCodes(ups.getScheduledStationNameCodes(), attrs, 4210725);
        this.setCodes(ups.getScheduledStationClassCodes(), attrs, 4210726);
        this.setCodes(ups.getScheduledStationGeographicLocationCodes(), attrs, 4210727);
        this.setHumanPerformerCodes(ups.getHumanPerformerCodes(), attrs.getSequence(0x404034));
        this.setReferencedRequests(ups.getReferencedRequests(), attrs.getSequence(4236144), arcDev.getFuzzyStr());
        ups.setAttributes(attrs, arcDev.getAttributeFilter(Entity.UPS));
        this.em.persist((Object)ups);
        LOG.info("{}: Create {}", (Object)ctx, (Object)ups);
        for (GlobalSubscription globalSubscription : this.globalSubscriptions(attrs)) {
            this.createSubscription(ctx, ups, globalSubscription.getSubscriberAET(), globalSubscription.isDeletionLock());
        }
        List<String> subcribers = this.subscribersOf(ups);
        if (!subcribers.isEmpty()) {
            ctx.addUPSEvent(UPSEvent.Type.StateReport, ups.getUPSInstanceUID(), UPSServiceEJB.stateReportOf(attrs), subcribers);
            for (Attributes eventInformation : UPSServiceEJB.assigned(attrs, attrs.containsValue(4210725), attrs.containsValue(0x404034))) {
                ctx.addUPSEvent(UPSEvent.Type.Assigned, ups.getUPSInstanceUID(), eventInformation, subcribers);
            }
        }
        return ups;
    }

    private Patient findOrCreatePatient(UPSContext ctx) {
        Patient pat = ctx.getPatient();
        if (pat == null) {
            PatientMgtContext patMgtCtx = ctx.getAssociation() != null ? this.patientService.createPatientMgtContextDIMSE(ctx.getAssociation()) : this.patientService.createPatientMgtContextWEB(ctx.getHttpRequestInfo());
            patMgtCtx.setAttributes(ctx.getAttributes());
            pat = this.patientService.findPatient(patMgtCtx);
            if (pat == null) {
                pat = this.patientService.createPatient(patMgtCtx);
            }
        }
        return pat;
    }

    public UPS updateUPS(UPSContext ctx) throws DicomServiceException {
        boolean progressInformationUpdated;
        boolean requestUpdated;
        boolean performerUpdated;
        boolean stationLocationUpdated;
        boolean stationClassUpdated;
        boolean stationNameUpdated;
        ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        UPS ups = this.findUPS(ctx);
        ctx.setTemplate(this.isTemplateUpdate(ctx, ups));
        String transactionUID = ctx.getAttributes().getString(528789);
        switch (ups.getProcedureStepState()) {
            case SCHEDULED: {
                if (transactionUID == null) break;
                throw new DicomServiceException(49936, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
            }
            case IN_PROGRESS: {
                if (transactionUID == null) {
                    if (ctx.isUPSUpdateWithoutTransactionUID()) break;
                    throw new DicomServiceException(49921, "The Transaction UID is missing.", false);
                }
                if (transactionUID.equals(ups.getTransactionUID())) break;
                throw new DicomServiceException(49921, "The Transaction UID is incorrect.", false);
            }
            case CANCELED: 
            case COMPLETED: {
                throw new DicomServiceException(49920, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
            }
        }
        AttributeFilter filter = arcDev.getAttributeFilter(Entity.UPS);
        Attributes modified = new Attributes();
        Attributes attrs = ups.getAttributes();
        boolean prevWorkitemCode = attrs.containsValue(4210712);
        boolean prevStationName = attrs.containsValue(4210725);
        boolean prevStationClass = attrs.containsValue(4210726);
        boolean prevStationLocation = attrs.containsValue(4210727);
        boolean prevPerformers = attrs.containsValue(0x404034);
        boolean prevRequest = attrs.containsValue(4236144);
        boolean prevProgressInformation = attrs.containsValue(7606274);
        if (!attrs.updateSelected(Attributes.UpdatePolicy.OVERWRITE, ctx.getAttributes(), modified, filter.getSelection())) {
            return ups;
        }
        boolean workitemCodeUpdated = (prevWorkitemCode ? modified : attrs).containsValue(4210712);
        if (workitemCodeUpdated) {
            ups.setScheduledWorkitemCode(this.findOrCreateCode(attrs, 4210712));
        }
        if (stationNameUpdated = (prevStationName ? modified : attrs).containsValue(4210725)) {
            this.setCodes(ups.getScheduledStationNameCodes(), attrs, 4210725);
        }
        if (stationClassUpdated = (prevStationClass ? modified : attrs).containsValue(4210726)) {
            this.setCodes(ups.getScheduledStationClassCodes(), attrs, 4210726);
        }
        if (stationLocationUpdated = (prevStationLocation ? modified : attrs).containsValue(4210727)) {
            this.setCodes(ups.getScheduledStationGeographicLocationCodes(), attrs, 4210727);
        }
        if (performerUpdated = (prevPerformers ? modified : attrs).containsValue(0x404034)) {
            this.setHumanPerformerCodes(ups.getHumanPerformerCodes(), attrs.getSequence(0x404034));
        }
        if (requestUpdated = (prevRequest ? modified : attrs).containsValue(4236144)) {
            this.setReferencedRequests(ups.getReferencedRequests(), attrs.getSequence(4236144), arcDev.getFuzzyStr());
        }
        ups.setAttributes(attrs, filter);
        LOG.info("{}: Update {}", (Object)ctx, (Object)ups);
        List<String> subcribers = this.subscribersOf(ups);
        if (subcribers.isEmpty()) {
            return ups;
        }
        if (modified.contains(0x404041)) {
            ctx.addUPSEvent(UPSEvent.Type.StateReport, ups.getUPSInstanceUID(), UPSServiceEJB.stateReportOf(attrs), subcribers);
        }
        if (progressInformationUpdated = (prevProgressInformation ? modified : attrs).containsValue(7606274)) {
            ctx.addUPSEvent(UPSEvent.Type.ProgressReport, ups.getUPSInstanceUID(), UPSServiceEJB.progressReportOf(attrs), subcribers);
        }
        for (Attributes eventInformation : UPSServiceEJB.assigned(attrs, stationNameUpdated, performerUpdated)) {
            ctx.addUPSEvent(UPSEvent.Type.Assigned, ups.getUPSInstanceUID(), eventInformation, subcribers);
        }
        return ups;
    }

    private boolean isTemplateUpdate(UPSContext ctx, UPS ups) throws DicomServiceException {
        if (!ups.getAttributes().getString(0x404005, "*").equals("*")) {
            return false;
        }
        if (!ctx.getAttributes().containsValue(0x404005)) {
            return true;
        }
        throw new DicomServiceException(262, "UPS Template workitem update shall not contain Scheduled Procedure Step Start DateTime");
    }

    public UPS findUPS(UPSContext ctx) throws DicomServiceException {
        try {
            return this.findUPS(ctx.getUPSInstanceUID());
        }
        catch (NoResultException e) {
            throw new DicomServiceException(49927, "Specified SOP Instance UID does not exist", false);
        }
    }

    public boolean exists(UPSContext ctx) {
        return !this.em.createNamedQuery("UPS.findByIUID").setParameter(1, (Object)ctx.getUPSInstanceUID()).getResultList().isEmpty();
    }

    private UPS findUPS(String upsInstanceUID) {
        return (UPS)this.em.createNamedQuery("UPS.findByIUIDEager", UPS.class).setParameter(1, (Object)upsInstanceUID).getSingleResult();
    }

    private void setReferencedRequests(Collection<UPSRequest> referencedRequests, Sequence seq, FuzzyStr fuzzyStr) {
        referencedRequests.clear();
        if (seq != null) {
            for (Attributes item : seq) {
                referencedRequests.add(new UPSRequest(item, fuzzyStr));
            }
        }
    }

    private CodeEntity findOrCreateCode(Attributes attrs, int seqTag) {
        Attributes item = attrs.getNestedDataset(seqTag);
        if (item != null) {
            try {
                return this.codeCache.findOrCreate(new Code(item));
            }
            catch (Exception e) {
                LOG.info("Illegal code item in Sequence {}:\n{}", (Object)TagUtils.toString((int)seqTag), (Object)item);
            }
        }
        return null;
    }

    private void setCodes(Collection<CodeEntity> codes, Attributes attrs, int seqTag) {
        Sequence seq = attrs.getSequence(seqTag);
        codes.clear();
        if (seq != null) {
            for (Attributes item : seq) {
                try {
                    codes.add(this.codeCache.findOrCreate(new Code(item)));
                }
                catch (Exception e) {
                    LOG.info("Illegal code item in Sequence {}:\n{}", (Object)TagUtils.toString((int)seqTag), (Object)item);
                }
            }
        }
    }

    private void setHumanPerformerCodes(Collection<CodeEntity> codes, Sequence seq) {
        codes.clear();
        if (seq != null) {
            for (Attributes item : seq) {
                try {
                    codes.add(this.codeCache.findOrCreate(new Code(item.getNestedDataset(0x404009))));
                }
                catch (Exception e) {
                    LOG.info("Illegal code item in Human Performer Code Sequence (0040,4009):\n{}", (Object)item);
                }
            }
        }
    }

    public UPS changeUPSState(UPSContext ctx, UPSState upsState, String transactionUID) throws DicomServiceException {
        UPS ups = this.findUPS(ctx);
        Attributes attrs = ups.getAttributes();
        if (ctx.getMergeAttributes() != null) {
            attrs.addAll(ctx.getMergeAttributes());
        }
        switch (upsState) {
            case IN_PROGRESS: {
                switch (ups.getProcedureStepState()) {
                    case IN_PROGRESS: {
                        throw new DicomServiceException(49922, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
                    }
                    case CANCELED: 
                    case COMPLETED: {
                        throw new DicomServiceException(49920, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
                    }
                }
                ups.setTransactionUID(transactionUID);
                ups.setPerformerAET(ctx.getRequesterAET());
                break;
            }
            case CANCELED: {
                switch (ups.getProcedureStepState()) {
                    case SCHEDULED: {
                        throw new DicomServiceException(49936, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
                    }
                    case CANCELED: {
                        ctx.setStatus(45828);
                        return ups;
                    }
                    case COMPLETED: {
                        throw new DicomServiceException(49920, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
                    }
                }
                if (transactionUID != null && !transactionUID.equals(ups.getTransactionUID())) {
                    throw new DicomServiceException(49921, "The Transaction UID is incorrect.", false);
                }
                UPSServiceEJB.supplementDiscontinuationReasonCode(UPSServiceEJB.ensureProgressInformation(attrs));
                ups.setTransactionUID(null);
                break;
            }
            case COMPLETED: {
                switch (ups.getProcedureStepState()) {
                    case SCHEDULED: {
                        throw new DicomServiceException(49936, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
                    }
                    case CANCELED: {
                        throw new DicomServiceException(49920, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
                    }
                    case COMPLETED: {
                        ctx.setStatus(45830);
                        return ups;
                    }
                }
                if (transactionUID != null && !transactionUID.equals(ups.getTransactionUID())) {
                    throw new DicomServiceException(49921, "The Transaction UID is incorrect.", false);
                }
                if (!UPSServiceEJB.meetFinalStateRequirementsOfCompleted(attrs)) {
                    throw new DicomServiceException(49924, "The submitted request is inconsistent with the current state of the UPS Instance.", false);
                }
                ups.setTransactionUID(null);
            }
        }
        attrs.setString(7606272, VR.CS, upsState.toString());
        List<String> subcribers = this.subscribersOf(ups);
        if (!subcribers.isEmpty()) {
            ctx.addUPSEvent(UPSEvent.Type.StateReport, ctx.getUPSInstanceUID(), UPSServiceEJB.stateReportOf(attrs), subcribers);
        }
        ups.setAttributes(attrs, ctx.getArchiveDeviceExtension().getAttributeFilter(Entity.UPS));
        LOG.info("{}: Update {}", (Object)ctx, (Object)ups);
        return ups;
    }

    public UPS requestUPSCancel(UPSContext ctx, UPSServiceImpl upsService) throws DicomServiceException {
        UPS ups = this.findUPS(ctx);
        switch (ups.getProcedureStepState()) {
            case IN_PROGRESS: {
                this.addCancelRequestedEvent(ctx, ups, upsService);
                return ups;
            }
            case CANCELED: {
                ctx.setStatus(45828);
                return ups;
            }
            case COMPLETED: {
                throw new DicomServiceException(49937, "The UPS is already COMPLETED.");
            }
        }
        this.cancelUPS(ctx, ups);
        return ups;
    }

    private void addCancelRequestedEvent(UPSContext ctx, UPS ups, UPSServiceImpl upsService) throws DicomServiceException {
        List<String> subcribers = this.subscribersOf(ups);
        Predicate<String> isUPSEventSCU = arg_0 -> ((ArchiveAEExtension)ctx.getArchiveAEExtension()).isUPSEventSCU(arg_0);
        subcribers.removeIf(isUPSEventSCU.or(upsService::websocketChannelsExists).negate());
        if (!subcribers.contains(ups.getPerformerAET())) {
            throw new DicomServiceException(49938, "The performer cannot be contacted");
        }
        ctx.addUPSEvent(UPSEvent.Type.CancelRequested, ctx.getUPSInstanceUID(), UPSServiceEJB.cancelRequestedBy(ctx), subcribers);
    }

    private void cancelUPS(UPSContext ctx, UPS ups) {
        Attributes attrs = ups.getAttributes();
        Attributes progressInformation = UPSServiceEJB.ensureProgressInformation(attrs);
        progressInformation.addSelected(ctx.getAttributes(), new int[]{7606286, 7606840});
        Attributes communicationsURI = new Attributes(ctx.getAttributes(), new int[]{7606282, 7606284});
        if (!communicationsURI.isEmpty()) {
            progressInformation.ensureSequence(7606280, 1).add(communicationsURI);
        }
        UPSServiceEJB.supplementDiscontinuationReasonCode(progressInformation);
        attrs.setString(7606272, VR.CS, "CANCELED");
        List<String> subcribers = this.subscribersOf(ups);
        if (!subcribers.isEmpty()) {
            ctx.addUPSEvent(UPSEvent.Type.StateReportInProcessAndCanceled, ctx.getUPSInstanceUID(), UPSServiceEJB.stateReportOf(attrs), subcribers);
        }
        ups.setAttributes(attrs, ctx.getArchiveDeviceExtension().getAttributeFilter(Entity.UPS));
        LOG.info("{}: Update {}", (Object)ctx, (Object)ups);
    }

    private static Attributes cancelRequestedBy(UPSContext ctx) {
        Attributes eventInformation = new Attributes(ctx.getAttributes(), new int[]{7606282, 7606284, 7606286, 7606840});
        eventInformation.setString(7606838, VR.AE, ctx.getRequesterAET());
        return eventInformation;
    }

    private static Attributes stateReportOf(Attributes attrs) {
        Attributes item;
        Attributes eventInformation = new Attributes(3);
        eventInformation.setString(0x404041, VR.CS, attrs.getString(0x404041));
        String state = attrs.getString(7606272);
        eventInformation.setString(7606272, VR.CS, state);
        if ("CANCELED".equals(state) && (item = attrs.getNestedDataset(7606274)) != null) {
            Attributes.unifyCharacterSets((Attributes[])new Attributes[]{eventInformation, attrs});
            eventInformation.addSelected(item, new int[]{7606286, 7606840});
        }
        return eventInformation;
    }

    private static Attributes progressReportOf(Attributes attrs) {
        return new Attributes(attrs, new int[]{7606274});
    }

    private static List<Attributes> assigned(Attributes attrs, boolean stationNameUpdated, boolean performerUpdated) {
        if (!performerUpdated) {
            return stationNameUpdated ? Collections.singletonList(new Attributes(attrs, new int[]{4210725})) : Collections.emptyList();
        }
        return attrs.getSequence(0x404034).stream().map(item -> UPSServiceEJB.assignedOf(attrs, stationNameUpdated, item)).collect(Collectors.toList());
    }

    private static Attributes assignedOf(Attributes attrs, boolean stationNameUpdated, Attributes item) {
        Attributes eventInformation = new Attributes(3);
        eventInformation.addSelected(item, new int[]{0x404009, 4210742});
        if (stationNameUpdated) {
            eventInformation.addSelected(attrs, new int[]{4210725});
        }
        return item;
    }

    private List<String> subscribersOf(UPS ups) {
        return this.em.createNamedQuery("Subscription.aetsByUPS", String.class).setParameter(1, (Object)ups).getResultList();
    }

    public List<UPSEvent> statusChangeEvents(ArchiveAEExtension arcAE, Attributes eventInformation) {
        List<UPSEvent> list = this.em.createNamedQuery("Subscription.allIUIDAndAET", Tuple.class).getResultStream().collect(Collectors.groupingBy(tuple -> (String)tuple.get(0, String.class), Collectors.mapping(tuple -> (String)tuple.get(1, String.class), Collectors.toList()))).entrySet().stream().map(entry -> new UPSEvent(arcAE, UPSEvent.Type.StatusChange, (String)entry.getKey(), eventInformation, (List)entry.getValue())).collect(Collectors.toList());
        this.addStatusChangeEvents(list, arcAE, eventInformation, "1.2.840.10008.5.1.4.34.5", "GlobalSubscription.globalAETs");
        this.addStatusChangeEvents(list, arcAE, eventInformation, "1.2.840.10008.5.1.4.34.5.1", "GlobalSubscription.filteredAETs");
        return list;
    }

    private void addStatusChangeEvents(List<UPSEvent> list, ArchiveAEExtension arcAE, Attributes eventInformation, String iuid, String queryName) {
        List subscriberAETs = this.em.createNamedQuery(queryName, String.class).getResultList();
        if (!subscriberAETs.isEmpty()) {
            list.add(new UPSEvent(arcAE, UPSEvent.Type.StatusChange, iuid, eventInformation, subscriberAETs));
        }
    }

    public Subscription createOrUpdateSubscription(UPSContext ctx) throws DicomServiceException {
        Subscription sub;
        UPS ups = this.findUPS(ctx);
        try {
            sub = this.updateSubscription(ctx, ups);
        }
        catch (NoResultException e) {
            sub = this.createSubscription(ctx, ups, ctx.getSubscriberAET(), ctx.isDeletionLock());
        }
        UPSServiceEJB.addInitialEvent(ctx, ups, ctx.getSubscriberAET());
        return sub;
    }

    public int deleteSubscription(UPSContext ctx) {
        if (this.em.createNamedQuery("Subscription.deleteByIUIDAndAET").setParameter(1, (Object)ctx.getUPSInstanceUID()).setParameter(2, (Object)ctx.getSubscriberAET()).executeUpdate() > 0) {
            LOG.info("{}: Delete Subscription[uid={}, aet={}]", new Object[]{ctx, ctx.getUPSInstanceUID(), ctx.getSubscriberAET()});
            return 1;
        }
        return 0;
    }

    public List<GlobalSubscription> findGlobalSubscriptions() {
        return this.em.createNamedQuery("GlobalSubscription.findAllEager", GlobalSubscription.class).getResultList();
    }

    public GlobalSubscription createOrUpdateGlobalSubscription(UPSContext ctx, List<Attributes> notSubscribedUPS) {
        GlobalSubscription sub;
        try {
            sub = this.updateGlobalSubscription(ctx);
        }
        catch (NoResultException e) {
            sub = this.createGlobalSubscription(ctx);
        }
        for (Attributes attrs : notSubscribedUPS) {
            UPS ups = this.findUPS(attrs.getString(524312));
            this.createSubscription(ctx, ups, ctx.getSubscriberAET(), ctx.isDeletionLock());
            if (!ctx.isDeletionLock()) continue;
            UPSServiceEJB.addInitialEvent(ctx, ups, ctx.getSubscriberAET());
        }
        return sub;
    }

    public int suspendGlobalSubscription(UPSContext ctx) {
        try {
            GlobalSubscription sub = (GlobalSubscription)this.em.createNamedQuery("GlobalSubscription.findByAET", GlobalSubscription.class).setParameter(1, (Object)ctx.getSubscriberAET()).getSingleResult();
            this.em.remove((Object)sub);
            LOG.info("{}: Delete {}", (Object)ctx, (Object)sub);
            return 1;
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public int deleteGlobalSubscription(UPSContext ctx) {
        this.suspendGlobalSubscription(ctx);
        int n = this.em.createNamedQuery("Subscription.deleteByAET").setParameter(1, (Object)ctx.getSubscriberAET()).executeUpdate();
        if (n > 0) {
            LOG.info("{}: Delete {} Subscriptions[aet={}]", new Object[]{ctx, n, ctx.getSubscriberAET()});
        }
        return n;
    }

    public boolean purgeUPSWithoutDeletionLock(ArchiveDeviceExtension arcdev) {
        int fetchSize = arcdev.getDeleteUPSFetchSize();
        List<UPS> list = this.findUPSWithoutDeletionLock(arcdev.getDeleteUPSCompletedDelay(), arcdev.getDeleteUPSCanceledDelay(), fetchSize);
        list.forEach(this::deleteUPS);
        return list.size() == fetchSize && arcdev.getDeleteUPSPollingInterval() != null;
    }

    private List<UPS> findUPSWithoutDeletionLock(Duration completedDelay, Duration canceledDelay, int fetchSize) {
        long now = System.currentTimeMillis();
        return this.em.createNamedQuery("UPS.findWithoutDeletionLock", UPS.class).setParameter(1, (Object)UPSState.COMPLETED).setParameter(2, (Object)UPSServiceEJB.before(now, completedDelay)).setParameter(3, (Object)UPSState.CANCELED).setParameter(4, (Object)UPSServiceEJB.before(now, canceledDelay)).setParameter(5, (Object)true).setMaxResults(fetchSize).getResultList();
    }

    private static Date before(long now, Duration delay) {
        return new Date(delay != null ? now - delay.getSeconds() * 1000L : now);
    }

    private void deleteUPS(UPS ups) {
        this.em.createNamedQuery("Subscription.deleteByUPS").setParameter(1, (Object)ups).executeUpdate();
        this.em.remove((Object)ups);
        LOG.info("Delete {}", (Object)ups);
    }

    private Subscription updateSubscription(UPSContext ctx, UPS ups) {
        Subscription sub = (Subscription)this.em.createNamedQuery("Subscription.findByUPSAndAET", Subscription.class).setParameter(1, (Object)ups).setParameter(2, (Object)ctx.getSubscriberAET()).getSingleResult();
        sub.setDeletionLock(ctx.isDeletionLock());
        LOG.info("{}: Update {}", (Object)ctx, (Object)sub);
        return sub;
    }

    private Subscription createSubscription(UPSContext ctx, UPS ups, String subscriberAET, boolean deletionLock) {
        Subscription sub = new Subscription();
        sub.setUPS(ups);
        sub.setSubscriberAET(subscriberAET);
        sub.setDeletionLock(deletionLock);
        this.em.persist((Object)sub);
        LOG.info("{}: Create {}", (Object)ctx, (Object)sub);
        return sub;
    }

    private static void addInitialEvent(UPSContext ctx, UPS ups, String subscriberAET) {
        ctx.addUPSEvent(UPSEvent.Type.StateReport, ups.getUPSInstanceUID(), UPSServiceEJB.stateReportOf(ups.getAttributes()), Collections.singletonList(subscriberAET));
    }

    private GlobalSubscription updateGlobalSubscription(UPSContext ctx) {
        GlobalSubscription sub = (GlobalSubscription)this.em.createNamedQuery("GlobalSubscription.findByAET", GlobalSubscription.class).setParameter(1, (Object)ctx.getSubscriberAET()).getSingleResult();
        sub.setDeletionLock(ctx.isDeletionLock());
        sub.setMatchKeys(ctx.getAttributes());
        LOG.info("{}: Update {}", (Object)ctx, (Object)sub);
        return sub;
    }

    private GlobalSubscription createGlobalSubscription(UPSContext ctx) {
        GlobalSubscription sub = new GlobalSubscription();
        sub.setSubscriberAET(ctx.getSubscriberAET());
        sub.setDeletionLock(ctx.isDeletionLock());
        sub.setMatchKeys(ctx.getAttributes());
        this.em.persist((Object)sub);
        LOG.info("{}: Create {}", (Object)ctx, (Object)sub);
        return sub;
    }

    private static boolean meetFinalStateRequirementsOfCompleted(Attributes attrs) {
        Attributes performedProcedure = attrs.getNestedDataset(7606806);
        if (performedProcedure != null && performedProcedure.containsValue(0x404050) && performedProcedure.containsValue(4210769)) {
            try {
                new Code(performedProcedure.getNestedDataset(4210728));
                new Code(performedProcedure.getNestedDataset(4210713));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static Attributes ensureProgressInformation(Attributes attrs) {
        Sequence sq = attrs.ensureSequence(7606274, 1);
        if (!sq.isEmpty()) {
            return (Attributes)sq.get(0);
        }
        Attributes progressInformation = new Attributes();
        sq.add(progressInformation);
        return progressInformation;
    }

    private static void supplementDiscontinuationReasonCode(Attributes attrs) {
        Attributes reasonCode;
        if (!attrs.containsValue(4210770)) {
            attrs.setDate(4210770, VR.DT, new Date[]{new Date()});
        }
        if ((reasonCode = attrs.getNestedDataset(7606286)) == null || reasonCode.isEmpty()) {
            attrs.newSequence(7606286, 1).add(ProcedureDiscontinuationReasons.DiscontinuedForUnspecifiedReason.toItem());
        }
    }

    public UPSContext createOrUpdateOnStore(StoreContext ctx, Calendar now, UPSOnStore rule) {
        LOG.debug("{}: Apply {}", (Object)ctx.getStoreSession(), (Object)rule);
        String iuid = rule.getInstanceUID(ctx.getAttributes());
        try {
            UPS ups = this.findUPS(iuid);
            UPSOnStore.IncludeInputInformation includeInputInformation = rule.getIncludeInputInformation();
            switch (includeInputInformation) {
                case APPEND: {
                    if (ups.getProcedureStepState() == UPSState.SCHEDULED) break;
                }
                case SINGLE: 
                case NO: {
                    LOG.debug("{}: {} already exists", (Object)ctx.getStoreSession(), (Object)ups);
                    return null;
                }
                default: {
                    while (includeInputInformation == UPSOnStore.IncludeInputInformation.SINGLE_OR_CREATE || ups.getProcedureStepState() != UPSState.SCHEDULED) {
                        iuid = UIDUtils.createNameBasedUID((byte[])iuid.getBytes());
                        ups = this.findUPS(iuid);
                    }
                    break block1;
                }
            }
            LOG.info("{}: update existing {}", (Object)ctx.getStoreSession(), (Object)ups);
            Attributes attrs = ups.getAttributes();
            attrs.setDate(0x404005, VR.DT, new Date[]{UPSUtils.add(now, rule.getStartDateTimeDelay())});
            if (!attrs.contains(4210721)) {
                attrs.setNull(4210721, VR.SQ);
            }
            this.updateIncludeInputInformation(attrs.getSequence(4210721), ctx);
            ups.setAttributes(attrs, ctx.getStoreSession().getArchiveDeviceExtension().getAttributeFilter(Entity.UPS));
            return null;
        }
        catch (NoResultException e) {
            return this.createOnStore(iuid, ctx, now, rule);
        }
    }

    private UPSContext createOnStore(String iuid, StoreContext storeCtx, Calendar now, UPSOnStore rule) {
        UPSContextImpl ctx = new UPSContextImpl(storeCtx, rule);
        ctx.setUPSInstanceUID(iuid);
        ctx.setAttributes(this.createOnStore(storeCtx, now, rule));
        this.createUPS(ctx);
        return ctx;
    }

    private Attributes createOnStore(StoreContext storeCtx, Calendar now, UPSOnStore rule) {
        Attributes attrs = this.applyXSLT(rule, storeCtx);
        if (rule.isIncludeStudyInstanceUID() && !attrs.contains(0x20000D)) {
            attrs.setString(0x20000D, VR.UI, storeCtx.getStudyInstanceUID());
        }
        if (!attrs.contains(3670032)) {
            attrs.setString(3670032, VR.LO, rule.getAdmissionID(storeCtx.getAttributes()));
            UPSUtils.setIssuer(attrs, 3670033, rule.getIssuerOfAdmissionID());
        }
        if (!attrs.contains(0x404005)) {
            attrs.setDate(0x404005, VR.DT, new Date[]{UPSUtils.add(now, rule.getStartDateTimeDelay())});
        }
        if (rule.getCompletionDateTimeDelay() != null && !attrs.contains(0x404011)) {
            attrs.setDate(0x404011, VR.DT, new Date[]{UPSUtils.add(now, rule.getCompletionDateTimeDelay())});
        }
        if (rule.getScheduledHumanPerformers().length > 0 && !attrs.contains(0x404034)) {
            UPSUtils.setScheduledHumanPerformerItems(attrs, rule.getScheduledHumanPerformers(), rule.getScheduledHumanPerformerName(attrs), rule.getScheduledHumanPerformerOrganization(attrs));
        }
        if (!attrs.contains(4210712)) {
            UPSUtils.setCode(attrs, 4210712, rule.getScheduledWorkitemCode());
        }
        if (!attrs.contains(4210725)) {
            UPSUtils.setCodes(attrs, 4210725, rule.getScheduledStationNames());
        }
        if (!attrs.contains(4210726)) {
            UPSUtils.setCodes(attrs, 4210726, rule.getScheduledStationClasses());
        }
        if (!attrs.contains(4210727)) {
            UPSUtils.setCodes(attrs, 4210727, rule.getScheduledStationLocations());
        }
        if (!attrs.contains(0x404041)) {
            attrs.setString(0x404041, VR.CS, rule.getInputReadinessState().toString());
        }
        if (!attrs.contains(4236144)) {
            if (rule.isIncludeReferencedRequest()) {
                attrs.newSequence(4236144, 1).add(this.referencedRequest(storeCtx, rule));
            } else {
                attrs.setNull(4236144, VR.SQ);
            }
        }
        if (rule.getDestinationAE() != null && !attrs.contains(0x404070)) {
            attrs.newSequence(0x404070, 1).add(UPSUtils.outputStorage(rule.getDestinationAE()));
        }
        attrs.setString(7606272, VR.CS, "SCHEDULED");
        if (!attrs.contains(7606784)) {
            attrs.setString(7606784, VR.CS, rule.getUPSPriority().toString());
        }
        if (!attrs.contains(7606786)) {
            attrs.setString(7606786, VR.LO, UPSServiceEJB.worklistLabel(storeCtx, rule));
        }
        if (!attrs.contains(7606788)) {
            attrs.setString(7606788, VR.LO, rule.getProcedureStepLabel(storeCtx.getAttributes()));
        }
        if (rule.getIncludeInputInformation() != UPSOnStore.IncludeInputInformation.NO && !attrs.contains(4210721)) {
            this.updateIncludeInputInformation(attrs.newSequence(4210721, 1), storeCtx);
        }
        UPSUtils.addScheduledProcessingParameter(attrs, ScopeOfAccumulation.CODE, rule.getScopeOfAccumulation());
        return attrs;
    }

    private Attributes referencedRequest(StoreContext storeCtx, UPSOnStore rule) {
        Attributes item = new Attributes(8);
        item.setString(524368, VR.SH, rule.getAccessionNumber(storeCtx.getAttributes()));
        UPSUtils.setIssuer(item, 524369, rule.getIssuerOfAccessionNumber());
        item.setString(0x20000D, VR.UI, storeCtx.getStudyInstanceUID());
        UPSServiceEJB.setNotNull(item, 3280946, VR.PN, rule.getRequestingPhysician(storeCtx.getAttributes()));
        UPSServiceEJB.setNotNull(item, 3280947, VR.LO, rule.getRequestingService(storeCtx.getAttributes()));
        item.setString(3280992, VR.LO, rule.getRequestedProcedureDescription(storeCtx.getAttributes()));
        item.setNull(3280996, VR.SQ);
        item.setString(0x401001, VR.SH, rule.getRequestedProcedureID(storeCtx.getAttributes()));
        return item;
    }

    private static void setNotNull(Attributes item, int tag, VR vr, String value) {
        if (value != null) {
            item.setString(tag, vr, value);
        }
    }

    private static String worklistLabel(StoreContext storeCtx, UPSOnStore rule) {
        String worklistLabel = rule.getWorklistLabel(storeCtx.getAttributes());
        return worklistLabel != null ? worklistLabel : storeCtx.getStoreSession().getArchiveAEExtension().upsWorklistLabel();
    }

    private Attributes applyXSLT(UPSOnStore upsOnStore, StoreContext ctx) {
        String uri = upsOnStore.getXSLTStylesheetURI();
        if (uri != null) {
            try {
                return SAXTransformer.transform((Attributes)ctx.getAttributes(), (Templates)TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)uri)), (boolean)false, (!upsOnStore.isNoKeywords() ? 1 : 0) != 0, (SAXTransformer.SetupTransformer)UPSServiceEJB.setupTransformer(ctx.getStoreSession()));
            }
            catch (SAXException e) {
                LOG.warn("{}: Failed to apply XSL: {}", new Object[]{ctx.getStoreSession(), uri, e});
            }
            catch (TransformerConfigurationException e) {
                LOG.warn("{}: Failed to compile XSL: {}", new Object[]{ctx.getStoreSession(), uri, e});
            }
        }
        return new Attributes();
    }

    private static SAXTransformer.SetupTransformer setupTransformer(StoreSession session) {
        return t -> {
            t.setParameter("LocalAET", session.getCalledAET());
            if (session.getCallingAET() != null) {
                t.setParameter("RemoteAET", session.getCallingAET());
            }
            if (session.getRemoteHostName() != null) {
                t.setParameter("RemoteHost", session.getRemoteHostName());
            }
        };
    }

    private List<GlobalSubscription> globalSubscriptions(Attributes attrs) {
        return this.findGlobalSubscriptions().stream().filter(sub -> this.matches(attrs, sub.getMatchKeys())).collect(Collectors.toList());
    }

    private boolean matches(Attributes attrs, Attributes keys) {
        return keys == null || attrs.matches(keys, false, false);
    }

    private void updateIncludeInputInformation(Sequence sq, StoreContext ctx) {
        this.refSOPSequence(sq, ctx).add(UPSServiceEJB.toSOPRef(ctx));
    }

    private static Attributes toSOPRef(StoreContext ctx) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, ctx.getSopClassUID());
        item.setString(528725, VR.UI, ctx.getSopInstanceUID());
        return item;
    }

    private Sequence refSOPSequence(Sequence sq, StoreContext ctx) {
        for (Attributes item : sq) {
            if (!ctx.getStudyInstanceUID().equals(item.getString(0x20000D)) || !ctx.getSeriesInstanceUID().equals(item.getString(0x20000E))) continue;
            return item.getSequence(528793);
        }
        Attributes item = new Attributes(5);
        sq.add(item);
        Sequence refSOPSequence = item.newSequence(528793, 10);
        item.setString(0x20000D, VR.UI, ctx.getStudyInstanceUID());
        item.setString(0x20000E, VR.UI, ctx.getSeriesInstanceUID());
        item.setString(4251680, VR.CS, "DICOM");
        item.newSequence(4251681, 1).add(this.retrieveAETItem(ctx));
        return refSOPSequence;
    }

    private Attributes retrieveAETItem(StoreContext ctx) {
        Attributes item = new Attributes(1);
        item.setString(524372, VR.AE, ctx.getRetrieveAETs());
        return item;
    }
}

